/******************************************************************************

                          Copyright (c) 2007-2015
                     Lantiq Beteiligungs-GmbH & Co. KG

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

#define DSL_INTERN

#include "drv_dsl_cpe_api.h"
#include "drv_dsl_cpe_api_ioctl.h"
#include "drv_dsl_cpe_debug.h"

#ifdef __cplusplus
   extern "C" {
#endif

#ifndef DSL_DEBUG_DISABLE

/** \file
   Debug support
*/

/** \addtogroup DRV_DSL_CPE_DEBUG
 @{ */

/*
 * Two global variables to store local and global debug levels.
 */

/* Default initialization for all debug blocks */
DSL_debugLevelEntry_t DSL_g_dbgLvl[DSL_DBG_MAX_ENTRIES] =
{
   { DSL_DBG_NONE,   "DSL_DBG_NO_BLOCK"            },   /* 00 */
   { DSL_DBG_MSG,    "DSL_DBG_CPE_API"             },   /* 01 */
   { DSL_DBG_ERR,    "DSL_DBG_G997"                },   /* 02 */
   { DSL_DBG_ERR,    "DSL_DBG_PM"                  },   /* 03 */
   { DSL_DBG_ERR,    "DSL_DBG_MIB"                 },   /* 04 */
   { DSL_DBG_ERR,    "DSL_DBG_CEOC"                },   /* 05 */
   { DSL_DBG_MSG,    "DSL_DBG_LED"                 },   /* 06 */
   { DSL_DBG_ERR,    "DSL_DBG_SAR"                 },   /* 07 */
   { DSL_DBG_MSG,    "DSL_DBG_DEVICE"              },   /* 08 */
   { DSL_DBG_MSG,    "DSL_DBG_AUTOBOOT_THREAD"     },   /* 09 */
   { DSL_DBG_MSG,    "DSL_DBG_OS"                  },   /* 10 */
   { DSL_DBG_ERR,    "DSL_DBG_CALLBACK"            },   /* 11 */
   { DSL_DBG_NONE,   "DSL_DBG_MESSAGE_DUMP"        },   /* 12 */
   { DSL_DBG_ERR,    "DSL_DBG_LOW_LEVEL_DRIVER"    },   /* 13 */
   { DSL_DBG_NONE,   "DSL_DBG_MULTIMODE"           },   /* 14 */
   { DSL_DBG_NONE,   "DSL_DBG_NOTIFICATIONS"       },   /* 15 */
   { DSL_DBG_NONE,   "not used"                    },   /* 16 */
};

/* Initialization for all debug levels */
DSL_debugLevelEntry_t DSL_g_dbgLvlNames[] =
{
   { DSL_DBG_NONE,   "DSL_DBG_NONE"    },
   { DSL_DBG_PRN,    "DSL_DBG_PRN"     },
   { DSL_DBG_ERR,    "DSL_DBG_ERR"     },
   { DSL_DBG_WRN,    "DSL_DBG_WRN"     },
   { DSL_DBG_MSG,    "DSL_DBG_MSG"     },
   { DSL_DBG_LOCAL,  "DSL_DBG_LOCAL"   },
};

#ifdef INCLUDE_DSL_CPE_DEBUG_LOGGER_SUPPORT
/* Initialization for debug destination */
DSL_debugDestinations_t DSL_g_dbgDestination = DSL_DBG_DST_CONSOLE;
#endif /* INCLUDE_DSL_CPE_DEBUG_LOGGER_SUPPORT */

/**
   Definition of strings that reflects the direction.
   This array should be used with index +1 */
const DSL_char_t* DSL_DBG_PRN_DIR[] = { "NA", "US", "DS" };

/**
   Definition of strings that reflects the autoboot status.
   This array includes debug information that will be used to display the states
   that are defined within \ref DSL_AutobootStatGet_t enum as plain text */
const DSL_char_t* DSL_DBG_PRN_AUTOBOOT_STATUS[] =
{
   "Stopped",
   "Starting",
   "Running",
   "FwWait",
   "ConfigWriteWait",
   "LinkActivateWait",
   "RestartWait"
};

/**
   Definition of strings that reflects the autoboot state.
   This array includes debug information that will be used to display the states
   that are defined within \ref DSL_AutobootStatGet_t enum as plain text */
const DSL_char_t* DSL_DBG_PRN_AUTOBOOT_STATE[] =
{
   "Unknown",
   "FirmwareRequest",
   "FirmwareWait",
   "firmwareReady",
   "L3",
   "Init",
   "Train",
   "Showtime",
   "Exception",
   "Diagnostic",
   "Restart",
   "ConfigWriteWait",
   "LinkActivateWait",
   "RestartWait",
   "ShutDownRequest",
   "ShutDownWait",
   "ShutDownReached"
};


const DSL_uint8_t DSL_g_dbgLvlNumber = sizeof(DSL_g_dbgLvlNames) / sizeof(DSL_debugLevelEntry_t);

DSL_debugLevels_t DSL_g_globalDbgLvl = DSL_DBG_LOCAL;
DSL_uint16_t DSL_g_dbgStartLine = 0;
DSL_uint16_t DSL_g_dbgStopLine = DSL_MAX_LINE_NUMBER;

/* Array of line debug levels */
DSL_debugLevels_t DSL_g_dbgLineLvl[DSL_MAX_LINE_NUMBER];

DSL_char_t* DSL_DBG_IoctlName(DSL_uint_t nIoctlCode)
{
   switch (nIoctlCode)
   {
   case DSL_FIO_INIT:
      return "DSL_FIO_INIT";
   case DSL_FIO_AUTOBOOT_LOAD_FIRMWARE:
      return "DSL_FIO_AUTOBOOT_LOAD_FIRMWARE";
   case DSL_FIO_AUTOBOOT_CONTROL_SET:
      return "DSL_FIO_AUTOBOOT_CONTROL_SET";
   case DSL_FIO_AUTOBOOT_STATUS_GET:
      return "DSL_FIO_AUTOBOOT_STATUS_GET";
   case DSL_FIO_VERSION_INFORMATION_GET:
      return "DSL_FIO_VERSION_INFORMATION_GET";
   case DSL_FIO_LINE_STATE_GET:
      return "DSL_FIO_LINE_STATE_GET";
   case DSL_FIO_LINE_FEATURE_CONFIG_SET:
      return "DSL_FIO_LINE_FEATURE_CONFIG_SET";
   case DSL_FIO_LINE_FEATURE_CONFIG_GET:
      return "DSL_FIO_LINE_FEATURE_CONFIG_GET";
   case DSL_FIO_LINE_FEATURE_STATUS_GET:
      return "DSL_FIO_LINE_FEATURE_STATUS_GET";
   case DSL_FIO_FRAMING_PARAMETER_STATUS_GET:
      return "DSL_FIO_FRAMING_PARAMETER_STATUS_GET";
   case DSL_FIO_DBG_MODULE_LEVEL_SET:
      return "DSL_FIO_DBG_MODULE_LEVEL_SET";
   case DSL_FIO_DBG_MODULE_LEVEL_GET:
      return "DSL_FIO_DBG_MODULE_LEVEL_GET";
   case DSL_FIO_DBG_DEVICE_MESSAGE_SEND:
      return "DSL_FIO_DBG_DEVICE_MESSAGE_SEND";
   case DSL_FIO_DBG_DEVICE_MESSAGE_MODIFY_SEND:
      return "DSL_FIO_DBG_DEVICE_MESSAGE_MODIFY_SEND";
   case DSL_FIO_TEST_MODE_CONTROL_SET:
      return "DSL_FIO_TEST_MODE_CONTROL_SET";
   case DSL_FIO_AUX_LINE_INVENTORY_GET:
      return "DSL_FIO_AUX_LINE_INVENTORY_GET";
   case DSL_FIO_LOOP_LENGTH_STATUS_GET:
      return "DSL_FIO_LOOP_LENGTH_STATUS_GET";
   case DSL_FIO_SYSTEM_INTERFACE_CONFIG_SET:
      return "DSL_FIO_SYSTEM_INTERFACE_CONFIG_SET";
   case DSL_FIO_SYSTEM_INTERFACE_CONFIG_GET:
      return "DSL_FIO_SYSTEM_INTERFACE_CONFIG_GET";
   case DSL_FIO_BAND_PLAN_STATUS_GET:
      return "DSL_FIO_BAND_PLAN_STATUS_GET";
   case DSL_FIO_BAND_PLAN_SUPPORT_GET:
      return "DSL_FIO_BAND_PLAN_SUPPORT_GET";
#ifdef INCLUDE_DSL_CPE_TRACE_BUFFER
   case DSL_FIO_SHOWTIME_LOGGING_DATA_GET:
      return "DSL_FIO_SHOWTIME_LOGGING_DATA_GET";
#endif
   case DSL_FIO_EVENT_STATUS_MASK_CONFIG_SET:
      return "DSL_FIO_EVENT_STATUS_MASK_CONFIG_SET";
   case DSL_FIO_EVENT_STATUS_MASK_CONFIG_GET:
      return "DSL_FIO_EVENT_STATUS_MASK_CONFIG_GET";
   case DSL_FIO_LOW_LEVEL_CONFIGURATION_GET:
      return "DSL_FIO_LOW_LEVEL_CONFIGURATION_GET";
   case DSL_FIO_LOW_LEVEL_CONFIGURATION_SET:
      return "DSL_FIO_LOW_LEVEL_CONFIGURATION_SET";
   case DSL_FIO_TEST_MODE_STATUS_GET:
      return "DSL_FIO_TEST_MODE_STATUS_GET";
   case DSL_FIO_SYSTEM_INTERFACE_STATUS_GET:
      return "DSL_FIO_SYSTEM_INTERFACE_STATUS_GET";
   case DSL_FIO_EVENT_STATUS_GET:
      return "DSL_FIO_EVENT_STATUS_GET";
   case DSL_FIO_INSTANCE_CONTROL_SET:
      return "DSL_FIO_INSTANCE_CONTROL_SET";
   case DSL_FIO_INSTANCE_STATUS_GET:
      return "DSL_FIO_INSTANCE_STATUS_GET";
   case DSL_FIO_AUTOBOOT_CONFIG_GET:
      return "DSL_FIO_AUTOBOOT_CONFIG_GET";
   case DSL_FIO_AUTOBOOT_CONFIG_SET:
      return "DSL_FIO_AUTOBOOT_CONFIG_SET";
   case DSL_FIO_INTEROP_FEATURE_CONFIG_GET:
      return "DSL_FIO_INTEROP_FEATURE_CONFIG_GET";
   case DSL_FIO_INTEROP_FEATURE_CONFIG_SET:
      return "DSL_FIO_INTEROP_FEATURE_CONFIG_SET";
   case DSL_FIO_RESOURCE_USAGE_STATISTICS_GET:
      return "DSL_FIO_RESOURCE_USAGE_STATISTICS_GET";
   case DSL_FIO_MISC_LINE_STATUS_GET:
      return "DSL_FIO_MISC_LINE_STATUS_GET";
   case DSL_FIO_BAND_BORDER_STATUS_GET:
      return "DSL_FIO_BAND_BORDER_STATUS_GET";
   case DSL_FIO_LINE_OPTIONS_CONFIG_SET:
      return "DSL_FIO_LINE_OPTIONS_CONFIG_SET";
   case DSL_FIO_LINE_OPTIONS_CONFIG_GET:
      return "DSL_FIO_LINE_OPTIONS_CONFIG_GET";
#ifdef INCLUDE_DEVICE_EXCEPTION_CODES
   case DSL_FIO_LAST_EXCEPTION_CODES_GET:
      return "DSL_FIO_LAST_EXCEPTION_CODES_GET";
#endif /* INCLUDE_DEVICE_EXCEPTION_CODES*/
#ifndef DSL_DEBUG_DISABLE
#ifdef INCLUDE_DSL_CPE_API_DANUBE
   case DSL_FIO_DBG_DEBUG_FEATURE_CONFIG_SET:
      return "DSL_FIO_DBG_DEBUG_FEATURE_CONFIG_SET";
   case DSL_FIO_DBG_DEBUG_FEATURE_CONFIG_GET:
      return "DSL_FIO_DBG_DEBUG_FEATURE_CONFIG_GET";
#endif /* INCLUDE_DSL_CPE_API_DANUBE*/
#endif /* DSL_DEBUG_DISABLE*/
   case DSL_FIO_PILOT_TONES_STATUS_GET:
      return "DSL_FIO_PILOT_TONES_STATUS_GET";
   case DSL_FIO_REBOOT_CRITERIA_CONFIG_SET:
      return "DSL_FIO_REBOOT_CRITERIA_CONFIG_SET";
   case DSL_FIO_REBOOT_CRITERIA_CONFIG_GET:
      return "DSL_FIO_REBOOT_CRITERIA_CONFIG_GET";
#ifdef INCLUDE_DSL_CPE_PM_RETX_COUNTERS
#ifdef INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS
   case DSL_FIO_RETX_STATISTICS_GET:
      return "DSL_FIO_RETX_STATISTICS_GET";
#endif /* INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS */
#endif /* INCLUDE_DSL_CPE_PM_RETX_COUNTERS */
#ifdef INCLUDE_DSL_FILTER_DETECTION
   case DSL_FIO_FILTER_DETECTION_DATA_GET:
      return "DSL_FIO_FILTER_DETECTION_DATA_GET";
#endif /* INCLUDE_DSL_FILTER_DETECTION */
   case DSL_FIO_HYBRID_SELECTION_DATA_GET:
      return "DSL_FIO_HYBRID_SELECTION_DATA_GET";
   case DSL_FIO_OLR_STATISTICS_GET:
      return "DSL_FIO_OLR_STATISTICS_GET";
   case DSL_FIO_DELT_SNR_GET:
      return "DSL_FIO_DELT_SNR_GET";
   case DSL_FIO_FIRMWARE_DOWNLOAD_STATUS_GET:
      return "DSL_FIO_FIRMWARE_DOWNLOAD_STATUS_GET";
   case DSL_FIO_VDSL_PROFILE_CONFIG_SET:
      return "DSL_FIO_VDSL_PROFILE_CONFIG_SET";
   case DSL_FIO_VDSL_PROFILE_CONFIG_GET:
      return "DSL_FIO_VDSL_PROFILE_CONFIG_GET";
#ifdef INCLUDE_DSL_BONDING
   case DSL_FIO_BND_HW_INIT:
      return "DSL_FIO_BND_HW_INIT";
   case DSL_FIO_BND_CONFIG_SET:
      return "DSL_FIO_BND_CONFIG_SET";
   case DSL_FIO_BND_CONFIG_GET:
      return "DSL_FIO_BND_CONFIG_GET";
   case DSL_FIO_BND_HS_STATUS_GET:
      return "DSL_FIO_BND_HS_STATUS_GET";
   case DSL_FIO_BND_HS_CONTINUE:
      return "DSL_FIO_BND_HS_CONTINUE";
   case DSL_FIO_BND_ETH_DBG_COUNTERS_GET:
      return "DSL_FIO_BND_ETH_DBG_COUNTERS_GET";
   case DSL_FIO_BND_ETH_COUNTERS_GET:
      return "DSL_FIO_BND_ETH_COUNTERS_GET";
   case DSL_FIO_BND_PORT_MODE_SYNC_SET:
      return "DSL_FIO_BND_PORT_MODE_SYNC_SET";
#endif /* INCLUDE_DSL_BONDING */

   case DSL_FIO_G997_LINE_ACTIVATE_CONFIG_SET:
      return "DSL_FIO_G997_LINE_ACTIVATE_CONFIG_SET";
   case DSL_FIO_G997_LINE_ACTIVATE_CONFIG_GET:
      return "DSL_FIO_G997_LINE_ACTIVATE_CONFIG_GET";
   case DSL_FIO_G997_XTU_SYSTEM_ENABLING_CONFIG_SET:
      return "DSL_FIO_G997_XTU_SYSTEM_ENABLING_CONFIG_SET";
   case DSL_FIO_G997_XTU_SYSTEM_ENABLING_CONFIG_GET:
      return "DSL_FIO_G997_XTU_SYSTEM_ENABLING_CONFIG_GET";
   case DSL_FIO_G997_XTU_SYSTEM_ENABLING_STATUS_GET:
      return "DSL_FIO_G997_XTU_SYSTEM_ENABLING_STATUS_GET";
   case DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_SET:
      return "DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_SET";
   case DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_GET:
      return "DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_GET";
   case DSL_FIO_G997_LINE_TRANSMISSION_STATUS_GET:
      return "DSL_FIO_G997_LINE_TRANSMISSION_STATUS_GET";
   case DSL_FIO_G997_LINE_INIT_STATUS_GET:
      return "DSL_FIO_G997_LINE_INIT_STATUS_GET";
   case DSL_FIO_G997_LINE_STATUS_GET:
      return "DSL_FIO_G997_LINE_STATUS_GET";
#if (INCLUDE_DSL_CPE_API_VDSL_SUPPORT == 1)
   case DSL_FIO_G997_LINE_STATUS_PER_BAND_GET:
      return "DSL_FIO_G997_LINE_STATUS_PER_BAND_GET";
#endif
   case DSL_FIO_G997_CHANNEL_STATUS_GET:
      return "DSL_FIO_G997_CHANNEL_STATUS_GET";
   case DSL_FIO_G997_POWER_MANAGEMENT_STATE_FORCED_TRIGGER:
      return "DSL_FIO_G997_POWER_MANAGEMENT_STATE_FORCED_TRIGGER";
   case DSL_FIO_G997_POWER_MANAGEMENT_STATUS_GET:
      return "DSL_FIO_G997_POWER_MANAGEMENT_STATUS_GET";
   case DSL_FIO_G997_LAST_STATE_TRANSMITTED_GET:
      return "DSL_FIO_G997_LAST_STATE_TRANSMITTED_GET";
   case DSL_FIO_G997_BIT_ALLOCATION_NSC_GET:
      return "DSL_FIO_G997_BIT_ALLOCATION_NSC_GET";
   case DSL_FIO_G997_GAIN_ALLOCATION_NSC_GET:
      return "DSL_FIO_G997_GAIN_ALLOCATION_NSC_GET";
   case DSL_FIO_G997_SNR_ALLOCATION_NSC_GET:
      return "DSL_FIO_G997_SNR_ALLOCATION_NSC_GET";
   case DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_SET:
      return "DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_SET";
   case DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_GET:
      return "DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_GET";
   case DSL_FIO_G997_LINE_FAILURES_STATUS_GET:
      return "DSL_FIO_G997_LINE_FAILURES_STATUS_GET";
   case DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_SET:
      return "DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_SET";
   case DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_GET:
      return "DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_GET";
   case DSL_FIO_G997_DATA_PATH_FAILURES_STATUS_GET:
      return "DSL_FIO_G997_DATA_PATH_FAILURES_STATUS_GET";
   case DSL_FIO_G997_FRAMING_PARAMETER_STATUS_GET:
      return "DSL_FIO_G997_FRAMING_PARAMETER_STATUS_GET";
   case DSL_FIO_G997_LINE_INVENTORY_GET:
      return "DSL_FIO_G997_LINE_INVENTORY_GET";
   case DSL_FIO_G997_LINE_INVENTORY_SET:
      return "DSL_FIO_G997_LINE_INVENTORY_SET";
   case DSL_FIO_G997_DELT_HLIN_SCALE_GET:
      return "DSL_FIO_G997_DELT_HLIN_SCALE_GET";
   case DSL_FIO_G997_DELT_HLIN_GET:
      return "DSL_FIO_G997_DELT_HLIN_GET";
   case DSL_FIO_G997_DELT_HLOG_GET:
      return "DSL_FIO_G997_DELT_HLOG_GET";
   case DSL_FIO_G997_DELT_SNR_GET:
      return "DSL_FIO_G997_DELT_SNR_GET";
   case DSL_FIO_G997_DELT_QLN_GET:
      return "DSL_FIO_G997_DELT_QLN_GET";
   case DSL_FIO_G997_DELT_FREE_RESOURCES:
      return "DSL_FIO_G997_DELT_FREE_RESOURCES";
   case DSL_FIO_G997_SNMP_MESSAGE_SEND:
      return "DSL_FIO_G997_SNMP_MESSAGE_SEND";
   case DSL_FIO_G997_SNMP_MESSAGE_RECEIVE:
      return "DSL_FIO_G997_SNMP_MESSAGE_RECEIVE";
   case DSL_FIO_G997_RATE_ADAPTATION_CONFIG_SET:
      return "DSL_FIO_G997_RATE_ADAPTATION_CONFIG_SET";
   case DSL_FIO_G997_RATE_ADAPTATION_CONFIG_GET:
      return "DSL_FIO_G997_RATE_ADAPTATION_CONFIG_GET";
   case DSL_FIO_G997_RATE_ADAPTATION_STATUS_GET:
      return "DSL_FIO_G997_RATE_ADAPTATION_STATUS_GET";
   case DSL_FIO_G997_US_POWER_BACK_OFF_STATUS_GET:
      return "DSL_FIO_G997_US_POWER_BACK_OFF_STATUS_GET";
   case DSL_FIO_G997_LOW_POWER_MODE_CONFIG_SET:
      return "DSL_FIO_G997_LOW_POWER_MODE_CONFIG_SET";
   case DSL_FIO_G997_LOW_POWER_MODE_CONFIG_GET:
      return "DSL_FIO_G997_LOW_POWER_MODE_CONFIG_GET";
   case DSL_FIO_G997_ATTAINABLE_NDR_STATUS_GET:
      return "DSL_FIO_G997_ATTAINABLE_NDR_STATUS_GET";
#if defined(INCLUDE_DSL_PM)
#ifdef INCLUDE_DSL_CPE_PM_LINE_COUNTERS
   case DSL_FIO_PM_LINE_SEC_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_LINE_SEC_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_LINE_SEC_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_LINE_SEC_HISTORY_STATS_1DAY_GET";
   case DSL_FIO_PM_LINE_SEC_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_LINE_SEC_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_LINE_SEC_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_LINE_SEC_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_LINE_SEC_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_LINE_SEC_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_SET:
      return "DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_SET";
   case DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_SET:
      return "DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_SET";
   case DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_GET:
      return "DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_GET";
   case DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_GET:
      return "DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_GET";
   case DSL_FIO_PM_LINE_INIT_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_LINE_INIT_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_LINE_INIT_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_LINE_INIT_HISTORY_STATS_1DAY_GET";
   case DSL_FIO_PM_LINE_INIT_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_LINE_INIT_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_LINE_INIT_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_LINE_INIT_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_LINE_INIT_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_LINE_INIT_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_SET:
      return "DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_SET";
   case DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_SET:
      return "DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_SET";
   case DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_GET:
      return "DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_GET";
   case DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_GET:
      return "DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_GET";
   case DSL_FIO_PM_LINE_SEC_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_LINE_SEC_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_LINE_INIT_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_LINE_INIT_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_1DAY_GET";
#endif
#ifdef INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS
   case DSL_FIO_PM_CHANNEL_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_CHANNEL_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_CHANNEL_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_CHANNEL_HISTORY_STATS_1DAY_GET";
   case DSL_FIO_PM_CHANNEL_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_CHANNEL_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_CHANNEL_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_CHANNEL_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_CHANNEL_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_CHANNEL_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_SET:
      return "DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_SET";
   case DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_SET:
      return "DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_SET";
   case DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_GET:
      return "DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_GET";
   case DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_GET:
      return "DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_GET";
   case DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_EXT_GET:
      return "DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_EXT_GET";
#endif
#ifdef INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS
   case DSL_FIO_PM_DATA_PATH_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_DATA_PATH_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_DATA_PATH_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_DATA_PATH_HISTORY_STATS_1DAY_GET";
   case DSL_FIO_PM_DATA_PATH_COUNTERS_15MIN_GET:
      return "SL_FIO_PM_DATA_PATH_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_DATA_PATH_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_DATA_PATH_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_DATA_PATH_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_DATA_PATH_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_SET:
      return "DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_SET";
   case DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_SET:
      return "DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_SET";
   case DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_GET:
      return "DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_GET";
   case DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_GET:
      return "DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_GET";
   case DSL_FIO_PM_DATA_PATH_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_DATA_PATH_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_1DAY_GET";
#endif
   case DSL_FIO_PM_RESET:
      return "DSL_FIO_PM_RESET";
   case DSL_FIO_PM_15MIN_ELAPSED_EXT_TRIGGER:
      return "DSL_FIO_PM_15MIN_ELAPSED_EXT_TRIGGER";
   case DSL_FIO_PM_ELAPSED_TIME_RESET:
      return "DSL_FIO_PM_ELAPSED_TIME_RESET";
   case DSL_FIO_PM_SYNC_MODE_SET:
      return "DSL_FIO_PM_SYNC_MODE_SET";
   case DSL_FIO_PM_BURNIN_MODE_SET:
      return "DSL_FIO_PM_BURNIN_MODE_SET";
   case DSL_FIO_PM_CONFIG_GET:
      return "DSL_FIO_PM_CONFIG_GET";
   case DSL_FIO_PM_CONFIG_SET:
      return "DSL_FIO_PM_CONFIG_SET";
   case DSL_FIO_PM_RETX_COUNTERS_15MIN_GET:
      return "DSL_FIO_PM_RETX_COUNTERS_15MIN_GET";
   case DSL_FIO_PM_RETX_COUNTERS_1DAY_GET:
      return "DSL_FIO_PM_RETX_COUNTERS_1DAY_GET";
   case DSL_FIO_PM_RETX_COUNTERS_SHOWTIME_GET:
      return "DSL_FIO_PM_RETX_COUNTERS_SHOWTIME_GET";
   case DSL_FIO_PM_RETX_COUNTERS_TOTAL_GET:
      return "DSL_FIO_PM_RETX_COUNTERS_TOTAL_GET";
   case DSL_FIO_PM_RETX_HISTORY_STATS_15MIN_GET:
      return "DSL_FIO_PM_RETX_HISTORY_STATS_15MIN_GET";
   case DSL_FIO_PM_RETX_HISTORY_STATS_1DAY_GET:
      return "DSL_FIO_PM_RETX_HISTORY_STATS_1DAY_GET";
   case DSL_FIO_PM_RETX_THRESHOLDS_15MIN_GET:
      return "DSL_FIO_PM_RETX_THRESHOLDS_15MIN_GET";
   case DSL_FIO_PM_RETX_THRESHOLDS_15MIN_SET:
      return "DSL_FIO_PM_RETX_THRESHOLDS_15MIN_SET";
   case DSL_FIO_PM_RETX_THRESHOLDS_1DAY_GET:
      return "DSL_FIO_PM_RETX_THRESHOLDS_1DAY_GET";
   case DSL_FIO_PM_RETX_THRESHOLDS_1DAY_SET:
      return "DSL_FIO_PM_RETX_THRESHOLDS_1DAY_SET";
   case DSL_FIO_PM_SYNC_MODE_GET:
      return "DSL_FIO_PM_SYNC_MODE_GET";
#endif /* #if defined(INCLUDE_DSL_PM)*/

#ifdef INCLUDE_REAL_TIME_TRACE
   case DSL_FIO_RTT_INIT:
      return "DSL_FIO_RTT_INIT";
   case DSL_FIO_RTT_CONFIG_SET:
      return "DSL_FIO_RTT_CONFIG_SET";
   case DSL_FIO_RTT_CONFIG_GET:
      return "DSL_FIO_RTT_CONFIG_GET";
   case DSL_FIO_RTT_STATUS_GET:
      return "DSL_FIO_RTT_STATUS_GET";
   case DSL_FIO_RTT_CONTROL_SET:
      return "DSL_FIO_RTT_CONTROL_SET";
   case DSL_FIO_RTT_STATISTICS_GET:
      return "DSL_FIO_RTT_STATISTICS_GET";
#endif /*#ifdef INCLUDE_REAL_TIME_TRACE*/
   default:
      return "<unknown>";
   }
}

/** @} DRV_DSL_CPE_DEBUG */

DSL_void_t DSL_DRV_ErrorSet(DSL_void_t *pContext, DSL_Error_t nCode)
{
   DSL_Context_t *pCtx = pContext;

   if (pContext == DSL_NULL)
   {
      DSL_DEBUG(DSL_DBG_ERR,
         (DSL_NULL, SYS_DBG_ERR"DSL DSL_DRV_ErrorSet: Context pointer is NULL!"
         DSL_DRV_CRLF));

      return;
   }

   pCtx->nErrNo = nCode;
}

#endif /* #ifndef DSL_DEBUG_DISABLE*/

#ifdef __cplusplus
}
#endif
