/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jan 15 07:29:12 EST 2017 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_notw_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 128 -name n1fv_128 -include n1f.h */

/*
 * This function contains 1082 FP additions, 642 FP multiplications,
 * (or, 440 additions, 0 multiplications, 642 fused multiply/add),
 * 295 stack variables, 31 constants, and 256 memory accesses
 */
#include "n1f.h"

static void n1fv_128(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DVK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DVK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DVK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DVK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DVK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DVK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DVK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DVK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DVK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DVK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DVK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DVK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DVK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DVK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V T6a, T5J, T6b, T5K, T6B, T6C, T6J, T6A, T6o, T6j, T6r, T68, T6e, T5O, T5R;
	       V T6d, T6D, T6K;
	       {
		    V Tad, TcZ, T6Z, T8T, T4U, Tr, Tfq, TgG, Ted, Tgf, Td0, Tcc, T9k, T84, Tb6;
		    V Tbt, Td8, TdK, TeK, Tgq, TeV, Tgt, T7q, T94, T3p, T5X, T7B, T97, T2G, T5U;
		    V TbD, Tc0, Tdf, TdN, Tf5, Tgx, Tfg, TgA, T7J, T9b, T4E, T64, T7U, T9e, T3V;
		    V T61, Td2, Td3, T85, T72, T4V, TI, Tcd, Tas, TgH, Tek, Tgg, Tft, T86, T75;
		    V T4W, TZ, TaI, Tcg, Tdr, TdG, Tgi, Tet, Tgj, Teq, T8X, T7a, T5M, T1B, T8W;
		    V T7d, T5N, T1s, TaX, Tcf, Tdo, TdH, Tgl, TeC, Tgm, Tez, T90, T7h, T5P, T2c;
		    V T8Z, T7k, T5Q, T23, T3Y, T49, TdL, Tdb, Tbu, Tbl, Tgu, TeR, Tgr, TeY, Tf6;
		    V TbG, T5V, T3s, T5Y, T3f, T95, T7E, T98, T7x, T4g, T4f, T4q, TbH, T41, TbI;
		    V T44, T4h, T4j, T4k, Tf9, TbN;
		    {
			 V Tu, TF, Ty, TL, TW, Tah, Tx, Tag, Tee, Tz, TM, TN, Teh, Tan, TP;
			 V TQ;
			 {
			      V TeG, T2A, Tbq, TeT, Tbp, TeH, T3m, T2x, Td6, T7o, T2q, T3l, T7z, Tbr, T2D;
			      V T82, T83;
			      {
				   V Ta7, T3, Ta8, T4O, Taa, Tab, Ta, T4P, Te, Tc9, Th, Tca, Tl, Tc6, Tc7;
				   V To;
				   {
					V T1, T2, T4M, T4N;
					T1 = LD(&(xi[0]), ivs, &(xi[0]));
					T2 = LD(&(xi[WS(is, 64)]), ivs, &(xi[0]));
					T4M = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
					T4N = LD(&(xi[WS(is, 96)]), ivs, &(xi[0]));
					{
					     V T4, T5, T7, T8;
					     T4 = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
					     T5 = LD(&(xi[WS(is, 80)]), ivs, &(xi[0]));
					     T7 = LD(&(xi[WS(is, 112)]), ivs, &(xi[0]));
					     T8 = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
					     {
						  V Tc, T6, T9, Td, Tf, Tg;
						  Tc = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
						  Ta7 = VADD(T1, T2);
						  T3 = VSUB(T1, T2);
						  Ta8 = VADD(T4M, T4N);
						  T4O = VSUB(T4M, T4N);
						  Taa = VADD(T4, T5);
						  T6 = VSUB(T4, T5);
						  Tab = VADD(T7, T8);
						  T9 = VSUB(T7, T8);
						  Td = LD(&(xi[WS(is, 72)]), ivs, &(xi[0]));
						  Tf = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
						  Tg = LD(&(xi[WS(is, 104)]), ivs, &(xi[0]));
						  {
						       V Tj, Tk, Tm, Tn;
						       Tj = LD(&(xi[WS(is, 120)]), ivs, &(xi[0]));
						       Tk = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
						       Tm = LD(&(xi[WS(is, 88)]), ivs, &(xi[0]));
						       Tn = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
						       Ta = VADD(T6, T9);
						       T4P = VSUB(T9, T6);
						       Te = VSUB(Tc, Td);
						       Tc9 = VADD(Tc, Td);
						       Th = VSUB(Tf, Tg);
						       Tca = VADD(Tf, Tg);
						       Tl = VSUB(Tj, Tk);
						       Tc6 = VADD(Tj, Tk);
						       Tc7 = VADD(Tn, Tm);
						       To = VSUB(Tm, Tn);
						  }
					     }
					}
				   }
				   {
					V T6X, Tb, Te9, Ta9, Tcb, Tea, T4R, Ti, Tfo, Tac, Tp, T4S, Tc8, Teb, T4Q;
					T6X = VFNMS(LDK(KP707106781), Ta, T3);
					Tb = VFMA(LDK(KP707106781), Ta, T3);
					Te9 = VSUB(Ta7, Ta8);
					Ta9 = VADD(Ta7, Ta8);
					Tcb = VADD(Tc9, Tca);
					Tea = VSUB(Tc9, Tca);
					T4R = VFMA(LDK(KP414213562), Te, Th);
					Ti = VFNMS(LDK(KP414213562), Th, Te);
					Tfo = VSUB(Tab, Taa);
					Tac = VADD(Taa, Tab);
					Tp = VFNMS(LDK(KP414213562), To, Tl);
					T4S = VFMA(LDK(KP414213562), Tl, To);
					Tc8 = VADD(Tc6, Tc7);
					Teb = VSUB(Tc6, Tc7);
					T4Q = VFNMS(LDK(KP707106781), T4P, T4O);
					T82 = VFMA(LDK(KP707106781), T4P, T4O);
					{
					     V T4T, T6Y, Tq, Tfp, Tec;
					     T4T = VSUB(T4R, T4S);
					     T6Y = VADD(T4R, T4S);
					     T83 = VSUB(Tp, Ti);
					     Tq = VADD(Ti, Tp);
					     Tfp = VSUB(Teb, Tea);
					     Tec = VADD(Tea, Teb);
					     Tad = VSUB(Ta9, Tac);
					     TcZ = VADD(Ta9, Tac);
					     T6Z = VFMA(LDK(KP923879532), T6Y, T6X);
					     T8T = VFNMS(LDK(KP923879532), T6Y, T6X);
					     T4U = VFMA(LDK(KP923879532), T4T, T4Q);
					     T6a = VFNMS(LDK(KP923879532), T4T, T4Q);
					     Tr = VFMA(LDK(KP923879532), Tq, Tb);
					     T5J = VFNMS(LDK(KP923879532), Tq, Tb);
					     Tfq = VFMA(LDK(KP707106781), Tfp, Tfo);
					     TgG = VFNMS(LDK(KP707106781), Tfp, Tfo);
					     Ted = VFMA(LDK(KP707106781), Tec, Te9);
					     Tgf = VFNMS(LDK(KP707106781), Tec, Te9);
					     Td0 = VADD(Tcb, Tc8);
					     Tcc = VSUB(Tc8, Tcb);
					}
				   }
			      }
			      {
				   V T2i, T3j, Tb2, T2B, Tb5, T3k, T2p, T2C;
				   {
					V T2m, Tb0, Tb1, Tb3, T2l, T2n;
					{
					     V T2g, T2h, T3h, T3i, T2j, T2k;
					     T2g = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
					     T2h = LD(&(xi[WS(is, 65)]), ivs, &(xi[WS(is, 1)]));
					     T3h = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
					     T3i = LD(&(xi[WS(is, 97)]), ivs, &(xi[WS(is, 1)]));
					     T2j = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
					     T2k = LD(&(xi[WS(is, 81)]), ivs, &(xi[WS(is, 1)]));
					     T2m = LD(&(xi[WS(is, 113)]), ivs, &(xi[WS(is, 1)]));
					     T9k = VFNMS(LDK(KP923879532), T83, T82);
					     T84 = VFMA(LDK(KP923879532), T83, T82);
					     T2i = VSUB(T2g, T2h);
					     Tb0 = VADD(T2g, T2h);
					     T3j = VSUB(T3h, T3i);
					     Tb1 = VADD(T3h, T3i);
					     Tb3 = VADD(T2j, T2k);
					     T2l = VSUB(T2j, T2k);
					     T2n = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
					}
					{
					     V T2r, T2s, T2u, T2v;
					     T2r = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
					     T2s = LD(&(xi[WS(is, 73)]), ivs, &(xi[WS(is, 1)]));
					     T2u = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
					     T2v = LD(&(xi[WS(is, 105)]), ivs, &(xi[WS(is, 1)]));
					     TeG = VSUB(Tb0, Tb1);
					     Tb2 = VADD(Tb0, Tb1);
					     {
						  V T2y, T2z, Tb4, T2o, Tbn, T2t, Tbo, T2w;
						  T2y = LD(&(xi[WS(is, 121)]), ivs, &(xi[WS(is, 1)]));
						  T2z = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
						  Tb4 = VADD(T2m, T2n);
						  T2o = VSUB(T2m, T2n);
						  Tbn = VADD(T2r, T2s);
						  T2t = VSUB(T2r, T2s);
						  Tbo = VADD(T2u, T2v);
						  T2w = VSUB(T2u, T2v);
						  T2B = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
						  T2A = VSUB(T2y, T2z);
						  Tbq = VADD(T2y, T2z);
						  TeT = VSUB(Tb3, Tb4);
						  Tb5 = VADD(Tb3, Tb4);
						  T3k = VSUB(T2l, T2o);
						  T2p = VADD(T2l, T2o);
						  Tbp = VADD(Tbn, Tbo);
						  TeH = VSUB(Tbn, Tbo);
						  T3m = VFMA(LDK(KP414213562), T2t, T2w);
						  T2x = VFNMS(LDK(KP414213562), T2w, T2t);
						  T2C = LD(&(xi[WS(is, 89)]), ivs, &(xi[WS(is, 1)]));
					     }
					}
				   }
				   Td6 = VADD(Tb2, Tb5);
				   Tb6 = VSUB(Tb2, Tb5);
				   T7o = VFNMS(LDK(KP707106781), T2p, T2i);
				   T2q = VFMA(LDK(KP707106781), T2p, T2i);
				   T3l = VFMA(LDK(KP707106781), T3k, T3j);
				   T7z = VFNMS(LDK(KP707106781), T3k, T3j);
				   Tbr = VADD(T2B, T2C);
				   T2D = VSUB(T2B, T2C);
			      }
			      {
				   V Tf1, Tfe, Tf2, TbZ, T3M, T4B, Tdd, T3F, T7H, T4A, T7S, TbW, Tf3, T4C, T3T;
				   {
					V T3x, T4y, Tbz, T3Q, TbC, T4z, T3E, T3R, T3P, TbU, TbV, T3S;
					{
					     V T3y, T3z, T3B, T3C;
					     {
						  V T3v, T3w, T4w, T4x;
						  T3v = LD(&(xi[WS(is, 127)]), ivs, &(xi[WS(is, 1)]));
						  T3w = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
						  T4w = LD(&(xi[WS(is, 95)]), ivs, &(xi[WS(is, 1)]));
						  T4x = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
						  T3y = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
						  {
						       V Tbs, TeI, T3n, T2E, Tbx;
						       Tbs = VADD(Tbq, Tbr);
						       TeI = VSUB(Tbq, Tbr);
						       T3n = VFNMS(LDK(KP414213562), T2A, T2D);
						       T2E = VFMA(LDK(KP414213562), T2D, T2A);
						       T3x = VSUB(T3v, T3w);
						       Tbx = VADD(T3v, T3w);
						       {
							    V Tby, Td7, TeJ, TeU;
							    T4y = VSUB(T4w, T4x);
							    Tby = VADD(T4x, T4w);
							    Td7 = VADD(Tbp, Tbs);
							    Tbt = VSUB(Tbp, Tbs);
							    TeJ = VADD(TeH, TeI);
							    TeU = VSUB(TeH, TeI);
							    {
								 V T7p, T3o, T7A, T2F;
								 T7p = VSUB(T3m, T3n);
								 T3o = VADD(T3m, T3n);
								 T7A = VSUB(T2x, T2E);
								 T2F = VADD(T2x, T2E);
								 Tbz = VADD(Tbx, Tby);
								 Tf1 = VSUB(Tbx, Tby);
								 Td8 = VADD(Td6, Td7);
								 TdK = VSUB(Td6, Td7);
								 TeK = VFMA(LDK(KP707106781), TeJ, TeG);
								 Tgq = VFNMS(LDK(KP707106781), TeJ, TeG);
								 TeV = VFMA(LDK(KP707106781), TeU, TeT);
								 Tgt = VFNMS(LDK(KP707106781), TeU, TeT);
								 T7q = VFMA(LDK(KP923879532), T7p, T7o);
								 T94 = VFNMS(LDK(KP923879532), T7p, T7o);
								 T3p = VFMA(LDK(KP923879532), T3o, T3l);
								 T5X = VFNMS(LDK(KP923879532), T3o, T3l);
								 T7B = VFNMS(LDK(KP923879532), T7A, T7z);
								 T97 = VFMA(LDK(KP923879532), T7A, T7z);
								 T2G = VFMA(LDK(KP923879532), T2F, T2q);
								 T5U = VFNMS(LDK(KP923879532), T2F, T2q);
								 T3z = LD(&(xi[WS(is, 79)]), ivs, &(xi[WS(is, 1)]));
							    }
						       }
						  }
						  T3B = LD(&(xi[WS(is, 111)]), ivs, &(xi[WS(is, 1)]));
						  T3C = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
					     }
					     {
						  V T3G, T3H, T3J, T3K;
						  T3G = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
						  T3H = LD(&(xi[WS(is, 71)]), ivs, &(xi[WS(is, 1)]));
						  T3J = LD(&(xi[WS(is, 103)]), ivs, &(xi[WS(is, 1)]));
						  T3K = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
						  {
						       V T3N, T3A, TbA, T3D, TbB, T3I, TbX, T3L, TbY, T3O;
						       T3N = LD(&(xi[WS(is, 119)]), ivs, &(xi[WS(is, 1)]));
						       T3A = VSUB(T3y, T3z);
						       TbA = VADD(T3y, T3z);
						       T3D = VSUB(T3B, T3C);
						       TbB = VADD(T3B, T3C);
						       T3I = VSUB(T3G, T3H);
						       TbX = VADD(T3G, T3H);
						       T3L = VSUB(T3J, T3K);
						       TbY = VADD(T3K, T3J);
						       T3O = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
						       T3Q = LD(&(xi[WS(is, 87)]), ivs, &(xi[WS(is, 1)]));
						       Tfe = VSUB(TbB, TbA);
						       TbC = VADD(TbA, TbB);
						       T4z = VSUB(T3D, T3A);
						       T3E = VADD(T3A, T3D);
						       T3R = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
						       Tf2 = VSUB(TbX, TbY);
						       TbZ = VADD(TbX, TbY);
						       T3M = VFMA(LDK(KP414213562), T3L, T3I);
						       T4B = VFNMS(LDK(KP414213562), T3I, T3L);
						       T3P = VSUB(T3N, T3O);
						       TbU = VADD(T3N, T3O);
						  }
					     }
					}
					Tdd = VADD(Tbz, TbC);
					TbD = VSUB(Tbz, TbC);
					TbV = VADD(T3R, T3Q);
					T3S = VSUB(T3Q, T3R);
					T3F = VFMA(LDK(KP707106781), T3E, T3x);
					T7H = VFNMS(LDK(KP707106781), T3E, T3x);
					T4A = VFMA(LDK(KP707106781), T4z, T4y);
					T7S = VFNMS(LDK(KP707106781), T4z, T4y);
					TbW = VADD(TbU, TbV);
					Tf3 = VSUB(TbU, TbV);
					T4C = VFMA(LDK(KP414213562), T3P, T3S);
					T3T = VFNMS(LDK(KP414213562), T3S, T3P);
				   }
				   {
					V TD, Tae, TE, TJ, TK, TU, TV;
					{
					     V Ts, Tt, Tde, Tf4, Tff;
					     Ts = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
					     Tt = LD(&(xi[WS(is, 68)]), ivs, &(xi[0]));
					     TD = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
					     Tde = VADD(TbZ, TbW);
					     Tc0 = VSUB(TbW, TbZ);
					     Tf4 = VADD(Tf2, Tf3);
					     Tff = VSUB(Tf3, Tf2);
					     {
						  V T7I, T4D, T7T, T3U;
						  T7I = VSUB(T4C, T4B);
						  T4D = VADD(T4B, T4C);
						  T7T = VSUB(T3T, T3M);
						  T3U = VADD(T3M, T3T);
						  Tae = VADD(Ts, Tt);
						  Tu = VSUB(Ts, Tt);
						  Tdf = VADD(Tdd, Tde);
						  TdN = VSUB(Tdd, Tde);
						  Tf5 = VFMA(LDK(KP707106781), Tf4, Tf1);
						  Tgx = VFNMS(LDK(KP707106781), Tf4, Tf1);
						  Tfg = VFMA(LDK(KP707106781), Tff, Tfe);
						  TgA = VFNMS(LDK(KP707106781), Tff, Tfe);
						  T7J = VFMA(LDK(KP923879532), T7I, T7H);
						  T9b = VFNMS(LDK(KP923879532), T7I, T7H);
						  T4E = VFMA(LDK(KP923879532), T4D, T4A);
						  T64 = VFNMS(LDK(KP923879532), T4D, T4A);
						  T7U = VFNMS(LDK(KP923879532), T7T, T7S);
						  T9e = VFMA(LDK(KP923879532), T7T, T7S);
						  T3V = VFMA(LDK(KP923879532), T3U, T3F);
						  T61 = VFNMS(LDK(KP923879532), T3U, T3F);
						  TE = LD(&(xi[WS(is, 100)]), ivs, &(xi[0]));
					     }
					}
					TJ = LD(&(xi[WS(is, 124)]), ivs, &(xi[0]));
					TK = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
					TU = LD(&(xi[WS(is, 92)]), ivs, &(xi[0]));
					TV = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
					{
					     V Tal, Tam, Tv, Tw, Taf;
					     Tv = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
					     Tw = LD(&(xi[WS(is, 84)]), ivs, &(xi[0]));
					     Taf = VADD(TD, TE);
					     TF = VSUB(TD, TE);
					     Ty = LD(&(xi[WS(is, 116)]), ivs, &(xi[0]));
					     TL = VSUB(TJ, TK);
					     Tal = VADD(TJ, TK);
					     TW = VSUB(TU, TV);
					     Tam = VADD(TV, TU);
					     Tah = VADD(Tv, Tw);
					     Tx = VSUB(Tv, Tw);
					     Tag = VADD(Tae, Taf);
					     Tee = VSUB(Tae, Taf);
					     Tz = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
					     TM = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
					     TN = LD(&(xi[WS(is, 76)]), ivs, &(xi[0]));
					     Teh = VSUB(Tal, Tam);
					     Tan = VADD(Tal, Tam);
					     TP = LD(&(xi[WS(is, 108)]), ivs, &(xi[0]));
					     TQ = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
					}
				   }
			      }
			 }
			 {
			      V Tev, TeA, Tdm, TaP, Tew, TaV, T1U, T29, T7f, T1N, T28, T7i, Tex, TaS, T21;
			      V T2a;
			      {
				   V Tem, Ter, Ten, TaD, T1j, T1y, TaA, Tdp, T1c, T78, T7b, T1x, TaG, Teo, T1z;
				   V T1q;
				   {
					V T14, T1v, Taw, Taz, T1b, T1w, T1n, T1o, T1m, TaE, TaF, T1p;
					{
					     V Tau, Tav, T15, T16, T18, T19;
					     {
						  V T12, Tai, TA, Tao, TO, T13;
						  T12 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
						  Tai = VADD(Ty, Tz);
						  TA = VSUB(Ty, Tz);
						  Tao = VADD(TM, TN);
						  TO = VSUB(TM, TN);
						  T13 = LD(&(xi[WS(is, 66)]), ivs, &(xi[0]));
						  {
						       V T1t, Tap, TR, Taj, Tef, TG, TB, T1u;
						       T1t = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
						       Tap = VADD(TP, TQ);
						       TR = VSUB(TP, TQ);
						       Taj = VADD(Tah, Tai);
						       Tef = VSUB(Tah, Tai);
						       TG = VSUB(Tx, TA);
						       TB = VADD(Tx, TA);
						       Tau = VADD(T12, T13);
						       T14 = VSUB(T12, T13);
						       T1u = LD(&(xi[WS(is, 98)]), ivs, &(xi[0]));
						       {
							    V Taq, Tei, TX, TS, Tak;
							    Taq = VADD(Tao, Tap);
							    Tei = VSUB(Tap, Tao);
							    TX = VSUB(TR, TO);
							    TS = VADD(TO, TR);
							    Tak = VSUB(Tag, Taj);
							    Td2 = VADD(Tag, Taj);
							    {
								 V Teg, Tfs, T71, TH;
								 Teg = VFNMS(LDK(KP414213562), Tef, Tee);
								 Tfs = VFMA(LDK(KP414213562), Tee, Tef);
								 T71 = VFNMS(LDK(KP707106781), TG, TF);
								 TH = VFMA(LDK(KP707106781), TG, TF);
								 {
								      V T70, TC, Tar, Tej, Tfr;
								      T70 = VFNMS(LDK(KP707106781), TB, Tu);
								      TC = VFMA(LDK(KP707106781), TB, Tu);
								      Tar = VSUB(Tan, Taq);
								      Td3 = VADD(Tan, Taq);
								      Tej = VFNMS(LDK(KP414213562), Tei, Teh);
								      Tfr = VFMA(LDK(KP414213562), Teh, Tei);
								      {
									   V T74, TY, T73, TT;
									   T74 = VFNMS(LDK(KP707106781), TX, TW);
									   TY = VFMA(LDK(KP707106781), TX, TW);
									   T73 = VFNMS(LDK(KP707106781), TS, TL);
									   TT = VFMA(LDK(KP707106781), TS, TL);
									   T85 = VFNMS(LDK(KP668178637), T70, T71);
									   T72 = VFMA(LDK(KP668178637), T71, T70);
									   T4V = VFMA(LDK(KP198912367), TC, TH);
									   TI = VFNMS(LDK(KP198912367), TH, TC);
									   Tcd = VSUB(Tar, Tak);
									   Tas = VADD(Tak, Tar);
									   TgH = VSUB(Tej, Teg);
									   Tek = VADD(Teg, Tej);
									   Tgg = VADD(Tfs, Tfr);
									   Tft = VSUB(Tfr, Tfs);
									   T86 = VFNMS(LDK(KP668178637), T73, T74);
									   T75 = VFMA(LDK(KP668178637), T74, T73);
									   T4W = VFMA(LDK(KP198912367), TT, TY);
									   TZ = VFNMS(LDK(KP198912367), TY, TT);
									   Tav = VADD(T1t, T1u);
									   T1v = VSUB(T1t, T1u);
								      }
								 }
							    }
						       }
						  }
					     }
					     T15 = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
					     T16 = LD(&(xi[WS(is, 82)]), ivs, &(xi[0]));
					     T18 = LD(&(xi[WS(is, 114)]), ivs, &(xi[0]));
					     T19 = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
					     {
						  V T1d, T1e, T1g, T1h, Tax, T17, Tay, T1a;
						  T1d = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
						  Taw = VADD(Tau, Tav);
						  Tem = VSUB(Tau, Tav);
						  T1e = LD(&(xi[WS(is, 74)]), ivs, &(xi[0]));
						  T1g = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
						  T1h = LD(&(xi[WS(is, 106)]), ivs, &(xi[0]));
						  Tax = VADD(T15, T16);
						  T17 = VSUB(T15, T16);
						  Tay = VADD(T18, T19);
						  T1a = VSUB(T18, T19);
						  {
						       V T1k, T1f, TaB, T1i, TaC, T1l;
						       T1k = LD(&(xi[WS(is, 122)]), ivs, &(xi[0]));
						       T1f = VSUB(T1d, T1e);
						       TaB = VADD(T1d, T1e);
						       T1i = VSUB(T1g, T1h);
						       TaC = VADD(T1g, T1h);
						       T1l = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
						       Taz = VADD(Tax, Tay);
						       Ter = VSUB(Tax, Tay);
						       T1b = VADD(T17, T1a);
						       T1w = VSUB(T17, T1a);
						       T1n = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
						       T1o = LD(&(xi[WS(is, 90)]), ivs, &(xi[0]));
						       Ten = VSUB(TaB, TaC);
						       TaD = VADD(TaB, TaC);
						       T1j = VFNMS(LDK(KP414213562), T1i, T1f);
						       T1y = VFMA(LDK(KP414213562), T1f, T1i);
						       T1m = VSUB(T1k, T1l);
						       TaE = VADD(T1k, T1l);
						  }
					     }
					}
					TaA = VSUB(Taw, Taz);
					Tdp = VADD(Taw, Taz);
					TaF = VADD(T1n, T1o);
					T1p = VSUB(T1n, T1o);
					T1c = VFMA(LDK(KP707106781), T1b, T14);
					T78 = VFNMS(LDK(KP707106781), T1b, T14);
					T7b = VFNMS(LDK(KP707106781), T1w, T1v);
					T1x = VFMA(LDK(KP707106781), T1w, T1v);
					TaG = VADD(TaE, TaF);
					Teo = VSUB(TaE, TaF);
					T1z = VFNMS(LDK(KP414213562), T1m, T1p);
					T1q = VFMA(LDK(KP414213562), T1p, T1m);
				   }
				   {
					V T1F, T26, T1Q, TaT, TaL, TaO, T27, T1M, T1Y, T1Z, TaU, T1T, TaQ, T1X, T20;
					V TaR;
					{
					     V T24, TaJ, T25, T1G, T1H, T1J, T1K, T1D, T1E;
					     T1D = LD(&(xi[WS(is, 126)]), ivs, &(xi[0]));
					     T1E = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
					     T24 = LD(&(xi[WS(is, 94)]), ivs, &(xi[0]));
					     {
						  V TaH, Tdq, Tes, Tep;
						  TaH = VSUB(TaD, TaG);
						  Tdq = VADD(TaD, TaG);
						  Tes = VSUB(Ten, Teo);
						  Tep = VADD(Ten, Teo);
						  {
						       V T79, T1A, T7c, T1r;
						       T79 = VSUB(T1y, T1z);
						       T1A = VADD(T1y, T1z);
						       T7c = VSUB(T1j, T1q);
						       T1r = VADD(T1j, T1q);
						       TaJ = VADD(T1D, T1E);
						       T1F = VSUB(T1D, T1E);
						       TaI = VFNMS(LDK(KP414213562), TaH, TaA);
						       Tcg = VFMA(LDK(KP414213562), TaA, TaH);
						       Tdr = VADD(Tdp, Tdq);
						       TdG = VSUB(Tdp, Tdq);
						       Tgi = VFNMS(LDK(KP707106781), Tes, Ter);
						       Tet = VFMA(LDK(KP707106781), Tes, Ter);
						       Tgj = VFNMS(LDK(KP707106781), Tep, Tem);
						       Teq = VFMA(LDK(KP707106781), Tep, Tem);
						       T8X = VFNMS(LDK(KP923879532), T79, T78);
						       T7a = VFMA(LDK(KP923879532), T79, T78);
						       T5M = VFNMS(LDK(KP923879532), T1A, T1x);
						       T1B = VFMA(LDK(KP923879532), T1A, T1x);
						       T8W = VFMA(LDK(KP923879532), T7c, T7b);
						       T7d = VFNMS(LDK(KP923879532), T7c, T7b);
						       T5N = VFNMS(LDK(KP923879532), T1r, T1c);
						       T1s = VFMA(LDK(KP923879532), T1r, T1c);
						       T25 = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
						  }
					     }
					     T1G = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
					     T1H = LD(&(xi[WS(is, 78)]), ivs, &(xi[0]));
					     T1J = LD(&(xi[WS(is, 110)]), ivs, &(xi[0]));
					     T1K = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
					     {
						  V T1R, T1I, TaM, T1L, TaN, T1S, T1O, T1P, TaK, T1V, T1W;
						  T1O = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
						  T1P = LD(&(xi[WS(is, 70)]), ivs, &(xi[0]));
						  T26 = VSUB(T24, T25);
						  TaK = VADD(T25, T24);
						  T1R = LD(&(xi[WS(is, 102)]), ivs, &(xi[0]));
						  T1I = VSUB(T1G, T1H);
						  TaM = VADD(T1G, T1H);
						  T1L = VSUB(T1J, T1K);
						  TaN = VADD(T1J, T1K);
						  T1Q = VSUB(T1O, T1P);
						  TaT = VADD(T1O, T1P);
						  Tev = VSUB(TaJ, TaK);
						  TaL = VADD(TaJ, TaK);
						  T1S = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
						  T1V = LD(&(xi[WS(is, 118)]), ivs, &(xi[0]));
						  T1W = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
						  TeA = VSUB(TaN, TaM);
						  TaO = VADD(TaM, TaN);
						  T27 = VSUB(T1L, T1I);
						  T1M = VADD(T1I, T1L);
						  T1Y = LD(&(xi[WS(is, 86)]), ivs, &(xi[0]));
						  T1Z = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
						  TaU = VADD(T1S, T1R);
						  T1T = VSUB(T1R, T1S);
						  TaQ = VADD(T1V, T1W);
						  T1X = VSUB(T1V, T1W);
					     }
					}
					Tdm = VADD(TaL, TaO);
					TaP = VSUB(TaL, TaO);
					T20 = VSUB(T1Y, T1Z);
					TaR = VADD(T1Z, T1Y);
					Tew = VSUB(TaT, TaU);
					TaV = VADD(TaT, TaU);
					T1U = VFMA(LDK(KP414213562), T1T, T1Q);
					T29 = VFNMS(LDK(KP414213562), T1Q, T1T);
					T7f = VFNMS(LDK(KP707106781), T1M, T1F);
					T1N = VFMA(LDK(KP707106781), T1M, T1F);
					T28 = VFMA(LDK(KP707106781), T27, T26);
					T7i = VFNMS(LDK(KP707106781), T27, T26);
					Tex = VSUB(TaQ, TaR);
					TaS = VADD(TaQ, TaR);
					T21 = VFNMS(LDK(KP414213562), T20, T1X);
					T2a = VFMA(LDK(KP414213562), T1X, T20);
				   }
			      }
			      {
				   V T2J, T2U, T30, T3b, TeL, Tb9, TeO, Tbg, T2M, Tba, T2P, Tbb, T34, Tbh, T33;
				   V T35;
				   {
					V T2H, T2I, T2S, T2T, T2Y, T2Z, T39, T3a;
					T2H = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
					{
					     V Tdn, TaW, Tey, TeB;
					     Tdn = VADD(TaV, TaS);
					     TaW = VSUB(TaS, TaV);
					     Tey = VADD(Tew, Tex);
					     TeB = VSUB(Tex, Tew);
					     {
						  V T2b, T7g, T22, T7j;
						  T2b = VADD(T29, T2a);
						  T7g = VSUB(T2a, T29);
						  T22 = VADD(T1U, T21);
						  T7j = VSUB(T21, T1U);
						  TaX = VFNMS(LDK(KP414213562), TaW, TaP);
						  Tcf = VFMA(LDK(KP414213562), TaP, TaW);
						  Tdo = VADD(Tdm, Tdn);
						  TdH = VSUB(Tdm, Tdn);
						  Tgl = VFNMS(LDK(KP707106781), TeB, TeA);
						  TeC = VFMA(LDK(KP707106781), TeB, TeA);
						  Tgm = VFNMS(LDK(KP707106781), Tey, Tev);
						  Tez = VFMA(LDK(KP707106781), Tey, Tev);
						  T90 = VFNMS(LDK(KP923879532), T7g, T7f);
						  T7h = VFMA(LDK(KP923879532), T7g, T7f);
						  T5P = VFNMS(LDK(KP923879532), T2b, T28);
						  T2c = VFMA(LDK(KP923879532), T2b, T28);
						  T8Z = VFMA(LDK(KP923879532), T7j, T7i);
						  T7k = VFNMS(LDK(KP923879532), T7j, T7i);
						  T5Q = VFNMS(LDK(KP923879532), T22, T1N);
						  T23 = VFMA(LDK(KP923879532), T22, T1N);
						  T2I = LD(&(xi[WS(is, 69)]), ivs, &(xi[WS(is, 1)]));
					     }
					}
					T2S = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
					T2T = LD(&(xi[WS(is, 101)]), ivs, &(xi[WS(is, 1)]));
					T2Y = LD(&(xi[WS(is, 125)]), ivs, &(xi[WS(is, 1)]));
					T2Z = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
					T39 = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
					T3a = LD(&(xi[WS(is, 93)]), ivs, &(xi[WS(is, 1)]));
					{
					     V T2K, Tbe, Tbf, T2L, T2N, T2O, Tb7, Tb8, T31, T32;
					     T2K = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
					     T2J = VSUB(T2H, T2I);
					     Tb7 = VADD(T2H, T2I);
					     T2U = VSUB(T2S, T2T);
					     Tb8 = VADD(T2S, T2T);
					     T30 = VSUB(T2Y, T2Z);
					     Tbe = VADD(T2Y, T2Z);
					     T3b = VSUB(T39, T3a);
					     Tbf = VADD(T39, T3a);
					     T2L = LD(&(xi[WS(is, 85)]), ivs, &(xi[WS(is, 1)]));
					     T2N = LD(&(xi[WS(is, 117)]), ivs, &(xi[WS(is, 1)]));
					     T2O = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
					     TeL = VSUB(Tb7, Tb8);
					     Tb9 = VADD(Tb7, Tb8);
					     T31 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
					     T32 = LD(&(xi[WS(is, 77)]), ivs, &(xi[WS(is, 1)]));
					     TeO = VSUB(Tbe, Tbf);
					     Tbg = VADD(Tbe, Tbf);
					     T2M = VSUB(T2K, T2L);
					     Tba = VADD(T2K, T2L);
					     T2P = VSUB(T2N, T2O);
					     Tbb = VADD(T2N, T2O);
					     T34 = LD(&(xi[WS(is, 109)]), ivs, &(xi[WS(is, 1)]));
					     Tbh = VADD(T31, T32);
					     T33 = VSUB(T31, T32);
					     T35 = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
					}
				   }
				   {
					V T4d, T4e, T4o, T4p;
					{
					     V T2X, T3q, T7t, T7C, T3r, T3e, T7D, T7w;
					     {
						  V T47, TbE, Tbd, Td9, TeW, TeN, T7s, T2W, T7r, T2R, TeP, Tbj, T37, T3c, T48;
						  {
						       V T3W, T3X, TeM, Tbc, T2Q, T2V, Tbi, T36;
						       T3W = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
						       T3X = LD(&(xi[WS(is, 67)]), ivs, &(xi[WS(is, 1)]));
						       TeM = VSUB(Tba, Tbb);
						       Tbc = VADD(Tba, Tbb);
						       T2Q = VADD(T2M, T2P);
						       T2V = VSUB(T2M, T2P);
						       T47 = LD(&(xi[WS(is, 99)]), ivs, &(xi[WS(is, 1)]));
						       Tbi = VADD(T34, T35);
						       T36 = VSUB(T34, T35);
						       TbE = VADD(T3W, T3X);
						       T3Y = VSUB(T3W, T3X);
						       Tbd = VSUB(Tb9, Tbc);
						       Td9 = VADD(Tb9, Tbc);
						       TeW = VFMA(LDK(KP414213562), TeL, TeM);
						       TeN = VFNMS(LDK(KP414213562), TeM, TeL);
						       T7s = VFNMS(LDK(KP707106781), T2V, T2U);
						       T2W = VFMA(LDK(KP707106781), T2V, T2U);
						       T7r = VFNMS(LDK(KP707106781), T2Q, T2J);
						       T2R = VFMA(LDK(KP707106781), T2Q, T2J);
						       TeP = VSUB(Tbh, Tbi);
						       Tbj = VADD(Tbh, Tbi);
						       T37 = VADD(T33, T36);
						       T3c = VSUB(T33, T36);
						       T48 = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
						  }
						  T2X = VFNMS(LDK(KP198912367), T2W, T2R);
						  T3q = VFMA(LDK(KP198912367), T2R, T2W);
						  T7t = VFMA(LDK(KP668178637), T7s, T7r);
						  T7C = VFNMS(LDK(KP668178637), T7r, T7s);
						  {
						       V Tbk, Tda, TeX, TeQ;
						       Tbk = VSUB(Tbg, Tbj);
						       Tda = VADD(Tbg, Tbj);
						       TeX = VFNMS(LDK(KP414213562), TeO, TeP);
						       TeQ = VFMA(LDK(KP414213562), TeP, TeO);
						       {
							    V T7v, T3d, T7u, T38, TbF;
							    T7v = VFNMS(LDK(KP707106781), T3c, T3b);
							    T3d = VFMA(LDK(KP707106781), T3c, T3b);
							    T7u = VFNMS(LDK(KP707106781), T37, T30);
							    T38 = VFMA(LDK(KP707106781), T37, T30);
							    T49 = VSUB(T47, T48);
							    TbF = VADD(T48, T47);
							    TdL = VSUB(Td9, Tda);
							    Tdb = VADD(Td9, Tda);
							    Tbu = VSUB(Tbd, Tbk);
							    Tbl = VADD(Tbd, Tbk);
							    Tgu = VSUB(TeN, TeQ);
							    TeR = VADD(TeN, TeQ);
							    Tgr = VSUB(TeW, TeX);
							    TeY = VADD(TeW, TeX);
							    T3r = VFNMS(LDK(KP198912367), T38, T3d);
							    T3e = VFMA(LDK(KP198912367), T3d, T38);
							    T7D = VFMA(LDK(KP668178637), T7u, T7v);
							    T7w = VFNMS(LDK(KP668178637), T7v, T7u);
							    Tf6 = VSUB(TbE, TbF);
							    TbG = VADD(TbE, TbF);
						       }
						  }
					     }
					     T4d = LD(&(xi[WS(is, 123)]), ivs, &(xi[WS(is, 1)]));
					     T5V = VSUB(T3q, T3r);
					     T3s = VADD(T3q, T3r);
					     T5Y = VSUB(T2X, T3e);
					     T3f = VADD(T2X, T3e);
					     T95 = VSUB(T7D, T7C);
					     T7E = VADD(T7C, T7D);
					     T98 = VSUB(T7t, T7w);
					     T7x = VADD(T7t, T7w);
					     T4e = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
					     T4o = LD(&(xi[WS(is, 91)]), ivs, &(xi[WS(is, 1)]));
					     T4p = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
					}
					{
					     V T3Z, T40, T42, T43, TbL, TbM;
					     T3Z = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
					     T40 = LD(&(xi[WS(is, 83)]), ivs, &(xi[WS(is, 1)]));
					     T42 = LD(&(xi[WS(is, 115)]), ivs, &(xi[WS(is, 1)]));
					     T43 = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
					     T4g = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
					     T4f = VSUB(T4d, T4e);
					     TbL = VADD(T4d, T4e);
					     T4q = VSUB(T4o, T4p);
					     TbM = VADD(T4p, T4o);
					     TbH = VADD(T3Z, T40);
					     T41 = VSUB(T3Z, T40);
					     TbI = VADD(T42, T43);
					     T44 = VSUB(T42, T43);
					     T4h = LD(&(xi[WS(is, 75)]), ivs, &(xi[WS(is, 1)]));
					     T4j = LD(&(xi[WS(is, 107)]), ivs, &(xi[WS(is, 1)]));
					     T4k = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
					     Tf9 = VSUB(TbL, TbM);
					     TbN = VADD(TbL, TbM);
					}
				   }
			      }
			 }
		    }
		    {
			 V TgB, Tgy, T62, T4H, T65, T4u, T9c, T7X, T9f, T7Q, Tg0, Tga, TfF, TeF, TfT;
			 V TfU, TfP, Tg7, TfI, Tfy, TfA, Tf0, Tfz, Tfl, Tg2, TfS;
			 {
			      V Tc1, TbS, Tfc, Tfj, TdX, Te5, TdZ, TdR, Te7, Te3, TdU, Te4;
			      {
				   V TdF, TdS, Tdx, Td5, TdO, TdE, TdC, Tdt, Tdk;
				   {
					V Tdc, TdA, T4F, T4c, T7V, T7M, T4G, T4t, T7W, T7P, TdB, Tdj;
					{
					     V Td1, Tdg, TbK, Tf8, Tfh, T4b, T7L, T46, T7K, TbQ, Tfa, T4r, T4m, Td4;
					     TdF = VSUB(TcZ, Td0);
					     Td1 = VADD(TcZ, Td0);
					     {
						  V TbJ, Tf7, T4a, T45;
						  TbJ = VADD(TbH, TbI);
						  Tf7 = VSUB(TbI, TbH);
						  T4a = VSUB(T44, T41);
						  T45 = VADD(T41, T44);
						  {
						       V TbO, T4i, TbP, T4l;
						       TbO = VADD(T4g, T4h);
						       T4i = VSUB(T4g, T4h);
						       TbP = VADD(T4j, T4k);
						       T4l = VSUB(T4j, T4k);
						       Tdg = VADD(TbG, TbJ);
						       TbK = VSUB(TbG, TbJ);
						       Tf8 = VFMA(LDK(KP414213562), Tf7, Tf6);
						       Tfh = VFNMS(LDK(KP414213562), Tf6, Tf7);
						       T4b = VFMA(LDK(KP707106781), T4a, T49);
						       T7L = VFNMS(LDK(KP707106781), T4a, T49);
						       T46 = VFMA(LDK(KP707106781), T45, T3Y);
						       T7K = VFNMS(LDK(KP707106781), T45, T3Y);
						       TbQ = VADD(TbO, TbP);
						       Tfa = VSUB(TbP, TbO);
						       T4r = VSUB(T4l, T4i);
						       T4m = VADD(T4i, T4l);
						       Td4 = VADD(Td2, Td3);
						       TdS = VSUB(Td3, Td2);
						  }
					     }
					     Tdc = VSUB(Td8, Tdb);
					     TdA = VADD(Td8, Tdb);
					     T4F = VFNMS(LDK(KP198912367), T46, T4b);
					     T4c = VFMA(LDK(KP198912367), T4b, T46);
					     T7V = VFMA(LDK(KP668178637), T7K, T7L);
					     T7M = VFNMS(LDK(KP668178637), T7L, T7K);
					     {
						  V Tdh, TbR, Tfb, Tfi;
						  Tdh = VADD(TbN, TbQ);
						  TbR = VSUB(TbN, TbQ);
						  Tfb = VFNMS(LDK(KP414213562), Tfa, Tf9);
						  Tfi = VFMA(LDK(KP414213562), Tf9, Tfa);
						  {
						       V T4s, T7O, T4n, T7N, Tdi;
						       T4s = VFMA(LDK(KP707106781), T4r, T4q);
						       T7O = VFNMS(LDK(KP707106781), T4r, T4q);
						       T4n = VFMA(LDK(KP707106781), T4m, T4f);
						       T7N = VFNMS(LDK(KP707106781), T4m, T4f);
						       Tdx = VADD(Td1, Td4);
						       Td5 = VSUB(Td1, Td4);
						       TdO = VSUB(Tdh, Tdg);
						       Tdi = VADD(Tdg, Tdh);
						       Tc1 = VSUB(TbR, TbK);
						       TbS = VADD(TbK, TbR);
						       TgB = VSUB(Tfb, Tf8);
						       Tfc = VADD(Tf8, Tfb);
						       Tgy = VSUB(Tfi, Tfh);
						       Tfj = VADD(Tfh, Tfi);
						       T4G = VFMA(LDK(KP198912367), T4n, T4s);
						       T4t = VFNMS(LDK(KP198912367), T4s, T4n);
						       T7W = VFNMS(LDK(KP668178637), T7N, T7O);
						       T7P = VFMA(LDK(KP668178637), T7O, T7N);
						       TdB = VADD(Tdf, Tdi);
						       Tdj = VSUB(Tdf, Tdi);
						  }
					     }
					}
					T62 = VSUB(T4G, T4F);
					T4H = VADD(T4F, T4G);
					T65 = VSUB(T4t, T4c);
					T4u = VADD(T4c, T4t);
					T9c = VSUB(T7V, T7W);
					T7X = VADD(T7V, T7W);
					T9f = VSUB(T7P, T7M);
					T7Q = VADD(T7M, T7P);
					TdE = VSUB(TdB, TdA);
					TdC = VADD(TdA, TdB);
					Tdt = VSUB(Tdj, Tdc);
					Tdk = VADD(Tdc, Tdj);
				   }
				   {
					V TdT, Tdl, Tdv, TdJ, Te1, Te2, TdQ, Tdz, TdD, Tdu, Tdw;
					{
					     V TdI, TdP, TdV, TdW, TdM, Tds, Tdy;
					     TdI = VADD(TdG, TdH);
					     TdT = VSUB(TdH, TdG);
					     TdP = VFNMS(LDK(KP414213562), TdO, TdN);
					     TdV = VFMA(LDK(KP414213562), TdN, TdO);
					     TdW = VFMA(LDK(KP414213562), TdK, TdL);
					     TdM = VFNMS(LDK(KP414213562), TdL, TdK);
					     Tdl = VFNMS(LDK(KP707106781), Tdk, Td5);
					     Tdv = VFMA(LDK(KP707106781), Tdk, Td5);
					     Tds = VSUB(Tdo, Tdr);
					     Tdy = VADD(Tdr, Tdo);
					     TdJ = VFMA(LDK(KP707106781), TdI, TdF);
					     Te1 = VFNMS(LDK(KP707106781), TdI, TdF);
					     TdX = VSUB(TdV, TdW);
					     Te2 = VADD(TdW, TdV);
					     Te5 = VSUB(TdP, TdM);
					     TdQ = VADD(TdM, TdP);
					     Tdz = VADD(Tdx, Tdy);
					     TdD = VSUB(Tdx, Tdy);
					     Tdu = VFNMS(LDK(KP707106781), Tdt, Tds);
					     Tdw = VFMA(LDK(KP707106781), Tdt, Tds);
					}
					TdZ = VFMA(LDK(KP923879532), TdQ, TdJ);
					TdR = VFNMS(LDK(KP923879532), TdQ, TdJ);
					Te7 = VFMA(LDK(KP923879532), Te2, Te1);
					Te3 = VFNMS(LDK(KP923879532), Te2, Te1);
					ST(&(xo[WS(os, 32)]), VFMAI(TdE, TdD), ovs, &(xo[0]));
					ST(&(xo[WS(os, 96)]), VFNMSI(TdE, TdD), ovs, &(xo[0]));
					ST(&(xo[0]), VADD(Tdz, TdC), ovs, &(xo[0]));
					ST(&(xo[WS(os, 64)]), VSUB(Tdz, TdC), ovs, &(xo[0]));
					ST(&(xo[WS(os, 16)]), VFMAI(Tdw, Tdv), ovs, &(xo[0]));
					ST(&(xo[WS(os, 112)]), VFNMSI(Tdw, Tdv), ovs, &(xo[0]));
					ST(&(xo[WS(os, 80)]), VFMAI(Tdu, Tdl), ovs, &(xo[0]));
					ST(&(xo[WS(os, 48)]), VFNMSI(Tdu, Tdl), ovs, &(xo[0]));
					TdU = VFMA(LDK(KP707106781), TdT, TdS);
					Te4 = VFNMS(LDK(KP707106781), TdT, TdS);
				   }
			      }
			      {
				   V Tcx, TcJ, TcI, Tcy, TcA, Tbm, Tcp, TaZ, Tcs, Tci, Tbv, TcB, TcD, TbT, Tc2;
				   V TcE, Tat, TaY;
				   Tcx = VFNMS(LDK(KP707106781), Tas, Tad);
				   Tat = VFMA(LDK(KP707106781), Tas, Tad);
				   TaY = VADD(TaI, TaX);
				   TcJ = VSUB(TaX, TaI);
				   {
					V Tce, Tch, Te8, Te6, TdY, Te0;
					TcI = VFNMS(LDK(KP707106781), Tcd, Tcc);
					Tce = VFMA(LDK(KP707106781), Tcd, Tcc);
					Tch = VSUB(Tcf, Tcg);
					Tcy = VADD(Tcg, Tcf);
					Te8 = VFNMS(LDK(KP923879532), Te5, Te4);
					Te6 = VFMA(LDK(KP923879532), Te5, Te4);
					TdY = VFNMS(LDK(KP923879532), TdX, TdU);
					Te0 = VFMA(LDK(KP923879532), TdX, TdU);
					TcA = VFNMS(LDK(KP707106781), Tbl, Tb6);
					Tbm = VFMA(LDK(KP707106781), Tbl, Tb6);
					Tcp = VFNMS(LDK(KP923879532), TaY, Tat);
					TaZ = VFMA(LDK(KP923879532), TaY, Tat);
					Tcs = VFNMS(LDK(KP923879532), Tch, Tce);
					Tci = VFMA(LDK(KP923879532), Tch, Tce);
					ST(&(xo[WS(os, 88)]), VFNMSI(Te6, Te3), ovs, &(xo[0]));
					ST(&(xo[WS(os, 40)]), VFMAI(Te6, Te3), ovs, &(xo[0]));
					ST(&(xo[WS(os, 104)]), VFMAI(Te8, Te7), ovs, &(xo[0]));
					ST(&(xo[WS(os, 24)]), VFNMSI(Te8, Te7), ovs, &(xo[0]));
					ST(&(xo[WS(os, 8)]), VFMAI(Te0, TdZ), ovs, &(xo[0]));
					ST(&(xo[WS(os, 120)]), VFNMSI(Te0, TdZ), ovs, &(xo[0]));
					ST(&(xo[WS(os, 72)]), VFMAI(TdY, TdR), ovs, &(xo[0]));
					ST(&(xo[WS(os, 56)]), VFNMSI(TdY, TdR), ovs, &(xo[0]));
					Tbv = VFMA(LDK(KP707106781), Tbu, Tbt);
					TcB = VFNMS(LDK(KP707106781), Tbu, Tbt);
					TcD = VFNMS(LDK(KP707106781), TbS, TbD);
					TbT = VFMA(LDK(KP707106781), TbS, TbD);
					Tc2 = VFMA(LDK(KP707106781), Tc1, Tc0);
					TcE = VFNMS(LDK(KP707106781), Tc1, Tc0);
				   }
				   {
					V TcR, Tcz, TcU, TcK, Tcq, Tcl, Tct, Tc4;
					{
					     V Tck, Tbw, Tcj, Tc3;
					     Tck = VFMA(LDK(KP198912367), Tbm, Tbv);
					     Tbw = VFNMS(LDK(KP198912367), Tbv, Tbm);
					     Tcj = VFMA(LDK(KP198912367), TbT, Tc2);
					     Tc3 = VFNMS(LDK(KP198912367), Tc2, TbT);
					     TcR = VFNMS(LDK(KP923879532), Tcy, Tcx);
					     Tcz = VFMA(LDK(KP923879532), Tcy, Tcx);
					     TcU = VFMA(LDK(KP923879532), TcJ, TcI);
					     TcK = VFNMS(LDK(KP923879532), TcJ, TcI);
					     Tcq = VADD(Tck, Tcj);
					     Tcl = VSUB(Tcj, Tck);
					     Tct = VSUB(Tc3, Tbw);
					     Tc4 = VADD(Tbw, Tc3);
					}
					{
					     V TfN, Tel, TfY, Tfu, Tfw, Tfv, TcT, TcX, TcQ, TcO, TcW, TcY, TcP, TcH, TfZ;
					     V TeE;
					     {
						  V Teu, TcS, TcN, TcV, TcG, TeD;
						  TfN = VFNMS(LDK(KP923879532), Tek, Ted);
						  Tel = VFMA(LDK(KP923879532), Tek, Ted);
						  {
						       V TcM, TcC, Tcr, Tcv;
						       TcM = VFNMS(LDK(KP668178637), TcA, TcB);
						       TcC = VFMA(LDK(KP668178637), TcB, TcA);
						       Tcr = VFNMS(LDK(KP980785280), Tcq, Tcp);
						       Tcv = VFMA(LDK(KP980785280), Tcq, Tcp);
						       {
							    V Tco, Tcm, Tcu, Tcw;
							    Tco = VFMA(LDK(KP980785280), Tcl, Tci);
							    Tcm = VFNMS(LDK(KP980785280), Tcl, Tci);
							    Tcu = VFMA(LDK(KP980785280), Tct, Tcs);
							    Tcw = VFNMS(LDK(KP980785280), Tct, Tcs);
							    {
								 V Tcn, Tc5, TcL, TcF;
								 Tcn = VFMA(LDK(KP980785280), Tc4, TaZ);
								 Tc5 = VFNMS(LDK(KP980785280), Tc4, TaZ);
								 TcL = VFNMS(LDK(KP668178637), TcD, TcE);
								 TcF = VFMA(LDK(KP668178637), TcE, TcD);
								 TfY = VFNMS(LDK(KP923879532), Tft, Tfq);
								 Tfu = VFMA(LDK(KP923879532), Tft, Tfq);
								 Tfw = VFMA(LDK(KP198912367), Teq, Tet);
								 Teu = VFNMS(LDK(KP198912367), Tet, Teq);
								 ST(&(xo[WS(os, 92)]), VFNMSI(Tcu, Tcr), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 36)]), VFMAI(Tcu, Tcr), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 100)]), VFMAI(Tcw, Tcv), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 28)]), VFNMSI(Tcw, Tcv), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 4)]), VFMAI(Tco, Tcn), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 124)]), VFNMSI(Tco, Tcn), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 68)]), VFMAI(Tcm, Tc5), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 60)]), VFNMSI(Tcm, Tc5), ovs, &(xo[0]));
								 TcS = VADD(TcM, TcL);
								 TcN = VSUB(TcL, TcM);
								 TcV = VSUB(TcF, TcC);
								 TcG = VADD(TcC, TcF);
								 TeD = VFNMS(LDK(KP198912367), TeC, Tez);
								 Tfv = VFMA(LDK(KP198912367), Tez, TeC);
							    }
						       }
						  }
						  TcT = VFMA(LDK(KP831469612), TcS, TcR);
						  TcX = VFNMS(LDK(KP831469612), TcS, TcR);
						  TcQ = VFMA(LDK(KP831469612), TcN, TcK);
						  TcO = VFNMS(LDK(KP831469612), TcN, TcK);
						  TcW = VFNMS(LDK(KP831469612), TcV, TcU);
						  TcY = VFMA(LDK(KP831469612), TcV, TcU);
						  TcP = VFMA(LDK(KP831469612), TcG, Tcz);
						  TcH = VFNMS(LDK(KP831469612), TcG, Tcz);
						  TfZ = VSUB(TeD, Teu);
						  TeE = VADD(Teu, TeD);
					     }
					     {
						  V TfQ, TeS, TfO, Tfx, TeZ, TfR, Tfd, Tfk;
						  TfQ = VFNMS(LDK(KP923879532), TeR, TeK);
						  TeS = VFMA(LDK(KP923879532), TeR, TeK);
						  ST(&(xo[WS(os, 84)]), VFMAI(TcW, TcT), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 44)]), VFNMSI(TcW, TcT), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 108)]), VFNMSI(TcY, TcX), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 20)]), VFMAI(TcY, TcX), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 116)]), VFMAI(TcQ, TcP), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 12)]), VFNMSI(TcQ, TcP), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 52)]), VFMAI(TcO, TcH), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 76)]), VFNMSI(TcO, TcH), ovs, &(xo[0]));
						  Tg0 = VFNMS(LDK(KP980785280), TfZ, TfY);
						  Tga = VFMA(LDK(KP980785280), TfZ, TfY);
						  TfF = VFNMS(LDK(KP980785280), TeE, Tel);
						  TeF = VFMA(LDK(KP980785280), TeE, Tel);
						  TfO = VADD(Tfw, Tfv);
						  Tfx = VSUB(Tfv, Tfw);
						  TeZ = VFMA(LDK(KP923879532), TeY, TeV);
						  TfR = VFNMS(LDK(KP923879532), TeY, TeV);
						  TfT = VFNMS(LDK(KP923879532), Tfc, Tf5);
						  Tfd = VFMA(LDK(KP923879532), Tfc, Tf5);
						  Tfk = VFMA(LDK(KP923879532), Tfj, Tfg);
						  TfU = VFNMS(LDK(KP923879532), Tfj, Tfg);
						  TfP = VFMA(LDK(KP980785280), TfO, TfN);
						  Tg7 = VFNMS(LDK(KP980785280), TfO, TfN);
						  TfI = VFNMS(LDK(KP980785280), Tfx, Tfu);
						  Tfy = VFMA(LDK(KP980785280), Tfx, Tfu);
						  TfA = VFMA(LDK(KP098491403), TeS, TeZ);
						  Tf0 = VFNMS(LDK(KP098491403), TeZ, TeS);
						  Tfz = VFMA(LDK(KP098491403), Tfd, Tfk);
						  Tfl = VFNMS(LDK(KP098491403), Tfk, Tfd);
						  Tg2 = VFNMS(LDK(KP820678790), TfQ, TfR);
						  TfS = VFMA(LDK(KP820678790), TfR, TfQ);
					     }
					}
				   }
			      }
			 }
			 {
			      V T8x, T8y, T8F, T8w, T8k, T8f, T8n, T80, T9l, T76, T87, T8U, T89, T7e, T7l;
			      V T8a;
			      {
				   V The, Tho, TgT, Tgp, Th7, Th8, Thg, Th6, Th3, Thl, TgW, TgM, TgU, TgP, TgX;
				   V TgE;
				   {
					V Th1, TgI, TgK, TgJ;
					{
					     V Tgh, Thc, Tgk, TfG, TfB, TfJ, Tfm, Tg1, TfV, Tgn, TfL, TfH;
					     Th1 = VFMA(LDK(KP923879532), Tgg, Tgf);
					     Tgh = VFNMS(LDK(KP923879532), Tgg, Tgf);
					     Thc = VFNMS(LDK(KP923879532), TgH, TgG);
					     TgI = VFMA(LDK(KP923879532), TgH, TgG);
					     TgK = VFMA(LDK(KP668178637), Tgi, Tgj);
					     Tgk = VFNMS(LDK(KP668178637), Tgj, Tgi);
					     TfG = VADD(TfA, Tfz);
					     TfB = VSUB(Tfz, TfA);
					     TfJ = VSUB(Tfl, Tf0);
					     Tfm = VADD(Tf0, Tfl);
					     Tg1 = VFNMS(LDK(KP820678790), TfT, TfU);
					     TfV = VFMA(LDK(KP820678790), TfU, TfT);
					     Tgn = VFNMS(LDK(KP668178637), Tgm, Tgl);
					     TgJ = VFMA(LDK(KP668178637), Tgl, Tgm);
					     TfL = VFMA(LDK(KP995184726), TfG, TfF);
					     TfH = VFNMS(LDK(KP995184726), TfG, TfF);
					     {
						  V TfE, TfC, TfM, TfK;
						  TfE = VFMA(LDK(KP995184726), TfB, Tfy);
						  TfC = VFNMS(LDK(KP995184726), TfB, Tfy);
						  TfM = VFNMS(LDK(KP995184726), TfJ, TfI);
						  TfK = VFMA(LDK(KP995184726), TfJ, TfI);
						  {
						       V TfD, Tfn, Tg8, Tg3;
						       TfD = VFMA(LDK(KP995184726), Tfm, TeF);
						       Tfn = VFNMS(LDK(KP995184726), Tfm, TeF);
						       Tg8 = VADD(Tg2, Tg1);
						       Tg3 = VSUB(Tg1, Tg2);
						       {
							    V Tgb, TfW, Thd, Tgo;
							    Tgb = VSUB(TfV, TfS);
							    TfW = VADD(TfS, TfV);
							    Thd = VSUB(Tgn, Tgk);
							    Tgo = VADD(Tgk, Tgn);
							    ST(&(xo[WS(os, 98)]), VFMAI(TfM, TfL), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 30)]), VFNMSI(TfM, TfL), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 94)]), VFNMSI(TfK, TfH), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 34)]), VFMAI(TfK, TfH), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 2)]), VFMAI(TfE, TfD), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 126)]), VFNMSI(TfE, TfD), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 66)]), VFMAI(TfC, Tfn), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 62)]), VFNMSI(TfC, Tfn), ovs, &(xo[0]));
							    {
								 V Tgd, Tg9, Tg6, Tg4;
								 Tgd = VFNMS(LDK(KP773010453), Tg8, Tg7);
								 Tg9 = VFMA(LDK(KP773010453), Tg8, Tg7);
								 Tg6 = VFMA(LDK(KP773010453), Tg3, Tg0);
								 Tg4 = VFNMS(LDK(KP773010453), Tg3, Tg0);
								 {
								      V Tge, Tgc, Tg5, TfX;
								      Tge = VFMA(LDK(KP773010453), Tgb, Tga);
								      Tgc = VFNMS(LDK(KP773010453), Tgb, Tga);
								      Tg5 = VFMA(LDK(KP773010453), TfW, TfP);
								      TfX = VFNMS(LDK(KP773010453), TfW, TfP);
								      The = VFMA(LDK(KP831469612), Thd, Thc);
								      Tho = VFNMS(LDK(KP831469612), Thd, Thc);
								      TgT = VFMA(LDK(KP831469612), Tgo, Tgh);
								      Tgp = VFNMS(LDK(KP831469612), Tgo, Tgh);
								      ST(&(xo[WS(os, 110)]), VFNMSI(Tge, Tgd), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 18)]), VFMAI(Tge, Tgd), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 82)]), VFMAI(Tgc, Tg9), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 46)]), VFNMSI(Tgc, Tg9), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 114)]), VFMAI(Tg6, Tg5), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 14)]), VFNMSI(Tg6, Tg5), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 50)]), VFMAI(Tg4, TfX), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 78)]), VFNMSI(Tg4, TfX), ovs, &(xo[0]));
								 }
							    }
						       }
						  }
					     }
					}
					{
					     V Th4, Tgs, Tgv, Th5, Tgz, TgC, Th2, TgL;
					     Th4 = VFMA(LDK(KP923879532), Tgr, Tgq);
					     Tgs = VFNMS(LDK(KP923879532), Tgr, Tgq);
					     Tgv = VFMA(LDK(KP923879532), Tgu, Tgt);
					     Th5 = VFNMS(LDK(KP923879532), Tgu, Tgt);
					     Th7 = VFMA(LDK(KP923879532), Tgy, Tgx);
					     Tgz = VFNMS(LDK(KP923879532), Tgy, Tgx);
					     TgC = VFMA(LDK(KP923879532), TgB, TgA);
					     Th8 = VFNMS(LDK(KP923879532), TgB, TgA);
					     Th2 = VADD(TgK, TgJ);
					     TgL = VSUB(TgJ, TgK);
					     {
						  V TgO, Tgw, TgN, TgD;
						  TgO = VFMA(LDK(KP534511135), Tgs, Tgv);
						  Tgw = VFNMS(LDK(KP534511135), Tgv, Tgs);
						  TgN = VFMA(LDK(KP534511135), Tgz, TgC);
						  TgD = VFNMS(LDK(KP534511135), TgC, Tgz);
						  Thg = VFNMS(LDK(KP303346683), Th4, Th5);
						  Th6 = VFMA(LDK(KP303346683), Th5, Th4);
						  Th3 = VFMA(LDK(KP831469612), Th2, Th1);
						  Thl = VFNMS(LDK(KP831469612), Th2, Th1);
						  TgW = VFNMS(LDK(KP831469612), TgL, TgI);
						  TgM = VFMA(LDK(KP831469612), TgL, TgI);
						  TgU = VADD(TgO, TgN);
						  TgP = VSUB(TgN, TgO);
						  TgX = VSUB(TgD, Tgw);
						  TgE = VADD(Tgw, TgD);
					     }
					}
				   }
				   {
					V T8u, T8v, T7R, T8d, T7G, Thm, Thh, Thp, Tha, T7Y, Thr, Thn;
					{
					     V T7y, T7F, TgZ, TgV;
					     T8u = VFNMS(LDK(KP831469612), T7x, T7q);
					     T7y = VFMA(LDK(KP831469612), T7x, T7q);
					     T7F = VFMA(LDK(KP831469612), T7E, T7B);
					     T8v = VFNMS(LDK(KP831469612), T7E, T7B);
					     T8x = VFNMS(LDK(KP831469612), T7Q, T7J);
					     T7R = VFMA(LDK(KP831469612), T7Q, T7J);
					     TgZ = VFMA(LDK(KP881921264), TgU, TgT);
					     TgV = VFNMS(LDK(KP881921264), TgU, TgT);
					     {
						  V TgS, TgQ, Th0, TgY;
						  TgS = VFMA(LDK(KP881921264), TgP, TgM);
						  TgQ = VFNMS(LDK(KP881921264), TgP, TgM);
						  Th0 = VFNMS(LDK(KP881921264), TgX, TgW);
						  TgY = VFMA(LDK(KP881921264), TgX, TgW);
						  {
						       V TgR, TgF, Thf, Th9;
						       TgR = VFMA(LDK(KP881921264), TgE, Tgp);
						       TgF = VFNMS(LDK(KP881921264), TgE, Tgp);
						       Thf = VFNMS(LDK(KP303346683), Th7, Th8);
						       Th9 = VFMA(LDK(KP303346683), Th8, Th7);
						       T8d = VFNMS(LDK(KP148335987), T7y, T7F);
						       T7G = VFMA(LDK(KP148335987), T7F, T7y);
						       ST(&(xo[WS(os, 106)]), VFMAI(Th0, TgZ), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 22)]), VFNMSI(Th0, TgZ), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 86)]), VFNMSI(TgY, TgV), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 42)]), VFMAI(TgY, TgV), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 10)]), VFMAI(TgS, TgR), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 118)]), VFNMSI(TgS, TgR), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 74)]), VFMAI(TgQ, TgF), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 54)]), VFNMSI(TgQ, TgF), ovs, &(xo[0]));
						       Thm = VADD(Thg, Thf);
						       Thh = VSUB(Thf, Thg);
						       Thp = VSUB(Th9, Th6);
						       Tha = VADD(Th6, Th9);
						       T7Y = VFMA(LDK(KP831469612), T7X, T7U);
						       T8y = VFNMS(LDK(KP831469612), T7X, T7U);
						  }
					     }
					}
					Thr = VFNMS(LDK(KP956940335), Thm, Thl);
					Thn = VFMA(LDK(KP956940335), Thm, Thl);
					{
					     V Thk, Thi, Ths, Thq;
					     Thk = VFMA(LDK(KP956940335), Thh, The);
					     Thi = VFNMS(LDK(KP956940335), Thh, The);
					     Ths = VFMA(LDK(KP956940335), Thp, Tho);
					     Thq = VFNMS(LDK(KP956940335), Thp, Tho);
					     {
						  V Thj, Thb, T8e, T7Z;
						  Thj = VFMA(LDK(KP956940335), Tha, Th3);
						  Thb = VFNMS(LDK(KP956940335), Tha, Th3);
						  T8e = VFNMS(LDK(KP148335987), T7R, T7Y);
						  T7Z = VFMA(LDK(KP148335987), T7Y, T7R);
						  T8F = VFMA(LDK(KP741650546), T8u, T8v);
						  T8w = VFNMS(LDK(KP741650546), T8v, T8u);
						  ST(&(xo[WS(os, 102)]), VFNMSI(Ths, Thr), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 26)]), VFMAI(Ths, Thr), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 90)]), VFMAI(Thq, Thn), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 38)]), VFNMSI(Thq, Thn), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 122)]), VFMAI(Thk, Thj), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 6)]), VFNMSI(Thk, Thj), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 58)]), VFMAI(Thi, Thb), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 70)]), VFNMSI(Thi, Thb), ovs, &(xo[0]));
						  T8k = VADD(T8d, T8e);
						  T8f = VSUB(T8d, T8e);
						  T8n = VSUB(T7Z, T7G);
						  T80 = VADD(T7G, T7Z);
					     }
					}
					T9l = VSUB(T75, T72);
					T76 = VADD(T72, T75);
					T87 = VSUB(T85, T86);
					T8U = VADD(T85, T86);
					T89 = VFNMS(LDK(KP303346683), T7a, T7d);
					T7e = VFMA(LDK(KP303346683), T7d, T7a);
					T7l = VFMA(LDK(KP303346683), T7k, T7h);
					T8a = VFNMS(LDK(KP303346683), T7h, T7k);
				   }
			      }
			      {
				   V T11, T5h, T5a, T55, T5d, T4K, T5C, T5x, T5F, T5q, T4X, T4Z, T1C, T2d, T50;
				   {
					V T5k, T3g, T3t, T5l, T5n, T4v, T4I, T5o, T8G, T8z;
					T5k = VFNMS(LDK(KP980785280), T3f, T2G);
					T3g = VFMA(LDK(KP980785280), T3f, T2G);
					T8G = VFMA(LDK(KP741650546), T8x, T8y);
					T8z = VFNMS(LDK(KP741650546), T8y, T8x);
					{
					     V T8r, T77, T8C, T88;
					     T8r = VFNMS(LDK(KP831469612), T76, T6Z);
					     T77 = VFMA(LDK(KP831469612), T76, T6Z);
					     T8C = VFNMS(LDK(KP831469612), T87, T84);
					     T88 = VFMA(LDK(KP831469612), T87, T84);
					     {
						  V T8D, T7m, T8s, T8b;
						  T8D = VSUB(T7l, T7e);
						  T7m = VADD(T7e, T7l);
						  T8s = VADD(T89, T8a);
						  T8b = VSUB(T89, T8a);
						  {
						       V T8M, T8H, T8P, T8A;
						       T8M = VADD(T8F, T8G);
						       T8H = VSUB(T8F, T8G);
						       T8P = VSUB(T8z, T8w);
						       T8A = VADD(T8w, T8z);
						       {
							    V T8E, T8O, T8j, T7n;
							    T8E = VFNMS(LDK(KP956940335), T8D, T8C);
							    T8O = VFMA(LDK(KP956940335), T8D, T8C);
							    T8j = VFNMS(LDK(KP956940335), T7m, T77);
							    T7n = VFMA(LDK(KP956940335), T7m, T77);
							    {
								 V T8t, T8L, T8m, T8c;
								 T8t = VFNMS(LDK(KP956940335), T8s, T8r);
								 T8L = VFMA(LDK(KP956940335), T8s, T8r);
								 T8m = VFNMS(LDK(KP956940335), T8b, T88);
								 T8c = VFMA(LDK(KP956940335), T8b, T88);
								 {
								      V T8K, T8I, T8S, T8Q;
								      T8K = VFMA(LDK(KP803207531), T8H, T8E);
								      T8I = VFNMS(LDK(KP803207531), T8H, T8E);
								      T8S = VFMA(LDK(KP803207531), T8P, T8O);
								      T8Q = VFNMS(LDK(KP803207531), T8P, T8O);
								      {
									   V T8p, T8l, T8h, T81;
									   T8p = VFNMS(LDK(KP989176509), T8k, T8j);
									   T8l = VFMA(LDK(KP989176509), T8k, T8j);
									   T8h = VFMA(LDK(KP989176509), T80, T7n);
									   T81 = VFNMS(LDK(KP989176509), T80, T7n);
									   {
										V T8J, T8B, T8R, T8N;
										T8J = VFMA(LDK(KP803207531), T8A, T8t);
										T8B = VFNMS(LDK(KP803207531), T8A, T8t);
										T8R = VFMA(LDK(KP803207531), T8M, T8L);
										T8N = VFNMS(LDK(KP803207531), T8M, T8L);
										{
										     V T8q, T8o, T8i, T8g;
										     T8q = VFNMS(LDK(KP989176509), T8n, T8m);
										     T8o = VFMA(LDK(KP989176509), T8n, T8m);
										     T8i = VFMA(LDK(KP989176509), T8f, T8c);
										     T8g = VFNMS(LDK(KP989176509), T8f, T8c);
										     ST(&(xo[WS(os, 115)]), VFMAI(T8K, T8J), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 13)]), VFNMSI(T8K, T8J), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 51)]), VFMAI(T8I, T8B), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 77)]), VFNMSI(T8I, T8B), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 109)]), VFNMSI(T8S, T8R), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 19)]), VFMAI(T8S, T8R), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 83)]), VFMAI(T8Q, T8N), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 45)]), VFNMSI(T8Q, T8N), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 99)]), VFMAI(T8q, T8p), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 29)]), VFNMSI(T8q, T8p), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 93)]), VFNMSI(T8o, T8l), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 35)]), VFMAI(T8o, T8l), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 3)]), VFMAI(T8i, T8h), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 125)]), VFNMSI(T8i, T8h), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 67)]), VFMAI(T8g, T81), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 61)]), VFNMSI(T8g, T81), ovs, &(xo[WS(os, 1)]));
										     T3t = VFMA(LDK(KP980785280), T3s, T3p);
										     T5l = VFNMS(LDK(KP980785280), T3s, T3p);
										}
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					}
					T5n = VFNMS(LDK(KP980785280), T4u, T3V);
					T4v = VFMA(LDK(KP980785280), T4u, T3V);
					T4I = VFMA(LDK(KP980785280), T4H, T4E);
					T5o = VFNMS(LDK(KP980785280), T4H, T4E);
					{
					     V T53, T3u, T54, T4J, T5v, T5m, T5w, T5p, T10;
					     T6b = VSUB(TZ, TI);
					     T10 = VADD(TI, TZ);
					     T53 = VFMA(LDK(KP049126849), T3g, T3t);
					     T3u = VFNMS(LDK(KP049126849), T3t, T3g);
					     T54 = VFMA(LDK(KP049126849), T4v, T4I);
					     T4J = VFNMS(LDK(KP049126849), T4I, T4v);
					     T5v = VFNMS(LDK(KP906347169), T5k, T5l);
					     T5m = VFMA(LDK(KP906347169), T5l, T5k);
					     T5w = VFNMS(LDK(KP906347169), T5n, T5o);
					     T5p = VFMA(LDK(KP906347169), T5o, T5n);
					     T11 = VFMA(LDK(KP980785280), T10, Tr);
					     T5h = VFNMS(LDK(KP980785280), T10, Tr);
					     T5a = VADD(T53, T54);
					     T55 = VSUB(T53, T54);
					     T5d = VSUB(T4J, T3u);
					     T4K = VADD(T3u, T4J);
					     T5C = VADD(T5v, T5w);
					     T5x = VSUB(T5v, T5w);
					     T5F = VSUB(T5p, T5m);
					     T5q = VADD(T5m, T5p);
					     T4X = VSUB(T4V, T4W);
					     T5K = VADD(T4V, T4W);
					}
					T4Z = VFMA(LDK(KP098491403), T1s, T1B);
					T1C = VFNMS(LDK(KP098491403), T1B, T1s);
					T2d = VFNMS(LDK(KP098491403), T2c, T23);
					T50 = VFMA(LDK(KP098491403), T23, T2c);
				   }
				   {
					V T9y, T9t, T9B, T9i, T9o, T9n, T9F, T8V, T9Q, T9m, T9R, T92, Ta0, T9V, Ta3;
					V T9O;
					{
					     V T9I, T9J, T9L, T9d, T5s, T4Y, T5t, T2e, T5i, T51, T9r, T9a, T9g, T9M, T96;
					     V T99;
					     T9I = VFMA(LDK(KP831469612), T95, T94);
					     T96 = VFNMS(LDK(KP831469612), T95, T94);
					     T99 = VFNMS(LDK(KP831469612), T98, T97);
					     T9J = VFMA(LDK(KP831469612), T98, T97);
					     T9L = VFMA(LDK(KP831469612), T9c, T9b);
					     T9d = VFNMS(LDK(KP831469612), T9c, T9b);
					     T5s = VFNMS(LDK(KP980785280), T4X, T4U);
					     T4Y = VFMA(LDK(KP980785280), T4X, T4U);
					     T5t = VSUB(T2d, T1C);
					     T2e = VADD(T1C, T2d);
					     T5i = VADD(T4Z, T50);
					     T51 = VSUB(T4Z, T50);
					     T9r = VFNMS(LDK(KP599376933), T96, T99);
					     T9a = VFMA(LDK(KP599376933), T99, T96);
					     T9g = VFNMS(LDK(KP831469612), T9f, T9e);
					     T9M = VFMA(LDK(KP831469612), T9f, T9e);
					     {
						  V T5u, T5E, T8Y, T91;
						  T5u = VFMA(LDK(KP995184726), T5t, T5s);
						  T5E = VFNMS(LDK(KP995184726), T5t, T5s);
						  {
						       V T59, T2f, T5j, T5B;
						       T59 = VFNMS(LDK(KP995184726), T2e, T11);
						       T2f = VFMA(LDK(KP995184726), T2e, T11);
						       T5j = VFMA(LDK(KP995184726), T5i, T5h);
						       T5B = VFNMS(LDK(KP995184726), T5i, T5h);
						       {
							    V T5c, T52, T9s, T9h;
							    T5c = VFNMS(LDK(KP995184726), T51, T4Y);
							    T52 = VFMA(LDK(KP995184726), T51, T4Y);
							    T9s = VFNMS(LDK(KP599376933), T9d, T9g);
							    T9h = VFMA(LDK(KP599376933), T9g, T9d);
							    {
								 V T5A, T5y, T5I, T5G;
								 T5A = VFMA(LDK(KP740951125), T5x, T5u);
								 T5y = VFNMS(LDK(KP740951125), T5x, T5u);
								 T5I = VFNMS(LDK(KP740951125), T5F, T5E);
								 T5G = VFMA(LDK(KP740951125), T5F, T5E);
								 {
								      V T5f, T5b, T57, T4L;
								      T5f = VFMA(LDK(KP998795456), T5a, T59);
								      T5b = VFNMS(LDK(KP998795456), T5a, T59);
								      T57 = VFMA(LDK(KP998795456), T4K, T2f);
								      T4L = VFNMS(LDK(KP998795456), T4K, T2f);
								      {
									   V T5z, T5r, T5H, T5D;
									   T5z = VFMA(LDK(KP740951125), T5q, T5j);
									   T5r = VFNMS(LDK(KP740951125), T5q, T5j);
									   T5H = VFNMS(LDK(KP740951125), T5C, T5B);
									   T5D = VFMA(LDK(KP740951125), T5C, T5B);
									   {
										V T5g, T5e, T58, T56;
										T5g = VFMA(LDK(KP998795456), T5d, T5c);
										T5e = VFNMS(LDK(KP998795456), T5d, T5c);
										T58 = VFMA(LDK(KP998795456), T55, T52);
										T56 = VFNMS(LDK(KP998795456), T55, T52);
										T9y = VADD(T9r, T9s);
										T9t = VSUB(T9r, T9s);
										T9B = VSUB(T9h, T9a);
										T9i = VADD(T9a, T9h);
										ST(&(xo[WS(os, 15)]), VFMAI(T5A, T5z), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 113)]), VFNMSI(T5A, T5z), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 79)]), VFMAI(T5y, T5r), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 49)]), VFNMSI(T5y, T5r), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 111)]), VFMAI(T5I, T5H), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 17)]), VFNMSI(T5I, T5H), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 81)]), VFNMSI(T5G, T5D), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 47)]), VFMAI(T5G, T5D), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 97)]), VFNMSI(T5g, T5f), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 31)]), VFMAI(T5g, T5f), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 95)]), VFMAI(T5e, T5b), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 33)]), VFNMSI(T5e, T5b), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 127)]), VFMAI(T58, T57), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 1)]), VFNMSI(T58, T57), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 63)]), VFMAI(T56, T4L), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 65)]), VFNMSI(T56, T4L), ovs, &(xo[WS(os, 1)]));
									   }
								      }
								 }
							    }
						       }
						  }
						  T9o = VFNMS(LDK(KP534511135), T8W, T8X);
						  T8Y = VFMA(LDK(KP534511135), T8X, T8W);
						  T91 = VFMA(LDK(KP534511135), T90, T8Z);
						  T9n = VFNMS(LDK(KP534511135), T8Z, T90);
						  {
						       V T9T, T9K, T9U, T9N;
						       T9T = VFMA(LDK(KP250486960), T9I, T9J);
						       T9K = VFNMS(LDK(KP250486960), T9J, T9I);
						       T9U = VFMA(LDK(KP250486960), T9L, T9M);
						       T9N = VFNMS(LDK(KP250486960), T9M, T9L);
						       T9F = VFNMS(LDK(KP831469612), T8U, T8T);
						       T8V = VFMA(LDK(KP831469612), T8U, T8T);
						       T9Q = VFNMS(LDK(KP831469612), T9l, T9k);
						       T9m = VFMA(LDK(KP831469612), T9l, T9k);
						       T9R = VSUB(T8Y, T91);
						       T92 = VADD(T8Y, T91);
						       Ta0 = VADD(T9T, T9U);
						       T9V = VSUB(T9T, T9U);
						       Ta3 = VSUB(T9N, T9K);
						       T9O = VADD(T9K, T9N);
						  }
					     }
					}
					{
					     V T6y, T6z, T63, T9Y, T9W, Ta6, Ta4, T9D, T9z, T9v, T9j, T6h, T60, T9H, T9Z;
					     V T9A, T9q, T66, T9X, T9P;
					     {
						  V T5W, T9S, Ta2, T9x, T93, T5Z, T9G, T9p;
						  T6y = VFMA(LDK(KP980785280), T5V, T5U);
						  T5W = VFNMS(LDK(KP980785280), T5V, T5U);
						  T9S = VFMA(LDK(KP881921264), T9R, T9Q);
						  Ta2 = VFNMS(LDK(KP881921264), T9R, T9Q);
						  T9x = VFNMS(LDK(KP881921264), T92, T8V);
						  T93 = VFMA(LDK(KP881921264), T92, T8V);
						  T5Z = VFMA(LDK(KP980785280), T5Y, T5X);
						  T6z = VFNMS(LDK(KP980785280), T5Y, T5X);
						  T6B = VFMA(LDK(KP980785280), T62, T61);
						  T63 = VFNMS(LDK(KP980785280), T62, T61);
						  T9G = VADD(T9o, T9n);
						  T9p = VSUB(T9n, T9o);
						  T9Y = VFMA(LDK(KP970031253), T9V, T9S);
						  T9W = VFNMS(LDK(KP970031253), T9V, T9S);
						  Ta6 = VFMA(LDK(KP970031253), Ta3, Ta2);
						  Ta4 = VFNMS(LDK(KP970031253), Ta3, Ta2);
						  T9D = VFNMS(LDK(KP857728610), T9y, T9x);
						  T9z = VFMA(LDK(KP857728610), T9y, T9x);
						  T9v = VFMA(LDK(KP857728610), T9i, T93);
						  T9j = VFNMS(LDK(KP857728610), T9i, T93);
						  T6h = VFMA(LDK(KP472964775), T5W, T5Z);
						  T60 = VFNMS(LDK(KP472964775), T5Z, T5W);
						  T9H = VFMA(LDK(KP881921264), T9G, T9F);
						  T9Z = VFNMS(LDK(KP881921264), T9G, T9F);
						  T9A = VFNMS(LDK(KP881921264), T9p, T9m);
						  T9q = VFMA(LDK(KP881921264), T9p, T9m);
						  T66 = VFMA(LDK(KP980785280), T65, T64);
						  T6C = VFNMS(LDK(KP980785280), T65, T64);
					     }
					     T9X = VFMA(LDK(KP970031253), T9O, T9H);
					     T9P = VFNMS(LDK(KP970031253), T9O, T9H);
					     {
						  V Ta5, Ta1, T9E, T9C;
						  Ta5 = VFMA(LDK(KP970031253), Ta0, T9Z);
						  Ta1 = VFNMS(LDK(KP970031253), Ta0, T9Z);
						  T9E = VFNMS(LDK(KP857728610), T9B, T9A);
						  T9C = VFMA(LDK(KP857728610), T9B, T9A);
						  {
						       V T9w, T9u, T6i, T67;
						       T9w = VFMA(LDK(KP857728610), T9t, T9q);
						       T9u = VFNMS(LDK(KP857728610), T9t, T9q);
						       T6i = VFMA(LDK(KP472964775), T63, T66);
						       T67 = VFNMS(LDK(KP472964775), T66, T63);
						       T6J = VFNMS(LDK(KP357805721), T6y, T6z);
						       T6A = VFMA(LDK(KP357805721), T6z, T6y);
						       ST(&(xo[WS(os, 123)]), VFMAI(T9Y, T9X), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 5)]), VFNMSI(T9Y, T9X), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 59)]), VFMAI(T9W, T9P), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 69)]), VFNMSI(T9W, T9P), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 101)]), VFNMSI(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 27)]), VFMAI(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 91)]), VFMAI(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 37)]), VFNMSI(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 107)]), VFMAI(T9E, T9D), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 21)]), VFNMSI(T9E, T9D), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 85)]), VFNMSI(T9C, T9z), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 43)]), VFMAI(T9C, T9z), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 11)]), VFMAI(T9w, T9v), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 117)]), VFNMSI(T9w, T9v), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 75)]), VFMAI(T9u, T9j), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 53)]), VFNMSI(T9u, T9j), ovs, &(xo[WS(os, 1)]));
						       T6o = VADD(T6h, T6i);
						       T6j = VSUB(T6h, T6i);
						       T6r = VSUB(T67, T60);
						       T68 = VADD(T60, T67);
						  }
					     }
					     T6e = VFMA(LDK(KP820678790), T5M, T5N);
					     T5O = VFNMS(LDK(KP820678790), T5N, T5M);
					     T5R = VFNMS(LDK(KP820678790), T5Q, T5P);
					     T6d = VFMA(LDK(KP820678790), T5P, T5Q);
					}
				   }
			      }
			 }
		    }
	       }
	       T6D = VFMA(LDK(KP357805721), T6C, T6B);
	       T6K = VFNMS(LDK(KP357805721), T6B, T6C);
	       {
		    V T5L, T6v, T6c, T6G;
		    T5L = VFNMS(LDK(KP980785280), T5K, T5J);
		    T6v = VFMA(LDK(KP980785280), T5K, T5J);
		    T6c = VFNMS(LDK(KP980785280), T6b, T6a);
		    T6G = VFMA(LDK(KP980785280), T6b, T6a);
		    {
			 V T5S, T6H, T6f, T6w;
			 T5S = VADD(T5O, T5R);
			 T6H = VSUB(T5O, T5R);
			 T6f = VSUB(T6d, T6e);
			 T6w = VADD(T6e, T6d);
			 {
			      V T6L, T6Q, T6E, T6T;
			      T6L = VSUB(T6J, T6K);
			      T6Q = VADD(T6J, T6K);
			      T6E = VADD(T6A, T6D);
			      T6T = VSUB(T6D, T6A);
			      {
				   V T6S, T6I, T5T, T6n;
				   T6S = VFNMS(LDK(KP773010453), T6H, T6G);
				   T6I = VFMA(LDK(KP773010453), T6H, T6G);
				   T5T = VFNMS(LDK(KP773010453), T5S, T5L);
				   T6n = VFMA(LDK(KP773010453), T5S, T5L);
				   {
					V T6P, T6x, T6g, T6q;
					T6P = VFNMS(LDK(KP773010453), T6w, T6v);
					T6x = VFMA(LDK(KP773010453), T6w, T6v);
					T6g = VFNMS(LDK(KP773010453), T6f, T6c);
					T6q = VFMA(LDK(KP773010453), T6f, T6c);
					{
					     V T6M, T6O, T6U, T6W;
					     T6M = VFNMS(LDK(KP941544065), T6L, T6I);
					     T6O = VFMA(LDK(KP941544065), T6L, T6I);
					     T6U = VFMA(LDK(KP941544065), T6T, T6S);
					     T6W = VFNMS(LDK(KP941544065), T6T, T6S);
					     {
						  V T6p, T6t, T69, T6l;
						  T6p = VFNMS(LDK(KP903989293), T6o, T6n);
						  T6t = VFMA(LDK(KP903989293), T6o, T6n);
						  T69 = VFNMS(LDK(KP903989293), T68, T5T);
						  T6l = VFMA(LDK(KP903989293), T68, T5T);
						  {
						       V T6F, T6N, T6R, T6V;
						       T6F = VFNMS(LDK(KP941544065), T6E, T6x);
						       T6N = VFMA(LDK(KP941544065), T6E, T6x);
						       T6R = VFMA(LDK(KP941544065), T6Q, T6P);
						       T6V = VFNMS(LDK(KP941544065), T6Q, T6P);
						       {
							    V T6s, T6u, T6k, T6m;
							    T6s = VFNMS(LDK(KP903989293), T6r, T6q);
							    T6u = VFMA(LDK(KP903989293), T6r, T6q);
							    T6k = VFNMS(LDK(KP903989293), T6j, T6g);
							    T6m = VFMA(LDK(KP903989293), T6j, T6g);
							    ST(&(xo[WS(os, 7)]), VFMAI(T6O, T6N), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 121)]), VFNMSI(T6O, T6N), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 71)]), VFMAI(T6M, T6F), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 57)]), VFNMSI(T6M, T6F), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 103)]), VFMAI(T6W, T6V), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 25)]), VFNMSI(T6W, T6V), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 89)]), VFNMSI(T6U, T6R), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 39)]), VFMAI(T6U, T6R), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 105)]), VFNMSI(T6u, T6t), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 23)]), VFMAI(T6u, T6t), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 87)]), VFMAI(T6s, T6p), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 41)]), VFNMSI(T6s, T6p), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 119)]), VFMAI(T6m, T6l), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 9)]), VFNMSI(T6m, T6l), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 55)]), VFMAI(T6k, T69), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 73)]), VFNMSI(T6k, T69), ovs, &(xo[WS(os, 1)]));
						       }
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 128, XSIMD_STRING("n1fv_128"), {440, 0, 642, 0}, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1fv_128) (planner *p) {
     X(kdft_register) (p, n1fv_128, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_notw_c.native -simd -compact -variables 4 -pipeline-latency 8 -n 128 -name n1fv_128 -include n1f.h */

/*
 * This function contains 1082 FP additions, 330 FP multiplications,
 * (or, 938 additions, 186 multiplications, 144 fused multiply/add),
 * 194 stack variables, 31 constants, and 256 memory accesses
 */
#include "n1f.h"

static void n1fv_128(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DVK(KP336889853, +0.336889853392220050689253212619147570477766780);
     DVK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DVK(KP427555093, +0.427555093430282094320966856888798534304578629);
     DVK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DVK(KP242980179, +0.242980179903263889948274162077471118320990783);
     DVK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DVK(KP514102744, +0.514102744193221726593693838968815772608049120);
     DVK(KP671558954, +0.671558954847018400625376850427421803228750632);
     DVK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DVK(KP049067674, +0.049067674327418014254954976942682658314745363);
     DVK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DVK(KP595699304, +0.595699304492433343467036528829969889511926338);
     DVK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DVK(KP146730474, +0.146730474455361751658850129646717819706215317);
     DVK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V Tr, T5J, Ted, Tgf, Tfq, TgH, T4U, T6b, T6Z, T8T, Tad, TcZ, Tcc, Td0, T84;
	       V T9l, Tb6, Tbt, T2G, T5X, TeV, Tgr, T3p, T5V, T7B, T95, TeK, Tgt, T7q, T97;
	       V Td8, TdK, TbD, Tc0, T3V, T61, Tfg, TgB, T4E, T65, T7U, T9f, Tf5, Tgx, T7J;
	       V T9b, Tdf, TdN, Td2, Td3, TI, T4V, Tft, Tgg, TZ, T4W, T75, T86, Tek, TgG;
	       V T72, T85, Tas, Tcd, Tdp, Tdq, TdG, Teq, Tgm, Tet, Tgl, T1s, T5P, T1B, T5Q;
	       V T7d, T8Z, TaI, Tcf, T7a, T90, Tdm, Tdn, TdH, Tez, Tgi, TeC, Tgj, T23, T5N;
	       V T2c, T5M, T7k, T8X, TaX, Tcg, T7h, T8W, Tbl, Tbu, Tdb, TdL, TeY, Tgu, TeR;
	       V Tgq, T7x, T98, T7E, T94, T3f, T5Y, T3s, T5U, TbS, Tc1, Tdi, TdO, Tfj, Tgy;
	       V Tfc, TgA, T7Q, T9e, T7X, T9c, T4u, T64, T4H, T62;
	       {
		    V T3, Ta7, T4P, Ta8, Ta, Tab, T4M, Taa, Tc9, Tca, Ti, Tea, T4S, Tc6, Tc7;
		    V Tp, Teb, T4R;
		    {
			 V T1, T2, T4N, T4O;
			 T1 = LD(&(xi[0]), ivs, &(xi[0]));
			 T2 = LD(&(xi[WS(is, 64)]), ivs, &(xi[0]));
			 T3 = VSUB(T1, T2);
			 Ta7 = VADD(T1, T2);
			 T4N = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
			 T4O = LD(&(xi[WS(is, 96)]), ivs, &(xi[0]));
			 T4P = VSUB(T4N, T4O);
			 Ta8 = VADD(T4N, T4O);
		    }
		    {
			 V T4, T5, T6, T7, T8, T9;
			 T4 = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
			 T5 = LD(&(xi[WS(is, 80)]), ivs, &(xi[0]));
			 T6 = VSUB(T4, T5);
			 T7 = LD(&(xi[WS(is, 112)]), ivs, &(xi[0]));
			 T8 = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
			 T9 = VSUB(T7, T8);
			 Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
			 Tab = VADD(T7, T8);
			 T4M = VMUL(LDK(KP707106781), VSUB(T9, T6));
			 Taa = VADD(T4, T5);
		    }
		    {
			 V Te, Th, Tl, To;
			 {
			      V Tc, Td, Tf, Tg;
			      Tc = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			      Td = LD(&(xi[WS(is, 72)]), ivs, &(xi[0]));
			      Te = VSUB(Tc, Td);
			      Tc9 = VADD(Tc, Td);
			      Tf = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
			      Tg = LD(&(xi[WS(is, 104)]), ivs, &(xi[0]));
			      Th = VSUB(Tf, Tg);
			      Tca = VADD(Tf, Tg);
			 }
			 Ti = VFNMS(LDK(KP382683432), Th, VMUL(LDK(KP923879532), Te));
			 Tea = VSUB(Tc9, Tca);
			 T4S = VFMA(LDK(KP382683432), Te, VMUL(LDK(KP923879532), Th));
			 {
			      V Tj, Tk, Tm, Tn;
			      Tj = LD(&(xi[WS(is, 120)]), ivs, &(xi[0]));
			      Tk = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
			      Tl = VSUB(Tj, Tk);
			      Tc6 = VADD(Tj, Tk);
			      Tm = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
			      Tn = LD(&(xi[WS(is, 88)]), ivs, &(xi[0]));
			      To = VSUB(Tm, Tn);
			      Tc7 = VADD(Tm, Tn);
			 }
			 Tp = VFMA(LDK(KP923879532), Tl, VMUL(LDK(KP382683432), To));
			 Teb = VSUB(Tc6, Tc7);
			 T4R = VFNMS(LDK(KP923879532), To, VMUL(LDK(KP382683432), Tl));
		    }
		    {
			 V Tb, Tq, Te9, Tec;
			 Tb = VADD(T3, Ta);
			 Tq = VADD(Ti, Tp);
			 Tr = VADD(Tb, Tq);
			 T5J = VSUB(Tb, Tq);
			 Te9 = VSUB(Ta7, Ta8);
			 Tec = VMUL(LDK(KP707106781), VADD(Tea, Teb));
			 Ted = VADD(Te9, Tec);
			 Tgf = VSUB(Te9, Tec);
		    }
		    {
			 V Tfo, Tfp, T4Q, T4T;
			 Tfo = VSUB(Tab, Taa);
			 Tfp = VMUL(LDK(KP707106781), VSUB(Teb, Tea));
			 Tfq = VADD(Tfo, Tfp);
			 TgH = VSUB(Tfp, Tfo);
			 T4Q = VSUB(T4M, T4P);
			 T4T = VSUB(T4R, T4S);
			 T4U = VADD(T4Q, T4T);
			 T6b = VSUB(T4T, T4Q);
		    }
		    {
			 V T6X, T6Y, Ta9, Tac;
			 T6X = VSUB(T3, Ta);
			 T6Y = VADD(T4S, T4R);
			 T6Z = VADD(T6X, T6Y);
			 T8T = VSUB(T6X, T6Y);
			 Ta9 = VADD(Ta7, Ta8);
			 Tac = VADD(Taa, Tab);
			 Tad = VSUB(Ta9, Tac);
			 TcZ = VADD(Ta9, Tac);
		    }
		    {
			 V Tc8, Tcb, T82, T83;
			 Tc8 = VADD(Tc6, Tc7);
			 Tcb = VADD(Tc9, Tca);
			 Tcc = VSUB(Tc8, Tcb);
			 Td0 = VADD(Tcb, Tc8);
			 T82 = VADD(T4P, T4M);
			 T83 = VSUB(Tp, Ti);
			 T84 = VADD(T82, T83);
			 T9l = VSUB(T83, T82);
		    }
	       }
	       {
		    V Tb0, Tb1, T2i, Tb2, T3k, Tb3, Tb4, T2p, Tb5, T3h, T2x, TeH, T3n, Tbs, T2E;
		    V TeI, T3m, Tbp, T2l, T2o, TeG, TeJ;
		    {
			 V T2g, T2h, T3i, T3j;
			 T2g = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 T2h = LD(&(xi[WS(is, 65)]), ivs, &(xi[WS(is, 1)]));
			 Tb0 = VADD(T2g, T2h);
			 T3i = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
			 T3j = LD(&(xi[WS(is, 97)]), ivs, &(xi[WS(is, 1)]));
			 Tb1 = VADD(T3i, T3j);
			 T2i = VSUB(T2g, T2h);
			 Tb2 = VADD(Tb0, Tb1);
			 T3k = VSUB(T3i, T3j);
		    }
		    {
			 V T2j, T2k, T2m, T2n;
			 T2j = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
			 T2k = LD(&(xi[WS(is, 81)]), ivs, &(xi[WS(is, 1)]));
			 T2l = VSUB(T2j, T2k);
			 Tb3 = VADD(T2j, T2k);
			 T2m = LD(&(xi[WS(is, 113)]), ivs, &(xi[WS(is, 1)]));
			 T2n = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
			 T2o = VSUB(T2m, T2n);
			 Tb4 = VADD(T2m, T2n);
		    }
		    T2p = VMUL(LDK(KP707106781), VADD(T2l, T2o));
		    Tb5 = VADD(Tb3, Tb4);
		    T3h = VMUL(LDK(KP707106781), VSUB(T2o, T2l));
		    {
			 V T2t, Tbq, T2w, Tbr;
			 {
			      V T2r, T2s, T2u, T2v;
			      T2r = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
			      T2s = LD(&(xi[WS(is, 73)]), ivs, &(xi[WS(is, 1)]));
			      T2t = VSUB(T2r, T2s);
			      Tbq = VADD(T2r, T2s);
			      T2u = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
			      T2v = LD(&(xi[WS(is, 105)]), ivs, &(xi[WS(is, 1)]));
			      T2w = VSUB(T2u, T2v);
			      Tbr = VADD(T2u, T2v);
			 }
			 T2x = VFNMS(LDK(KP382683432), T2w, VMUL(LDK(KP923879532), T2t));
			 TeH = VSUB(Tbq, Tbr);
			 T3n = VFMA(LDK(KP382683432), T2t, VMUL(LDK(KP923879532), T2w));
			 Tbs = VADD(Tbq, Tbr);
		    }
		    {
			 V T2A, Tbn, T2D, Tbo;
			 {
			      V T2y, T2z, T2B, T2C;
			      T2y = LD(&(xi[WS(is, 121)]), ivs, &(xi[WS(is, 1)]));
			      T2z = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
			      T2A = VSUB(T2y, T2z);
			      Tbn = VADD(T2y, T2z);
			      T2B = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
			      T2C = LD(&(xi[WS(is, 89)]), ivs, &(xi[WS(is, 1)]));
			      T2D = VSUB(T2B, T2C);
			      Tbo = VADD(T2B, T2C);
			 }
			 T2E = VFMA(LDK(KP923879532), T2A, VMUL(LDK(KP382683432), T2D));
			 TeI = VSUB(Tbn, Tbo);
			 T3m = VFNMS(LDK(KP923879532), T2D, VMUL(LDK(KP382683432), T2A));
			 Tbp = VADD(Tbn, Tbo);
		    }
		    Tb6 = VSUB(Tb2, Tb5);
		    Tbt = VSUB(Tbp, Tbs);
		    {
			 V T2q, T2F, TeT, TeU;
			 T2q = VADD(T2i, T2p);
			 T2F = VADD(T2x, T2E);
			 T2G = VADD(T2q, T2F);
			 T5X = VSUB(T2q, T2F);
			 TeT = VSUB(Tb4, Tb3);
			 TeU = VMUL(LDK(KP707106781), VSUB(TeI, TeH));
			 TeV = VADD(TeT, TeU);
			 Tgr = VSUB(TeU, TeT);
		    }
		    {
			 V T3l, T3o, T7z, T7A;
			 T3l = VSUB(T3h, T3k);
			 T3o = VSUB(T3m, T3n);
			 T3p = VADD(T3l, T3o);
			 T5V = VSUB(T3o, T3l);
			 T7z = VADD(T3k, T3h);
			 T7A = VSUB(T2E, T2x);
			 T7B = VADD(T7z, T7A);
			 T95 = VSUB(T7A, T7z);
		    }
		    TeG = VSUB(Tb0, Tb1);
		    TeJ = VMUL(LDK(KP707106781), VADD(TeH, TeI));
		    TeK = VADD(TeG, TeJ);
		    Tgt = VSUB(TeG, TeJ);
		    {
			 V T7o, T7p, Td6, Td7;
			 T7o = VSUB(T2i, T2p);
			 T7p = VADD(T3n, T3m);
			 T7q = VADD(T7o, T7p);
			 T97 = VSUB(T7o, T7p);
			 Td6 = VADD(Tb2, Tb5);
			 Td7 = VADD(Tbs, Tbp);
			 Td8 = VADD(Td6, Td7);
			 TdK = VSUB(Td6, Td7);
		    }
	       }
	       {
		    V Tbx, Tby, T3x, Tbz, T4z, TbA, TbB, T3E, TbC, T4w, T3M, Tf2, T4C, TbZ, T3T;
		    V Tf3, T4B, TbW, T3A, T3D, Tf1, Tf4;
		    {
			 V T3v, T3w, T4x, T4y;
			 T3v = LD(&(xi[WS(is, 127)]), ivs, &(xi[WS(is, 1)]));
			 T3w = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
			 Tbx = VADD(T3v, T3w);
			 T4x = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
			 T4y = LD(&(xi[WS(is, 95)]), ivs, &(xi[WS(is, 1)]));
			 Tby = VADD(T4x, T4y);
			 T3x = VSUB(T3v, T3w);
			 Tbz = VADD(Tbx, Tby);
			 T4z = VSUB(T4x, T4y);
		    }
		    {
			 V T3y, T3z, T3B, T3C;
			 T3y = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
			 T3z = LD(&(xi[WS(is, 79)]), ivs, &(xi[WS(is, 1)]));
			 T3A = VSUB(T3y, T3z);
			 TbA = VADD(T3y, T3z);
			 T3B = LD(&(xi[WS(is, 111)]), ivs, &(xi[WS(is, 1)]));
			 T3C = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
			 T3D = VSUB(T3B, T3C);
			 TbB = VADD(T3B, T3C);
		    }
		    T3E = VMUL(LDK(KP707106781), VADD(T3A, T3D));
		    TbC = VADD(TbA, TbB);
		    T4w = VMUL(LDK(KP707106781), VSUB(T3D, T3A));
		    {
			 V T3I, TbX, T3L, TbY;
			 {
			      V T3G, T3H, T3J, T3K;
			      T3G = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			      T3H = LD(&(xi[WS(is, 71)]), ivs, &(xi[WS(is, 1)]));
			      T3I = VSUB(T3G, T3H);
			      TbX = VADD(T3G, T3H);
			      T3J = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
			      T3K = LD(&(xi[WS(is, 103)]), ivs, &(xi[WS(is, 1)]));
			      T3L = VSUB(T3J, T3K);
			      TbY = VADD(T3J, T3K);
			 }
			 T3M = VFNMS(LDK(KP382683432), T3L, VMUL(LDK(KP923879532), T3I));
			 Tf2 = VSUB(TbX, TbY);
			 T4C = VFMA(LDK(KP382683432), T3I, VMUL(LDK(KP923879532), T3L));
			 TbZ = VADD(TbX, TbY);
		    }
		    {
			 V T3P, TbU, T3S, TbV;
			 {
			      V T3N, T3O, T3Q, T3R;
			      T3N = LD(&(xi[WS(is, 119)]), ivs, &(xi[WS(is, 1)]));
			      T3O = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
			      T3P = VSUB(T3N, T3O);
			      TbU = VADD(T3N, T3O);
			      T3Q = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
			      T3R = LD(&(xi[WS(is, 87)]), ivs, &(xi[WS(is, 1)]));
			      T3S = VSUB(T3Q, T3R);
			      TbV = VADD(T3Q, T3R);
			 }
			 T3T = VFMA(LDK(KP923879532), T3P, VMUL(LDK(KP382683432), T3S));
			 Tf3 = VSUB(TbU, TbV);
			 T4B = VFNMS(LDK(KP923879532), T3S, VMUL(LDK(KP382683432), T3P));
			 TbW = VADD(TbU, TbV);
		    }
		    TbD = VSUB(Tbz, TbC);
		    Tc0 = VSUB(TbW, TbZ);
		    {
			 V T3F, T3U, Tfe, Tff;
			 T3F = VADD(T3x, T3E);
			 T3U = VADD(T3M, T3T);
			 T3V = VADD(T3F, T3U);
			 T61 = VSUB(T3F, T3U);
			 Tfe = VSUB(TbB, TbA);
			 Tff = VMUL(LDK(KP707106781), VSUB(Tf3, Tf2));
			 Tfg = VADD(Tfe, Tff);
			 TgB = VSUB(Tff, Tfe);
		    }
		    {
			 V T4A, T4D, T7S, T7T;
			 T4A = VSUB(T4w, T4z);
			 T4D = VSUB(T4B, T4C);
			 T4E = VADD(T4A, T4D);
			 T65 = VSUB(T4D, T4A);
			 T7S = VADD(T4z, T4w);
			 T7T = VSUB(T3T, T3M);
			 T7U = VADD(T7S, T7T);
			 T9f = VSUB(T7T, T7S);
		    }
		    Tf1 = VSUB(Tbx, Tby);
		    Tf4 = VMUL(LDK(KP707106781), VADD(Tf2, Tf3));
		    Tf5 = VADD(Tf1, Tf4);
		    Tgx = VSUB(Tf1, Tf4);
		    {
			 V T7H, T7I, Tdd, Tde;
			 T7H = VSUB(T3x, T3E);
			 T7I = VADD(T4C, T4B);
			 T7J = VADD(T7H, T7I);
			 T9b = VSUB(T7H, T7I);
			 Tdd = VADD(Tbz, TbC);
			 Tde = VADD(TbZ, TbW);
			 Tdf = VADD(Tdd, Tde);
			 TdN = VSUB(Tdd, Tde);
		    }
	       }
	       {
		    V Tu, Tee, TG, Tag, TL, Teh, TX, Tan, TB, Tef, TD, Taj, TS, Tei, TU;
		    V Taq, Teg, Tej;
		    {
			 V Ts, Tt, Tae, TE, TF, Taf;
			 Ts = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 Tt = LD(&(xi[WS(is, 68)]), ivs, &(xi[0]));
			 Tae = VADD(Ts, Tt);
			 TE = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
			 TF = LD(&(xi[WS(is, 100)]), ivs, &(xi[0]));
			 Taf = VADD(TE, TF);
			 Tu = VSUB(Ts, Tt);
			 Tee = VSUB(Tae, Taf);
			 TG = VSUB(TE, TF);
			 Tag = VADD(Tae, Taf);
		    }
		    {
			 V TJ, TK, Tal, TV, TW, Tam;
			 TJ = LD(&(xi[WS(is, 124)]), ivs, &(xi[0]));
			 TK = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
			 Tal = VADD(TJ, TK);
			 TV = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
			 TW = LD(&(xi[WS(is, 92)]), ivs, &(xi[0]));
			 Tam = VADD(TV, TW);
			 TL = VSUB(TJ, TK);
			 Teh = VSUB(Tal, Tam);
			 TX = VSUB(TV, TW);
			 Tan = VADD(Tal, Tam);
		    }
		    {
			 V Tx, Tah, TA, Tai;
			 {
			      V Tv, Tw, Ty, Tz;
			      Tv = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
			      Tw = LD(&(xi[WS(is, 84)]), ivs, &(xi[0]));
			      Tx = VSUB(Tv, Tw);
			      Tah = VADD(Tv, Tw);
			      Ty = LD(&(xi[WS(is, 116)]), ivs, &(xi[0]));
			      Tz = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
			      TA = VSUB(Ty, Tz);
			      Tai = VADD(Ty, Tz);
			 }
			 TB = VMUL(LDK(KP707106781), VADD(Tx, TA));
			 Tef = VSUB(Tai, Tah);
			 TD = VMUL(LDK(KP707106781), VSUB(TA, Tx));
			 Taj = VADD(Tah, Tai);
		    }
		    {
			 V TO, Tao, TR, Tap;
			 {
			      V TM, TN, TP, TQ;
			      TM = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
			      TN = LD(&(xi[WS(is, 76)]), ivs, &(xi[0]));
			      TO = VSUB(TM, TN);
			      Tao = VADD(TM, TN);
			      TP = LD(&(xi[WS(is, 108)]), ivs, &(xi[0]));
			      TQ = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
			      TR = VSUB(TP, TQ);
			      Tap = VADD(TP, TQ);
			 }
			 TS = VMUL(LDK(KP707106781), VADD(TO, TR));
			 Tei = VSUB(Tap, Tao);
			 TU = VMUL(LDK(KP707106781), VSUB(TR, TO));
			 Taq = VADD(Tao, Tap);
		    }
		    Td2 = VADD(Tag, Taj);
		    Td3 = VADD(Tan, Taq);
		    {
			 V TC, TH, Tfr, Tfs;
			 TC = VADD(Tu, TB);
			 TH = VSUB(TD, TG);
			 TI = VFMA(LDK(KP980785280), TC, VMUL(LDK(KP195090322), TH));
			 T4V = VFNMS(LDK(KP195090322), TC, VMUL(LDK(KP980785280), TH));
			 Tfr = VFNMS(LDK(KP382683432), Tee, VMUL(LDK(KP923879532), Tef));
			 Tfs = VFMA(LDK(KP382683432), Teh, VMUL(LDK(KP923879532), Tei));
			 Tft = VADD(Tfr, Tfs);
			 Tgg = VSUB(Tfs, Tfr);
		    }
		    {
			 V TT, TY, T73, T74;
			 TT = VADD(TL, TS);
			 TY = VSUB(TU, TX);
			 TZ = VFNMS(LDK(KP195090322), TY, VMUL(LDK(KP980785280), TT));
			 T4W = VFMA(LDK(KP195090322), TT, VMUL(LDK(KP980785280), TY));
			 T73 = VSUB(TL, TS);
			 T74 = VADD(TX, TU);
			 T75 = VFNMS(LDK(KP555570233), T74, VMUL(LDK(KP831469612), T73));
			 T86 = VFMA(LDK(KP555570233), T73, VMUL(LDK(KP831469612), T74));
		    }
		    Teg = VFMA(LDK(KP923879532), Tee, VMUL(LDK(KP382683432), Tef));
		    Tej = VFNMS(LDK(KP382683432), Tei, VMUL(LDK(KP923879532), Teh));
		    Tek = VADD(Teg, Tej);
		    TgG = VSUB(Tej, Teg);
		    {
			 V T70, T71, Tak, Tar;
			 T70 = VSUB(Tu, TB);
			 T71 = VADD(TG, TD);
			 T72 = VFMA(LDK(KP831469612), T70, VMUL(LDK(KP555570233), T71));
			 T85 = VFNMS(LDK(KP555570233), T70, VMUL(LDK(KP831469612), T71));
			 Tak = VSUB(Tag, Taj);
			 Tar = VSUB(Tan, Taq);
			 Tas = VMUL(LDK(KP707106781), VADD(Tak, Tar));
			 Tcd = VMUL(LDK(KP707106781), VSUB(Tar, Tak));
		    }
	       }
	       {
		    V Tav, Tau, T1b, Taw, T1v, Tay, Tax, T18, Taz, T1w, T1j, Teo, T1z, TaD, T1q;
		    V Ten, T1y, TaG, T14, T17, Tem, Tep;
		    {
			 V T19, T1a, T1t, T1u;
			 T19 = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
			 T1a = LD(&(xi[WS(is, 98)]), ivs, &(xi[0]));
			 Tav = VADD(T19, T1a);
			 T1t = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 T1u = LD(&(xi[WS(is, 66)]), ivs, &(xi[0]));
			 Tau = VADD(T1t, T1u);
			 T1b = VSUB(T19, T1a);
			 Taw = VADD(Tau, Tav);
			 T1v = VSUB(T1t, T1u);
		    }
		    {
			 V T12, T13, T15, T16;
			 T12 = LD(&(xi[WS(is, 114)]), ivs, &(xi[0]));
			 T13 = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
			 T14 = VSUB(T12, T13);
			 Tay = VADD(T12, T13);
			 T15 = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
			 T16 = LD(&(xi[WS(is, 82)]), ivs, &(xi[0]));
			 T17 = VSUB(T15, T16);
			 Tax = VADD(T15, T16);
		    }
		    T18 = VMUL(LDK(KP707106781), VSUB(T14, T17));
		    Taz = VADD(Tax, Tay);
		    T1w = VMUL(LDK(KP707106781), VADD(T17, T14));
		    {
			 V T1f, TaB, T1i, TaC;
			 {
			      V T1d, T1e, T1g, T1h;
			      T1d = LD(&(xi[WS(is, 122)]), ivs, &(xi[0]));
			      T1e = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
			      T1f = VSUB(T1d, T1e);
			      TaB = VADD(T1d, T1e);
			      T1g = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
			      T1h = LD(&(xi[WS(is, 90)]), ivs, &(xi[0]));
			      T1i = VSUB(T1g, T1h);
			      TaC = VADD(T1g, T1h);
			 }
			 T1j = VFNMS(LDK(KP923879532), T1i, VMUL(LDK(KP382683432), T1f));
			 Teo = VSUB(TaB, TaC);
			 T1z = VFMA(LDK(KP923879532), T1f, VMUL(LDK(KP382683432), T1i));
			 TaD = VADD(TaB, TaC);
		    }
		    {
			 V T1m, TaE, T1p, TaF;
			 {
			      V T1k, T1l, T1n, T1o;
			      T1k = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
			      T1l = LD(&(xi[WS(is, 74)]), ivs, &(xi[0]));
			      T1m = VSUB(T1k, T1l);
			      TaE = VADD(T1k, T1l);
			      T1n = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
			      T1o = LD(&(xi[WS(is, 106)]), ivs, &(xi[0]));
			      T1p = VSUB(T1n, T1o);
			      TaF = VADD(T1n, T1o);
			 }
			 T1q = VFMA(LDK(KP382683432), T1m, VMUL(LDK(KP923879532), T1p));
			 Ten = VSUB(TaE, TaF);
			 T1y = VFNMS(LDK(KP382683432), T1p, VMUL(LDK(KP923879532), T1m));
			 TaG = VADD(TaE, TaF);
		    }
		    Tdp = VADD(Taw, Taz);
		    Tdq = VADD(TaG, TaD);
		    TdG = VSUB(Tdp, Tdq);
		    Tem = VSUB(Tau, Tav);
		    Tep = VMUL(LDK(KP707106781), VADD(Ten, Teo));
		    Teq = VADD(Tem, Tep);
		    Tgm = VSUB(Tem, Tep);
		    {
			 V Ter, Tes, T1c, T1r;
			 Ter = VSUB(Tay, Tax);
			 Tes = VMUL(LDK(KP707106781), VSUB(Teo, Ten));
			 Tet = VADD(Ter, Tes);
			 Tgl = VSUB(Tes, Ter);
			 T1c = VSUB(T18, T1b);
			 T1r = VSUB(T1j, T1q);
			 T1s = VADD(T1c, T1r);
			 T5P = VSUB(T1r, T1c);
		    }
		    {
			 V T1x, T1A, T7b, T7c;
			 T1x = VADD(T1v, T1w);
			 T1A = VADD(T1y, T1z);
			 T1B = VADD(T1x, T1A);
			 T5Q = VSUB(T1x, T1A);
			 T7b = VADD(T1b, T18);
			 T7c = VSUB(T1z, T1y);
			 T7d = VADD(T7b, T7c);
			 T8Z = VSUB(T7c, T7b);
		    }
		    {
			 V TaA, TaH, T78, T79;
			 TaA = VSUB(Taw, Taz);
			 TaH = VSUB(TaD, TaG);
			 TaI = VFMA(LDK(KP923879532), TaA, VMUL(LDK(KP382683432), TaH));
			 Tcf = VFNMS(LDK(KP382683432), TaA, VMUL(LDK(KP923879532), TaH));
			 T78 = VSUB(T1v, T1w);
			 T79 = VADD(T1q, T1j);
			 T7a = VADD(T78, T79);
			 T90 = VSUB(T78, T79);
		    }
	       }
	       {
		    V TaJ, TaK, T1F, TaL, T27, TaM, TaN, T1M, TaO, T24, T1U, Tew, T2a, TaV, T21;
		    V Tex, T29, TaS, T1I, T1L, Tev, Tey;
		    {
			 V T1D, T1E, T25, T26;
			 T1D = LD(&(xi[WS(is, 126)]), ivs, &(xi[0]));
			 T1E = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
			 TaJ = VADD(T1D, T1E);
			 T25 = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
			 T26 = LD(&(xi[WS(is, 94)]), ivs, &(xi[0]));
			 TaK = VADD(T25, T26);
			 T1F = VSUB(T1D, T1E);
			 TaL = VADD(TaJ, TaK);
			 T27 = VSUB(T25, T26);
		    }
		    {
			 V T1G, T1H, T1J, T1K;
			 T1G = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 T1H = LD(&(xi[WS(is, 78)]), ivs, &(xi[0]));
			 T1I = VSUB(T1G, T1H);
			 TaM = VADD(T1G, T1H);
			 T1J = LD(&(xi[WS(is, 110)]), ivs, &(xi[0]));
			 T1K = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
			 T1L = VSUB(T1J, T1K);
			 TaN = VADD(T1J, T1K);
		    }
		    T1M = VMUL(LDK(KP707106781), VADD(T1I, T1L));
		    TaO = VADD(TaM, TaN);
		    T24 = VMUL(LDK(KP707106781), VSUB(T1L, T1I));
		    {
			 V T1Q, TaT, T1T, TaU;
			 {
			      V T1O, T1P, T1R, T1S;
			      T1O = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
			      T1P = LD(&(xi[WS(is, 70)]), ivs, &(xi[0]));
			      T1Q = VSUB(T1O, T1P);
			      TaT = VADD(T1O, T1P);
			      T1R = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
			      T1S = LD(&(xi[WS(is, 102)]), ivs, &(xi[0]));
			      T1T = VSUB(T1R, T1S);
			      TaU = VADD(T1R, T1S);
			 }
			 T1U = VFNMS(LDK(KP382683432), T1T, VMUL(LDK(KP923879532), T1Q));
			 Tew = VSUB(TaT, TaU);
			 T2a = VFMA(LDK(KP382683432), T1Q, VMUL(LDK(KP923879532), T1T));
			 TaV = VADD(TaT, TaU);
		    }
		    {
			 V T1X, TaQ, T20, TaR;
			 {
			      V T1V, T1W, T1Y, T1Z;
			      T1V = LD(&(xi[WS(is, 118)]), ivs, &(xi[0]));
			      T1W = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
			      T1X = VSUB(T1V, T1W);
			      TaQ = VADD(T1V, T1W);
			      T1Y = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
			      T1Z = LD(&(xi[WS(is, 86)]), ivs, &(xi[0]));
			      T20 = VSUB(T1Y, T1Z);
			      TaR = VADD(T1Y, T1Z);
			 }
			 T21 = VFMA(LDK(KP923879532), T1X, VMUL(LDK(KP382683432), T20));
			 Tex = VSUB(TaQ, TaR);
			 T29 = VFNMS(LDK(KP923879532), T20, VMUL(LDK(KP382683432), T1X));
			 TaS = VADD(TaQ, TaR);
		    }
		    Tdm = VADD(TaL, TaO);
		    Tdn = VADD(TaV, TaS);
		    TdH = VSUB(Tdm, Tdn);
		    Tev = VSUB(TaJ, TaK);
		    Tey = VMUL(LDK(KP707106781), VADD(Tew, Tex));
		    Tez = VADD(Tev, Tey);
		    Tgi = VSUB(Tev, Tey);
		    {
			 V TeA, TeB, T1N, T22;
			 TeA = VSUB(TaN, TaM);
			 TeB = VMUL(LDK(KP707106781), VSUB(Tex, Tew));
			 TeC = VADD(TeA, TeB);
			 Tgj = VSUB(TeB, TeA);
			 T1N = VADD(T1F, T1M);
			 T22 = VADD(T1U, T21);
			 T23 = VADD(T1N, T22);
			 T5N = VSUB(T1N, T22);
		    }
		    {
			 V T28, T2b, T7i, T7j;
			 T28 = VSUB(T24, T27);
			 T2b = VSUB(T29, T2a);
			 T2c = VADD(T28, T2b);
			 T5M = VSUB(T2b, T28);
			 T7i = VADD(T27, T24);
			 T7j = VSUB(T21, T1U);
			 T7k = VADD(T7i, T7j);
			 T8X = VSUB(T7j, T7i);
		    }
		    {
			 V TaP, TaW, T7f, T7g;
			 TaP = VSUB(TaL, TaO);
			 TaW = VSUB(TaS, TaV);
			 TaX = VFNMS(LDK(KP382683432), TaW, VMUL(LDK(KP923879532), TaP));
			 Tcg = VFMA(LDK(KP382683432), TaP, VMUL(LDK(KP923879532), TaW));
			 T7f = VSUB(T1F, T1M);
			 T7g = VADD(T2a, T29);
			 T7h = VADD(T7f, T7g);
			 T8W = VSUB(T7f, T7g);
		    }
	       }
	       {
		    V T2J, TeL, T2V, Tb9, T30, TeO, T3c, Tbg, T2Q, TeM, T2S, Tbc, T37, TeP, T39;
		    V Tbj;
		    {
			 V T2H, T2I, Tb7, T2T, T2U, Tb8;
			 T2H = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
			 T2I = LD(&(xi[WS(is, 69)]), ivs, &(xi[WS(is, 1)]));
			 Tb7 = VADD(T2H, T2I);
			 T2T = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
			 T2U = LD(&(xi[WS(is, 101)]), ivs, &(xi[WS(is, 1)]));
			 Tb8 = VADD(T2T, T2U);
			 T2J = VSUB(T2H, T2I);
			 TeL = VSUB(Tb7, Tb8);
			 T2V = VSUB(T2T, T2U);
			 Tb9 = VADD(Tb7, Tb8);
		    }
		    {
			 V T2Y, T2Z, Tbe, T3a, T3b, Tbf;
			 T2Y = LD(&(xi[WS(is, 125)]), ivs, &(xi[WS(is, 1)]));
			 T2Z = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
			 Tbe = VADD(T2Y, T2Z);
			 T3a = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
			 T3b = LD(&(xi[WS(is, 93)]), ivs, &(xi[WS(is, 1)]));
			 Tbf = VADD(T3a, T3b);
			 T30 = VSUB(T2Y, T2Z);
			 TeO = VSUB(Tbe, Tbf);
			 T3c = VSUB(T3a, T3b);
			 Tbg = VADD(Tbe, Tbf);
		    }
		    {
			 V T2M, Tba, T2P, Tbb;
			 {
			      V T2K, T2L, T2N, T2O;
			      T2K = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
			      T2L = LD(&(xi[WS(is, 85)]), ivs, &(xi[WS(is, 1)]));
			      T2M = VSUB(T2K, T2L);
			      Tba = VADD(T2K, T2L);
			      T2N = LD(&(xi[WS(is, 117)]), ivs, &(xi[WS(is, 1)]));
			      T2O = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
			      T2P = VSUB(T2N, T2O);
			      Tbb = VADD(T2N, T2O);
			 }
			 T2Q = VMUL(LDK(KP707106781), VADD(T2M, T2P));
			 TeM = VSUB(Tbb, Tba);
			 T2S = VMUL(LDK(KP707106781), VSUB(T2P, T2M));
			 Tbc = VADD(Tba, Tbb);
		    }
		    {
			 V T33, Tbh, T36, Tbi;
			 {
			      V T31, T32, T34, T35;
			      T31 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			      T32 = LD(&(xi[WS(is, 77)]), ivs, &(xi[WS(is, 1)]));
			      T33 = VSUB(T31, T32);
			      Tbh = VADD(T31, T32);
			      T34 = LD(&(xi[WS(is, 109)]), ivs, &(xi[WS(is, 1)]));
			      T35 = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
			      T36 = VSUB(T34, T35);
			      Tbi = VADD(T34, T35);
			 }
			 T37 = VMUL(LDK(KP707106781), VADD(T33, T36));
			 TeP = VSUB(Tbi, Tbh);
			 T39 = VMUL(LDK(KP707106781), VSUB(T36, T33));
			 Tbj = VADD(Tbh, Tbi);
		    }
		    {
			 V Tbd, Tbk, TeN, TeQ;
			 Tbd = VSUB(Tb9, Tbc);
			 Tbk = VSUB(Tbg, Tbj);
			 Tbl = VMUL(LDK(KP707106781), VADD(Tbd, Tbk));
			 Tbu = VMUL(LDK(KP707106781), VSUB(Tbk, Tbd));
			 {
			      V Td9, Tda, TeW, TeX;
			      Td9 = VADD(Tb9, Tbc);
			      Tda = VADD(Tbg, Tbj);
			      Tdb = VADD(Td9, Tda);
			      TdL = VSUB(Tda, Td9);
			      TeW = VFNMS(LDK(KP382683432), TeL, VMUL(LDK(KP923879532), TeM));
			      TeX = VFMA(LDK(KP382683432), TeO, VMUL(LDK(KP923879532), TeP));
			      TeY = VADD(TeW, TeX);
			      Tgu = VSUB(TeX, TeW);
			 }
			 TeN = VFMA(LDK(KP923879532), TeL, VMUL(LDK(KP382683432), TeM));
			 TeQ = VFNMS(LDK(KP382683432), TeP, VMUL(LDK(KP923879532), TeO));
			 TeR = VADD(TeN, TeQ);
			 Tgq = VSUB(TeQ, TeN);
			 {
			      V T7t, T7C, T7w, T7D;
			      {
				   V T7r, T7s, T7u, T7v;
				   T7r = VSUB(T2J, T2Q);
				   T7s = VADD(T2V, T2S);
				   T7t = VFMA(LDK(KP831469612), T7r, VMUL(LDK(KP555570233), T7s));
				   T7C = VFNMS(LDK(KP555570233), T7r, VMUL(LDK(KP831469612), T7s));
				   T7u = VSUB(T30, T37);
				   T7v = VADD(T3c, T39);
				   T7w = VFNMS(LDK(KP555570233), T7v, VMUL(LDK(KP831469612), T7u));
				   T7D = VFMA(LDK(KP555570233), T7u, VMUL(LDK(KP831469612), T7v));
			      }
			      T7x = VADD(T7t, T7w);
			      T98 = VSUB(T7D, T7C);
			      T7E = VADD(T7C, T7D);
			      T94 = VSUB(T7w, T7t);
			 }
			 {
			      V T2X, T3q, T3e, T3r;
			      {
				   V T2R, T2W, T38, T3d;
				   T2R = VADD(T2J, T2Q);
				   T2W = VSUB(T2S, T2V);
				   T2X = VFMA(LDK(KP980785280), T2R, VMUL(LDK(KP195090322), T2W));
				   T3q = VFNMS(LDK(KP195090322), T2R, VMUL(LDK(KP980785280), T2W));
				   T38 = VADD(T30, T37);
				   T3d = VSUB(T39, T3c);
				   T3e = VFNMS(LDK(KP195090322), T3d, VMUL(LDK(KP980785280), T38));
				   T3r = VFMA(LDK(KP195090322), T38, VMUL(LDK(KP980785280), T3d));
			      }
			      T3f = VADD(T2X, T3e);
			      T5Y = VSUB(T3r, T3q);
			      T3s = VADD(T3q, T3r);
			      T5U = VSUB(T3e, T2X);
			 }
		    }
	       }
	       {
		    V T3Y, Tf6, T4a, TbG, T4f, Tf9, T4r, TbN, T45, Tf7, T47, TbJ, T4m, Tfa, T4o;
		    V TbQ;
		    {
			 V T3W, T3X, TbE, T48, T49, TbF;
			 T3W = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
			 T3X = LD(&(xi[WS(is, 67)]), ivs, &(xi[WS(is, 1)]));
			 TbE = VADD(T3W, T3X);
			 T48 = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
			 T49 = LD(&(xi[WS(is, 99)]), ivs, &(xi[WS(is, 1)]));
			 TbF = VADD(T48, T49);
			 T3Y = VSUB(T3W, T3X);
			 Tf6 = VSUB(TbE, TbF);
			 T4a = VSUB(T48, T49);
			 TbG = VADD(TbE, TbF);
		    }
		    {
			 V T4d, T4e, TbL, T4p, T4q, TbM;
			 T4d = LD(&(xi[WS(is, 123)]), ivs, &(xi[WS(is, 1)]));
			 T4e = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
			 TbL = VADD(T4d, T4e);
			 T4p = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
			 T4q = LD(&(xi[WS(is, 91)]), ivs, &(xi[WS(is, 1)]));
			 TbM = VADD(T4p, T4q);
			 T4f = VSUB(T4d, T4e);
			 Tf9 = VSUB(TbL, TbM);
			 T4r = VSUB(T4p, T4q);
			 TbN = VADD(TbL, TbM);
		    }
		    {
			 V T41, TbH, T44, TbI;
			 {
			      V T3Z, T40, T42, T43;
			      T3Z = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
			      T40 = LD(&(xi[WS(is, 83)]), ivs, &(xi[WS(is, 1)]));
			      T41 = VSUB(T3Z, T40);
			      TbH = VADD(T3Z, T40);
			      T42 = LD(&(xi[WS(is, 115)]), ivs, &(xi[WS(is, 1)]));
			      T43 = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
			      T44 = VSUB(T42, T43);
			      TbI = VADD(T42, T43);
			 }
			 T45 = VMUL(LDK(KP707106781), VADD(T41, T44));
			 Tf7 = VSUB(TbI, TbH);
			 T47 = VMUL(LDK(KP707106781), VSUB(T44, T41));
			 TbJ = VADD(TbH, TbI);
		    }
		    {
			 V T4i, TbO, T4l, TbP;
			 {
			      V T4g, T4h, T4j, T4k;
			      T4g = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			      T4h = LD(&(xi[WS(is, 75)]), ivs, &(xi[WS(is, 1)]));
			      T4i = VSUB(T4g, T4h);
			      TbO = VADD(T4g, T4h);
			      T4j = LD(&(xi[WS(is, 107)]), ivs, &(xi[WS(is, 1)]));
			      T4k = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
			      T4l = VSUB(T4j, T4k);
			      TbP = VADD(T4j, T4k);
			 }
			 T4m = VMUL(LDK(KP707106781), VADD(T4i, T4l));
			 Tfa = VSUB(TbP, TbO);
			 T4o = VMUL(LDK(KP707106781), VSUB(T4l, T4i));
			 TbQ = VADD(TbO, TbP);
		    }
		    {
			 V TbK, TbR, Tf8, Tfb;
			 TbK = VSUB(TbG, TbJ);
			 TbR = VSUB(TbN, TbQ);
			 TbS = VMUL(LDK(KP707106781), VADD(TbK, TbR));
			 Tc1 = VMUL(LDK(KP707106781), VSUB(TbR, TbK));
			 {
			      V Tdg, Tdh, Tfh, Tfi;
			      Tdg = VADD(TbG, TbJ);
			      Tdh = VADD(TbN, TbQ);
			      Tdi = VADD(Tdg, Tdh);
			      TdO = VSUB(Tdh, Tdg);
			      Tfh = VFNMS(LDK(KP382683432), Tf6, VMUL(LDK(KP923879532), Tf7));
			      Tfi = VFMA(LDK(KP382683432), Tf9, VMUL(LDK(KP923879532), Tfa));
			      Tfj = VADD(Tfh, Tfi);
			      Tgy = VSUB(Tfi, Tfh);
			 }
			 Tf8 = VFMA(LDK(KP923879532), Tf6, VMUL(LDK(KP382683432), Tf7));
			 Tfb = VFNMS(LDK(KP382683432), Tfa, VMUL(LDK(KP923879532), Tf9));
			 Tfc = VADD(Tf8, Tfb);
			 TgA = VSUB(Tfb, Tf8);
			 {
			      V T7M, T7V, T7P, T7W;
			      {
				   V T7K, T7L, T7N, T7O;
				   T7K = VSUB(T3Y, T45);
				   T7L = VADD(T4a, T47);
				   T7M = VFMA(LDK(KP831469612), T7K, VMUL(LDK(KP555570233), T7L));
				   T7V = VFNMS(LDK(KP555570233), T7K, VMUL(LDK(KP831469612), T7L));
				   T7N = VSUB(T4f, T4m);
				   T7O = VADD(T4r, T4o);
				   T7P = VFNMS(LDK(KP555570233), T7O, VMUL(LDK(KP831469612), T7N));
				   T7W = VFMA(LDK(KP555570233), T7N, VMUL(LDK(KP831469612), T7O));
			      }
			      T7Q = VADD(T7M, T7P);
			      T9e = VSUB(T7P, T7M);
			      T7X = VADD(T7V, T7W);
			      T9c = VSUB(T7W, T7V);
			 }
			 {
			      V T4c, T4F, T4t, T4G;
			      {
				   V T46, T4b, T4n, T4s;
				   T46 = VADD(T3Y, T45);
				   T4b = VSUB(T47, T4a);
				   T4c = VFMA(LDK(KP980785280), T46, VMUL(LDK(KP195090322), T4b));
				   T4F = VFNMS(LDK(KP195090322), T46, VMUL(LDK(KP980785280), T4b));
				   T4n = VADD(T4f, T4m);
				   T4s = VSUB(T4o, T4r);
				   T4t = VFNMS(LDK(KP195090322), T4s, VMUL(LDK(KP980785280), T4n));
				   T4G = VFMA(LDK(KP195090322), T4n, VMUL(LDK(KP980785280), T4s));
			      }
			      T4u = VADD(T4c, T4t);
			      T64 = VSUB(T4t, T4c);
			      T4H = VADD(T4F, T4G);
			      T62 = VSUB(T4G, T4F);
			 }
		    }
	       }
	       {
		    V Td5, Tdx, TdC, TdE, Tdk, Tdt, Tds, Tdy, Tdz, TdD;
		    {
			 V Td1, Td4, TdA, TdB;
			 Td1 = VADD(TcZ, Td0);
			 Td4 = VADD(Td2, Td3);
			 Td5 = VSUB(Td1, Td4);
			 Tdx = VADD(Td1, Td4);
			 TdA = VADD(Td8, Tdb);
			 TdB = VADD(Tdf, Tdi);
			 TdC = VADD(TdA, TdB);
			 TdE = VBYI(VSUB(TdB, TdA));
		    }
		    {
			 V Tdc, Tdj, Tdo, Tdr;
			 Tdc = VSUB(Td8, Tdb);
			 Tdj = VSUB(Tdf, Tdi);
			 Tdk = VMUL(LDK(KP707106781), VADD(Tdc, Tdj));
			 Tdt = VMUL(LDK(KP707106781), VSUB(Tdj, Tdc));
			 Tdo = VADD(Tdm, Tdn);
			 Tdr = VADD(Tdp, Tdq);
			 Tds = VSUB(Tdo, Tdr);
			 Tdy = VADD(Tdr, Tdo);
		    }
		    Tdz = VADD(Tdx, Tdy);
		    ST(&(xo[WS(os, 64)]), VSUB(Tdz, TdC), ovs, &(xo[0]));
		    ST(&(xo[0]), VADD(Tdz, TdC), ovs, &(xo[0]));
		    TdD = VSUB(Tdx, Tdy);
		    ST(&(xo[WS(os, 96)]), VSUB(TdD, TdE), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 32)]), VADD(TdD, TdE), ovs, &(xo[0]));
		    {
			 V Tdl, Tdu, Tdv, Tdw;
			 Tdl = VADD(Td5, Tdk);
			 Tdu = VBYI(VADD(Tds, Tdt));
			 ST(&(xo[WS(os, 112)]), VSUB(Tdl, Tdu), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 16)]), VADD(Tdl, Tdu), ovs, &(xo[0]));
			 Tdv = VSUB(Td5, Tdk);
			 Tdw = VBYI(VSUB(Tdt, Tds));
			 ST(&(xo[WS(os, 80)]), VSUB(Tdv, Tdw), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 48)]), VADD(Tdv, Tdw), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TdJ, Te4, TdX, Te5, TdQ, Te1, TdU, Te2;
		    {
			 V TdF, TdI, TdV, TdW;
			 TdF = VSUB(TcZ, Td0);
			 TdI = VMUL(LDK(KP707106781), VADD(TdG, TdH));
			 TdJ = VADD(TdF, TdI);
			 Te4 = VSUB(TdF, TdI);
			 TdV = VFNMS(LDK(KP382683432), TdK, VMUL(LDK(KP923879532), TdL));
			 TdW = VFMA(LDK(KP382683432), TdN, VMUL(LDK(KP923879532), TdO));
			 TdX = VADD(TdV, TdW);
			 Te5 = VSUB(TdW, TdV);
		    }
		    {
			 V TdM, TdP, TdS, TdT;
			 TdM = VFMA(LDK(KP923879532), TdK, VMUL(LDK(KP382683432), TdL));
			 TdP = VFNMS(LDK(KP382683432), TdO, VMUL(LDK(KP923879532), TdN));
			 TdQ = VADD(TdM, TdP);
			 Te1 = VSUB(TdP, TdM);
			 TdS = VSUB(Td3, Td2);
			 TdT = VMUL(LDK(KP707106781), VSUB(TdH, TdG));
			 TdU = VADD(TdS, TdT);
			 Te2 = VSUB(TdT, TdS);
		    }
		    {
			 V TdR, TdY, Te7, Te8;
			 TdR = VADD(TdJ, TdQ);
			 TdY = VBYI(VADD(TdU, TdX));
			 ST(&(xo[WS(os, 120)]), VSUB(TdR, TdY), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 8)]), VADD(TdR, TdY), ovs, &(xo[0]));
			 Te7 = VBYI(VADD(Te2, Te1));
			 Te8 = VADD(Te4, Te5);
			 ST(&(xo[WS(os, 24)]), VADD(Te7, Te8), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 104)]), VSUB(Te8, Te7), ovs, &(xo[0]));
		    }
		    {
			 V TdZ, Te0, Te3, Te6;
			 TdZ = VSUB(TdJ, TdQ);
			 Te0 = VBYI(VSUB(TdX, TdU));
			 ST(&(xo[WS(os, 72)]), VSUB(TdZ, Te0), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 56)]), VADD(TdZ, Te0), ovs, &(xo[0]));
			 Te3 = VBYI(VSUB(Te1, Te2));
			 Te6 = VSUB(Te4, Te5);
			 ST(&(xo[WS(os, 40)]), VADD(Te3, Te6), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 88)]), VSUB(Te6, Te3), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TaZ, Tcs, Tci, Tcq, Tc4, Tct, Tcl, Tcp;
		    {
			 V Tat, TaY, Tce, Tch;
			 Tat = VADD(Tad, Tas);
			 TaY = VADD(TaI, TaX);
			 TaZ = VADD(Tat, TaY);
			 Tcs = VSUB(Tat, TaY);
			 Tce = VADD(Tcc, Tcd);
			 Tch = VADD(Tcf, Tcg);
			 Tci = VADD(Tce, Tch);
			 Tcq = VSUB(Tch, Tce);
			 {
			      V Tbw, Tcj, Tc3, Tck;
			      {
				   V Tbm, Tbv, TbT, Tc2;
				   Tbm = VADD(Tb6, Tbl);
				   Tbv = VADD(Tbt, Tbu);
				   Tbw = VFMA(LDK(KP980785280), Tbm, VMUL(LDK(KP195090322), Tbv));
				   Tcj = VFNMS(LDK(KP195090322), Tbm, VMUL(LDK(KP980785280), Tbv));
				   TbT = VADD(TbD, TbS);
				   Tc2 = VADD(Tc0, Tc1);
				   Tc3 = VFNMS(LDK(KP195090322), Tc2, VMUL(LDK(KP980785280), TbT));
				   Tck = VFMA(LDK(KP195090322), TbT, VMUL(LDK(KP980785280), Tc2));
			      }
			      Tc4 = VADD(Tbw, Tc3);
			      Tct = VSUB(Tck, Tcj);
			      Tcl = VADD(Tcj, Tck);
			      Tcp = VSUB(Tc3, Tbw);
			 }
		    }
		    {
			 V Tc5, Tcm, Tcv, Tcw;
			 Tc5 = VADD(TaZ, Tc4);
			 Tcm = VBYI(VADD(Tci, Tcl));
			 ST(&(xo[WS(os, 124)]), VSUB(Tc5, Tcm), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 4)]), VADD(Tc5, Tcm), ovs, &(xo[0]));
			 Tcv = VBYI(VADD(Tcq, Tcp));
			 Tcw = VADD(Tcs, Tct);
			 ST(&(xo[WS(os, 28)]), VADD(Tcv, Tcw), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 100)]), VSUB(Tcw, Tcv), ovs, &(xo[0]));
		    }
		    {
			 V Tcn, Tco, Tcr, Tcu;
			 Tcn = VSUB(TaZ, Tc4);
			 Tco = VBYI(VSUB(Tcl, Tci));
			 ST(&(xo[WS(os, 68)]), VSUB(Tcn, Tco), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 60)]), VADD(Tcn, Tco), ovs, &(xo[0]));
			 Tcr = VBYI(VSUB(Tcp, Tcq));
			 Tcu = VSUB(Tcs, Tct);
			 ST(&(xo[WS(os, 36)]), VADD(Tcr, Tcu), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 92)]), VSUB(Tcu, Tcr), ovs, &(xo[0]));
		    }
	       }
	       {
		    V Tcz, TcU, TcK, TcS, TcG, TcV, TcN, TcR;
		    {
			 V Tcx, Tcy, TcI, TcJ;
			 Tcx = VSUB(Tad, Tas);
			 Tcy = VSUB(Tcg, Tcf);
			 Tcz = VADD(Tcx, Tcy);
			 TcU = VSUB(Tcx, Tcy);
			 TcI = VSUB(Tcd, Tcc);
			 TcJ = VSUB(TaX, TaI);
			 TcK = VADD(TcI, TcJ);
			 TcS = VSUB(TcJ, TcI);
			 {
			      V TcC, TcL, TcF, TcM;
			      {
				   V TcA, TcB, TcD, TcE;
				   TcA = VSUB(Tb6, Tbl);
				   TcB = VSUB(Tbu, Tbt);
				   TcC = VFMA(LDK(KP831469612), TcA, VMUL(LDK(KP555570233), TcB));
				   TcL = VFNMS(LDK(KP555570233), TcA, VMUL(LDK(KP831469612), TcB));
				   TcD = VSUB(TbD, TbS);
				   TcE = VSUB(Tc1, Tc0);
				   TcF = VFNMS(LDK(KP555570233), TcE, VMUL(LDK(KP831469612), TcD));
				   TcM = VFMA(LDK(KP555570233), TcD, VMUL(LDK(KP831469612), TcE));
			      }
			      TcG = VADD(TcC, TcF);
			      TcV = VSUB(TcM, TcL);
			      TcN = VADD(TcL, TcM);
			      TcR = VSUB(TcF, TcC);
			 }
		    }
		    {
			 V TcH, TcO, TcX, TcY;
			 TcH = VADD(Tcz, TcG);
			 TcO = VBYI(VADD(TcK, TcN));
			 ST(&(xo[WS(os, 116)]), VSUB(TcH, TcO), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 12)]), VADD(TcH, TcO), ovs, &(xo[0]));
			 TcX = VBYI(VADD(TcS, TcR));
			 TcY = VADD(TcU, TcV);
			 ST(&(xo[WS(os, 20)]), VADD(TcX, TcY), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 108)]), VSUB(TcY, TcX), ovs, &(xo[0]));
		    }
		    {
			 V TcP, TcQ, TcT, TcW;
			 TcP = VSUB(Tcz, TcG);
			 TcQ = VBYI(VSUB(TcN, TcK));
			 ST(&(xo[WS(os, 76)]), VSUB(TcP, TcQ), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 52)]), VADD(TcP, TcQ), ovs, &(xo[0]));
			 TcT = VBYI(VSUB(TcR, TcS));
			 TcW = VSUB(TcU, TcV);
			 ST(&(xo[WS(os, 44)]), VADD(TcT, TcW), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 84)]), VSUB(TcW, TcT), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TeF, Tg8, TfI, Tg0, Tfy, Tga, TfG, TfP, Tfm, TfJ, TfB, TfF, TfW, Tgb, Tg3;
		    V Tg7;
		    {
			 V Tel, TfY, TeE, TfZ, Teu, TeD;
			 Tel = VADD(Ted, Tek);
			 TfY = VSUB(Tft, Tfq);
			 Teu = VFMA(LDK(KP980785280), Teq, VMUL(LDK(KP195090322), Tet));
			 TeD = VFNMS(LDK(KP195090322), TeC, VMUL(LDK(KP980785280), Tez));
			 TeE = VADD(Teu, TeD);
			 TfZ = VSUB(TeD, Teu);
			 TeF = VADD(Tel, TeE);
			 Tg8 = VSUB(TfZ, TfY);
			 TfI = VSUB(Tel, TeE);
			 Tg0 = VADD(TfY, TfZ);
		    }
		    {
			 V Tfu, TfN, Tfx, TfO, Tfv, Tfw;
			 Tfu = VADD(Tfq, Tft);
			 TfN = VSUB(Ted, Tek);
			 Tfv = VFNMS(LDK(KP195090322), Teq, VMUL(LDK(KP980785280), Tet));
			 Tfw = VFMA(LDK(KP195090322), Tez, VMUL(LDK(KP980785280), TeC));
			 Tfx = VADD(Tfv, Tfw);
			 TfO = VSUB(Tfw, Tfv);
			 Tfy = VADD(Tfu, Tfx);
			 Tga = VSUB(TfN, TfO);
			 TfG = VSUB(Tfx, Tfu);
			 TfP = VADD(TfN, TfO);
		    }
		    {
			 V Tf0, Tfz, Tfl, TfA;
			 {
			      V TeS, TeZ, Tfd, Tfk;
			      TeS = VADD(TeK, TeR);
			      TeZ = VADD(TeV, TeY);
			      Tf0 = VFMA(LDK(KP995184726), TeS, VMUL(LDK(KP098017140), TeZ));
			      Tfz = VFNMS(LDK(KP098017140), TeS, VMUL(LDK(KP995184726), TeZ));
			      Tfd = VADD(Tf5, Tfc);
			      Tfk = VADD(Tfg, Tfj);
			      Tfl = VFNMS(LDK(KP098017140), Tfk, VMUL(LDK(KP995184726), Tfd));
			      TfA = VFMA(LDK(KP098017140), Tfd, VMUL(LDK(KP995184726), Tfk));
			 }
			 Tfm = VADD(Tf0, Tfl);
			 TfJ = VSUB(TfA, Tfz);
			 TfB = VADD(Tfz, TfA);
			 TfF = VSUB(Tfl, Tf0);
		    }
		    {
			 V TfS, Tg1, TfV, Tg2;
			 {
			      V TfQ, TfR, TfT, TfU;
			      TfQ = VSUB(TeK, TeR);
			      TfR = VSUB(TeY, TeV);
			      TfS = VFMA(LDK(KP773010453), TfQ, VMUL(LDK(KP634393284), TfR));
			      Tg1 = VFNMS(LDK(KP634393284), TfQ, VMUL(LDK(KP773010453), TfR));
			      TfT = VSUB(Tf5, Tfc);
			      TfU = VSUB(Tfj, Tfg);
			      TfV = VFNMS(LDK(KP634393284), TfU, VMUL(LDK(KP773010453), TfT));
			      Tg2 = VFMA(LDK(KP634393284), TfT, VMUL(LDK(KP773010453), TfU));
			 }
			 TfW = VADD(TfS, TfV);
			 Tgb = VSUB(Tg2, Tg1);
			 Tg3 = VADD(Tg1, Tg2);
			 Tg7 = VSUB(TfV, TfS);
		    }
		    {
			 V Tfn, TfC, Tg9, Tgc;
			 Tfn = VADD(TeF, Tfm);
			 TfC = VBYI(VADD(Tfy, TfB));
			 ST(&(xo[WS(os, 126)]), VSUB(Tfn, TfC), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 2)]), VADD(Tfn, TfC), ovs, &(xo[0]));
			 Tg9 = VBYI(VSUB(Tg7, Tg8));
			 Tgc = VSUB(Tga, Tgb);
			 ST(&(xo[WS(os, 46)]), VADD(Tg9, Tgc), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 82)]), VSUB(Tgc, Tg9), ovs, &(xo[0]));
		    }
		    {
			 V Tgd, Tge, TfD, TfE;
			 Tgd = VBYI(VADD(Tg8, Tg7));
			 Tge = VADD(Tga, Tgb);
			 ST(&(xo[WS(os, 18)]), VADD(Tgd, Tge), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 110)]), VSUB(Tge, Tgd), ovs, &(xo[0]));
			 TfD = VSUB(TeF, Tfm);
			 TfE = VBYI(VSUB(TfB, Tfy));
			 ST(&(xo[WS(os, 66)]), VSUB(TfD, TfE), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 62)]), VADD(TfD, TfE), ovs, &(xo[0]));
		    }
		    {
			 V TfH, TfK, TfX, Tg4;
			 TfH = VBYI(VSUB(TfF, TfG));
			 TfK = VSUB(TfI, TfJ);
			 ST(&(xo[WS(os, 34)]), VADD(TfH, TfK), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 94)]), VSUB(TfK, TfH), ovs, &(xo[0]));
			 TfX = VADD(TfP, TfW);
			 Tg4 = VBYI(VADD(Tg0, Tg3));
			 ST(&(xo[WS(os, 114)]), VSUB(TfX, Tg4), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 14)]), VADD(TfX, Tg4), ovs, &(xo[0]));
		    }
		    {
			 V Tg5, Tg6, TfL, TfM;
			 Tg5 = VSUB(TfP, TfW);
			 Tg6 = VBYI(VSUB(Tg3, Tg0));
			 ST(&(xo[WS(os, 78)]), VSUB(Tg5, Tg6), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 50)]), VADD(Tg5, Tg6), ovs, &(xo[0]));
			 TfL = VBYI(VADD(TfG, TfF));
			 TfM = VADD(TfI, TfJ);
			 ST(&(xo[WS(os, 30)]), VADD(TfL, TfM), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 98)]), VSUB(TfM, TfL), ovs, &(xo[0]));
		    }
	       }
	       {
		    V Tgp, Thm, TgW, The, TgM, Tho, TgU, Th3, TgE, TgX, TgP, TgT, Tha, Thp, Thh;
		    V Thl;
		    {
			 V Tgh, Thc, Tgo, Thd, Tgk, Tgn;
			 Tgh = VSUB(Tgf, Tgg);
			 Thc = VADD(TgH, TgG);
			 Tgk = VFMA(LDK(KP555570233), Tgi, VMUL(LDK(KP831469612), Tgj));
			 Tgn = VFNMS(LDK(KP555570233), Tgm, VMUL(LDK(KP831469612), Tgl));
			 Tgo = VSUB(Tgk, Tgn);
			 Thd = VADD(Tgn, Tgk);
			 Tgp = VADD(Tgh, Tgo);
			 Thm = VSUB(Thd, Thc);
			 TgW = VSUB(Tgh, Tgo);
			 The = VADD(Thc, Thd);
		    }
		    {
			 V TgI, Th1, TgL, Th2, TgJ, TgK;
			 TgI = VSUB(TgG, TgH);
			 Th1 = VADD(Tgf, Tgg);
			 TgJ = VFNMS(LDK(KP555570233), Tgj, VMUL(LDK(KP831469612), Tgi));
			 TgK = VFMA(LDK(KP831469612), Tgm, VMUL(LDK(KP555570233), Tgl));
			 TgL = VSUB(TgJ, TgK);
			 Th2 = VADD(TgK, TgJ);
			 TgM = VADD(TgI, TgL);
			 Tho = VSUB(Th1, Th2);
			 TgU = VSUB(TgL, TgI);
			 Th3 = VADD(Th1, Th2);
		    }
		    {
			 V Tgw, TgN, TgD, TgO;
			 {
			      V Tgs, Tgv, Tgz, TgC;
			      Tgs = VSUB(Tgq, Tgr);
			      Tgv = VSUB(Tgt, Tgu);
			      Tgw = VFMA(LDK(KP471396736), Tgs, VMUL(LDK(KP881921264), Tgv));
			      TgN = VFNMS(LDK(KP471396736), Tgv, VMUL(LDK(KP881921264), Tgs));
			      Tgz = VSUB(Tgx, Tgy);
			      TgC = VSUB(TgA, TgB);
			      TgD = VFNMS(LDK(KP471396736), TgC, VMUL(LDK(KP881921264), Tgz));
			      TgO = VFMA(LDK(KP881921264), TgC, VMUL(LDK(KP471396736), Tgz));
			 }
			 TgE = VADD(Tgw, TgD);
			 TgX = VSUB(TgO, TgN);
			 TgP = VADD(TgN, TgO);
			 TgT = VSUB(TgD, Tgw);
		    }
		    {
			 V Th6, Thf, Th9, Thg;
			 {
			      V Th4, Th5, Th7, Th8;
			      Th4 = VADD(Tgr, Tgq);
			      Th5 = VADD(Tgt, Tgu);
			      Th6 = VFMA(LDK(KP290284677), Th4, VMUL(LDK(KP956940335), Th5));
			      Thf = VFNMS(LDK(KP290284677), Th5, VMUL(LDK(KP956940335), Th4));
			      Th7 = VADD(Tgx, Tgy);
			      Th8 = VADD(TgB, TgA);
			      Th9 = VFNMS(LDK(KP290284677), Th8, VMUL(LDK(KP956940335), Th7));
			      Thg = VFMA(LDK(KP956940335), Th8, VMUL(LDK(KP290284677), Th7));
			 }
			 Tha = VADD(Th6, Th9);
			 Thp = VSUB(Thg, Thf);
			 Thh = VADD(Thf, Thg);
			 Thl = VSUB(Th9, Th6);
		    }
		    {
			 V TgF, TgQ, Thn, Thq;
			 TgF = VADD(Tgp, TgE);
			 TgQ = VBYI(VADD(TgM, TgP));
			 ST(&(xo[WS(os, 118)]), VSUB(TgF, TgQ), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 10)]), VADD(TgF, TgQ), ovs, &(xo[0]));
			 Thn = VBYI(VSUB(Thl, Thm));
			 Thq = VSUB(Tho, Thp);
			 ST(&(xo[WS(os, 38)]), VADD(Thn, Thq), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 90)]), VSUB(Thq, Thn), ovs, &(xo[0]));
		    }
		    {
			 V Thr, Ths, TgR, TgS;
			 Thr = VBYI(VADD(Thm, Thl));
			 Ths = VADD(Tho, Thp);
			 ST(&(xo[WS(os, 26)]), VADD(Thr, Ths), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 102)]), VSUB(Ths, Thr), ovs, &(xo[0]));
			 TgR = VSUB(Tgp, TgE);
			 TgS = VBYI(VSUB(TgP, TgM));
			 ST(&(xo[WS(os, 74)]), VSUB(TgR, TgS), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 54)]), VADD(TgR, TgS), ovs, &(xo[0]));
		    }
		    {
			 V TgV, TgY, Thb, Thi;
			 TgV = VBYI(VSUB(TgT, TgU));
			 TgY = VSUB(TgW, TgX);
			 ST(&(xo[WS(os, 42)]), VADD(TgV, TgY), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 86)]), VSUB(TgY, TgV), ovs, &(xo[0]));
			 Thb = VADD(Th3, Tha);
			 Thi = VBYI(VADD(The, Thh));
			 ST(&(xo[WS(os, 122)]), VSUB(Thb, Thi), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 6)]), VADD(Thb, Thi), ovs, &(xo[0]));
		    }
		    {
			 V Thj, Thk, TgZ, Th0;
			 Thj = VSUB(Th3, Tha);
			 Thk = VBYI(VSUB(Thh, The));
			 ST(&(xo[WS(os, 70)]), VSUB(Thj, Thk), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 58)]), VADD(Thj, Thk), ovs, &(xo[0]));
			 TgZ = VBYI(VADD(TgU, TgT));
			 Th0 = VADD(TgW, TgX);
			 ST(&(xo[WS(os, 22)]), VADD(TgZ, Th0), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 106)]), VSUB(Th0, TgZ), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T80, T8n, T8f, T8j, T8A, T8P, T8H, T8L, T7n, T8M, T8O, T8c, T8k, T8t, T8E;
		    V T8m;
		    {
			 V T7G, T8d, T7Z, T8e;
			 {
			      V T7y, T7F, T7R, T7Y;
			      T7y = VADD(T7q, T7x);
			      T7F = VADD(T7B, T7E);
			      T7G = VFMA(LDK(KP989176509), T7y, VMUL(LDK(KP146730474), T7F));
			      T8d = VFNMS(LDK(KP146730474), T7y, VMUL(LDK(KP989176509), T7F));
			      T7R = VADD(T7J, T7Q);
			      T7Y = VADD(T7U, T7X);
			      T7Z = VFNMS(LDK(KP146730474), T7Y, VMUL(LDK(KP989176509), T7R));
			      T8e = VFMA(LDK(KP146730474), T7R, VMUL(LDK(KP989176509), T7Y));
			 }
			 T80 = VADD(T7G, T7Z);
			 T8n = VSUB(T8e, T8d);
			 T8f = VADD(T8d, T8e);
			 T8j = VSUB(T7Z, T7G);
		    }
		    {
			 V T8w, T8F, T8z, T8G;
			 {
			      V T8u, T8v, T8x, T8y;
			      T8u = VSUB(T7q, T7x);
			      T8v = VSUB(T7E, T7B);
			      T8w = VFMA(LDK(KP803207531), T8u, VMUL(LDK(KP595699304), T8v));
			      T8F = VFNMS(LDK(KP595699304), T8u, VMUL(LDK(KP803207531), T8v));
			      T8x = VSUB(T7J, T7Q);
			      T8y = VSUB(T7X, T7U);
			      T8z = VFNMS(LDK(KP595699304), T8y, VMUL(LDK(KP803207531), T8x));
			      T8G = VFMA(LDK(KP595699304), T8x, VMUL(LDK(KP803207531), T8y));
			 }
			 T8A = VADD(T8w, T8z);
			 T8P = VSUB(T8G, T8F);
			 T8H = VADD(T8F, T8G);
			 T8L = VSUB(T8z, T8w);
		    }
		    {
			 V T77, T8r, T88, T8C, T7m, T8D, T8b, T8s, T76, T87;
			 T76 = VADD(T72, T75);
			 T77 = VADD(T6Z, T76);
			 T8r = VSUB(T6Z, T76);
			 T87 = VADD(T85, T86);
			 T88 = VADD(T84, T87);
			 T8C = VSUB(T87, T84);
			 {
			      V T7e, T7l, T89, T8a;
			      T7e = VFMA(LDK(KP956940335), T7a, VMUL(LDK(KP290284677), T7d));
			      T7l = VFNMS(LDK(KP290284677), T7k, VMUL(LDK(KP956940335), T7h));
			      T7m = VADD(T7e, T7l);
			      T8D = VSUB(T7l, T7e);
			      T89 = VFNMS(LDK(KP290284677), T7a, VMUL(LDK(KP956940335), T7d));
			      T8a = VFMA(LDK(KP290284677), T7h, VMUL(LDK(KP956940335), T7k));
			      T8b = VADD(T89, T8a);
			      T8s = VSUB(T8a, T89);
			 }
			 T7n = VADD(T77, T7m);
			 T8M = VSUB(T8D, T8C);
			 T8O = VSUB(T8r, T8s);
			 T8c = VADD(T88, T8b);
			 T8k = VSUB(T8b, T88);
			 T8t = VADD(T8r, T8s);
			 T8E = VADD(T8C, T8D);
			 T8m = VSUB(T77, T7m);
		    }
		    {
			 V T81, T8g, T8N, T8Q;
			 T81 = VADD(T7n, T80);
			 T8g = VBYI(VADD(T8c, T8f));
			 ST(&(xo[WS(os, 125)]), VSUB(T81, T8g), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 3)]), VADD(T81, T8g), ovs, &(xo[WS(os, 1)]));
			 T8N = VBYI(VSUB(T8L, T8M));
			 T8Q = VSUB(T8O, T8P);
			 ST(&(xo[WS(os, 45)]), VADD(T8N, T8Q), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 83)]), VSUB(T8Q, T8N), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8R, T8S, T8h, T8i;
			 T8R = VBYI(VADD(T8M, T8L));
			 T8S = VADD(T8O, T8P);
			 ST(&(xo[WS(os, 19)]), VADD(T8R, T8S), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 109)]), VSUB(T8S, T8R), ovs, &(xo[WS(os, 1)]));
			 T8h = VSUB(T7n, T80);
			 T8i = VBYI(VSUB(T8f, T8c));
			 ST(&(xo[WS(os, 67)]), VSUB(T8h, T8i), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 61)]), VADD(T8h, T8i), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8l, T8o, T8B, T8I;
			 T8l = VBYI(VSUB(T8j, T8k));
			 T8o = VSUB(T8m, T8n);
			 ST(&(xo[WS(os, 35)]), VADD(T8l, T8o), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 93)]), VSUB(T8o, T8l), ovs, &(xo[WS(os, 1)]));
			 T8B = VADD(T8t, T8A);
			 T8I = VBYI(VADD(T8E, T8H));
			 ST(&(xo[WS(os, 115)]), VSUB(T8B, T8I), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 13)]), VADD(T8B, T8I), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8J, T8K, T8p, T8q;
			 T8J = VSUB(T8t, T8A);
			 T8K = VBYI(VSUB(T8H, T8E));
			 ST(&(xo[WS(os, 77)]), VSUB(T8J, T8K), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 51)]), VADD(T8J, T8K), ovs, &(xo[WS(os, 1)]));
			 T8p = VBYI(VADD(T8k, T8j));
			 T8q = VADD(T8m, T8n);
			 ST(&(xo[WS(os, 29)]), VADD(T8p, T8q), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 99)]), VSUB(T8q, T8p), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T4K, T5d, T55, T59, T5q, T5F, T5x, T5B, T2f, T5C, T5E, T52, T5a, T5j, T5u;
		    V T5c;
		    {
			 V T3u, T53, T4J, T54;
			 {
			      V T3g, T3t, T4v, T4I;
			      T3g = VADD(T2G, T3f);
			      T3t = VADD(T3p, T3s);
			      T3u = VFMA(LDK(KP998795456), T3g, VMUL(LDK(KP049067674), T3t));
			      T53 = VFNMS(LDK(KP049067674), T3g, VMUL(LDK(KP998795456), T3t));
			      T4v = VADD(T3V, T4u);
			      T4I = VADD(T4E, T4H);
			      T4J = VFNMS(LDK(KP049067674), T4I, VMUL(LDK(KP998795456), T4v));
			      T54 = VFMA(LDK(KP049067674), T4v, VMUL(LDK(KP998795456), T4I));
			 }
			 T4K = VADD(T3u, T4J);
			 T5d = VSUB(T54, T53);
			 T55 = VADD(T53, T54);
			 T59 = VSUB(T4J, T3u);
		    }
		    {
			 V T5m, T5v, T5p, T5w;
			 {
			      V T5k, T5l, T5n, T5o;
			      T5k = VSUB(T2G, T3f);
			      T5l = VSUB(T3s, T3p);
			      T5m = VFMA(LDK(KP740951125), T5k, VMUL(LDK(KP671558954), T5l));
			      T5v = VFNMS(LDK(KP671558954), T5k, VMUL(LDK(KP740951125), T5l));
			      T5n = VSUB(T3V, T4u);
			      T5o = VSUB(T4H, T4E);
			      T5p = VFNMS(LDK(KP671558954), T5o, VMUL(LDK(KP740951125), T5n));
			      T5w = VFMA(LDK(KP671558954), T5n, VMUL(LDK(KP740951125), T5o));
			 }
			 T5q = VADD(T5m, T5p);
			 T5F = VSUB(T5w, T5v);
			 T5x = VADD(T5v, T5w);
			 T5B = VSUB(T5p, T5m);
		    }
		    {
			 V T11, T5h, T4Y, T5s, T2e, T5t, T51, T5i, T10, T4X;
			 T10 = VADD(TI, TZ);
			 T11 = VADD(Tr, T10);
			 T5h = VSUB(Tr, T10);
			 T4X = VADD(T4V, T4W);
			 T4Y = VADD(T4U, T4X);
			 T5s = VSUB(T4X, T4U);
			 {
			      V T1C, T2d, T4Z, T50;
			      T1C = VFMA(LDK(KP098017140), T1s, VMUL(LDK(KP995184726), T1B));
			      T2d = VFNMS(LDK(KP098017140), T2c, VMUL(LDK(KP995184726), T23));
			      T2e = VADD(T1C, T2d);
			      T5t = VSUB(T2d, T1C);
			      T4Z = VFNMS(LDK(KP098017140), T1B, VMUL(LDK(KP995184726), T1s));
			      T50 = VFMA(LDK(KP995184726), T2c, VMUL(LDK(KP098017140), T23));
			      T51 = VADD(T4Z, T50);
			      T5i = VSUB(T50, T4Z);
			 }
			 T2f = VADD(T11, T2e);
			 T5C = VSUB(T5t, T5s);
			 T5E = VSUB(T5h, T5i);
			 T52 = VADD(T4Y, T51);
			 T5a = VSUB(T51, T4Y);
			 T5j = VADD(T5h, T5i);
			 T5u = VADD(T5s, T5t);
			 T5c = VSUB(T11, T2e);
		    }
		    {
			 V T4L, T56, T5D, T5G;
			 T4L = VADD(T2f, T4K);
			 T56 = VBYI(VADD(T52, T55));
			 ST(&(xo[WS(os, 127)]), VSUB(T4L, T56), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 1)]), VADD(T4L, T56), ovs, &(xo[WS(os, 1)]));
			 T5D = VBYI(VSUB(T5B, T5C));
			 T5G = VSUB(T5E, T5F);
			 ST(&(xo[WS(os, 47)]), VADD(T5D, T5G), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 81)]), VSUB(T5G, T5D), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5H, T5I, T57, T58;
			 T5H = VBYI(VADD(T5C, T5B));
			 T5I = VADD(T5E, T5F);
			 ST(&(xo[WS(os, 17)]), VADD(T5H, T5I), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 111)]), VSUB(T5I, T5H), ovs, &(xo[WS(os, 1)]));
			 T57 = VSUB(T2f, T4K);
			 T58 = VBYI(VSUB(T55, T52));
			 ST(&(xo[WS(os, 65)]), VSUB(T57, T58), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 63)]), VADD(T57, T58), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5b, T5e, T5r, T5y;
			 T5b = VBYI(VSUB(T59, T5a));
			 T5e = VSUB(T5c, T5d);
			 ST(&(xo[WS(os, 33)]), VADD(T5b, T5e), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 95)]), VSUB(T5e, T5b), ovs, &(xo[WS(os, 1)]));
			 T5r = VADD(T5j, T5q);
			 T5y = VBYI(VADD(T5u, T5x));
			 ST(&(xo[WS(os, 113)]), VSUB(T5r, T5y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 15)]), VADD(T5r, T5y), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5z, T5A, T5f, T5g;
			 T5z = VSUB(T5j, T5q);
			 T5A = VBYI(VSUB(T5x, T5u));
			 ST(&(xo[WS(os, 79)]), VSUB(T5z, T5A), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 49)]), VADD(T5z, T5A), ovs, &(xo[WS(os, 1)]));
			 T5f = VBYI(VADD(T5a, T59));
			 T5g = VADD(T5c, T5d);
			 ST(&(xo[WS(os, 31)]), VADD(T5f, T5g), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 97)]), VSUB(T5g, T5f), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T9i, T9B, T9t, T9x, T9O, Ta3, T9V, T9Z, T93, Ta0, Ta2, T9q, T9y, T9H, T9S;
		    V T9A;
		    {
			 V T9a, T9r, T9h, T9s;
			 {
			      V T96, T99, T9d, T9g;
			      T96 = VSUB(T94, T95);
			      T99 = VSUB(T97, T98);
			      T9a = VFMA(LDK(KP514102744), T96, VMUL(LDK(KP857728610), T99));
			      T9r = VFNMS(LDK(KP514102744), T99, VMUL(LDK(KP857728610), T96));
			      T9d = VSUB(T9b, T9c);
			      T9g = VSUB(T9e, T9f);
			      T9h = VFNMS(LDK(KP514102744), T9g, VMUL(LDK(KP857728610), T9d));
			      T9s = VFMA(LDK(KP857728610), T9g, VMUL(LDK(KP514102744), T9d));
			 }
			 T9i = VADD(T9a, T9h);
			 T9B = VSUB(T9s, T9r);
			 T9t = VADD(T9r, T9s);
			 T9x = VSUB(T9h, T9a);
		    }
		    {
			 V T9K, T9T, T9N, T9U;
			 {
			      V T9I, T9J, T9L, T9M;
			      T9I = VADD(T95, T94);
			      T9J = VADD(T97, T98);
			      T9K = VFMA(LDK(KP242980179), T9I, VMUL(LDK(KP970031253), T9J));
			      T9T = VFNMS(LDK(KP242980179), T9J, VMUL(LDK(KP970031253), T9I));
			      T9L = VADD(T9b, T9c);
			      T9M = VADD(T9f, T9e);
			      T9N = VFNMS(LDK(KP242980179), T9M, VMUL(LDK(KP970031253), T9L));
			      T9U = VFMA(LDK(KP970031253), T9M, VMUL(LDK(KP242980179), T9L));
			 }
			 T9O = VADD(T9K, T9N);
			 Ta3 = VSUB(T9U, T9T);
			 T9V = VADD(T9T, T9U);
			 T9Z = VSUB(T9N, T9K);
		    }
		    {
			 V T8V, T9F, T9m, T9Q, T92, T9R, T9p, T9G, T8U, T9k;
			 T8U = VSUB(T86, T85);
			 T8V = VSUB(T8T, T8U);
			 T9F = VADD(T8T, T8U);
			 T9k = VSUB(T75, T72);
			 T9m = VSUB(T9k, T9l);
			 T9Q = VADD(T9l, T9k);
			 {
			      V T8Y, T91, T9n, T9o;
			      T8Y = VFMA(LDK(KP471396736), T8W, VMUL(LDK(KP881921264), T8X));
			      T91 = VFNMS(LDK(KP471396736), T90, VMUL(LDK(KP881921264), T8Z));
			      T92 = VSUB(T8Y, T91);
			      T9R = VADD(T91, T8Y);
			      T9n = VFNMS(LDK(KP471396736), T8X, VMUL(LDK(KP881921264), T8W));
			      T9o = VFMA(LDK(KP881921264), T90, VMUL(LDK(KP471396736), T8Z));
			      T9p = VSUB(T9n, T9o);
			      T9G = VADD(T9o, T9n);
			 }
			 T93 = VADD(T8V, T92);
			 Ta0 = VSUB(T9R, T9Q);
			 Ta2 = VSUB(T9F, T9G);
			 T9q = VADD(T9m, T9p);
			 T9y = VSUB(T9p, T9m);
			 T9H = VADD(T9F, T9G);
			 T9S = VADD(T9Q, T9R);
			 T9A = VSUB(T8V, T92);
		    }
		    {
			 V T9j, T9u, Ta1, Ta4;
			 T9j = VADD(T93, T9i);
			 T9u = VBYI(VADD(T9q, T9t));
			 ST(&(xo[WS(os, 117)]), VSUB(T9j, T9u), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 11)]), VADD(T9j, T9u), ovs, &(xo[WS(os, 1)]));
			 Ta1 = VBYI(VSUB(T9Z, Ta0));
			 Ta4 = VSUB(Ta2, Ta3);
			 ST(&(xo[WS(os, 37)]), VADD(Ta1, Ta4), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 91)]), VSUB(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V Ta5, Ta6, T9v, T9w;
			 Ta5 = VBYI(VADD(Ta0, T9Z));
			 Ta6 = VADD(Ta2, Ta3);
			 ST(&(xo[WS(os, 27)]), VADD(Ta5, Ta6), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 101)]), VSUB(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
			 T9v = VSUB(T93, T9i);
			 T9w = VBYI(VSUB(T9t, T9q));
			 ST(&(xo[WS(os, 75)]), VSUB(T9v, T9w), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 53)]), VADD(T9v, T9w), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T9z, T9C, T9P, T9W;
			 T9z = VBYI(VSUB(T9x, T9y));
			 T9C = VSUB(T9A, T9B);
			 ST(&(xo[WS(os, 43)]), VADD(T9z, T9C), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 85)]), VSUB(T9C, T9z), ovs, &(xo[WS(os, 1)]));
			 T9P = VADD(T9H, T9O);
			 T9W = VBYI(VADD(T9S, T9V));
			 ST(&(xo[WS(os, 123)]), VSUB(T9P, T9W), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 5)]), VADD(T9P, T9W), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T9X, T9Y, T9D, T9E;
			 T9X = VSUB(T9H, T9O);
			 T9Y = VBYI(VSUB(T9V, T9S));
			 ST(&(xo[WS(os, 69)]), VSUB(T9X, T9Y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 59)]), VADD(T9X, T9Y), ovs, &(xo[WS(os, 1)]));
			 T9D = VBYI(VADD(T9y, T9x));
			 T9E = VADD(T9A, T9B);
			 ST(&(xo[WS(os, 21)]), VADD(T9D, T9E), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 107)]), VSUB(T9E, T9D), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T68, T6r, T6j, T6n, T6E, T6T, T6L, T6P, T5T, T6Q, T6S, T6g, T6o, T6x, T6I;
		    V T6q;
		    {
			 V T60, T6h, T67, T6i;
			 {
			      V T5W, T5Z, T63, T66;
			      T5W = VSUB(T5U, T5V);
			      T5Z = VSUB(T5X, T5Y);
			      T60 = VFMA(LDK(KP427555093), T5W, VMUL(LDK(KP903989293), T5Z));
			      T6h = VFNMS(LDK(KP427555093), T5Z, VMUL(LDK(KP903989293), T5W));
			      T63 = VSUB(T61, T62);
			      T66 = VSUB(T64, T65);
			      T67 = VFNMS(LDK(KP427555093), T66, VMUL(LDK(KP903989293), T63));
			      T6i = VFMA(LDK(KP903989293), T66, VMUL(LDK(KP427555093), T63));
			 }
			 T68 = VADD(T60, T67);
			 T6r = VSUB(T6i, T6h);
			 T6j = VADD(T6h, T6i);
			 T6n = VSUB(T67, T60);
		    }
		    {
			 V T6A, T6J, T6D, T6K;
			 {
			      V T6y, T6z, T6B, T6C;
			      T6y = VADD(T5V, T5U);
			      T6z = VADD(T5X, T5Y);
			      T6A = VFMA(LDK(KP336889853), T6y, VMUL(LDK(KP941544065), T6z));
			      T6J = VFNMS(LDK(KP336889853), T6z, VMUL(LDK(KP941544065), T6y));
			      T6B = VADD(T61, T62);
			      T6C = VADD(T65, T64);
			      T6D = VFNMS(LDK(KP336889853), T6C, VMUL(LDK(KP941544065), T6B));
			      T6K = VFMA(LDK(KP941544065), T6C, VMUL(LDK(KP336889853), T6B));
			 }
			 T6E = VADD(T6A, T6D);
			 T6T = VSUB(T6K, T6J);
			 T6L = VADD(T6J, T6K);
			 T6P = VSUB(T6D, T6A);
		    }
		    {
			 V T5L, T6v, T6c, T6G, T5S, T6H, T6f, T6w, T5K, T6a;
			 T5K = VSUB(T4W, T4V);
			 T5L = VSUB(T5J, T5K);
			 T6v = VADD(T5J, T5K);
			 T6a = VSUB(TZ, TI);
			 T6c = VSUB(T6a, T6b);
			 T6G = VADD(T6b, T6a);
			 {
			      V T5O, T5R, T6d, T6e;
			      T5O = VFMA(LDK(KP773010453), T5M, VMUL(LDK(KP634393284), T5N));
			      T5R = VFNMS(LDK(KP634393284), T5Q, VMUL(LDK(KP773010453), T5P));
			      T5S = VSUB(T5O, T5R);
			      T6H = VADD(T5R, T5O);
			      T6d = VFNMS(LDK(KP634393284), T5M, VMUL(LDK(KP773010453), T5N));
			      T6e = VFMA(LDK(KP634393284), T5P, VMUL(LDK(KP773010453), T5Q));
			      T6f = VSUB(T6d, T6e);
			      T6w = VADD(T6e, T6d);
			 }
			 T5T = VADD(T5L, T5S);
			 T6Q = VSUB(T6H, T6G);
			 T6S = VSUB(T6v, T6w);
			 T6g = VADD(T6c, T6f);
			 T6o = VSUB(T6f, T6c);
			 T6x = VADD(T6v, T6w);
			 T6I = VADD(T6G, T6H);
			 T6q = VSUB(T5L, T5S);
		    }
		    {
			 V T69, T6k, T6R, T6U;
			 T69 = VADD(T5T, T68);
			 T6k = VBYI(VADD(T6g, T6j));
			 ST(&(xo[WS(os, 119)]), VSUB(T69, T6k), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 9)]), VADD(T69, T6k), ovs, &(xo[WS(os, 1)]));
			 T6R = VBYI(VSUB(T6P, T6Q));
			 T6U = VSUB(T6S, T6T);
			 ST(&(xo[WS(os, 39)]), VADD(T6R, T6U), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 89)]), VSUB(T6U, T6R), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6V, T6W, T6l, T6m;
			 T6V = VBYI(VADD(T6Q, T6P));
			 T6W = VADD(T6S, T6T);
			 ST(&(xo[WS(os, 25)]), VADD(T6V, T6W), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 103)]), VSUB(T6W, T6V), ovs, &(xo[WS(os, 1)]));
			 T6l = VSUB(T5T, T68);
			 T6m = VBYI(VSUB(T6j, T6g));
			 ST(&(xo[WS(os, 73)]), VSUB(T6l, T6m), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 55)]), VADD(T6l, T6m), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6p, T6s, T6F, T6M;
			 T6p = VBYI(VSUB(T6n, T6o));
			 T6s = VSUB(T6q, T6r);
			 ST(&(xo[WS(os, 41)]), VADD(T6p, T6s), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 87)]), VSUB(T6s, T6p), ovs, &(xo[WS(os, 1)]));
			 T6F = VADD(T6x, T6E);
			 T6M = VBYI(VADD(T6I, T6L));
			 ST(&(xo[WS(os, 121)]), VSUB(T6F, T6M), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 7)]), VADD(T6F, T6M), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6N, T6O, T6t, T6u;
			 T6N = VSUB(T6x, T6E);
			 T6O = VBYI(VSUB(T6L, T6I));
			 ST(&(xo[WS(os, 71)]), VSUB(T6N, T6O), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 57)]), VADD(T6N, T6O), ovs, &(xo[WS(os, 1)]));
			 T6t = VBYI(VADD(T6o, T6n));
			 T6u = VADD(T6q, T6r);
			 ST(&(xo[WS(os, 23)]), VADD(T6t, T6u), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 105)]), VSUB(T6u, T6t), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 128, XSIMD_STRING("n1fv_128"), {938, 186, 144, 0}, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1fv_128) (planner *p) {
     X(kdft_register) (p, n1fv_128, &desc);
}

#endif				/* HAVE_FMA */
