/** \file
 *  This C source file was generated by $ANTLR version 3.5.2
 *
 *     -  From the grammar source file : SMARTPL2SQL.g
 *     -                            On : 2017-08-04 23:11:00
 *     -           for the tree parser : SMARTPL2SQLTreeParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <limits.h>
	#include <errno.h>
	#include <time.h>
	#include <sqlite3.h>

	#include "logger.h"
	#include "db.h"

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "SMARTPL2SQL.h"
/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSMARTPL2SQL_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSMARTPL2SQL_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSMARTPL2SQL_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSMARTPL2SQL_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef	    BACKTRACKING
#undef      ADAPTOR
#undef	    RULEMEMO
#undef		SEEK
#undef		INDEX
#undef		DBG

#define	    PARSER							ctx->pTreeParser
#define	    RECOGNIZER						PARSER->rec
#define		PSRSTATE						RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)				RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    INPUT							PARSER->ctnstream
#define		ISTREAM							INPUT->tnstream->istream
#define	    STRSTREAM						INPUT->tnstream
#define	    HASEXCEPTION()					(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION						PSRSTATE->exception
#define	    MATCHT(t, fs)					RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()						RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK					    PSRSTATE->following
#define	    FOLLOWPUSH(x)					FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()						FOLLOWSTACK->pop(FOLLOWSTACK)
#define	    PRECOVER()						RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()					RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)							ISTREAM->_LA(ISTREAM, n)
#define	    LT(n)							INPUT->tnstream->_LT(INPUT->tnstream, n)
#define	    CONSTRUCTEX()					RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()						ISTREAM->consume(ISTREAM)
#define	    MARK()							ISTREAM->mark(ISTREAM)
#define	    REWIND(m)						ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()					ISTREAM->rewindLast(ISTREAM)
#define	    PERRORRECOVERY					PSRSTATE->errorRecovery
#define	    FAILEDFLAG						PSRSTATE->failed
#define	    HASFAILED()						(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING					PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         INPUT->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		SEEK(n)							ISTREAM->seek(ISTREAM, n)
#define		INDEX()							ISTREAM->index(ISTREAM)
#define		DBG								RECOGNIZER->debugger



#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   SMARTPL2SQLTokenNames[28+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "AFTER",
        (pANTLR3_UINT8) "AGO",
        (pANTLR3_UINT8) "AND",
        (pANTLR3_UINT8) "BEFORE",
        (pANTLR3_UINT8) "DATE",
        (pANTLR3_UINT8) "DATETAG",
        (pANTLR3_UINT8) "DATINTERVAL",
        (pANTLR3_UINT8) "ENUMTAG",
        (pANTLR3_UINT8) "ENUMVAL",
        (pANTLR3_UINT8) "EQUAL",
        (pANTLR3_UINT8) "GREATER",
        (pANTLR3_UINT8) "GREATEREQUAL",
        (pANTLR3_UINT8) "INCLUDES",
        (pANTLR3_UINT8) "INT",
        (pANTLR3_UINT8) "INTBOOL",
        (pANTLR3_UINT8) "INTTAG",
        (pANTLR3_UINT8) "IS",
        (pANTLR3_UINT8) "LESS",
        (pANTLR3_UINT8) "LESSEQUAL",
        (pANTLR3_UINT8) "LPAR",
        (pANTLR3_UINT8) "NOT",
        (pANTLR3_UINT8) "OR",
        (pANTLR3_UINT8) "RPAR",
        (pANTLR3_UINT8) "STR",
        (pANTLR3_UINT8) "STRTAG",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "'{'",
        (pANTLR3_UINT8) "'}'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 SMARTPL2SQL_playlist_return
	playlist    (pSMARTPL2SQL ctx);
static 
 pANTLR3_STRING
	expression    (pSMARTPL2SQL ctx);
static 
 int
	dateval    (pSMARTPL2SQL ctx);
static 
 int
	interval    (pSMARTPL2SQL ctx);
static void	SMARTPL2SQLFree(pSMARTPL2SQL ctx);
static void     SMARTPL2SQLReset (pSMARTPL2SQL ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "SMARTPL2SQL.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new SMARTPL2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSMARTPL2SQL
SMARTPL2SQLNew   (pANTLR3_COMMON_TREE_NODE_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return SMARTPL2SQLNewSSD(instream, NULL);
}

/** \brief Create a new SMARTPL2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSMARTPL2SQL
SMARTPL2SQLNewSSD   (pANTLR3_COMMON_TREE_NODE_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSMARTPL2SQL ctx;	    /* Context structure we will build and return   */

    ctx	= (pSMARTPL2SQL) ANTLR3_CALLOC(1, sizeof(SMARTPL2SQL));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in SMARTPL2SQL.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base Tree parser/recognizer, using the supplied tree node stream
     */
    ctx->pTreeParser		= antlr3TreeParserNewStream(ANTLR3_SIZE_HINT, instream, state);

    /* Install the implementation of our SMARTPL2SQL interface
     */
    ctx->playlist	= playlist;
    ctx->expression	= expression;
    ctx->dateval	= dateval;
    ctx->interval	= interval;
    ctx->free			= SMARTPL2SQLFree;
    ctx->reset			= SMARTPL2SQLReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = SMARTPL2SQLTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
SMARTPL2SQLReset (pSMARTPL2SQL ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 SMARTPL2SQLFree(pSMARTPL2SQL ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pTreeParser->free(ctx->pTreeParser);

    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
tree parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return SMARTPL2SQLTokenNames;
}




/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_playlist66  */
static	ANTLR3_BITWORD FOLLOW_STR_in_playlist66_bits[]	= { ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_playlist66	= { FOLLOW_STR_in_playlist66_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_30_in_playlist68  */
static	ANTLR3_BITWORD FOLLOW_30_in_playlist68_bits[]	= { ANTLR3_UINT64_LIT(0x0000000013080A40) };
static  ANTLR3_BITSET_LIST FOLLOW_30_in_playlist68	= { FOLLOW_30_in_playlist68_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_playlist74  */
static	ANTLR3_BITWORD FOLLOW_expression_in_playlist74_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_playlist74	= { FOLLOW_expression_in_playlist74_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_31_in_playlist76  */
static	ANTLR3_BITWORD FOLLOW_31_in_playlist76_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_31_in_playlist76	= { FOLLOW_31_in_playlist76_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_in_expression101  */
static	ANTLR3_BITWORD FOLLOW_NOT_in_expression101_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_in_expression101	= { FOLLOW_NOT_in_expression101_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression107  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression107	= { FOLLOW_expression_in_expression107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_in_expression118  */
static	ANTLR3_BITWORD FOLLOW_AND_in_expression118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_in_expression118	= { FOLLOW_AND_in_expression118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression124  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression124_bits[]	= { ANTLR3_UINT64_LIT(0x0000000013080A40) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression124	= { FOLLOW_expression_in_expression124_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression130  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression130	= { FOLLOW_expression_in_expression130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_in_expression141  */
static	ANTLR3_BITWORD FOLLOW_OR_in_expression141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_in_expression141	= { FOLLOW_OR_in_expression141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression147  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000013080A40) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression147	= { FOLLOW_expression_in_expression147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression153  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression153_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression153	= { FOLLOW_expression_in_expression153_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_expression163  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_expression163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_expression163	= { FOLLOW_STRTAG_in_expression163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDES_in_expression165  */
static	ANTLR3_BITWORD FOLLOW_INCLUDES_in_expression165_bits[]	= { ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDES_in_expression165	= { FOLLOW_INCLUDES_in_expression165_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_expression167  */
static	ANTLR3_BITWORD FOLLOW_STR_in_expression167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_expression167	= { FOLLOW_STR_in_expression167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_expression176  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_expression176_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_expression176	= { FOLLOW_STRTAG_in_expression176_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_in_expression178  */
static	ANTLR3_BITWORD FOLLOW_IS_in_expression178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_in_expression178	= { FOLLOW_IS_in_expression178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_expression180  */
static	ANTLR3_BITWORD FOLLOW_STR_in_expression180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_expression180	= { FOLLOW_STR_in_expression180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTTAG_in_expression189  */
static	ANTLR3_BITWORD FOLLOW_INTTAG_in_expression189_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTTAG_in_expression189	= { FOLLOW_INTTAG_in_expression189_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTBOOL_in_expression191  */
static	ANTLR3_BITWORD FOLLOW_INTBOOL_in_expression191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTBOOL_in_expression191	= { FOLLOW_INTBOOL_in_expression191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_expression193  */
static	ANTLR3_BITWORD FOLLOW_INT_in_expression193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_expression193	= { FOLLOW_INT_in_expression193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATETAG_in_expression202  */
static	ANTLR3_BITWORD FOLLOW_DATETAG_in_expression202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_DATETAG_in_expression202	= { FOLLOW_DATETAG_in_expression202_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AFTER_in_expression204  */
static	ANTLR3_BITWORD FOLLOW_AFTER_in_expression204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020100) };
static  ANTLR3_BITSET_LIST FOLLOW_AFTER_in_expression204	= { FOLLOW_AFTER_in_expression204_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateval_in_expression206  */
static	ANTLR3_BITWORD FOLLOW_dateval_in_expression206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dateval_in_expression206	= { FOLLOW_dateval_in_expression206_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATETAG_in_expression215  */
static	ANTLR3_BITWORD FOLLOW_DATETAG_in_expression215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_DATETAG_in_expression215	= { FOLLOW_DATETAG_in_expression215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BEFORE_in_expression217  */
static	ANTLR3_BITWORD FOLLOW_BEFORE_in_expression217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020100) };
static  ANTLR3_BITSET_LIST FOLLOW_BEFORE_in_expression217	= { FOLLOW_BEFORE_in_expression217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateval_in_expression219  */
static	ANTLR3_BITWORD FOLLOW_dateval_in_expression219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dateval_in_expression219	= { FOLLOW_dateval_in_expression219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENUMTAG_in_expression228  */
static	ANTLR3_BITWORD FOLLOW_ENUMTAG_in_expression228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_ENUMTAG_in_expression228	= { FOLLOW_ENUMTAG_in_expression228_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_in_expression230  */
static	ANTLR3_BITWORD FOLLOW_IS_in_expression230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_in_expression230	= { FOLLOW_IS_in_expression230_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENUMVAL_in_expression232  */
static	ANTLR3_BITWORD FOLLOW_ENUMVAL_in_expression232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENUMVAL_in_expression232	= { FOLLOW_ENUMVAL_in_expression232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval257  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval257_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval257	= { FOLLOW_DATE_in_dateval257_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval266  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval266_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval266	= { FOLLOW_interval_in_dateval266_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BEFORE_in_dateval268  */
static	ANTLR3_BITWORD FOLLOW_BEFORE_in_dateval268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_BEFORE_in_dateval268	= { FOLLOW_BEFORE_in_dateval268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval270  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval270_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval270	= { FOLLOW_DATE_in_dateval270_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval279  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval279	= { FOLLOW_interval_in_dateval279_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AFTER_in_dateval281  */
static	ANTLR3_BITWORD FOLLOW_AFTER_in_dateval281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_AFTER_in_dateval281	= { FOLLOW_AFTER_in_dateval281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval283  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval283	= { FOLLOW_DATE_in_dateval283_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval292  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval292	= { FOLLOW_interval_in_dateval292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AGO_in_dateval294  */
static	ANTLR3_BITWORD FOLLOW_AGO_in_dateval294_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AGO_in_dateval294	= { FOLLOW_AGO_in_dateval294_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_interval318  */
static	ANTLR3_BITWORD FOLLOW_INT_in_interval318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_interval318	= { FOLLOW_INT_in_interval318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATINTERVAL_in_interval320  */
static	ANTLR3_BITWORD FOLLOW_DATINTERVAL_in_interval320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATINTERVAL_in_interval320	= { FOLLOW_DATINTERVAL_in_interval320_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start playlist
 * SMARTPL2SQL.g:43:1: playlist returns [ pANTLR3_STRING title, pANTLR3_STRING query ] : STR '{' e= expression '}' ;
 */
static SMARTPL2SQL_playlist_return
playlist(pSMARTPL2SQL ctx)
{
    SMARTPL2SQL_playlist_return retval;


    pANTLR3_BASE_TREE    STR1;
    pANTLR3_STRING e;
    #undef	RETURN_TYPE_e
    #define	RETURN_TYPE_e pANTLR3_STRING

    /* Initialize rule variables
     */

     retval.title= NULL;
     retval.query= NULL;
     
    STR1       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        // SMARTPL2SQL.g:45:2: ( STR '{' e= expression '}' )
        // SMARTPL2SQL.g:45:4: STR '{' e= expression '}'
        {
            STR1 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_playlist66);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


             MATCHT(30, &FOLLOW_30_in_playlist68);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


            FOLLOWPUSH(FOLLOW_expression_in_playlist74);
            e=expression(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


             MATCHT(31, &FOLLOW_31_in_playlist76);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


            {

                			pANTLR3_UINT8 val;
                			val = (STR1->getText(STR1))->toUTF8((STR1->getText(STR1)))->chars;
                			val++;
                			val[strlen((const char *)val) - 1] = '\0';
                			
                			
                retval.title= (STR1->getText(STR1))->factory->newRaw((STR1->getText(STR1))->factory);

                			retval.title
                ->append8(retval.title
                , (const char *)val);
                			
                			retval.query= 
                e
                ->factory->newRaw(e
                ->factory);

                			retval.query
                ->append8(retval.query
                , "(");
                			retval.query
                ->appendS(retval.query
                , e
                );
                			retval.query
                ->append8(retval.query
                , ")");
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleplaylistEx; /* Prevent compiler warnings */
    ruleplaylistEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end playlist */

/**
 * $ANTLR start expression
 * SMARTPL2SQL.g:62:1: expression returns [ pANTLR3_STRING result ] : ( ^( NOT a= expression ) | ^( AND a= expression b= expression ) | ^( OR a= expression b= expression ) | STRTAG INCLUDES STR | STRTAG IS STR | INTTAG INTBOOL INT | DATETAG AFTER dateval | DATETAG BEFORE dateval | ENUMTAG IS ENUMVAL );
 */
static pANTLR3_STRING
expression(pSMARTPL2SQL ctx)
{
    pANTLR3_STRING result;


    pANTLR3_BASE_TREE    STR2;
    pANTLR3_BASE_TREE    STRTAG3;
    pANTLR3_BASE_TREE    STR4;
    pANTLR3_BASE_TREE    STRTAG5;
    pANTLR3_BASE_TREE    INTTAG6;
    pANTLR3_BASE_TREE    INTBOOL7;
    pANTLR3_BASE_TREE    INT8;
    pANTLR3_BASE_TREE    DATETAG10;
    pANTLR3_BASE_TREE    DATETAG12;
    pANTLR3_BASE_TREE    ENUMTAG13;
    pANTLR3_BASE_TREE    ENUMVAL14;
    pANTLR3_STRING a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a pANTLR3_STRING

    pANTLR3_STRING b;
    #undef	RETURN_TYPE_b
    #define	RETURN_TYPE_b pANTLR3_STRING

    int dateval9;
    #undef	RETURN_TYPE_dateval9
    #define	RETURN_TYPE_dateval9 int

    int dateval11;
    #undef	RETURN_TYPE_dateval11
    #define	RETURN_TYPE_dateval11 int

    /* Initialize rule variables
     */

     result= NULL;
     
    STR2       = NULL;
    STRTAG3       = NULL;
    STR4       = NULL;
    STRTAG5       = NULL;
    INTTAG6       = NULL;
    INTBOOL7       = NULL;
    INT8       = NULL;
    DATETAG10       = NULL;
    DATETAG12       = NULL;
    ENUMTAG13       = NULL;
    ENUMVAL14       = NULL;

    {
        {
            //  SMARTPL2SQL.g:64:2: ( ^( NOT a= expression ) | ^( AND a= expression b= expression ) | ^( OR a= expression b= expression ) | STRTAG INCLUDES STR | STRTAG IS STR | INTTAG INTBOOL INT | DATETAG AFTER dateval | DATETAG BEFORE dateval | ENUMTAG IS ENUMVAL )

            ANTLR3_UINT32 alt1;

            alt1=9;

            switch ( LA(1) )
            {
            case NOT:
            	{
            		alt1=1;
            	}
                break;
            case AND:
            	{
            		alt1=2;
            	}
                break;
            case OR:
            	{
            		alt1=3;
            	}
                break;
            case STRTAG:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDES:
            			{
            				alt1=4;
            			}
            		    break;
            		case IS:
            			{
            				alt1=5;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 4;


            		    goto ruleexpressionEx;

            		}

            	}
                break;
            case INTTAG:
            	{
            		alt1=6;
            	}
                break;
            case DATETAG:
            	{
            		switch ( LA(2) )
            		{
            		case AFTER:
            			{
            				alt1=7;
            			}
            		    break;
            		case BEFORE:
            			{
            				alt1=8;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 6;


            		    goto ruleexpressionEx;

            		}

            	}
                break;
            case ENUMTAG:
            	{
            		alt1=9;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleexpressionEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // SMARTPL2SQL.g:64:4: ^( NOT a= expression )
        	    {
        	         MATCHT(NOT, &FOLLOW_NOT_in_expression101);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression107);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			result= 
        	            a
        	            ->factory->newRaw(a
        	            ->factory);

        	            			result
        	            ->append8(result
        	            , "NOT(");
        	            			result
        	            ->appendS(result
        	            , a
        	            );
        	            			result
        	            ->append8(result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // SMARTPL2SQL.g:71:4: ^( AND a= expression b= expression )
        	    {
        	         MATCHT(AND, &FOLLOW_AND_in_expression118);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression124);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expression_in_expression130);
        	        b=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			result= 
        	            a
        	            ->factory->newRaw(a
        	            ->factory);

        	            			result
        	            ->append8(result
        	            , "(");
        	            			result
        	            ->appendS(result
        	            , a
        	            );
        	            			result
        	            ->append8(result
        	            , " AND ");
        	            			result
        	            ->appendS(result
        	            , b
        	            );
        	            			result
        	            ->append8(result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // SMARTPL2SQL.g:80:4: ^( OR a= expression b= expression )
        	    {
        	         MATCHT(OR, &FOLLOW_OR_in_expression141);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression147);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expression_in_expression153);
        	        b=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			result= 
        	            a
        	            ->factory->newRaw(a
        	            ->factory);

        	            			result
        	            ->append8(result
        	            , "(");
        	            			result
        	            ->appendS(result
        	            , a
        	            );
        	            			result
        	            ->append8(result
        	            , " OR ");
        	            			result
        	            ->appendS(result
        	            , b
        	            );
        	            			result
        	            ->append8(result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // SMARTPL2SQL.g:89:4: STRTAG INCLUDES STR
        	    {
        	        STRTAG3 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_expression163);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(INCLUDES, &FOLLOW_INCLUDES_in_expression165);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        STR2 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_expression167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 val;
        	            			val = (STR2->getText(STR2))->toUTF8((STR2->getText(STR2)))->chars;
        	            			val++;
        	            			val[strlen((const char *)val) - 1] = '\0';
        	            			
        	            			
        	            result= (STR2->getText(STR2))->factory->newRaw((STR2->getText(STR2))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (STRTAG3->getText(STRTAG3))->toUTF8((STRTAG3->getText(STRTAG3))));
        	            			
        	            result
        	            ->append8(result
        	            , " LIKE '%");
        	            			result
        	            ->append8(result
        	            , sqlite3_mprintf("%q", (const char *)val));
        	            			result
        	            ->append8(result
        	            , "%'");
        	            		
        	        }


        	    }
        	    break;
        	case 5:
        	    // SMARTPL2SQL.g:103:4: STRTAG IS STR
        	    {
        	        STRTAG5 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_expression176);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(IS, &FOLLOW_IS_in_expression178);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        STR4 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_expression180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 val;
        	            			val = (STR4->getText(STR4))->toUTF8((STR4->getText(STR4)))->chars;
        	            			val++;
        	            			val[strlen((const char *)val) - 1] = '\0';
        	            			
        	            			
        	            result= (STR4->getText(STR4))->factory->newRaw((STR4->getText(STR4))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (STRTAG5->getText(STRTAG5))->toUTF8((STRTAG5->getText(STRTAG5))));
        	            			
        	            result
        	            ->append8(result
        	            , " LIKE '");
        	            			result
        	            ->append8(result
        	            , sqlite3_mprintf("%q", (const char *)val));
        	            			result
        	            ->append8(result
        	            , "'");
        	            		
        	        }


        	    }
        	    break;
        	case 6:
        	    // SMARTPL2SQL.g:117:4: INTTAG INTBOOL INT
        	    {
        	        INTTAG6 = (pANTLR3_BASE_TREE) MATCHT(INTTAG, &FOLLOW_INTTAG_in_expression189);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INTBOOL7 = (pANTLR3_BASE_TREE) MATCHT(INTBOOL, &FOLLOW_INTBOOL_in_expression191);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INT8 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_expression193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			result= (INTTAG6->getText(INTTAG6))->factory->newRaw((INTTAG6->getText(INTTAG6))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (INTTAG6->getText(INTTAG6))->toUTF8((INTTAG6->getText(INTTAG6))));
        	            			
        	            result
        	            ->append8(result
        	            , " ");
        	            			result
        	            ->appendS(result
        	            , (INTBOOL7->getText(INTBOOL7))->toUTF8((INTBOOL7->getText(INTBOOL7))));
        	            			
        	            result
        	            ->append8(result
        	            , " ");
        	            			result
        	            ->appendS(result
        	            , (INT8->getText(INT8))->toUTF8((INT8->getText(INT8))));
        	            		
        	        }


        	    }
        	    break;
        	case 7:
        	    // SMARTPL2SQL.g:127:4: DATETAG AFTER dateval
        	    {
        	        DATETAG10 = (pANTLR3_BASE_TREE) MATCHT(DATETAG, &FOLLOW_DATETAG_in_expression202);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(AFTER, &FOLLOW_AFTER_in_expression204);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_dateval_in_expression206);
        	        dateval9=dateval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			char str[15];
        	            			sprintf(str, "%d", dateval9
        	            );
        	            			
        	            			result= (DATETAG10->getText(DATETAG10))->factory->newRaw((DATETAG10->getText(DATETAG10))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (DATETAG10->getText(DATETAG10))->toUTF8((DATETAG10->getText(DATETAG10))));
        	            			
        	            result
        	            ->append8(result
        	            , " > ");
        	            			result
        	            ->append8(result
        	            , str);
        	            		
        	        }


        	    }
        	    break;
        	case 8:
        	    // SMARTPL2SQL.g:138:4: DATETAG BEFORE dateval
        	    {
        	        DATETAG12 = (pANTLR3_BASE_TREE) MATCHT(DATETAG, &FOLLOW_DATETAG_in_expression215);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(BEFORE, &FOLLOW_BEFORE_in_expression217);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_dateval_in_expression219);
        	        dateval11=dateval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			char str[15];
        	            			sprintf(str, "%d", dateval11
        	            );
        	            			
        	            			result= (DATETAG12->getText(DATETAG12))->factory->newRaw((DATETAG12->getText(DATETAG12))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (DATETAG12->getText(DATETAG12))->toUTF8((DATETAG12->getText(DATETAG12))));
        	            			
        	            result
        	            ->append8(result
        	            , " > ");
        	            			result
        	            ->append8(result
        	            , str);
        	            		
        	        }


        	    }
        	    break;
        	case 9:
        	    // SMARTPL2SQL.g:149:4: ENUMTAG IS ENUMVAL
        	    {
        	        ENUMTAG13 = (pANTLR3_BASE_TREE) MATCHT(ENUMTAG, &FOLLOW_ENUMTAG_in_expression228);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(IS, &FOLLOW_IS_in_expression230);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        ENUMVAL14 = (pANTLR3_BASE_TREE) MATCHT(ENUMVAL, &FOLLOW_ENUMVAL_in_expression232);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 tag;
        	            			pANTLR3_UINT8 val;
        	            			char str[20];
        	            			
        	            			sprintf(str, "1=1");
        	            			
        	            			tag = (ENUMTAG13->getText(ENUMTAG13))->chars;
        	            			val = (ENUMVAL14->getText(ENUMVAL14))->chars;
        	            			if (strcmp((char *)tag, "media_kind") == 0)
        	            			{
        	            				if (strcmp((char *)val, "music") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_MUSIC);
        	            				}
        	            				else if (strcmp((char *)val, "movie") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_MOVIE);
        	            				}
        	            				else if (strcmp((char *)val, "podcast") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_PODCAST);
        	            				}
        	            				else if (strcmp((char *)val, "audiobook") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_AUDIOBOOK);
        	            				}
        	            				else if (strcmp((char *)val, "tvshow") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_TVSHOW);
        	            				}
        	            			}
        	            			else if (strcmp((char *)tag, "data_kind") == 0)
        	            			{
        	            				if (strcmp((char *)val, "file") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_FILE);
        	            				}
        	            				else if (strcmp((char *)val, "url") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_HTTP);
        	            				}
        	            				else if (strcmp((char *)val, "spotify") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_SPOTIFY);
        	            				}
        	            				else if (strcmp((char *)val, "pipe") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_PIPE);
        	            				}
        	            			}
        	            			
        	            			
        	            result= (ENUMTAG13->getText(ENUMTAG13))->factory->newRaw((ENUMTAG13->getText(ENUMTAG13))->factory);

        	            			result
        	            ->append8(result
        	            , str);
        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleexpressionEx; /* Prevent compiler warnings */
    ruleexpressionEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end expression */

/**
 * $ANTLR start dateval
 * SMARTPL2SQL.g:207:1: dateval returns [ int result ] : ( DATE | interval BEFORE DATE | interval AFTER DATE | interval AGO );
 */
static int
dateval(pSMARTPL2SQL ctx)
{
    int result;


    pANTLR3_BASE_TREE    DATE15;
    pANTLR3_BASE_TREE    DATE16;
    pANTLR3_BASE_TREE    DATE18;
    int interval17;
    #undef	RETURN_TYPE_interval17
    #define	RETURN_TYPE_interval17 int

    int interval19;
    #undef	RETURN_TYPE_interval19
    #define	RETURN_TYPE_interval19 int

    int interval20;
    #undef	RETURN_TYPE_interval20
    #define	RETURN_TYPE_interval20 int

    /* Initialize rule variables
     */

     result= 0;
     
    DATE15       = NULL;
    DATE16       = NULL;
    DATE18       = NULL;

    {
        {
            //  SMARTPL2SQL.g:209:2: ( DATE | interval BEFORE DATE | interval AFTER DATE | interval AGO )

            ANTLR3_UINT32 alt2;

            alt2=4;

            switch ( LA(1) )
            {
            case DATE:
            	{
            		alt2=1;
            	}
                break;
            case INT:
            	{
            		switch ( LA(2) )
            		{
            		case DATINTERVAL:
            			{
            				switch ( LA(3) )
            				{
            				case BEFORE:
            					{
            						alt2=2;
            					}
            				    break;
            				case AFTER:
            					{
            						alt2=3;
            					}
            				    break;
            				case AGO:
            					{
            						alt2=4;
            					}
            				    break;

            				default:
            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 2;
            				    EXCEPTION->state        = 3;


            				    goto ruledatevalEx;

            				}

            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 2;
            		    EXCEPTION->state        = 2;


            		    goto ruledatevalEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruledatevalEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // SMARTPL2SQL.g:209:4: DATE
        	    {
        	        DATE15 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval257);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 datval;
        	            			
        	            			datval = (DATE15->getText(DATE15))->chars;
        	            			
        	            			if (strcmp((char *)datval, "today") == 0)
        	            			{
        	            				
        	            result= time(NULL);

        	            			}
        	            			else if (strcmp((char *)datval, "yesterday") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600;

        	            			}
        	            			else if (strcmp((char *)datval, "last week") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 7;

        	            			}
        	            			else if (strcmp((char *)datval, "last month") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 30;

        	            			}
        	            			else if (strcmp((char *)datval, "last year") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 365;

        	            			}
        	            			else
        	            			{
        	            				struct tm tm;
        	            				char year[5];
        	            				char month[3];
        	            				char day[3];
        	            				
        	            				memset((void*)&tm,0,sizeof(tm));
        	            				memset(year, 0, sizeof(year));
        	            				memset(month, 0, sizeof(month));
        	            				memset(day, 0, sizeof(day));

        	            				strncpy(year, (const char *)datval, 4);
        	            				strncpy(month, (const char *)datval + 5, 2);
        	            				strncpy(day, (const char *)datval + 8, 2);
        	            				
        	            				tm.tm_year = atoi(year) - 1900;
        	            				tm.tm_mon = atoi(month) - 1;
        	            				tm.tm_mday = atoi(day);
        	            				
        	            				result= mktime(&tm);

        	            			}
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // SMARTPL2SQL.g:258:4: interval BEFORE DATE
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval266);
        	        interval17=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	         MATCHT(BEFORE, &FOLLOW_BEFORE_in_dateval268);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        DATE16 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval270);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 datval;
        	            			
        	            			datval = (DATE16->getText(DATE16))->chars;
        	            			
        	            			if (strcmp((char *)datval, "yesterday") == 0)
        	            			{
        	            				
        	            result= time(NULL) - 24 * 3600;

        	            			}
        	            			else if (strcmp((char *)datval, "last week") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 7;

        	            			}
        	            			else if (strcmp((char *)datval, "last month") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 30;

        	            			}
        	            			else if (strcmp((char *)datval, "last year") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 365;

        	            			}
        	            			else
        	            			{
        	            				result= time(NULL);

        	            			}
        	            			
        	            			result= 
        	            result
        	             - interval17
        	            ;

        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // SMARTPL2SQL.g:287:4: interval AFTER DATE
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval279);
        	        interval19=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	         MATCHT(AFTER, &FOLLOW_AFTER_in_dateval281);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        DATE18 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval283);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 datval;
        	            			
        	            			datval = (DATE18->getText(DATE18))->chars;
        	            			
        	            			if (strcmp((char *)datval, "yesterday") == 0)
        	            			{
        	            				
        	            result= time(NULL) - 24 * 3600;

        	            			}
        	            			else if (strcmp((char *)datval, "last week") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 7;

        	            			}
        	            			else if (strcmp((char *)datval, "last month") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 30;

        	            			}
        	            			else if (strcmp((char *)datval, "last year") == 0)
        	            			{
        	            				result= time(NULL) - 24 * 3600 * 365;

        	            			}
        	            			else
        	            			{
        	            				result= time(NULL);

        	            			}
        	            			
        	            			result= 
        	            result
        	             + interval19
        	            ;

        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // SMARTPL2SQL.g:316:4: interval AGO
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval292);
        	        interval20=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	         MATCHT(AGO, &FOLLOW_AGO_in_dateval294);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			result= time(NULL) - 
        	            interval20
        	            ;

        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledatevalEx; /* Prevent compiler warnings */
    ruledatevalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end dateval */

/**
 * $ANTLR start interval
 * SMARTPL2SQL.g:322:1: interval returns [ int result ] : INT DATINTERVAL ;
 */
static int
interval(pSMARTPL2SQL ctx)
{
    int result;


    pANTLR3_BASE_TREE    INT21;
    pANTLR3_BASE_TREE    DATINTERVAL22;

    /* Initialize rule variables
     */

     result= 0;
     
    INT21       = NULL;
    DATINTERVAL22       = NULL;

    {
        // SMARTPL2SQL.g:324:2: ( INT DATINTERVAL )
        // SMARTPL2SQL.g:324:4: INT DATINTERVAL
        {
            INT21 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_interval318);
            if  (HASEXCEPTION())
            {
                goto ruleintervalEx;
            }


            DATINTERVAL22 = (pANTLR3_BASE_TREE) MATCHT(DATINTERVAL, &FOLLOW_DATINTERVAL_in_interval320);
            if  (HASEXCEPTION())
            {
                goto ruleintervalEx;
            }


            {

                			pANTLR3_UINT8 interval;
                			
                			result= atoi((const char *)(INT21->getText(INT21))->chars);

                			interval = (DATINTERVAL22->getText(DATINTERVAL22))->chars;
                			
                			if (strcmp((char *)interval, "days") == 0)
                			{
                				
                result= 
                result
                 * 24 * 3600;

                			}
                			else if (strcmp((char *)interval, "weeks") == 0)
                			{
                				result= 
                result
                 * 24 * 3600 * 7;

                			}
                			else if (strcmp((char *)interval, "months") == 0)
                			{
                				result= 
                result
                 * 24 * 3600 * 30;

                			}
                			else if (strcmp((char *)interval, "weeks") == 0)
                			{
                				result= 
                result
                 * 24 * 3600 * 365;

                			}
                			else
                			{
                				result= 0;

                			}
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleintervalEx; /* Prevent compiler warnings */
    ruleintervalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end interval */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
