<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>core - Serveur Apache HTTP Version 2.2</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Fonctionalits de Base Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../de/mod/core.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/core.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/core.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/core.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fonctionnalits de base du serveur HTTP Apache disponibles
en toutes circonstances</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Core</td></tr></table>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#acceptfilter">AcceptFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#acceptpathinfo">AcceptPathInfo</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#accessfilename">AccessFileName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#adddefaultcharset">AddDefaultCharset</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addoutputfilterbytype">AddOutputFilterByType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#allowencodedslashes">AllowEncodedSlashes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#allowoverride">AllowOverride</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authname">AuthName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authtype">AuthType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgimapextension">CGIMapExtension</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#contentdigest">ContentDigest</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#defaulttype">DefaultType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#directory">&lt;Directory&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#directorymatch">&lt;DirectoryMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#documentroot">DocumentRoot</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enablemmap">EnableMMAP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enablesendfile">EnableSendfile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#errordocument">ErrorDocument</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#errorlog">ErrorLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#fileetag">FileETag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#files">&lt;Files&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#filesmatch">&lt;FilesMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#forcetype">ForceType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gprofdir">GprofDir</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#hostnamelookups">HostnameLookups</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ifdefine">&lt;IfDefine&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ifmodule">&lt;IfModule&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#include">Include</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#keepalive">KeepAlive</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#keepalivetimeout">KeepAliveTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limit">&lt;Limit&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitexcept">&lt;LimitExcept&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitinternalrecursion">LimitInternalRecursion</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestbody">LimitRequestBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestfields">LimitRequestFields</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestfieldsize">LimitRequestFieldSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestline">LimitRequestLine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitxmlrequestbody">LimitXMLRequestBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#location">&lt;Location&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#locationmatch">&lt;LocationMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#loglevel">LogLevel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxkeepaliverequests">MaxKeepAliveRequests</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxranges">MaxRanges</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#mergetrailers">MergeTrailers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#namevirtualhost">NameVirtualHost</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#options">Options</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#protocol">Protocol</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#require">Require</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitcpu">RLimitCPU</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitmem">RLimitMEM</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitnproc">RLimitNPROC</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#satisfy">Satisfy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#scriptinterpretersource">ScriptInterpreterSource</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serveradmin">ServerAdmin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serveralias">ServerAlias</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#servername">ServerName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverpath">ServerPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverroot">ServerRoot</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serversignature">ServerSignature</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#servertokens">ServerTokens</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sethandler">SetHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setinputfilter">SetInputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setoutputfilter">SetOutputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#suexec">Suexec</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#timeout">TimeOut</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#traceenable">TraceEnable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usecanonicalname">UseCanonicalName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#virtualhost">&lt;VirtualHost&gt;</a></li>
</ul>
<ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="acceptfilter" id="acceptfilter">Directive</a> <a name="AcceptFilter" id="AcceptFilter">AcceptFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet d'optimiser la configuration d'un socket pour
l'coute d'un protocole</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AcceptFilter <var>protocole</var> <var>filtre
d'acceptation</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible avec Apache version 2.1.5 et
suprieures</td></tr>
</table>
    <p>Cette directive permet d'effectuer une optimisation du socket
    d'coute d'un type de protocole en fonction du systme
    d'exploitation. Le but premier est de faire en sorte que le noyau
    n'envoie pas de socket au processus du serveur jusqu' ce que
    des donnes soient reues, ou qu'une requte HTTP complte soit mise
    en tampon. Seuls les <a href="http://www.freebsd.org/cgi/man.cgi?query=accept_filter&amp;     sektion=9">Filtres d'acceptation de FreeBSD</a> et le filtre plus
    primitif <code>TCP_DEFER_ACCEPT</code> sous Linux sont actuellement
    supports.</p>

    <p>Sous FreeBSD, les valeurs par dfaut sont :</p>
    <div class="example"><p><code>
        AcceptFilter http httpready <br />
        AcceptFilter https dataready
    </code></p></div>

    <p>Le filtre d'acceptation <code>httpready</code> met en tampon des
    requtes HTTP entires au niveau du noyau. Quand une requte
    entire a t reue, le noyau l'envoie au serveur. Voir la page de
    manuel de <a href="http://www.freebsd.org/cgi/man.cgi?query=accf_http&amp;     sektion=9">accf_http(9)</a> pour plus de dtails. Comme les requtes
    HTTPS sont chiffres, celles-ci n'autorisent que le filtre <a href="http://www.freebsd.org/cgi/man.cgi?query=accf_data&amp;     sektion=9">accf_data(9)</a>.</p>

    <p>Sous Linux, les valeurs par dfaut sont :</p>
    <div class="example"><p><code>
        AcceptFilter http data <br />
        AcceptFilter https data
    </code></p></div>

    <p>Le filtre <code>TCP_DEFER_ACCEPT</code> de Linux ne supporte pas
    la mise en tampon des requtes http. Toute valeur autre que
    <code>none</code> active le filtre <code>TCP_DEFER_ACCEPT</code>
    pour ce protocole. Pour plus de dtails, voir la page de
    manuel Linux de <a href="http://homepages.cwi.nl/~aeb/linux/man2html/man7/     tcp.7.html">tcp(7)</a>.</p>

    <p>L'utilisation de la valeur <code>none</code> comme argument
    dsactive tout filtre d'acceptation pour ce protocole. Elle peut
    tre utile dans le cas d'un protocole pour lequel un serveur doit
    d'abord envoyer des donnes, comme <code>nntp</code> :</p>
    <div class="example"><p><code>AcceptFilter nntp none</code></p></div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive">Protocol</code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="acceptpathinfo" id="acceptpathinfo">Directive</a> <a name="AcceptPathInfo" id="AcceptPathInfo">AcceptPathInfo</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les ressources acceptent des informations sous forme d'un
nom de chemin en fin de requte.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AcceptPathInfo On|Off|Default</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AcceptPathInfo Default</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible avec Apache version 2.0.30 et
suprieures</td></tr>
</table>

    <p>Cette directive permet de dfinir si les requtes contenant des
    informations sous forme d'un nom de chemin suivant le nom d'un
    fichier rel (ou un fichier qui n'existe pas dans un rpertoire qui
    existe) doivent tre acceptes ou rejetes. Les scripts peuvent
    accder  cette information via la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>Supposons par exemple que <code>/test/</code> pointe vers un
    rpertoire qui ne contient que le fichier <code>here.html</code>.
    Les requtes pour <code>/test/here.html/more</code> et
    <code>/test/nothere.html/more</code> vont affecter la valeur
    <code>/more</code>  la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>L'argument de la directive <code class="directive">AcceptPathInfo</code>
    possde trois valeurs possibles :</p>
    <dl>
    <dt><code>Off</code></dt><dd>Une requte ne sera accepte que si
    elle correspond  un chemin qui existe. Par consquent, une requte
    contenant une information de chemin aprs le nom de fichier rel
    comme <code>/test/here.html/more</code> dans l'exemple ci-dessus
    renverra une erreur "404 NOT FOUND".</dd>

    <dt><code>On</code></dt><dd>Une requte sera accepte si la partie
    principale du chemin correspond  un fichier existant. Dans
    l'exemple ci-dessus <code>/test/here.html/more</code>, la requte
    sera accepte si <code>/test/here.html</code> correspond  un nom de
    fichier valide.</dd>

    <dt><code>Default</code></dt><dd>Le traitement des requtes est
    dtermin par le <a href="../handler.html">gestionnaire</a> responsable de la requte.
    Le gestionnaire de base pour les fichiers normaux rejette par dfaut
    les requtes avec <code>PATH_INFO</code>. Les gestionnaires qui
    servent des scripts, comme<a href="mod_cgi.html">cgi-script</a> et <a href="mod_isapi.html">isapi-handler</a>, acceptent en gnral par
    dfaut les requtes avec <code>PATH_INFO</code>.</dd>
    </dl>

    <p>Le but premier de la directive <code>AcceptPathInfo</code> est de
    vous permettre de remplacer le choix du gestionnaire d'accepter ou
    de rejeter <code>PATH_INFO</code>. Ce remplacement est ncessaire
    par exemple, lorsque vous utilisez un <a href="../filter.html">filtre</a>, comme <a href="mod_include.html">INCLUDES</a>, pour gnrer un contenu bas
    sur <code>PATH_INFO</code>. Le gestionnaire de base va en gnral
    rejeter la requte, et vous pouvez utiliser la configuration
    suivante pour utiliser un tel script :</p>

    <div class="example"><p><code>
      &lt;Files "mes-chemins.shtml"&gt;<br />
      <span class="indent">
        Options +Includes<br />
        SetOutputFilter INCLUDES<br />
        AcceptPathInfo On<br />
      </span>
      &lt;/Files&gt;
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="accessfilename" id="accessfilename">Directive</a> <a name="AccessFileName" id="AccessFileName">AccessFileName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom du fichier de configuration distribu</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AccessFileName <var>nom-du-fichier</var>
[<var>nom-du-fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AccessFileName .htaccess</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Au cours du traitement d'une requte, le serveur recherche le
    premier fichier de configuration existant  partir de la liste
    de noms dans chaque rpertoire composant le chemin du document, 
    partir du moment o les fichiers de configuration distribus sont <a href="#allowoverride">activs pour ce rpertoire</a>. Par exemple
    :</p>

    <div class="example"><p><code>
      AccessFileName .acl
    </code></p></div>

    <p>avant de renvoyer le document
    <code>/usr/local/web/index.html</code>, le serveur va rechercher les
    fichiers <code>/.acl</code>, <code>/usr/.acl</code>,
    <code>/usr/local/.acl</code> et <code>/usr/local/web/.acl</code>
    pour y lire d'ventuelles directives,  moins quelles n'aient t
    dsactives avec</p>

    <div class="example"><p><code>
      &lt;Directory /&gt;<br />
      <span class="indent">
        AllowOverride None<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#allowoverride">AllowOverride</a></code></li>
<li><a href="../configuring.html">Fichiers de configuration</a></li>
<li><a href="../howto/htaccess.html">Fichiers .htaccess</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="adddefaultcharset" id="adddefaultcharset">Directive</a> <a name="AddDefaultCharset" id="AddDefaultCharset">AddDefaultCharset</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Paramtre jeu de caractres par dfaut  ajouter quand le
type de contenu d'une rponse est <code>text/plain</code> ou
<code>text/html</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddDefaultCharset On|Off|<var>jeu de caractres</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AddDefaultCharset Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive spcifie une valeur par dfaut pour le paramtre
    jeu de caractres du type de mdia (le nom d'un codage de
    caractres)  ajouter  une rponse, si et seulement si le type de
    contenu de la rponse est soit <code>text/plain</code>, soit
    <code>text/html</code>. Ceci va remplacer
    tout jeu de caractres spcifi dans le corps de la rponse via un
    lment <code>META</code>, bien que cet effet dpende en fait
    souvent de la configuration du client de l'utilisateur. La
    dfinition de <code>AddDefaultCharset Off</code> dsactive cette
    fonctionnalit. <code>AddDefaultCharset On</code> ajoute un jeu de
    caractres par dfaut de <code>iso-8859-1</code>. Toute autre valeur
    peut tre dfinie via le paramtre <var>jeu de caractres</var>, qui
    doit appartenir  la liste des <a href="http://www.iana.org/assignments/character-sets">valeurs de
    jeux de caractres enregistrs par l'IANA</a>  utiliser dans les
    types de mdia MIME.
    Par exemple :</p>

    <div class="example"><p><code>
      AddDefaultCharset utf-8
    </code></p></div>

    <p>La directive <code class="directive">AddDefaultCharset</code> ne doit
    tre utilise que lorsque toutes les ressources textes auxquelles
    elle s'applique possdent le jeu de caractre spcifi, et qu'il est
    trop contraignant de dfinir leur jeu de caractres
    individuellement. Un exemple de ce type est l'ajout du paramtre jeu
    de caractres aux ressources comportant un contenu gnr, comme les
    scripts CGI hrits qui peuvent tre vulnrables  des attaques de
    type cross-site scripting  cause des donnes utilisateurs incluses
    dans leur sortie. Notez cependant qu'une meilleur solution consiste
     corriger (ou supprimer) ces scripts, car la dfinition d'un jeu de
    caractres par dfaut ne protge pas les utilisateurs qui ont activ
    la fonctionnalit "Dtection automatique de l'encodage des
    caractres" dans leur navigateur.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addcharset">AddCharset</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addoutputfilterbytype" id="addoutputfilterbytype">Directive</a> <a name="AddOutputFilterByType" id="AddOutputFilterByType">AddOutputFilterByType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>assigne un filtre en sortie pour un type MIME
particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddOutputFilterByType <var>filtre</var>[;<var>filtre</var>...]
<var>type MIME</var> [<var>type MIME</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans Apache version 2.0.33 et suprieures ;
obsolte depuis les versions 2.1</td></tr>
</table>
    <p>Cette directive active un <a href="../filter.html">filtre</a> en sortie particulier pour une
    requte en fonction du <a class="glossarylink" href="../glossary.html#type mime" title="voir glossaire">type MIME</a> de la rponse.
    Suite  certains problmes voqus plus loin, cette directive a t
    abandonne. Le mme rsultat peut tre obtenu  l'aide du module
    <code class="module"><a href="../mod/mod_filter.html">mod_filter</a></code>.</p>

    <p>L'exemple suivant active le filtre <code>DEFLATE</code> qui est
    fourni par le module <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code>. Il va compresser
    toute sortie dont le type MIME est <code>text/html</code> ou
    <code>text/plain</code> avant de l'envoyer au client.</p>

    <div class="example"><p><code>
      AddOutputFilterByType DEFLATE text/html text/plain
    </code></p></div>

    <p>Si vous voulez assigner plusieurs filtres au contenu, leurs noms
    doivent tre spars par des points-virgules. On peut aussi utiliser
    une directive <code class="directive">AddOutputFilterByType</code> pour
    chacun des filtres  assigner.</p>

    <p>La configuration ci-dessous impose le traitement de toute sortie
    de script dont le type MIME est <code>text/html</code> en premier
    lieu par le filtre <code>INCLUDES</code>, puis par le filtre
    <code>DEFLATE</code>.</p>

    <div class="example"><p><code>
    &lt;Location /cgi-bin/&gt;<br />
    <span class="indent">
      Options Includes<br />
      AddOutputFilterByType INCLUDES;DEFLATE text/html<br />
    </span>
    &lt;/Location&gt;
    </code></p></div>

    <div class="warning"><h3>Note</h3>
      <p>L'activation de filtres par la directive
      <code class="directive">AddOutputFilterByType</code> peut partiellement
      chouer, ou mme compltement dans certains cas. Par exemple,
      aucun filtre n'est appliqu si le <a class="glossarylink" href="../glossary.html#type mime" title="voir glossaire">type MIME</a>
      n'a pas pu tre dtermin et est dans ce cas dfini par la
      directive <code class="directive"><a href="#defaulttype">DefaultType</a></code>, mme
      si la directive <code class="directive"><a href="#defaulttype">DefaultType</a></code> a
      la mme valeur.</p>

      <p>Cependant, si vous voulez vous assurer que les filtres seront
      appliqus, assignez explicitement le type de contenu  une
      ressource, par exemple  l'aide d'une directive <code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code> ou <code class="directive"><a href="#forcetype">ForceType</a></code>. Il est aussi recommand de
      dfinir le type de contenu dans un script CGI (non-nph).</p>

    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addoutputfilter">AddOutputFilter</a></code></li>
<li><code class="directive"><a href="#setoutputfilter">SetOutputFilter</a></code></li>
<li><a href="../filter.html">Les filtres</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allowencodedslashes" id="allowencodedslashes">Directive</a> <a name="AllowEncodedSlashes" id="AllowEncodedSlashes">AllowEncodedSlashes</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les sparateurs de chemin encods sont
autoriss  transiter dans les URLs tel quel</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AllowEncodedSlashes On|Off|NoDecode</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AllowEncodedSlashes Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans Apache version 2.0.46 et
ultrieures. L'option NoDecode est disponible depuis la version
2.2.18.</td></tr>
</table>
    <p>La directive <code class="directive">AllowEncodedSlashes</code> permet
    l'utilisation des URLs contenant des sparateurs de chemin
    encods dans la partie chemin
    (<code>%2F</code> pour <code>/</code> et mme <code>%5C</code> pour
    <code>\</code> sur les systmes concerns).</p>

    <p>Avec la valeur par dfaut, <code>Off</code>, de telles URLs sont
    refuses et provoquent le renvoi d'une erreur 404 (Not found).</p>

    <p>Avec la valeur <code>On</code>, ces URLs sont acceptes, et les
    slashes encods sont dcods comme tout autre caractre cod.</p>

    <p>Avec la valeur <code>NoDecode</code>, ces URLs sont acceptes,
    mais les slashes cods ne sont pas dcods et laisss dans leur tat
    cod.</p>

    <p>Dfinir <code class="directive">AllowEncodedSlashes</code> 
    <code>On</code> est surtout utile en association avec
    <code>PATH_INFO</code>.</p>

    <div class="note"><h3>Note</h3>
      <p>Si le codage des slashes dans la partie chemin est ncessaire,
      l'utilisation de l'option <code>NoDecode</code> est fortement
      recommande par mesure de scurit. Permettre le dcodage des
      slashes pourrait ventuellement induire l'autorisation de chemins
      non srs.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#acceptpathinfo">AcceptPathInfo</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allowoverride" id="allowoverride">Directive</a> <a name="AllowOverride" id="AllowOverride">AllowOverride</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Types de directives autorises dans les fichiers
<code>.htaccess</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AllowOverride All|None|<var>type directive</var>
[<var>type directive</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AllowOverride All</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code> (dont
    le nom est dfini par la directive <code class="directive"><a href="#accessfilename">AccessFileName</a></code>), il doit savoir lesquelles
    des directives places dans ce fichier sont autorises  modifier la
    configuration prexistante.</p>

    <div class="note"><h3>Valable seulement dans les sections
    &lt;Directory&gt;</h3>
    La directive <code class="directive">AllowOverride</code> ne peut tre
    utilise que dans les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> dfinies sans expressions
    rationnelles, et non dans les sections <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, <code class="directive"><a href="#directorymatch">&lt;DirectoryMatch&gt;</a></code> ou
    <code class="directive"><a href="#files">&lt;Files&gt;</a></code>.
    </div>

    <p>Lorsque cette directive est dfinie  <code>None</code>, les
    fichiers <a href="#accessfilename">.htaccess</a> sont totalement
    ignors. Dans ce cas, le serveur n'essaiera mme pas de lire les
    fichiers <code>.htaccess</code> du systme de fichiers.</p>

    <p>Lorsque cette directive est dfinie  <code>All</code>, toute
    directive valable dans le <a href="directive-dict.html#Context">Contexte</a> .htaccess sera
    autorise dans les fichiers <code>.htaccess</code>.</p>

    <p>L'argument <var>type directive</var> peut contenir les
    groupements de directives suivants :</p>

    <dl>
      <dt>AuthConfig</dt>

      <dd>

      Permet l'utilisation des directives d'autorisation (<code class="directive"><a href="../mod/mod_authz_dbm.html#authdbmgroupfile">AuthDBMGroupFile</a></code>,
      <code class="directive"><a href="../mod/mod_authn_dbm.html#authdbmuserfile">AuthDBMUserFile</a></code>,
      <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code>,
      <code class="directive"><a href="#authname">AuthName</a></code>,
      <code class="directive"><a href="#authtype">AuthType</a></code>, <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>, <code class="directive"><a href="#require">Require</a></code>, <em>etc.</em>).</dd>

      <dt>FileInfo</dt>

      <dd>
      Permet l'utilisation des directives qui contrlent les types de
      documents (directives <code class="directive"><a href="#defaulttype">DefaultType</a></code>, <code class="directive"><a href="#errordocument">ErrorDocument</a></code>, <code class="directive"><a href="#forcetype">ForceType</a></code>, <code class="directive"><a href="../mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code>,
      <code class="directive"><a href="#sethandler">SetHandler</a></code>, <code class="directive"><a href="#setinputfilter">SetInputFilter</a></code>, <code class="directive"><a href="#setoutputfilter">SetOutputFilter</a></code>, et directives du
      module <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> Add* et Remove*,
      <em>etc...</em>), des metadonnes des documents (<code class="directive"><a href="../mod/mod_headers.html#header">Header</a></code>, <code class="directive"><a href="../mod/mod_headers.html#requestheader">RequestHeader</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#setenvifnocase">SetEnvIfNoCase</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookieexpires">CookieExpires</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiedomain">CookieDomain</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiestyle">CookieStyle</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookietracking">CookieTracking</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiename">CookieName</a></code>), des directives du
      module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> (<code class="directive"><a href="../mod/mod_rewrite.html#rewriteengine">RewriteEngine</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewriteoptions">RewriteOptions</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewritebase">RewriteBase</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>), des directives du
      module <code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> directives (<code class="directive"><a href="../mod/mod_alias.html#redirect">Redirect</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirecttemp">RedirectTemp</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirectpermanent">RedirectPermanent</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirectmatch">RedirectMatch</a></code>), et de la directive
      <code class="directive"><a href="../mod/mod_actions.html#action">Action</a></code> du module
      <code class="module"><a href="../mod/mod_actions.html">mod_actions</a></code>.
      </dd>

      <dt>Indexes</dt>

      <dd>
      Permet l'utilisation des directives qui contrlent l'indexation
      des rpertoires (<code class="directive"><a href="../mod/mod_autoindex.html#adddescription">AddDescription</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#addicon">AddIcon</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#addiconbyencoding">AddIconByEncoding</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#addiconbytype">AddIconByType</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#defaulticon">DefaultIcon</a></code>, <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>, <a href="mod_autoindex.html#indexoptions.fancyindexing"><code>FancyIndexing</code></a>,
      <code class="directive"><a href="../mod/mod_autoindex.html#headername">HeaderName</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#indexignore">IndexIgnore</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#indexoptions">IndexOptions</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#readmename">ReadmeName</a></code>,
      <em>etc...</em>).</dd>

      <dt>Limit</dt>

      <dd>
      Permet l'utilisation des directives contrlant l'accs au serveur
      (<code class="directive"><a href="../mod/mod_authz_host.html#allow">Allow</a></code>, <code class="directive"><a href="../mod/mod_authz_host.html#deny">Deny</a></code> et <code class="directive"><a href="../mod/mod_authz_host.html#order">Order</a></code>).</dd>

      <dt>Options[=<var>Option</var>,...]</dt>

      <dd>
      Permet l'utilisation des directives contrlant les fonctionnalits
      spcifiques d'un rpertoire (<code class="directive"><a href="#options">Options</a></code> et <code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code>). "Options" doit tre
      suivi d'un signe "gal", puis d'une liste d'options spares par des
      virgules (pas d'espaces) ; ces options doivent tre dfinies 
      l'aide de la commande <code class="directive"><a href="#options">Options</a></code>.
      
      <div class="note"><h3>Dsactivation implicite des options</h3>
      <p>Bien que la liste des options disponibles dans les fichiers
      .htaccess puisse tre limite par cette directive, tant qu'un
      directive <code class="directive"><a href="#options">Options</a></code> est
      autorise, toute autre option hrite peut tre dsactive en
      utilisant la syntaxe non-relative. En d'autres termes, ce
      mcanisme ne peut pas forcer une option spcifique  rester
      <em>active</em> tout en permettant  toute autre option d'tre
      active.
      </p></div>
      </dd>
    </dl>

    <p>Exemple :</p>

    <div class="example"><p><code>
      AllowOverride AuthConfig Indexes
    </code></p></div>

    <p>Dans l'exemple ci-dessus, toutes les directives qui ne font
    partie ni du groupe <code>AuthConfig</code>, ni du groupe
    <code>Indexes</code>, provoquent une "internal
    server error".</p>

    <div class="note"><p>Pour des raisons de scurit et de performances, n'affectez
    pas  <code>AllowOverride</code> une autre valeur que
    <code>None</code> dans votre bloc <code>&lt;Directory /&gt;</code>.
    Configurez plutt le bloc <code>&lt;Directory&gt;</code> qui
    concerne le rpertoire dans lequel vous voulez placer votre fichier
    <code>.htaccess</code> (ou crez-le s'il n'existe pas).</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#accessfilename">AccessFileName</a></code></li>
<li><a href="../configuring.html">Fichiers de Configuration</a></li>
<li><a href="../howto/htaccess.html">Fichiers .htaccess</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authname" id="authname">Directive</a> <a name="AuthName" id="AuthName">AuthName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Identificateur d'autorisation  utiliser pour
l'authentification HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthName <var>domaine d'authentification</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir l'identificateur d'autorisation
    pour un rpertoire. Cet identificateur est fourni au client afin que
    ce dernier sache quels nom d'utilisateur et mot de passe envoyer.
    <code class="directive">AuthName</code> n'accepte qu'un seul argument ; si
    l'identificateur contient des espaces, il doit tre entour
    d'apostrophes. Il doit tre associ  des directives <code class="directive"><a href="#authtype">AuthType</a></code> et <code class="directive"><a href="#require">Require</a></code>, ainsi qu' des directives telles
    que <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> et
    <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code>
    pour pouvoir fonctionner.</p>

   <p>Par exemple :</p>

   <div class="example"><p><code>
     AuthName "Top Secret"
   </code></p></div>

    <p>La chane de caractres dfinie par la directive
    <code>AuthName</code> correspond  celle que la plupart des
    navigateurs vont fournir dans la bote de dialogue de saisie du mot
    de passe.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/auth.html">Authentification, Autorisation, et
    contrle d'accs</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authtype" id="authtype">Directive</a> <a name="AuthType" id="AuthType">AuthType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le type d'authentification de l'utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthType Basic|Digest</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir le type d'authentification de
    l'utilisateur pour un rpertoire. Les types d'authentification
    disponibles sont <code>Basic</code> (implment par
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>), et <code>Digest</code> (implment
    par <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>).</p>

    <p>Pour que l'authentification fonctionne, vous devez aussi dfinir
    les directives <code class="directive"><a href="#authname">AuthName</a></code> et <code class="directive"><a href="#require">Require</a></code>.
    En outre, le serveur doit avoir  sa disposition un module
    fournisseur d'authentification tel que
    <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code> et un module d'autorisation tel que
    <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/auth.html">Authentification et autorisation</a></li>
<li><a href="../howto/access.html">Tutoriel du contrle d'accs</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cgimapextension" id="cgimapextension">Directive</a> <a name="CGIMapExtension" id="CGIMapExtension">CGIMapExtension</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Technique permettant de localiser l'interprteur des
scripts CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CGIMapExtension <var>chemin CGI</var> <var>.extension</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>NetWare uniquement</td></tr>
</table>
    <p>Cette directive permet de contrler la manire dont Apache trouve
    l'interprteur servant  excuter les scripts CGI. Par exemple, avec
    la dfinition <code>CGIMapExtension sys:\foo.nlm .foo</code>, tous
    les fichiers scripts CGI possdant une extension <code>.foo</code>
    seront passs  l'interprteur FOO.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="contentdigest" id="contentdigest">Directive</a> <a name="ContentDigest" id="ContentDigest">ContentDigest</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la gnration d'un en-tte <code>Content-MD5</code>
dans la rponse HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ContentDigest On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ContentDigest Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive active la gnration d'un en-tte
    <code>Content-MD5</code> selon les dfinitions des RFC 1864 et
    2616.</p>

    <p>MD5 est un algorithme permettant de gnrer un condens (parfois
    appel "empreinte")  partir de donnes d'une taille alatoire ; le
    degr de prcision est tel que la moindre altration des donnes
    d'origine entrane une altration de l'empreinte.</p>

    <p>L'en-tte <code>Content-MD5</code> permet de vrifier
    l'intgrit de la rponse HTTP dans son ensemble. Un serveur mandataire
    ou un client peut utiliser cet en-tte pour rechercher une
    ventuelle modification accidentelle de la rponse au cours de sa
    transmission. Exemple d'en-tte :</p>

    <div class="example"><p><code>
      Content-MD5: AuLb7Dp1rqtRtxz2m9kRpA==
    </code></p></div>

    <p>Notez que des problmes de performances peuvent affecter votre
    serveur, car l'empreinte est gnre pour chaque requte (il n'y a
    pas de mise en cache).</p>

    <p>L'en-tte <code>Content-MD5</code> n'est envoy qu'avec les
    documents servis par le module <code class="module"><a href="../mod/core.html">core</a></code>,  l'exclusion
    de tout autre module. Ainsi, les documents SSI, les sorties de
    scripts CGI, et les rponses  des requtes partielles (byte range)
    ne comportent pas cet en-tte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="defaulttype" id="defaulttype">Directive</a> <a name="DefaultType" id="DefaultType">DefaultType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Type de contenu MIME qui sera envoy par dfaut si le
serveur ne peut le dterminer d'aucune manire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DefaultType <var>type MIME|none</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DefaultType text/plain</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>L'argument <code>none</code> est disponible dans les
versions d'Apache 2.2.7 et suprieures</td></tr>
</table>
    <p>Il peut arriver que le serveur doive servir un document dont il
    ne peut pas dterminer le type  partir de sa table de <a class="glossarylink" href="../glossary.html#mime-type" title="voir glossaire">types MIME</a>.</p>

    <p>Le serveur DEVRAIT fournir au client le type de contenu du
    document. Si le serveur n'est pas capable de le dterminer par la
    voie normale, il fournira le type dfini par la directive
    <code>DefaultType</code>. Par exemple :</p>

    <div class="example"><p><code>
      DefaultType image/gif
    </code></p></div>

    <p>conviendra pour un rpertoire contenant de nombreuses images GIF
    dont le fichier ne comporte pas l'extension <code>.gif</code>.</p>

    <p>Dans les cas o ni le serveur, ni l'administrateur (ou un
    serveur mandataire) ne sont en mesure de dterminer le type du
    document, il est prfrable de ne pas le mentionner, plutt que de
    fournir de fausses informations.  cet effet, on utilise </p>
    <div class="example"><p><code>
      DefaultType None
    </code></p></div>
    <p><code>DefaultType None</code> n'est disponible que dans les
    versions d'Apache 2.2.7 et suprieures.</p>

    <p>Notez qu' la diffrence de la directive <code class="directive"><a href="#forcetype">ForceType</a></code>, cette directive ne dfinit que
    le type MIME par dfaut. Toute autre dfinition de type MIME, y
    compris l'extension des noms de fichiers, susceptible de
    permettre d'identifier le type de mdia l'emportera sur la valeur
    par dfaut.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="directory" id="directory">Directive</a> <a name="Directory" id="Directory">&lt;Directory&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe un ensemble de directives qui ne s'appliquent
qu'au rpertoire concern du systme de fichiers,  ses
sous-rpertoires, et  leur contenu.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Directory <var>chemin rpertoire</var>&gt;
... &lt;/Directory&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;Directory&gt;</code> et
    <code>&lt;/Directory&gt;</code> permettent de regrouper un ensemble
    de directives qui ne s'appliquent qu'au rpertoire
    prcis,  ses sous-rpertoires, et aux fichiers situs dans ces
    sous-rpertoires. Toute directive
    autorise dans un contexte de rpertoire peut tre utilise.
    <var>chemin rpertoire</var> est soit le chemin absolu d'un
    rpertoire, soit une chane de caractres avec caractres gnriques
    utilisant la comparaison Unix de style shell. Dans une chane de
    caractres avec caractres gnriques, <code>?</code> correspond 
    un caractre quelconque, et <code>*</code>  toute chane de
    caractres. Les intervalles de caractres <code>[]</code> sont aussi
    autoriss. Aucun caractre gnrique ne peut remplacer le caractre
    `/', si bien que l'expression <code>&lt;Directory
    /*/public_html&gt;</code> ne conviendra pas pour le chemin
     * <code>/home/user/public_html</code>, alors que <code>&lt;Directory
    /home/*/public_html&gt;</code> conviendra. Exemple :</p>

    <div class="example"><p><code>
      &lt;Directory /usr/local/httpd/htdocs&gt;<br />
      <span class="indent">
        Options Indexes FollowSymLinks<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <div class="note">
      <p>Soyez prudent avec l'argument <var>chemin rpertoire</var> : il
      doit correspondre exactement au chemin du systme de fichier
      qu'Apache utilise pour accder aux fichiers. Les directives
      comprises dans une section <code>&lt;Directory&gt;</code> ne
      s'appliqueront pas aux fichiers du mme rpertoire auxquels on
      aura accd via un chemin diffrent, per exemple via un lien
      symbolique.</p>
    </div>

    <p> Les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions rationnelles</a>
    peuvent aussi tre utilises en ajoutant le caractre
    <code>~</code>. Par exemple :</p>

    <div class="example"><p><code>
      &lt;Directory ~ "^/www/[0-9]{3}"&gt;
    </code></p></div>

    <p>pourra correspondre  tout rpertoire situ dans /www/ et dont le
    nom se compose de trois chiffres.</p>

    <p>Si plusieurs sections <code class="directive">&lt;Directory&gt;</code> (sans expression rationnelle)
    correspondent au rpertoire (ou  un de ses parents) qui contient le
    document, les directives de la section <code class="directive">&lt;Directory&gt;</code> dont le chemin est le plus
    court sont appliques en premier, en s'intercalant avec les
    directives des fichiers <a href="#accessfilename">.htaccess</a>. Par
    exemple, avec</p>

    <div class="example"><p><code>
      &lt;Directory /&gt;<br />
      <span class="indent">
        AllowOverride None<br />
      </span>
      &lt;/Directory&gt;<br />
      <br />
      &lt;Directory /home&gt;<br />
      <span class="indent">
        AllowOverride FileInfo<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>l'accs au document <code>/home/web/dir/doc.html</code> emprunte
    le chemin suivant :</p>

    <ul>
      <li>Aplication de la directive <code>AllowOverride None</code>
      (qui dsactive les fichiers <code>.htaccess</code>).</li>

      <li>Application de la directive <code>AllowOverride
      FileInfo</code> (pour le rpertoire <code>/home</code>).</li>

      <li>Application de toute directive <code>FileInfo</code> qui se
      trouverait dans d'ventuels fichiers <code>/home/.htaccess</code>,
      <code>/home/web/.htaccess</code> ou
      <code>/home/web/dir/.htaccess</code>, dans cet ordre.</li>
    </ul>

    <p>Les directives associes aux rpertoires sous forme d'expressions
    rationnelles ne sont prises en compte qu'une fois toutes les
    directives des sections sans expressions rationnelles appliques.
    Alors, tous les rpertoires avec expressions rationnelles sont
    tests selon l'ordre dans lequel ils apparaissent dans le fichier de
    configuration. Par exemple, avec</p>

    <div class="example"><p><code>
      &lt;Directory ~ "public_html/.*"&gt;<br />
      <span class="indent">
        # ... directives here ...<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>la section avec expression rationnelle ne sera prise en compte
    qu'aprs les sections <code class="directive">&lt;Directory&gt;</code> sans expressions rationnelles
    et les fichiers <code>.htaccess</code>. Alors, l'expression
    rationnelle conviendra pour <code>/home/abc/public_html/abc</code>
    et la section <code class="directive">&lt;Directory&gt;</code>
    correspondante s'appliquera.</p>

   <p><strong>Notez que pour Apache, la politique d'accs par dfaut
   dans les sections <code>&lt;Directory /&gt;</code> est <code>Allow
   from All</code>. Ceci signifie qu'Apache va servir tout fichier
   correspondant  une URL. Il est recommand de modifier cette
   situation  l'aide d'un bloc du style</strong></p>

    <div class="example"><p><code>
      &lt;Directory /&gt;<br />
      <span class="indent">
        Order Deny,Allow<br />
        Deny from All<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p><strong>puis d'affiner la configuration pour les rpertoires que vous
    voulez rendre accessibles. Voir la page <a href="../misc/security_tips.html">Conseils  propos de la scurit</a>
    pour plus de dtails.</strong></p>

    <p>Les sections directory se situent dans le fichier
    <code>httpd.conf</code>. Les directives <code class="directive">&lt;Directory&gt;</code> ne peuvent pas tre imbriques
    et ne sont pas autorises dans les sections <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> ou <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour des
explications  propos de la manire dont ces diffrentes sections se
combinent entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="directorymatch" id="directorymatch">Directive</a> <a name="DirectoryMatch" id="DirectoryMatch">&lt;DirectoryMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe des directives qui s'appliquent  des rpertoires
du systme de fichiers correspondant  une expression rationnelle et 
leurs sous-rpertoires</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;DirectoryMatch <var>regex</var>&gt;
... &lt;/DirectoryMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;DirectoryMatch&gt;</code>
    et <code>&lt;/DirectoryMatch&gt;</code> permettent de regrouper un
    ensemble de directives qui ne s'appliqueront qu'au rpertoire
    prcis (et aux fichiers qu'il contient), comme pour la section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>. Cependant, le
    rpertoire est prcis sous la forme d'une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>. Par exemple :</p>

    <div class="example"><p><code>
      &lt;DirectoryMatch "^/www/(.+/)?[0-9]{3}"&gt;
    </code></p></div>

    <p>conviendrait pour les sous-rpertoires de <code>/www/</code> dont
    le nom se compose de trois chiffres.</p>

    <div class="note"><h3>Caractre de fin de ligne</h3>
      <p>Cette directive ne tient pas compte du caractre de fin de
      ligne ($).</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>
pour une description de la manire dont les expressions rationnelles
sont traites en prsence d'autres sections <code class="directive">&lt;Directory&gt;</code> sans expressions rationnelles</li>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication  propos de la manire dont ces diffrentes sections se
combinent entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="documentroot" id="documentroot">Directive</a> <a name="DocumentRoot" id="DocumentRoot">DocumentRoot</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Racine de l'arborescence des documents principale visible
depuis Internet</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DocumentRoot <var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DocumentRoot /usr/local/apache/htdocs</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir le rpertoire  partir duquel
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> va servir les fichiers. S'il ne correspond
    pas  un <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, le chemin
    de l'URL sera ajout par le serveur  la racine des documents afin
    de construire le chemin du document recherch. Exemple :</p>

    <div class="example"><p><code>
      DocumentRoot /usr/web
    </code></p></div>

    <p>un accs  <code>http://www.my.host.com/index.html</code> se
    rfre alors  <code>/usr/web/index.html</code>. Si <var>chemin
    rpertoire</var> n'est pas un chemin absolu, il est considr comme
    relatif au chemin dfini par la directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <p>Le rpertoire dfini par la directive
    <code class="directive">DocumentRoot</code> ne doit pas comporter de slash
    terminal.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../urlmapping.html#documentroot">Mise en
correspondance des URLs avec le systme de fichiers</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="enablemmap" id="enablemmap">Directive</a> <a name="EnableMMAP" id="EnableMMAP">EnableMMAP</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise la projection en mmoire (Memory-Mapping) pour
lire les fichiers pendant qu'ils sont servis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>EnableMMAP On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>EnableMMAP On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive dfinit si <code class="program"><a href="../programs/httpd.html">httpd</a></code> peut utiliser
    la projection en mmoire (Memory-Mapping) s'il doit lire le contenu
    d'un fichier pendant qu'il est servi. Par dfaut, lorsque le
    traitement d'une requte requiert l'accs aux donnes contenues dans
    un fichier -- par exemple, pour servir un fichier interprt par le
    serveur  l'aide de <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> -- Apache projette
    le fichier en mmoire si le systme d'exploitation le permet.</p>

    <p>Cette projection en mmoire induit parfois une amlioration des
    performances. Cependant, sur certains systmes, il est prfrable de
    dsactiver la projection en mmoire afin d'viter certains problmes
    oprationnels :</p>

    <ul>
    <li>Sur certains systmes multi-processeurs, la projection en
    mmoire peut dgrader les performances du programme
    <code class="program"><a href="../programs/httpd.html">httpd</a></code>.</li>
    <li>La suppression ou la troncature d'un fichier faisant l'objet
    d'une image en mmoire peut provoquer un crash de
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> avec une erreur de segmentation.
    </li>
    </ul>

    <p>Pour les configurations de serveur sujettes  ce genre de
    problme, il est prfrable de dsactiver la projection en mmoire
    des fichiers servis en spcifiant :</p>

    <div class="example"><p><code>
      EnableMMAP Off
    </code></p></div>

    <p>Pour les montages NFS, cette fonctionnalit peut tre
    explicitement dsactive pour les fichiers concerns en spcifiant
    :</p>

    <div class="example"><p><code>
      &lt;Directory "/chemin vers montage NFS"&gt;
      <span class="indent">
        EnableMMAP Off
      </span>
      &lt;/Directory&gt;
    </code></p></div>


    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="enablesendfile" id="enablesendfile">Directive</a> <a name="EnableSendfile" id="EnableSendfile">EnableSendfile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise le support sendfile du noyau pour servir les
fichiers aux clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>EnableSendfile On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>EnableSendfile On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans les versions 2.0.44 et
suprieures</td></tr>
</table>
    <p>Cette directive dfinit si le programme <code class="program"><a href="../programs/httpd.html">httpd</a></code>
    peut utiliser le support sendfile du noyau pour transmettre le
    contenu des fichiers aux clients. Par dfaut, lorsque le traitement
    d'une requte ne requiert pas l'accs aux donnes contenues dans un
    fichier -- par exemple, pour la transmission d'un fichier statique
    -- Apache utilise sendfile pour transmettre le contenu du fichier
    sans mme lire ce dernier, si le systme d'exploitation le
    permet.</p>

    <p>Ce mcanisme sendfile vite la sparation des oprations de
    lecture et d'envoi, ainsi que les rservations de tampons. sur
    certains systmes cependant, ou sous certains systmes de fichiers,
    il est prfrable de dsactiver cette fonctionnalit afin d'viter
    certains problmes oprationnels :</p>

    <ul>
    <li>Certains systmes peuvent prsenter un support sendfile
    dfectueux que le systme de compilation n'a pas dtect, en
    particulier si les excutables ont t compils sur une autre
    machine, puis copis sur la premire avec un support sendfile
    dfectueux.</li>
    <li>Sous Linux, l'utilisation de sendfile induit des bogues lors de
    la rcupration des paquets de vrification TCP (TCP-checksum) avec
    certaines cartes rseau lorsqu'on utilise IPv6.</li>
    <li>Sous Linux sur plateforme Itanium, sendfile peut s'avrer
    r.{1,2}pertoireincapable de traiter les fichiers de plus de 2 Go.</li>
    <li>Avec un montage rseau de <code class="directive"><a href="#documentroot">DocumentRoot</a></code> (par exemple NFS ou SMB), le
    noyau peut s'avrer incapable de servir un fichier de ce montage
    rseau en passant par son propre cache.</li>
    </ul>

    <p>Pour les configurations de serveur sujettes  ce genre de
    problme, il est recommand de dsactiver cette fonctionnalit en
    spcifiant :</p>

    <div class="example"><p><code>
      EnableSendfile Off
    </code></p></div>

    <p>Pour les montages NFS ou SMB, cette fonctionnalit peut tre
    explicitement dsactive pour les fichiers concerns en spcifiant
    :</p>

    <div class="example"><p><code>
      &lt;Directory "/chemin vers montage rseau"&gt;
      <span class="indent">
        EnableSendfile Off
      </span>
      &lt;/Directory&gt;
    </code></p></div>
    <p>Veuillez noter que la configuration de la directive
    <code class="directive">EnableSendfile</code> dans un contexte de rpertoire
    ou de fichier .htaccess n'est pas supporte par
    <code class="module"><a href="../mod/mod_disk_cache.html">mod_disk_cache</a></code>. Le module ne prend en compte la
    dfinition de <code class="directive">EnableSendfile</code> que dans un
    contexte global.
    </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="errordocument" id="errordocument">Directive</a> <a name="ErrorDocument" id="ErrorDocument">ErrorDocument</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Document que le serveur renvoie au client en cas
d'erreur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ErrorDocument <var>code erreur</var> <var>document</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>La syntaxe des guillemets pour les messages textes est
diffrente dans Apache 2.0</td></tr>
</table>
    <p>Apache peut traiter les problmes et les erreurs de quatre
    manires,</p>

    <ol>
      <li>afficher un simple message d'erreur au contenu fixe</li>

      <li>afficher un message personnalis</li>

      <li>rediriger en interne vers un <var>chemin d'URL</var> local pour traiter
      le problme ou l'erreur</li>

      <li>rediriger vers une <var>URL</var> externe pour traiter
      le problme ou l'erreur</li>
    </ol>

    <p>La premire option constitue le comportement par dfaut; pour
    choisir une des trois autres options, il faut configurer Apache 
    l'aide de la directive <code class="directive">ErrorDocument</code>, suivie
    du code de la rponse HTTP et d'une URL ou d'un message. Apache
    fournit parfois des informations supplmentaires  propos du
    problme ou de l'erreur.</p>

    <p>Les URLs peuvent commencer par un slash (/) pour les chemins web
    locaux (relatifs au rpertoire dfini par la directive <code class="directive"><a href="#documentroot">DocumentRoot</a></code>), ou se prsenter sous la
    forme d'une URL complte que le client pourra rsoudre.
    Alternativement, un message  afficher par le navigateur pourra tre
    fourni. Exemples :</p>

    <div class="example"><p><code>
      ErrorDocument 500 http://foo.example.com/cgi-bin/tester<br />
      ErrorDocument 404 /cgi-bin/bad_urls.pl<br />
      ErrorDocument 401 /subscription_info.html<br />
      ErrorDocument 403 "Dsol, vous n'avez pas l'autorisation d'accs
      aujourd'hui"
    </code></p></div>

    <p>De plus, on peut spcifier la valeur spciale <code>default</code>
    pour indiquer l'utilisation d'un simple message d'Apache cod en
    dur. Bien que non ncessaire dans des circonstances normales, la
    spcification de la valeur <code>default</code> va permettre de
    rtablir l'utilisation du simple message d'Apache cod en dur pour
    les configurations qui sans cela, hriteraient d'une directive
    <code class="directive">ErrorDocument</code> existante.</p>

    <div class="example"><p><code>
      ErrorDocument 404 /cgi-bin/bad_urls.pl<br /><br />
      &lt;Directory /web/docs&gt;<br />
      <span class="indent">
        ErrorDocument 404 default<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>Notez que lorsque vous spcifiez une directive
    <code class="directive">ErrorDocument</code> pointant vers une URL distante
    (c'est  dire tout ce qui commence par le prfixe http), Apache va
    envoyer une redirection au client afin de lui indiquer o trouver le
    document, mme dans le cas o ce document se trouve sur le serveur
    local. Ceci a de nombreuses consquences dont la plus importante
    rside dans le fait que le client ne recevra pas le code d'erreur
    original, mais au contraire un code de statut de redirection. Ceci
    peut en retour semer la confusion chez les robots web et divers
    clients qui tentent de dterminer la validit d'une URL en examinant
    le code de statut. De plus, si vous utilisez une URL distante avec
    <code>ErrorDocument 401</code>, le client ne saura pas qu'il doit
    demander un mot de passe  l'utilisateur car il ne recevra pas le
    code de statut 401. C'est pourquoi, <strong>si vous utilisez une
    directive <code>ErrorDocument 401</code>, elle devra faire rfrence
     un document par le biais d'un chemin local.</strong></p>

    <p>Microsoft Internet Explorer (MSIE) ignore par dfaut les messages
    d'erreur gnrs par le serveur lorsqu'ils sont trop courts et
    remplacent ces propres messages d'erreur "amicaux". Le seuil de
    taille varie en fonction du type d'erreur, mais en gnral, si la
    taille de votre message d'erreur est suprieure  512 octets, il y a
    peu de chances pour que MSIE l'occulte, et il sera affich par ce
    dernier. Vous trouverez d'avantage d'informations dans l'article de
    la base de connaissances Microsoft <a href="http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807">Q294807</a>.</p>

    <p>Bien que la plupart des messages d'erreur internes originaux
    puissent tre remplacs, ceux-ci sont cependant conservs dans
    certaines circonstances sans tenir compte de la dfinition de la
    directive <code class="directive"><a href="#errordocument">ErrorDocument</a></code>. En
    particulier, en cas de dtection d'une requte mal forme, le
    processus de traitement normal des requtes est immdiatement
    interrompu, et un message d'erreur interne est renvoy, ceci afin de
    se prmunir contre les problmes de scurit lis aux requtes mal
    formes.</p>

    <p>Si vous utilisez mod_proxy, il est en gnral prfrable
    d'activer <code class="directive"><a href="../mod/mod_proxy.html#proxyerroroverride">ProxyErrorOverride</a></code> afin d'tre en
    mesure de produire des messages d'erreur personnaliss pour le
    compte de votre serveur d'origine. Si vous n'activez pas
    ProxyErrorOverride, Apache ne gnrera pas de messages d'erreur
    personnaliss pour le contenu mandat.</p>

    <p>Avant la version 2.0, les messages taient indiqus en les
    prfixant par un seul caractre guillemet isol.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../custom-error.html">documentation sur la
personnalisation des rponses</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="errorlog" id="errorlog">Directive</a> <a name="ErrorLog" id="ErrorLog">ErrorLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinition du chemin du journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> ErrorLog <var>chemin fichier</var>|syslog[:<var>facility</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ErrorLog logs/error_log (Unix) ErrorLog logs/error.log (Windows
et OS/2)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ErrorLog</code> permet de dfinir le
    nom du fichier dans lequel le serveur va journaliser toutes les
    erreurs qu'il rencontre. Si le <var>chemin fichier</var> n'est pas
    absolu, il est considre comme relatif au chemin dfini par la
    directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <div class="example"><h3>Exemple</h3><p><code>
    ErrorLog /var/log/httpd/error_log
    </code></p></div>

    <p>Si le <var>chemin fichier</var> commence par une barre verticale
    "<code>|</code>", il est considr comme une commande  lancer pour traiter la
    journalisation de l'erreur.</p>

    <div class="example"><h3>Exemple</h3><p><code>
    ErrorLog "|/usr/local/bin/erreurs_httpd"
    </code></p></div>

    <p>Voir les notes  propos des <a href="../logs.html#piped">journaux
    redirigs</a> pour plus de dtails.</p>

    <p>L'utilisation de <code>syslog</code>  la place d'un nom de
    fichier active la journalisation via syslogd(8) si le systme le
    supporte. Le dispositif syslog par dfaut est <code>local7</code>,
    mais vous pouvez le modifier  l'aide de la syntaxe
    <code>syslog:<var>facility</var></code>, o <var>facility</var> peut
    tre remplac par un des noms habituellement documents dans la page
    de man syslog(1).</p>

    <div class="example"><h3>Exemple</h3><p><code>
    ErrorLog syslog:user
    </code></p></div>

    <p>SECURITE : Voir le document <a href="../misc/security_tips.html#serverroot">conseils  propos de
    scurit</a> pour des dtails sur les raisons pour lesquelles votre
    scurit peut tre compromise si le rpertoire contenant les
    fichiers journaux prsente des droits en criture pour tout autre
    utilisateur que celui sous lequel le serveur est dmarr.</p>
    <div class="warning"><h3>Note</h3>
      <p>Lors de la spcification d'un chemin de fichier sur les
      plates-formes non-Unix, on doit veiller  n'utiliser que des
      slashes (/), mme si la plate-forme autorise l'utilisation des
      anti-slashes (\). Et d'une manire gnrale, il est recommand de
      n'utiliser que des slashes (/) dans les fichiers de
      configuration.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#loglevel">LogLevel</a></code></li>
<li><a href="../logs.html">Fichiers journaux d'Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="fileetag" id="fileetag">Directive</a> <a name="FileETag" id="FileETag">FileETag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Caractristiques de fichier utiliss lors de la gnration
de l'en-tte de rponse HTTP ETag pour les fichiers statiques</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>FileETag <var>composant</var> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>FileETag INode MTime Size</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>
    La directive <code class="directive">FileETag</code> dfinit les
    caractristiques de fichier utilises lors de la gnration de
    l'en-tte de rponse HTTP <code>ETag</code> (entity tag) quand le
    document est contenu dans un fichier statique (la valeur de
    <code>ETag</code>
    est utilise dans le cadre de la gestion du cache pour prserver la
    bande passante rseau). Dans les versions 1.3.22 et antrieures
    d'Apache, la valeur de l'en-tte <code>ETag</code> se composait
    <em>toujours</em> de l'inode du fichier, de sa taille et de sa date
    de dernire modification (mtime). La directive
    <code class="directive">FileETag</code> vous permet dsormais de choisir
    quelles caractristiques du fichier vont tre ventuellement
    utilises. Les mots-cls reconnus sont :
    </p>

    <dl>
     <dt><strong>INode</strong></dt>
     <dd>Le numro d'i-node du fichier sera inclus dans le processus de
     gnration</dd>
     <dt><strong>MTime</strong></dt>
     <dd>La date et l'heure auxquelles le fichier a t modifi la
     dernire fois seront incluses</dd>
     <dt><strong>Size</strong></dt>
     <dd>La taille du fichier en octets sera incluse</dd>
     <dt><strong>All</strong></dt>
     <dd>Tous les champs disponibles seront utiliss. Cette dfinition
     est quivalente  : <div class="example"><p><code>FileETag INode MTime
     Size</code></p></div></dd>
     <dt><strong>None</strong></dt>
     <dd>Si le document se compose d'un fichier, aucun champ
     <code>ETag</code> ne sera inclus dans la rponse</dd>
    </dl>

    <p>Les mots-cls <code>INode</code>, <code>MTime</code>, et
    <code>Size</code> peuvent tre prfixs par <code>+</code> ou
    <code>-</code>, ce qui permet de modifier les valeurs par dfaut
    hrites d'un niveau de configuration plus gnral. Tout mot-cl
    apparaissant sans aucun prfixe annule entirement et immdiatement
    les configurations hrites.</p>

    <p>Si la configuration d'un rpertoire contient
    <code>FileETag&nbsp;INode&nbsp;MTime&nbsp;Size</code>, et si un de
    ses sous-rpertoires contient <code>FileETag&nbsp;-INode</code>, la
    configuration de ce sous-rpertoire (qui sera propage vers tout
    sous-rpertoire qui ne la supplante pas), sera quivalente 
    <code>FileETag&nbsp;MTime&nbsp;Size</code>.</p>
    <div class="warning"><h3>Avertissement</h3>
    Ne modifiez pas les valeurs par dfaut pour les rpertoires ou
    localisations o WebDAV est activ et qui utilisent
    <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code> comme fournisseur de stockage.
    <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code> utilise
    <code>INode&nbsp;MTime&nbsp;Size</code> comme format fixe pour les
    comparaisons de champs <code>ETag</code> dans les requtes
    conditionnelles. Ces requtes conditionnelles choueront si le
    format <code>ETag</code> est modifi via la directive
    <code class="directive">FileETag</code>.
    </div>
    <div class="note"><h3>Inclusions ct serveur</h3>
    Aucun champ ETag n'est gnr pour les rponses interprtes par
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>, car l'entit de la rponse peut
    changer sans modification de l'INode, du MTime, ou de la taille du
    fichier statique contenant les directives SSI.
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="files" id="files">Directive</a> <a name="Files" id="Files">&lt;Files&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui s'appliquent aux fichiers
prciss</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Files <var>nom fichier</var>&gt; ... &lt;/Files&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;Files&gt;</code> limite
    la porte des directives qu'elle contient aux fichiers prciss.
    Elle est comparable aux directives <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Elle doit se terminer par une
    balise <code>&lt;/Files&gt;</code>. Les directives contenues dans
    cette section s'appliqueront  tout objet dont le nom de base (la
    dernire partie du nom de fichier) correspond au fichier spcifi.
    Les sections <code class="directive">&lt;Files&gt;</code> sont
    traites selon l'ordre dans lequel elles apparaissent dans le
    fichier de configuration, aprs les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et la lecture des fichiers
    <code>.htaccess</code>, mais avant les sections <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Notez que les
    sections <code class="directive">&lt;Files&gt;</code> peuvent tre
    imbriques dans les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> afin de restreindre la portion
    du systme de fichiers  laquelle ces dernires vont
    s'appliquer.</p>

    <p>L'argument <var>filename</var> peut contenir un nom de fichier
    ou une chane de caractres avec caractres gnriques, o
    <code>?</code> remplace un caractre, et <code>*</code> toute chane
    de caractres :</p>
    <div class="example"><pre>&lt;Files "cat.html"&gt;
    # Insrer ici les directives s'appliquant au fichier cat.html
&lt;/Files&gt;

&lt;Files "?at.*"&gt;
    # Les directives insres ici s'appliqueront aux fichiers cat.html,
    # bat.html, hat.php et ainsi de suite.
&lt;/Files&gt;</pre></div>
    
    <p>
    On peut aussi utiliser les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions rationnelles</a> en ajoutant la
    caractre <code>~</code>. Par exemple :</p>

    <div class="example"><p><code>
      &lt;Files ~ "\.(gif|jpe?g|png)$"&gt;
    </code></p></div>

    <p>correspondrait  la plupart des formats graphiques de l'Internet.
    Il est cependant prfrable d'utiliser la directive <code class="directive"><a href="#filesmatch">&lt;FilesMatch&gt;</a></code>.</p>

    <p>Notez qu' la diffrence des sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, les sections <code class="directive">&lt;Files&gt;</code> peuvent tre utilises dans les
    fichiers <code>.htaccess</code>. Ceci permet aux utilisateurs de
    contrler l'accs  leurs propres ressources, fichier par
    fichier.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="filesmatch" id="filesmatch">Directive</a> <a name="FilesMatch" id="FilesMatch">&lt;FilesMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui s'appliquent  des fichiers
spcifis sous la forme d'expressions rationnelles</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;FilesMatch <var>expression rationnelle</var>&gt; ...
&lt;/FilesMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La section <code class="directive">&lt;FilesMatch&gt;</code>
    limite la porte des directives qu'elle contient aux fichiers
    spcifis, tout comme le ferait une section <code class="directive"><a href="#files">&lt;Files&gt;</a></code>. Mais elle accepte aussi les
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>. Par
    exemple :</p>

    <div class="example"><p><code>
      &lt;FilesMatch "\.(gif|jpe?g|png)$"&gt;
    </code></p></div>

    <p>correspondrait  la plupart des formats graphiques de
    l'Internet.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="forcetype" id="forcetype">Directive</a> <a name="ForceType" id="ForceType">ForceType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force un type de contenu MIME pour les fichiers
spcifis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ForceType <var>type MIME</var>|None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Intgr dans le coeur d'Apache depuis la version
2.0</td></tr>
</table>
    <p>Lorsqu'elle est place dans un fichier <code>.htaccess</code> ou
    une section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, ou <code class="directive"><a href="#files">&lt;Files&gt;</a></code>, cette directive force
    l'identification du type MIME des fichiers spcifis  la valeur de
    l'argument <var>type MIME</var>. Par exemple, si vous possdez un
    rpertoire ne contenant que des fichiers GIF, et si vous ne voulez
    pas leur ajouter l'extension <code>.gif</code>, vous pouvez utiliser
    :</p>

    <div class="example"><p><code>
      ForceType image/gif
    </code></p></div>

    <p>Notez qu' la diffrence de <code class="directive"><a href="#defaulttype">DefaultType</a></code>, cette directive l'emporte sur
    toute mthode d'attribution du type MIME, y compris les extensions
    de nom de fichier, qui parviendrait  identifier le type de
    mdium.</p>

    <p>Vous pouvez annuler toute autre dfinition
    <code class="directive">ForceType</code> en affectant la valeur
    <code>None</code>  l'argument <var>type MIME</var> :</p>

    <div class="example"><p><code>
      # force le type MIME de tous les fichiers  image/gif:<br />
      &lt;Location /images&gt;<br />
        <span class="indent">
          ForceType image/gif<br />
        </span>
      &lt;/Location&gt;<br />
      <br />
      # mais utilise les mthodes classiques d'attribution du type MIME
      # dans le sous-rpertoire suivant :<br />
      &lt;Location /images/mixed&gt;<br />
      <span class="indent">
        ForceType None<br />
      </span>
      &lt;/Location&gt;
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="gprofdir" id="gprofdir">Directive</a> <a name="GprofDir" id="GprofDir">GprofDir</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire dans lequel crire les donnes de profiling
gmon.out.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>GprofDir <var>/tmp/gprof/</var>|<var>/tmp/gprof/</var>%</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsque le serveur a t compil avec le support du profiling
    gprof, la directive <code class="directive">GprofDir</code> permet de
    spcifier dans quel rpertoire les fichiers <code>gmon.out</code>
    doivent tre crits lorsque le processus s'arrte. Si l'argument se
    termine par un caractre pourcentage ('%'), des sous-rpertoires
    sont crs pour chaque identifiant de processus.</p>

    <p>Cette directive ne fonctionne actuellement qu'avec le MPM
    <code class="module"><a href="../mod/prefork.html">prefork</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="hostnamelookups" id="hostnamelookups">Directive</a> <a name="HostnameLookups" id="HostnameLookups">HostnameLookups</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la recherche DNS sur les adresses IP des
clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>HostnameLookups On|Off|Double</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>HostnameLookups Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive active la recherche DNS afin de pouvoir
    journaliser les noms d'htes (et les passer aux programmes CGI et aux
    inclusions SSI via la variable <code>REMOTE_HOST</code>). La valeur
    <code>Double</code> dclenche une double recherche DNS inverse. En
    d'autres termes, une fois la recherche inverse effectue, on lance
    une recherche directe sur le rsultat de cette dernire. Au moins
    une des adresses IP fournies par la recherche directe doit
    correspondre  l'adresse originale (ce que l'on nomme
    <code>PARANOID</code> dans la terminologie "tcpwrappers").</p>

    <p>Quelle que soit la configuration, lorsqu'on utilise
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> pour contrler l'accs en fonction
    du nom d'hte, une double recherche DNS inverse est effectue,
    scurit oblige. Notez cependant que le rsultat de cette double
    recherche n'est en gnral pas accessible,  moins que vous n'ayez
    spcifi <code>HostnameLookups Double</code>. Par exemple, si vous
    n'avez spcifi que <code>HostnameLookups On</code>, et si une
    requte concerne un objet protg par des restrictions en fonction
    du nom d'hte, quel que soit le rsultat de la double recherche
    inverse, les programmes CGI ne recevront que le rsultat de la
    recherche inverse simple dans la variable
    <code>REMOTE_HOST</code>.</p>

    <p>La valeur par dfaut est <code>Off</code> afin de prserver le
    traffic rseau des sites pour lesquels la recherche inverse n'est
    pas vraiment ncessaire. Cette valeur par dfaut est aussi bnfique
    pour les utilisateurs finaux car il n'ont ainsi pas  subir de temps
    d'attente supplmentaires dus aux recherches DNS. Les sites
    fortement chargs devraient laisser cette directive 
    <code>Off</code>, car les recherches DNS peuvent prendre des temps
    trs longs. Vous pouvez ventuellement utiliser hors ligne
    l'utilitaire <code class="program"><a href="../programs/logresolve.html">logresolve</a></code>, compil par dfaut dans
    le sous-rpertoire <code>bin</code> de votre rpertoire
    d'installation, afin de dterminer les noms d'htes associs aux
    adresses IP journalises.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ifdefine" id="ifdefine">Directive</a> <a name="IfDefine" id="IfDefine">&lt;IfDefine&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliqueront que si un
test retourne "vrai" au dmarrage du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;IfDefine [!]<var>paramtre</var>&gt; ...
    &lt;/IfDefine&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La section <code>&lt;IfDefine
    <var>test</var>&gt;...&lt;/IfDefine&gt;</code> permet de
    confrer un caractre conditionnel  un ensemble de directives. Les
    directives situes  l'intrieur d'une section <code class="directive">&lt;IfDefine&gt;</code> ne s'appliquent que si
    <var>test</var> est vrai. Si <var>test</var> est faux, tout ce qui
    se trouve entre les balises de dbut et de fin est ignor.</p>

    <p><var>test</var> peut se prsenter sous deux formes :</p>

    <ul>
      <li><var>nom paramtre</var></li>

      <li><code>!</code><var>nom paramtre</var></li>
    </ul>

    <p>Dans le premier cas, les directives situes entre les balises de
    dbut et de fin ne s'appliqueront que si le paramtre nomm <var>nom
    paramtre</var> est dfini. Le second format inverse le test, et
    dans ce cas, les directives ne s'appliqueront que si <var>nom
    paramtre</var> n'est <strong>pas</strong> dfini.</p>

    <p>La dfinition de l'argument <var>nom paramtre</var>
    s'effectue au niveau de la ligne de commande
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> via le paramtre
    <code>-D<var>paramtre</var></code> au dmarrage du serveur.</p>

    <p>Les sections <code class="directive">&lt;IfDefine&gt;</code>
    peuvent tre imbriques, ce qui permet de mettre en oeuvre un test
    multi-paramtres simple. Exemple :</p>

    <div class="example"><p><code>
      httpd -DReverseProxy -DUseCache -DMemCache ...<br />
      <br />
      # httpd.conf<br />
      &lt;IfDefine ReverseProxy&gt;<br />
      <span class="indent">
        LoadModule proxy_module   modules/mod_proxy.so<br />
        LoadModule proxy_http_module   modules/mod_proxy_http.so<br />
        &lt;IfDefine UseCache&gt;<br />
        <span class="indent">
          LoadModule cache_module   modules/mod_cache.so<br />
          &lt;IfDefine MemCache&gt;<br />
          <span class="indent">
            LoadModule mem_cache_module   modules/mod_mem_cache.so<br />
          </span>
          &lt;/IfDefine&gt;<br />
          &lt;IfDefine !MemCache&gt;<br />
          <span class="indent">
            LoadModule disk_cache_module   modules/mod_disk_cache.so<br />
          </span>
          &lt;/IfDefine&gt;
        </span>
        &lt;/IfDefine&gt;
      </span>
      &lt;/IfDefine&gt;
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ifmodule" id="ifmodule">Directive</a> <a name="IfModule" id="IfModule">&lt;IfModule&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent qu'en fonction
de la prsence ou de l'absence d'un module spcifique</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;IfModule [!]<var>fichier module</var>|<var>identificateur
module</var>&gt; ... &lt;/IfModule&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les identificateurs de modules sont disponibles dans les
versions 2.1 et suprieures.</td></tr>
</table>
    <p>La section <code>&lt;IfModule
    <var>test</var>&gt;...&lt;/IfModule&gt;</code> permet de confrer 
    des directives un caractre conditionnel bas sur la prsence d'un
    module spcifique. Les directives situes dans une section
    <code class="directive">&lt;IfModule&gt;</code> ne s'appliquent que
    si <var>test</var> est vrai. Si <var>test</var> est faux, tout ce
    qui se trouve entre les balises de dbut et de fin est ignor.</p>

    <p><var>test</var> peut se prsenter sous deux formes :</p>

    <ul>
      <li><var>module</var></li>

      <li>!<var>module</var></li>
    </ul>

    <p>Dans le premier cas, les directives situes entre les balises de
    dbut et de fin ne s'appliquent que si le module <var>module</var>
    est prsent -- soit compil avec le binaire httpd, soit charg
    dynamiquement via la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>. Le second format inverse le test, et dans
    ce cas, les directives ne s'appliquent que si <var>module</var>
    n'est <strong>pas</strong> prsent.</p>

    <p>L'argument <var>module</var> peut contenir soit l'identificateur
    du module, soit le nom du fichier source du module. Par exemple,
    <code>rewrite_module</code> est un identificateur et
    <code>mod_rewrite.c</code> le nom du fichier source
    correspondant. Si un module comporte plusieurs fichiers sources,
    utilisez le nom du fichier qui contient la chane de caractres
    <code>STANDARD20_MODULE_STUFF</code>.</p>

    <p>Les sections <code class="directive">&lt;IfModule&gt;</code>
    peuvent tre imbriques, ce qui permet d'implmenter des tests
    multi-modules simples.</p>

    <div class="note">Cette section ne doit tre utilise que si votre fichier de
    configuration ne fonctionne qu'en fonction de la prsence ou de
    l'absence d'un module spcifique. D'une manire gnrale, il n'est
    pas ncessaire de placer les directives  l'intrieur de sections
    <code class="directive">&lt;IfModule&gt;</code>.</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="include" id="include">Directive</a> <a name="Include" id="Include">Include</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Inclut d'autres fichiers de configuration dans un des
fichiers de configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Include <var>chemin fichier</var>|<var>chemin
rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Utilisation des caractres gnriques depuis la version
2.0.41, utilisation des caractres gnriques pour les rpertoires
depuis la version 2.3.6</td></tr>
</table>
    <p>Cette directive permet l'inclusion d'autres fichiers de
    configuration dans un des fichiers de configuration du serveur.</p>

    <p>On peut utiliser des caractres gnriques de style Shell
    (<code>fnmatch()</code>) dans le nom du fichier ou la partie
    rpertoire pour inclure plusieurs fichiers en une
    seule fois, selon leur ordre alphabtique. De plus, si la directive
    <code class="directive">Include</code> pointe vers un rpertoire, Apache
    inclura tous les fichiers de ce rpertoire et de tous ces
    sous-rpertoires. L'inclusion de rpertoires entiers est cependant
    dconseille, car il est frquent d'oublier des fichiers
    temporaires dans un rpertoire, ce qui causerait une erreur
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> en cas d'inclusion. Nous vous recommandons
    plutt d'utiliser la syntaxe avec caractres gnriques vue ci-dessous
    pour inclure des fichiers dont le nom correspond  un modle
    particulier, comme *.conf par exemple.</p>

    <p>Lorsqu'on utilise un caractre gnrique dans le nom de fichier
    ou la partie rpertoire du chemin, et si aucun fichier ou rpertoire
    ne correspond au modle, la directive <code class="directive"><a href="#include">Include</a></code> sera silencieusement ignore. Si
    un nom de fichier ou un rpertoire du chemin est spcifi sans
    caractre gnrique, et si ce rpertoire ou fichier n'existe pas, la
    directive <code class="directive"><a href="#include">Include</a></code> chouera et
    renverra un message d'erreur indiquant que le rpertoire ou fichier
    n'a pas pu tre trouv. Il
    devient ainsi inutile de crer des fichiers fictifs destins 
    correspondre par dfaut  un chemin contenant des caractres
    gnriques.</p>

    <p>Le chemin fichier spcifi peut tre soit un chemin absolu, soit
    un chemin relatif au rpertoire dfini par la directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <p>Exemples :</p>

    <div class="example"><p><code>
      Include /usr/local/apache2/conf/ssl.conf<br />
      Include /usr/local/apache2/conf/vhosts/*.conf
    </code></p></div>

    <p>ou encore, avec des chemins relatifs au rpertoire dfini par la
    directive <code class="directive"><a href="#serverroot">ServerRoot</a></code> :</p>

    <div class="example"><p><code>
      Include conf/ssl.conf<br />
      Include conf/vhosts/*.conf
    </code></p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="program"><a href="../programs/apachectl.html">apachectl</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="keepalive" id="keepalive">Directive</a> <a name="KeepAlive" id="KeepAlive">KeepAlive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active les connexions HTTP persistantes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>KeepAlive On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>KeepAlive On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>L'extension Keep-Alive de HTTP/1.0 et l'implmentation des
    connexions persistantes dans HTTP/1.1 ont rendu possibles des
    sessions HTTP de longue dure, ce qui permet de transmettre
    plusieurs requtes via la mme connexion TCP. Dans certains cas, le
    gain en rapidit pour des documents comportant de nombreuses images
    peut atteindre 50%. Pour activer les connexions persistantes,
    dfinissez <code>KeepAlive On</code>.</p>

    <p>Pour les clients HTTP/1.0, les connexions persistantes ne seront
    mises en oeuvre que si elles ont t spcialement demandes par un
    client. De plus, une connexion persistante avec un client HTTP/1.0
    ne peut tre utilise que si la taille du contenu est connue
    d'avance. Ceci implique que les contenus dynamiques comme les
    sorties CGI, les pages SSI, et les listings de rpertoires gnrs
    par le serveur n'utiliseront en gnral pas les connexions
    persistantes avec les clients HTTP/1.0. Avec les clients HTTP/1.1,
    les connexions persistantes sont utilises par dfaut, sauf
    instructions contraires. Si le client le demande, le transfert par
    tronons de taille fixe (chunked encoding) sera utilis afin de
    transmettre un contenu de longueur inconnue via une connexion
    persistante.</p>

    <p>Lorsqu'un client utilise une connexion persistante, elle comptera
    pour une seule requte pour la directive MaxRequestsPerChild, quel
    que soit le nombre de requtes transmises via cette connexion.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#maxkeepaliverequests">MaxKeepAliveRequests</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="keepalivetimeout" id="keepalivetimeout">Directive</a> <a name="KeepAliveTimeout" id="KeepAliveTimeout">KeepAliveTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure pendant laquelle le serveur va attendre une requte
avant de fermer une connexion persistante</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>KeepAliveTimeout <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>KeepAliveTimeout 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Le nombre de secondes pendant lesquelles Apache va attendre une
    requte avant de fermer la connexion. La valeur du dlai spcifie
    par la directive <code class="directive"><a href="#timeout">Timeout</a></code>
    s'applique ds qu'une requte a t reue.</p>

    <p>Donner une valeur trop lve 
    <code class="directive">KeepAliveTimeout</code> peut induire des problmes
    de performances sur les serveurs fortement chargs. Plus le dlai
    est lv, plus nombreux seront les processus serveur en attente de
    requtes de la part de clients inactifs.</p>

    <p>Dans un contexte de serveur virtuel  base de nom, c'est le dlai
    du premier serveur virtuel dfini (le serveur par dfaut) parmi un
    ensemble de directives <code class="directive"><a href="#namevirtualhost">NameVirtualHost</a></code> qui sera utilis. Les
    autres valeurs seront ignores.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limit" id="limit">Directive</a> <a name="Limit" id="Limit">&lt;Limit&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Restreint les contrles d'accs que la section contient 
certaines mthodes HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Limit <var>mthode</var> [<var>mthode</var>] ... &gt; ...
    &lt;/Limit&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les contrles d'accs s'appliquent normalement 
    <strong>toutes</strong> les mthodes d'accs, et c'est en gnral le
    comportement souhait. <strong>Dans le cas gnral, les directives
    de contrle d'accs n'ont pas  tre places dans une section
    <code class="directive">&lt;Limit&gt;</code>.</strong></p>

    <p>La directive <code class="directive">&lt;Limit&gt;</code> a pour
    but de limiter les effets des contrles d'accs aux mthodes HTTP
    spcifies. Pour toutes les autres mthodes, les restrictions
    d'accs contenues dans la section <code class="directive">&lt;Limit&gt;</code> <strong>n'auront aucun
    effet</strong>. L'exemple suivant n'applique les contrles d'accs
    qu'aux mthodes <code>POST</code>, <code>PUT</code>, et
    <code>DELETE</code>, en laissant les autres mthodes sans protection
    :</p>

    <div class="example"><p><code>
      &lt;Limit POST PUT DELETE&gt;<br />
      <span class="indent">
        Require valid-user<br />
      </span>
      &lt;/Limit&gt;
    </code></p></div>

    <p>La liste des noms de mthodes peut contenir une ou plusieurs
    valeurs parmi les suivantes : <code>GET</code>, <code>POST</code>,
    <code>PUT</code>, <code>DELETE</code>, <code>CONNECT</code>,
    <code>OPTIONS</code>, <code>PATCH</code>, <code>PROPFIND</code>,
    <code>PROPPATCH</code>, <code>MKCOL</code>, <code>COPY</code>,
    <code>MOVE</code>, <code>LOCK</code>, et <code>UNLOCK</code>.
    <strong>Le nom de mthode est sensible  la casse.</strong> Si la
    valeur <code>GET</code> est prsente, les requtes <code>HEAD</code>
    seront aussi concernes. La mthode <code>TRACE</code> ne peut pas
    tre limite.</p>

    <div class="warning">Une section <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code> doit toujours tre prfre 
    une section <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> pour la restriction d'accs, car une
    section <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code> fournit une protection contre
    les mthodes arbitraires.</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitexcept" id="limitexcept">Directive</a> <a name="LimitExcept" id="LimitExcept">&lt;LimitExcept&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Applique les contrles d'accs  toutes les mthodes HTTP,
sauf celles qui sont spcifies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;LimitExcept <var>mthode</var> [<var>mthode</var>] ... &gt; ...
    &lt;/LimitExcept&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p><code class="directive">&lt;LimitExcept&gt;</code> et
    <code>&lt;/LimitExcept&gt;</code> permettent de regrouper des
    directives de contrle d'accs qui s'appliqueront  toutes les
    mthodes d'accs HTTP qui ne font <strong>pas</strong> partie de la
    liste des arguments ; en d'autres termes, elles ont un comportement
    oppos  celui de la section <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code>, et on peut les utiliser pour
    contrler aussi bien les mthodes standards que les mthodes non
    standards ou non reconnues. Voir la documentation de la section
    <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> pour plus
    de dtails.</p>

    <p>Par exemple :</p>

    <div class="example"><p><code>
      &lt;LimitExcept POST GET&gt;<br />
      <span class="indent">
        Require valid-user<br />
      </span>
      &lt;/LimitExcept&gt;
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitinternalrecursion" id="limitinternalrecursion">Directive</a> <a name="LimitInternalRecursion" id="LimitInternalRecursion">LimitInternalRecursion</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le nombre maximal de redirections internes et de
sous-requtes imbriques</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitInternalRecursion <var>nombre</var> [<var>nombre</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitInternalRecursion 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.0.47 d'Apache</td></tr>
</table>
    <p>Une redirection interne survient, par exemple, quand on utilise
    la directive <code class="directive"><a href="../mod/mod_actions.html#action">Action</a></code> qui
    redirige en interne la requte d'origine vers un script CGI. Une
    sous-requte est le mcanisme qu'utilise Apache pour dterminer ce
    qui se passerait pour un URI s'il faisait l'objet d'une requte. Par
    exemple, <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code> utilise les sous-requtes pour
    rechercher les fichiers lists dans la directive <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>.</p>

    <p>La directive <code class="directive">LimitInternalRecursion</code> permet
    d'viter un crash du serveur d  un bouclage infini de redirections
    internes ou de sous-requtes. De tels bouclages sont dus en gnral
     des erreurs de configuration.</p>

    <p>La directive accepte, comme arguments, deux limites qui sont
    values  chaque requte. Le premier <var>nombre</var> est le
    nombre maximum de redirections internes qui peuvent se succder. Le
    second <var>nombre</var> dtermine la profondeur d'imbrication
    maximum des sous-requtes. Si vous ne spcifiez qu'un seul
    <var>nombre</var>, il sera affect aux deux limites.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      LimitInternalRecursion 5
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestbody" id="limitrequestbody">Directive</a> <a name="LimitRequestBody" id="LimitRequestBody">LimitRequestBody</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>limite la taille maximale du corps de la requte HTTP
envoye par le client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestBody <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestBody 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive spcifie la taille maximale autorise pour le
    corps d'une requte ; la valeur de l'argument <var>octets</var> va
    de 0 (pour une taille illimite),  2147483647 (2Go).</p>

    <p>La directive <code class="directive">LimitRequestBody</code> permet de
    dfinir une limite pour la taille maximale autorise du corps d'une
    requte HTTP en tenant compte du contexte dans lequel la directive
    a t place (c'est  dire au niveau du serveur, d'un rpertoire,
    d'un fichier ou d'un chemin d'url). Si la requte du client dpasse
    cette limite, le serveur rpondra par un message d'erreur et ne
    traitera pas la requte. La taille du corps d'une requte normale va
    varier de manire importante en fonction de la nature de la
    ressource et des mthodes autorises pour cette dernire. Les
    scripts CGI utilisent souvent le corps du message pour extraire les
    informations d'un formulaire. Les implmentations de la mthode
    <code>PUT</code> ncessitent une valeur au moins aussi leve que la
    taille maximale des reprsentations que le serveur dsire accepter
    pour cette ressource.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Si par exemple, vous autorisez le chargement de fichiers vers une
    localisation particulire, et souhaitez limiter la taille des
    fichiers chargs  100Ko, vous pouvez utiliser la directive suivante
    :</p>

    <div class="example"><p><code>
      LimitRequestBody 102400
    </code></p></div>

    <div class="note">Note : ne s'applique pas aux requtes mandates.</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestfields" id="limitrequestfields">Directive</a> <a name="LimitRequestFields" id="LimitRequestFields">LimitRequestFields</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de champs d'en-tte autoriss dans une
requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestFields <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestFields 100</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p><var>nombre</var> est un entier de 0 (nombre de champs illimit)
     32767. La valeur par dfaut est dfinie  la compilation par la
    constante <code>DEFAULT_LIMIT_REQUEST_FIELDS</code> (100 selon la
    distribution).</p>

    <p>La directive <code class="directive">LimitRequestFields</code> permet 
    l'administrateur du serveur de modifier le nombre maximum de champs
    d'en-tte autoriss dans une requte HTTP. Pour un serveur, cette
    valeur doit tre suprieure au nombre de champs qu'une requte
    client normale peut contenir. Le nombre de champs d'en-tte d'une
    requte qu'un client utilise dpasse rarement 20, mais ce nombre
    peut varier selon les implmentations des clients, et souvent en
    fonction des extensions que les utilisateurs configurent dans leurs
    navigateurs pour supporter la ngociation de contenu dtaille. Les
    extensions HTTP optionnelles fonctionnent utilisent souvent les
    champs d'en-tte des requtes.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service. La valeur spcifie doit tre
    augmente si les clients standards reoivent une erreur du serveur
    indiquant que la requte comportait un nombre d'en-ttes trop
    important.</p>

    <p>Par exemple :</p>

    <div class="example"><p><code>
      LimitRequestFields 50
    </code></p></div>

    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels par noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour lequel la connexion correspondait  la
     directive <code class="directive">NameVirtualHost</code>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestfieldsize" id="limitrequestfieldsize">Directive</a> <a name="LimitRequestFieldSize" id="LimitRequestFieldSize">LimitRequestFieldSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ddinit la taille maximale autorise d'un en-tte de
requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestFieldSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestFieldSize 8190</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre maximum
    d'<var>octets</var> autoriss dans un en-tte de requte HTTP.</p>

    <p>La directive <code class="directive">LimitRequestFieldSize</code> permet
     l'administrateur du serveur de dfinir la taille
    maximale autorise d'un en-tte de requte HTTP. Pour un serveur,
    cette valeur doit tre suffisamment grande pour contenir tout
    en-tte d'une requte client normale. La taille d'un champ d'en-tte
    de requte normal va varier selon les implmentations des clients,
    et en fonction des extensions que les utilisateurs
    configurent dans leurs navigateurs pour supporter la ngociation de
    contenu dtaille. Les en-ttes d'authentification SPNEGO peuvent
    atteindre une taille de 12392 octets.</p>

    <p>&gt;L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Par exemple ::</p>

    <div class="example"><p><code>
      LimitRequestFieldSize 4094
    </code></p></div>

    <div class="note">Dans des conditions normales, la valeur par dfaut de cette
    directive ne doit pas tre modifie.</div>

    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels par noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour lequel la connexion correspondait  la
     directive <code class="directive">NameVirtualHost</code>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestline" id="limitrequestline">Directive</a> <a name="LimitRequestLine" id="LimitRequestLine">LimitRequestLine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille maximale d'une ligne de requte
HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestLine <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestLine 8190</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir la taille maximale autorise
    pour une ligne de requte HTTP en <var>octets</var>.</p>

    <p>La directive <code class="directive">LimitRequestLine</code> permet 
    l'administrateur du serveur de dfinir la taille
    maximale autorise d'une ligne de requte HTTP client. Comme une
    requte comporte une mthode HTTP, un URI, et une version de
    protocole, la directive <code class="directive">LimitRequestLine</code>
    impose une restriction sur la longueur maximale autorise pour un
    URI dans une requte au niveau du serveur. Pour un serveur, cette
    valeur doit tre suffisamment grande pour rfrencer les noms de
    toutes ses ressources, y compris toutes informations pouvant tre
    ajoutes dans la partie requte d'une mthode <code>GET</code>.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Par exemple :</p>

    <div class="example"><p><code>
      LimitRequestLine 4094
    </code></p></div>

    <div class="note">Dans des conditions normales, cette directive doit conserver
    sa valeur par dfaut.</div>

    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels par noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour lequel la connexion correspondait  la
     directive <code class="directive">NameVirtualHost</code>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitxmlrequestbody" id="limitxmlrequestbody">Directive</a> <a name="LimitXMLRequestBody" id="LimitXMLRequestBody">LimitXMLRequestBody</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille maximale du corps d'une requte au format
XML</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitXMLRequestBody <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitXMLRequestBody 1000000</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Taille maximale (en octets) du corps d'une requte au format XML.
    Une valeur de <code>0</code> signifie qu'aucune limite n'est
    impose.</p>

    <p>Exemple :</p>

    <div class="example"><p><code>
      LimitXMLRequestBody 0
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="location" id="location">Directive</a> <a name="Location" id="Location">&lt;Location&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>N'applique les directives contenues qu'aux URLs
spcifies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Location
    <var>chemin URL</var>|<var>URL</var>&gt; ... &lt;/Location&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;Location&gt;</code>
    limite la porte des directives contenues aux URLs dfinies par
    l'argument URL. Elle est similaire  la directive <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>, et marque le
    dbut d'une section qui se termine par une directive
    <code>&lt;/Location&gt;</code>. Les sections <code class="directive">&lt;Location&gt;</code> sont traites selon l'ordre dans
    lequel elles apparaissent dans le fichier de configuration, mais
    aprs les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et la lecture des
    fichiers <code>.htaccess</code>, et aprs les sections <code class="directive"><a href="#files">&lt;Files&gt;</a></code>.</p>

    <p>Les sections <code class="directive">&lt;Location&gt;</code>
    agissent compltement en dehors du systme de fichiers. Ceci a de
    nombreuses consquences. Parmi les plus importantes, on ne doit pas
    utiliser les sections <code class="directive">&lt;Location&gt;</code>
    pour contrler l'accs aux rpertoires du systme de fichiers. Comme
    plusieurs URLs peuvent correspondre au mme rpertoire du systme de
    fichiers, un tel contrle d'accs pourrait tre contourn.</p>

    <p>Les directives que contient cette section seront appliques aux
    requtes si la partie chemin de l'URL satisfait  l'un au moins de
    ces critres :</p>
    <ul>
      <li>Le chemin spcifi correspond exactement  la partie chemin de
      l'URL.
      </li>
      <li>Le chemin spcifi, qui se termine par un slash, est un
      prfixe de la partie chemin de l'URL (trait comme une racine du
      contexte).
      </li>
      <li>Le chemin spcifi, si on lui ajoute un slash de fin, est un
      prfixe de la partie chemin de l'URL (aussi trait comme une racine du
      contexte).
      </li>
    </ul>
    <p>Dans l'exemple ci-dessous, o aucun slash de fin n'est utilis, les
    directives contenues dans la section s'appliqueront  /private1,
    /private1/ et /private1/file.txt, mais pas  /private1other.</p>
    <div class="example"><p><code>
      &lt;Location /private1&gt;
          ...
    </code></p></div>
    <p>De mme, dans l'exemple ci-dessous, o l'on utilise un slash de fin, les
    directives contenues dans la section s'appliqueront  /private2/ et
     /private2/file.txt, mais pas  /private2other.</p>
    <div class="example"><p><code>
      &lt;Location /private2<em>/</em>&gt;
          ...
    </code></p></div>
    
    <div class="note"><h3>Quand utiliser la section <code class="directive">&lt;Location&gt;</code></h3>

    <p>Vous pouvez utiliser une section <code class="directive">&lt;Location&gt;</code> pour appliquer des directives 
    des contenus situs en dehors du systme de fichiers. Pour les
    contenus situs  l'intrieur du systme de fichiers, utilisez
    plutt les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#files">&lt;Files&gt;</a></code>. <code>&lt;Location
    /&gt;</code> constitue une exception  cette rgle et permet d'appliquer
    aisment une configuration  l'ensemble du serveur.</p>
    </div>

    <p>Pour toutes les requtes originales (non mandates), l'argument
    URL est un chemin d'URL de la forme
    <code>/chemin/</code>. <em>Aucun protocole, nom d'hte, port, ou chane
    de requte ne doivent apparatre.</em> Pour les requtes mandates, l'URL
    spcifie doit tre de la forme
    <code>protocole://nom_serveur/chemin</code>, et vous devez inclure
    le prfixe.</p>

    <p>L'URL peut contenir des caractres gnriques. Dans une chane
    avec caractres gnriques, <code>?</code> correspond  un caractre
    quelconque, et <code>*</code>  toute chane de caractres. Les
    caractres gnriques ne peuvent pas remplacer un / dans le chemin
    URL.</p>

    <p>On peut galement utiliser les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions
    rationnelles</a>, moyennant l'addition d'un caractre
    <code>~</code>. Par exemple :</p>

    <div class="example"><p><code>
      &lt;Location ~ "/(extra|special)/data"&gt;
    </code></p></div>

    <p>concernerait les URLs contenant les sous-chane
    <code>/extra/data</code> ou <code>/special/data</code>. La directive
    <code class="directive"><a href="#locationmatch">&lt;LocationMatch&gt;</a></code>
    prsente un comportement identique  la version avec expressions
    rationnelles de la directive <code class="directive">&lt;Location&gt;</code>.</p>

    <p>La directive <code class="directive">&lt;Location&gt;</code>
    s'utilise principalement avec la directive <code class="directive"><a href="#sethandler">SetHandler</a></code>. Par exemple, pour activer les
    requtes d'tat, mais ne les autoriser que depuis des navigateurs
    appartenant au domaine <code>example.com</code>, vous pouvez
    utiliser :</p>

    <div class="example"><p><code>
      &lt;Location /status&gt;<br />
      <span class="indent">
        SetHandler server-status<br />
        Order Deny,Allow<br />
        Deny from all<br />
        Allow from .example.com<br />
      </span>
      &lt;/Location&gt;
    </code></p></div>

    <div class="note"><h3>Note  propos du slash (/)</h3>
      <p>La signification du caractre slash dpend de l'endroit o il
      se trouve dans l'URL. Les utilisateurs peuvent tre habitus 
      son comportement dans le systme de fichiers o plusieurs slashes
      successifs sont souvent rduits  un slash unique (en d'autres
      termes, <code>/home///foo</code> est identique 
      <code>/home/foo</code>). Dans l'espace de nommage des URLs, ce
      n'est cependant pas toujours le cas. Pour la directive <code class="directive"><a href="#locationmatch">&lt;LocationMatch&gt;</a></code> et la
      version avec expressions rationnelles de la directive <code class="directive">&lt;Location&gt;</code>, vous devez spcifier
      explicitement les slashes multiples si telle est votre
      intention.</p>

      <p>Par exemple, <code>&lt;LocationMatch ^/abc&gt;</code> va
      correspondre  l'URL <code>/abc</code> mais pas  l'URL <code>
      //abc</code>. La directive <code class="directive">&lt;Location&gt;</code> sans expression rationnelle se comporte de
      la mme manire lorsqu'elle est utilise pour des requtes
      mandates. En revanche, lorsque la directive <code class="directive">&lt;Location&gt;</code> sans expression rationnelle
      est utilise pour des requtes non mandates, elle fera
      correspondre implicitement les slashes multiples  des slashes
      uniques. Par exemple, si vous spcifiez <code>&lt;Location
      /abc/def&gt;</code>, une requte de la forme
      <code>/abc//def</code> correspondra.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="locationmatch" id="locationmatch">Directive</a> <a name="LocationMatch" id="LocationMatch">&lt;LocationMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>N'applique les directives contenues qu'aux URLs
correspondant  une expression rationnelle</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;LocationMatch
    <var>regex</var>&gt; ... &lt;/LocationMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;LocationMatch&gt;</code>
    limite la porte des directives contenues  l'URL spcifie, de
    manire identique  la directive <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Mais son argument permettant de
    spcifier les URLs concernes est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> au lieu d'une simple
    chane de caractres. Par exemple :</p>

    <div class="example"><p><code>
      &lt;LocationMatch "/(extra|special)/data"&gt;
    </code></p></div>

    <p>correspondrait  toute URL contenant les sous-chanes
    <code>/extra/data</code> ou <code>/special/data</code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="loglevel" id="loglevel">Directive</a> <a name="LogLevel" id="LogLevel">LogLevel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle la verbosit du journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LogLevel <var>niveau</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LogLevel warn</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">LogLevel</code> permet d'ajuster la
    verbosit des messages enregistrs dans les journaux d'erreur (voir
    la directive <code class="directive"><a href="#errorlog">ErrorLog</a></code>
    directive). Les <var>niveau</var>x disponibles sont prsents
    ci-aprs, par ordre de criticit dcroissante :</p>

    <table class="bordered">
    
      <tr>
        <th><strong>Niveau</strong> </th>

        <th><strong>Description</strong> </th>

        <th><strong>Exemple</strong> </th>
      </tr>

      <tr>
        <td><code>emerg</code> </td>

        <td>Urgences - le systme est inutilisable.</td>

        <td>"Child cannot open lock file. Exiting"</td>
      </tr>

      <tr>
        <td><code>alert</code> </td>

        <td>Des mesures doivent tre prises immdiatement.</td>

        <td>"getpwuid: couldn't determine user name from uid"</td>
      </tr>

      <tr>
        <td><code>crit</code> </td>

        <td>Conditions critiques.</td>

        <td>"socket: Failed to get a socket, exiting child"</td>
      </tr>

      <tr>
        <td><code>error</code> </td>

        <td>Erreurs.</td>

        <td>"Premature end of script headers"</td>
      </tr>

      <tr>
        <td><code>warn</code> </td>

        <td>Avertissements.</td>

        <td>"child process 1234 did not exit, sending another
        SIGHUP"</td>
      </tr>

      <tr>
        <td><code>notice</code> </td>

        <td>Evnement important mais normal.</td>

        <td>"httpd: caught SIGBUS, attempting to dump core in
        ..."</td>
      </tr>

      <tr>
        <td><code>info</code> </td>

        <td>Informations.</td>

        <td>"Server seems busy, (you may need to increase
        StartServers, or Min/MaxSpareServers)..."</td>
      </tr>

      <tr>
        <td><code>debug</code> </td>

        <td>Messages de dbogage.</td>

        <td>"Opening config file ..."</td>
      </tr>
    </table>

    <p>Lorsqu'un niveau particulier est spcifi, les messages de tous
    les autres niveaux de criticit suprieure seront aussi enregistrs.
    <em>Par exemple</em>, si <code>LogLevel info</code> est spcifi,
    les messages de niveaux <code>notice</code> et <code>warn</code>
    seront aussi mis.</p>

    <p>Il est recommand d'utiliser un niveau <code>crit</code> ou
    infrieur.</p>

    <p>Par exemple :</p>

    <div class="example"><p><code>
      LogLevel notice
    </code></p></div>

    <div class="note"><h3>Note</h3>
      <p>Si la journalisation s'effectue directement dans un fichier,
      les messages de niveau <code>notice</code> ne peuvent pas tre
      supprims et sont donc toujours journaliss. Cependant, ceci ne
      s'applique pas lorsque la journalisation s'effectue vers
      <code>syslog</code>.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxkeepaliverequests" id="maxkeepaliverequests">Directive</a> <a name="MaxKeepAliveRequests" id="MaxKeepAliveRequests">MaxKeepAliveRequests</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de requtes permises pour une connexion
persistante</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxKeepAliveRequests <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxKeepAliveRequests 100</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">MaxKeepAliveRequests</code> permet
    de limiter le nombre de requtes autorises par connexion lorsque
    <code class="directive"><a href="#keepalive">KeepAlive</a></code> est  "on". Si sa
    valeur est <code>0</code>, le nombre de requtes autorises est
    illimit. Il est recommand de dfinir une valeur assez haute pour
    des performances du serveur maximales.</p>

    <p>Par exemple :</p>

    <div class="example"><p><code>
      MaxKeepAliveRequests 500
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxranges" id="maxranges">Directive</a> <a name="MaxRanges" id="MaxRanges">MaxRanges</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de segments de donnes autoris avant le renvoi de
l'intgralit de la ressource</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxRanges default | unlimited | none | <var>nombre de segments</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxRanges 200</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.21 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">MaxRanges</code> permet de limiter
    le nombre de segments de donnes que le serveur va renvoyer au
    client. Si un nombre de segments plus important est demand, la
    ressource sera renvoye dans son intgralit.</p>

    <dl>  
      <dt><strong>default</strong></dt>
      <dd>Limite le nombre de segments de donnes  200 (valeur par
      dfaut dfinie  la compilation).</dd>
   
      <dt><strong>none</strong></dt>
      <dd>Les en-ttes Range sont ignors.</dd>
          
      <dt><strong>unlimited</strong></dt>
      <dd>Le nombre de segments de donnes est illimit.</dd>

      <dt><var>nombre de segments</var></dt>
      <dd>Un nombre positif reprsentera la nombre de segments de
      donnes maximal que le serveur renverra au client.</dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="mergetrailers" id="mergetrailers">Directive</a> <a name="MergeTrailers" id="MergeTrailers">MergeTrailers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les donnes supplmentaires (trailers) sont
fusionnes avec les en-ttes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MergeTrailers [on|off]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MergeTrailers off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.2.28 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet de contrler la fusion des donnes HTTP
    supplmentaires (trailers) avec la reprsentation interne des
    en-ttes. Cette fusion intervient lorsque le corps de la requte a
    t entirement reu, bien longtemps aprs que la majeure partie du
    traitement des en-ttes ait une chance de pouvoir examiner ou
    modifier les en-ttes de la requte.</p>
    <p>Cette option a t introduite dans un souci de compatibilit avec
    les versions antrieures  2.2.28, o les donnes supplmentaires
    taient systmatiquement fusionnes avec les en-ttes de la requte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="namevirtualhost" id="namevirtualhost">Directive</a> <a name="NameVirtualHost" id="NameVirtualHost">NameVirtualHost</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une adresse IP pour les serveurs virtuels  base de
nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>NameVirtualHost <var>adresse</var>[:<var>port</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">NameVirtualHost</code> est
    obligatoire si vous envisagez de configurer des <a href="../vhosts/">serveurs virtuels par nom</a>.</p>

    <p>Bien que <var>adresse</var> puisse tre un nom d'hte, il est
    recommand d'utiliser plutt une adresse IP et un port,
    dans le style</p>

    <div class="example"><p><code>
      NameVirtualHost 111.22.33.44:80
    </code></p></div>

    <p>La directive <code class="directive">NameVirtualHost</code> vous permet
    de spcifier l'adresse IP sur laquelle le serveur recevra des
    requtes pour des serveurs virtuels bass sur le nom. Il s'agit en
    gnral de l'adresse  laquelle correspondent vos noms de serveurs
    virtuels bass sur le nom. Dans le cas o un par-feu ou autre
    mandataire reoit les requtes et les fait suivre au serveur avec
    une adresse IP diffrente, vous devez spcifier l'adresse IP de
    l'interface physique du serveur qui traite les requtes. Si vous
    avez plusieurs serveurs virtuels bass sur le nom avec plusieurs
    adresses, utilisez une directive pour chaque adresse.</p>

    <div class="note"><h3>Note</h3>
      <p>Notez que le "serveur principal" et tout serveur
      <code>_default_</code> ne seront <strong>jamais</strong>
      sollicits pour une requte vers une adresse
      <code class="directive">NameVirtualHost</code> ( moins que pour une
      raison ou pour une autre, vous spcifiiez un
      <code class="directive">NameVirtualHost</code> sans dfinir de
      <code class="directive">VirtualHost</code>s pour cette adresse).</p>
    </div>

    <p>Vous pouvez galement ajouter un numro de port sur lequel
    les serveurs virtuels bass sur le nom rpondront, comme</p>

    <div class="example"><p><code>
      NameVirtualHost 111.22.33.44:8080
    </code></p></div>

    <p>Les adresses IPv6 doivent tre entoures de crochets, comme dans
    l'exemple suivant :</p>

    <div class="example"><p><code>
      NameVirtualHost [2001:db8::a00:20ff:fea7:ccea]:8080
    </code></p></div>

    <p>Pour recevoir les requtes sur toutes les interfaces, vous pouvez
    utiliser comme argument <code>*:80</code>, ou <code>*</code> dans le
    cas o vous coutez sur plusieurs ports et souhaitez vraiment que le
    serveur rponde sur chacun d'entre eux avec un jeu de serveurs
    virtuels particulier.</p>

    <div class="example"><p><code>
      NameVirtualHost *:80
    </code></p></div>

    <div class="note"><h3>Argument de la directive <code class="directive">&lt;VirtualHost&gt;</code></h3>
      <p>Notez que l'argument de la directive <code class="directive">&lt;VirtualHost&gt;</code> doit tre identique 
       l'argument de la directive <code class="directive">NameVirtualHost</code>.</p>

      <div class="example"><p><code>
        NameVirtualHost 1.2.3.4:80<br />
        &lt;VirtualHost 1.2.3.4:80&gt;<br />
        # ...<br />
        &lt;/VirtualHost&gt;<br />
      </code></p></div>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation sur les serveurs
virtuels</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="options" id="options">Directive</a> <a name="Options" id="Options">Options</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les fonctionnalits disponibles pour un rpertoire
particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Options
    [+|-]<var>option</var> [[+|-]<var>option</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Options All</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">Options</code> permet de dfinir
    les fonctionnalits de serveur disponibles pour un rpertoire
    particulier.</p>

    <p><var>option</var> peut tre dfini  <code>None</code>, auquel
    cas aucune fonctionnalit spcifique n'est active, ou comprendre
    une ou plusieurs des options suivantes :</p>

    <dl>
      <dt><code>All</code></dt>

      <dd>Toutes les options excepte <code>MultiViews</code>. il s'agit
      de la configuration par dfaut.</dd>

      <dt><code>ExecCGI</code></dt>

      <dd>L'excution de scripts CGI  l'aide du module
      <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code> est permise.</dd>

      <dt><code>FollowSymLinks</code></dt>

      <dd>

      Le serveur va suivre les liens symboliques dans le rpertoire
      concern.
      <div class="note">
      <p>Bien que le serveur suive les liens symboliques, il ne modifie
      <em>pas</em> le nom de chemin concern dfini par la section
      <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>.</p>
       
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas tre considr comme
      une mesure de scurit efficace, car il existe toujours une
      situation de comptition (race condition) entre l'instant o l'on
      vrifie qu'un chemin n'est pas un lien symbolique, et l'instant o
      l'on utilise effectivement ce chemin.</p>
      </div></dd>

      <dt><code>Includes</code></dt>

      <dd>
      Les inclusions ct serveur (SSI)  l'aide du module
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> sont autorises.</dd>

      <dt><code>IncludesNOEXEC</code></dt>

      <dd>

      Les inclusions ct serveur (SSI) sont permises, mais <code>#exec
      cmd</code> et <code>#exec cgi</code> sont dsactives.
      L'utilisation de <code>#include virtual</code> pour les scripts
      CGI est cependant toujours possible depuis des rpertoires
      dfinis par <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>.</dd>

      <dt><code>Indexes</code></dt>

      <dd>
      Si une URL requise correspond au rpertoire concern, et si aucun
      <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code> (<em>par
      exemple</em> <code>index.html</code>) n'est dfini pour ce
      rpertoire, le module <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> va renvoyer
      un listing format du rpertoire.</dd>

      <dt><code>MultiViews</code></dt>

      <dd>
      Les vues multiples ("multiviews")  <a href="../content-negotiation.html">contenu ngoci</a>  l'aide du
      module <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> sont autorises.</dd>

      <dt><code>SymLinksIfOwnerMatch</code></dt>

      <dd>Le serveur ne suivra que les liens symboliques qui renvoient
      vers un fichier ou un rpertoire dont le propritaire est le mme
      que celui du lien.

      <div class="note"><h3>Note</h3>
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas tre considr comme
      une mesure de scurit efficace, car il existe toujours une
      situation de comptition (race condition) entre l'instant o l'on
      vrifie qu'un chemin n'est pas un lien symbolique, et l'instant o
      l'on utilise effectivement ce chemin.</p>
      </div> </dd>
    </dl>

    <p>Normalement, si plusieurs directives
    <code class="directive">Options</code> peuvent s'appliquer  un rpertoire,
    c'est la plus spcifique qui est utilise et les autres sont
    ignores ; les options ne sont pas fusionnes (voir <a href="../sections.html#mergin">comment les sections sont
    fusionnes</a>). Elles le sont cependant si <em>toutes</em> les
    options de la directive <code class="directive">Options</code> sont
    prcdes d'un symbole <code>+</code> ou <code>-</code>. Toute
    option prcde d'un <code>+</code> est ajoute  la liste des
    options courantes de manire force et toute option prcde d'un
    <code>-</code> est supprime de la liste des options courantes de la
    mme manire.</p>

    <div class="warning"><h3>Avertissement</h3>
    <p>Mlanger des <code class="directive">Options</code> avec <code>+</code>
    ou <code>-</code> avec des <code class="directive">Options</code> sans
    <code>+</code> ou <code>-</code> constitue une erreur de syntaxe, et
    peut rsulter en des comportements inattendus.</p>
    </div>

    <p>Par exemple, sans aucun symbole <code>+</code> et <code>-</code>
    :</p>

    <div class="example"><p><code>
      &lt;Directory /web/docs&gt;<br />
      <span class="indent">
        Options Indexes FollowSymLinks<br />
      </span>
      &lt;/Directory&gt;<br />
      <br />
      &lt;Directory /web/docs/spec&gt;<br />
      <span class="indent">
        Options Includes<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>ici, seule l'option <code>Includes</code> sera prise en compte
    pour le rpertoire <code>/web/docs/spec</code>. Par contre, si la
    seconde directive <code class="directive">Options</code> utilise les
    symboles <code>+</code> et <code>-</code> :</p>

    <div class="example"><p><code>
      &lt;Directory /web/docs&gt;<br />
      <span class="indent">
        Options Indexes FollowSymLinks<br />
      </span>
      &lt;/Directory&gt;<br />
      <br />
      &lt;Directory /web/docs/spec&gt;<br />
      <span class="indent">
        Options +Includes -Indexes<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>alors, les options <code>FollowSymLinks</code> et
    <code>Includes</code> seront prises en compte pour le rpertoire
    <code>/web/docs/spec</code>.</p>

    <div class="note"><h3>Note</h3>
      <p>L'utilisation de <code>-IncludesNOEXEC</code> ou
      <code>-Includes</code> dsactive compltement les inclusions ct
      serveur sans tenir compte des dfinitions prcdentes.</p>
    </div>

    <p>En l'absence de toute dfinition d'options, la valeur par dfaut
    est <code>All</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="protocol" id="protocol">Directive</a> <a name="Protocol" id="Protocol">Protocol</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Protocole pour une socket d'coute</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Protocol <var>protocole</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1.5 d'Apache, mais
uniquement depuis la version 2.3.3 sous Windows.</td></tr>
</table>
    <p>Cette directive permet de spcifier le protocole utilis pour une
    socket d'coute particulire. Le protocole sert  dterminer quel
    module doit traiter une requte, et d'appliquer les optimisations
    spcifiques au protocole via la directive
    <code class="directive">AcceptFilter</code>.</p>

    <p>Vous ne devez dfinir le protocole que si vous travaillez avec
    des ports non standards ; dans le cas gnral, le protocole
    <code>http</code> est associ au port 80 et le protocole
    <code>https</code> au port 443.</p>

    <p>Par exemple, si vous travaillez avec le protocole
    <code>https</code> sur un port non standard, spcifiez le protocole
    de manire explicite :</p>

    <div class="example"><p><code>
      Protocol https
    </code></p></div>

    <p>Vous pouvez aussi spcifier le protocole via la directive
    <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive">AcceptFilter</code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="require" id="require">Directive</a> <a name="Require" id="Require">Require</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine les utilisateurs authentifis autoriss  accder
 une ressource</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Require <var>nom entit</var> [<var>nom entit</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dterminer les utilisateurs
    authentifis autoriss  accder  une ressource. De multiples
    instances de cette directive se combinent entre elles avec un "OU"
    logique, si bien qu'un utilisateur qui convient  une ligne
    <code class="directive">Require </code> reoit l'autorisation d'accs.
    Les restrictions
    sont traites par les modules d'autorisation. Voici quelques
    exemples de syntaxes autorises par <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>
    et <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> :</p>

    <dl>
      <dt><code>Require user <var>identifiant_utilisateur</var>
      [<var>identifiant_utilisateur</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs spcifis peuvent accder  la
      ressource.</dd>

      <dt><code>Require group <var>nom_groupe</var> [<var>nom_groupe</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs appartenant aux groupes spcifis
      peuvent accder  la ressource.</dd>

      <dt><code>Require valid-user</code></dt>
      <dd>Tout utilisateur valide peut accder  la ressource.</dd>
    </dl>

    <p>D'autres modules d'autorisation comme
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>, <code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code>, et
    <code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code> implmentent les options de la
    directive Require.</p>

    <p>La directive <code class="directive">Require</code> doit tre associe
    aux directives <code class="directive"><a href="#authname">AuthName</a></code> et
    <code class="directive"><a href="#authtype">AuthType</a></code>, ainsi qu' des
    directives telles que <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> et <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code> (pour la
    dfinition des utilisateurs et des groupes) afin de pouvoir
    fonctionner correctement. Exemple :</p>

    <div class="example"><p><code>
       AuthType Basic<br />
       AuthName "Ressource  accs restreint"<br />
       AuthUserFile /web/users<br />
       AuthGroupFile /web/groups<br />
       Require group admin
    </code></p></div>

    <p>Les contrles d'accs appliqus de cette manire sont effectifs
    pour <strong>toutes</strong> les mthodes HTTP. <strong>C'est en gnral
    ce que l'on souhaite.</strong> Si vous dsirez n'appliquer les
    contrles d'accs que pour certaines mthodes, tout en laissant les
    autres mthodes sans protection, vous devez placer la directive
    <code class="directive">Require</code>  l'intrieur d'une section
    <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code>.</p>

    <p>Si la directive <code class="directive">Require</code> est utilise
    conjointement avec les directives <code class="directive"><a href="../mod/mod_authz_host.html#allow">Allow</a></code> ou <code class="directive"><a href="../mod/mod_authz_host.html#deny">Deny</a></code>, l'interaction entre les
    diffrentes restrictions imposes est contrle par la directive
    <code class="directive"><a href="#satisfy">Satisfy</a></code>.</p>

    <p>Plusieurs directives <code class="directive">Require</code> se combinent
    entre elles via un "OU" logique, mais certains modules
    d'authentification sous-jacents peuvent ncessiter une configuration
    explicite afin que l'authentification puisse tre chane avec
    d'autres. <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> qui exporte la directive
    <code class="directive">AuthzLDAPAuthoritative</code>  cet effet en est un cas
    typique.</p>

    <div class="note"><h3>Dsactivation des contrles d'accs pour certains
    sous-rpertoires</h3>
    <p>L'exemple suivant montre comment utiliser la directive <code class="directive"><a href="#satisfy">Satisfy</a></code> pour dsactiver les contrles
    d'accs dans un sous-rpertoire d'un rpertoire protg. Cette
    technique doit tre utilise avec prcautions, car elle va aussi
    dsactiver tout contrle d'accs impos par
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>.</p>
    <div class="example"><p><code>
      &lt;Directory /chemin/vers/protg/&gt;<br />
        <span class="indent">
        Require user david<br />
        </span>
      &lt;/Directory&gt;<br />
      &lt;Directory /chemin/vers/protg/non-protg&gt;<br />
        <span class="indent">
        # Tous les contrle d'accs et authentifications sont
	# dsactivs pour ce rpertoire<br />
        Satisfy Any<br />
        Allow from all<br />
        </span>
      &lt;/Directory&gt;<br />
    </code></p></div>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/auth.html">Authentification et autorisation</a></li>
<li><a href="../howto/access.html">Tutoriel du contrle d'accs</a></li>
<li><code class="directive"><a href="#satisfy">Satisfy</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitcpu" id="rlimitcpu">Directive</a> <a name="RLimitCPU" id="RLimitCPU">RLimitCPU</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le temps CPU allou aux processus initis par les
processus enfants d'Apache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitCPU <var>secondes</var>|max [<var>secondes</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Non dfini ; utilise les valeurs par dfaut du systme
d'exploitation</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites de ressources CPU sont exprimes en secondes par
    processus.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitmem">RLimitMEM</a></code></li>
<li><code class="directive"><a href="#rlimitnproc">RLimitNPROC</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitmem" id="rlimitmem">Directive</a> <a name="RLimitMEM" id="RLimitMEM">RLimitMEM</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite la mmoire alloue aux processus initis par les
processus enfants d'Apache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitMEM <var>octets</var>|max [<var>octets</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Non dfini ; utilise les valeurs par dfaut du systme
d'exploitation</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites de ressources mmoire sont exprimes en octets par
    processus.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitcpu">RLimitCPU</a></code></li>
<li><code class="directive"><a href="#rlimitnproc">RLimitNPROC</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitnproc" id="rlimitnproc">Directive</a> <a name="RLimitNPROC" id="RLimitNPROC">RLimitNPROC</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de processus qui peuvent tre initis par
les processus initis par les processus enfants d'Apache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitNPROC <var>nombre</var>|max [<var>nombre</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Unset; uses operating system defaults</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites des processus contrlent le nombre de processus par
    utilisateur.</p>

    <div class="note"><h3>Note</h3>
      <p>Si les processus CGI s'excutent sous le mme
      utilisateur que celui du serveur web, cette
      directive va limiter le nombre de processus que le serveur
      pourra lui-mme crer. La prsence de messages
      <strong><code>cannot fork</code></strong> dans le journal des
      erreurs indiquera que la limite est atteinte.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitmem">RLimitMEM</a></code></li>
<li><code class="directive"><a href="#rlimitcpu">RLimitCPU</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="satisfy" id="satisfy">Directive</a> <a name="Satisfy" id="Satisfy">Satisfy</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interaction entre les contrles d'accs par hte
et l'authentification des utilisateurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Satisfy Any|All</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Satisfy All</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Influenc par les sections <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> et <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code> dans les versions 2.0.51 et
suprieures</td></tr>
</table>
    <p>Cette directive permet de dfinir la politique d'accs lorsque
    les directives <code class="directive"><a href="../mod/mod_authz_host.html#allow">Allow</a></code> et <code class="directive"><a href="#require">Require</a></code> sont utilises conjointement.
    L'argument prend pour valeur <code>All</code> ou <code>Any</code>.
    Cette directive ne s'avre utile que dans le cas o l'accs  une
    zone particulire est contrl  la fois par une authentification
    utilisateur/mot de passe <em>et</em> par l'adresse IP du client.
    Avec la valeur par dfaut de l'argument (<code>All</code>), le
    client doit d'abord satisfaire  la condition d'accs en fonction de
    son adresse IP, <em>puis</em> fournir un couple utilisateur/mot de
    passe valide. Si l'argument est <code>Any</code>, le client se verra
    accorder l'accs s'il satisfait  au moins une des conditions d'accs
    : adresse IP et/ou un couple  utilisateur/mot de passe valides. On
    peut utiliser cette valeur pour restreindre l'accs  une zone 
    l'aide d'un mot de passe, mais laisser cette zone en accs libre
    pour les clients possdant certaines adresses IP.</p>

    <p>Par exemple, si vous souhaitez accorder un accs sans restriction
     une portion de votre site web aux clients de votre rseau, mais
    n'accorder cet accs aux clients  l'extrieur de votre rseau qu'en
    change d'un mot de passe, vous pouvez utiliser une configuration de
    ce style :</p>

    <div class="example"><p><code>
      Require valid-user<br />
      Order allow,deny<br />
      Allow from 192.168.1<br />
      Satisfy Any
    </code></p></div>

    <p>Depuis la version 2.0.51, les directives
    <code class="directive">Satisfy</code> peuvent tre limites  certaines
    mthodes particulires  l'aide des sections <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> et <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_authz_host.html#allow">Allow</a></code></li>
<li><code class="directive"><a href="#require">Require</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="scriptinterpretersource" id="scriptinterpretersource">Directive</a> <a name="ScriptInterpreterSource" id="ScriptInterpreterSource">ScriptInterpreterSource</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet de localiser l'interprteur des scripts
CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ScriptInterpreterSource Registry|Registry-Strict|Script</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ScriptInterpreterSource Script</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Win32 seulement ;
l'option <code>Registry-Strict</code> est disponible dans les versions
2.0 et suprieures d'Apache</td></tr>
</table>
    <p>Cette directive permet de contrler la mthode qu'utilise Apache
    pour trouver l'interprteur destin  excuter les scripts CGI. La
    dfinition par dfaut est <code>Script</code> : ceci indique 
    Apache qu'il doit utiliser l'interprteur prcis dans la ligne
    shebang du script (la premire ligne, commenant par
    <code>#!</code>). Sur les systmes Win32, cette ligne ressemble
    souvent  ceci :</p>

    <div class="example"><p><code>
      #!C:/Perl/bin/perl.exe
    </code></p></div>

    <p>ou simplement, dans le cas o <code>perl</code> est dans le
    <code>PATH</code> :</p>

    <div class="example"><p><code>
      #!perl
    </code></p></div>

    <p>Avec <code>ScriptInterpreterSource Registry</code>, Windows va
    effectuer une recherche dans l'arborescence
    <code>HKEY_CLASSES_ROOT</code> de la base de registre avec comme
    mot-cl l'extension du fichier contenant le script (par exemple
    <code>.pl</code>). C'est la commande dfinie par la sous-cl de
    registre <code>Shell\ExecCGI\Command</code> ou, si elle n'existe
    pas, la sous-cl <code>Shell\Open\Command</code> qui est utilise
    pour ouvrir le fichier du script. Si ces cls de registre ne sont
    pas trouves, Apache utilise la mthode de l'option
    <code>Script</code>.</p>

    <p>Par exemple, pour que les scripts possdant l'extension .pl
    soient traits par perl, la ligne du registre doit tre :</p>

    <div class="example"><p><code><code>HKEY_CLASSES_ROOT\.pl\Shell\ExecCGI\Command\(Default)
    =&gt; C:\Perl\bin\perl.exe -wT</code></code></p></div>

    <div class="warning"><h3>Scurit</h3>
    <p>Soyez prudent si vous utilisez <code>ScriptInterpreterSource
    Registry</code> avec des rpertoires faisant l'objet d'un <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>, car Apache va essayer
    d'excuter <strong>tous</strong> les fichiers contenus dans
    celui-ci. L'option <code>Registry</code> peut causer des appels de
    programmes non voulus sur des fichiers non destins  tre excuts.
    Par exemple, la commande par dfaut open sur les fichiers
    <code>.htm</code> sur la plupart des systmes Windows va lancer
    Microsoft Internet Explorer ; ainsi, toute requte HTTP pour un
    fichier <code>.htm</code> situ dans le rpertoire des scripts
    va lancer le navigateur en arrire-plan sur le serveur, ce qui a
    toutes les chances de crasher votre systme dans les minutes qui
    suivent.</p>
    </div>

    <p>L'option <code>Registry-Strict</code>, apparue avec Apache 2.0,
    agit de manire identique  <code>Registry</code>, mais n'utilise
    que la sous-cl <code>Shell\ExecCGI\Command</code>. La prsence de
    la cl <code>ExecCGI</code> n'tant pas systmatique, Elle doit tre
    dfinie manuellement dans le registre Windows et vite ainsi tout
    appel de programme accidentel sur votre systme.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serveradmin" id="serveradmin">Directive</a> <a name="ServerAdmin" id="ServerAdmin">ServerAdmin</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'adresse lectronique que le serveur inclut dans les
messages d'erreur envoys au client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerAdmin <var>adresse lectronique</var>|<var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerAdmin</code> permet de dfinir
    l'adresse de contact que le serveur va inclure dans tout message
    d'erreur qu'il envoie au client. Si le programme <code>httpd</code>
    ne reconnait pas l'argument fourni comme une URL, il suppose que
    c'est une <var>adresse lectronique</var>, et lui ajoute le prfixe
    <code>mailto:</code> dans les cibles des hyperliens. Il est
    cependant recommand d'utiliser exclusivement une adresse
    lectronique, car de nombreux scripts CGI considrent ceci comme
    implicite. Si vous utilisez une URL, elle doit pointer vers un autre
    serveur que vous contrlez. Dans le cas contraire, les utilisateurs
    seraient dans l'impossibilit de vous contacter en cas de problme.</p>

    <p>Il peut s'avrer utile de dfinir une adresse ddie 
    l'administration du serveur, par exemple :</p>

    <div class="example"><p><code>
      ServerAdmin www-admin@foo.example.com
    </code></p></div>
    <p>car les utilisateurs ne mentionnent pas systmatiquement le
    serveur dont ils parlent !</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serveralias" id="serveralias">Directive</a> <a name="ServerAlias" id="ServerAlias">ServerAlias</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Autres noms d'un serveur utilisables pour atteindre des
serveurs virtuels  base de nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerAlias <var>nom serveur</var> [<var>nom serveur</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerAlias</code> permet de dfinir
    les noms alternatifs d'un serveur utilisables pour atteindre des <a href="../vhosts/name-based.html">serveurs virtuels  base de
    nom</a>. La directive <code class="directive">ServerAlias</code> peut
    contenir des caractres gnriques, si ncessaire.</p>

    <div class="example"><p><code>
      &lt;VirtualHost *:80&gt;<br />
      ServerName serveur.domaine.com<br />
      ServerAlias serveur serveur2.domaine.com serveur2<br />
      ServerAlias *.example.com<br />
      UseCanonicalName Off<br />
      # ...<br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>La recherche du serveur virtuel  base de nom qui correspond le
    mieux s'effectue selon l'ordre d'apparition des sections <code class="directive"><a href="#virtualhost">&lt;virtualhost&gt;</a></code> dans le fichier
    de configuration. Le premier serveur virtuel dont le <code class="directive"><a href="#servername">ServerName</a></code> ou le <code class="directive"><a href="#serveralias">ServerAlias</a></code> correspond est choisi, sans
    prfrence si le nom contient des caractres gnriques ou pas.</p>

    <p>Tous les noms spcifis au sein d'une section
    <code class="directive">VirtualHost</code> sont traits comme un
    <code class="directive">ServerAlias</code> (sans caractres gnriques).</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
d'Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="servername" id="servername">Directive</a> <a name="ServerName" id="ServerName">ServerName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom d'hte et port que le serveur utilise pour
s'authentifier lui-mme</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerName [<var>protocole</var>://]<var>nom de domaine
entirement qualifi</var>[:<var>port</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Dans la version 2.0, cette directive remplace la
fonctionnalit de la directive <code class="directive">Port</code> de la version
1.3.</td></tr>
</table>
    <p>La directive <code class="directive">ServerName</code> permet de dfinir
    les protocole, nom d'hte et port d'une requte que le serveur
    utilise pour s'authentifier lui-mme. Ceci est utile lors de la
    cration de redirections d'URLs.</p>

    <p>La directive <code class="directive">ServerName</code> permet aussi
    (ventuellement en conjonction avec la directive
    <code class="directive">ServerAlias</code>) d'identifier de manire unique
    un serveur virtuel, lorsqu'elle est utilise dans un contexte de <a href="../vhosts/name-based.html">serveurs virtuels par
    noms</a>.</p>

    <p>Par exemple, si le nom de la
    machine hbergeant le serveur web est
    <code>simple.example.com</code>, la machine possde l'alias
    DNS <code>www.example.com</code>, et si vous voulez que le serveur
    web s'identifie avec cet alias, vous devez utilisez la dfinition
    suivante :</p>

    <div class="example"><p><code>
      ServerName www.example.com
    </code></p></div>

    <p>Si la directive <code class="directive">ServerName</code> n'est pas
    dfinie, le serveur tente de dterminer le nom d'hte en effectuant
    une recherche DNS inverse sur son adresse IP. Si la directive
    <code class="directive">ServerName</code> ne prcise pas de port, le serveur
    utilisera celui de la requte entrante. Il est recommand de
    spcifier un nom d'hte et un port spcifiques  l'aide de la
    directive <code class="directive">ServerName</code> pour une fiabilit
    optimale et  titre prventif.</p>

    <p>Si vous dfinissez des <a href="../vhosts/name-based.html">serveurs virtuels  base de
    nom</a>, une directive <code class="directive">ServerName</code> situe 
    l'intrieur d'une section <code class="directive"><a href="#virtualhost">&lt;VirtualHost&gt;</a></code> spcifiera quel nom d'hte
    doit apparatre dans l'en-tte de requte <code>Host:</code> pour
    pouvoir atteindre ce serveur virtuel.</p>


    <p>Parfois, le serveur s'excute en amont d'un dispositif qui
    implmente SSL, comme un mandataire inverse, un rpartiteur de
    charge ou un botier ddi SSL. Dans ce cas, spcifiez le protocole
    <code>https://</code> et le port auquel les clients se connectent
    dans la directive <code class="directive">ServerName</code>, afin de
    s'assurer que le serveur gnre correctement ses URLs
    d'auto-identification.
    </p>

    <p>Voir la description des directives <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code> et <code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code> pour les
    dfinitions qui permettent de dterminer si les URLs
    auto-identifiantes (par exemple via le module
    <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code>) vont faire rfrence au port spcifi, ou
    au port indiqu dans la requte du client.
    </p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../dns-caveats.html">Problmes concernant le DNS et
Apache</a></li>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
d'Apache</a></li>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code></li>
<li><code class="directive"><a href="#namevirtualhost">NameVirtualHost</a></code></li>
<li><code class="directive"><a href="#serveralias">ServerAlias</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serverpath" id="serverpath">Directive</a> <a name="ServerPath" id="ServerPath">ServerPath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom de chemin d'URL hrit pour un serveur virtuel  base
de nom accd par un navigateur incompatible</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerPath <var>chemin d'URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerPath</code> permet de dfinir
    le nom de chemin d'URL hrit d'un hte,  utiliser avec les <a href="../vhosts/">serveurs virtuels  base de nom</a>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
d'Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serverroot" id="serverroot">Directive</a> <a name="ServerRoot" id="ServerRoot">ServerRoot</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Racine du rpertoire d'installation du
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerRoot <var>chemin de rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerRoot /usr/local/apache</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerRoot</code> permet de dfinir
    le rpertoire dans lequel le serveur est install. En particulier,
    il contiendra les sous-rpertoires <code>conf/</code> et
    <code>logs/</code>. Les chemins relatifs indiqus dans les autres
    directives (comme <code class="directive"><a href="#include">Include</a></code> ou <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>) seront dfinis par
    rapport  ce rpertoire.</p>

    <div class="example"><h3>Example</h3><p><code>
      ServerRoot /home/httpd
    </code></p></div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../invoking.html">the <code>-d</code>
    options de <code>httpd</code></a></li>
<li><a href="../misc/security_tips.html#serverroot">les conseils 
propos de la scurit</a> pour des informations sur la manire de dfinir
correctement les permissions sur le rpertoire indiqu par la directive
<code class="directive">ServerRoot</code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serversignature" id="serversignature">Directive</a> <a name="ServerSignature" id="ServerSignature">ServerSignature</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit un pied de page pour les documents gnrs par le
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerSignature On|Off|EMail</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerSignature Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerSignature</code> permet de
    dfinir une ligne de pied de page fixe pour les documents gnrs
    par le serveur (messages d'erreur, listings de rpertoires ftp de
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, sorties de <code class="module"><a href="../mod/mod_info.html">mod_info</a></code>,
    etc...). Dans le cas d'une chane de mandataires, l'utilisateur n'a
    souvent aucun moyen de dterminer lequel des mandataires chans a
    gnr un message d'erreur, et c'est une des raisons pour lesquelles
    on peut tre amen  ajouter un tel pied de page.</p>

    <p>La valeur par dfaut <code>Off</code> supprime la ligne de pied
    de page (et est ainsi compatible avec le comportement des
    versions 1.2 et antrieures d'Apache). la valeur <code>On</code>
    ajoute simplement une ligne contenant le numro de version du
    serveur ainsi que le nom du serveur virtuel issu de la directive
    <code class="directive"><a href="#servername">ServerName</a></code>, alors que la valeur
    <code>EMail</code> ajoute en plus une rfrence "mailto:" 
    l'administrateur du document rfrenc issu la directive
    <code class="directive"><a href="#serveradmin">ServerAdmin</a></code>.</p>

    <p>Depuis la version 2.0.44, les dtails  propos du numro de
    version du serveur sont contrls  l'aide de la directive
    <code class="directive"><a href="#servertokens">ServerTokens</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#servertokens">ServerTokens</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="servertokens" id="servertokens">Directive</a> <a name="ServerTokens" id="ServerTokens">ServerTokens</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure l'en-tte <code>Server</code> de la rponse
HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerTokens Major|Minor|Min[imal]|Prod[uctOnly]|OS|Full</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerTokens Full</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de contrler le contenu de l'en-tte
    <code>Server</code> inclus dans la rponse envoye au client : cet
    en-tte peut contenir le type de systme d'exploitation du serveur,
    ainsi que des informations  propos des modules compils avec le
    serveur.</p>

    <dl>
      <dt><code>ServerTokens Prod[uctOnly]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache</code></dd>

      <dt><code>ServerTokens Major</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2</code></dd>

      <dt><code>ServerTokens Minor</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.0</code></dd>

      <dt><code>ServerTokens Min[imal]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.0.41</code></dd>

      <dt><code>ServerTokens OS</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.0.41 (Unix)</code></dd>

      <dt><code>ServerTokens Full</code> (valeur par dfaut)</dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.0.41 (Unix) PHP/4.2.2 MyMod/1.2</code></dd>
    </dl>

    <p>Cette dfinition s'applique  l'ensemble du serveur et ne peut
    tre active ou dsactive pour tel ou tel serveur virtuel.</p>

    <p>Dans les versions postrieures  2.0.44, cette directive contrle
    galement les informations fournies par la directive <code class="directive"><a href="#serversignature">ServerSignature</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#serversignature">ServerSignature</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sethandler" id="sethandler">Directive</a> <a name="SetHandler" id="SetHandler">SetHandler</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force le traitement des fichiers spcifis par un
gestionnaire particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetHandler <var>nom gestionnaire</var>|None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Intgr dans le noyau d'Apache depuis la version
2.0</td></tr>
</table>
    <p>Lorsqu'elle se situe  l'intrieur d'un fichier
    <code>.htaccess</code>, ou d'une section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, cette directive force le
    traitement de tous les fichiers spcifis par le <a href="../handler.html">gestionnaire</a> dfini par l'argument
    <var>nom gestionnaire</var>. Par exemple, dans le cas d'un
    rpertoire dont vous voulez interprter le contenu comme des
    fichiers de rgles d'images cliquables, sans tenir compte des
    extensions, vous pouvez ajouter la ligne suivante dans un fichier
    <code>.htaccess</code> de ce rpertoire :</p>

    <div class="example"><p><code>
      SetHandler imap-file
    </code></p></div>

    <p>Autre exemple : si vous voulez que le serveur affiche un
    compte-rendu d'tat chaque fois qu'une URL du type <code>http://nom
    serveur/status</code> est appele, vous pouvez ajouter ceci dans
    <code>httpd.conf</code> :</p>

    <div class="example"><p><code>
      &lt;Location /status&gt;<br />
      <span class="indent">
        SetHandler server-status<br />
      </span>
      &lt;/Location&gt;
    </code></p></div>

    <p>Vous pouvez craser la dfinition antrieure d'une directive
    <code class="directive">SetHandler</code> en utilisant la valeur
    <code>None</code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="setinputfilter" id="setinputfilter">Directive</a> <a name="SetInputFilter" id="SetInputFilter">SetInputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les filtres par lesquels vont passer les requtes
client et les donnes POST</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetInputFilter <var>filtre</var>[;<var>filtre</var>...]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">SetInputFilter</code> permet de
    dfinir le ou les filtres par lesquels vont passer les requtes
    client et les donnes POST au moment o le serveur les reoit. Cette
    dfinition vient en ajout  tout autre filtre dfini en
    quelqu'endroit que ce soit, y compris via la directive <code class="directive"><a href="../mod/mod_mime.html#addinputfilter">AddInputFilter</a></code>.</p>

    <p>Si la directive comporte plusieurs filtres, ils doivent tre
    spars par des points-virgules, et spcifis selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>

<h3>Voir aussi</h3>
<ul>
<li>documentation des <a href="../filter.html">Filtres</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="setoutputfilter" id="setoutputfilter">Directive</a> <a name="SetOutputFilter" id="SetOutputFilter">SetOutputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les filtres par lesquels vont passer les rponses
du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetOutputFilter <var>filtre</var>[;<var>filtre</var>...]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">SetOutputFilter</code> permet de
    dfinir les filtres par lesquels vont passer les rponses du serveur
    avant d'tre envoyes au client. Cette dfinition vient en ajout 
    tout autre filtre dfini en quelqu'endroit que ce soit, y compris
    via la directive <code class="directive"><a href="../mod/mod_mime.html#addoutputfilter">AddOutputFilter</a></code>.</p>

    <p>Par exemple, la configuration suivante va traiter tous les
    fichiers du rpertoire <code>/www/data/</code> comme des inclusions
    ct serveur (SSI) :</p>

    <div class="example"><p><code>
      &lt;Directory /www/data/&gt;<br />
      <span class="indent">
        SetOutputFilter INCLUDES<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>Si la directive comporte plusieurs filtres, ils doivent tre
    spars par des points-virgules, et spcifis selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../filter.html">Filters</a> documentation</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="suexec" id="suexec">Directive</a> <a name="Suexec" id="Suexec">Suexec</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active ou dsactive la fonctionnalit suEXEC</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Suexec On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>On si le binaire suexec existe avec un mode et un propritaire
appropris, Off dans le cas contraire</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.18 d'Apache httpd</td></tr>
</table>
    <p>Lorsque cette directive est dfinie  On, le dmarrage du serveur
    chouera si le binaire suexec n'existe pas, ou possde un mode de
    fichier ou un propritaire invalides.</p>
    <p>Lorsque cette directive est dfinie  Off, la fonctionnalit
    suEXEC est dsactive, mme si le binaire suexec existe et possde
    un mode de fichier et un propritaire valides.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="timeout" id="timeout">Directive</a> <a name="TimeOut" id="TimeOut">TimeOut</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Temps pendant lequel le serveur va attendre certains
vnements avant de considrer qu'une requte a chou</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TimeOut <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>TimeOut 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">TimeOut</code> permet
    de dfinir le temps maximum pendant lequel Apache va attendre des
    entres/sorties dans diverses circonstances :</p>

    <ol>
      <li>Lors de la lecture de donnes en provenance du client, le
      temps maximum d'attente avant l'arrive d'un paquet TCP si le
      tampon de lecture est vide.</li>

      <li>Lors de l'envoi de donnes vers le client, le temps maximum
      d'attente avant l'arrive de l'accus-rception d'un paquet si le
      tampon d'envoi est plein.</li>

      <li>Avec <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>, le temps maximum
      d'attente avant la sortie des donnes d'un script CGI.</li>

      <li>Avec <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code>, le temps maximum
      d'attente avant la sortie des donnes d'un processus de
      filtrage.</li>

      <li>Avec <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, la valeur du dlai par dfaut
      si la directive <code class="directive"><a href="../mod/mod_proxy.html#proxytimeout">ProxyTimeout</a></code> n'a pas t
      dfinie.</li>
    </ol>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="traceenable" id="traceenable">Directive</a> <a name="TraceEnable" id="TraceEnable">TraceEnable</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le comportement des requtes
<code>TRACE</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TraceEnable <var>[on|off|extended]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>TraceEnable on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans les versions 1.3.34, 2.0.55 et
suprieures d'Apache</td></tr>
</table>
    <p>Cette directive l'emporte sur le comportement de
    <code>TRACE</code> pour le noyau du serveur et
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. La dfinition par dfaut
    <code>TraceEnable on</code> permet des requtes <code>TRACE</code>
    selon la RFC 2616, qui interdit d'ajouter tout corps  la requte.
    La dfinition <code>TraceEnable off</code> indique au noyau du
    serveur et  <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> de retourner un code
    d'erreur <code>405</code> (Mthode non autorise) au client.</p>

    <p>En fait, et  des fins de test et de diagnostic seulement, on
    peut autoriser l'ajout d'un corps de requte  l'aide de la
    dfinition non standard <code>TraceEnable extended</code>. Le noyau
    du serveur (dans le cas d'un serveur d'origine) va limiter la taille
    du corps de requte  64k (plus 8k pour les en-ttes de
    fractionnement si <code>Transfer-Encoding: chunked</code> est
    utilis). Le noyau du serveur va reproduire l'ensemble des en-ttes,
    y compris les en-ttes de fractionnement avec le corps de la
    rponse. Dans le cas d'un serveur mandataire, la taille du corps de
    requte n'est pas limite  64k.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="usecanonicalname" id="usecanonicalname">Directive</a> <a name="UseCanonicalName" id="UseCanonicalName">UseCanonicalName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la manire dont le serveur dtermine son propre nom
et son port</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>UseCanonicalName On|Off|DNS</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>UseCanonicalName Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Dans de nombreuses situations, Apache doit construire une URL
    <em>auto-identifiante</em> -- c'est  dire une URL qui fait
    rfrence au serveur lui-mme. Avec <code>UseCanonicalName
    On</code>, Apache va utiliser le nom d'hte et le port spcifis par
    la directive <code class="directive"><a href="#servername">ServerName</a></code> pour
    construire le nom canonique du serveur. Ce nom est utilis dans
    toutes les URLs auto-identifiantes, et affect aux variables
    <code>SERVER_NAME</code> et <code>SERVER_PORT</code> dans les
    programmes CGI.</p>

    <p>Avec <code>UseCanonicalName Off</code>, Apache va construire ses
    URLs auto-identifiantes  l'aide du nom d'hte et du port fournis
    par le client, si ce dernier en a fourni un (dans la ngative,
    Apache utilisera le nom canonique, de la mme manire que
    ci-dessus). Ces valeurs sont les mmes que celles qui sont utilises
    pour implmenter les <a href="../vhosts/name-based.html">serveurs virtuels par
    nom</a>, et sont disponibles avec les mmes clients. De mme, les
    variables CGI <code>SERVER_NAME</code> et <code>SERVER_PORT</code>
    seront affectes des valeurs fournies par le client.</p>

    <p>Cette directive peut s'avrer utile, par exemple, sur un serveur
    intranet auquel les utilisateurs se connectent en utilisant des noms
    courts tels que <code>www</code>. Si les utilisateurs tapent un nom
    court suivi d'une URL qui fait rfrence  un rpertoire, comme
    <code>http://www/splat</code>, <em>sans le slash terminal</em>, vous
    remarquerez qu'Apache va les rediriger vers
    <code>http://www.domain.com/splat/</code>. Si vous avez activ
    l'authentification, ceci va obliger l'utilisateur  s'authentifier
    deux fois (une premire fois pour <code>www</code> et une seconde
    fois pour <code>www.domain.com</code> -- voir <a href="http://wiki.apache.org/httpd/FAQ#Why_does_Apache_ask_for_my_password_twice_before_serving_a_file.3F">la
    foire aux questions sur ce sujet pour plus d'informations</a>). Par
    contre, si <code class="directive">UseCanonicalName</code> est dfinie 
    <code>Off</code>, Apache redirigera l'utilisateur vers
    <code>http://www/splat/</code>.</p>

    <p>Pour l'hbergement virtuel en masse par adresse IP, on
    utilise une troisime option, <code>UseCanonicalName
    DNS</code>, pour supporter les clients anciens qui ne
    fournissent pas d'en-tte <code>Host:</code>. Apache effectue alors
    une recherche DNS inverse sur l'adresse IP du serveur auquel le
    client s'est connect afin de construire ses URLs
    auto-identifiantes.</p>

    <div class="warning"><h3>Avertissement</h3>
    <p>Les programmes CGI risquent d'tre perturbs par cette option
    s'ils tiennent compte de la variable <code>SERVER_NAME</code>. Le
    client est pratiquement libre de fournir la valeur qu'il veut comme
    nom d'hte. Mais si le programme CGI n'utilise
    <code>SERVER_NAME</code> que pour construire des URLs
    auto-identifiantes, il ne devrait pas y avoir de problme.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code></li>
<li><code class="directive"><a href="#servername">ServerName</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="usecanonicalphysicalport" id="usecanonicalphysicalport">Directive</a> <a name="UseCanonicalPhysicalPort" id="UseCanonicalPhysicalPort">UseCanonicalPhysicalPort</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la manire dont le serveur dtermine son propre nom
et son port</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>UseCanonicalPhysicalPort On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>UseCanonicalPhysicalPort Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Dans de nombreuses situations, Apache doit construire une URL
    <em>auto-identifiante</em> -- c'est  dire une URL qui fait
    rfrence au serveur lui-mme. Avec <code>UseCanonicalPhysicalPort
    On</code>, Apache va fournir le numro de port physique rel utilis
    par la requte en tant que port potentiel, pour construire le port
    canonique afin que le serveur puisse alimenter la directive
    <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code>. Avec
    <code>UseCanonicalPhysicalPort Off</code>, Apache n'utilisera pas le
    numro de port physique rel, mais au contraire se rfrera aux
    informations de configuration pour construire un numro de port
    valide.</p>

    <div class="note"><h3>Note</h3>
    <p>L'ordre dans lequel s'effectue la recherche du port est le
    suivant :<br /><br />
     <code>UseCanonicalName On</code></p>
     <ul>
      <li>Port spcifi par <code>Servername</code></li>
      <li>Port physique</li>
      <li>Port par dfaut</li>
     </ul>
     <code>UseCanonicalName Off | DNS</code>
     <ul>
      <li>Port spcifi dans l'en-tte <code>Host:</code></li>
      <li>Port physique</li>
      <li>Port spcifi par <code>Servername</code></li>
      <li>Port par dfaut</li>
     </ul>

    <p>Avec <code>UseCanonicalPhysicalPort Off</code>, on reprend
    l'ordre ci-dessus en supprimant "Port physique".</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><code class="directive"><a href="#servername">ServerName</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="virtualhost" id="virtualhost">Directive</a> <a name="VirtualHost" id="VirtualHost">&lt;VirtualHost&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent qu' un nom
d'hte spcifique ou  une adresse IP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;VirtualHost
    <var>adresse IP</var>[:<var>port</var>] [<var>adresse
    IP</var>[:<var>port</var>]] ...&gt; ...
    &lt;/VirtualHost&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;VirtualHost&gt;</code> et
    <code>&lt;/VirtualHost&gt;</code> permettent de rassembler un groupe
    de directives qui ne s'appliquent qu' un serveur virtuel
    particulier. Toute directive autorise dans un contexte de serveur
    virtuel peut tre utilise. Lorsque le serveur reoit un requte
    pour un document hberg par un serveur virtuel particulier, il
    applique les directives de configuration rassembles dans la section
    <code class="directive">&lt;VirtualHost&gt;</code>. <var>adresse
    IP</var> peut tre :</p>

    <ul>
      <li>L'adresse IP du serveur virtuel ;</li>

      <li>Un nom de domaine entirement qualifi correspondant 
      l'adresse IP du serveur virtuel (non recommand) ;</li>

      <li>Le caractre <code>*</code>, qui n'est utilis qu'en
      combinaison avec <code>NameVirtualHost *</code> pour intercepter
      toutes les adresses IP ; ou</li>

      <li>La chane de caractres <code>_default_</code>, qui n'est
      utilise qu'avec l'hbergement virtuel  base d'adresse IP pour
      intercepter les adresses IP qui ne correspondent  aucun serveur
      virtuel.</li>
    </ul>

    <div class="example"><h3>Exemple</h3><p><code>
      &lt;VirtualHost 10.1.2.3:80&gt;<br />
      <span class="indent">
        ServerAdmin webmaster@host.example.com<br />
        DocumentRoot /www/docs/host.example.com<br />
        ServerName host.example.com<br />
        ErrorLog logs/host.example.com-error_log<br />
        TransferLog logs/host.example.com-access_log<br />
      </span>
      &lt;/VirtualHost&gt;
    </code></p></div>


    <p>Les adresses IPv6 doivent tre entoures de crochets car dans le
    cas contraire, un ventuel port optionnel ne pourrait pas tre
    dtermin. Voici un exemple de serveur virtuel avec adresse IPv6
    :</p>

    <div class="example"><p><code>
      &lt;VirtualHost [2001:db8::a00:20ff:fea7:ccea]:80&gt;<br />
      <span class="indent">
        ServerAdmin webmaster@host.example.com<br />
        DocumentRoot /www/docs/host.example.com<br />
        ServerName host.example.com<br />
        ErrorLog logs/host.example.com-error_log<br />
        TransferLog logs/host.example.com-access_log<br />
      </span>
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Chaque serveur virtuel doit correspondre  une adresse IP, un
    port ou un nom d'hte spcifique ; dans le premier cas, le serveur
    doit tre configur pour recevoir les paquets IP de plusieurs
    adresses (si le serveur n'a qu'une interface rseau, on peut
    utiliser  cet effet la commande <code>ifconfig alias</code> -- si
    votre systme d'exploitation le permet).</p>

    <div class="note"><h3>Note</h3>
    <p>L'utilisation de la directive <code class="directive">&lt;VirtualHost&gt;</code> n'affecte en rien les
    adresses IP sur lesquelles Apache est en coute. Vous devez vous
    assurer que les adresses des serveurs virtuels sont bien incluses
    dans la liste des adresses prcises par la directive <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>.</p>
    </div>

    <p>Avec l'hbergement virtuel  base d'adresse IP, on peut utiliser
    le nom spcial <code>_default_</code>, auquel cas le serveur virtuel
    considr interceptera toute adresse IP qui n'est pas explicitement
    associe  un autre serveur virtuel. En l'absence de serveur virtuel
    associ  <code>_default_</code>, et si l'adresse IP demande ne
    correspond  aucun serveur virtuel, c'est la configuration du
    serveur "principal" qui sera utilise, c'est  dire l'ensemble des
    dfinitions situes en dehors de toute section VirtualHost (Notez
    cependant que toute adresse IP correspondant  une directive
    <code class="directive"><a href="#namevirtualhost">NameVirtualHost</a></code> n'utilisera ni
    la configuration du serveur "principal", ni le serveur virtuel
    <code>_default_</code>. Voir la documentation de l'<a href="../vhosts/name-based.html">hbergement virtuel par
    nom</a> pour plus de dtails).</p>

    <p>Vous pouvez spcifier <code>:port</code> pour modifier le port du
    serveur virtuel. S'il n'est pas spcifi, sa valeur par dfaut
    correspond  celle qui est dfinie par la dernire directive
    <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> du serveur
    principal. Vous pouvez aussi spcifier <code>:*</code> pour accepter
    tous les ports associs  l'adresse du serveur virtuel (c'est une
    configuration recommande lorsqu'on utilise
    <code>_default_</code>).</p>

    <p>Tout bloc <code class="directive">&lt;VirtualHost&gt;</code> doit comporter une directive
    <code class="directive"><a href="#servername">ServerName</a></code>. Dans le cas
    contraire, le serveur virtuel hritera de la valeur de la directive
    <code class="directive"><a href="#servername">ServerName</a></code> issue de la
    configuration du serveur principal.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>Voir le document sur les <a href="../misc/security_tips.html">conseils  propos de la scurit</a>
    pour une description dtaille des raisons pour lesquelles la
    scurit de votre serveur pourrait tre compromise, si le rpertoire
    contenant les fichiers journaux est inscriptible par tout autre
    utilisateur que celui qui dmarre le serveur.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation des serveurs virtuels
d'Apache</a></li>
<li><a href="../dns-caveats.html">Problmes concernant DNS et
Apache</a></li>
<li><a href="../bind.html">Dfinition des adresses et ports
qu'utilise Apache</a></li>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../de/mod/core.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/core.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/core.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/core.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.2/mod/core.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>