/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSGPIOMON_H
#define _REGSGPIOMON_H  1

#include "regs.h"

#ifndef REGS_GPIOMON_BASE
#define REGS_GPIOMON_BASE (REGS_BASE + 0x0003C300)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK0_DATAIN - GPIO Monitor Bank0 DataIn Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank0_datain_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK0_DATAIN register
//

#define HW_GPIOMON_BANK0_DATAIN_ADDR      (REGS_GPIOMON_BASE + 0x00000000)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK0_DATAIN           (*(volatile hw_gpiomon_bank0_datain_t *) HW_GPIOMON_BANK0_DATAIN_ADDR)
#define HW_GPIOMON_BANK0_DATAIN_RD()      (HW_GPIOMON_BANK0_DATAIN.U)
#endif


//
// constants & macros for individual HW_GPIOMON_BANK0_DATAIN bitfields
//

//--- Register HW_GPIOMON_BANK0_DATAIN, field DATA

#define BP_GPIOMON_BANK0_DATAIN_DATA      0
#define BM_GPIOMON_BANK0_DATAIN_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK0_DATAIN_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK0_DATAIN_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK1_DATAIN - GPIO Monitor Bank1 DataIn Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank1_datain_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK1_DATAIN register
//

#define HW_GPIOMON_BANK1_DATAIN_ADDR      (REGS_GPIOMON_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK1_DATAIN           (*(volatile hw_gpiomon_bank1_datain_t *) HW_GPIOMON_BANK1_DATAIN_ADDR)
#define HW_GPIOMON_BANK1_DATAIN_RD()      (HW_GPIOMON_BANK1_DATAIN.U)
#endif


//
// constants & macros for individual HW_GPIOMON_BANK1_DATAIN bitfields
//

//--- Register HW_GPIOMON_BANK1_DATAIN, field DATA

#define BP_GPIOMON_BANK1_DATAIN_DATA      0
#define BM_GPIOMON_BANK1_DATAIN_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK1_DATAIN_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK1_DATAIN_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK2_DATAIN - GPIO Monitor Bank2 DataIn Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank2_datain_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK2_DATAIN register
//

#define HW_GPIOMON_BANK2_DATAIN_ADDR      (REGS_GPIOMON_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK2_DATAIN           (*(volatile hw_gpiomon_bank2_datain_t *) HW_GPIOMON_BANK2_DATAIN_ADDR)
#define HW_GPIOMON_BANK2_DATAIN_RD()      (HW_GPIOMON_BANK2_DATAIN.U)
#endif


//
// constants & macros for individual HW_GPIOMON_BANK2_DATAIN bitfields
//

//--- Register HW_GPIOMON_BANK2_DATAIN, field DATA

#define BP_GPIOMON_BANK2_DATAIN_DATA      0
#define BM_GPIOMON_BANK2_DATAIN_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK2_DATAIN_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK2_DATAIN_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK3_DATAIN - GPIO Monitor Bank3 DataIn Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank3_datain_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK3_DATAIN register
//

#define HW_GPIOMON_BANK3_DATAIN_ADDR      (REGS_GPIOMON_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK3_DATAIN           (*(volatile hw_gpiomon_bank3_datain_t *) HW_GPIOMON_BANK3_DATAIN_ADDR)
#define HW_GPIOMON_BANK3_DATAIN_RD()      (HW_GPIOMON_BANK3_DATAIN.U)
#endif


//
// constants & macros for individual HW_GPIOMON_BANK3_DATAIN bitfields
//

//--- Register HW_GPIOMON_BANK3_DATAIN, field DATA

#define BP_GPIOMON_BANK3_DATAIN_DATA      0
#define BM_GPIOMON_BANK3_DATAIN_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK3_DATAIN_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK3_DATAIN_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK0_DATAOUT - GPIO Monitor Bank0 DataOut Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank0_dataout_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK0_DATAOUT register
//

#define HW_GPIOMON_BANK0_DATAOUT_ADDR      (REGS_GPIOMON_BASE + 0x00000040)
#define HW_GPIOMON_BANK0_DATAOUT_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000044)
#define HW_GPIOMON_BANK0_DATAOUT_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000048)
#define HW_GPIOMON_BANK0_DATAOUT_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK0_DATAOUT           (*(volatile hw_gpiomon_bank0_dataout_t *) HW_GPIOMON_BANK0_DATAOUT_ADDR)
#define HW_GPIOMON_BANK0_DATAOUT_RD()      (HW_GPIOMON_BANK0_DATAOUT.U)
#define HW_GPIOMON_BANK0_DATAOUT_WR(v)     (HW_GPIOMON_BANK0_DATAOUT.U = (v))
#define HW_GPIOMON_BANK0_DATAOUT_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOUT_SET_ADDR) = (v))
#define HW_GPIOMON_BANK0_DATAOUT_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOUT_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK0_DATAOUT_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOUT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK0_DATAOUT bitfields
//

//--- Register HW_GPIOMON_BANK0_DATAOUT, field DATA

#define BP_GPIOMON_BANK0_DATAOUT_DATA      0
#define BM_GPIOMON_BANK0_DATAOUT_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK0_DATAOUT_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK0_DATAOUT_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK0_DATAOUT_DATA(v)   (HW_GPIOMON_BANK0_DATAOUT.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK1_DATAOUT - GPIO Monitor Bank1 DataOut Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank1_dataout_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK1_DATAOUT register
//

#define HW_GPIOMON_BANK1_DATAOUT_ADDR      (REGS_GPIOMON_BASE + 0x00000050)
#define HW_GPIOMON_BANK1_DATAOUT_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000054)
#define HW_GPIOMON_BANK1_DATAOUT_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000058)
#define HW_GPIOMON_BANK1_DATAOUT_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK1_DATAOUT           (*(volatile hw_gpiomon_bank1_dataout_t *) HW_GPIOMON_BANK1_DATAOUT_ADDR)
#define HW_GPIOMON_BANK1_DATAOUT_RD()      (HW_GPIOMON_BANK1_DATAOUT.U)
#define HW_GPIOMON_BANK1_DATAOUT_WR(v)     (HW_GPIOMON_BANK1_DATAOUT.U = (v))
#define HW_GPIOMON_BANK1_DATAOUT_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOUT_SET_ADDR) = (v))
#define HW_GPIOMON_BANK1_DATAOUT_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOUT_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK1_DATAOUT_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOUT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK1_DATAOUT bitfields
//

//--- Register HW_GPIOMON_BANK1_DATAOUT, field DATA

#define BP_GPIOMON_BANK1_DATAOUT_DATA      0
#define BM_GPIOMON_BANK1_DATAOUT_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK1_DATAOUT_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK1_DATAOUT_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK1_DATAOUT_DATA(v)   (HW_GPIOMON_BANK1_DATAOUT.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK2_DATAOUT - GPIO Monitor Bank2 DataOut Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank2_dataout_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK2_DATAOUT register
//

#define HW_GPIOMON_BANK2_DATAOUT_ADDR      (REGS_GPIOMON_BASE + 0x00000060)
#define HW_GPIOMON_BANK2_DATAOUT_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000064)
#define HW_GPIOMON_BANK2_DATAOUT_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000068)
#define HW_GPIOMON_BANK2_DATAOUT_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK2_DATAOUT           (*(volatile hw_gpiomon_bank2_dataout_t *) HW_GPIOMON_BANK2_DATAOUT_ADDR)
#define HW_GPIOMON_BANK2_DATAOUT_RD()      (HW_GPIOMON_BANK2_DATAOUT.U)
#define HW_GPIOMON_BANK2_DATAOUT_WR(v)     (HW_GPIOMON_BANK2_DATAOUT.U = (v))
#define HW_GPIOMON_BANK2_DATAOUT_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOUT_SET_ADDR) = (v))
#define HW_GPIOMON_BANK2_DATAOUT_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOUT_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK2_DATAOUT_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOUT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK2_DATAOUT bitfields
//

//--- Register HW_GPIOMON_BANK2_DATAOUT, field DATA

#define BP_GPIOMON_BANK2_DATAOUT_DATA      0
#define BM_GPIOMON_BANK2_DATAOUT_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK2_DATAOUT_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK2_DATAOUT_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK2_DATAOUT_DATA(v)   (HW_GPIOMON_BANK2_DATAOUT.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK3_DATAOUT - GPIO Monitor Bank3 DataOut Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_gpiomon_bank3_dataout_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK3_DATAOUT register
//

#define HW_GPIOMON_BANK3_DATAOUT_ADDR      (REGS_GPIOMON_BASE + 0x00000070)
#define HW_GPIOMON_BANK3_DATAOUT_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000074)
#define HW_GPIOMON_BANK3_DATAOUT_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000078)
#define HW_GPIOMON_BANK3_DATAOUT_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK3_DATAOUT           (*(volatile hw_gpiomon_bank3_dataout_t *) HW_GPIOMON_BANK3_DATAOUT_ADDR)
#define HW_GPIOMON_BANK3_DATAOUT_RD()      (HW_GPIOMON_BANK3_DATAOUT.U)
#define HW_GPIOMON_BANK3_DATAOUT_WR(v)     (HW_GPIOMON_BANK3_DATAOUT.U = (v))
#define HW_GPIOMON_BANK3_DATAOUT_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOUT_SET_ADDR) = (v))
#define HW_GPIOMON_BANK3_DATAOUT_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOUT_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK3_DATAOUT_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOUT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK3_DATAOUT bitfields
//

//--- Register HW_GPIOMON_BANK3_DATAOUT, field DATA

#define BP_GPIOMON_BANK3_DATAOUT_DATA      0
#define BM_GPIOMON_BANK3_DATAOUT_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK3_DATAOUT_DATA(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK3_DATAOUT_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK3_DATAOUT_DATA(v)   (HW_GPIOMON_BANK3_DATAOUT.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK0_DATAOEN - GPIO Monitor Bank0 DataOEN Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OUTPUT_ENABLES;
    } B;
} hw_gpiomon_bank0_dataoen_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK0_DATAOEN register
//

#define HW_GPIOMON_BANK0_DATAOEN_ADDR      (REGS_GPIOMON_BASE + 0x00000080)
#define HW_GPIOMON_BANK0_DATAOEN_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000084)
#define HW_GPIOMON_BANK0_DATAOEN_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000088)
#define HW_GPIOMON_BANK0_DATAOEN_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000008C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK0_DATAOEN           (*(volatile hw_gpiomon_bank0_dataoen_t *) HW_GPIOMON_BANK0_DATAOEN_ADDR)
#define HW_GPIOMON_BANK0_DATAOEN_RD()      (HW_GPIOMON_BANK0_DATAOEN.U)
#define HW_GPIOMON_BANK0_DATAOEN_WR(v)     (HW_GPIOMON_BANK0_DATAOEN.U = (v))
#define HW_GPIOMON_BANK0_DATAOEN_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOEN_SET_ADDR) = (v))
#define HW_GPIOMON_BANK0_DATAOEN_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOEN_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK0_DATAOEN_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK0_DATAOEN_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK0_DATAOEN bitfields
//

//--- Register HW_GPIOMON_BANK0_DATAOEN, field OUTPUT_ENABLES

#define BP_GPIOMON_BANK0_DATAOEN_OUTPUT_ENABLES      0
#define BM_GPIOMON_BANK0_DATAOEN_OUTPUT_ENABLES      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK0_DATAOEN_OUTPUT_ENABLES(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK0_DATAOEN_OUTPUT_ENABLES(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK0_DATAOEN_OUTPUT_ENABLES(v)   (HW_GPIOMON_BANK0_DATAOEN.B.OUTPUT_ENABLES = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK1_DATAOEN - GPIO Monitor Bank1 DataOEN Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OUTPUT_ENABLES;
    } B;
} hw_gpiomon_bank1_dataoen_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK1_DATAOEN register
//

#define HW_GPIOMON_BANK1_DATAOEN_ADDR      (REGS_GPIOMON_BASE + 0x00000090)
#define HW_GPIOMON_BANK1_DATAOEN_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000094)
#define HW_GPIOMON_BANK1_DATAOEN_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000098)
#define HW_GPIOMON_BANK1_DATAOEN_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000009C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK1_DATAOEN           (*(volatile hw_gpiomon_bank1_dataoen_t *) HW_GPIOMON_BANK1_DATAOEN_ADDR)
#define HW_GPIOMON_BANK1_DATAOEN_RD()      (HW_GPIOMON_BANK1_DATAOEN.U)
#define HW_GPIOMON_BANK1_DATAOEN_WR(v)     (HW_GPIOMON_BANK1_DATAOEN.U = (v))
#define HW_GPIOMON_BANK1_DATAOEN_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOEN_SET_ADDR) = (v))
#define HW_GPIOMON_BANK1_DATAOEN_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOEN_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK1_DATAOEN_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK1_DATAOEN_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK1_DATAOEN bitfields
//

//--- Register HW_GPIOMON_BANK1_DATAOEN, field OUTPUT_ENABLES

#define BP_GPIOMON_BANK1_DATAOEN_OUTPUT_ENABLES      0
#define BM_GPIOMON_BANK1_DATAOEN_OUTPUT_ENABLES      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK1_DATAOEN_OUTPUT_ENABLES(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK1_DATAOEN_OUTPUT_ENABLES(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK1_DATAOEN_OUTPUT_ENABLES(v)   (HW_GPIOMON_BANK1_DATAOEN.B.OUTPUT_ENABLES = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK2_DATAOEN - GPIO Monitor Bank2 DataOEN Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OUTPUT_ENABLES;
    } B;
} hw_gpiomon_bank2_dataoen_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK2_DATAOEN register
//

#define HW_GPIOMON_BANK2_DATAOEN_ADDR      (REGS_GPIOMON_BASE + 0x000000A0)
#define HW_GPIOMON_BANK2_DATAOEN_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000A4)
#define HW_GPIOMON_BANK2_DATAOEN_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000A8)
#define HW_GPIOMON_BANK2_DATAOEN_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000AC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK2_DATAOEN           (*(volatile hw_gpiomon_bank2_dataoen_t *) HW_GPIOMON_BANK2_DATAOEN_ADDR)
#define HW_GPIOMON_BANK2_DATAOEN_RD()      (HW_GPIOMON_BANK2_DATAOEN.U)
#define HW_GPIOMON_BANK2_DATAOEN_WR(v)     (HW_GPIOMON_BANK2_DATAOEN.U = (v))
#define HW_GPIOMON_BANK2_DATAOEN_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOEN_SET_ADDR) = (v))
#define HW_GPIOMON_BANK2_DATAOEN_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOEN_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK2_DATAOEN_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK2_DATAOEN_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK2_DATAOEN bitfields
//

//--- Register HW_GPIOMON_BANK2_DATAOEN, field OUTPUT_ENABLES

#define BP_GPIOMON_BANK2_DATAOEN_OUTPUT_ENABLES      0
#define BM_GPIOMON_BANK2_DATAOEN_OUTPUT_ENABLES      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK2_DATAOEN_OUTPUT_ENABLES(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK2_DATAOEN_OUTPUT_ENABLES(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK2_DATAOEN_OUTPUT_ENABLES(v)   (HW_GPIOMON_BANK2_DATAOEN.B.OUTPUT_ENABLES = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_BANK3_DATAOEN - GPIO Monitor Bank3 DataOEN Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OUTPUT_ENABLES;
    } B;
} hw_gpiomon_bank3_dataoen_t;
#endif


//
// constants & macros for entire HW_GPIOMON_BANK3_DATAOEN register
//

#define HW_GPIOMON_BANK3_DATAOEN_ADDR      (REGS_GPIOMON_BASE + 0x000000B0)
#define HW_GPIOMON_BANK3_DATAOEN_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000B4)
#define HW_GPIOMON_BANK3_DATAOEN_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000B8)
#define HW_GPIOMON_BANK3_DATAOEN_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_BANK3_DATAOEN           (*(volatile hw_gpiomon_bank3_dataoen_t *) HW_GPIOMON_BANK3_DATAOEN_ADDR)
#define HW_GPIOMON_BANK3_DATAOEN_RD()      (HW_GPIOMON_BANK3_DATAOEN.U)
#define HW_GPIOMON_BANK3_DATAOEN_WR(v)     (HW_GPIOMON_BANK3_DATAOEN.U = (v))
#define HW_GPIOMON_BANK3_DATAOEN_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOEN_SET_ADDR) = (v))
#define HW_GPIOMON_BANK3_DATAOEN_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOEN_CLR_ADDR) = (v))
#define HW_GPIOMON_BANK3_DATAOEN_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_BANK3_DATAOEN_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_BANK3_DATAOEN bitfields
//

//--- Register HW_GPIOMON_BANK3_DATAOEN, field OUTPUT_ENABLES

#define BP_GPIOMON_BANK3_DATAOEN_OUTPUT_ENABLES      0
#define BM_GPIOMON_BANK3_DATAOEN_OUTPUT_ENABLES      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_BANK3_DATAOEN_OUTPUT_ENABLES(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_BANK3_DATAOEN_OUTPUT_ENABLES(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_BANK3_DATAOEN_OUTPUT_ENABLES(v)   (HW_GPIOMON_BANK3_DATAOEN.B.OUTPUT_ENABLES = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_CTRL - GPIO Monitor Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OEN_NAND          :  1;
        unsigned OEN_4MA           :  1;
        unsigned OEN_8MA           :  1;
        unsigned PINMUX_ALT_RESET  :  1;
        unsigned RSRVD             : 28;
    } B;
} hw_gpiomon_ctrl_t;
#endif


//
// constants & macros for entire HW_GPIOMON_CTRL register
//

#define HW_GPIOMON_CTRL_ADDR      (REGS_GPIOMON_BASE + 0x000000C0)
#define HW_GPIOMON_CTRL_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000C4)
#define HW_GPIOMON_CTRL_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000C8)
#define HW_GPIOMON_CTRL_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000CC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_CTRL           (*(volatile hw_gpiomon_ctrl_t *) HW_GPIOMON_CTRL_ADDR)
#define HW_GPIOMON_CTRL_RD()      (HW_GPIOMON_CTRL.U)
#define HW_GPIOMON_CTRL_WR(v)     (HW_GPIOMON_CTRL.U = (v))
#define HW_GPIOMON_CTRL_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_CTRL_SET_ADDR) = (v))
#define HW_GPIOMON_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_CTRL_CLR_ADDR) = (v))
#define HW_GPIOMON_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_CTRL bitfields
//

//--- Register HW_GPIOMON_CTRL, field RSRVD

#define BP_GPIOMON_CTRL_RSRVD      4
#define BM_GPIOMON_CTRL_RSRVD      0xFFFFFFF0

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_CTRL_RSRVD(v)   ((((reg32_t) v) << 4) & BM_GPIOMON_CTRL_RSRVD)
#else
#define BF_GPIOMON_CTRL_RSRVD(v)   (((v) << 4) & BM_GPIOMON_CTRL_RSRVD)
#endif

//--- Register HW_GPIOMON_CTRL, field PINMUX_ALT_RESET

#define BP_GPIOMON_CTRL_PINMUX_ALT_RESET      3
#define BM_GPIOMON_CTRL_PINMUX_ALT_RESET      0x00000008

#define BF_GPIOMON_CTRL_PINMUX_ALT_RESET(v)   (((v) << 3) & BM_GPIOMON_CTRL_PINMUX_ALT_RESET)

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_CTRL_PINMUX_ALT_RESET(v)   BF_CS1(GPIOMON_CTRL, PINMUX_ALT_RESET, v)
#endif

//--- Register HW_GPIOMON_CTRL, field OEN_8MA

#define BP_GPIOMON_CTRL_OEN_8MA      2
#define BM_GPIOMON_CTRL_OEN_8MA      0x00000004

#define BF_GPIOMON_CTRL_OEN_8MA(v)   (((v) << 2) & BM_GPIOMON_CTRL_OEN_8MA)

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_CTRL_OEN_8MA(v)   BF_CS1(GPIOMON_CTRL, OEN_8MA, v)
#endif

//--- Register HW_GPIOMON_CTRL, field OEN_4MA

#define BP_GPIOMON_CTRL_OEN_4MA      1
#define BM_GPIOMON_CTRL_OEN_4MA      0x00000002

#define BF_GPIOMON_CTRL_OEN_4MA(v)   (((v) << 1) & BM_GPIOMON_CTRL_OEN_4MA)

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_CTRL_OEN_4MA(v)   BF_CS1(GPIOMON_CTRL, OEN_4MA, v)
#endif

//--- Register HW_GPIOMON_CTRL, field OEN_NAND

#define BP_GPIOMON_CTRL_OEN_NAND      0
#define BM_GPIOMON_CTRL_OEN_NAND      0x00000001

#define BF_GPIOMON_CTRL_OEN_NAND(v)   (((v) << 0) & BM_GPIOMON_CTRL_OEN_NAND)

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_CTRL_OEN_NAND(v)   BF_CS1(GPIOMON_CTRL, OEN_NAND, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT1_PINMUX_BANK0 - GPIO Alternate PinMux Bank0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt1_pinmux_bank0_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT1_PINMUX_BANK0 register
//

#define HW_GPIOMON_ALT1_PINMUX_BANK0_ADDR      (REGS_GPIOMON_BASE + 0x000000D0)
#define HW_GPIOMON_ALT1_PINMUX_BANK0_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000D4)
#define HW_GPIOMON_ALT1_PINMUX_BANK0_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000D8)
#define HW_GPIOMON_ALT1_PINMUX_BANK0_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000DC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT1_PINMUX_BANK0           (*(volatile hw_gpiomon_alt1_pinmux_bank0_t *) HW_GPIOMON_ALT1_PINMUX_BANK0_ADDR)
#define HW_GPIOMON_ALT1_PINMUX_BANK0_RD()      (HW_GPIOMON_ALT1_PINMUX_BANK0.U)
#define HW_GPIOMON_ALT1_PINMUX_BANK0_WR(v)     (HW_GPIOMON_ALT1_PINMUX_BANK0.U = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK0_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK0_SET_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK0_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK0_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK0_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT1_PINMUX_BANK0 bitfields
//

//--- Register HW_GPIOMON_ALT1_PINMUX_BANK0, field INDEX

#define BP_GPIOMON_ALT1_PINMUX_BANK0_INDEX      0
#define BM_GPIOMON_ALT1_PINMUX_BANK0_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT1_PINMUX_BANK0_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT1_PINMUX_BANK0_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT1_PINMUX_BANK0_INDEX(v)   (HW_GPIOMON_ALT1_PINMUX_BANK0.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT1_PINMUX_BANK1 - GPIO Alternate PinMux Bank1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt1_pinmux_bank1_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT1_PINMUX_BANK1 register
//

#define HW_GPIOMON_ALT1_PINMUX_BANK1_ADDR      (REGS_GPIOMON_BASE + 0x000000E0)
#define HW_GPIOMON_ALT1_PINMUX_BANK1_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000E4)
#define HW_GPIOMON_ALT1_PINMUX_BANK1_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000E8)
#define HW_GPIOMON_ALT1_PINMUX_BANK1_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000EC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT1_PINMUX_BANK1           (*(volatile hw_gpiomon_alt1_pinmux_bank1_t *) HW_GPIOMON_ALT1_PINMUX_BANK1_ADDR)
#define HW_GPIOMON_ALT1_PINMUX_BANK1_RD()      (HW_GPIOMON_ALT1_PINMUX_BANK1.U)
#define HW_GPIOMON_ALT1_PINMUX_BANK1_WR(v)     (HW_GPIOMON_ALT1_PINMUX_BANK1.U = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK1_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK1_SET_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK1_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK1_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK1_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT1_PINMUX_BANK1 bitfields
//

//--- Register HW_GPIOMON_ALT1_PINMUX_BANK1, field INDEX

#define BP_GPIOMON_ALT1_PINMUX_BANK1_INDEX      0
#define BM_GPIOMON_ALT1_PINMUX_BANK1_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT1_PINMUX_BANK1_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT1_PINMUX_BANK1_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT1_PINMUX_BANK1_INDEX(v)   (HW_GPIOMON_ALT1_PINMUX_BANK1.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT1_PINMUX_BANK2 - GPIO Alternate PinMux Bank2 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt1_pinmux_bank2_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT1_PINMUX_BANK2 register
//

#define HW_GPIOMON_ALT1_PINMUX_BANK2_ADDR      (REGS_GPIOMON_BASE + 0x000000F0)
#define HW_GPIOMON_ALT1_PINMUX_BANK2_SET_ADDR  (REGS_GPIOMON_BASE + 0x000000F4)
#define HW_GPIOMON_ALT1_PINMUX_BANK2_CLR_ADDR  (REGS_GPIOMON_BASE + 0x000000F8)
#define HW_GPIOMON_ALT1_PINMUX_BANK2_TOG_ADDR  (REGS_GPIOMON_BASE + 0x000000FC)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT1_PINMUX_BANK2           (*(volatile hw_gpiomon_alt1_pinmux_bank2_t *) HW_GPIOMON_ALT1_PINMUX_BANK2_ADDR)
#define HW_GPIOMON_ALT1_PINMUX_BANK2_RD()      (HW_GPIOMON_ALT1_PINMUX_BANK2.U)
#define HW_GPIOMON_ALT1_PINMUX_BANK2_WR(v)     (HW_GPIOMON_ALT1_PINMUX_BANK2.U = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK2_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK2_SET_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK2_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK2_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK2_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT1_PINMUX_BANK2 bitfields
//

//--- Register HW_GPIOMON_ALT1_PINMUX_BANK2, field INDEX

#define BP_GPIOMON_ALT1_PINMUX_BANK2_INDEX      0
#define BM_GPIOMON_ALT1_PINMUX_BANK2_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT1_PINMUX_BANK2_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT1_PINMUX_BANK2_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT1_PINMUX_BANK2_INDEX(v)   (HW_GPIOMON_ALT1_PINMUX_BANK2.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT1_PINMUX_BANK3 - GPIO Alternate PinMux Bank3 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt1_pinmux_bank3_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT1_PINMUX_BANK3 register
//

#define HW_GPIOMON_ALT1_PINMUX_BANK3_ADDR      (REGS_GPIOMON_BASE + 0x00000100)
#define HW_GPIOMON_ALT1_PINMUX_BANK3_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000104)
#define HW_GPIOMON_ALT1_PINMUX_BANK3_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000108)
#define HW_GPIOMON_ALT1_PINMUX_BANK3_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000010C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT1_PINMUX_BANK3           (*(volatile hw_gpiomon_alt1_pinmux_bank3_t *) HW_GPIOMON_ALT1_PINMUX_BANK3_ADDR)
#define HW_GPIOMON_ALT1_PINMUX_BANK3_RD()      (HW_GPIOMON_ALT1_PINMUX_BANK3.U)
#define HW_GPIOMON_ALT1_PINMUX_BANK3_WR(v)     (HW_GPIOMON_ALT1_PINMUX_BANK3.U = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK3_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK3_SET_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK3_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK3_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT1_PINMUX_BANK3_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT1_PINMUX_BANK3_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT1_PINMUX_BANK3 bitfields
//

//--- Register HW_GPIOMON_ALT1_PINMUX_BANK3, field INDEX

#define BP_GPIOMON_ALT1_PINMUX_BANK3_INDEX      0
#define BM_GPIOMON_ALT1_PINMUX_BANK3_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT1_PINMUX_BANK3_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT1_PINMUX_BANK3_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT1_PINMUX_BANK3_INDEX(v)   (HW_GPIOMON_ALT1_PINMUX_BANK3.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT2_PINMUX_BANK0 - GPIO Alternate PinMux Bank0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt2_pinmux_bank0_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT2_PINMUX_BANK0 register
//

#define HW_GPIOMON_ALT2_PINMUX_BANK0_ADDR      (REGS_GPIOMON_BASE + 0x00000110)
#define HW_GPIOMON_ALT2_PINMUX_BANK0_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000114)
#define HW_GPIOMON_ALT2_PINMUX_BANK0_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000118)
#define HW_GPIOMON_ALT2_PINMUX_BANK0_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000011C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT2_PINMUX_BANK0           (*(volatile hw_gpiomon_alt2_pinmux_bank0_t *) HW_GPIOMON_ALT2_PINMUX_BANK0_ADDR)
#define HW_GPIOMON_ALT2_PINMUX_BANK0_RD()      (HW_GPIOMON_ALT2_PINMUX_BANK0.U)
#define HW_GPIOMON_ALT2_PINMUX_BANK0_WR(v)     (HW_GPIOMON_ALT2_PINMUX_BANK0.U = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK0_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK0_SET_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK0_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK0_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK0_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT2_PINMUX_BANK0 bitfields
//

//--- Register HW_GPIOMON_ALT2_PINMUX_BANK0, field INDEX

#define BP_GPIOMON_ALT2_PINMUX_BANK0_INDEX      0
#define BM_GPIOMON_ALT2_PINMUX_BANK0_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT2_PINMUX_BANK0_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT2_PINMUX_BANK0_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT2_PINMUX_BANK0_INDEX(v)   (HW_GPIOMON_ALT2_PINMUX_BANK0.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT2_PINMUX_BANK1 - GPIO Alternate PinMux Bank1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt2_pinmux_bank1_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT2_PINMUX_BANK1 register
//

#define HW_GPIOMON_ALT2_PINMUX_BANK1_ADDR      (REGS_GPIOMON_BASE + 0x00000120)
#define HW_GPIOMON_ALT2_PINMUX_BANK1_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000124)
#define HW_GPIOMON_ALT2_PINMUX_BANK1_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000128)
#define HW_GPIOMON_ALT2_PINMUX_BANK1_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000012C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT2_PINMUX_BANK1           (*(volatile hw_gpiomon_alt2_pinmux_bank1_t *) HW_GPIOMON_ALT2_PINMUX_BANK1_ADDR)
#define HW_GPIOMON_ALT2_PINMUX_BANK1_RD()      (HW_GPIOMON_ALT2_PINMUX_BANK1.U)
#define HW_GPIOMON_ALT2_PINMUX_BANK1_WR(v)     (HW_GPIOMON_ALT2_PINMUX_BANK1.U = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK1_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK1_SET_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK1_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK1_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK1_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT2_PINMUX_BANK1 bitfields
//

//--- Register HW_GPIOMON_ALT2_PINMUX_BANK1, field INDEX

#define BP_GPIOMON_ALT2_PINMUX_BANK1_INDEX      0
#define BM_GPIOMON_ALT2_PINMUX_BANK1_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT2_PINMUX_BANK1_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT2_PINMUX_BANK1_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT2_PINMUX_BANK1_INDEX(v)   (HW_GPIOMON_ALT2_PINMUX_BANK1.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT2_PINMUX_BANK2 - GPIO Alternate PinMux Bank2 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt2_pinmux_bank2_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT2_PINMUX_BANK2 register
//

#define HW_GPIOMON_ALT2_PINMUX_BANK2_ADDR      (REGS_GPIOMON_BASE + 0x00000130)
#define HW_GPIOMON_ALT2_PINMUX_BANK2_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000134)
#define HW_GPIOMON_ALT2_PINMUX_BANK2_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000138)
#define HW_GPIOMON_ALT2_PINMUX_BANK2_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000013C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT2_PINMUX_BANK2           (*(volatile hw_gpiomon_alt2_pinmux_bank2_t *) HW_GPIOMON_ALT2_PINMUX_BANK2_ADDR)
#define HW_GPIOMON_ALT2_PINMUX_BANK2_RD()      (HW_GPIOMON_ALT2_PINMUX_BANK2.U)
#define HW_GPIOMON_ALT2_PINMUX_BANK2_WR(v)     (HW_GPIOMON_ALT2_PINMUX_BANK2.U = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK2_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK2_SET_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK2_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK2_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK2_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT2_PINMUX_BANK2 bitfields
//

//--- Register HW_GPIOMON_ALT2_PINMUX_BANK2, field INDEX

#define BP_GPIOMON_ALT2_PINMUX_BANK2_INDEX      0
#define BM_GPIOMON_ALT2_PINMUX_BANK2_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT2_PINMUX_BANK2_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT2_PINMUX_BANK2_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT2_PINMUX_BANK2_INDEX(v)   (HW_GPIOMON_ALT2_PINMUX_BANK2.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT2_PINMUX_BANK3 - GPIO Alternate PinMux Bank3 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt2_pinmux_bank3_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT2_PINMUX_BANK3 register
//

#define HW_GPIOMON_ALT2_PINMUX_BANK3_ADDR      (REGS_GPIOMON_BASE + 0x00000140)
#define HW_GPIOMON_ALT2_PINMUX_BANK3_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000144)
#define HW_GPIOMON_ALT2_PINMUX_BANK3_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000148)
#define HW_GPIOMON_ALT2_PINMUX_BANK3_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000014C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT2_PINMUX_BANK3           (*(volatile hw_gpiomon_alt2_pinmux_bank3_t *) HW_GPIOMON_ALT2_PINMUX_BANK3_ADDR)
#define HW_GPIOMON_ALT2_PINMUX_BANK3_RD()      (HW_GPIOMON_ALT2_PINMUX_BANK3.U)
#define HW_GPIOMON_ALT2_PINMUX_BANK3_WR(v)     (HW_GPIOMON_ALT2_PINMUX_BANK3.U = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK3_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK3_SET_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK3_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK3_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT2_PINMUX_BANK3_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT2_PINMUX_BANK3_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT2_PINMUX_BANK3 bitfields
//

//--- Register HW_GPIOMON_ALT2_PINMUX_BANK3, field INDEX

#define BP_GPIOMON_ALT2_PINMUX_BANK3_INDEX      0
#define BM_GPIOMON_ALT2_PINMUX_BANK3_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT2_PINMUX_BANK3_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT2_PINMUX_BANK3_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT2_PINMUX_BANK3_INDEX(v)   (HW_GPIOMON_ALT2_PINMUX_BANK3.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT3_PINMUX_BANK0 - GPIO Alternate PinMux Bank0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt3_pinmux_bank0_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT3_PINMUX_BANK0 register
//

#define HW_GPIOMON_ALT3_PINMUX_BANK0_ADDR      (REGS_GPIOMON_BASE + 0x00000150)
#define HW_GPIOMON_ALT3_PINMUX_BANK0_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000154)
#define HW_GPIOMON_ALT3_PINMUX_BANK0_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000158)
#define HW_GPIOMON_ALT3_PINMUX_BANK0_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000015C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT3_PINMUX_BANK0           (*(volatile hw_gpiomon_alt3_pinmux_bank0_t *) HW_GPIOMON_ALT3_PINMUX_BANK0_ADDR)
#define HW_GPIOMON_ALT3_PINMUX_BANK0_RD()      (HW_GPIOMON_ALT3_PINMUX_BANK0.U)
#define HW_GPIOMON_ALT3_PINMUX_BANK0_WR(v)     (HW_GPIOMON_ALT3_PINMUX_BANK0.U = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK0_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK0_SET_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK0_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK0_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK0_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT3_PINMUX_BANK0 bitfields
//

//--- Register HW_GPIOMON_ALT3_PINMUX_BANK0, field INDEX

#define BP_GPIOMON_ALT3_PINMUX_BANK0_INDEX      0
#define BM_GPIOMON_ALT3_PINMUX_BANK0_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT3_PINMUX_BANK0_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT3_PINMUX_BANK0_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT3_PINMUX_BANK0_INDEX(v)   (HW_GPIOMON_ALT3_PINMUX_BANK0.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT3_PINMUX_BANK1 - GPIO Alternate PinMux Bank1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt3_pinmux_bank1_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT3_PINMUX_BANK1 register
//

#define HW_GPIOMON_ALT3_PINMUX_BANK1_ADDR      (REGS_GPIOMON_BASE + 0x00000160)
#define HW_GPIOMON_ALT3_PINMUX_BANK1_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000164)
#define HW_GPIOMON_ALT3_PINMUX_BANK1_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000168)
#define HW_GPIOMON_ALT3_PINMUX_BANK1_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000016C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT3_PINMUX_BANK1           (*(volatile hw_gpiomon_alt3_pinmux_bank1_t *) HW_GPIOMON_ALT3_PINMUX_BANK1_ADDR)
#define HW_GPIOMON_ALT3_PINMUX_BANK1_RD()      (HW_GPIOMON_ALT3_PINMUX_BANK1.U)
#define HW_GPIOMON_ALT3_PINMUX_BANK1_WR(v)     (HW_GPIOMON_ALT3_PINMUX_BANK1.U = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK1_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK1_SET_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK1_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK1_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK1_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT3_PINMUX_BANK1 bitfields
//

//--- Register HW_GPIOMON_ALT3_PINMUX_BANK1, field INDEX

#define BP_GPIOMON_ALT3_PINMUX_BANK1_INDEX      0
#define BM_GPIOMON_ALT3_PINMUX_BANK1_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT3_PINMUX_BANK1_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT3_PINMUX_BANK1_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT3_PINMUX_BANK1_INDEX(v)   (HW_GPIOMON_ALT3_PINMUX_BANK1.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT3_PINMUX_BANK2 - GPIO Alternate PinMux Bank2 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt3_pinmux_bank2_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT3_PINMUX_BANK2 register
//

#define HW_GPIOMON_ALT3_PINMUX_BANK2_ADDR      (REGS_GPIOMON_BASE + 0x00000170)
#define HW_GPIOMON_ALT3_PINMUX_BANK2_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000174)
#define HW_GPIOMON_ALT3_PINMUX_BANK2_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000178)
#define HW_GPIOMON_ALT3_PINMUX_BANK2_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000017C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT3_PINMUX_BANK2           (*(volatile hw_gpiomon_alt3_pinmux_bank2_t *) HW_GPIOMON_ALT3_PINMUX_BANK2_ADDR)
#define HW_GPIOMON_ALT3_PINMUX_BANK2_RD()      (HW_GPIOMON_ALT3_PINMUX_BANK2.U)
#define HW_GPIOMON_ALT3_PINMUX_BANK2_WR(v)     (HW_GPIOMON_ALT3_PINMUX_BANK2.U = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK2_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK2_SET_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK2_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK2_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK2_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT3_PINMUX_BANK2 bitfields
//

//--- Register HW_GPIOMON_ALT3_PINMUX_BANK2, field INDEX

#define BP_GPIOMON_ALT3_PINMUX_BANK2_INDEX      0
#define BM_GPIOMON_ALT3_PINMUX_BANK2_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT3_PINMUX_BANK2_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT3_PINMUX_BANK2_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT3_PINMUX_BANK2_INDEX(v)   (HW_GPIOMON_ALT3_PINMUX_BANK2.B.INDEX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_GPIOMON_ALT3_PINMUX_BANK3 - GPIO Alternate PinMux Bank3 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  INDEX;
    } B;
} hw_gpiomon_alt3_pinmux_bank3_t;
#endif


//
// constants & macros for entire HW_GPIOMON_ALT3_PINMUX_BANK3 register
//

#define HW_GPIOMON_ALT3_PINMUX_BANK3_ADDR      (REGS_GPIOMON_BASE + 0x00000180)
#define HW_GPIOMON_ALT3_PINMUX_BANK3_SET_ADDR  (REGS_GPIOMON_BASE + 0x00000184)
#define HW_GPIOMON_ALT3_PINMUX_BANK3_CLR_ADDR  (REGS_GPIOMON_BASE + 0x00000188)
#define HW_GPIOMON_ALT3_PINMUX_BANK3_TOG_ADDR  (REGS_GPIOMON_BASE + 0x0000018C)

#ifndef __LANGUAGE_ASM__
#define HW_GPIOMON_ALT3_PINMUX_BANK3           (*(volatile hw_gpiomon_alt3_pinmux_bank3_t *) HW_GPIOMON_ALT3_PINMUX_BANK3_ADDR)
#define HW_GPIOMON_ALT3_PINMUX_BANK3_RD()      (HW_GPIOMON_ALT3_PINMUX_BANK3.U)
#define HW_GPIOMON_ALT3_PINMUX_BANK3_WR(v)     (HW_GPIOMON_ALT3_PINMUX_BANK3.U = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK3_SET(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK3_SET_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK3_CLR(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK3_CLR_ADDR) = (v))
#define HW_GPIOMON_ALT3_PINMUX_BANK3_TOG(v)    ((*(volatile reg32_t *) HW_GPIOMON_ALT3_PINMUX_BANK3_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_GPIOMON_ALT3_PINMUX_BANK3 bitfields
//

//--- Register HW_GPIOMON_ALT3_PINMUX_BANK3, field INDEX

#define BP_GPIOMON_ALT3_PINMUX_BANK3_INDEX      0
#define BM_GPIOMON_ALT3_PINMUX_BANK3_INDEX      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_GPIOMON_ALT3_PINMUX_BANK3_INDEX(v)   ((reg32_t) v)
#else
#define BF_GPIOMON_ALT3_PINMUX_BANK3_INDEX(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_GPIOMON_ALT3_PINMUX_BANK3_INDEX(v)   (HW_GPIOMON_ALT3_PINMUX_BANK3.B.INDEX = (v))
#endif


#endif // _REGSGPIOMON_H

////////////////////////////////////////////////////////////////////////////////
