/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 2.2
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _DCP_H
#define _DCP_H  1

#include "regs.h"

#ifndef REGS_DCP_BASE
#define REGS_DCP_BASE (REGS_BASE + 0x28000)
#endif

/*
 * HW_DCP_CTRL - DCP Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CHANNEL_INTERRUPT_ENABLE   :  8;
        unsigned RSVD_CSC_INTERRUPT_ENABLE  :  1;
        unsigned RSVD0                      : 12;
        unsigned ENABLE_CONTEXT_SWITCHING   :  1;
        unsigned ENABLE_CONTEXT_CACHING     :  1;
        unsigned GATHER_RESIDUAL_WRITES     :  1;
        unsigned RSVD1                      :  4;
        unsigned PRESENT_SHA                :  1;
        unsigned PRESENT_CRYPTO             :  1;
        unsigned CLKGATE                    :  1;
        unsigned SFTRST                     :  1;
    } B;
} hw_dcp_ctrl_t;
#endif

/*
 * constants & macros for entire HW_DCP_CTRL register
 */
#define HW_DCP_CTRL_ADDR         (REGS_DCP_BASE + 0x0)
#define HW_DCP_CTRL_SET_ADDR     (HW_DCP_CTRL_ADDR + 4)
#define HW_DCP_CTRL_CLR_ADDR     (HW_DCP_CTRL_ADDR + 8)
#define HW_DCP_CTRL_TOG_ADDR     (HW_DCP_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CTRL           (*(volatile hw_dcp_ctrl_t *) HW_DCP_CTRL_ADDR)
#define HW_DCP_CTRL_RD()      (HW_DCP_CTRL.U)
#define HW_DCP_CTRL_WR(v)     (HW_DCP_CTRL.U = (v))
#define HW_DCP_CTRL_SET(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_SET_ADDR) = (v))
#define HW_DCP_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_CLR_ADDR) = (v))
#define HW_DCP_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DCP_CTRL bitfields
 */
/* --- Register HW_DCP_CTRL, field SFTRST */

#define BP_DCP_CTRL_SFTRST      31
#define BM_DCP_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_DCP_CTRL_SFTRST)
#else
#define BF_DCP_CTRL_SFTRST(v)   (((v) << 31) & BM_DCP_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_SFTRST(v)   BF_CS1(DCP_CTRL, SFTRST, v)
#endif

/* --- Register HW_DCP_CTRL, field CLKGATE */

#define BP_DCP_CTRL_CLKGATE      30
#define BM_DCP_CTRL_CLKGATE      0x40000000

#define BF_DCP_CTRL_CLKGATE(v)   (((v) << 30) & BM_DCP_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_CLKGATE(v)   BF_CS1(DCP_CTRL, CLKGATE, v)
#endif

/* --- Register HW_DCP_CTRL, field PRESENT_CRYPTO */

#define BP_DCP_CTRL_PRESENT_CRYPTO      29
#define BM_DCP_CTRL_PRESENT_CRYPTO      0x20000000

#define BF_DCP_CTRL_PRESENT_CRYPTO(v)   (((v) << 29) & BM_DCP_CTRL_PRESENT_CRYPTO)
#define BV_DCP_CTRL_PRESENT_CRYPTO__Present  0x1
#define BV_DCP_CTRL_PRESENT_CRYPTO__Absent   0x0

/* --- Register HW_DCP_CTRL, field PRESENT_SHA */

#define BP_DCP_CTRL_PRESENT_SHA      28
#define BM_DCP_CTRL_PRESENT_SHA      0x10000000

#define BF_DCP_CTRL_PRESENT_SHA(v)   (((v) << 28) & BM_DCP_CTRL_PRESENT_SHA)
#define BV_DCP_CTRL_PRESENT_SHA__Present  0x1
#define BV_DCP_CTRL_PRESENT_SHA__Absent   0x0

/* --- Register HW_DCP_CTRL, field RSVD1 */

#define BP_DCP_CTRL_RSVD1      24
#define BM_DCP_CTRL_RSVD1      0x0F000000

#define BF_DCP_CTRL_RSVD1(v)   (((v) << 24) & BM_DCP_CTRL_RSVD1)
/* --- Register HW_DCP_CTRL, field GATHER_RESIDUAL_WRITES */

#define BP_DCP_CTRL_GATHER_RESIDUAL_WRITES      23
#define BM_DCP_CTRL_GATHER_RESIDUAL_WRITES      0x00800000

#define BF_DCP_CTRL_GATHER_RESIDUAL_WRITES(v)   (((v) << 23) & BM_DCP_CTRL_GATHER_RESIDUAL_WRITES)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_GATHER_RESIDUAL_WRITES(v)   BF_CS1(DCP_CTRL, GATHER_RESIDUAL_WRITES, v)
#endif

/* --- Register HW_DCP_CTRL, field ENABLE_CONTEXT_CACHING */

#define BP_DCP_CTRL_ENABLE_CONTEXT_CACHING      22
#define BM_DCP_CTRL_ENABLE_CONTEXT_CACHING      0x00400000

#define BF_DCP_CTRL_ENABLE_CONTEXT_CACHING(v)   (((v) << 22) & BM_DCP_CTRL_ENABLE_CONTEXT_CACHING)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_ENABLE_CONTEXT_CACHING(v)   BF_CS1(DCP_CTRL, ENABLE_CONTEXT_CACHING, v)
#endif

/* --- Register HW_DCP_CTRL, field ENABLE_CONTEXT_SWITCHING */

#define BP_DCP_CTRL_ENABLE_CONTEXT_SWITCHING      21
#define BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING      0x00200000

#define BF_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v)   (((v) << 21) & BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v)   BF_CS1(DCP_CTRL, ENABLE_CONTEXT_SWITCHING, v)
#endif

/* --- Register HW_DCP_CTRL, field RSVD0 */

#define BP_DCP_CTRL_RSVD0      9
#define BM_DCP_CTRL_RSVD0      0x001FFE00

#define BF_DCP_CTRL_RSVD0(v)   (((v) << 9) & BM_DCP_CTRL_RSVD0)
/* --- Register HW_DCP_CTRL, field RSVD_CSC_INTERRUPT_ENABLE */

#define BP_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE      8
#define BM_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE      0x00000100

#define BF_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE(v)   (((v) << 8) & BM_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE)
/* --- Register HW_DCP_CTRL, field CHANNEL_INTERRUPT_ENABLE */

#define BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE      0
#define BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE      0x000000FF

#define BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)   (((v) << 0) & BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)   (HW_DCP_CTRL.B.CHANNEL_INTERRUPT_ENABLE = (v))
#endif

#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH0  0x01
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH1  0x02
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH2  0x04
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH3  0x08



/*
 * HW_DCP_STAT - DCP Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQ             :  4;
        unsigned RSVD0           :  4;
        unsigned RSVD_IRQ        :  1;
        unsigned RSVD1           :  7;
        unsigned READY_CHANNELS  :  8;
        unsigned CUR_CHANNEL     :  4;
        unsigned OTP_KEY_READY   :  1;
        unsigned RSVD2           :  3;
    } B;
} hw_dcp_stat_t;
#endif

/*
 * constants & macros for entire HW_DCP_STAT register
 */
#define HW_DCP_STAT_ADDR         (REGS_DCP_BASE + 0x10)
#define HW_DCP_STAT_SET_ADDR     (HW_DCP_STAT_ADDR + 4)
#define HW_DCP_STAT_CLR_ADDR     (HW_DCP_STAT_ADDR + 8)
#define HW_DCP_STAT_TOG_ADDR     (HW_DCP_STAT_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_STAT           (*(volatile hw_dcp_stat_t *) HW_DCP_STAT_ADDR)
#define HW_DCP_STAT_RD()      (HW_DCP_STAT.U)
#define HW_DCP_STAT_WR(v)     (HW_DCP_STAT.U = (v))
#define HW_DCP_STAT_SET(v)    ((*(volatile reg32_t *) HW_DCP_STAT_SET_ADDR) = (v))
#define HW_DCP_STAT_CLR(v)    ((*(volatile reg32_t *) HW_DCP_STAT_CLR_ADDR) = (v))
#define HW_DCP_STAT_TOG(v)    ((*(volatile reg32_t *) HW_DCP_STAT_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DCP_STAT bitfields
 */
/* --- Register HW_DCP_STAT, field RSVD2 */

#define BP_DCP_STAT_RSVD2      29
#define BM_DCP_STAT_RSVD2      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_STAT_RSVD2(v)   ((((reg32_t) v) << 29) & BM_DCP_STAT_RSVD2)
#else
#define BF_DCP_STAT_RSVD2(v)   (((v) << 29) & BM_DCP_STAT_RSVD2)
#endif
/* --- Register HW_DCP_STAT, field OTP_KEY_READY */

#define BP_DCP_STAT_OTP_KEY_READY      28
#define BM_DCP_STAT_OTP_KEY_READY      0x10000000

#define BF_DCP_STAT_OTP_KEY_READY(v)   (((v) << 28) & BM_DCP_STAT_OTP_KEY_READY)
/* --- Register HW_DCP_STAT, field CUR_CHANNEL */

#define BP_DCP_STAT_CUR_CHANNEL      24
#define BM_DCP_STAT_CUR_CHANNEL      0x0F000000

#define BF_DCP_STAT_CUR_CHANNEL(v)   (((v) << 24) & BM_DCP_STAT_CUR_CHANNEL)
#define BV_DCP_STAT_CUR_CHANNEL__None  0x0
#define BV_DCP_STAT_CUR_CHANNEL__CH0   0x1
#define BV_DCP_STAT_CUR_CHANNEL__CH1   0x2
#define BV_DCP_STAT_CUR_CHANNEL__CH2   0x3
#define BV_DCP_STAT_CUR_CHANNEL__CH3   0x4

/* --- Register HW_DCP_STAT, field READY_CHANNELS */

#define BP_DCP_STAT_READY_CHANNELS      16
#define BM_DCP_STAT_READY_CHANNELS      0x00FF0000

#define BF_DCP_STAT_READY_CHANNELS(v)   (((v) << 16) & BM_DCP_STAT_READY_CHANNELS)
#define BV_DCP_STAT_READY_CHANNELS__CH0  0x01
#define BV_DCP_STAT_READY_CHANNELS__CH1  0x02
#define BV_DCP_STAT_READY_CHANNELS__CH2  0x04
#define BV_DCP_STAT_READY_CHANNELS__CH3  0x08

/* --- Register HW_DCP_STAT, field RSVD1 */

#define BP_DCP_STAT_RSVD1      9
#define BM_DCP_STAT_RSVD1      0x0000FE00

#define BF_DCP_STAT_RSVD1(v)   (((v) << 9) & BM_DCP_STAT_RSVD1)
/* --- Register HW_DCP_STAT, field RSVD_IRQ */

#define BP_DCP_STAT_RSVD_IRQ      8
#define BM_DCP_STAT_RSVD_IRQ      0x00000100

#define BF_DCP_STAT_RSVD_IRQ(v)   (((v) << 8) & BM_DCP_STAT_RSVD_IRQ)
/* --- Register HW_DCP_STAT, field RSVD0 */

#define BP_DCP_STAT_RSVD0      4
#define BM_DCP_STAT_RSVD0      0x000000F0

#define BF_DCP_STAT_RSVD0(v)   (((v) << 4) & BM_DCP_STAT_RSVD0)
/* --- Register HW_DCP_STAT, field IRQ */

#define BP_DCP_STAT_IRQ      0
#define BM_DCP_STAT_IRQ      0x0000000F

#define BF_DCP_STAT_IRQ(v)   (((v) << 0) & BM_DCP_STAT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_STAT_IRQ(v)   BF_CS1(DCP_STAT, IRQ, v)
#endif



/*
 * HW_DCP_CHANNELCTRL - DCP Channel Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE_CHANNEL         :  8;
        unsigned HIGH_PRIORITY_CHANNEL  :  8;
        unsigned CH0_IRQ_MERGED         :  1;
        unsigned RSVD                   : 15;
    } B;
} hw_dcp_channelctrl_t;
#endif

/*
 * constants & macros for entire HW_DCP_CHANNELCTRL register
 */
#define HW_DCP_CHANNELCTRL_ADDR         (REGS_DCP_BASE + 0x20)
#define HW_DCP_CHANNELCTRL_SET_ADDR     (HW_DCP_CHANNELCTRL_ADDR + 4)
#define HW_DCP_CHANNELCTRL_CLR_ADDR     (HW_DCP_CHANNELCTRL_ADDR + 8)
#define HW_DCP_CHANNELCTRL_TOG_ADDR     (HW_DCP_CHANNELCTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHANNELCTRL           (*(volatile hw_dcp_channelctrl_t *) HW_DCP_CHANNELCTRL_ADDR)
#define HW_DCP_CHANNELCTRL_RD()      (HW_DCP_CHANNELCTRL.U)
#define HW_DCP_CHANNELCTRL_WR(v)     (HW_DCP_CHANNELCTRL.U = (v))
#define HW_DCP_CHANNELCTRL_SET(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_SET_ADDR) = (v))
#define HW_DCP_CHANNELCTRL_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_CLR_ADDR) = (v))
#define HW_DCP_CHANNELCTRL_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DCP_CHANNELCTRL bitfields
 */
/* --- Register HW_DCP_CHANNELCTRL, field RSVD */

#define BP_DCP_CHANNELCTRL_RSVD      17
#define BM_DCP_CHANNELCTRL_RSVD      0xFFFE0000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHANNELCTRL_RSVD(v)   ((((reg32_t) v) << 17) & BM_DCP_CHANNELCTRL_RSVD)
#else
#define BF_DCP_CHANNELCTRL_RSVD(v)   (((v) << 17) & BM_DCP_CHANNELCTRL_RSVD)
#endif
/* --- Register HW_DCP_CHANNELCTRL, field CH0_IRQ_MERGED */

#define BP_DCP_CHANNELCTRL_CH0_IRQ_MERGED      16
#define BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED      0x00010000

#define BF_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v)   (((v) << 16) & BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v)   BF_CS1(DCP_CHANNELCTRL, CH0_IRQ_MERGED, v)
#endif

/* --- Register HW_DCP_CHANNELCTRL, field HIGH_PRIORITY_CHANNEL */

#define BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL      8
#define BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL      0x0000FF00

#define BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)   (((v) << 8) & BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)   (HW_DCP_CHANNELCTRL.B.HIGH_PRIORITY_CHANNEL = (v))
#endif

#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH0  0x01
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH1  0x02
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH2  0x04
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH3  0x08

/* --- Register HW_DCP_CHANNELCTRL, field ENABLE_CHANNEL */

#define BP_DCP_CHANNELCTRL_ENABLE_CHANNEL      0
#define BM_DCP_CHANNELCTRL_ENABLE_CHANNEL      0x000000FF

#define BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)   (((v) << 0) & BM_DCP_CHANNELCTRL_ENABLE_CHANNEL)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)   (HW_DCP_CHANNELCTRL.B.ENABLE_CHANNEL = (v))
#endif

#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH0  0x01
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH1  0x02
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH2  0x04
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH3  0x08



/*
 * HW_DCP_CAPABILITY0 - DCP Capability 0 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NUM_KEYS            :  8;
        unsigned NUM_CHANNELS        :  4;
        unsigned RSVD                : 17;
        unsigned DISABLE_UNIQUE_KEY  :  1;
        unsigned ENABLE_TZONE        :  1;
        unsigned DISABLE_DECRYPT     :  1;
    } B;
} hw_dcp_capability0_t;
#endif

/*
 * constants & macros for entire HW_DCP_CAPABILITY0 register
 */
#define HW_DCP_CAPABILITY0_ADDR         (REGS_DCP_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CAPABILITY0           (*(volatile hw_dcp_capability0_t *) HW_DCP_CAPABILITY0_ADDR)
#define HW_DCP_CAPABILITY0_RD()      (HW_DCP_CAPABILITY0.U)
#define HW_DCP_CAPABILITY0_WR(v)     (HW_DCP_CAPABILITY0.U = (v))
#define HW_DCP_CAPABILITY0_SET(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() |  (v)))
#define HW_DCP_CAPABILITY0_CLR(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() & ~(v)))
#define HW_DCP_CAPABILITY0_TOG(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_CAPABILITY0 bitfields
 */
/* --- Register HW_DCP_CAPABILITY0, field DISABLE_DECRYPT */

#define BP_DCP_CAPABILITY0_DISABLE_DECRYPT      31
#define BM_DCP_CAPABILITY0_DISABLE_DECRYPT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   ((((reg32_t) v) << 31) & BM_DCP_CAPABILITY0_DISABLE_DECRYPT)
#else
#define BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   (((v) << 31) & BM_DCP_CAPABILITY0_DISABLE_DECRYPT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   BF_CS1(DCP_CAPABILITY0, DISABLE_DECRYPT, v)
#endif

/* --- Register HW_DCP_CAPABILITY0, field ENABLE_TZONE */

#define BP_DCP_CAPABILITY0_ENABLE_TZONE      30
#define BM_DCP_CAPABILITY0_ENABLE_TZONE      0x40000000

#define BF_DCP_CAPABILITY0_ENABLE_TZONE(v)   (((v) << 30) & BM_DCP_CAPABILITY0_ENABLE_TZONE)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CAPABILITY0_ENABLE_TZONE(v)   BF_CS1(DCP_CAPABILITY0, ENABLE_TZONE, v)
#endif

/* --- Register HW_DCP_CAPABILITY0, field DISABLE_UNIQUE_KEY */

#define BP_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY      29
#define BM_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY      0x20000000

#define BF_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(v)   (((v) << 29) & BM_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(v)   BF_CS1(DCP_CAPABILITY0, DISABLE_UNIQUE_KEY, v)
#endif

/* --- Register HW_DCP_CAPABILITY0, field RSVD */

#define BP_DCP_CAPABILITY0_RSVD      12
#define BM_DCP_CAPABILITY0_RSVD      0x1FFFF000

#define BF_DCP_CAPABILITY0_RSVD(v)   (((v) << 12) & BM_DCP_CAPABILITY0_RSVD)
/* --- Register HW_DCP_CAPABILITY0, field NUM_CHANNELS */

#define BP_DCP_CAPABILITY0_NUM_CHANNELS      8
#define BM_DCP_CAPABILITY0_NUM_CHANNELS      0x00000F00

#define BF_DCP_CAPABILITY0_NUM_CHANNELS(v)   (((v) << 8) & BM_DCP_CAPABILITY0_NUM_CHANNELS)
/* --- Register HW_DCP_CAPABILITY0, field NUM_KEYS */

#define BP_DCP_CAPABILITY0_NUM_KEYS      0
#define BM_DCP_CAPABILITY0_NUM_KEYS      0x000000FF

#define BF_DCP_CAPABILITY0_NUM_KEYS(v)   (((v) << 0) & BM_DCP_CAPABILITY0_NUM_KEYS)


/*
 * HW_DCP_CAPABILITY1 - DCP Capability 1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CIPHER_ALGORITHMS  : 16;
        unsigned HASH_ALGORITHMS    : 16;
    } B;
} hw_dcp_capability1_t;
#endif

/*
 * constants & macros for entire HW_DCP_CAPABILITY1 register
 */
#define HW_DCP_CAPABILITY1_ADDR         (REGS_DCP_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CAPABILITY1           (*(volatile hw_dcp_capability1_t *) HW_DCP_CAPABILITY1_ADDR)
#define HW_DCP_CAPABILITY1_RD()      (HW_DCP_CAPABILITY1.U)
#endif


/*
 * constants & macros for individual HW_DCP_CAPABILITY1 bitfields
 */
/* --- Register HW_DCP_CAPABILITY1, field HASH_ALGORITHMS */

#define BP_DCP_CAPABILITY1_HASH_ALGORITHMS      16
#define BM_DCP_CAPABILITY1_HASH_ALGORITHMS      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v)   ((((reg32_t) v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#else
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v)   (((v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#endif
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA1    0x0001
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__CRC32   0x0002
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA256  0x0004

/* --- Register HW_DCP_CAPABILITY1, field CIPHER_ALGORITHMS */

#define BP_DCP_CAPABILITY1_CIPHER_ALGORITHMS      0
#define BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS      0x0000FFFF

#define BF_DCP_CAPABILITY1_CIPHER_ALGORITHMS(v)   (((v) << 0) & BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS)
#define BV_DCP_CAPABILITY1_CIPHER_ALGORITHMS__AES128  0x0001



/*
 * HW_DCP_CONTEXT - DCP Context Buffer Pointer
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_context_t;
#endif

/*
 * constants & macros for entire HW_DCP_CONTEXT register
 */
#define HW_DCP_CONTEXT_ADDR         (REGS_DCP_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CONTEXT           (*(volatile hw_dcp_context_t *) HW_DCP_CONTEXT_ADDR)
#define HW_DCP_CONTEXT_RD()      (HW_DCP_CONTEXT.U)
#define HW_DCP_CONTEXT_WR(v)     (HW_DCP_CONTEXT.U = (v))
#define HW_DCP_CONTEXT_SET(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() |  (v)))
#define HW_DCP_CONTEXT_CLR(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() & ~(v)))
#define HW_DCP_CONTEXT_TOG(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_CONTEXT bitfields
 */
/* --- Register HW_DCP_CONTEXT, field ADDR */

#define BP_DCP_CONTEXT_ADDR      0
#define BM_DCP_CONTEXT_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CONTEXT_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CONTEXT_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CONTEXT_ADDR(v)   (HW_DCP_CONTEXT.B.ADDR = (v))
#endif



/*
 * HW_DCP_KEY - DCP Key Index
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SUBWORD       :  2;
        unsigned RSVD_SUBWORD  :  2;
        unsigned INDEX         :  2;
        unsigned RSVD_INDEX    :  2;
        unsigned RSVD          : 24;
    } B;
} hw_dcp_key_t;
#endif

/*
 * constants & macros for entire HW_DCP_KEY register
 */
#define HW_DCP_KEY_ADDR         (REGS_DCP_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_KEY           (*(volatile hw_dcp_key_t *) HW_DCP_KEY_ADDR)
#define HW_DCP_KEY_RD()      (HW_DCP_KEY.U)
#define HW_DCP_KEY_WR(v)     (HW_DCP_KEY.U = (v))
#define HW_DCP_KEY_SET(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() |  (v)))
#define HW_DCP_KEY_CLR(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() & ~(v)))
#define HW_DCP_KEY_TOG(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_KEY bitfields
 */
/* --- Register HW_DCP_KEY, field RSVD */

#define BP_DCP_KEY_RSVD      8
#define BM_DCP_KEY_RSVD      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_DCP_KEY_RSVD(v)   ((((reg32_t) v) << 8) & BM_DCP_KEY_RSVD)
#else
#define BF_DCP_KEY_RSVD(v)   (((v) << 8) & BM_DCP_KEY_RSVD)
#endif
/* --- Register HW_DCP_KEY, field RSVD_INDEX */

#define BP_DCP_KEY_RSVD_INDEX      6
#define BM_DCP_KEY_RSVD_INDEX      0x000000C0

#define BF_DCP_KEY_RSVD_INDEX(v)   (((v) << 6) & BM_DCP_KEY_RSVD_INDEX)
/* --- Register HW_DCP_KEY, field INDEX */

#define BP_DCP_KEY_INDEX      4
#define BM_DCP_KEY_INDEX      0x00000030

#define BF_DCP_KEY_INDEX(v)   (((v) << 4) & BM_DCP_KEY_INDEX)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEY_INDEX(v)   BF_CS1(DCP_KEY, INDEX, v)
#endif

/* --- Register HW_DCP_KEY, field RSVD_SUBWORD */

#define BP_DCP_KEY_RSVD_SUBWORD      2
#define BM_DCP_KEY_RSVD_SUBWORD      0x0000000C

#define BF_DCP_KEY_RSVD_SUBWORD(v)   (((v) << 2) & BM_DCP_KEY_RSVD_SUBWORD)
/* --- Register HW_DCP_KEY, field SUBWORD */

#define BP_DCP_KEY_SUBWORD      0
#define BM_DCP_KEY_SUBWORD      0x00000003

#define BF_DCP_KEY_SUBWORD(v)   (((v) << 0) & BM_DCP_KEY_SUBWORD)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEY_SUBWORD(v)   BF_CS1(DCP_KEY, SUBWORD, v)
#endif



/*
 * HW_DCP_KEYDATA - DCP Key Data
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_dcp_keydata_t;
#endif

/*
 * constants & macros for entire HW_DCP_KEYDATA register
 */
#define HW_DCP_KEYDATA_ADDR         (REGS_DCP_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_KEYDATA           (*(volatile hw_dcp_keydata_t *) HW_DCP_KEYDATA_ADDR)
#define HW_DCP_KEYDATA_RD()      (HW_DCP_KEYDATA.U)
#define HW_DCP_KEYDATA_WR(v)     (HW_DCP_KEYDATA.U = (v))
#define HW_DCP_KEYDATA_SET(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() |  (v)))
#define HW_DCP_KEYDATA_CLR(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() & ~(v)))
#define HW_DCP_KEYDATA_TOG(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_KEYDATA bitfields
 */
/* --- Register HW_DCP_KEYDATA, field DATA */

#define BP_DCP_KEYDATA_DATA      0
#define BM_DCP_KEYDATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_KEYDATA_DATA(v)   ((reg32_t) v)
#else
#define BF_DCP_KEYDATA_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEYDATA_DATA(v)   (HW_DCP_KEYDATA.B.DATA = (v))
#endif



/*
 * HW_DCP_PACKET0 - DCP Work Packet 0 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_packet0_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET0 register
 */
#define HW_DCP_PACKET0_ADDR         (REGS_DCP_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET0           (*(volatile hw_dcp_packet0_t *) HW_DCP_PACKET0_ADDR)
#define HW_DCP_PACKET0_RD()      (HW_DCP_PACKET0.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET0 bitfields
 */
/* --- Register HW_DCP_PACKET0, field ADDR */

#define BP_DCP_PACKET0_ADDR      0
#define BM_DCP_PACKET0_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET0_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET0_ADDR(v)   (v)
#endif


/*
 * HW_DCP_PACKET1 - DCP Work Packet 1 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INTERRUPT         :  1;
        unsigned DECR_SEMAPHORE    :  1;
        unsigned CHAIN             :  1;
        unsigned CHAIN_CONTIGUOUS  :  1;
        unsigned ENABLE_MEMCOPY    :  1;
        unsigned ENABLE_CIPHER     :  1;
        unsigned ENABLE_HASH       :  1;
        unsigned ENABLE_BLIT       :  1;
        unsigned CIPHER_ENCRYPT    :  1;
        unsigned CIPHER_INIT       :  1;
        unsigned OTP_KEY           :  1;
        unsigned PAYLOAD_KEY       :  1;
        unsigned HASH_INIT         :  1;
        unsigned HASH_TERM         :  1;
        unsigned CHECK_HASH        :  1;
        unsigned HASH_OUTPUT       :  1;
        unsigned CONSTANT_FILL     :  1;
        unsigned TEST_SEMA_IRQ     :  1;
        unsigned KEY_BYTESWAP      :  1;
        unsigned KEY_WORDSWAP      :  1;
        unsigned INPUT_BYTESWAP    :  1;
        unsigned INPUT_WORDSWAP    :  1;
        unsigned OUTPUT_BYTESWAP   :  1;
        unsigned OUTPUT_WORDSWAP   :  1;
        unsigned TAG               :  8;
    } B;
} hw_dcp_packet1_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET1 register
 */
#define HW_DCP_PACKET1_ADDR         (REGS_DCP_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET1           (*(volatile hw_dcp_packet1_t *) HW_DCP_PACKET1_ADDR)
#define HW_DCP_PACKET1_RD()      (HW_DCP_PACKET1.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET1 bitfields
 */
/* --- Register HW_DCP_PACKET1, field TAG */

#define BP_DCP_PACKET1_TAG      24
#define BM_DCP_PACKET1_TAG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET1_TAG(v)   ((((reg32_t) v) << 24) & BM_DCP_PACKET1_TAG)
#else
#define BF_DCP_PACKET1_TAG(v)   (((v) << 24) & BM_DCP_PACKET1_TAG)
#endif
/* --- Register HW_DCP_PACKET1, field OUTPUT_WORDSWAP */

#define BP_DCP_PACKET1_OUTPUT_WORDSWAP      23
#define BM_DCP_PACKET1_OUTPUT_WORDSWAP      0x00800000

#define BF_DCP_PACKET1_OUTPUT_WORDSWAP(v)   (((v) << 23) & BM_DCP_PACKET1_OUTPUT_WORDSWAP)
/* --- Register HW_DCP_PACKET1, field OUTPUT_BYTESWAP */

#define BP_DCP_PACKET1_OUTPUT_BYTESWAP      22
#define BM_DCP_PACKET1_OUTPUT_BYTESWAP      0x00400000

#define BF_DCP_PACKET1_OUTPUT_BYTESWAP(v)   (((v) << 22) & BM_DCP_PACKET1_OUTPUT_BYTESWAP)
/* --- Register HW_DCP_PACKET1, field INPUT_WORDSWAP */

#define BP_DCP_PACKET1_INPUT_WORDSWAP      21
#define BM_DCP_PACKET1_INPUT_WORDSWAP      0x00200000

#define BF_DCP_PACKET1_INPUT_WORDSWAP(v)   (((v) << 21) & BM_DCP_PACKET1_INPUT_WORDSWAP)
/* --- Register HW_DCP_PACKET1, field INPUT_BYTESWAP */

#define BP_DCP_PACKET1_INPUT_BYTESWAP      20
#define BM_DCP_PACKET1_INPUT_BYTESWAP      0x00100000

#define BF_DCP_PACKET1_INPUT_BYTESWAP(v)   (((v) << 20) & BM_DCP_PACKET1_INPUT_BYTESWAP)
/* --- Register HW_DCP_PACKET1, field KEY_WORDSWAP */

#define BP_DCP_PACKET1_KEY_WORDSWAP      19
#define BM_DCP_PACKET1_KEY_WORDSWAP      0x00080000

#define BF_DCP_PACKET1_KEY_WORDSWAP(v)   (((v) << 19) & BM_DCP_PACKET1_KEY_WORDSWAP)
/* --- Register HW_DCP_PACKET1, field KEY_BYTESWAP */

#define BP_DCP_PACKET1_KEY_BYTESWAP      18
#define BM_DCP_PACKET1_KEY_BYTESWAP      0x00040000

#define BF_DCP_PACKET1_KEY_BYTESWAP(v)   (((v) << 18) & BM_DCP_PACKET1_KEY_BYTESWAP)
/* --- Register HW_DCP_PACKET1, field TEST_SEMA_IRQ */

#define BP_DCP_PACKET1_TEST_SEMA_IRQ      17
#define BM_DCP_PACKET1_TEST_SEMA_IRQ      0x00020000

#define BF_DCP_PACKET1_TEST_SEMA_IRQ(v)   (((v) << 17) & BM_DCP_PACKET1_TEST_SEMA_IRQ)
/* --- Register HW_DCP_PACKET1, field CONSTANT_FILL */

#define BP_DCP_PACKET1_CONSTANT_FILL      16
#define BM_DCP_PACKET1_CONSTANT_FILL      0x00010000

#define BF_DCP_PACKET1_CONSTANT_FILL(v)   (((v) << 16) & BM_DCP_PACKET1_CONSTANT_FILL)
/* --- Register HW_DCP_PACKET1, field HASH_OUTPUT */

#define BP_DCP_PACKET1_HASH_OUTPUT      15
#define BM_DCP_PACKET1_HASH_OUTPUT      0x00008000

#define BF_DCP_PACKET1_HASH_OUTPUT(v)   (((v) << 15) & BM_DCP_PACKET1_HASH_OUTPUT)
#define BV_DCP_PACKET1_HASH_OUTPUT__INPUT   0x00
#define BV_DCP_PACKET1_HASH_OUTPUT__OUTPUT  0x01

/* --- Register HW_DCP_PACKET1, field CHECK_HASH */

#define BP_DCP_PACKET1_CHECK_HASH      14
#define BM_DCP_PACKET1_CHECK_HASH      0x00004000

#define BF_DCP_PACKET1_CHECK_HASH(v)   (((v) << 14) & BM_DCP_PACKET1_CHECK_HASH)
/* --- Register HW_DCP_PACKET1, field HASH_TERM */

#define BP_DCP_PACKET1_HASH_TERM      13
#define BM_DCP_PACKET1_HASH_TERM      0x00002000

#define BF_DCP_PACKET1_HASH_TERM(v)   (((v) << 13) & BM_DCP_PACKET1_HASH_TERM)
/* --- Register HW_DCP_PACKET1, field HASH_INIT */

#define BP_DCP_PACKET1_HASH_INIT      12
#define BM_DCP_PACKET1_HASH_INIT      0x00001000

#define BF_DCP_PACKET1_HASH_INIT(v)   (((v) << 12) & BM_DCP_PACKET1_HASH_INIT)
/* --- Register HW_DCP_PACKET1, field PAYLOAD_KEY */

#define BP_DCP_PACKET1_PAYLOAD_KEY      11
#define BM_DCP_PACKET1_PAYLOAD_KEY      0x00000800

#define BF_DCP_PACKET1_PAYLOAD_KEY(v)   (((v) << 11) & BM_DCP_PACKET1_PAYLOAD_KEY)
/* --- Register HW_DCP_PACKET1, field OTP_KEY */

#define BP_DCP_PACKET1_OTP_KEY      10
#define BM_DCP_PACKET1_OTP_KEY      0x00000400

#define BF_DCP_PACKET1_OTP_KEY(v)   (((v) << 10) & BM_DCP_PACKET1_OTP_KEY)
/* --- Register HW_DCP_PACKET1, field CIPHER_INIT */

#define BP_DCP_PACKET1_CIPHER_INIT      9
#define BM_DCP_PACKET1_CIPHER_INIT      0x00000200

#define BF_DCP_PACKET1_CIPHER_INIT(v)   (((v) << 9) & BM_DCP_PACKET1_CIPHER_INIT)
/* --- Register HW_DCP_PACKET1, field CIPHER_ENCRYPT */

#define BP_DCP_PACKET1_CIPHER_ENCRYPT      8
#define BM_DCP_PACKET1_CIPHER_ENCRYPT      0x00000100

#define BF_DCP_PACKET1_CIPHER_ENCRYPT(v)   (((v) << 8) & BM_DCP_PACKET1_CIPHER_ENCRYPT)
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__ENCRYPT  0x01
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__DECRYPT  0x00

/* --- Register HW_DCP_PACKET1, field ENABLE_BLIT */

#define BP_DCP_PACKET1_ENABLE_BLIT      7
#define BM_DCP_PACKET1_ENABLE_BLIT      0x00000080

#define BF_DCP_PACKET1_ENABLE_BLIT(v)   (((v) << 7) & BM_DCP_PACKET1_ENABLE_BLIT)
/* --- Register HW_DCP_PACKET1, field ENABLE_HASH */

#define BP_DCP_PACKET1_ENABLE_HASH      6
#define BM_DCP_PACKET1_ENABLE_HASH      0x00000040

#define BF_DCP_PACKET1_ENABLE_HASH(v)   (((v) << 6) & BM_DCP_PACKET1_ENABLE_HASH)
/* --- Register HW_DCP_PACKET1, field ENABLE_CIPHER */

#define BP_DCP_PACKET1_ENABLE_CIPHER      5
#define BM_DCP_PACKET1_ENABLE_CIPHER      0x00000020

#define BF_DCP_PACKET1_ENABLE_CIPHER(v)   (((v) << 5) & BM_DCP_PACKET1_ENABLE_CIPHER)
/* --- Register HW_DCP_PACKET1, field ENABLE_MEMCOPY */

#define BP_DCP_PACKET1_ENABLE_MEMCOPY      4
#define BM_DCP_PACKET1_ENABLE_MEMCOPY      0x00000010

#define BF_DCP_PACKET1_ENABLE_MEMCOPY(v)   (((v) << 4) & BM_DCP_PACKET1_ENABLE_MEMCOPY)
/* --- Register HW_DCP_PACKET1, field CHAIN_CONTIGUOUS */

#define BP_DCP_PACKET1_CHAIN_CONTIGUOUS      3
#define BM_DCP_PACKET1_CHAIN_CONTIGUOUS      0x00000008

#define BF_DCP_PACKET1_CHAIN_CONTIGUOUS(v)   (((v) << 3) & BM_DCP_PACKET1_CHAIN_CONTIGUOUS)
/* --- Register HW_DCP_PACKET1, field CHAIN */

#define BP_DCP_PACKET1_CHAIN      2
#define BM_DCP_PACKET1_CHAIN      0x00000004

#define BF_DCP_PACKET1_CHAIN(v)   (((v) << 2) & BM_DCP_PACKET1_CHAIN)
/* --- Register HW_DCP_PACKET1, field DECR_SEMAPHORE */

#define BP_DCP_PACKET1_DECR_SEMAPHORE      1
#define BM_DCP_PACKET1_DECR_SEMAPHORE      0x00000002

#define BF_DCP_PACKET1_DECR_SEMAPHORE(v)   (((v) << 1) & BM_DCP_PACKET1_DECR_SEMAPHORE)
/* --- Register HW_DCP_PACKET1, field INTERRUPT */

#define BP_DCP_PACKET1_INTERRUPT      0
#define BM_DCP_PACKET1_INTERRUPT      0x00000001

#define BF_DCP_PACKET1_INTERRUPT(v)   (((v) << 0) & BM_DCP_PACKET1_INTERRUPT)


/*
 * HW_DCP_PACKET2 - DCP Work Packet 2 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CIPHER_SELECT  :  4;
        unsigned CIPHER_MODE    :  4;
        unsigned KEY_SELECT     :  8;
        unsigned HASH_SELECT    :  4;
        unsigned RSVD           :  4;
        unsigned CIPHER_CFG     :  8;
    } B;
} hw_dcp_packet2_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET2 register
 */
#define HW_DCP_PACKET2_ADDR         (REGS_DCP_BASE + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET2           (*(volatile hw_dcp_packet2_t *) HW_DCP_PACKET2_ADDR)
#define HW_DCP_PACKET2_RD()      (HW_DCP_PACKET2.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET2 bitfields
 */
/* --- Register HW_DCP_PACKET2, field CIPHER_CFG */

#define BP_DCP_PACKET2_CIPHER_CFG      24
#define BM_DCP_PACKET2_CIPHER_CFG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET2_CIPHER_CFG(v)   ((((reg32_t) v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#else
#define BF_DCP_PACKET2_CIPHER_CFG(v)   (((v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#endif
/* --- Register HW_DCP_PACKET2, field RSVD */

#define BP_DCP_PACKET2_RSVD      20
#define BM_DCP_PACKET2_RSVD      0x00F00000

#define BF_DCP_PACKET2_RSVD(v)   (((v) << 20) & BM_DCP_PACKET2_RSVD)
/* --- Register HW_DCP_PACKET2, field HASH_SELECT */

#define BP_DCP_PACKET2_HASH_SELECT      16
#define BM_DCP_PACKET2_HASH_SELECT      0x000F0000

#define BF_DCP_PACKET2_HASH_SELECT(v)   (((v) << 16) & BM_DCP_PACKET2_HASH_SELECT)
#define BV_DCP_PACKET2_HASH_SELECT__SHA1    0x00
#define BV_DCP_PACKET2_HASH_SELECT__CRC32   0x01
#define BV_DCP_PACKET2_HASH_SELECT__SHA256  0x02

/* --- Register HW_DCP_PACKET2, field KEY_SELECT */

#define BP_DCP_PACKET2_KEY_SELECT      8
#define BM_DCP_PACKET2_KEY_SELECT      0x0000FF00

#define BF_DCP_PACKET2_KEY_SELECT(v)   (((v) << 8) & BM_DCP_PACKET2_KEY_SELECT)
#define BV_DCP_PACKET2_KEY_SELECT__KEY0        0x00
#define BV_DCP_PACKET2_KEY_SELECT__KEY1        0x01
#define BV_DCP_PACKET2_KEY_SELECT__KEY2        0x02
#define BV_DCP_PACKET2_KEY_SELECT__KEY3        0x03
#define BV_DCP_PACKET2_KEY_SELECT__UNIQUE_KEY  0xFE
#define BV_DCP_PACKET2_KEY_SELECT__OTP_KEY     0xFF

/* --- Register HW_DCP_PACKET2, field CIPHER_MODE */

#define BP_DCP_PACKET2_CIPHER_MODE      4
#define BM_DCP_PACKET2_CIPHER_MODE      0x000000F0

#define BF_DCP_PACKET2_CIPHER_MODE(v)   (((v) << 4) & BM_DCP_PACKET2_CIPHER_MODE)
#define BV_DCP_PACKET2_CIPHER_MODE__ECB  0x00
#define BV_DCP_PACKET2_CIPHER_MODE__CBC  0x01

/* --- Register HW_DCP_PACKET2, field CIPHER_SELECT */

#define BP_DCP_PACKET2_CIPHER_SELECT      0
#define BM_DCP_PACKET2_CIPHER_SELECT      0x0000000F

#define BF_DCP_PACKET2_CIPHER_SELECT(v)   (((v) << 0) & BM_DCP_PACKET2_CIPHER_SELECT)
#define BV_DCP_PACKET2_CIPHER_SELECT__AES128  0x00



/*
 * HW_DCP_PACKET3 - DCP Work Packet 3 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_packet3_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET3 register
 */
#define HW_DCP_PACKET3_ADDR         (REGS_DCP_BASE + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET3           (*(volatile hw_dcp_packet3_t *) HW_DCP_PACKET3_ADDR)
#define HW_DCP_PACKET3_RD()      (HW_DCP_PACKET3.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET3 bitfields
 */
/* --- Register HW_DCP_PACKET3, field ADDR */

#define BP_DCP_PACKET3_ADDR      0
#define BM_DCP_PACKET3_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET3_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET3_ADDR(v)   (v)
#endif


/*
 * HW_DCP_PACKET4 - DCP Work Packet 4 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_packet4_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET4 register
 */
#define HW_DCP_PACKET4_ADDR         (REGS_DCP_BASE + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET4           (*(volatile hw_dcp_packet4_t *) HW_DCP_PACKET4_ADDR)
#define HW_DCP_PACKET4_RD()      (HW_DCP_PACKET4.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET4 bitfields
 */
/* --- Register HW_DCP_PACKET4, field ADDR */

#define BP_DCP_PACKET4_ADDR      0
#define BM_DCP_PACKET4_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET4_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET4_ADDR(v)   (v)
#endif


/*
 * HW_DCP_PACKET5 - DCP Work Packet 5 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_dcp_packet5_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET5 register
 */
#define HW_DCP_PACKET5_ADDR         (REGS_DCP_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET5           (*(volatile hw_dcp_packet5_t *) HW_DCP_PACKET5_ADDR)
#define HW_DCP_PACKET5_RD()      (HW_DCP_PACKET5.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET5 bitfields
 */
/* --- Register HW_DCP_PACKET5, field COUNT */

#define BP_DCP_PACKET5_COUNT      0
#define BM_DCP_PACKET5_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET5_COUNT(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET5_COUNT(v)   (v)
#endif


/*
 * HW_DCP_PACKET6 - DCP Work Packet 6 Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_packet6_t;
#endif

/*
 * constants & macros for entire HW_DCP_PACKET6 register
 */
#define HW_DCP_PACKET6_ADDR         (REGS_DCP_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET6           (*(volatile hw_dcp_packet6_t *) HW_DCP_PACKET6_ADDR)
#define HW_DCP_PACKET6_RD()      (HW_DCP_PACKET6.U)
#endif


/*
 * constants & macros for individual HW_DCP_PACKET6 bitfields
 */
/* --- Register HW_DCP_PACKET6, field ADDR */

#define BP_DCP_PACKET6_ADDR      0
#define BM_DCP_PACKET6_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET6_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET6_ADDR(v)   (v)
#endif


/*
 *  multi-register-define name HW_DCP_CHnCMDPTR
 *              base 0x00000100
 *              count 4
 *              offset 0x40
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_dcp_chncmdptr_t;
#endif

    /*
     * constants & macros for entire HW_DCP_CHnCMDPTR multi-register
     */
    #define HW_DCP_CHnCMDPTR_COUNT        4
    #define HW_DCP_CHnCMDPTR_ADDR(n)      (REGS_DCP_BASE + 0x100 + ((n) * 0x40))

    #ifndef __LANGUAGE_ASM__
    #define HW_DCP_CHnCMDPTR(n)           (*(volatile hw_dcp_chncmdptr_t *) HW_DCP_CHnCMDPTR_ADDR(n))
    #define HW_DCP_CHnCMDPTR_RD(n)        (HW_DCP_CHnCMDPTR(n).U)
    #define HW_DCP_CHnCMDPTR_WR(n, v)     (HW_DCP_CHnCMDPTR(n).U = (v))
    #define HW_DCP_CHnCMDPTR_SET(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) |  (v)))
    #define HW_DCP_CHnCMDPTR_CLR(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) & ~(v)))
    #define HW_DCP_CHnCMDPTR_TOG(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_DCP_CHnCMDPTR multi-register bitfields
 */
/* --- Register HW_DCP_CHnCMDPTR, field ADDR */

#define BP_DCP_CHnCMDPTR_ADDR      0
#define BM_DCP_CHnCMDPTR_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnCMDPTR_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CHnCMDPTR_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnCMDPTR_ADDR(n, v)  (HW_DCP_CHnCMDPTR(n).B.ADDR = (v))
#endif



/*
 *  multi-register-define name HW_DCP_CHnSEMA
 *              base 0x00000110
 *              count 4
 *              offset 0x40
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INCREMENT  :  8;
        unsigned RSVD1      :  8;
        unsigned VALUE      :  8;
        unsigned RSVD2      :  8;
    } B;
} hw_dcp_chnsema_t;
#endif

    /*
     * constants & macros for entire HW_DCP_CHnSEMA multi-register
     */
    #define HW_DCP_CHnSEMA_COUNT        4
    #define HW_DCP_CHnSEMA_ADDR(n)      (REGS_DCP_BASE + 0x110 + ((n) * 0x40))

    #ifndef __LANGUAGE_ASM__
    #define HW_DCP_CHnSEMA(n)           (*(volatile hw_dcp_chnsema_t *) HW_DCP_CHnSEMA_ADDR(n))
    #define HW_DCP_CHnSEMA_RD(n)        (HW_DCP_CHnSEMA(n).U)
    #define HW_DCP_CHnSEMA_WR(n, v)     (HW_DCP_CHnSEMA(n).U = (v))
    #define HW_DCP_CHnSEMA_SET(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) |  (v)))
    #define HW_DCP_CHnSEMA_CLR(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) & ~(v)))
    #define HW_DCP_CHnSEMA_TOG(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_DCP_CHnSEMA multi-register bitfields
 */
/* --- Register HW_DCP_CHnSEMA, field RSVD2 */

#define BP_DCP_CHnSEMA_RSVD2      24
#define BM_DCP_CHnSEMA_RSVD2      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnSEMA_RSVD2(v)   ((((reg32_t) v) << 24) & BM_DCP_CHnSEMA_RSVD2)
#else
#define BF_DCP_CHnSEMA_RSVD2(v)   (((v) << 24) & BM_DCP_CHnSEMA_RSVD2)
#endif
/* --- Register HW_DCP_CHnSEMA, field VALUE */

#define BP_DCP_CHnSEMA_VALUE      16
#define BM_DCP_CHnSEMA_VALUE      0x00FF0000

#define BF_DCP_CHnSEMA_VALUE(v)   (((v) << 16) & BM_DCP_CHnSEMA_VALUE)
/* --- Register HW_DCP_CHnSEMA, field RSVD1 */

#define BP_DCP_CHnSEMA_RSVD1      8
#define BM_DCP_CHnSEMA_RSVD1      0x0000FF00

#define BF_DCP_CHnSEMA_RSVD1(v)   (((v) << 8) & BM_DCP_CHnSEMA_RSVD1)
/* --- Register HW_DCP_CHnSEMA, field INCREMENT */

#define BP_DCP_CHnSEMA_INCREMENT      0
#define BM_DCP_CHnSEMA_INCREMENT      0x000000FF

#define BF_DCP_CHnSEMA_INCREMENT(v)   (((v) << 0) & BM_DCP_CHnSEMA_INCREMENT)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSEMA_INCREMENT(n, v)  (HW_DCP_CHnSEMA(n).B.INCREMENT = (v))
#endif



/*
 *  multi-register-define name HW_DCP_CHnSTAT
 *              base 0x00000120
 *              count 4
 *              offset 0x40
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD_COMPLETE    :  1;
        unsigned HASH_MISMATCH    :  1;
        unsigned ERROR_SETUP      :  1;
        unsigned ERROR_PACKET     :  1;
        unsigned ERROR_SRC        :  1;
        unsigned ERROR_DST        :  1;
        unsigned ERROR_PAGEFAULT  :  1;
        unsigned RSVD0            :  9;
        unsigned ERROR_CODE       :  8;
        unsigned TAG              :  8;
    } B;
} hw_dcp_chnstat_t;
#endif

    /*
     * constants & macros for entire HW_DCP_CHnSTAT multi-register
     */
    #define HW_DCP_CHnSTAT_COUNT        4
    #define HW_DCP_CHnSTAT_ADDR(n)      (REGS_DCP_BASE + 0x120 + ((n) * 0x40))
    #define HW_DCP_CHnSTAT_SET_ADDR(n)  (HW_DCP_CHnSTAT_ADDR(n) + 4)
    #define HW_DCP_CHnSTAT_CLR_ADDR(n)  (HW_DCP_CHnSTAT_ADDR(n) + 8)
    #define HW_DCP_CHnSTAT_TOG_ADDR(n)  (HW_DCP_CHnSTAT_ADDR(n) + 12)

    #ifndef __LANGUAGE_ASM__
    #define HW_DCP_CHnSTAT(n)           (*(volatile hw_dcp_chnstat_t *) HW_DCP_CHnSTAT_ADDR(n))
    #define HW_DCP_CHnSTAT_RD(n)        (HW_DCP_CHnSTAT(n).U)
    #define HW_DCP_CHnSTAT_WR(n, v)     (HW_DCP_CHnSTAT(n).U = (v))
    #define HW_DCP_CHnSTAT_SET(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_SET_ADDR(n)) = (v))
    #define HW_DCP_CHnSTAT_CLR(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_CLR_ADDR(n)) = (v))
    #define HW_DCP_CHnSTAT_TOG(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_TOG_ADDR(n)) = (v))
    #endif


/*
 * constants & macros for individual HW_DCP_CHnSTAT multi-register bitfields
 */
/* --- Register HW_DCP_CHnSTAT, field TAG */

#define BP_DCP_CHnSTAT_TAG      24
#define BM_DCP_CHnSTAT_TAG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnSTAT_TAG(v)   ((((reg32_t) v) << 24) & BM_DCP_CHnSTAT_TAG)
#else
#define BF_DCP_CHnSTAT_TAG(v)   (((v) << 24) & BM_DCP_CHnSTAT_TAG)
#endif
/* --- Register HW_DCP_CHnSTAT, field ERROR_CODE */

#define BP_DCP_CHnSTAT_ERROR_CODE      16
#define BM_DCP_CHnSTAT_ERROR_CODE      0x00FF0000

#define BF_DCP_CHnSTAT_ERROR_CODE(v)   (((v) << 16) & BM_DCP_CHnSTAT_ERROR_CODE)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_CODE(n, v)  (HW_DCP_CHnSTAT(n).B.ERROR_CODE = (v))
#endif

#define BV_DCP_CHnSTAT_ERROR_CODE__NEXT_CHAIN_IS_0  0x01
#define BV_DCP_CHnSTAT_ERROR_CODE__NO_CHAIN         0x02
#define BV_DCP_CHnSTAT_ERROR_CODE__CONTEXT_ERROR    0x03
#define BV_DCP_CHnSTAT_ERROR_CODE__PAYLOAD_ERROR    0x04
#define BV_DCP_CHnSTAT_ERROR_CODE__INVALID_MODE     0x05

/* --- Register HW_DCP_CHnSTAT, field RSVD0 */

#define BP_DCP_CHnSTAT_RSVD0      7
#define BM_DCP_CHnSTAT_RSVD0      0x0000FF80

#define BF_DCP_CHnSTAT_RSVD0(v)   (((v) << 7) & BM_DCP_CHnSTAT_RSVD0)
/* --- Register HW_DCP_CHnSTAT, field ERROR_PAGEFAULT */

#define BP_DCP_CHnSTAT_ERROR_PAGEFAULT      6
#define BM_DCP_CHnSTAT_ERROR_PAGEFAULT      0x00000040

#define BF_DCP_CHnSTAT_ERROR_PAGEFAULT(v)   (((v) << 6) & BM_DCP_CHnSTAT_ERROR_PAGEFAULT)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_PAGEFAULT(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_PAGEFAULT, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field ERROR_DST */

#define BP_DCP_CHnSTAT_ERROR_DST      5
#define BM_DCP_CHnSTAT_ERROR_DST      0x00000020

#define BF_DCP_CHnSTAT_ERROR_DST(v)   (((v) << 5) & BM_DCP_CHnSTAT_ERROR_DST)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_DST(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_DST, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field ERROR_SRC */

#define BP_DCP_CHnSTAT_ERROR_SRC      4
#define BM_DCP_CHnSTAT_ERROR_SRC      0x00000010

#define BF_DCP_CHnSTAT_ERROR_SRC(v)   (((v) << 4) & BM_DCP_CHnSTAT_ERROR_SRC)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_SRC(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_SRC, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field ERROR_PACKET */

#define BP_DCP_CHnSTAT_ERROR_PACKET      3
#define BM_DCP_CHnSTAT_ERROR_PACKET      0x00000008

#define BF_DCP_CHnSTAT_ERROR_PACKET(v)   (((v) << 3) & BM_DCP_CHnSTAT_ERROR_PACKET)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_PACKET(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_PACKET, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field ERROR_SETUP */

#define BP_DCP_CHnSTAT_ERROR_SETUP      2
#define BM_DCP_CHnSTAT_ERROR_SETUP      0x00000004

#define BF_DCP_CHnSTAT_ERROR_SETUP(v)   (((v) << 2) & BM_DCP_CHnSTAT_ERROR_SETUP)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_SETUP(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_SETUP, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field HASH_MISMATCH */

#define BP_DCP_CHnSTAT_HASH_MISMATCH      1
#define BM_DCP_CHnSTAT_HASH_MISMATCH      0x00000002

#define BF_DCP_CHnSTAT_HASH_MISMATCH(v)   (((v) << 1) & BM_DCP_CHnSTAT_HASH_MISMATCH)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_HASH_MISMATCH(n, v)  BF_CS1n(DCP_CHnSTAT, n, HASH_MISMATCH, v)
#endif

/* --- Register HW_DCP_CHnSTAT, field RSVD_COMPLETE */

#define BP_DCP_CHnSTAT_RSVD_COMPLETE      0
#define BM_DCP_CHnSTAT_RSVD_COMPLETE      0x00000001

#define BF_DCP_CHnSTAT_RSVD_COMPLETE(v)   (((v) << 0) & BM_DCP_CHnSTAT_RSVD_COMPLETE)


/*
 *  multi-register-define name HW_DCP_CHnOPTS
 *              base 0x00000130
 *              count 4
 *              offset 0x40
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RECOVERY_TIMER  : 16;
        unsigned RSVD            : 16;
    } B;
} hw_dcp_chnopts_t;
#endif

    /*
     * constants & macros for entire HW_DCP_CHnOPTS multi-register
     */
    #define HW_DCP_CHnOPTS_COUNT        4
    #define HW_DCP_CHnOPTS_ADDR(n)      (REGS_DCP_BASE + 0x130 + ((n) * 0x40))
    #define HW_DCP_CHnOPTS_SET_ADDR(n)  (HW_DCP_CHnOPTS_ADDR(n) + 4)
    #define HW_DCP_CHnOPTS_CLR_ADDR(n)  (HW_DCP_CHnOPTS_ADDR(n) + 8)
    #define HW_DCP_CHnOPTS_TOG_ADDR(n)  (HW_DCP_CHnOPTS_ADDR(n) + 12)

    #ifndef __LANGUAGE_ASM__
    #define HW_DCP_CHnOPTS(n)           (*(volatile hw_dcp_chnopts_t *) HW_DCP_CHnOPTS_ADDR(n))
    #define HW_DCP_CHnOPTS_RD(n)        (HW_DCP_CHnOPTS(n).U)
    #define HW_DCP_CHnOPTS_WR(n, v)     (HW_DCP_CHnOPTS(n).U = (v))
    #define HW_DCP_CHnOPTS_SET(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_SET_ADDR(n)) = (v))
    #define HW_DCP_CHnOPTS_CLR(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_CLR_ADDR(n)) = (v))
    #define HW_DCP_CHnOPTS_TOG(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_TOG_ADDR(n)) = (v))
    #endif


/*
 * constants & macros for individual HW_DCP_CHnOPTS multi-register bitfields
 */
/* --- Register HW_DCP_CHnOPTS, field RSVD */

#define BP_DCP_CHnOPTS_RSVD      16
#define BM_DCP_CHnOPTS_RSVD      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnOPTS_RSVD(v)   ((((reg32_t) v) << 16) & BM_DCP_CHnOPTS_RSVD)
#else
#define BF_DCP_CHnOPTS_RSVD(v)   (((v) << 16) & BM_DCP_CHnOPTS_RSVD)
#endif
/* --- Register HW_DCP_CHnOPTS, field RECOVERY_TIMER */

#define BP_DCP_CHnOPTS_RECOVERY_TIMER      0
#define BM_DCP_CHnOPTS_RECOVERY_TIMER      0x0000FFFF

#define BF_DCP_CHnOPTS_RECOVERY_TIMER(v)   (((v) << 0) & BM_DCP_CHnOPTS_RECOVERY_TIMER)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnOPTS_RECOVERY_TIMER(n, v)  (HW_DCP_CHnOPTS(n).B.RECOVERY_TIMER = (v))
#endif



/*
 * HW_DCP_DBGSELECT - DCP Debug Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INDEX  :  8;
        unsigned RSVD   : 24;
    } B;
} hw_dcp_dbgselect_t;
#endif

/*
 * constants & macros for entire HW_DCP_DBGSELECT register
 */
#define HW_DCP_DBGSELECT_ADDR         (REGS_DCP_BASE + 0x400)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_DBGSELECT           (*(volatile hw_dcp_dbgselect_t *) HW_DCP_DBGSELECT_ADDR)
#define HW_DCP_DBGSELECT_RD()      (HW_DCP_DBGSELECT.U)
#define HW_DCP_DBGSELECT_WR(v)     (HW_DCP_DBGSELECT.U = (v))
#define HW_DCP_DBGSELECT_SET(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() |  (v)))
#define HW_DCP_DBGSELECT_CLR(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() & ~(v)))
#define HW_DCP_DBGSELECT_TOG(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_DBGSELECT bitfields
 */
/* --- Register HW_DCP_DBGSELECT, field RSVD */

#define BP_DCP_DBGSELECT_RSVD      8
#define BM_DCP_DBGSELECT_RSVD      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_DCP_DBGSELECT_RSVD(v)   ((((reg32_t) v) << 8) & BM_DCP_DBGSELECT_RSVD)
#else
#define BF_DCP_DBGSELECT_RSVD(v)   (((v) << 8) & BM_DCP_DBGSELECT_RSVD)
#endif
/* --- Register HW_DCP_DBGSELECT, field INDEX */

#define BP_DCP_DBGSELECT_INDEX      0
#define BM_DCP_DBGSELECT_INDEX      0x000000FF

#define BF_DCP_DBGSELECT_INDEX(v)   (((v) << 0) & BM_DCP_DBGSELECT_INDEX)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_DBGSELECT_INDEX(v)   (HW_DCP_DBGSELECT.B.INDEX = (v))
#endif

#define BV_DCP_DBGSELECT_INDEX__CONTROL  0x01
#define BV_DCP_DBGSELECT_INDEX__OTPKEY0  0x10
#define BV_DCP_DBGSELECT_INDEX__OTPKEY1  0x11
#define BV_DCP_DBGSELECT_INDEX__OTPKEY2  0x12
#define BV_DCP_DBGSELECT_INDEX__OTPKEY3  0x13



/*
 * HW_DCP_DBGDATA - DCP Debug Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_dcp_dbgdata_t;
#endif

/*
 * constants & macros for entire HW_DCP_DBGDATA register
 */
#define HW_DCP_DBGDATA_ADDR         (REGS_DCP_BASE + 0x410)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_DBGDATA           (*(volatile hw_dcp_dbgdata_t *) HW_DCP_DBGDATA_ADDR)
#define HW_DCP_DBGDATA_RD()      (HW_DCP_DBGDATA.U)
#endif


/*
 * constants & macros for individual HW_DCP_DBGDATA bitfields
 */
/* --- Register HW_DCP_DBGDATA, field DATA */

#define BP_DCP_DBGDATA_DATA      0
#define BM_DCP_DBGDATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_DBGDATA_DATA(v)   ((reg32_t) v)
#else
#define BF_DCP_DBGDATA_DATA(v)   (v)
#endif


/*
 * HW_DCP_PAGETABLE - DCP Page Table Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE  :  1;
        unsigned FLUSH   :  1;
        unsigned BASE    : 30;
    } B;
} hw_dcp_pagetable_t;
#endif

/*
 * constants & macros for entire HW_DCP_PAGETABLE register
 */
#define HW_DCP_PAGETABLE_ADDR         (REGS_DCP_BASE + 0x420)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PAGETABLE           (*(volatile hw_dcp_pagetable_t *) HW_DCP_PAGETABLE_ADDR)
#define HW_DCP_PAGETABLE_RD()      (HW_DCP_PAGETABLE.U)
#define HW_DCP_PAGETABLE_WR(v)     (HW_DCP_PAGETABLE.U = (v))
#define HW_DCP_PAGETABLE_SET(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() |  (v)))
#define HW_DCP_PAGETABLE_CLR(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() & ~(v)))
#define HW_DCP_PAGETABLE_TOG(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DCP_PAGETABLE bitfields
 */
/* --- Register HW_DCP_PAGETABLE, field BASE */

#define BP_DCP_PAGETABLE_BASE      2
#define BM_DCP_PAGETABLE_BASE      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PAGETABLE_BASE(v)   ((((reg32_t) v) << 2) & BM_DCP_PAGETABLE_BASE)
#else
#define BF_DCP_PAGETABLE_BASE(v)   (((v) << 2) & BM_DCP_PAGETABLE_BASE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_BASE(v)   BF_CS1(DCP_PAGETABLE, BASE, v)
#endif

/* --- Register HW_DCP_PAGETABLE, field FLUSH */

#define BP_DCP_PAGETABLE_FLUSH      1
#define BM_DCP_PAGETABLE_FLUSH      0x00000002

#define BF_DCP_PAGETABLE_FLUSH(v)   (((v) << 1) & BM_DCP_PAGETABLE_FLUSH)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_FLUSH(v)   BF_CS1(DCP_PAGETABLE, FLUSH, v)
#endif

/* --- Register HW_DCP_PAGETABLE, field ENABLE */

#define BP_DCP_PAGETABLE_ENABLE      0
#define BM_DCP_PAGETABLE_ENABLE      0x00000001

#define BF_DCP_PAGETABLE_ENABLE(v)   (((v) << 0) & BM_DCP_PAGETABLE_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_ENABLE(v)   BF_CS1(DCP_PAGETABLE, ENABLE, v)
#endif



/*
 * HW_DCP_VERSION - DCP Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_dcp_version_t;
#endif

/*
 * constants & macros for entire HW_DCP_VERSION register
 */
#define HW_DCP_VERSION_ADDR         (REGS_DCP_BASE + 0x430)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_VERSION           (*(volatile hw_dcp_version_t *) HW_DCP_VERSION_ADDR)
#define HW_DCP_VERSION_RD()      (HW_DCP_VERSION.U)
#endif


/*
 * constants & macros for individual HW_DCP_VERSION bitfields
 */
/* --- Register HW_DCP_VERSION, field MAJOR */

#define BP_DCP_VERSION_MAJOR      24
#define BM_DCP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_DCP_VERSION_MAJOR)
#else
#define BF_DCP_VERSION_MAJOR(v)   (((v) << 24) & BM_DCP_VERSION_MAJOR)
#endif
/* --- Register HW_DCP_VERSION, field MINOR */

#define BP_DCP_VERSION_MINOR      16
#define BM_DCP_VERSION_MINOR      0x00FF0000

#define BF_DCP_VERSION_MINOR(v)   (((v) << 16) & BM_DCP_VERSION_MINOR)
/* --- Register HW_DCP_VERSION, field STEP */

#define BP_DCP_VERSION_STEP      0
#define BM_DCP_VERSION_STEP      0x0000FFFF

#define BF_DCP_VERSION_STEP(v)   (((v) << 0) & BM_DCP_VERSION_STEP)

#endif /* _DCP_H */

////////////////////////////////////////////////////////////////////////////////
