#define DEC_20 19
#define DEC_24 23
#define DEC_32 31

#define DEC(N) uECC_CONCAT(DEC_, N)

#define REPEAT_1(stuff) stuff
#define REPEAT_2(stuff) REPEAT_1(stuff) stuff
#define REPEAT_3(stuff) REPEAT_2(stuff) stuff
#define REPEAT_4(stuff) REPEAT_3(stuff) stuff
#define REPEAT_5(stuff) REPEAT_4(stuff) stuff
#define REPEAT_6(stuff) REPEAT_5(stuff) stuff
#define REPEAT_7(stuff) REPEAT_6(stuff) stuff
#define REPEAT_8(stuff) REPEAT_7(stuff) stuff
#define REPEAT_9(stuff) REPEAT_8(stuff) stuff
#define REPEAT_10(stuff) REPEAT_9(stuff) stuff
#define REPEAT_11(stuff) REPEAT_10(stuff) stuff
#define REPEAT_12(stuff) REPEAT_11(stuff) stuff
#define REPEAT_13(stuff) REPEAT_12(stuff) stuff
#define REPEAT_14(stuff) REPEAT_13(stuff) stuff
#define REPEAT_15(stuff) REPEAT_14(stuff) stuff
#define REPEAT_16(stuff) REPEAT_15(stuff) stuff
#define REPEAT_17(stuff) REPEAT_16(stuff) stuff
#define REPEAT_18(stuff) REPEAT_17(stuff) stuff
#define REPEAT_19(stuff) REPEAT_18(stuff) stuff
#define REPEAT_20(stuff) REPEAT_19(stuff) stuff
#define REPEAT_21(stuff) REPEAT_20(stuff) stuff
#define REPEAT_22(stuff) REPEAT_21(stuff) stuff
#define REPEAT_23(stuff) REPEAT_22(stuff) stuff
#define REPEAT_24(stuff) REPEAT_23(stuff) stuff
#define REPEAT_25(stuff) REPEAT_24(stuff) stuff
#define REPEAT_26(stuff) REPEAT_25(stuff) stuff
#define REPEAT_27(stuff) REPEAT_26(stuff) stuff
#define REPEAT_28(stuff) REPEAT_27(stuff) stuff
#define REPEAT_29(stuff) REPEAT_28(stuff) stuff
#define REPEAT_30(stuff) REPEAT_29(stuff) stuff
#define REPEAT_31(stuff) REPEAT_30(stuff) stuff
#define REPEAT_32(stuff) REPEAT_31(stuff) stuff

#define REPEAT(N, stuff) uECC_CONCAT(REPEAT_, N)(stuff)

#define STR2(thing) #thing
#define STR(thing) STR2(thing)

#if (uECC_ASM == uECC_asm_fast)

static void vli_clear(uint8_t *p_vli)
{
    __asm__ volatile (
        REPEAT(uECC_BYTES, "st %a[ptr]+, r1 \n\t")

        : [ptr] "+e" (p_vli)
        :
        : "r0", "cc", "memory"
    );
}
#define asm_clear 1

static void vli_set(uint8_t *p_dest, const uint8_t *p_src)
{
    __asm__ volatile (
        REPEAT(uECC_BYTES, "ld r0, %a[sptr]+ \n\t"
            "st %a[dptr]+, r0 \n\t")
        : [dptr] "+e" (p_dest), [sptr] "+e" (p_src)
        :
        : "r0", "cc", "memory"
    );
}
#define asm_set 1

static void vli_rshift1(uint8_t *p_vli)
{
    __asm__ volatile (
        "adiw r30, " STR(uECC_BYTES) " \n\t"
        "ld r0, -z \n\t"  /* Load byte. */
        "lsr r0 \n\t" /* Shift. */
        "st z, r0 \n\t"  /* Store the first result byte. */

        /* Now we just do the remaining bytes with the carry bit (using ROR) */
        REPEAT(DEC(uECC_BYTES), "ld r0, -z \n\t"
            "ror r0 \n\t"
            "st z, r0 \n\t")

        : "+z" (p_vli)
        :
        : "r0", "cc", "memory"
    );
}
#define asm_rshift1 1

/* Computes p_result = p_left + p_right, returning carry. Can modify in place. */
static uint8_t vli_add(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t l_carry = 0;
    uint8_t l_left;
    uint8_t l_right;

    __asm__ volatile (
        "ld %[left], x+ \n\t"  /* Load left byte. */
        "ld %[right], y+ \n\t" /* Load right byte. */
        "add %[left], %[right] \n\t" /* Add the first byte. */
        "st z+, %[left] \n\t"  /* Store the first result byte. */
        
        /* Now we just do the remaining bytes with the carry bit (using ADC) */
        REPEAT(DEC(uECC_BYTES), "ld %[left], x+ \n\t"
            "ld %[right], y+ \n\t"
            "adc %[left], %[right] \n\t"
            "st z+, %[left] \n\t")
        
        "adc %[carry], %[carry] \n\t"    /* Store carry bit in l_carry. */
        
        "sbiw r28, " STR(uECC_BYTES) " \n\t" /* Restore Y */

        : "+z" (p_result), "+x" (p_left),
            [carry] "+r" (l_carry), [left] "=&r" (l_left), [right] "=&r" (l_right)
        : "y" (p_right)
        : "cc", "memory"
    );
    return l_carry;
}
#define asm_add 1

/* Computes p_result = p_left - p_right, returning borrow. Can modify in place. */
static uint8_t vli_sub(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t l_borrow = 0;
    uint8_t l_left;
    uint8_t l_right;

    __asm__ volatile (
        "ld %[left], x+ \n\t"  /* Load left byte. */
        "ld %[right], y+ \n\t" /* Load right byte. */
        "sub %[left], %[right] \n\t" /* Subtract the first byte. */
        "st z+, %[left] \n\t"  /* Store the first result byte. */
        
        /* Now we just do the remaining bytes with the carry bit (using SBC) */
        REPEAT(DEC(uECC_BYTES), "ld %[left], x+ \n\t"
            "ld %[right], y+ \n\t"
            "sbc %[left], %[right] \n\t"
            "st z+, %[left] \n\t")
        
        "adc %[borrow], %[borrow] \n\t"    /* Store carry bit in l_borrow. */
        
        "sbiw r28, " STR(uECC_BYTES) " \n\t" /* Restore Y */

        : "+z" (p_result), "+x" (p_left),
            [borrow] "+r" (l_borrow), [left] "=&r" (l_left), [right] "=&r" (l_right)
        : "y" (p_right)
        : "cc", "memory"
    );
    return l_borrow;
}
#define asm_sub 1

#if (uECC_BYTES == 20)
__attribute((noinline))
static void vli_mult(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    __asm__ volatile (
        "adiw r30, 10 \n\t"
        "adiw r28, 10 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ld r16, y+ \n\t"
        "ld r17, y+ \n\t"
        "ld r18, y+ \n\t"
        "ld r19, y+ \n\t"
        "ld r20, y+ \n\t"
        "ld r21, y+ \n\t"
        "ldi r25, 0 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r24 \n\t"
        "st z+, r22 \n\t"

        "sbiw r30, 30 \n\t"
        "sbiw r28, 20 \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ld r16, y+ \n\t"
        "ld r17, y+ \n\t"
        "ld r18, y+ \n\t"
        "ld r19, y+ \n\t"
        "ld r20, y+ \n\t"
        "ld r21, y+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r5, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r6, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r7, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r8, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r9, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r10, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r11, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r12, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r13, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r14, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r15, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r16, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r17, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r18, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r19, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r20, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r21, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r24 \n\t"
        "eor r1, r1 \n\t"
        : "+x" (p_left), "+y" (p_right), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "cc", "memory"
    );
}
#define asm_mult 1
#elif (uECC_BYTES == 24)
__attribute((noinline))
static void vli_mult(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    __asm__ volatile (
        "adiw r30, 20 \n\t"
        "adiw r28, 20 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ldi r25, 0 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r24 \n\t"
        "st z+, r22 \n\t"

        "sbiw r30, 18 \n\t"
        "sbiw r28, 14 \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ld r16, y+ \n\t"
        "ld r17, y+ \n\t"
        "ld r18, y+ \n\t"
        "ld r19, y+ \n\t"
        "ld r20, y+ \n\t"
        "ld r21, y+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r5, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r12, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r13, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r14, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r15, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r24 \n\t"

        "sbiw r30, 38 \n\t"
        "sbiw r28, 24 \n\t"
        "sbiw r26, 14 \n\t"
        "ld r2, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r3, x+ \n\t"
        "ld r13, y+ \n\t"
        "ld r4, x+ \n\t"
        "ld r14, y+ \n\t"
        "ld r5, x+ \n\t"
        "ld r15, y+ \n\t"
        "ld r6, x+ \n\t"
        "ld r16, y+ \n\t"
        "ld r7, x+ \n\t"
        "ld r17, y+ \n\t"
        "ld r8, x+ \n\t"
        "ld r18, y+ \n\t"
        "ld r9, x+ \n\t"
        "ld r19, y+ \n\t"
        "ld r10, x+ \n\t"
        "ld r20, y+ \n\t"
        "ld r11, x+ \n\t"
        "ld r21, y+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r5, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r6, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r7, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r8, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r9, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r10, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r11, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r2, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r3, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r4, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r5, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r12, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r13, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r14, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r15, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r16, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r17, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r18, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r19, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r20, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r21, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r12, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r13, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r14, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r15, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "st z+, r23 \n\t"

        "eor r1, r1 \n\t"
        : "+x" (p_left), "+y" (p_right), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "cc", "memory"
    );
}
#define asm_mult 1
#elif (uECC_BYTES == 32)
__attribute((noinline))
static void vli_mult(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    __asm__ volatile (
        "adiw r30, 30 \n\t"
        "adiw r28, 30 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ldi r25, 0 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r24 \n\t"

        "sbiw r30, 14 \n\t"
        "sbiw r28, 12 \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ld r16, y+ \n\t"
        "ld r17, y+ \n\t"
        "ld r18, y+ \n\t"
        "ld r19, y+ \n\t"
        "ld r20, y+ \n\t"
        "ld r21, y+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r12, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r13, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "st z+, r23 \n\t"

        "sbiw r30, 34 \n\t"
        "sbiw r28, 22 \n\t"
        "sbiw r26, 12 \n\t"
        "ld r2, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r3, x+ \n\t"
        "ld r13, y+ \n\t"
        "ld r4, x+ \n\t"
        "ld r14, y+ \n\t"
        "ld r5, x+ \n\t"
        "ld r15, y+ \n\t"
        "ld r6, x+ \n\t"
        "ld r16, y+ \n\t"
        "ld r7, x+ \n\t"
        "ld r17, y+ \n\t"
        "ld r8, x+ \n\t"
        "ld r18, y+ \n\t"
        "ld r9, x+ \n\t"
        "ld r19, y+ \n\t"
        "ld r10, x+ \n\t"
        "ld r20, y+ \n\t"
        "ld r11, x+ \n\t"
        "ld r21, y+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r5, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r6, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r7, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r8, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r9, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r10, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r11, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r2, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r3, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r12, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r13, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r14, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r15, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r16, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r17, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r18, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r19, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r20, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r21, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r12, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r13, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r24 \n\t"
        "st z+, r22 \n\t"

        "sbiw r30, 54 \n\t"
        "sbiw r28, 32 \n\t"
        "sbiw r26, 22 \n\t"
        "ld r2, x+ \n\t"
        "ld r12, y+ \n\t"
        "ld r3, x+ \n\t"
        "ld r13, y+ \n\t"
        "ld r4, x+ \n\t"
        "ld r14, y+ \n\t"
        "ld r5, x+ \n\t"
        "ld r15, y+ \n\t"
        "ld r6, x+ \n\t"
        "ld r16, y+ \n\t"
        "ld r7, x+ \n\t"
        "ld r17, y+ \n\t"
        "ld r8, x+ \n\t"
        "ld r18, y+ \n\t"
        "ld r9, x+ \n\t"
        "ld r19, y+ \n\t"
        "ld r10, x+ \n\t"
        "ld r20, y+ \n\t"
        "ld r11, x+ \n\t"
        "ld r21, y+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r5, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r6, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r7, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r8, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r9, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r10, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r11, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r2, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r3, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r4, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r5, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r6, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r7, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r7, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r8, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r8, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r9, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r10, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r10, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r11, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r11, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r2, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r3, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r3, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r12, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r13, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r14, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r15, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r16, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r17, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r18, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r19, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r20, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r21, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r12, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r13, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r14, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r15, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r16, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r17, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r18, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r19, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r20, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r21, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r4, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "ld r0, z \n\t"
        "add r24, r0 \n\t"
        "adc r22, r25 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r12, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "ld r0, z \n\t"
        "add r22, r0 \n\t"
        "adc r23, r25 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r13, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r5, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r6, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r8, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r19 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r18 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r9, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r11, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r21 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r24 \n\t"

        "eor r1, r1 \n\t"
        : "+x" (p_left), "+y" (p_right), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "cc", "memory"
    );
}
#define asm_mult 1
#endif /* uECC_BYTES == 32 */

#if uECC_SQUARE_FUNC

#if (uECC_BYTES == 20)
static void vli_square(uint8_t *p_result, uint8_t *p_left)
{
    __asm__ volatile (
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"
        "ld r12, x+ \n\t"
        "ld r13, x+ \n\t"
        "ld r14, x+ \n\t"
        "ld r15, x+ \n\t"
        "ld r16, x+ \n\t"
        "ld r17, x+ \n\t"
        "ld r18, x+ \n\t"
        "ld r19, x+ \n\t"
        "ld r20, x+ \n\t"
        "ld r21, x+ \n\t"
        "ldi r27, 0 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r2 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r3 \n\t"
        "lsl r0 \n\t"
        "rol r1 \n\t"
        "adc r24, r27 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r27 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r4 \n\t"
        "lsl r0 \n\t"
        "rol r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r3, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r6 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r4, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r7 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r8 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r5, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r9 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r10 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r6, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r11 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r12 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r7, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r8, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r15 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r16 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r8, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r9, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r17 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r9, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r18 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r9, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r10, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r19 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r10, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r11, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r2, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r12, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r4, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r12, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r5, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r12, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r13, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r6, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r12, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r13, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r7, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r12, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r13, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r14, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r8, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r12, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r13, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r14, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r9, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r12, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r13, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r14, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r15, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r10, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r12, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r13, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r14, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r15, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r11, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r12, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r13, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r14, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r15, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r16, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r12, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r13, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r14, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r15, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r16, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r13, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r14, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r15, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r16, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r17, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r14, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r15, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r16, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r17, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r15, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r16, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "mul r17, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r18, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r16, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r17, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "mul r18, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r17, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r18, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r19, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r27 \n\t"
        "add r23, r25 \n\t"
        "adc r24, r26 \n\t"
        "adc r22, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r26, 0 \n\t"
        "mul r18, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r25, r1 \n\t"
        "mul r19, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "adc r26, r27 \n\t"
        "lsl r23 \n\t"
        "rol r25 \n\t"
        "rol r26 \n\t"
        "add r23, r24 \n\t"
        "adc r25, r22 \n\t"
        "adc r26, r27 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r19, r21 \n\t"
        "lsl r0 \n\t"
        "rol r1 \n\t"
        "adc r23, r27 \n\t"
        "add r25, r0 \n\t"
        "adc r26, r1 \n\t"
        "adc r23, r27 \n\t"
        "mul r20, r20 \n\t"
        "add r25, r0 \n\t"
        "adc r26, r1 \n\t"
        "adc r23, r27 \n\t"
        "st z+, r25 \n\t"

        "ldi r25, 0 \n\t"
        "mul r20, r21 \n\t"
        "lsl r0 \n\t"
        "rol r1 \n\t"
        "adc r25, r27 \n\t"
        "add r26, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r25, r27 \n\t"
        "st z+, r26 \n\t"

        "mul r21, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r25, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r25 \n\t"
        "eor r1, r1 \n\t"
        : "+x" (p_left), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "cc", "memory"
    );
}
#define asm_square 1

#elif (uECC_BYTES == 24)

__attribute((noinline))
static void vli_square(uint8_t *p_result, uint8_t *p_left)
{
    __asm__ volatile (
        "ldi r25, 0 \n\t"
        "movw r28, r26 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "adiw r28, 20 \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "adiw r30, 20 \n\t"
        
        "ldi r23, 0 \n\t"
        "mul 2, 12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"
        
        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"
        
        "ld r12, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ld r13, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"
        
        "ld r2, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r3, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"
        
        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "mul r3, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r24 \n\t"
        "st z+, r22 \n\t"
        
        "sbiw r26, 4 \n\t"
        "sbiw r30, 28 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"
        "ld r12, x+ \n\t"
        "ld r13, x+ \n\t"
        "ld r14, x+ \n\t"
        "ld r15, x+ \n\t"
        "ld r16, x+ \n\t"
        "ld r17, x+ \n\t"
        "ld r18, x+ \n\t"
        "ld r19, x+ \n\t"
        "ld r20, x+ \n\t"
        "ld r21, x+ \n\t"
        
        "ldi r23, 0 \n\t"
        "mul r2, r2 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"
        
        "ldi r24, 0 \n\t"
        "mul r2, r3 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r6 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r4, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r7 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r8 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r5, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r9 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r10 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r6, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r11 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r12 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r7, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r8, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r15 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r16 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r9, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r17 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r18 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r10, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r19 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r11, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ld r2, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r12, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r3, r2 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r2 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r13, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r4, r3 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r5, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ld r4, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r5, r3 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r6, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r14, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r5, r4 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r6, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ld r5, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r4 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r7, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r15, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r6, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r7, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r7, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r8, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r16, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r8, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r9, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r9, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r10, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r17, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r10, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r11, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r11, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r12, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r18, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r12, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r13, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r13, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r14, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r19, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r14, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r15, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r15, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r16, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r20, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r16, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r17, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r17, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r18, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r21, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r18, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r19, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r19, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r20, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r2, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r20, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r21, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r22, 0 \n\t"
        "mul r21, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r2, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r3, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r29, 0 \n\t"
        "mul r2, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"
        
        "ldi r23, 0 \n\t"
        "mul r3, r5 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r4 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r28 \n\t"
        
        "ldi r28, 0 \n\t"
        "mul r4, r5 \n\t"
        "add r29, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r28, r25 \n\t"
        "add r29, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r28, r25 \n\t"
        "st z+, r29 \n\t"
        
        "mul r5, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r28 \n\t"
        "eor r1, r1 \n\t"
        : "+x" (p_left), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r28", "r29", "cc", "memory"
    );
}
#define asm_square 1

#elif (uECC_BYTES == 32)

__attribute((noinline))
static void vli_square(uint8_t *p_result, uint8_t *p_left)
{
    __asm__ volatile (
        "ldi r25, 0 \n\t"
        "movw r28, r26 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "adiw r28, 20 \n\t"
        "ld r12, y+ \n\t"
        "ld r13, y+ \n\t"
        "ld r14, y+ \n\t"
        "ld r15, y+ \n\t"
        "ld r16, y+ \n\t"
        "ld r17, y+ \n\t"
        "adiw r30, 20 \n\t"

        "ldi r23, 0 \n\t"
        "mul 2, 12 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r12, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r13, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r14, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r15, y+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r16, y+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r17, y+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r2, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r12 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r3, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r13 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r4, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r5, x+ \n\t"
        "ldi r23, 0 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r2, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r3, r14 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ld r6, x+ \n\t"
        "ldi r24, 0 \n\t"
        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r2, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r3, r15 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ld r7, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r2, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r3, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "ldi r24, 0 \n\t"
        "mul r4, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r6, r17 \n\t"
        "add r24, r0 \n\t"
        "adc r22, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r24 \n\t"

        "mul r7, r17 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "st z+, r23 \n\t"

        "sbiw r26, 12 \n\t"
        "sbiw r30, 44 \n\t"
        "ld r2, x+ \n\t"
        "ld r3, x+ \n\t"
        "ld r4, x+ \n\t"
        "ld r5, x+ \n\t"
        "ld r6, x+ \n\t"
        "ld r7, x+ \n\t"
        "ld r8, x+ \n\t"
        "ld r9, x+ \n\t"
        "ld r10, x+ \n\t"
        "ld r11, x+ \n\t"
        "ld r12, x+ \n\t"
        "ld r13, x+ \n\t"
        "ld r14, x+ \n\t"
        "ld r15, x+ \n\t"
        "ld r16, x+ \n\t"
        "ld r17, x+ \n\t"
        "ld r18, x+ \n\t"
        "ld r19, x+ \n\t"
        "ld r20, x+ \n\t"
        "ld r21, x+ \n\t"

        "ldi r23, 0 \n\t"
        "mul r2, r2 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"

        "ldi r24, 0 \n\t"
        "mul r2, r3 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r24, r25 \n\t"
        "st z+, r22 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r6 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r4, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r7 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r8 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r5, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r9 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r10 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r6, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r11 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r12 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r7, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r14 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r8, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r15 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r16 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r9, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r17 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r18 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r10, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r19 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r2, r20 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r3, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r11, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r2, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r3, r21 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r4, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r12, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r3, r2 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r4, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r3, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r4, r2 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r5, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r13, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r4, r3 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r5, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r4, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r5, r3 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r6, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r14, r14 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r5, r4 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r6, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r5, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r6, r4 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r7, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r15, r15 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r6, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r7, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r6, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r7, r5 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r8, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r16, r16 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r7, r6 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r8, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r7, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r8, r6 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r9, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r10, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r17, r17 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r8, r7 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r9, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r8, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r9, r7 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r10, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r11, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r18, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r9, r8 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r10, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r11, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r9, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r10, r8 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r11, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r12, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r19, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r10, r9 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r11, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r12, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r10, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r11, r9 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r12, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r13, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r20, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r11, r10 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r12, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r13, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r11, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r12, r10 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r13, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r14, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r21, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r12, r11 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r13, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r14, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r12, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r13, r11 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r14, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r15, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r2, r2 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r13, r12 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r14, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r15, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ld r13, x+ \n\t"
        "ldi r22, 0 \n\t"
        "mul r14, r12 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r15, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r16, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r24, r25 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r3, r3 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r14, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r15, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r16, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r17, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r3, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "ld r0, z \n\t"
        "add r23, r0 \n\t"
        "adc r28, r25 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r15, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r16, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r17, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r18, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r4, r4 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r16, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r17, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r18, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r19, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r3, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r17, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r18, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r19, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r20, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r5, r5 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r18, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r19, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r20, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r21, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r3, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r19, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r20, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r21, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r2, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r6, r6 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r20, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r21, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r2, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r3, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r21, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r2, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r3, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r4, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r7, r7 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r2, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r3, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r4, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r5, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r3, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r4, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r5, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r6, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r8, r8 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r4, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r5, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r6, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r7, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r5, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r6, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r7, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r8, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r9, r9 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r6, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r7, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r8, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r9, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r7, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r8, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "mul r9, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r10, r10 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r8, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r9, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "mul r10, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r22, 0 \n\t"
        "mul r9, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r24, r1 \n\t"
        "mul r10, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "lsl r23 \n\t"
        "rol r24 \n\t"
        "rol r22 \n\t"
        "mul r11, r11 \n\t"
        "add r23, r0 \n\t"
        "adc r24, r1 \n\t"
        "adc r22, r25 \n\t"
        "add r23, r28 \n\t"
        "adc r24, r29 \n\t"
        "adc r22, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r29, 0 \n\t"
        "mul r10, r13 \n\t"
        "mov r23, r0 \n\t"
        "mov r28, r1 \n\t"
        "mul r11, r12 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "adc r29, r25 \n\t"
        "lsl r23 \n\t"
        "rol r28 \n\t"
        "rol r29 \n\t"
        "add r23, r24 \n\t"
        "adc r28, r22 \n\t"
        "adc r29, r25 \n\t"
        "st z+, r23 \n\t"

        "ldi r23, 0 \n\t"
        "mul r11, r13 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "mul r12, r12 \n\t"
        "add r28, r0 \n\t"
        "adc r29, r1 \n\t"
        "adc r23, r25 \n\t"
        "st z+, r28 \n\t"

        "ldi r28, 0 \n\t"
        "mul r12, r13 \n\t"
        "add r29, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r28, r25 \n\t"
        "add r29, r0 \n\t"
        "adc r23, r1 \n\t"
        "adc r28, r25 \n\t"
        "st z+, r29 \n\t"

        "mul r13, r13 \n\t"
        "add r23, r0 \n\t"
        "adc r28, r1 \n\t"
        "st z+, r23 \n\t"
        "st z+, r28 \n\t"
        "eor r1, r1 \n\t"
        : "+x" (p_left), "+z" (p_result)
        :
        : "r0", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12",
          "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r28", "r29", "cc", "memory"
    );
}
#define asm_square 1

#endif /* uECC_BYTES == xx */
#endif /* uECC_SQUARE_FUNC */

static void vli_modSub_fast(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t t1, t2;
    __asm__ volatile (
        "push r28 \n\t" /* Save Y */
        "push r29 \n\t"
        
        "ld %[t1], x+ \n\t"  /* Load left word. */
        "ld %[t2], y+ \n\t" /* Load right word. */
        "sub %[t1], %[t2] \n\t" /* Subtract the first word. */
        "st z+, %[t1] \n\t"  /* Store the first result word. */
        
        /* Now we just do the remaining words with the carry bit (using SBC) */
        REPEAT(DEC(uECC_BYTES), "ld %[t1], x+ \n\t"
            "ld %[t2], y+ \n\t"
            "sbc %[t1], %[t2] \n\t"
            "st z+, %[t1] \n\t")
        
        "brcs 1f \n\t" /* If borrow is set, then we need to add */
        "rjmp done \n\t" /* otherwise we are done */
        "1: \n\t"
        
        "sbiw r30, " STR(uECC_BYTES) " \n\t" /* make z point at p_result again */
        "ldi r28, lo8(curve_p) \n\t" /* make y point at curve_p */
    	"ldi r29, hi8(curve_p) \n\t"
    	
    	/* do the addition */
    	"ld %[t1], z \n\t"
        "ld %[t2], y+ \n\t"
        "add %[t1], %[t2] \n\t"
        "st z+, %[t1] \n\t"
        REPEAT(DEC(uECC_BYTES), "ld %[t1], z \n\t"
            "ld %[t2], y+ \n\t"
            "adc %[t1], %[t2] \n\t"
            "st z+, %[t1] \n\t")
        
        "done: \n\t"
        "pop r29 \n\t" /* Restore Y */
        "pop r28 \n\t"

        : "+z" (p_result), "+x" (p_left),
          [t1] "=&r" (t1), [t2] "=&r" (t2)
        : "y" (p_right)
        : "cc", "memory"
    );
}
#define asm_modSub_fast 1

#if uECC_CURVE == uECC_secp160r1
static void vli_mmod_fast(uint8_t *RESTRICT p_result, uint8_t *RESTRICT p_product)
{
    uint8_t l_carry = 0;
    __asm__ volatile (
        "in r30, __SP_L__ \n\t"
    	"in r31, __SP_H__ \n\t"
    	"sbiw r30, 24 \n\t"
    	"in r0, __SREG__ \n\t"
    	"cli \n\t"
    	"out __SP_H__, r31 \n\t"
    	"out __SREG__, r0 \n\t"
    	"out __SP_L__, r30 \n\t"
    	
    	"adiw r30, 25 \n\t" /* we are shifting by 31 bits, so shift over 4 bytes (+ 1 since z initially points below the stack) */
        "adiw r26, 40 \n\t" /* end of p_product */
        "ld r18, -x \n\t"  /* Load word. */
        "lsr r18 \n\t" /* Shift. */
        "st -z, r18 \n\t"  /* Store the first result word. */

        /* Now we just do the remaining words with the carry bit (using ROR) */
        REPEAT(19, "ld r18, -x \n\t"
            "ror r18 \n\t"
            "st -z, r18 \n\t")

        "eor r18, r18 \n\t" /* r18 = 0 */
        "ror r18 \n\t" /* get last bit */
        "st -z, r18 \n\t" /* store it */

        "sbiw r30, 3 \n\t" /* move z back to point at tmp */
        /* now we add p_right */
        "ld r18, x+ \n\t"
        "st z+, r18 \n\t" /* the first 3 bytes do not need to be added */
        "ld r18, x+ \n\t"
        "st z+, r18 \n\t"
        "ld r18, x+ \n\t"
        "st z+, r18 \n\t"

        "ld r18, x+ \n\t"
        "ld r19, z \n\t"
        "add r18, r19 \n\t"
        "st z+, r18 \n\t"

        /* Now we just do the remaining words with the carry bit (using ADC) */
        REPEAT(16, "ld r18, x+ \n\t"
            "ld r19, z \n\t"
            "adc r18, r19 \n\t"
            "st z+, r18 \n\t")

        /* Propagate over the remaining bytes of p_result */
        "ld r18, z \n\t"
        "adc r18, r1 \n\t"
        "st z+, r18 \n\t"

        "ld r18, z \n\t"
        "adc r18, r1 \n\t"
        "st z+, r18 \n\t"

        "ld r18, z \n\t"
        "adc r18, r1 \n\t"
        "st z+, r18 \n\t"

        "ld r18, z \n\t"
        "adc r18, r1 \n\t"
        "st z+, r18 \n\t"
        
        "sbiw r30, 24 \n\t" /* move z back to point at tmp */
        "sbiw r26, 40 \n\t" /* move x back to point at p_product */
        
        /* add low bytes of tmp to p_product, storing in p_result */
        "ld r18, z+ \n\t"
        "ld r19, x+ \n\t"
        "add r18, r19 \n\t"
        "st y+, r18 \n\t"
        REPEAT(19, "ld r18, z+ \n\t"
            "ld r19, x+ \n\t"
            "adc r18, r19 \n\t"
            "st y+, r18 \n\t")
        "adc %[carry], __zero_reg__ \n\t"    /* Store carry bit (carry flag is cleared). */
        /* at this point x is at the end of p_product, y is at the end of p_result, z is 20 bytes into tmp */
        "sbiw r28, 20 \n\t" /* move y back to point at p_result */
        "adiw r30, 4 \n\t" /* move z to point to the end of tmp */
        
        /* do omega_mult again with the 4 relevant bytes */
        /* z points to the end of tmp, x points to the end of p_product */
        "ld r18, -z \n\t"  /* Load word. */
        "lsr r18 \n\t" /* Shift. */
        "st -x, r18 \n\t"  /* Store the first result word. */
        
        "ld r18, -z \n\t"
        "ror r18 \n\t"
        "st -x, r18 \n\t"
        "ld r18, -z \n\t"
        "ror r18 \n\t"
        "st -x, r18 \n\t"
        "ld r18, -z \n\t"
        "ror r18 \n\t"
        "st -x, r18 \n\t"
        
        "eor r18, r18 \n\t" /* r18 = 0 */
        "ror r18 \n\t" /* get last bit */
        "st -x, r18 \n\t" /* store it */
        
        "sbiw r26, 3 \n\t" /* move x back to point at beginning */
        /* now we add a copy of the 4 bytes */
        "ld r18, z+ \n\t"
        "st x+, r18 \n\t" /* the first 3 bytes do not need to be added */
        "ld r18, z+ \n\t"
        "st x+, r18 \n\t"
        "ld r18, z+ \n\t"
        "st x+, r18 \n\t"
        
        "ld r18, z+ \n\t"
        "ld r19, x \n\t"
        "add r18, r19 \n\t"
        "st x+, r18 \n\t"
        
        /* Propagate over the remaining bytes */
        "ld r18, x \n\t"
        "adc r18, r1 \n\t"
        "st x+, r18 \n\t"
        
        "ld r18, x \n\t"
        "adc r18, r1 \n\t"
        "st x+, r18 \n\t"
        
        "ld r18, x \n\t"
        "adc r18, r1 \n\t"
        "st x+, r18 \n\t"
        
        "ld r18, x \n\t"
        "adc r18, r1 \n\t"
        "st x+, r18 \n\t"
        
        /* now z points to the end of tmp, x points to the end of p_product (y still points at p_result) */
        "sbiw r26, 8 \n\t" /* move x back to point at beginning of actual data */
        /* add into p_result */
        "ld r18, x+ \n\t"
        "ld r19, y \n\t"
        "add r18, r19 \n\t"
        "st y+, r18 \n\t"
        REPEAT(7, "ld r18, x+ \n\t"
            "ld r19, y \n\t"
            "adc r18, r19 \n\t"
            "st y+, r18 \n\t")
        
        /* Done adding, now propagate carry bit */
        REPEAT(12, "ld r18, y \n\t"
            "adc r18, __zero_reg__ \n\t"
            "st y+, r18 \n\t")
        
        "adc %[carry], __zero_reg__ \n\t"    /* Store carry bit (carry flag is cleared). */
        "sbiw r28, 20 \n\t" /* move y back to point at p_result */
        
        "sbiw r30, 1 \n\t" /* fix stack pointer */
    	"in r0, __SREG__ \n\t"
    	"cli \n\t"
    	"out __SP_H__, r31 \n\t"
    	"out __SREG__, r0 \n\t"
    	"out __SP_L__, r30 \n\t"
        
        : "+x" (p_product), [carry] "+r" (l_carry)
        : "y" (p_result)
        : "r0", "r18", "r19", "r30", "r31", "cc", "memory"
    );
    
    if(l_carry > 0)
    {
        --l_carry;
        vli_sub(p_result, p_result, curve_p);
    }
    if(l_carry > 0)
    {
        vli_sub(p_result, p_result, curve_p);
    }
    
    if(vli_cmp(p_result, curve_p) > 0)
    {
        vli_sub(p_result, p_result, curve_p);
    }
}
#define asm_mmod_fast 1

#elif (uECC_CURVE == uECC_secp256k1)
static void vli_mmod_fast(uint8_t *RESTRICT p_result, uint8_t *RESTRICT p_product)
{
    uint8_t l_carry = 0;
    __asm__ volatile (
        "in r30, __SP_L__ \n\t"
    	"in r31, __SP_H__ \n\t"
    	"sbiw r30, 37 \n\t"
    	"in r0, __SREG__ \n\t"
    	"cli \n\t"
    	"out __SP_H__, r31 \n\t"
    	"out __SREG__, r0 \n\t"
    	"out __SP_L__, r30 \n\t"
    	
    	"adiw r30, 1 \n\t" /* add 1 since z initially points below the stack */
        "adiw r26, 32 \n\t" /* p_product + uECC_WORDS */
        "ldi r25, 0x03 \n\t"
        "ldi r24, 0xD1 \n\t"
        "ld r18, x+ \n\t"
        "ld r19, x+ \n\t"
        "ld r20, x+ \n\t"
        "ld r21, x+ \n\t"
        
        "mul r24, r18 \n\t"
        "st z+, r0 \n\t"
        "mov r22, r1 \n\t"
        "ldi r23, 0 \n\t"
        
        "mul r24, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t" /* can't overflow */
        "mul r25, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t" /* can't overflow */
        "st z+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "mul r24, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "mul r25, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "mul r24, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r25, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        /* now we start adding the 2^32 part as well */
        "add r23, r18 \n\t" // 28
        "adc r22, r22 \n\t"
        "ld r18, x+ \n\t"
        "mul r24, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "mul r25, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "add r22, r19 \n\t" // 27
        "adc r23, r23 \n\t"
        "ld r19, x+ \n\t"
        "mul r24, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r25, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        REPEAT(6, // 26 - 3
            "add r23, r20 \n\t"
            "adc r22, r22 \n\t"
            "ld r20, x+ \n\t"
            "mul r24, r20 \n\t"
            "add r23, r0 \n\t"
            "adc r22, r1 \n\t"
            "mul r25, r19 \n\t"
            "add r23, r0 \n\t"
            "adc r22, r1 \n\t"
            "st z+, r23 \n\t"
            "ldi r23, 0 \n\t"
            
            "add r22, r21 \n\t"
            "adc r23, r23 \n\t"
            "ld r21, x+ \n\t"
            "mul r24, r21 \n\t"
            "add r22, r0 \n\t"
            "adc r23, r1 \n\t"
            "mul r25, r20 \n\t"
            "add r22, r0 \n\t"
            "adc r23, r1 \n\t"
            "st z+, r22 \n\t"
            "ldi r22, 0 \n\t"
            
            "add r23, r18 \n\t"
            "adc r22, r22 \n\t"
            "ld r18, x+ \n\t"
            "mul r24, r18 \n\t"
            "add r23, r0 \n\t"
            "adc r22, r1 \n\t"
            "mul r25, r21 \n\t"
            "add r23, r0 \n\t"
            "adc r22, r1 \n\t"
            "st z+, r23 \n\t"
            "ldi r23, 0 \n\t"
            
            "add r22, r19 \n\t"
            "adc r23, r23 \n\t"
            "ld r19, x+ \n\t"
            "mul r24, r19 \n\t"
            "add r22, r0 \n\t"
            "adc r23, r1 \n\t"
            "mul r25, r18 \n\t"
            "add r22, r0 \n\t"
            "adc r23, r1 \n\t"
            "st z+, r22 \n\t"
            "ldi r22, 0 \n\t")

        "add r23, r20 \n\t" // 2
        "adc r22, r22 \n\t"
        "ld r20, x+ \n\t"
        "mul r24, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "mul r25, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "add r22, r21 \n\t" // 1
        "adc r23, r23 \n\t"
        "ld r21, x+ \n\t"
        "mul r24, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r25, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st z+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        /* Now finish the carries etc */
        "add r23, r18 \n\t"
        "adc r22, r22 \n\t"
        "mul r25, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st z+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "add r22, r19 \n\t"
        "adc r23, r23 \n\t"
        "st z+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "add r23, r20 \n\t"
        "adc r22, r22 \n\t"
        "st z+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "add r22, r21 \n\t"
        "adc r23, r23 \n\t"
        "st z+, r22 \n\t"
        "st z+, r23 \n\t"
        "eor r1, r1 \n\t" /* make r1 be 0 again */
        
        "sbiw r30, 37 \n\t" /* move z back to point at tmp */
        "subi r26, 64 \n\t" /* move x back to point at p_product */
        "sbc r27, __zero_reg__ \n\t"
        
        /* add low bytes of tmp to p_product, storing in p_result */
        "ld r18, z+ \n\t"
        "ld r19, x+ \n\t"
        "add r18, r19 \n\t"
        "st y+, r18 \n\t"
        REPEAT(31, "ld r18, z+ \n\t"
            "ld r19, x+ \n\t"
            "adc r18, r19 \n\t"
            "st y+, r18 \n\t")
        
        "adc %[carry], __zero_reg__ \n\t"    /* Store carry bit (carry flag is cleared). */
        /* at this point x is at the end of p_product, y is at the end of p_result, z is 32 bytes into tmp */
        "sbiw r28, 32 \n\t" /* move y back to point at p_result */

        /* do omega_mult again with the 5 relevant bytes */
        /* z points to l_tmp + uECC_WORDS, x points to the end of p_product */
        "sbiw r26, 32 \n\t" /* shift x back to point into the p_product buffer (we can overwrite it now) */
        
        "ld r18, z+ \n\t"
        "ld r19, z+ \n\t"
        "ld r20, z+ \n\t"
        "ld r21, z+ \n\t"
        
        "mul r24, r18 \n\t"
        "st x+, r0 \n\t"
        "mov r22, r1 \n\t"
        "ldi r23, 0 \n\t"
        
        "mul r24, r19 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t" /* can't overflow */
        "mul r25, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t" /* can't overflow */
        "st x+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "mul r24, r20 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "mul r25, r19 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st x+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "mul r24, r21 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "mul r25, r20 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st x+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "add r23, r18 \n\t"
        "adc r22, r22 \n\t"
        "ld r18, z+ \n\t"
        "mul r24, r18 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "mul r25, r21 \n\t"
        "add r23, r0 \n\t"
        "adc r22, r1 \n\t"
        "st x+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        /* Now finish the carries etc */
        "add r22, r19 \n\t"
        "adc r23, r23 \n\t"
        "mul r25, r18 \n\t"
        "add r22, r0 \n\t"
        "adc r23, r1 \n\t"
        "st x+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "add r23, r20 \n\t"
        "adc r22, r22 \n\t"
        "st x+, r23 \n\t"
        "ldi r23, 0 \n\t"
        
        "add r22, r21 \n\t"
        "adc r23, r23 \n\t"
        "st x+, r22 \n\t"
        "ldi r22, 0 \n\t"
        
        "add r23, r18 \n\t"
        "adc r22, r22 \n\t"
        "st x+, r23 \n\t"
        "st x+, r22 \n\t"
        "eor r1, r1 \n\t" /* make r1 be 0 again */
        
        /* now z points to the end of tmp, x points to the end of p_product (y still points at p_result) */
        "sbiw r26, 10 \n\t" /* move x back to point at beginning of actual data */
        /* add into p_result */
        "ld r18, x+ \n\t"
        "ld r19, y \n\t"
        "add r18, r19 \n\t"
        "st y+, r18 \n\t"
        REPEAT(9, "ld r18, x+ \n\t"
            "ld r19, y \n\t"
            "adc r18, r19 \n\t"
            "st y+, r18 \n\t")
        
        /* Done adding, now propagate carry bit */
        REPEAT(22, "ld r18, y \n\t"
            "adc r18, __zero_reg__ \n\t"
            "st y+, r18 \n\t")
        
        "adc %[carry], __zero_reg__ \n\t"    /* Store carry bit (carry flag is cleared). */
        "sbiw r28, 32 \n\t" /* move y back to point at p_result */
        
        "sbiw r30, 1 \n\t" /* fix stack pointer */
    	"in r0, __SREG__ \n\t"
    	"cli \n\t"
    	"out __SP_H__, r31 \n\t"
    	"out __SREG__, r0 \n\t"
    	"out __SP_L__, r30 \n\t"
        
        : "+x" (p_product), [carry] "+r" (l_carry)
        : "y" (p_result)
        : "r0", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r30", "r31", "cc", "memory"
    );
    
    if(l_carry > 0)
    {
        --l_carry;
        vli_sub(p_result, p_result, curve_p);
    }
    if(l_carry > 0)
    {
        vli_sub(p_result, p_result, curve_p);
    }
    
    if(vli_cmp(p_result, curve_p) > 0)
    {
        vli_sub(p_result, p_result, curve_p);
    }
}
#define asm_mmod_fast 1

#endif /* (uECC_CURVE == uECC_secp256k1) */

#endif /* (uECC_ASM == uECC_asm_fast) */

#if !asm_rshift1
static void vli_rshift1(uint8_t *p_vli)
{
    uint8_t i = uECC_BYTES;
    __asm__ volatile (
        "adiw r30, " STR(uECC_BYTES) " \n\t"
        "clc \n\t"
        
        "1: \n\t"
        "ld r0, -z \n\t"
        "ror r0 \n\t"
        "st z, r0 \n\t"
        "dec %[i] \n\t"
        "brne 1b \n\t"

        : "+z" (p_vli), [i] "+r" (i)
        : 
        : "r0", "cc", "memory"
    );
}
#define asm_rshift1 1
#endif

#if !asm_add
static uint8_t vli_add(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t i = uECC_BYTES;
    uint8_t l_carry = 0;
    uint8_t l_left;
    uint8_t l_right;

    __asm__ volatile (
        "clc \n\t"
        
        "1: \n\t"
        "ld %[left], x+ \n\t"  /* Load left byte. */
        "ld %[right], y+ \n\t" /* Load right byte. */
        "adc %[left], %[right] \n\t" /* Add. */
        "st z+, %[left] \n\t"  /* Store the result. */
        "dec %[i] \n\t"
        "brne 1b \n\t"
        
        "adc %[carry], %[carry] \n\t"    /* Store carry bit in l_carry. */
        
        "sbiw r28, " STR(uECC_BYTES) " \n\t" /* Restore Y */

        : "+z" (p_result), "+x" (p_left), [i] "+r" (i),
            [carry] "+r" (l_carry), [left] "=&r" (l_left), [right] "=&r" (l_right)
        : "y" (p_right)
        : "cc", "memory"
    );
    return l_carry;
}
#define asm_add 1
#endif

#if !asm_sub
static uint8_t vli_sub(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t i = uECC_BYTES;
    uint8_t l_borrow = 0;
    uint8_t l_left;
    uint8_t l_right;

    __asm__ volatile (
        "clc \n\t"
        
        "1: \n\t"
        "ld %[left], x+ \n\t"  /* Load left byte. */
        "ld %[right], y+ \n\t" /* Load right byte. */
        "sbc %[left], %[right] \n\t" /* Subtract. */
        "st z+, %[left] \n\t"  /* Store the result. */
        "dec %[i] \n\t"
        "brne 1b \n\t"
        
        "adc %[borrow], %[borrow] \n\t"    /* Store carry bit in l_borrow. */
        
        "sbiw r28, " STR(uECC_BYTES) " \n\t" /* Restore Y */

        : "+z" (p_result), "+x" (p_left), [i] "+r" (i),
            [borrow] "+r" (l_borrow), [left] "=&r" (l_left), [right] "=&r" (l_right)
        : "y" (p_right)
        : "cc", "memory"
    );
    return l_borrow;
}
#define asm_sub 1
#endif

#if !asm_mult
__attribute((noinline))
static void vli_mult(uint8_t *p_result, uint8_t *p_left, uint8_t *p_right)
{
    uint8_t r0 = 0;
    uint8_t r1 = 0;
    uint8_t r2 = 0;
    
    uint8_t l_zero = 0;
    
    uint8_t k, i;
    
    __asm__ volatile (
        "ldi %[k], 1 \n\t" /* k = 1; k < uECC_BYTES; ++k */
        
        "1: \n\t"
        "ldi %[i], 0 \n\t"  /* i=0; i < k; ++i */
        
        "add r28, %[k] \n\t" /* pre-add right ptr */
        "adc r29, %[zero] \n\t"
        
        "2: \n\t"
        "ld r0, x+ \n\t"
        "ld r1, -y \n\t"
        "mul r0, r1 \n\t"
        
        "add %[r0], r0 \n\t"
        "adc %[r1], r1 \n\t"
        "adc %[r2], %[zero] \n\t"
        
        "inc %[i] \n\t"
        "cp %[i], %[k] \n\t"
        "brlo 2b \n\t" /* loop if i < k */
        
        "sub r26, %[k] \n\t" /* fix up left ptr */
        "sbc r27, %[zero] \n\t"
        
        "st z+, %[r0] \n\t"  /* Store the result. */
        "mov %[r0], %[r1] \n\t"
        "mov %[r1], %[r2] \n\t"
        "mov %[r2], %[zero] \n\t"
        
        "inc %[k] \n\t"
        "cpi %[k], " STR(uECC_BYTES) " \n\t"
        "brlo 1b \n\t" /* loop if k < uECC_BYTES */
        
        /* second half */
        "ldi %[k], " STR(uECC_BYTES) " \n\t" /* k = uECC_BYTES; k > 0; --k */
        "adiw r28, " STR(uECC_BYTES) " \n\t" /* move right ptr to point at the end of p_right */
        
        "1: \n\t"
        "ldi %[i], 0 \n\t" /* i=0; i < k; ++i */
        
        "2: \n\t"
        "ld r0, x+ \n\t"
        "ld r1, -y \n\t"
        "mul r0, r1 \n\t"
        
        "add %[r0], r0 \n\t"
        "adc %[r1], r1 \n\t"
        "adc %[r2], %[zero] \n\t"
        
        "inc %[i] \n\t"
        "cp %[i], %[k] \n\t"
        "brlo 2b \n\t" /* loop if i < k */
        
        "add r28, %[k] \n\t" /* fix up right ptr */
        "adc r29, %[zero] \n\t"
        
        "st z+, %[r0] \n\t"  /* Store the result. */
        "mov %[r0], %[r1] \n\t"
        "mov %[r1], %[r2] \n\t"
        "mov %[r2], %[zero] \n\t"
        
        "dec %[k] \n\t"
        "sub r26, %[k] \n\t" /* fix up left ptr (after k is decremented, so next time we start 1 higher) */
        "sbc r27, %[zero] \n\t"
        
        "cpi %[k], 0 \n\t"
        "brne 1b \n\t" /* loop if k > 0 */
        
        "st z+, %[r0] \n\t"  /* Store last result byte. */
        
        "eor r1, r1 \n\t" /* fix r1 to be 0 again */
        
        "sbiw r28, " STR(uECC_BYTES) " \n\t" /* Restore Y */
    
        : "+z" (p_result), "+x" (p_left),
          [r0] "+r" (r0), [r1] "+r" (r1), [r2] "+r" (r2), [zero] "+r" (l_zero),
          [k] "=&a" (k), [i] "=&a" (i)
        : "y" (p_right)
        : "r0", "cc", "memory"
    );
}
#define asm_mult 1
#endif

#if uECC_SQUARE_FUNC
#if !asm_square
static void vli_square(uint8_t *p_result, uint8_t *p_left)
{
    uint8_t r0 = 0;
    uint8_t r1 = 0;
    uint8_t r2 = 0;
    
    uint8_t l_zero = 0;
    
    uint8_t k;
    
    __asm__ volatile (
        "ldi %[k], 1 \n\t" /* k = 1; k < uECC_BYTES*2; ++k */
        
        "1: \n\t"
        
        "movw r26, %[orig] \n\t"  /* copy orig ptr to 'left' ptr */
        "movw r30, %[orig] \n\t"  /* copy orig ptr to 'right' ptr */
        "cpi %[k], " STR(uECC_BYTES) " \n\t"
        "brlo 2f \n\t"
        "breq 2f \n\t"
        
        /* when k > uECC_BYTES, we start from (k - uECC_BYTES) on the 'left' ptr */
        "add r26, %[k] \n\t"
        "adc r27, %[zero] \n\t"
        "subi r26, " STR(uECC_BYTES) " \n\t"
        "sbc r27, %[zero] \n\t"
        "adiw r30, " STR(uECC_BYTES) " \n\t" /* move right ptr to point at the end */
        "rjmp 3f \n\t"
        
        "2: \n\t" /* when k <= uECC_BYTES, we add k to the 'right' ptr */
        "add r30, %[k] \n\t" /* pre-add 'right' ptr */
        "adc r31, %[zero] \n\t"
        
        "3: \n\t"
        "ld r0, x+ \n\t"
        "cp r26, r30 \n\t" /* if left == right here, then we are done after this mult (and we don't need to double) */
        "breq 4f \n\t"
        "ld r1, -z \n\t"
        "mul r0, r1 \n\t"
        
        /* add twice since it costs the same as doubling */
        "add %[r0], r0 \n\t"
        "adc %[r1], r1 \n\t"
        "adc %[r2], %[zero] \n\t"
        "add %[r0], r0 \n\t"
        "adc %[r1], r1 \n\t"
        "adc %[r2], %[zero] \n\t"
        
        "cpse r26, r30 \n\t" /* if left == right here, then we are done */
        "rjmp 3b \n\t"
        "rjmp 5f \n\t" /* skip code for non-doubled mult */
        
        "4: \n\t"
        "ld r1, -z \n\t"
        "mul r0, r1 \n\t"
        "add %[r0], r0 \n\t"
        "adc %[r1], r1 \n\t"
        "adc %[r2], %[zero] \n\t"
        
        "5: \n\t"
        "movw r30, %[result] \n\t"  /* make z point to result */
        "st z+, %[r0] \n\t"  /* Store the result. */
        "movw %[result], r30 \n\t"  /* update result ptr*/
        "mov %[r0], %[r1] \n\t"
        "mov %[r1], %[r2] \n\t"
        "mov %[r2], %[zero] \n\t"
        
        "inc %[k] \n\t"
        "cpi %[k], %[max] \n\t"
        "brlo 1b \n\t" /* loop if k < uECC_BYTES */
        
        "movw r30, %[result] \n\t"  /* make z point to result */
        "st z+, %[r0] \n\t"  /* Store last result byte. */
        
        "eor r1, r1 \n\t" /* fix r1 to be 0 again */
    
        : [result] "+r" (p_result),
          [r0] "+r" (r0), [r1] "+r" (r1), [r2] "+r" (r2), [zero] "+r" (l_zero),
          [k] "=&a" (k)
        : [orig] "r" (p_left), [max] "M" (2*uECC_BYTES)
        : "r0", "r26", "r27", "r30", "r31", "cc", "memory"
    );
}
#define asm_square 1
#endif
#endif /* uECC_SQUARE_FUNC */
