/*   FILE: stack.vala -- A stack
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 04 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

public class Stack<T> : GLib.Object {
	private Gee.ArrayList<T> list;

	public Stack () {
		list = new Gee.ArrayList<T> ();
	}

	public size_t size () {
		return list.size;
	}

	public void push (T item) {
		list.add (item);
	}

	public T peek () {
		return list.get (list.size - 1);
	}

	public T pop () {
		T item = peek ();
		list.remove_at (list.size - 1);
		return item;
	}
}
