/* lcdringer.c generated by valac 0.32.1, the Vala compiler
 * generated from lcdringer.vala, do not modify */

/*   FILE: lcdringer.vala -- Receives XMPP messages and rings
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 20 September 2016
 *
 * Copyright (c) 2016 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <loudmouth/loudmouth.h>
#include <gst/gst.h>
#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RINGER_RESET_TYPE (ringer_reset_type_get_type ())

#define TYPE_LCD_RINGER (lcd_ringer_get_type ())
#define LCD_RINGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_RINGER, LCDRinger))
#define LCD_RINGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_RINGER, LCDRingerClass))
#define IS_LCD_RINGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_RINGER))
#define IS_LCD_RINGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_RINGER))
#define LCD_RINGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_RINGER, LCDRingerClass))

typedef struct _LCDRinger LCDRinger;
typedef struct _LCDRingerClass LCDRingerClass;
typedef struct _LCDRingerPrivate LCDRingerPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _lm_connection_unref0(var) ((var == NULL) ? NULL : (var = (lm_connection_unref (var), NULL)))
#define _lm_message_handler_unref0(var) ((var == NULL) ? NULL : (var = (lm_message_handler_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _lm_message_unref0(var) ((var == NULL) ? NULL : (var = (lm_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _ParamSpecLCDRinger ParamSpecLCDRinger;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _lcd_ringer_unref0(var) ((var == NULL) ? NULL : (var = (lcd_ringer_unref (var), NULL)))

typedef enum  {
	RINGER_RESET_TYPE_TIMEOUT,
	RINGER_RESET_TYPE_ACKNOWLEDGED
} RingerResetType;

struct _LCDRinger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDRingerPrivate * priv;
};

struct _LCDRingerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDRinger *self);
};

struct _LCDRingerPrivate {
	GMainLoop* loop;
	LmConnection* connection;
	LmMessageHandler* message_handler;
	GstElement* playbin;
	gchar* sender;
	guint8* lastSwitchState;
	gint lastSwitchState_length1;
	gint _lastSwitchState_size_;
	guint lights_out_timeout_id;
};

struct _ParamSpecLCDRinger {
	GParamSpec parent_instance;
};


extern gboolean no_pifacecad;
gboolean no_pifacecad = FALSE;
extern gchar* jid;
gchar* jid = NULL;
extern gchar* password;
gchar* password = NULL;
extern gchar* ring_path;
gchar* ring_path = NULL;
static gpointer lcd_ringer_parent_class = NULL;
static guint lcd_ringer_output_shift;
static guint lcd_ringer_output_shift = (guint) 0;
static gchar* lcd_ringer_output_str;
static gchar* lcd_ringer_output_str = NULL;

#define LIGHTS_OUT_SECONDS ((guint) 60)
#define SWITCH_POLL_MILLISECONDS ((guint) 1)
GType ringer_reset_type_get_type (void) G_GNUC_CONST;
gpointer lcd_ringer_ref (gpointer instance);
void lcd_ringer_unref (gpointer instance);
GParamSpec* param_spec_lcd_ringer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_ringer (GValue* value, gpointer v_object);
void value_take_lcd_ringer (GValue* value, gpointer v_object);
gpointer value_get_lcd_ringer (const GValue* value);
GType lcd_ringer_get_type (void) G_GNUC_CONST;
#define LCD_RINGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LCD_RINGER, LCDRingerPrivate))
enum  {
	LCD_RINGER_DUMMY_PROPERTY
};
LCDRinger* lcd_ringer_new (const gchar* jid, const gchar* password);
LCDRinger* lcd_ringer_construct (GType object_type, const gchar* jid, const gchar* password);
static gboolean ___lambda4_ (LCDRinger* self);
static gboolean ____lambda4__gsource_func (gpointer self);
void lcd_ringer_output (LCDRinger* self, const gchar* str);
void lcd_ringer_register_handlers (LCDRinger* self);
static void lcd_ringer_setup_ringer (LCDRinger* self);
static void lcd_ringer_connect_to_xmpp (LCDRinger* self);
static inline void _dynamic_set_uri0 (GstElement* obj, gchar* value);
static gboolean lcd_ringer_bus_callback (LCDRinger* self, GstBus* bus, GstMessage* message);
static gboolean _lcd_ringer_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static LmHandlerResult lcd_ringer_handle_message (LCDRinger* self, LmMessageHandler* handler, LmConnection* connection, LmMessage* message);
static LmHandlerResult _lcd_ringer_handle_message_lm_handle_message_function (LmMessageHandler* handler, LmConnection* connection, LmMessage* message, gpointer self);
static void lcd_ringer_disconnect_cb (LCDRinger* self, LmConnection* connection, LmDisconnectReason reason);
static void _lcd_ringer_disconnect_cb_lm_disconnect_function (LmConnection* connection, LmDisconnectReason reason, gpointer self);
static void lcd_ringer_ring (LCDRinger* self);
static gboolean lcd_ringer_render_output (LCDRinger* self);
gboolean lcd_ringer_lights_out (LCDRinger* self);
static gboolean _lcd_ringer_lights_out_gsource_func (gpointer self);
static void lcd_ringer_reset_ringer (LCDRinger* self, RingerResetType reset_type);
gboolean lcd_ringer_check_keyboard (LCDRinger* self, GIOChannel* channel, GIOCondition condition);
static gboolean _lcd_ringer_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
gboolean lcd_ringer_check_switches (LCDRinger* self);
static gboolean _lcd_ringer_check_switches_gsource_func (gpointer self);
static void lcd_ringer_finalize (LCDRinger* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[5] = {{"jid", 'j', 0, G_OPTION_ARG_STRING, &jid, "JID", NULL}, {"password", 'p', 0, G_OPTION_ARG_STRING, &password, "Password", NULL}, {"ring-path", 'r', 0, G_OPTION_ARG_STRING, &ring_path, "Ring path", NULL}, {"no-pifacecad", 'n', 0, G_OPTION_ARG_NONE, &no_pifacecad, "Do not try to use PiFace CAD for I/O", NULL}, {NULL}};

GType ringer_reset_type_get_type (void) {
	static volatile gsize ringer_reset_type_type_id__volatile = 0;
	if (g_once_init_enter (&ringer_reset_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RINGER_RESET_TYPE_TIMEOUT, "RINGER_RESET_TYPE_TIMEOUT", "timeout"}, {RINGER_RESET_TYPE_ACKNOWLEDGED, "RINGER_RESET_TYPE_ACKNOWLEDGED", "acknowledged"}, {0, NULL, NULL}};
		GType ringer_reset_type_type_id;
		ringer_reset_type_type_id = g_enum_register_static ("RingerResetType", values);
		g_once_init_leave (&ringer_reset_type_type_id__volatile, ringer_reset_type_type_id);
	}
	return ringer_reset_type_type_id__volatile;
}


static gboolean ___lambda4_ (LCDRinger* self) {
	gboolean result = FALSE;
	pifacecad_lcd_backlight_off ();
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((LCDRinger*) self);
	return result;
}


LCDRinger* lcd_ringer_construct (GType object_type, const gchar* jid, const gchar* password) {
	LCDRinger* self = NULL;
	GMainLoop* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GMainLoop* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (jid != NULL, NULL);
	g_return_val_if_fail (password != NULL, NULL);
	self = (LCDRinger*) g_type_create_instance (object_type);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	_tmp1_ = no_pifacecad;
	if (!_tmp1_) {
		pifacecad_open ();
		pifacecad_lcd_backlight_on ();
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, LIGHTS_OUT_SECONDS, ____lambda4__gsource_func, lcd_ringer_ref (self), lcd_ringer_unref);
	}
	lcd_ringer_output (self, "Starting");
	lcd_ringer_register_handlers (self);
	lcd_ringer_output (self, "Setting up ringer");
	lcd_ringer_setup_ringer (self);
	lcd_ringer_output (self, "Connecting to XMPP server");
	lcd_ringer_connect_to_xmpp (self);
	lcd_ringer_output (self, "Waiting for messages");
	_tmp2_ = self->priv->loop;
	g_main_loop_run (_tmp2_);
	_tmp3_ = no_pifacecad;
	if (!_tmp3_) {
		pifacecad_close ();
	}
	return self;
}


LCDRinger* lcd_ringer_new (const gchar* jid, const gchar* password) {
	return lcd_ringer_construct (TYPE_LCD_RINGER, jid, password);
}


static inline void _dynamic_set_uri0 (GstElement* obj, gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static gboolean _lcd_ringer_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = lcd_ringer_bus_callback ((LCDRinger*) self, bus, message);
	return result;
}


static void lcd_ringer_setup_ringer (LCDRinger* self) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp5_ = NULL;
	GstBus* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gst_element_factory_make ("playbin", "play");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	_g_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp0_;
	_tmp1_ = self->priv->playbin;
	_tmp2_ = ring_path;
	_tmp3_ = g_strconcat ("file://", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_dynamic_set_uri0 (_tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->playbin;
	_tmp6_ = gst_element_get_bus (_tmp5_);
	bus = _tmp6_;
	gst_bus_add_watch_full (bus, 0, _lcd_ringer_bus_callback_gst_bus_func, lcd_ringer_ref (self), lcd_ringer_unref);
	_tmp7_ = self->priv->playbin;
	gst_element_set_state (_tmp7_, GST_STATE_READY);
	_g_object_unref0 (bus);
}


static LmHandlerResult _lcd_ringer_handle_message_lm_handle_message_function (LmMessageHandler* handler, LmConnection* connection, LmMessage* message, gpointer self) {
	LmHandlerResult result;
	result = lcd_ringer_handle_message ((LCDRinger*) self, handler, connection, message);
	return result;
}


static void _lcd_ringer_disconnect_cb_lm_disconnect_function (LmConnection* connection, LmDisconnectReason reason, gpointer self) {
	lcd_ringer_disconnect_cb ((LCDRinger*) self, connection, reason);
}


static void lcd_ringer_connect_to_xmpp (LCDRinger* self) {
	LmConnection* _tmp0_ = NULL;
	LmConnection* _tmp1_ = NULL;
	LmConnection* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	LmMessageHandler* _tmp4_ = NULL;
	LmConnection* _tmp5_ = NULL;
	LmMessageHandler* _tmp6_ = NULL;
	LmConnection* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = lm_connection_new ("www.flyn.org");
	_lm_connection_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	_tmp1_ = self->priv->connection;
	lm_connection_set_port (_tmp1_, (guint) 5222);
	_tmp2_ = self->priv->connection;
	_tmp3_ = jid;
	lm_connection_set_jid (_tmp2_, _tmp3_);
	_tmp4_ = lm_message_handler_new (_lcd_ringer_handle_message_lm_handle_message_function, self, NULL);
	_lm_message_handler_unref0 (self->priv->message_handler);
	self->priv->message_handler = _tmp4_;
	_tmp5_ = self->priv->connection;
	_tmp6_ = self->priv->message_handler;
	lm_connection_register_message_handler (_tmp5_, _tmp6_, LM_MESSAGE_TYPE_MESSAGE, LM_HANDLER_PRIORITY_NORMAL);
	_tmp7_ = self->priv->connection;
	lm_connection_set_disconnect_function (_tmp7_, _lcd_ringer_disconnect_cb_lm_disconnect_function, self, NULL);
	{
		gboolean _tmp8_ = FALSE;
		LmConnection* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		LmConnection* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_ = NULL;
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		LmMessage* msg = NULL;
		LmMessage* _tmp21_ = NULL;
		LmMessage* _tmp22_ = NULL;
		LmMessageNode* _tmp23_ = NULL;
		LmConnection* _tmp24_ = NULL;
		LmMessage* _tmp25_ = NULL;
		_tmp9_ = self->priv->connection;
		_tmp10_ = lm_connection_open_and_block (_tmp9_, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp8_) {
			lcd_ringer_output (self, "Failure to open connection");
			return;
		}
		lcd_ringer_output (self, "Connected");
		_tmp12_ = self->priv->connection;
		_tmp13_ = jid;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "@", 0);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _vala_array_length (_tmp14_);
		_tmp17_ = _tmp16_[0];
		_tmp18_ = password;
		_tmp19_ = lm_connection_authenticate_and_block (_tmp12_, _tmp17_, _tmp18_, "lcdringer", &_inner_error_);
		_tmp20_ = _tmp19_;
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		_tmp11_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp11_) {
			lcd_ringer_output (self, "Failure to authenticate");
			return;
		}
		lcd_ringer_output (self, "Authenticated");
		_tmp21_ = lm_message_new_with_sub_type (NULL, LM_MESSAGE_TYPE_PRESENCE, LM_MESSAGE_SUB_TYPE_AVAILABLE);
		msg = _tmp21_;
		_tmp22_ = msg;
		_tmp23_ = _tmp22_->node;
		lm_message_node_add_child (_tmp23_, "show", "chat");
		_tmp24_ = self->priv->connection;
		_tmp25_ = msg;
		lm_connection_send (_tmp24_, _tmp25_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_lm_message_unref0 (msg);
			goto __catch0_g_error;
		}
		_lm_message_unref0 (msg);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e->message;
		g_error ("lcdringer.vala:132: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static LmHandlerResult lcd_ringer_handle_message (LCDRinger* self, LmMessageHandler* handler, LmConnection* connection, LmMessage* message) {
	LmHandlerResult result = 0;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (handler != NULL, 0);
	g_return_val_if_fail (connection != NULL, 0);
	g_return_val_if_fail (message != NULL, 0);
	_tmp0_ = self->priv->sender;
	if (NULL == _tmp0_) {
		LmMessage* _tmp1_ = NULL;
		LmMessageType _tmp2_ = 0;
		LmMessage* _tmp7_ = NULL;
		LmMessageNode* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp1_ = message;
		_tmp2_ = lm_message_get_type (_tmp1_);
		if (LM_MESSAGE_TYPE_MESSAGE == _tmp2_) {
			LmMessage* _tmp3_ = NULL;
			LmMessageNode* _tmp4_ = NULL;
			LmMessageNode* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp3_ = message;
			_tmp4_ = _tmp3_->node;
			_tmp5_ = lm_message_node_get_child (_tmp4_, "body");
			_tmp6_ = lm_message_node_get_value (_tmp5_);
			lcd_ringer_output (self, _tmp6_);
		} else {
			lcd_ringer_output (self, "Invalid message type rec'd");
		}
		_tmp7_ = message;
		_tmp8_ = _tmp7_->node;
		_tmp9_ = lm_message_node_get_attribute (_tmp8_, "from");
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->sender);
		self->priv->sender = _tmp10_;
		lcd_ringer_ring (self);
	} else {
		LmMessage* msg = NULL;
		const gchar* _tmp11_ = NULL;
		LmMessage* _tmp12_ = NULL;
		LmMessage* _tmp13_ = NULL;
		LmMessageNode* _tmp14_ = NULL;
		_tmp11_ = self->priv->sender;
		_tmp12_ = lm_message_new (_tmp11_, LM_MESSAGE_TYPE_MESSAGE);
		msg = _tmp12_;
		_tmp13_ = msg;
		_tmp14_ = _tmp13_->node;
		lm_message_node_add_child (_tmp14_, "body", "Already ringing.");
		{
			LmConnection* _tmp15_ = NULL;
			LmMessage* _tmp16_ = NULL;
			_tmp15_ = connection;
			_tmp16_ = msg;
			lm_connection_send (_tmp15_, _tmp16_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = stderr;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			fprintf (_tmp17_, "Error sending message: %s\n", _tmp19_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_lm_message_unref0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_lm_message_unref0 (msg);
	}
	result = LM_HANDLER_RESULT_REMOVE_MESSAGE;
	return result;
}


static void lcd_ringer_disconnect_cb (LCDRinger* self, LmConnection* connection, LmDisconnectReason reason) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	lcd_ringer_output (self, "Disconnected");
}


static gboolean _lcd_ringer_lights_out_gsource_func (gpointer self) {
	gboolean result;
	result = lcd_ringer_lights_out ((LCDRinger*) self);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean lcd_ringer_render_output (LCDRinger* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	pifacecad_lcd_clear ();
	pifacecad_lcd_backlight_on ();
	_tmp0_ = self->priv->lights_out_timeout_id;
	if (((guint) 0) != _tmp0_) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->lights_out_timeout_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, LIGHTS_OUT_SECONDS, _lcd_ringer_lights_out_gsource_func, lcd_ringer_ref (self), lcd_ringer_unref);
	self->priv->lights_out_timeout_id = _tmp2_;
	_tmp3_ = lcd_ringer_output_str;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ <= 15) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = lcd_ringer_output_str;
		pifacecad_lcd_write (_tmp6_);
	} else {
		GString* builder = NULL;
		GString* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		guint rest = 0U;
		gint _tmp15_ = 0;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		guint cutoff = 0U;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		GString* _tmp27_ = NULL;
		GString* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GString* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		guint _tmp36_ = 0U;
		guint _tmp37_ = 0U;
		guint _tmp38_ = 0U;
		_tmp7_ = g_string_new ("");
		builder = _tmp7_;
		_tmp9_ = lcd_ringer_output_str;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 30) {
			_tmp8_ = 15;
		} else {
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp12_ = lcd_ringer_output_str;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_ - 15;
		}
		rest = (guint) _tmp8_;
		_tmp16_ = lcd_ringer_output_str;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ > 30) {
			const gchar* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			_tmp19_ = lcd_ringer_output_str;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp15_ = _tmp21_ - 30;
		} else {
			_tmp15_ = 0;
		}
		cutoff = (guint) _tmp15_;
		_tmp22_ = builder;
		_tmp23_ = lcd_ringer_output_str;
		_tmp24_ = lcd_ringer_output_shift;
		_tmp25_ = string_substring (_tmp23_, (glong) _tmp24_, (glong) 15);
		_tmp26_ = _tmp25_;
		g_string_append (_tmp22_, _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = builder;
		g_string_append (_tmp27_, "\n ");
		_tmp28_ = builder;
		_tmp29_ = lcd_ringer_output_str;
		_tmp30_ = lcd_ringer_output_shift;
		_tmp31_ = rest;
		_tmp32_ = string_substring (_tmp29_, (glong) (15 + _tmp30_), (glong) _tmp31_);
		_tmp33_ = _tmp32_;
		g_string_append (_tmp28_, _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = builder;
		_tmp35_ = _tmp34_->str;
		pifacecad_lcd_write (_tmp35_);
		_tmp37_ = lcd_ringer_output_shift;
		_tmp38_ = cutoff;
		if (_tmp37_ < _tmp38_) {
			guint _tmp39_ = 0U;
			_tmp39_ = lcd_ringer_output_shift;
			_tmp36_ = _tmp39_ + 1;
		} else {
			_tmp36_ = (guint) 0;
		}
		lcd_ringer_output_shift = _tmp36_;
		_g_string_free0 (builder);
	}
	result = TRUE;
	return result;
}


gboolean lcd_ringer_lights_out (LCDRinger* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("lcdringer.vala:199: Lights out.\n");
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		pifacecad_lcd_backlight_off ();
	}
	self->priv->lights_out_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


void lcd_ringer_output (LCDRinger* self, const gchar* str) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = stdout;
	_tmp1_ = str;
	fprintf (_tmp0_, "%s\n", _tmp1_);
	lcd_ringer_output_shift = (guint) 0;
	_tmp2_ = str;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (lcd_ringer_output_str);
	lcd_ringer_output_str = _tmp3_;
	_tmp4_ = no_pifacecad;
	if (!_tmp4_) {
		lcd_ringer_render_output (self);
	}
}


static gboolean lcd_ringer_bus_callback (LCDRinger* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp2_ = NULL;
			GError* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			GError* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp2_ = message;
			gst_message_parse_error (_tmp2_, &_tmp3_, &_tmp4_);
			_g_error_free0 (err);
			err = _tmp3_;
			_g_free0 (debug);
			debug = _tmp4_;
			_tmp5_ = err;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = g_strconcat ("Error: ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			lcd_ringer_output (self, _tmp8_);
			_g_free0 (_tmp8_);
			_g_free0 (debug);
			_g_error_free0 (err);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			lcd_ringer_reset_ringer (self, RINGER_RESET_TYPE_TIMEOUT);
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static void lcd_ringer_ring (LCDRinger* self) {
	LmMessage* msg = NULL;
	const gchar* _tmp0_ = NULL;
	LmMessage* _tmp1_ = NULL;
	LmMessageNode* _tmp2_ = NULL;
	GstElement* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	_tmp1_ = lm_message_new (_tmp0_, LM_MESSAGE_TYPE_MESSAGE);
	msg = _tmp1_;
	_tmp2_ = msg->node;
	lm_message_node_add_child (_tmp2_, "body", "Ringing ...");
	{
		LmConnection* _tmp3_ = NULL;
		_tmp3_ = self->priv->connection;
		lm_connection_send (_tmp3_, msg, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Error sending message: %s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_lm_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->playbin;
	gst_element_set_state (_tmp7_, GST_STATE_PLAYING);
	_lm_message_unref0 (msg);
}


static gboolean _lcd_ringer_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = lcd_ringer_check_keyboard ((LCDRinger*) self, source, condition);
	return result;
}


static gboolean _lcd_ringer_check_switches_gsource_func (gpointer self) {
	gboolean result;
	result = lcd_ringer_check_switches ((LCDRinger*) self);
	return result;
}


void lcd_ringer_register_handlers (LCDRinger* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GIOChannel* channel = NULL;
		GIOChannel* _tmp0_ = NULL;
		_tmp0_ = g_io_channel_unix_new (STDIN_FILENO);
		channel = _tmp0_;
		g_io_channel_set_encoding (channel, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_io_channel_unref0 (channel);
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch3_g_io_channel_error;
			}
			_g_io_channel_unref0 (channel);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_io_add_watch (channel, G_IO_IN, _lcd_ringer_check_keyboard_gio_func, self);
		g_timeout_add_full (G_PRIORITY_DEFAULT, SWITCH_POLL_MILLISECONDS, _lcd_ringer_check_switches_gsource_func, lcd_ringer_ref (self), lcd_ringer_unref);
		_g_io_channel_unref0 (channel);
	}
	goto __finally3;
	__catch3_g_io_channel_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("lcdringer.vala:255: Channel error initializing state");
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean lcd_ringer_check_switches (LCDRinger* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		{
			guint8 _switch_ = 0U;
			_switch_ = (guint8) 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					guint8 _tmp3_ = 0U;
					guint8 current = 0U;
					guint8 _tmp4_ = 0U;
					guint8 _tmp5_ = 0U;
					gboolean _tmp6_ = FALSE;
					guint8 _tmp7_ = 0U;
					guint8* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					guint8 _tmp12_ = 0U;
					guint8 _tmp13_ = 0U;
					guint8 _tmp14_ = 0U;
					if (!_tmp1_) {
						guint8 _tmp2_ = 0U;
						_tmp2_ = _switch_;
						_switch_ = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = _switch_;
					if (!(((gint) _tmp3_) < 8)) {
						break;
					}
					_tmp4_ = _switch_;
					_tmp5_ = pifacecad_read_switch (_tmp4_);
					current = _tmp5_;
					_tmp7_ = current;
					if (0 == ((gint) _tmp7_)) {
						guint8* _tmp8_ = NULL;
						gint _tmp8__length1 = 0;
						guint8 _tmp9_ = 0U;
						guint8 _tmp10_ = 0U;
						_tmp8_ = self->priv->lastSwitchState;
						_tmp8__length1 = self->priv->lastSwitchState_length1;
						_tmp9_ = _switch_;
						_tmp10_ = _tmp8_[_tmp9_];
						_tmp6_ = 1 == ((gint) _tmp10_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						lcd_ringer_reset_ringer (self, RINGER_RESET_TYPE_ACKNOWLEDGED);
					}
					_tmp11_ = self->priv->lastSwitchState;
					_tmp11__length1 = self->priv->lastSwitchState_length1;
					_tmp12_ = _switch_;
					_tmp13_ = current;
					_tmp11_[_tmp12_] = _tmp13_;
					_tmp14_ = _tmp11_[_tmp12_];
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void lcd_ringer_reset_ringer (LCDRinger* self, RingerResetType reset_type) {
	const gchar* _tmp0_ = NULL;
	GstElement* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	if (NULL != _tmp0_) {
		LmMessage* msg = NULL;
		const gchar* _tmp1_ = NULL;
		LmMessage* _tmp2_ = NULL;
		RingerResetType _tmp3_ = 0;
		_tmp1_ = self->priv->sender;
		_tmp2_ = lm_message_new (_tmp1_, LM_MESSAGE_TYPE_MESSAGE);
		msg = _tmp2_;
		_tmp3_ = reset_type;
		switch (_tmp3_) {
			case RINGER_RESET_TYPE_ACKNOWLEDGED:
			{
				LmMessage* _tmp4_ = NULL;
				LmMessageNode* _tmp5_ = NULL;
				_tmp4_ = msg;
				_tmp5_ = _tmp4_->node;
				lm_message_node_add_child (_tmp5_, "body", "Ringing acknowledged.");
				break;
			}
			default:
			case RINGER_RESET_TYPE_TIMEOUT:
			{
				LmMessage* _tmp6_ = NULL;
				LmMessageNode* _tmp7_ = NULL;
				_tmp6_ = msg;
				_tmp7_ = _tmp6_->node;
				lm_message_node_add_child (_tmp7_, "body", "Ringing timed out.");
				break;
			}
		}
		{
			LmConnection* _tmp8_ = NULL;
			LmMessage* _tmp9_ = NULL;
			_tmp8_ = self->priv->connection;
			_tmp9_ = msg;
			lm_connection_send (_tmp8_, _tmp9_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = stderr;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			fprintf (_tmp10_, "Error sending message: %s\n", _tmp12_);
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_lm_message_unref0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (self->priv->sender);
		self->priv->sender = NULL;
		_lm_message_unref0 (msg);
	}
	_tmp13_ = self->priv->playbin;
	gst_element_set_state (_tmp13_, GST_STATE_READY);
}


gboolean lcd_ringer_check_keyboard (LCDRinger* self, GIOChannel* channel, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* c = NULL;
	gchar* _tmp0_ = NULL;
	gint c_length1 = 0;
	gint _c_size_ = 0;
	GIOCondition _tmp1_ = 0;
	gchar* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar _tmp18_ = '\0';
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1);
	c = _tmp0_;
	c_length1 = 1;
	_c_size_ = c_length1;
	_tmp1_ = condition;
	if (_tmp1_ == G_IO_HUP) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Standard in closed?\n");
		result = FALSE;
		c = (g_free (c), NULL);
		return result;
	}
	{
		gsize length = 0UL;
		GIOStatus status = 0;
		GIOChannel* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gsize _tmp5_ = 0UL;
		GIOStatus _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		GIOStatus _tmp8_ = 0;
		length = (gsize) -1;
		_tmp3_ = channel;
		_tmp4_ = c;
		_tmp4__length1 = c_length1;
		_tmp6_ = g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
		length = _tmp5_;
		status = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch5_g_io_channel_error;
			}
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch5_g_convert_error;
			}
			c = (g_free (c), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp8_ = status;
		if (_tmp8_ == G_IO_STATUS_EOF) {
			_tmp7_ = TRUE;
		} else {
			gsize _tmp9_ = 0UL;
			_tmp9_ = length;
			_tmp7_ = _tmp9_ != ((gsize) 1);
		}
		if (_tmp7_) {
			FILE* _tmp10_ = NULL;
			_tmp10_ = stderr;
			fprintf (_tmp10_, "Standard in closed?\n");
			result = FALSE;
			c = (g_free (c), NULL);
			return result;
		}
	}
	goto __finally5;
	__catch5_g_io_channel_error:
	{
		GError* e = NULL;
		FILE* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "IOChannelError: %s\n", _tmp13_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	goto __finally5;
	__catch5_g_convert_error:
	{
		GError* e = NULL;
		FILE* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		fprintf (_tmp14_, "ConvertError: %s\n", _tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		c = (g_free (c), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp17_ = c;
	_tmp17__length1 = c_length1;
	_tmp18_ = _tmp17_[0];
	switch (_tmp18_) {
		case '\n':
		{
			const gchar* _tmp19_ = NULL;
			_tmp19_ = self->priv->sender;
			if (NULL != _tmp19_) {
				lcd_ringer_reset_ringer (self, RINGER_RESET_TYPE_ACKNOWLEDGED);
			}
			break;
		}
		default:
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = no_pifacecad;
			if (!_tmp20_) {
				g_warning ("lcdringer.vala:332: Invalid key pressed");
			} else {
				FILE* _tmp21_ = NULL;
				FILE* _tmp22_ = NULL;
				_tmp21_ = stderr;
				fprintf (_tmp21_, "Valid keys are:\n");
				_tmp22_ = stderr;
				fprintf (_tmp22_, "  'enter' (answer)\n");
			}
			break;
		}
	}
	result = TRUE;
	c = (g_free (c), NULL);
	return result;
}


static void value_lcd_ringer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_lcd_ringer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		lcd_ringer_unref (value->data[0].v_pointer);
	}
}


static void value_lcd_ringer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = lcd_ringer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_lcd_ringer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_lcd_ringer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		LCDRinger* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = lcd_ringer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_lcd_ringer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LCDRinger** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = lcd_ringer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_lcd_ringer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLCDRinger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LCD_RINGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_lcd_ringer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_RINGER), NULL);
	return value->data[0].v_pointer;
}


void value_set_lcd_ringer (GValue* value, gpointer v_object) {
	LCDRinger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_RINGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_RINGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		lcd_ringer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_ringer_unref (old);
	}
}


void value_take_lcd_ringer (GValue* value, gpointer v_object) {
	LCDRinger* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_RINGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_RINGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_ringer_unref (old);
	}
}


static void lcd_ringer_class_init (LCDRingerClass * klass) {
	gchar* _tmp0_ = NULL;
	lcd_ringer_parent_class = g_type_class_peek_parent (klass);
	((LCDRingerClass *) klass)->finalize = lcd_ringer_finalize;
	g_type_class_add_private (klass, sizeof (LCDRingerPrivate));
	_tmp0_ = g_strdup ("");
	lcd_ringer_output_str = _tmp0_;
}


static void lcd_ringer_instance_init (LCDRinger * self) {
	guint8* _tmp0_ = NULL;
	self->priv = LCD_RINGER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (guint8, 8);
	_tmp0_[0] = (guint8) 1;
	_tmp0_[1] = (guint8) 1;
	_tmp0_[2] = (guint8) 1;
	_tmp0_[3] = (guint8) 1;
	_tmp0_[4] = (guint8) 1;
	_tmp0_[5] = (guint8) 1;
	_tmp0_[6] = (guint8) 1;
	_tmp0_[7] = (guint8) 1;
	self->priv->lastSwitchState = _tmp0_;
	self->priv->lastSwitchState_length1 = 8;
	self->priv->_lastSwitchState_size_ = self->priv->lastSwitchState_length1;
	self->priv->lights_out_timeout_id = (guint) 0;
	self->ref_count = 1;
}


static void lcd_ringer_finalize (LCDRinger* obj) {
	LCDRinger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LCD_RINGER, LCDRinger);
	g_signal_handlers_destroy (self);
	_g_main_loop_unref0 (self->priv->loop);
	_lm_connection_unref0 (self->priv->connection);
	_lm_message_handler_unref0 (self->priv->message_handler);
	_g_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->sender);
	self->priv->lastSwitchState = (g_free (self->priv->lastSwitchState), NULL);
}


GType lcd_ringer_get_type (void) {
	static volatile gsize lcd_ringer_type_id__volatile = 0;
	if (g_once_init_enter (&lcd_ringer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_lcd_ringer_init, value_lcd_ringer_free_value, value_lcd_ringer_copy_value, value_lcd_ringer_peek_pointer, "p", value_lcd_ringer_collect_value, "p", value_lcd_ringer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LCDRingerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lcd_ringer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LCDRinger), 0, (GInstanceInitFunc) lcd_ringer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType lcd_ringer_type_id;
		lcd_ringer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LCDRinger", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&lcd_ringer_type_id__volatile, lcd_ringer_type_id);
	}
	return lcd_ringer_type_id__volatile;
}


gpointer lcd_ringer_ref (gpointer instance) {
	LCDRinger* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void lcd_ringer_unref (gpointer instance) {
	LCDRinger* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LCD_RINGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	struct termios old_tio = {0};
	struct termios new_tio = {0};
	struct termios _tmp22_ = {0};
	struct termios _tmp23_ = {0};
	tcflag_t _tmp24_ = {0};
	struct termios _tmp25_ = {0};
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	LCDRinger* _tmp28_ = NULL;
	LCDRinger* _tmp29_ = NULL;
	struct termios _tmp30_ = {0};
	GError * _inner_error_ = NULL;
	_tmp0_ = g_key_file_new ();
	key_file = _tmp0_;
	{
		gboolean ok = FALSE;
		GKeyFile* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = key_file;
		_tmp2_ = g_key_file_load_from_file (_tmp1_, "/etc/lcdringer.conf", G_KEY_FILE_NONE, &_inner_error_);
		ok = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp3_ = ok;
		if (_tmp3_) {
			gchar* _tmp4_ = NULL;
			GKeyFile* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			GKeyFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			GKeyFile* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp5_ = key_file;
			_tmp6_ = g_key_file_get_string (_tmp5_, "account", "jid", &_inner_error_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 (jid);
			jid = _tmp7_;
			_tmp9_ = key_file;
			_tmp10_ = g_key_file_get_string (_tmp9_, "account", "password", &_inner_error_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_tmp4_);
				goto __catch6_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (password);
			password = _tmp11_;
			_tmp13_ = key_file;
			_tmp14_ = g_key_file_get_string (_tmp13_, "account", "ring_path", &_inner_error_);
			_tmp12_ = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_free0 (_tmp4_);
				goto __catch6_g_error;
			}
			_tmp15_ = _tmp12_;
			_tmp12_ = NULL;
			_g_free0 (ring_path);
			ring_path = _tmp15_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp4_);
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_error ("lcdringer.vala:356: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp17_ = NULL;
		_tmp17_ = g_option_context_new ("- Ringer");
		opt_context = _tmp17_;
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch7_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_key_file_unref0 (key_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally7;
	__catch7_g_option_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e->message;
		g_error ("lcdringer.vala:365: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp19_ = jid;
	if (NULL == _tmp19_) {
		g_error ("lcdringer.vala:369: Requires a JID");
	}
	_tmp20_ = password;
	if (NULL == _tmp20_) {
		g_error ("lcdringer.vala:373: Requires a password");
	}
	_tmp21_ = ring_path;
	if (NULL == _tmp21_) {
		g_error ("lcdringer.vala:377: Requires a ring path");
	}
	tcgetattr (STDIN_FILENO, &_tmp22_);
	old_tio = _tmp22_;
	_tmp23_ = old_tio;
	new_tio = _tmp23_;
	_tmp24_ = new_tio.c_lflag;
	new_tio.c_lflag = _tmp24_ & ((~ICANON) & (~ECHO));
	_tmp25_ = new_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp25_);
	gst_init (&args_length1, &args);
	_tmp26_ = jid;
	_tmp27_ = password;
	_tmp28_ = lcd_ringer_new (_tmp26_, _tmp27_);
	_tmp29_ = _tmp28_;
	_lcd_ringer_unref0 (_tmp29_);
	_tmp30_ = old_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp30_);
	result = 0;
	_g_key_file_unref0 (key_file);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



