/*
 * Author: Stefan Andritoiu <stefan.andritoiu@intel.com>
 * Copyright (c) 2015 Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

public class MQ303ASample{

	static {
		try {
			System.loadLibrary("javaupm_mq303a");
		}catch (UnsatisfiedLinkError e) {
			System.err.println("error in loading native library");
			System.exit(-1);
		}
	}
	
	public static void main(String[] args) throws InterruptedException {
		//! [Interesting]
        // Instantiate an mq303a sensor on analog pin A0
		 
		// This device uses a heater powered from an analog I/O pin.·
		// If using A0 as the data pin, then you need to use A1, as the heater
		// pin (if using a grove mq303a).  For A1, we can use the D15 gpio,·
		// setup as an output, and drive it low to power the heater.
		upm_mq303a.MQ303A mq303a = new upm_mq303a.MQ303A(1,15);
		
		System.out.println("Enabling heater and waiting 2 minutes for warmup.");
		mq303a.heaterEnable(true);
		Thread.sleep(120000);
		
		System.out.println("This sensor may need to warm until the value drops below about 450.");
		
		for(int i = 1 ; i < 10 ; i++){
			int val = mq303a.value();
			System.out.println("Alcohol detected (higher means stronger alcohol): " + val);
			
			Thread.sleep(1000);
		}
		
		mq303a.heaterEnable(false);
		System.out.println("Exiting");
	    //! [Interesting]
    }

}
