// This file is a collection of functions taken from the original iaxclient_lib.h and maybe somewhere else into the iaxclient project.
// There could be some modified function somewhere so please have a look at the original at http://iaxclient.sourceforge.net

#ifndef _iaxclient_h
#define _iaxclient_h


#include <stdio.h>

/* Define audio type constants */
#define AUDIO_INTERNAL 0
#define AUDIO_INTERNAL_PA 1
#define AUDIO_INTERNAL_FILE 2
#define AUDIO_EXTERNAL 99

/* payload formats : WARNING: must match libiax values!!! */
/* Data formats for capabilities and frames alike */
#define IAXC_FORMAT_G723_1       (1 << 0)        /* G.723.1 compression */
#define IAXC_FORMAT_GSM          (1 << 1)        /* GSM compression */
#define IAXC_FORMAT_ULAW         (1 << 2)        /* Raw mu-law data (G.711) */
#define IAXC_FORMAT_ALAW         (1 << 3)        /* Raw A-law data (G.711) */
#define IAXC_FORMAT_MP3          (1 << 4)        /* MPEG-2 layer 3 */
#define IAXC_FORMAT_ADPCM        (1 << 5)        /* ADPCM (whose?) */
#define IAXC_FORMAT_SLINEAR      (1 << 6)        /* Raw 16-bit Signed Linear (8000 Hz) PCM */
#define IAXC_FORMAT_LPC10        (1 << 7)        /* LPC10, 180 samples/frame */
#define IAXC_FORMAT_G729A        (1 << 8)        /* G.729a Audio */

#define IAXC_FORMAT_MAX_AUDIO (1 << 15)  /* Maximum audio format */
#define IAXC_FORMAT_JPEG         (1 << 16)       /* JPEG Images */
#define IAXC_FORMAT_PNG          (1 << 17)       /* PNG Images */
#define IAXC_FORMAT_H261         (1 << 18)       /* H.261 Video */
#define IAXC_FORMAT_H263         (1 << 19)       /* H.263 Video */



#define IAXC_EVENT_TEXT			1
#define IAXC_EVENT_LEVELS		2
#define IAXC_EVENT_STATE		3

#define IAXC_CALL_STATE_FREE 		0
#define IAXC_CALL_STATE_ACTIVE 		(1<<1)
#define IAXC_CALL_STATE_OUTGOING 	(1<<2)
#define IAXC_CALL_STATE_RINGING 	(1<<3)
#define IAXC_CALL_STATE_COMPLETE 	(1<<4)
#define IAXC_CALL_STATE_SELECTED 	(1<<5)

#define IAXC_TEXT_TYPE_STATUS		1
#define IAXC_TEXT_TYPE_NOTICE		2
#define IAXC_TEXT_TYPE_ERROR		3
/* FATAL ERROR: User Agent should probably display error, then die. */
#define IAXC_TEXT_TYPE_FATALERROR	4
#define IAXC_TEXT_TYPE_IAX		5



#define IAXC_EVENT_BUFSIZ	256
struct iaxc_ev_levels {
	float input;
	float output;
};

struct iaxc_ev_text {
	int type;
	int callNo; /* call number for IAX text */
	char message[IAXC_EVENT_BUFSIZ];
};

struct iaxc_ev_call_state {
	int callNo;
	int state;
	char remote[IAXC_EVENT_BUFSIZ];
	char remote_name[IAXC_EVENT_BUFSIZ];
	char local[IAXC_EVENT_BUFSIZ];
	char local_context[IAXC_EVENT_BUFSIZ];
};

typedef struct iaxc_event_struct {
	int type;
	union {
		struct iaxc_ev_levels 		levels;
		struct iaxc_ev_text 		text;
		struct iaxc_ev_call_state 	call;
	} ev;
} iaxc_event;

typedef int (*iaxc_event_callback_t)(iaxc_event e);
void iaxc_set_event_callback(iaxc_event_callback_t func);

int iaxc_initialize(int nCalls);
void iaxc_shutdown();
void iaxc_set_encode_format(int fmt);
void iaxc_set_callerid(char *name, char *number);
void iaxc_process_calls();
int iaxc_service_audio();
int iaxc_start_processing_thread();
int iaxc_stop_processing_thread();
void iaxc_call(char *num);
void iaxc_register(char *user, char *pass, char *host);
void iaxc_answer_call(int callNo); 
void iaxc_blind_transfer_call(int callNo, char *number); 
void iaxc_dump_all_calls(void);
void iaxc_dump_call(void);
void iaxc_reject_call(void);
void iaxc_send_dtmf(char digit);
int iaxc_was_call_answered();
void iaxc_millisleep(long ms);
void iaxc_set_silence_threshold(double thr);
void iaxc_set_audio_output(int mode);
int iaxc_select_call(int callNo);
int iaxc_first_free_call();
int iaxc_selected_call();
int iaxc_quelch(int callNo, int MOH);
int iaxc_unquelch(int call);

#define IAXC_AD_INPUT           (1<<0)
#define IAXC_AD_OUTPUT          (1<<1)
#define IAXC_AD_RING            (1<<2)
#define IAXC_AD_INPUT_DEFAULT   (1<<3)
#define IAXC_AD_OUTPUT_DEFAULT  (1<<4)
#define IAXC_AD_RING_DEFAULT    (1<<5)

struct iaxc_audio_device {
	char *name;             /* name of the device */
	long capabilities;      /* flags, defined above */
	int devID;              /* driver-specific ID */
};

/* Get audio device information:
 * 	**devs: a pointer to an array of device structures, as declared above.  function
 * 	will give you a pointer to the proper array, which will be valid as long as iaxc is
 * 	initialized.
 *
 * 	*nDevs: a pointer to an int, to which the count of devices in the array devs will be
 * 	written
 *
 * 	*input, *output, *ring: the currently selected devices for input, output, ring will
 * 	be written to the int pointed to by these pointers.
 */
int iaxc_audio_devices_get(struct iaxc_audio_device **devs, int *nDevs, int *input, int *output, int *ring); 
int iaxc_audio_devices_set(int input, int output, int ring);

double iaxc_input_level_get();
double iaxc_output_level_get();
int iaxc_input_level_set(double level);
int iaxc_output_level_set(double level);


struct iaxc_sound {
	short 	*data;          /* sound data */
	long 	len;            /* length of sample */
	int 	malloced;	/* should the library free() the data after it is played? */
	int	channel;	/* 0 for outputSelected, 1 for ringSelected */
	int 	repeat;      	/* number of times to repeat (-1 = infinite) */
	long	pos;		/* internal use: current play position */
	int 	id;		/* internal use: sound ID */
	struct iaxc_sound *next; /* internal use: next in list */
};

/* play a sound.  sound = an iaxc_sound structure, ring: 0: play through output device; 1: play through "ring" device */
int iaxc_play_sound(struct iaxc_sound *sound, int ring);

/* stop sound with ID "id" */
int iaxc_stop_sound(int id);


#define IAXC_FILTER_DENOISE 	(1<<0)
#define IAXC_FILTER_AGC 	(1<<1)
#define IAXC_FILTER_ECHO 	(1<<2)
int iaxc_get_filters(void);
void iaxc_set_filters(int filters);



#endif



#ifndef _iaxclient_lib_h
#define _iaxclient_lib_h

/* This is the internal include file for IAXCLIENT -- externally
 * accessible APIs should be declared in iaxclient.h */


#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <pthread.h>
#include <stdio.h>




#define THREAD pthread_t
#define THREADID unsigned /* unused for Posix Threads */
#define THREADCREATE(func, args, thread, id) \
pthread_create(&thread, NULL, func, args)
#define THREADCREATE_ERROR -1
#define THREADFUNCDECL(func) void * func(void *args)
#define THREADFUNCRET(r) void * r = 0
#define THREADJOIN(t) pthread_join(t, 0)
#define MUTEX pthread_mutex_t
#define MUTEXINIT(m) pthread_mutex_init(m, NULL) //TODO: check error
#define MUTEXLOCK(m) pthread_mutex_lock(m)
#define MUTEXUNLOCK(m) pthread_mutex_unlock(m)
#define MUTEXDESTROY(m) pthread_mutex_destroy(m)


#define MAXARGS 10
#define MAXARG 256
#define MAX_SESSIONS 4
#define OUT_INTERVAL 20

/* millisecond interval to time out calls */
#define IAXC_CALL_TIMEOUT 30000

#include "iax-client.h" // LibIAX functions
#include "gsm.h"


void iaxc_usermsg(int type, const char *fmt, ...);
long iaxc_usecdiff( struct timeval *timeA, struct timeval *timeB );
void iaxc_handle_network_event(struct iax_event *e, int callNo);
void iaxc_service_network(int netfd);
void iaxc_do_levels_callback(float input, float output);



struct iaxc_call {
	/* to be replaced with codec-structures, with codec-private data  */
	gsm gsmin;
	gsm gsmout;

	/* the "state" of this call */
	int state;
	char remote[IAXC_EVENT_BUFSIZ];
	char remote_name[IAXC_EVENT_BUFSIZ];
	char local[IAXC_EVENT_BUFSIZ];
	char local_context[IAXC_EVENT_BUFSIZ];

	/* Outbound CallerID */
	char callerid_name[IAXC_EVENT_BUFSIZ];
	char callerid_number[IAXC_EVENT_BUFSIZ];

	/* reset whenever we receive packets from remote */
	struct 	 timeval 	last_activity;
	struct 	 timeval 	last_ping;

	struct iax_session *session;
};


extern double iaxc_silence_threshold;
extern iaxc_event_callback_t iaxc_event_callback;
extern MUTEX iaxc_lock;

#endif

