/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2006, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	mesh.c

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Fonchi		2007-06-25      For mesh (802.11s) support.
*/

#ifdef MESH_SUPPORT


#include "rt_config.h"
#include "mesh_sanity.h"

extern UCHAR OUI_WPA_NONE_AKM[4];
extern UCHAR OUI_WPA_TKIP[4];
extern UCHAR OUI_WPA_CCMP[4];
extern UCHAR OUI_WPA2_TKIP[4];
extern UCHAR OUI_WPA2_CCMP[4];
extern UCHAR OUI_MSA_8021X_AKM[4];		/* Not yet final - IEEE 802.11s-D1.06 */
extern UCHAR OUI_MSA_PSK_AKM[4];		/* Not yet final - IEEE 802.11s-D1.06 */


typedef VOID (*MESH_ACT_FRAME_HANDLER_FUNC)(IN PRTMP_ADAPTER pAd, IN RX_BLK *pRxBlk);

typedef struct _MESH_ACTION_HANDLER
{
	UINT8 Category;
	UINT8 ActionCode;
	MESH_ACT_FRAME_HANDLER_FUNC pHandle;
} MESH_ACTION_HANDLER, *PMESH_ACTION_HANDLER;

static MESH_ACTION_HANDLER MeshActHandler[] = 
{
	/* Peer Link Management. */
	{CATEGORY_MESH_PEER_LINK, ACT_CODE_PEER_LINK_OPEN, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPeerLinkOpenProcess},
	{CATEGORY_MESH_PEER_LINK, ACT_CODE_PEER_LINK_CONFIRM, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPeerLinkConfirmProcess},
	{CATEGORY_MESH_PEER_LINK, ACT_CODE_PEER_LINK_CLOSE, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPeerLinkCloseProcess},

	/* Peer Link Metric. */
	{CATEGORY_MESH_LINK_METRIC, ACT_CODE_LINK_METRIC_REP, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPeerLinkMetricReportProcess},

	/* HWMP. */
	{CATEGORY_MESH_PATH_SELECTION, ACT_CODE_PATH_REQUEST, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPreqRcvProcess},
	{CATEGORY_MESH_PATH_SELECTION, ACT_CODE_PATH_REPLY, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPrepRcvProcess},
	{CATEGORY_MESH_PATH_SELECTION, ACT_CODE_PATH_ERROR, (MESH_ACT_FRAME_HANDLER_FUNC)MeshPerrRcvProcess},
	{CATEGORY_MESH_PATH_SELECTION, ACT_CODE_MULTIPATH_NOTICE,
															(MESH_ACT_FRAME_HANDLER_FUNC)MeshMultipathNoticeRcvProcess},

	{CATEGORY_MESH_RES_COORDINATION, RESOURCE_CHANNEL_SWITCH_ANNOUNCEMENT,
															(MESH_ACT_FRAME_HANDLER_FUNC)MeshChSwAnnounceProcess}
};
#define MESH_ACT_HANDLER_TAB_SIZE (sizeof(MeshActHandler) / sizeof(MESH_ACTION_HANDLER))




INT Set_MeshId_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT   success = FALSE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if(strlen(arg) <= MAX_MESH_ID_LEN)
	{
		NdisZeroMemory(pAd->MeshTab.MeshId, MAX_MESH_ID_LEN);
		NdisMoveMemory(pAd->MeshTab.MeshId, arg, strlen(arg));
		pAd->MeshTab.MeshIdLen = (UCHAR)strlen(arg);
		success = TRUE;

		DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) Set_MeshId_Proc::(Len=%d,MeshId=%s)\n",
			pAd->MeshTab.MeshIdLen, pAd->MeshTab.MeshId));
	
		MeshDown(pAd, TRUE);
		MeshUp(pAd);		
	}
	else
		success = FALSE;

	return success;
}

INT Set_MeshHostName_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT   success = FALSE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if(strlen(arg) <= MAX_HOST_NAME_LEN)
	{
		NdisZeroMemory(pAd->MeshTab.HostName, MAX_HOST_NAME_LEN);
		NdisMoveMemory(pAd->MeshTab.HostName, arg, strlen(arg));
		success = TRUE;

		DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) Set_MeshHostName_Proc::(HostName=%s)\n",
			pAd->MeshTab.HostName));
	}
	else
		success = FALSE;

	return success;
}

INT Set_MeshAutoLink_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT Enable;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	Enable = simple_strtol(arg, 0, 16);

	pAd->MeshTab.MeshAutoLink = (Enable > 0) ? TRUE : FALSE;

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(enable = %d)\n", __FUNCTION__, pAd->MeshTab.MeshAutoLink));
	
	return TRUE;
}


INT Set_MeshForward_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT Enable;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	Enable = simple_strtol(arg, 0, 16);

	pAd->MeshTab.MeshCapability.field.Forwarding = (Enable > 0) ? (1) : (0);

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(enable = %d)\n", __FUNCTION__, pAd->MeshTab.MeshCapability.field.Forwarding));
	
	return TRUE;
}


INT Set_MeshPortal_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT Enable;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	Enable = simple_strtol(arg, 0, 16);

	if (Enable)
		pAd->MeshTab.OpMode |= MESH_POTAL;
	else
		pAd->MeshTab.OpMode ^= MESH_POTAL;	
	

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(enable = %d)\n", __FUNCTION__, pAd->MeshTab.OpMode));
	
	return TRUE;
}

INT Set_MeshAddLink_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	PSTRING value;
	UCHAR PeerMac[ETH_LENGTH_OF_ADDRESS];	
	ULONG LinkIdx;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if(strlen(arg) == 17)  /*Mac address acceptable format 01:02:03:04:05:06 length 17 */
	{
		for (i=0, value = rstrtok(arg,":"); value; value = rstrtok(NULL,":"), i++) 
		{
			if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
				return FALSE;  /*Invalid */

			AtoH(value, &PeerMac[i], 1);
		}

		if(i != 6)
			return FALSE;  /*Invalid */
	}

	LinkIdx = GetMeshLinkId(pAd, (PCHAR)PeerMac);
	if (LinkIdx == BSS_NOT_FOUND)
	{
		LinkIdx = MeshLinkAlloc(pAd, PeerMac, MESH_LINK_STATIC);
		if (LinkIdx == BSS_NOT_FOUND)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("%s() All Mesh-Links been occupied.\n", __FUNCTION__));
			return FALSE;
		}
	}

	if (!VALID_MESH_LINK_ID(LinkIdx))
		return FALSE;

	MlmeEnqueue(pAd, MESH_LINK_MNG_STATE_MACHINE, MESH_LINK_MNG_ACTOPN, 0, NULL, LinkIdx);

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(LinkIdx = %ld)\n", __FUNCTION__, LinkIdx));
	
	return TRUE;
}

INT Set_MeshDelLink_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	PSTRING value;
	UCHAR PeerMac[ETH_LENGTH_OF_ADDRESS];	
	ULONG LinkIdx;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if(strlen(arg) == 17)  /*Mac address acceptable format 01:02:03:04:05:06 length 17 */
	{
		for (i=0, value = rstrtok(arg,":"); value; value = rstrtok(NULL,":"), i++) 
		{
			if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
				return FALSE;  /*Invalid */

			AtoH(value, &PeerMac[i], 1);
		}

		if(i != 6)
			return FALSE;  /*Invalid */
	}

	LinkIdx = GetMeshLinkId(pAd, (PCHAR)PeerMac);
	if (!VALID_MESH_LINK_ID(LinkIdx))
		return FALSE;

	pAd->MeshTab.MeshLink[LinkIdx].Entry.LinkType = MESH_LINK_DYNAMIC;
	MlmeEnqueue(pAd, MESH_LINK_MNG_STATE_MACHINE, MESH_LINK_MNG_CNCL, 0, NULL, LinkIdx);

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(LinkIdx = %ld)\n", __FUNCTION__, LinkIdx));
	
	return TRUE;
}

INT Set_MeshMaxTxRate_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT Rate;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	Rate = simple_strtol(arg, 0, 10);

	if (Rate <= 12)
		pAd->MeshTab.MeshMaxTxRate = Rate;
	else 
		DBGPRINT(RT_DEBUG_ERROR, ("%s::Wrong Tx Rate setting(%d), (0 ~ 12))\n", __FUNCTION__, Rate));

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(Max Tx Rate = %ld)\n", __FUNCTION__, pAd->MeshTab.MeshMaxTxRate));
	
	return TRUE;
}

INT Set_MeshRouteAdd_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT	success = TRUE;
	return success;
}

INT Set_MeshRouteDelete_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT	success = TRUE;
	return success;
}

INT Set_MeshRouteUpdate_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT	success = TRUE;
	return success;
}

INT Set_MeshMultiCastAgeOut_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT AgeTime;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	AgeTime = simple_strtol(arg, 0, 10);

	if ((AgeTime <= 65535) && (AgeTime >= 1))
		pAd->MeshTab.MeshMultiCastAgeOut = AgeTime;
	else 
		DBGPRINT(RT_DEBUG_ERROR, ("%s::Wrong MeshMultiCastAgeOut setting(%d), (1 ~ 65535))\n", __FUNCTION__, AgeTime));

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(MeshMultiCastAgeOut = %ld)\n", __FUNCTION__, pAd->MeshTab.MeshMultiCastAgeOut));

	pAd->MeshTab.MeshMultiCastAgeOut = (AgeTime * 1000);

	return TRUE;
}

INT Set_MeshAuthMode_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UCHAR	i;
	INT		success = TRUE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;
	
	if ((strncmp(arg, "WPANONE", 7) == 0) || (strncmp(arg, "wpanone", 7) == 0))
		pAd->MeshTab.AuthMode = Ndis802_11AuthModeWPANone;		
	else
		pAd->MeshTab.AuthMode = Ndis802_11AuthModeOpen;

	/* Set all mesh link as Port_Not_Secure */
	for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
	{
		if (IS_ENTRY_MESH(&pAd->MacTab.Content[i]))
		{
			pAd->MacTab.Content[i].PortSecured  = WPA_802_1X_PORT_NOT_SECURED;
		}
	}
		
	RTMPMakeRSNIE(pAd, pAd->MeshTab.AuthMode, pAd->MeshTab.WepStatus, MIN_NET_DEVICE_FOR_MESH);
	
	if(pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
	{	
		if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
			pAd->MeshTab.DefaultKeyId = 0;
		else
			pAd->MeshTab.DefaultKeyId = 1;
	}

	DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) Set_MeshAuthMode_Proc::(MeshAuthMode(%d)=%s)\n",
			pAd->MeshTab.AuthMode, GetAuthMode(pAd->MeshTab.AuthMode)));
	
	return success;
}

INT Set_MeshEncrypType_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT	success = TRUE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if ((strncmp(arg, "WEP", 3) == 0) || (strncmp(arg, "wep", 3) == 0))
    {
		if (pAd->MeshTab.AuthMode < Ndis802_11AuthModeWPA)
			pAd->MeshTab.WepStatus = Ndis802_11WEPEnabled;				  
	}
	else if ((strncmp(arg, "TKIP", 4) == 0) || (strncmp(arg, "tkip", 4) == 0))
	{
		if (pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
			pAd->MeshTab.WepStatus = Ndis802_11Encryption2Enabled;                       
    }
	else if ((strncmp(arg, "AES", 3) == 0) || (strncmp(arg, "aes", 3) == 0))
	{
		if (pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
			pAd->MeshTab.WepStatus = Ndis802_11Encryption3Enabled;                            
	}    
	else
	{
		pAd->MeshTab.WepStatus = Ndis802_11WEPDisabled;                 
	}

	if(pAd->MeshTab.WepStatus >= Ndis802_11Encryption2Enabled)
	{		
		if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
			pAd->MeshTab.DefaultKeyId = 0;
		else
			pAd->MeshTab.DefaultKeyId = 1;
	}
								
	RTMPMakeRSNIE(pAd, pAd->MeshTab.AuthMode, pAd->MeshTab.WepStatus, MIN_NET_DEVICE_FOR_MESH);

	DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) Set_MeshEncrypType_Proc::(MeshEncrypType(%d)=%s)\n",
			pAd->MeshTab.WepStatus, GetEncryptType(pAd->MeshTab.WepStatus)));

	return success;
}

INT Set_MeshDefaultkey_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	ULONG		KeyIdx;
	INT			success = TRUE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	KeyIdx = simple_strtol(arg, 0, 10);
	if((KeyIdx >= 1 ) && (KeyIdx <= 4))
		pAd->MeshTab.DefaultKeyId = (UCHAR) (KeyIdx - 1);
	else
		pAd->MeshTab.DefaultKeyId = 0;	/* Default value */

	DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) Set_MeshDefaultkey_Proc::(MeshDefaultkey=%d)\n",
										pAd->MeshTab.DefaultKeyId));

	return success;
}

INT Set_MeshWEPKEY_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UCHAR		i;
	UCHAR		KeyLen;
	UCHAR		CipherAlg = CIPHER_NONE;
	INT			success = TRUE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: /*wep 40 Ascii type */
		case 13: /*wep 104 Ascii type */
			pAd->MeshTab.SharedKey.KeyLen = KeyLen;
			NdisMoveMemory(pAd->MeshTab.SharedKey.Key, arg, KeyLen);
			if (KeyLen == 5)
				CipherAlg = CIPHER_WEP64;
			else
				CipherAlg = CIPHER_WEP128;

			NdisMoveMemory(pAd->MeshTab.DesiredWepKey, arg, KeyLen);
			pAd->MeshTab.DesiredWepKeyLen= KeyLen;
			
			DBGPRINT(RT_DEBUG_TRACE, ("IF(mesh0) Set_MeshWEPKRY_Proc::(WepKey=%s ,type=%s, Alg=%s)\n", arg, "Ascii", CipherName[CipherAlg]));		
			break;
		case 10: /*wep 40 Hex type */
		case 26: /*wep 104 Hex type */
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  /*Not Hex value; */
			}
			pAd->MeshTab.SharedKey.KeyLen = KeyLen/2 ;
			AtoH(arg, pAd->MeshTab.SharedKey.Key, KeyLen/2);
			if (KeyLen == 10)
				CipherAlg = CIPHER_WEP64;
			else
				CipherAlg = CIPHER_WEP128;

			NdisMoveMemory(pAd->MeshTab.DesiredWepKey, arg, KeyLen);
			pAd->MeshTab.DesiredWepKeyLen = KeyLen;
			
			DBGPRINT(RT_DEBUG_TRACE, ("IF(mesh0) Set_MeshWEPKRY_Proc::(WepKey=%s, type=%s, Alg=%s)\n", arg, "Hex", CipherName[CipherAlg]));		
			break;				
		default: /*Invalid argument */
			pAd->MeshTab.SharedKey.KeyLen = 0;
			pAd->MeshTab.DesiredWepKeyLen = KeyLen;
			DBGPRINT(RT_DEBUG_ERROR, ("IF(mesh0) Set_MeshWEPKRY_Proc::Invalid argument (=%s)\n", arg));		
			return FALSE;
	}

	pAd->MeshTab.SharedKey.CipherAlg = CipherAlg;
    

	return success;
}


INT Set_MeshWPAKEY_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	/*UCHAR	keyMaterial[40]; */
	INT		success = TRUE;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	success = RT_CfgSetWPAPSKKey(pAd, arg, pAd->MeshTab.MeshId, pAd->MeshTab.MeshIdLen, pAd->MeshTab.PMK);
	if (success == FALSE)
		return FALSE;

	NdisMoveMemory(pAd->MeshTab.WPAPassPhraseKey, arg, strlen(arg));
	pAd->MeshTab.WPAPassPhraseKeyLen = strlen(arg);

	DBGPRINT(RT_DEBUG_TRACE, ("IF(mesh0) Set_MeshWPAKEY_Proc::PassPhrasKey (=%s)\n", arg));		
	
	return success;
}

INT Set_MeshRouteInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;
	PMESH_ROUTING_TABLE	pRouteTab = pAd->MeshTab.pMeshRouteTab;

	if (pRouteTab == NULL)
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: Mesh Route Table doesn't exist.\n", __FUNCTION__));
		return FALSE;
	}

	if(!IS_MESH_IF(pObj))
		return FALSE;

	DBGPRINT(RT_DEBUG_OFF, ("\n\n"));

	DBGPRINT(RT_DEBUG_OFF, ("\n%-19s%-6s%-19s%-16s%-12s%-9s\n",
		"MESH DA", "DSN", "NEXTHOP", "NEXTHOPLINKID", "METRICS", "ROUTE_IDX"));
	
	for (i=0; i<MAX_ROUTE_TAB_SIZE; i++)
	{
		PMESH_ROUTING_ENTRY pEntry = &pRouteTab->Content[i];
		if (pEntry->Valid)
		{
			DBGPRINT(RT_DEBUG_OFF, ("%02X:%02X:%02X:%02X:%02X:%02X  ", PRINT_MAC(pEntry->MeshDA)));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", pEntry->Dsn));
			DBGPRINT(RT_DEBUG_OFF, ("%02X:%02X:%02X:%02X:%02X:%02X  ", PRINT_MAC(pEntry->NextHop)));
			DBGPRINT(RT_DEBUG_OFF, ("%-16d", (int)pEntry->NextHopLinkID));
			DBGPRINT(RT_DEBUG_OFF, ("%-12d", pEntry->PathMetric));
			DBGPRINT(RT_DEBUG_OFF, ("%-9d\n", (int)pEntry->Idx));
		}
	} 

	return TRUE;
}


INT Set_MeshProxyInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{

	PMESH_PROXY_ENTRY	pEntry = NULL;
	SHORT	EntryIndex;
	PMESH_PROXY_ENTRY_TABLE	pProxyTab = pAd->MeshTab.pMeshProxyTab;
	int i=0;

	DBGPRINT(RT_DEBUG_OFF, ("pProxyTab size:%d free:%d\n",pProxyTab->AgeList.Number,pProxyTab->FreeEntryList.Number));

	EntryIndex=pProxyTab->AgeList.Head;
	if (EntryIndex >= 0)
	pEntry=&pProxyTab->Content[EntryIndex];

	DBGPRINT(RT_DEBUG_OFF, ("Mesh Proxy Age Out List\n"));
	DBGPRINT(RT_DEBUG_OFF, ("Index,DLNext,DLPrev,HashNext,Mac\n"));
	while(EntryIndex!=-1)
	{
		DBGPRINT(RT_DEBUG_OFF, ("%02d %02d %02d %02d MAC:%02x:%02x:%02x:%02x:%02x:%02x \n",
			
			EntryIndex,pEntry->DLNext,pEntry->DLPrev,pEntry->Next,
			pEntry->MacAddr[0],pEntry->MacAddr[1],pEntry->MacAddr[2],
			pEntry->MacAddr[3],pEntry->MacAddr[4],pEntry->MacAddr[5]));

		EntryIndex=pEntry->DLNext;
		pEntry=&pProxyTab->Content[EntryIndex];
	
	}

	DBGPRINT(RT_DEBUG_TRACE, ("Mesh Proxy Mac Hash Table \n"));
	for(i=0;i<MAX_HASH_ENTRY_TAB_SIZE;i++)
	{
		if (pProxyTab->Hash[i]!=-1)
			DBGPRINT(RT_DEBUG_TRACE, ("%03d : %d \n",i,pProxyTab->Hash[i]));
	
	}


	DBGPRINT(RT_DEBUG_OFF, ("Mesh Content Table \n"));
	DBGPRINT(RT_DEBUG_OFF, ("No,HashNext,DLNext,DLPrev\n"));
	for(i=0;i<MAX_HASH_PROXY_ENTRY_TAB_SIZE;i++)
	{
		DBGPRINT(RT_DEBUG_OFF, (" %d: %02d %02d %02d\n",i,pProxyTab->Content[i].Next,pProxyTab->Content[i].DLNext,pProxyTab->Content[i].DLPrev));
	}

	return TRUE;
}

INT Set_MeshEntryInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	DBGPRINT(RT_DEBUG_OFF, ("\n%-19s%-10s\n", "DESTMAC", "ROUTE_IDX"));
	
	MeshEntryTableGet(pAd);
	return TRUE;
}

INT Set_MeshInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	DBGPRINT(RT_DEBUG_OFF, ("HostName = %s, Len=%d\n", pAd->MeshTab.HostName, strlen((PSTRING)pAd->MeshTab.HostName)));
	DBGPRINT(RT_DEBUG_OFF, ("Mesh Id = %s, Len=%d\n", pAd->MeshTab.MeshId, pAd->MeshTab.MeshIdLen));
	DBGPRINT(RT_DEBUG_OFF, ("Mesh AutoLink = %s\n", pAd->MeshTab.MeshAutoLink == TRUE ? "Enable" : "Disable"));
	DBGPRINT(RT_DEBUG_OFF, ("Channel Precedence (CPI) = %d\n", pAd->MeshTab.CPI));
	DBGPRINT(RT_DEBUG_OFF, ("mesh ctrl current state =%d\n", pAd->MeshTab.CtrlCurrentState));
	DBGPRINT(RT_DEBUG_OFF, ("Mesh AuthMode(%d)=%s, EncrypType(%d)=%s \n", 
							pAd->MeshTab.AuthMode, GetAuthMode(pAd->MeshTab.AuthMode), 
							pAd->MeshTab.WepStatus, GetEncryptType(pAd->MeshTab.WepStatus)));


	for (i = 0; i < MAX_MESH_LINKS; i++)
	{
		DBGPRINT(RT_DEBUG_OFF, ("mesh link (%d) current state =%d,", i, pAd->MeshTab.MeshLink[i].CurrentState));
		DBGPRINT(RT_DEBUG_OFF, (" Valid =%d,", pAd->MeshTab.MeshLink[i].Entry.Valid));
		DBGPRINT(RT_DEBUG_OFF, (" MatchWcid =%d,", pAd->MeshTab.MeshLink[i].Entry.MacTabMatchWCID));
		DBGPRINT(RT_DEBUG_OFF, (" LocalId =%x,", pAd->MeshTab.MeshLink[i].Entry.LocalLinkId));
		DBGPRINT(RT_DEBUG_OFF, (" PeerId =%x,", pAd->MeshTab.MeshLink[i].Entry.PeerLinkId));
		DBGPRINT(RT_DEBUG_OFF, (" ExtChOffset =%d,", pAd->MeshTab.MeshLink[i].Entry.ExtChOffset));
		DBGPRINT(RT_DEBUG_OFF, (" PeerMacAddr =%02x:%02x:%02x:%02x:%02x:%02x\n",
			pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[0], pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[1],
			pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[2], pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[3],
			pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[4], pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr[5]));
	}
	DBGPRINT(RT_DEBUG_OFF, ("\n\n"));

	DBGPRINT(RT_DEBUG_OFF, ("\n%-19s%-4s%-4s%-4s%-7s%-7s%-7s%-10s%-6s%-6s%-6s%-6s\n",
			"MAC", "IDX", "AID", "PSM", "RSSI0", "RSSI1", "RSSI2", "PhMd", "BW", "MCS", "SGI", "STBC"));
	
	for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
	{
		PMAC_TABLE_ENTRY pEntry = &pAd->MacTab.Content[i];
		if (IS_ENTRY_MESH(pEntry))
		{
			DBGPRINT(RT_DEBUG_OFF, ("%02X:%02X:%02X:%02X:%02X:%02X  ",
				pEntry->Addr[0], pEntry->Addr[1], pEntry->Addr[2],
				pEntry->Addr[3], pEntry->Addr[4], pEntry->Addr[5]));
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", (int)pEntry->MatchWDSTabIdx));
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", (int)pEntry->Aid));
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", (int)pEntry->PsMode));
			DBGPRINT(RT_DEBUG_OFF, ("%-7d", pEntry->RssiSample.AvgRssi0));
			DBGPRINT(RT_DEBUG_OFF, ("%-7d", pEntry->RssiSample.AvgRssi1));
			DBGPRINT(RT_DEBUG_OFF, ("%-7d", pEntry->RssiSample.AvgRssi2));
#ifdef DOT11_N_SUPPORT
			DBGPRINT(RT_DEBUG_OFF, ("%-10s", GetPhyMode(pEntry->HTPhyMode.field.MODE)));
			DBGPRINT(RT_DEBUG_OFF, ("%-6s", GetBW(pEntry->HTPhyMode.field.BW)));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", pEntry->HTPhyMode.field.MCS));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", pEntry->HTPhyMode.field.ShortGI));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d\n", pEntry->HTPhyMode.field.STBC));
#endif /* DOT11_N_SUPPORT */
		}
	} 

	return TRUE;
}

INT Set_NeighborInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	int i;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	if (pAd->MeshTab.pMeshNeighborTab == NULL)
	{
		DBGPRINT(RT_DEBUG_OFF, ("Mesh Neighbor Tab not ready.\n"));
		return TRUE;
	}
		

	if (pAd->MeshTab.pMeshNeighborTab->NeighborNr == 0)
	{
		DBGPRINT(RT_DEBUG_OFF, ("Mesh Neighbor Tab empty.\n"));
		return TRUE;
	}

	DBGPRINT(RT_DEBUG_OFF, ("Neighbor MP Num = %d\n", pAd->MeshTab.pMeshNeighborTab->NeighborNr));
	DBGPRINT(RT_DEBUG_OFF, ("\n%-4s%-19s%-6s%-4s%-4s%-6s%-8s%-6s%-8s%-14s%-16s%-6s\n",
		"IDX", "MAC", "MRSI", "CH", "BW", "CHOF", "CPI", "STATE", "LINKID", "ECRP", "MESHID", "HSTN"));
	
	for (i=0; i<MAX_NEIGHBOR_MP; i++)
	{
		UCHAR	MeshEncrypType = ENCRYPT_OPEN_NONE;
		PMESH_NEIGHBOR_ENTRY pEntry = &pAd->MeshTab.pMeshNeighborTab->NeighborMP[i];
		if (pEntry->Valid)
		{
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", i));
			DBGPRINT(RT_DEBUG_OFF, ("%02X:%02X:%02X:%02X:%02X:%02X  ",
				pEntry->PeerMac[0], pEntry->PeerMac[1], pEntry->PeerMac[2],
				pEntry->PeerMac[3], pEntry->PeerMac[4], pEntry->PeerMac[5]));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", (int)pEntry->RealRssi));
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", (int)pEntry->Channel));
			DBGPRINT(RT_DEBUG_OFF, ("%-4d", (int)pEntry->ChBW));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", (int)pEntry->ExtChOffset));
			DBGPRINT(RT_DEBUG_OFF, ("%-8d", (int)pEntry->CPI));
			DBGPRINT(RT_DEBUG_OFF, ("%-6d", (int)pEntry->State));
			DBGPRINT(RT_DEBUG_OFF, ("%-8x", (int)pEntry->MeshLinkIdx));
			MeshEncrypType = MeshCheckPeerMpCipher(pEntry->CapabilityInfo, pEntry->RSNIE, pEntry->RSNIE_Len);
			if (MeshEncrypType == ENCRYPT_OPEN_WEP)
			{
				DBGPRINT(RT_DEBUG_OFF, ("%-14s", "OPEN-WEP"));
			}
			else if (MeshEncrypType == ENCRYPT_WPANONE_TKIP) 
			{
				DBGPRINT(RT_DEBUG_OFF, ("%-14s", "WPANONE-TKIP"));
			}
			else if (MeshEncrypType == ENCRYPT_WPANONE_AES) 
			{
				DBGPRINT(RT_DEBUG_OFF, ("%-14s", "WPANONE-AES"));
			}
			else
			{
				DBGPRINT(RT_DEBUG_OFF, ("%-14s", "OPEN-NONE"));
			}
			DBGPRINT(RT_DEBUG_OFF, ("%-16s", pEntry->MeshId));
			DBGPRINT(RT_DEBUG_OFF, ("%s\n", pEntry->HostName));
		}
	} 

	return TRUE;
}

INT Set_MultipathInfo_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	LONG HashId;
	PMESH_MULTIPATH_ENTRY pEntry;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	for (i = 0; i < MAX_MESH_LINKS; i++)
	{
		if (!PeerLinkValidCheck(pAd, i))
			continue;
		DBGPRINT(RT_DEBUG_OFF, ("Link(%d) ", i));
		for (HashId = 0; HashId < MULTIPATH_HASH_TAB_SIZE; HashId++)
		{
			pEntry = (PMESH_MULTIPATH_ENTRY)(pAd->MeshTab.MeshLink[i].Entry.MultiPathHash[HashId].pHead);
			if (pEntry == NULL)
				continue;

			DBGPRINT(RT_DEBUG_OFF, (" HashId(%ld):", HashId));
			while (pEntry)
			{
				DBGPRINT(RT_DEBUG_OFF, ("SA=%02x:%02x:%02x:%02x:%02x:%02x ",
					pEntry->MeshSA[0], pEntry->MeshSA[1], pEntry->MeshSA[2],
					pEntry->MeshSA[3], pEntry->MeshSA[4], pEntry->MeshSA[5]));
				pEntry = pEntry->pNext;
			}
		}
		DBGPRINT(RT_DEBUG_OFF, ("\n"));
	}

	return TRUE;
}

INT Set_MultiCastAgeOut_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	DBGPRINT(RT_DEBUG_OFF, ("Multi Cast Age Timeout = %ld sec\n", (pAd->MeshTab.MeshMultiCastAgeOut) / 1000));
	
	return TRUE;
}

INT Set_MeshOnly_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	UINT Enable;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	Enable = (UINT) simple_strtol(arg, 0, 16);

	pAd->MeshTab.MeshOnly= (Enable > 0) ? TRUE : FALSE;

	DBGPRINT(RT_DEBUG_TRACE, ("%s::(enable = %d)\n", __FUNCTION__, pAd->MeshTab.MeshOnly));
	
	return TRUE;
}

INT Set_PktSig_Display_Proc(
	IN PRTMP_ADAPTER pAd, 
	IN PSTRING arg)
{
	INT i;
	POS_COOKIE pObj = (POS_COOKIE) pAd->OS_Cookie;
	PMESH_BMPKTSIG_TAB pTab = pAd->MeshTab.pBMPktSigTab;

	if(!IS_MESH_IF(pObj))
		return FALSE;

	DBGPRINT(RT_DEBUG_OFF, ("\n%-4s%-19s%-4s\n", "IDX", "MAC", "SEQ"));
	for (i=0; i<MAX_BMPKTSIG_TAB_SIZE; i++)
	{
		PMESH_BMPKTSIG_ENTRY pEntry = &(pTab->Content[i]);
		if (pTab->Content[i].Valid == FALSE)
			continue;

		DBGPRINT(RT_DEBUG_OFF, ("%-4d", i));
		DBGPRINT(RT_DEBUG_OFF, ("%02x:%02x:%02x:%02x:%02x:%02x  ",
				pEntry->MeshSA[0], pEntry->MeshSA[1], pEntry->MeshSA[2],
				pEntry->MeshSA[3], pEntry->MeshSA[4], pEntry->MeshSA[5]));
		DBGPRINT(RT_DEBUG_OFF, ("%-8x:%-9x%-9x%-9x%-9x",
			pEntry->MeshSeqBased, pEntry->Offset[0], pEntry->Offset[1],
			pEntry->Offset[2], pEntry->Offset[3]));
		DBGPRINT(RT_DEBUG_OFF, ("\n"));
	}

	return TRUE;
}

/* --------------------------------- Public -------------------------------- */
/*
========================================================================
Routine Description:
    Close Mesh network interface.

Arguments:
    ad_p            points to our adapter

Return Value:
    None

Note:
========================================================================
*/
VOID RTMP_Mesh_Close(
	IN PRTMP_ADAPTER pAd)
{
	
	/* free Mesh Tables and allocate spin locks */
	NdisFreeSpinLock(&pAd->MeshTabLock);

	/* close virtual interface. */
	if (pAd->MeshTab.dev)
		RtmpOSNetDevClose(pAd->MeshTab.dev);

} /* End of RTMP_Mesh_Close */


/*
========================================================================
Routine Description:
    Remove Mesh network interface.

Arguments:
    ad_p            points to our adapter

Return Value:
    None

Note:
========================================================================
*/
VOID MESH_Remove(
	IN PRTMP_ADAPTER pAd)
{
	

#ifdef CONFIG_STA_SUPPORT
#endif /* CONFIG_STA_SUPPORT */

	/* remove virtual interface. */
	if (pAd->MeshTab.dev)
	{
		RtmpOSNetDevDetach(pAd->MeshTab.dev);
		RtmpOSNetDevFree(pAd->MeshTab.dev);
	}

	NeighborTableDestroy(pAd);
	BMPktSigTabExit(pAd);
	MultipathPoolExit(pAd);

	MeshRoutingTable_Exit(pAd);
	MeshEntryTable_Exit(pAd);
	MeshProxyEntryTable_Exit(pAd);

} /* End of MESH_Remove */


/* --------------------------------- Private -------------------------------- */

VOID MeshUp(
	IN PRTMP_ADAPTER pAd)
{
	BOOLEAN TxPreamble;

    DBGPRINT(RT_DEBUG_TRACE, ("%s: ===> \n", __FUNCTION__));
	if ( RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS) ||
		 RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		 /*||!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_START_UP)) */
		return;

	pAd->MeshTab.MeshChannel = pAd->CommonCfg.Channel;

	/* Make regular Beacon frame */
	MeshMakeBeacon(pAd, MESH_BEACON_IDX(pAd));

	/* Check if the security is supported */
	if (pAd->MeshTab.EasyMeshSecurity)
	{
		if (pAd->MeshTab.AuthMode != Ndis802_11AuthModeOpen && 
			pAd->MeshTab.AuthMode != Ndis802_11AuthModeWPANone)
		{
			pAd->MeshTab.AuthMode = Ndis802_11AuthModeOpen;
			pAd->MeshTab.WepStatus = Ndis802_11WEPDisabled;
		}			
		pAd->MeshTab.OpMode &= ~(MESH_MKD);
		
		DBGPRINT(RT_DEBUG_TRACE, ("MeshUp: the Easy MSA is enabled. \n"));
	}
	else
	{
		if (pAd->MeshTab.AuthMode != Ndis802_11AuthModeWPA2 && 
			pAd->MeshTab.AuthMode != Ndis802_11AuthModeWPA2PSK)
		{
			pAd->MeshTab.AuthMode = Ndis802_11AuthModeWPA2;
			pAd->MeshTab.WepStatus = Ndis802_11Encryption3Enabled;
		}

		DBGPRINT(RT_DEBUG_TRACE, ("MeshUp: the Easy MSA is disabled. \n"));
	}

	if (pAd->MeshTab.OpMode & MESH_MKD)
	{
		NdisMoveMemory(pAd->MeshTab.LocalMSCIE.MKDDID, pAd->MeshTab.CurrentAddress, MAC_ADDR_LEN);
		pAd->MeshTab.bInitialMsaDone = TRUE;
		pAd->MeshTab.bKeyholderDone  = TRUE;
		pAd->MeshTab.bConnectedToMKD = TRUE;
	}
	else
	{
		NdisZeroMemory(&pAd->MeshTab.LocalMSCIE, sizeof(MESH_SECURITY_CAPABILITY_IE));
		pAd->MeshTab.bInitialMsaDone = FALSE;
		pAd->MeshTab.bKeyholderDone  = FALSE;
		pAd->MeshTab.bConnectedToMKD = FALSE;
	}

#ifdef CONFIG_STA_SUPPORT
	/* set my current address as my BSSID */
	IF_DEV_CONFIG_OPMODE_ON_STA(pAd)
	AsicSetBssid(pAd, pAd->CurrentAddress);
#endif /* CONFIG_STA_SUPPORT */

	/* Init PMKID */
	pAd->MeshTab.PMKID_Len = 0;
	NdisZeroMemory(pAd->MeshTab.PMKID, LEN_PMKID);

	TxPreamble = (pAd->CommonCfg.TxPreamble == Rt802_11PreambleLong ? 0 : 1);

	pAd->MeshTab.CapabilityInfo =
			CAP_GENERATE(0, 0, (pAd->MeshTab.WepStatus != Ndis802_11EncryptionDisabled), TxPreamble, pAd->CommonCfg.bUseShortSlotTime, 0);

	if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
	{
		pAd->MeshTab.DefaultKeyId = 0;	/* always be zero */
		
        NdisZeroMemory(&pAd->MeshTab.SharedKey, sizeof(CIPHER_KEY));  
		pAd->MeshTab.SharedKey.KeyLen = LEN_TK;

		NdisMoveMemory(pAd->MeshTab.SharedKey.Key, pAd->MeshTab.PMK, LEN_TK);
            
        if (pAd->MeshTab.WepStatus == Ndis802_11Encryption2Enabled)
        {
    		NdisMoveMemory(pAd->MeshTab.SharedKey.RxMic, &pAd->MeshTab.PMK[16], LEN_TKIP_MIC);
    		NdisMoveMemory(pAd->MeshTab.SharedKey.TxMic, &pAd->MeshTab.PMK[16], LEN_TKIP_MIC);
        }

		/* Decide its ChiperAlg */
		if (pAd->MeshTab.WepStatus == Ndis802_11Encryption2Enabled)
			pAd->MeshTab.SharedKey.CipherAlg = CIPHER_TKIP;
		else if (pAd->MeshTab.WepStatus == Ndis802_11Encryption3Enabled)
			pAd->MeshTab.SharedKey.CipherAlg = CIPHER_AES;
		else
        {         
            DBGPRINT(RT_DEBUG_WARN, ("Unknow Cipher (=%d), set Cipher to AES\n", pAd->MeshTab.WepStatus));
			pAd->MeshTab.SharedKey.CipherAlg = CIPHER_AES;
        } 
	}

	DBGPRINT(RT_DEBUG_TRACE, ("!!! %s - AuthMode(%d)=%s, WepStatus(%d)=%s !!!\n", 
									__FUNCTION__,
									pAd->MeshTab.AuthMode, GetAuthMode(pAd->MeshTab.AuthMode),
									pAd->MeshTab.WepStatus, GetEncryptType(pAd->MeshTab.WepStatus)));

	MlmeEnqueue(pAd, MESH_CTRL_STATE_MACHINE, MESH_CTRL_JOIN, 0, NULL, 0);
	DBGPRINT(RT_DEBUG_TRACE, ("%s: <=== \n", __FUNCTION__));
}

BOOLEAN MeshLinkCheck(
	IN VOID *pAdSrc)
{
	PRTMP_ADAPTER pAd = (PRTMP_ADAPTER)pAdSrc;
	BOOLEAN WaitMeshClose = FALSE;
	INT idx;


	for (idx = 0; idx < MAX_MESH_LINKS; idx++)
	{
		if (PeerLinkMngRuning(pAd, idx) || PeerLinkValidCheck(pAd, idx))
			WaitMeshClose = TRUE;
	}
	return WaitMeshClose;
}

VOID MeshDown(
	IN PRTMP_ADAPTER pAd,
	IN BOOLEAN WaitFlag)
{
	INT idx;

	/* clear PMKID */
	pAd->MeshTab.PMKID_Len = 0;
	NdisZeroMemory(pAd->MeshTab.PMKID, LEN_PMKID);

	/* clear these flag */
	pAd->MeshTab.bInitialMsaDone = FALSE;	
	pAd->MeshTab.bKeyholderDone  = FALSE;
	pAd->MeshTab.bConnectedToMKD = FALSE;

#ifdef CONFIG_STA_SUPPORT
#endif /* CONFIG_STA_SUPPORT */

	MlmeEnqueue(pAd, MESH_CTRL_STATE_MACHINE, MESH_CTRL_DISCONNECT, 0, NULL, 0);
	MeshMlmeHandler(pAd);


	RtmpMeshDown(pAd, WaitFlag, MeshLinkCheck);

	/* delete all mesh links. */
	for (idx = 0; idx < MAX_MESH_LINKS; idx++)
	{
		if (pAd->MeshTab.MeshLink[idx].Entry.Valid)
			MeshLinkDelete(pAd, pAd->MeshTab.MeshLink[idx].Entry.PeerMacAddr, idx);
	}

	/* when the ra interface is down, do not send its beacon frame */
	MeshCleanBeaconFrame(pAd, MESH_BEACON_IDX(pAd));

#ifdef CONFIG_STA_SUPPORT
	/* resume BSSID for infra mode */
	IF_DEV_CONFIG_OPMODE_ON_STA(pAd)
	AsicSetBssid(pAd, pAd->CommonCfg.Bssid);
#endif /* CONFIG_STA_SUPPORT */
}

VOID MeshHalt(
	IN PRTMP_ADAPTER pAd)
{
	int idx;
	BOOLEAN 	  Cancelled;

	RTMPCancelTimer(&pAd->MeshTab.PldTimer, &Cancelled);
	RTMPCancelTimer(&pAd->MeshTab.McsTimer, &Cancelled);
	for (idx = 0; idx < MAX_MESH_LINKS; idx++)
	{
		RTMPCancelTimer(&pAd->MeshTab.MeshLink[idx].TOR, &Cancelled);
		RTMPCancelTimer(&pAd->MeshTab.MeshLink[idx].TOC, &Cancelled);
		RTMPCancelTimer(&pAd->MeshTab.MeshLink[idx].TOH, &Cancelled);
	}
}

VOID TearDownAllMeshLink(
		IN PRTMP_ADAPTER pAd)
{
	INT i;
	PMESH_NEIGHBOR_ENTRY pNeighbor = NULL;
	DBGPRINT(RT_DEBUG_TRACE, ("%s: tear down all Mesh Link.\n", __FUNCTION__));

	for (i = 0; i < MAX_MESH_LINKS; i++)
	{
			if(PeerLinkValidCheck(pAd, i))
			{
				/*
				SendMeshPeerLinkClose(pAd, pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr,
				pAd->MeshTab.MeshLink[i].Entry.LocalLinkId,
				pAd->MeshTab.MeshLink[i].Entry.PeerLinkId,
				MESH_LINK_CANCELLED);
				*/
				/*send link close message */
				{
					PUCHAR pPeerMac=pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr;
					UINT32 LocalLinkId=pAd->MeshTab.MeshLink[i].Entry.LocalLinkId;
					UINT32 PeerLinkId=pAd->MeshTab.MeshLink[i].Entry.PeerLinkId;
					HEADER_802_11 MeshHdr;
					PUCHAR pOutBuffer = NULL;
					NDIS_STATUS NStatus;
					ULONG FrameLen;
					MESH_FLAG MeshFlag;
					UINT32 MeshSeq = INC_MESH_SEQ(pAd->MeshTab.MeshSeq);

					NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  /*Get an unused nonpaged memory */
					if(NStatus != NDIS_STATUS_SUCCESS)
					{
						DBGPRINT(RT_DEBUG_TRACE, ("%s() allocate memory failed \n", __FUNCTION__));
						return;
					}

					MeshHeaderInit(pAd, &MeshHdr,
						pPeerMac,		/* addr1 */
						pAd->MeshTab.CurrentAddress,							/* addr2 */
						ZERO_MAC_ADDR);		/* addr3 */
					NdisMoveMemory(pOutBuffer, (PCHAR)&MeshHdr, sizeof(HEADER_802_11));
					FrameLen = sizeof(HEADER_802_11);

					/* Mesh Header */
					MeshFlag.word = 0;
					MeshFlag.field.AE = 0;	/* Peer-Link manager frame never carry 6 addresses. */
					InsertMeshHeader(pAd, (pOutBuffer + FrameLen), &FrameLen, MeshFlag.word,
						pAd->MeshTab.TTL, MeshSeq, NULL, NULL, NULL);

					/* Action field */
					InsertMeshActField(pAd, (pOutBuffer + FrameLen), &FrameLen, CATEGORY_MESH_PEER_LINK, ACT_CODE_PEER_LINK_CLOSE);

					/* Reason code */
					InsertReasonCode(pAd, (pOutBuffer + FrameLen), &FrameLen, MESH_LINK_CANCELLED);

					/* Mesh Peer Link Management IE */
					InsertMeshPeerLinkMngIE(pAd, (pOutBuffer + FrameLen), &FrameLen, SUBTYPE_PEER_LINK_CLOSE,
						LocalLinkId, PeerLinkId, MESH_LINK_CANCELLED);

					MiniportMMRequest(pAd, QID_AC_BE, pOutBuffer, FrameLen);
					MlmeFreeMemory(pAd, pOutBuffer);

					DBGPRINT(RT_DEBUG_TRACE, ("%s: LocalLinkId=%x, PeerLinkId=%x, Reason=%d\n",
						__FUNCTION__, LocalLinkId, PeerLinkId, MESH_LINK_CANCELLED));

				}

			
				pNeighbor = NeighborSearch(pAd, pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr);
				if (pNeighbor)
				{
					pNeighbor->State = NEIGHBOR_MP;
					pNeighbor->MeshLinkIdx = 0;
				}

				if (pAd->MeshTab.LinkSize == 0)
				{
					pAd->MeshTab.bInitialMsaDone = FALSE;
				}

				MultipathListDelete(pAd, i);


				if(MeshTableLookup(pAd, pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr, TRUE))
					MacTableDeleteMeshEntry(pAd, pAd->MeshTab.MeshLink[i].Entry.MacTabMatchWCID,
						pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr);


				if (pAd->MeshTab.MeshLink[i].Entry.Valid)
				{	
					MeshLinkDelete(pAd, pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr, i);
				}
			}
	}
}

BOOLEAN MeshAcceptPeerLink(
	IN PRTMP_ADAPTER pAd)
{
	return (pAd->MeshTab.LinkSize < MAX_MESH_LINKS) ? 1 : 0;
}

MAC_TABLE_ENTRY *MacTableInsertMeshEntry(
	IN  PRTMP_ADAPTER   pAd, 
	IN  PUCHAR pAddr,
	IN  UINT MeshLinkIdx)
{
	PMAC_TABLE_ENTRY pEntry = NULL;

	/* if FULL, return */
	if (pAd->MacTab.Size >= MAX_LEN_OF_MAC_TABLE)
		return NULL;

	do
	{
		if((pEntry = MeshTableLookup(pAd, pAddr, TRUE)) != NULL)
			break;

		/* allocate one MAC entry */
		pEntry = MacTableInsertEntry(pAd, pAddr, MeshLinkIdx + MIN_NET_DEVICE_FOR_MESH, OPMODE_AP, TRUE);
		if (pEntry)
		{
			pAd->MeshTab.MeshLink[MeshLinkIdx].Entry.MacTabMatchWCID = pEntry->Aid;
			pEntry->MatchMeshTabIdx = MeshLinkIdx;

			pEntry->MaxHTPhyMode.word = pAd->MeshTab.MaxHTPhyMode.word;
			pEntry->MinHTPhyMode.word = pAd->MeshTab.MinHTPhyMode.word;
			pEntry->HTPhyMode.word = pAd->MeshTab.HTPhyMode.word;
			
#ifdef DOT11_N_SUPPORT
			if (pAd->MeshTab.HTPhyMode.field.MODE >= MODE_HTMIX)
			{
				if (pAd->MeshTab.DesiredTransmitSetting.field.MCS != MCS_AUTO)
				{
					DBGPRINT(RT_DEBUG_TRACE, ("IF-mesh0 : Desired MCS = %d\n",
						pAd->MeshTab.DesiredTransmitSetting.field.MCS));
					
					if (pAd->MeshTab.DesiredTransmitSetting.field.MCS == 32)
					{
						/* Fix MCS as HT Duplicated Mode */
						pEntry->MaxHTPhyMode.field.BW = 1;
						pEntry->MaxHTPhyMode.field.MODE = MODE_HTMIX;
						pEntry->MaxHTPhyMode.field.STBC = 0;
						pEntry->MaxHTPhyMode.field.ShortGI = 0;
						pEntry->MaxHTPhyMode.field.MCS = 32;
					}
					else if (pEntry->MaxHTPhyMode.field.MCS > pAd->MeshTab.HTPhyMode.field.MCS)
					{
						/* STA supports fixed MCS */
						pEntry->MaxHTPhyMode.field.MCS = pAd->MeshTab.HTPhyMode.field.MCS;
					}
				}
			}
#endif /* DOT11_N_SUPPORT */
			
			DBGPRINT(RT_DEBUG_TRACE, ("MacTableInsertMeshEntry - allocate entry #%d, Total= %d\n",pEntry->Aid, pAd->MacTab.Size));
			break;
		}
	} while(FALSE);

	return pEntry;
}


/*
	==========================================================================
	Description:
		Delete all Mesh Entry in pAd->MacTab
	==========================================================================
 */
BOOLEAN MacTableDeleteMeshEntry(
	IN PRTMP_ADAPTER pAd,
	IN USHORT wcid,
	IN PUCHAR pAddr)
{
	if (!VALID_WCID(wcid))
		return FALSE;

	MacTableDeleteEntry(pAd, wcid, pAddr);
	MeshCreatePerrAction(pAd, pAddr);

	return TRUE;
}

MAC_TABLE_ENTRY *MeshTableLookup(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR pAddr,
	IN BOOLEAN bResetIdelCount)
{
	ULONG HashIdx;
	MAC_TABLE_ENTRY *pEntry = NULL;

	RTMP_SEM_LOCK(&pAd->MacTabLock);
	HashIdx = MAC_ADDR_HASH_INDEX(pAddr);
	pEntry = pAd->MacTab.Hash[HashIdx];

	while (pEntry)
	{
		if (IS_ENTRY_MESH(pEntry)
			&& MAC_ADDR_EQUAL(pEntry->Addr, pAddr))
		{
			if(bResetIdelCount)
				pEntry->NoDataIdleCount = 0;
			break;
		}
		else
			pEntry = pEntry->pNext;
	}

	RTMP_SEM_UNLOCK(&pAd->MacTabLock);
	return pEntry;
}

MAC_TABLE_ENTRY *MeshTableLookupByWcid(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR wcid,
	IN PUCHAR pAddr,
	IN BOOLEAN bResetIdelCount)
{
	ULONG MeshIndex;
	PMAC_TABLE_ENTRY pCurEntry = NULL;
	PMAC_TABLE_ENTRY pEntry = NULL;

	if (!VALID_WCID(wcid))
		return NULL;

	RTMP_SEM_LOCK(&pAd->MeshTabLock);
	RTMP_SEM_LOCK(&pAd->MacTabLock);

	do
	{
		pCurEntry = &pAd->MacTab.Content[wcid];

		MeshIndex = 0xff;
		if ((pCurEntry) && IS_ENTRY_MESH(pCurEntry))
		{
			MeshIndex = pCurEntry->MatchMeshTabIdx;
		}

		if (MeshIndex == 0xff)
			break;

		if (pAd->MeshTab.MeshLink[MeshIndex].Entry.Valid != TRUE)
			break;

		if (MAC_ADDR_EQUAL(pCurEntry->Addr, pAddr))
		{
			if(bResetIdelCount)
				pCurEntry->NoDataIdleCount = 0;
			pEntry = pCurEntry;
			break;
		}
	} while(FALSE);

	RTMP_SEM_UNLOCK(&pAd->MacTabLock);
	RTMP_SEM_UNLOCK(&pAd->MeshTabLock);

	return pEntry;
}

MAC_TABLE_ENTRY *FindMeshEntry(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR 			Wcid,
	IN PUCHAR			pAddr)
{
	MAC_TABLE_ENTRY *pEntry;

	/* lookup the match wds entry for the incoming packet. */
	pEntry = MeshTableLookupByWcid(pAd, Wcid, pAddr, TRUE);

	return pEntry;
}

VOID MlmeHandleRxMeshFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	RX_BLK			*pRxBlk)
{
	int i;
	PHEADER_802_11					pHeader = pRxBlk->pHeader;
/*	PNDIS_PACKET					pRxPacket = pRxBlk->pRxPacket; */
	UCHAR							Category;
	UCHAR							ActionField;
	UCHAR							MeshHdrLen;

	if (!MESH_ON(pAd))
		return;

	

#ifdef WDS_SUPPORT
	if (WdsTableLookup(pAd, pHeader->Addr2, FALSE) != NULL)
	{
		
		return;
	}
#endif /* WDS_SUPPORT */


	pRxBlk->pData = (UCHAR *)pHeader;
	pRxBlk->pData += LENGTH_802_11;
	pRxBlk->DataSize -= LENGTH_802_11;

	MeshHdrLen = GetMeshHederLen(pRxBlk->pData);
	/* get Category */
	NdisMoveMemory(&Category, pRxBlk->pData + MeshHdrLen, 1);
	/* get ActionField */
	NdisMoveMemory(&ActionField, pRxBlk->pData + MeshHdrLen + 1, 1);

	for (i = 0;  i < MESH_ACT_HANDLER_TAB_SIZE; i++)
	{
		if ((Category == MeshActHandler[i].Category)
			&& (ActionField == MeshActHandler[i].ActionCode)
			&& (MeshActHandler[i].pHandle))
		{
			(*(MeshActHandler[i].pHandle))(pAd, pRxBlk);
			break;
		}
	}

}

LONG
PathRouteIDSearch(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR	pAddr)
{
	MESH_ENTRY *pEntry = NULL;
	UCHAR	DestAddr[MAC_ADDR_LEN];

	
	if (*pAddr & 0x01) /* B/Mcast packet. */
		return BMCAST_ROUTE_ID;

	COPY_MAC_ADDR(DestAddr, pAddr);
	pEntry = MeshEntryTableLookUp(pAd, DestAddr);

	if (pEntry)
	{
		if (pEntry->PathReqTimerRunning)
		{
			
			return -1;
		}
		else
			return (ULONG)pEntry->Idx;
	}

	
	return -1;
}

PUCHAR
PathRouteAddrSearch(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR	RouteIdx)
{
	MESH_ROUTING_ENTRY *pEntry = NULL;
	PMESH_ROUTING_TABLE	pRouteTab = pAd->MeshTab.pMeshRouteTab;

	if (pRouteTab == NULL)
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: Mesh Route Table doesn't exist.\n", __FUNCTION__));
		return NULL;
	}

	if (RouteIdx >= MAX_ROUTE_TAB_SIZE)
		return NULL;

	if (pRouteTab->Content[RouteIdx].Valid == TRUE)
	{
		pEntry = &pRouteTab->Content[RouteIdx];
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("Can't find the Route Index = (%d)\n", (int)RouteIdx));
		return NULL;
	}

	return pEntry->MeshDA;
}

INT
PathMeshLinkIDSearch(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR	RouteIdx)
{
	MESH_ROUTING_ENTRY *pEntry = NULL;
	PMESH_ROUTING_TABLE	pRouteTab = pAd->MeshTab.pMeshRouteTab;

	if (pRouteTab == NULL)
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: Mesh Route Table doesn't exist.\n", __FUNCTION__));
		return -1;
	}

	if (RouteIdx >= MAX_ROUTE_TAB_SIZE)
		return -1;

	if (pRouteTab->Content[RouteIdx].Valid == TRUE)
	{
		pEntry = &pRouteTab->Content[RouteIdx];
		return pEntry->NextHopLinkID;
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("Can't find the Route Index = (%d)\n", (int)RouteIdx));
	}

	return -1;
}

UINT GetMeshHederLen(
	IN PUCHAR pSrcBufVA)
{
	UINT MeshHdrLen = 0;

	switch(GetMeshFlagAE(pSrcBufVA))
	{
		case 0:
			MeshHdrLen = 6;
			break;
		case 1:
			MeshHdrLen = 12;
			break;
		case 2:
			MeshHdrLen = 18;
			break;
		case 3:
			MeshHdrLen = 24;
			break;
		default:
			DBGPRINT(RT_DEBUG_ERROR, ("%s: Undown Mesh AE type=%x\n", __FUNCTION__, GetMeshFlagAE(pSrcBufVA)));
			break;
	}


	return MeshHdrLen; 
}

UINT8 GetMeshFlag(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);

	return pMeshHead->MeshFlag; 
}

UINT8 GetMeshFlagAE(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);

	return (UINT8)((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE;
}

UINT8 GetMeshTTL(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);

	return pMeshHead->MeshTTL; 
}

UINT32 GetMeshSeq(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;
	UINT32 MeshSeq;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);
	MeshSeq = le2cpu32(pMeshHead->MeshSeq);

	return MeshSeq;
}

PUCHAR GetMeshAddr4(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);
	if (((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 1
		|| ((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 3)
		return (PUCHAR)(pSrcBufVA + 6);
	else
		return NULL; 
}

PUCHAR GetMeshAddr5(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);
	if (((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 2)
		return (PUCHAR)(pSrcBufVA + 6);
	else if (((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 3)
		return (PUCHAR)(pSrcBufVA + 6 + MAC_ADDR_LEN);
	else
		return NULL; 
}

PUCHAR GetMeshAddr6(
	IN PUCHAR pSrcBufVA)
{
	PMESH_HEADER pMeshHead;

	pMeshHead = (PMESH_HEADER)(pSrcBufVA);
	if (((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 2)
		return (PUCHAR)(pSrcBufVA + 6 + MAC_ADDR_LEN);
	else if (((PMESH_FLAG)&pMeshHead->MeshFlag)->field.AE == 3)
		return (PUCHAR)(pSrcBufVA + 6 + MAC_ADDR_LEN + MAC_ADDR_LEN);
	else
		return NULL; 
}

ULONG GetMeshLinkId(
	IN PRTMP_ADAPTER pAd,
	IN PCHAR PeerMacAddr)
{
	ULONG i;

	for (i = 0; i < MAX_MESH_LINKS; i++)
	{
		if (MAC_ADDR_EQUAL(PeerMacAddr, pAd->MeshTab.MeshLink[i].Entry.PeerMacAddr))
			break;
	}

	if (i == MAX_MESH_LINKS)
		return BSS_NOT_FOUND;

	return (ULONG)i;
}

VOID MeshDataPktProcess(
	IN PRTMP_ADAPTER pAd,
	IN PNDIS_PACKET pPacket,
	IN USHORT MeshLinkIdx,
	OUT PNDIS_PACKET *pMeshForwardPacket,
	OUT BOOLEAN *pbDirectForward,
	OUT BOOLEAN *pbAnnounce)

{
	PUCHAR pHeader802_3 = GET_OS_PKT_DATAPTR(pPacket);
	PUCHAR pMeshHdr = pHeader802_3 + LENGTH_802_3;
	UINT MeshHdrLen = GetMeshHederLen(pMeshHdr);
	UINT8 MeshTTL = GetMeshTTL(pMeshHdr);
	UINT8 MeshFlagAE = GetMeshFlagAE(pMeshHdr);
	INT PktLen;

	do
	{
		*pbAnnounce = FALSE;
		*pbDirectForward = FALSE;

		if (!MESH_ON(pAd))
			break;

		if (*pHeader802_3 & 0x01)
		{
			if (--MeshTTL > 0)
				*pbDirectForward = TRUE;
			else
				*pbDirectForward = FALSE;
			*pbAnnounce = TRUE;
		}
		else
		{

			if (MAC_ADDR_EQUAL(pHeader802_3, pAd->MeshTab.CurrentAddress))
			{
				*pbAnnounce = TRUE;
				*pbDirectForward = FALSE;

				if ((!(pAd->MeshTab.OpMode & MESH_AP) && !(pAd->MeshTab.OpMode & MESH_POTAL)) &&
				     (MeshFlagAE == 2 && !MAC_ADDR_EQUAL(GetMeshAddr5(pMeshHdr),pAd->MeshTab.CurrentAddress)))
					*pbAnnounce = FALSE;
			}
			else
			{
				if (--MeshTTL > 0)
					*pbDirectForward = TRUE;
				else
					*pbDirectForward = FALSE;
				*pbAnnounce = FALSE;
			}
		}

		if (pAd->MeshTab.MeshCapability.field.Forwarding == 0)
			*pbDirectForward = FALSE;

		if (*pbDirectForward == TRUE)
		{
			PUCHAR pFwdPktHeader = NULL;
			if (*pbAnnounce == TRUE)
			{
				*pMeshForwardPacket = (PNDIS_PACKET)OS_PKT_COPY(RTPKT_TO_OSPKT(pPacket));
				if (*pMeshForwardPacket == NULL)
				{
					/*ASSERT(*pMeshForwardPacket); */
					*pbAnnounce = FALSE;
					*pbDirectForward = FALSE;
					break;
				}
				pFwdPktHeader = GET_OS_PKT_DATAPTR(*pMeshForwardPacket);
			}
			else
				pFwdPktHeader = pHeader802_3;
			

			if (NdisEqualMemory(SNAP_802_1H, pFwdPktHeader + LENGTH_802_3 + MeshHdrLen, 6)  || 
				NdisEqualMemory(SNAP_BRIDGE_TUNNEL, pFwdPktHeader + LENGTH_802_3 + MeshHdrLen, 6))   
			{
				NdisMoveMemory(pFwdPktHeader + 12, pFwdPktHeader + LENGTH_802_3 + MeshHdrLen + 6, 2);
			}
			else
			{	
				PktLen=GET_OS_PKT_LEN(pPacket)-LENGTH_802_3;
				*(pFwdPktHeader+12)=(UCHAR)(PktLen / 256);
				*(pFwdPktHeader+13)=(UCHAR)(PktLen % 256);
			}			
		}

		if (*pbAnnounce == TRUE)
		{
			PUCHAR pSrcBuf,pData=pMeshHdr + MeshHdrLen;	
			UINT Offset;
			BOOLEAN WithLLC=TRUE;
			UCHAR Header802_3[14];
	

			if (NdisEqualMemory(SNAP_802_1H, pData, 6)  || NdisEqualMemory(SNAP_BRIDGE_TUNNEL, pData, 6))                 
			{  
				pSrcBuf = pMeshHdr + MeshHdrLen + 6 - LENGTH_802_3_NO_TYPE; 	
			}
			else
			{
				pSrcBuf = pMeshHdr + MeshHdrLen - LENGTH_802_3;
				WithLLC=FALSE;
			}


			if (MeshFlagAE == 2)
			{	/* the lenght of hdr shall be 16 bytes here. */
				COPY_MAC_ADDR(Header802_3,GetMeshAddr5(pMeshHdr));
				COPY_MAC_ADDR(Header802_3+MAC_ADDR_LEN,GetMeshAddr6(pMeshHdr));
			}
			else if(MeshFlagAE == 1)
			{
				/* Mesh Data frame never AE=1. */
				/* drop the frame. */
				DBGPRINT(RT_DEBUG_ERROR, ("%s: Receive Mesh-Data frame carry AE=1. Drop the frame.\n", __FUNCTION__));
				*pbAnnounce = FALSE;
				*pbDirectForward = FALSE;
				if (*pMeshForwardPacket != NULL)
					RELEASE_NDIS_PACKET(pAd, *pMeshForwardPacket, NDIS_STATUS_FAILURE);
				*pMeshForwardPacket = NULL;
				break;
			}
			else
			{
				COPY_MAC_ADDR(Header802_3,pHeader802_3);
				COPY_MAC_ADDR(Header802_3+MAC_ADDR_LEN,pHeader802_3 + MAC_ADDR_LEN);				
			}

			Offset = pSrcBuf - pHeader802_3;
/*			GET_OS_PKT_DATAPTR(pPacket) = pSrcBuf; */
/*			GET_OS_PKT_LEN(pPacket) -= Offset; */
			SET_OS_PKT_DATAPTR(pPacket, pSrcBuf);
			SET_OS_PKT_LEN(pPacket, (GET_OS_PKT_LEN(pPacket) - Offset));

			if (WithLLC==FALSE)
			{
				PktLen=GET_OS_PKT_LEN(pPacket)-14;
				Header802_3[12]=(UCHAR)(PktLen / 256); 
				Header802_3[13]=(UCHAR)(PktLen % 256);
				memcpy(pSrcBuf,Header802_3,14);
			}
			else
			{
				memcpy(pSrcBuf,Header802_3,12);
			}
			

		}
	} while (FALSE);

	return;
}

ULONG InsertPktMeshHeader(
	IN PRTMP_ADAPTER pAd,
	IN TX_BLK *pTxBlk, 
	IN PUCHAR *pHeaderBufPtr)
{
	ULONG TempLen = 0;
	MESH_FLAG MeshFlag;
	UINT16 MeshTTL;
	UINT32 MeshSeq;
	PUCHAR pMeshAddr5 = NULL;
	PUCHAR pMeshAddr6 = NULL;

	PerpareMeshHeader(pAd, pTxBlk, &MeshFlag, &MeshTTL, &MeshSeq, &pMeshAddr5, &pMeshAddr6);
	InsertMeshHeader(pAd, *pHeaderBufPtr, &TempLen, MeshFlag.word, MeshTTL, MeshSeq,
						NULL, pMeshAddr5, pMeshAddr6);

	*pHeaderBufPtr += TempLen;
	pTxBlk->MpduHeaderLen += TempLen;

	return TempLen;
}

UINT32 RandomMeshCPI(
	IN PRTMP_ADAPTER pAd)
{
	return (UINT32)((RandomByte(pAd) << 8) + (RandomByte(pAd)));
}

UINT16 RandomLinkId(
	IN PRTMP_ADAPTER pAd)
{
	return (UINT16)((RandomByte(pAd) << 8) + (RandomByte(pAd)));
}

UINT8 RandomChSwWaitTime(
	IN PRTMP_ADAPTER pAd)
{
	UINT8 ChSwCnt = RandomByte(pAd);

	ChSwCnt = (ChSwCnt >= 50) ? ChSwCnt : (UINT8)(50 + RandomByte(pAd));
	return ChSwCnt;
}

void rtmp_read_mesh_from_file(
	IN PRTMP_ADAPTER pAd,
	PSTRING tmpbuf,
	PSTRING buffer)
{
	/*UCHAR		keyMaterial[40]; */
	ULONG		KeyIdx;
	ULONG		KeyLen;

	/*MeshId */
	if(RTMPGetKeyParameter("MeshId", tmpbuf, 255, buffer, FALSE))
	{
		/*MeshId acceptable strlen must be less than 32 and bigger than 0. */
		if((strlen(tmpbuf) < 0) || (strlen(tmpbuf) > 32))
			pAd->MeshTab.MeshIdLen = 0;
		else
			pAd->MeshTab.MeshIdLen = strlen(tmpbuf);

		if(pAd->MeshTab.MeshIdLen > 0)
		{
			NdisMoveMemory(&pAd->MeshTab.MeshId, tmpbuf, pAd->MeshTab.MeshIdLen);
		}
		else
		{
			NdisZeroMemory(&pAd->MeshTab.MeshId, MAX_MESH_ID_LEN);
		}
		DBGPRINT(RT_DEBUG_TRACE, ("MeshIdLen=%d, MeshId=%s\n", pAd->MeshTab.MeshIdLen, pAd->MeshTab.MeshId));
	}

	/*MeshAutoLink */
	if (RTMPGetKeyParameter("MeshAutoLink", tmpbuf, 255, buffer, TRUE))
	{
		LONG Enable;
		Enable = simple_strtol(tmpbuf, 0, 10);
		pAd->MeshTab.MeshAutoLink = (Enable > 0) ? TRUE : FALSE;
		DBGPRINT(RT_DEBUG_TRACE, ("%s::(MeshAutoLink=%d)\n", __FUNCTION__, pAd->MeshTab.MeshAutoLink));
	}
	else 
		pAd->MeshTab.MeshAutoLink = TRUE;

	/*MeshForward */
	if (RTMPGetKeyParameter("MeshForward", tmpbuf, 255, buffer, TRUE))
	{
		LONG Enable;
		Enable = simple_strtol(tmpbuf, 0, 10);
		pAd->MeshTab.MeshCapability.field.Forwarding = (Enable > 0) ? (1) : (0);
		DBGPRINT(RT_DEBUG_TRACE, ("%s::(MeshForward=%d)\n", __FUNCTION__, pAd->MeshTab.MeshCapability.field.Forwarding));
	}

	/*MeshAuthMode */
	if (RTMPGetKeyParameter("MeshAuthMode", tmpbuf, 255, buffer, TRUE))
	{										
		if ((strncmp(tmpbuf, "WPANONE", 7) == 0) || (strncmp(tmpbuf, "wpanone", 7) == 0))
			pAd->MeshTab.AuthMode = Ndis802_11AuthModeWPANone;				
		else
			pAd->MeshTab.AuthMode = Ndis802_11AuthModeOpen;
			
		DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) MeshAuthMode(%d)=%s \n", pAd->MeshTab.AuthMode, GetAuthMode(pAd->MeshTab.AuthMode)));
		RTMPMakeRSNIE(pAd, pAd->MeshTab.AuthMode, pAd->MeshTab.WepStatus, MIN_NET_DEVICE_FOR_MESH);		

		if(pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
		{	
			if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
				pAd->MeshTab.DefaultKeyId = 0;
			else
				pAd->MeshTab.DefaultKeyId = 1;
		}

	}

	/*MeshEncrypType */
	if (RTMPGetKeyParameter("MeshEncrypType", tmpbuf, 255, buffer, TRUE))
	{										
		if ((strncmp(tmpbuf, "WEP", 3) == 0) || (strncmp(tmpbuf, "wep", 3) == 0))
        {
			if (pAd->MeshTab.AuthMode < Ndis802_11AuthModeWPA)
				pAd->MeshTab.WepStatus = Ndis802_11WEPEnabled;				  
		}
		else if ((strncmp(tmpbuf, "TKIP", 4) == 0) || (strncmp(tmpbuf, "tkip", 4) == 0))
		{
			if (pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
				pAd->MeshTab.WepStatus = Ndis802_11Encryption2Enabled;                       
        }
		else if ((strncmp(tmpbuf, "AES", 3) == 0) || (strncmp(tmpbuf, "aes", 3) == 0))
		{
			if (pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
				pAd->MeshTab.WepStatus = Ndis802_11Encryption3Enabled;                            
		}    
		else
		{
			pAd->MeshTab.WepStatus = Ndis802_11WEPDisabled;                 
		}
							
		DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) MeshEncrypType(%d)=%s \n", pAd->MeshTab.WepStatus, GetEncryptType(pAd->MeshTab.WepStatus)));
		RTMPMakeRSNIE(pAd, pAd->MeshTab.AuthMode, pAd->MeshTab.WepStatus, MIN_NET_DEVICE_FOR_MESH);
		
	}
	
	/*MeshWPAKEY */
	if (RTMPGetKeyParameter("MeshWPAKEY", tmpbuf, 255, buffer, TRUE))
	{
		/* The WPA KEY must be 8~64 characters */
		int success;

		success = RT_CfgSetWPAPSKKey(pAd, tmpbuf, pAd->MeshTab.MeshId, pAd->MeshTab.MeshIdLen, pAd->MeshTab.PMK);
		if (success == TRUE)
		{
			NdisMoveMemory(pAd->MeshTab.WPAPassPhraseKey, tmpbuf, strlen(tmpbuf));
			pAd->MeshTab.WPAPassPhraseKeyLen = strlen(tmpbuf);
		}
		else
		{
			DBGPRINT(RT_DEBUG_ERROR, ("I/F(mesh0) set MeshWPAKEY fail, key string required 8 ~ 64 characters!!!\n"));
		}
																				
	}

	/*MeshDefaultkey */
	if (RTMPGetKeyParameter("MeshDefaultkey", tmpbuf, 255, buffer, TRUE))
	{								
		KeyIdx = simple_strtol(tmpbuf, 0, 10);
		if((KeyIdx >= 1 ) && (KeyIdx <= 4))
			pAd->MeshTab.DefaultKeyId = (UCHAR) (KeyIdx - 1);
		else
			pAd->MeshTab.DefaultKeyId = 0;

		DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) DefaultKeyID(0~3)=%d\n", pAd->MeshTab.DefaultKeyId));		
	}

	/*MeshWEPKEY */
	if (RTMPGetKeyParameter("MeshWEPKEY", tmpbuf, 255, buffer, TRUE))
	{		    		                
		KeyLen = strlen(tmpbuf);
			
		/* Hex type */
		if((KeyLen == 10) || (KeyLen == 26))
		{
			pAd->MeshTab.SharedKey.KeyLen = KeyLen / 2;
			AtoH(tmpbuf, pAd->MeshTab.SharedKey.Key, KeyLen / 2);
			if (KeyLen == 10)
				pAd->MeshTab.SharedKey.CipherAlg = CIPHER_WEP64;
			else
				pAd->MeshTab.SharedKey.CipherAlg = CIPHER_WEP128;

			NdisMoveMemory(pAd->MeshTab.DesiredWepKey, tmpbuf, KeyLen);
			pAd->MeshTab.DesiredWepKeyLen = KeyLen;
							
			DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) MeshWEPKEY=%s, it's HEX type and %s\n", tmpbuf, (KeyLen == 10) ? "wep64":"wep128"));
		}
		/* ASCII type */
		else if ((KeyLen == 5) || (KeyLen == 13))													
		{
			pAd->MeshTab.SharedKey.KeyLen = KeyLen;
			NdisMoveMemory(pAd->MeshTab.SharedKey.Key, tmpbuf, KeyLen);
			if (KeyLen == 5)
				pAd->MeshTab.SharedKey.CipherAlg = CIPHER_WEP64;
			else
				pAd->MeshTab.SharedKey.CipherAlg = CIPHER_WEP128;

			NdisMoveMemory(pAd->MeshTab.DesiredWepKey, tmpbuf, KeyLen);
			pAd->MeshTab.DesiredWepKeyLen = KeyLen;
									
			DBGPRINT(RT_DEBUG_TRACE, ("I/F(mesh0) MeshWEPKEY=%s, it's ASCII type and %s\n", tmpbuf, (KeyLen == 5) ? "wep64":"wep128"));
		}
		/*Invalid key length */
		else
		{ 
			pAd->MeshTab.DesiredWepKeyLen = 0;
			DBGPRINT(RT_DEBUG_ERROR, ("I/F(mesh0) MeshWEPKEY is Invalid key length(%d)!\n", (UCHAR)KeyLen));
		}
	}	

	return;
}


VOID LocalMsaIeInit(
	IN PRTMP_ADAPTER pAd,
	IN INT			 idx)
{
	PMSA_HANDSHAKE_IE	pLocalMsaIe;

	/* clear the local MP's MSAIE field */
	NdisZeroMemory(pAd->MeshTab.MeshLink[idx].Entry.LocalMsaIe, MESH_MAX_MSAIE_LEN);	
	pAd->MeshTab.MeshLink[idx].Entry.LocalMsaIeLen = 0;

	pLocalMsaIe = (PMSA_HANDSHAKE_IE)pAd->MeshTab.MeshLink[idx].Entry.LocalMsaIe;


	pLocalMsaIe->MeshHSControl.word = 0;	
	if (pAd->MeshTab.bInitialMsaDone == FALSE || pAd->MeshTab.PMKID_Len == 0)
		pLocalMsaIe->MeshHSControl.field.RequestAuth = 1;	
	
	if (pAd->MeshTab.MeshLink[idx].Entry.bValidLocalMpAsSelector)
	{
		UCHAR	AuthMode = pAd->MeshTab.AuthMode;
		UCHAR	EncrypType = pAd->MeshTab.WepStatus;
	
		switch (AuthMode)
        {
           	case Ndis802_11AuthModeWPA2:            	
               	NdisMoveMemory(pLocalMsaIe->SelectedAKM, OUI_MSA_8021X_AKM, LEN_OUI_SUITE);
            break;

          	case Ndis802_11AuthModeWPA2PSK:
           		NdisMoveMemory(pLocalMsaIe->SelectedAKM, OUI_MSA_PSK_AKM, LEN_OUI_SUITE);
            break;

			/*default: */
			case Ndis802_11AuthModeWPANone:                
	            NdisMoveMemory(pLocalMsaIe->SelectedAKM, OUI_WPA_NONE_AKM, LEN_OUI_SUITE);
            break;
        }	
			
		switch (EncrypType)
        {
           	case Ndis802_11Encryption2Enabled:  
				if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
	               	NdisMoveMemory(pLocalMsaIe->SelectedPairwiseCipher, OUI_WPA_TKIP, LEN_OUI_SUITE);
				else
					NdisMoveMemory(pLocalMsaIe->SelectedPairwiseCipher, OUI_WPA2_TKIP, LEN_OUI_SUITE);
			break;

          	case Ndis802_11Encryption3Enabled:
           		if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)
	               	NdisMoveMemory(pLocalMsaIe->SelectedPairwiseCipher, OUI_WPA_CCMP, LEN_OUI_SUITE);
				else
					NdisMoveMemory(pLocalMsaIe->SelectedPairwiseCipher, OUI_WPA2_CCMP, LEN_OUI_SUITE);
            break;			
        }			
	}

	pAd->MeshTab.MeshLink[idx].Entry.LocalMsaIeLen = sizeof(MSA_HANDSHAKE_IE);

}

/* 
    ==========================================================================
    Description:
        It shall be queried about mesh security information through IOCTL     
	Arguments:
	    pAd		Pointer to our adapter
	    wrq		Pointer to the ioctl argument
    ==========================================================================
*/
VOID RTMPIoctlQueryMeshSecurityInfo(
		IN PRTMP_ADAPTER pAd, 
		IN RTMP_IOCTL_INPUT_STRUCT *wrq)
{
	UCHAR	key_len = 0;
	MESH_SECURITY_INFO	meshInfo;

	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlQueryMeshSecurityInfo==>\n"));
	
	NdisZeroMemory((PUCHAR)&meshInfo, sizeof(MESH_SECURITY_INFO));
																																	
	if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeOpen && pAd->MeshTab.WepStatus == Ndis802_11Encryption1Enabled)
		meshInfo.EncrypType = ENCRYPT_OPEN_WEP;		/* 1 - 	OPEN-WEP */
	else if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone && pAd->MeshTab.WepStatus == Ndis802_11Encryption2Enabled)
		meshInfo.EncrypType = ENCRYPT_WPANONE_TKIP;	/* 2 -	WPANONE-TKIP */
	else if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone && pAd->MeshTab.WepStatus == Ndis802_11Encryption3Enabled)
		meshInfo.EncrypType = ENCRYPT_WPANONE_AES;	/* 3 -	WPANONE-AES */
	else
		meshInfo.EncrypType = ENCRYPT_OPEN_NONE;	/* 0 - 	OPEN-NONE */

	meshInfo.KeyIndex = pAd->MeshTab.DefaultKeyId + 1;
				
	if (meshInfo.EncrypType == ENCRYPT_OPEN_WEP)
	{		
		key_len = pAd->MeshTab.DesiredWepKeyLen;		
		if (key_len > 0)
		{					
			meshInfo.KeyLength = key_len;			
			NdisMoveMemory(meshInfo.KeyMaterial, pAd->MeshTab.DesiredWepKey, key_len);
		}
	}
	else if (meshInfo.EncrypType == ENCRYPT_WPANONE_TKIP || meshInfo.EncrypType == ENCRYPT_WPANONE_AES)
	{
		key_len = pAd->MeshTab.WPAPassPhraseKeyLen;
		if (key_len > 0)
		{								
			meshInfo.KeyLength = key_len;
			NdisMoveMemory(meshInfo.KeyMaterial, pAd->MeshTab.WPAPassPhraseKey, key_len);
		}
	}
		
	wrq->u.data.length = sizeof(MESH_SECURITY_INFO);
	if (copy_to_user(wrq->u.data.pointer, &meshInfo, wrq->u.data.length))
	{
		DBGPRINT(RT_DEBUG_TRACE, ("%s: copy_to_user() fail\n", __FUNCTION__));
	}

}


/* 
    ==========================================================================
    Description:
        It shall be set mesh security through IOCTL        
	Arguments:
	    pAd		Pointer to our adapter
	    wrq		Pointer to the ioctl argument
    ==========================================================================
*/
INT RTMPIoctlSetMeshSecurityInfo(
		IN PRTMP_ADAPTER pAd, 
		IN RTMP_IOCTL_INPUT_STRUCT *wrq)
{	
	INT 	Status = NDIS_STATUS_SUCCESS;
	MESH_SECURITY_INFO	meshInfo;
	UCHAR	MeshKey[255];

	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlSetMeshSecurityInfo==>\n"));

	if (wrq->u.data.length != sizeof(MESH_SECURITY_INFO))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: the length is too large \n", __FUNCTION__));
		return -EINVAL;
	}

	if (copy_from_user(&meshInfo, wrq->u.data.pointer, wrq->u.data.length))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: copy_from_user() fail\n", __FUNCTION__));
		return -EFAULT;
	}

	/* Default security mode is OPEN-NONE */
	pAd->MeshTab.AuthMode = Ndis802_11AuthModeOpen;
	pAd->MeshTab.WepStatus = Ndis802_11EncryptionDisabled;
	NdisZeroMemory((PUCHAR)&pAd->MeshTab.SharedKey, sizeof(CIPHER_KEY));

	/* Set default key index */
	if((meshInfo.KeyIndex >= 1) && (meshInfo.KeyIndex <= 4))
		pAd->MeshTab.DefaultKeyId = meshInfo.KeyIndex - 1;
	else
		pAd->MeshTab.DefaultKeyId = 0;
		
	NdisZeroMemory(MeshKey, 255);
	if (meshInfo.KeyLength > 0)
		NdisMoveMemory(MeshKey, meshInfo.KeyMaterial, meshInfo.KeyLength);
	MeshKey[sizeof(MeshKey)-1] = 0x00;
		
	/* OPEN-WEP */
	if (meshInfo.EncrypType == ENCRYPT_OPEN_WEP)					
	{
		if (!Set_MeshWEPKEY_Proc(pAd, (PSTRING) MeshKey))
		{
			DBGPRINT(RT_DEBUG_ERROR, ("%s: Mesh WEP key isn't valid \n", __FUNCTION__));
			return -EFAULT;
		}

		pAd->MeshTab.AuthMode = Ndis802_11AuthModeOpen;
		pAd->MeshTab.WepStatus = Ndis802_11Encryption1Enabled;							
	}
	else if (meshInfo.EncrypType == ENCRYPT_WPANONE_TKIP || meshInfo.EncrypType == ENCRYPT_WPANONE_AES) 
	{
		if (!Set_MeshWPAKEY_Proc(pAd, (PSTRING) MeshKey))
		{
			DBGPRINT(RT_DEBUG_ERROR, ("%s: Mesh WPA key isn't valid \n", __FUNCTION__));
			return -EFAULT;
		}

		pAd->MeshTab.AuthMode = Ndis802_11AuthModeWPANone;
		if (meshInfo.EncrypType == ENCRYPT_WPANONE_TKIP)
			pAd->MeshTab.WepStatus = Ndis802_11Encryption2Enabled;
		else
			pAd->MeshTab.WepStatus = Ndis802_11Encryption3Enabled;

		RTMPMakeRSNIE(pAd, pAd->MeshTab.AuthMode, pAd->MeshTab.WepStatus, MIN_NET_DEVICE_FOR_MESH);
	}
			
	return Status;

}

UCHAR GetMeshSecurity(
		IN PRTMP_ADAPTER pAd)
{

	UCHAR	EncrypType = ENCRYPT_OPEN_NONE;

	if (pAd->MeshTab.AuthMode==Ndis802_11AuthModeOpen
	&& pAd->MeshTab.WepStatus == Ndis802_11WEPDisabled)
	{

	}
	else if (pAd->MeshTab.AuthMode==Ndis802_11AuthModeOpen
	&& pAd->MeshTab.WepStatus == Ndis802_11WEPEnabled)
	{

		EncrypType = ENCRYPT_OPEN_WEP;
	}
	else if (pAd->MeshTab.AuthMode==Ndis802_11AuthModeWPANone
	&& pAd->MeshTab.WepStatus == Ndis802_11Encryption2Enabled)
	{
		EncrypType = ENCRYPT_WPANONE_TKIP;
	}
	else if (pAd->MeshTab.AuthMode==Ndis802_11AuthModeWPANone
	&& pAd->MeshTab.WepStatus == Ndis802_11Encryption3Enabled)
	{
		EncrypType = ENCRYPT_WPANONE_AES;
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR, ("%s: Can not find correct mesh security ,return OPEN_NONE Auth:%d WepStatus:%d \n", __FUNCTION__
			,pAd->MeshTab.AuthMode,pAd->MeshTab.WepStatus));
	}


	return EncrypType;
}

UCHAR MeshCheckPeerMpCipher(
		IN USHORT 		 CapabilityInfo, 
		IN PUCHAR 		 pVIE,
		IN USHORT		 LenVIE)
{
	UCHAR	EncrypType = ENCRYPT_OPEN_NONE;
	
	if (CAP_IS_PRIVACY_ON(CapabilityInfo))
	{
		PUCHAR  		pVarIEs;
		USHORT			VarIELen;				
		PEID_STRUCT     pEid;

		EncrypType = ENCRYPT_OPEN_WEP;
			
		pVarIEs  = pVIE;
		VarIELen = LenVIE;
		
		while (VarIELen > 0)
		{
			pEid = (PEID_STRUCT) pVarIEs;

			if ((pEid->Eid == IE_WPA) && (VarIELen > (sizeof(RSNIE) + 2)) && (NdisEqualMemory(pEid->Octet, WPA_OUI, 4)))
			{
				RSNIE	*pRsnie;

				pRsnie = (RSNIE*)pEid->Octet;

				if(RTMPEqualMemory(OUI_WPA_TKIP, pRsnie->ucast[0].oui, 4))						
				EncrypType = ENCRYPT_WPANONE_TKIP;
				else if (RTMPEqualMemory(OUI_WPA_CCMP, pRsnie->ucast[0].oui, 4))			
				EncrypType = ENCRYPT_WPANONE_AES;			

				break;
		}
			/* For WPA2/WPA2PSK */
			
			pVarIEs   += (pEid->Len + 2);
			VarIELen  -= (pEid->Len + 2);
		}
														
	}

	return EncrypType;
}

BOOLEAN MeshAllowToSendPacket(
	IN RTMP_ADAPTER *pAd,
	IN PNDIS_PACKET pPacket,
	OUT UCHAR		*pWcid)
{
	BOOLEAN	allowed = FALSE;
	PMESH_PROXY_ENTRY	pMeshProxyEntry = NULL;
	PUCHAR pSrcBufVA = GET_OS_PKT_DATAPTR(pPacket);

	if (MESH_ON(pAd))
	{
		LONG RouteId = PathRouteIDSearch(pAd, pSrcBufVA);

		if (!MAC_ADDR_EQUAL(pAd->MeshTab.CurrentAddress, pSrcBufVA + MAC_ADDR_LEN))
		{
			if ((pAd->MeshTab.OpMode & MESH_AP) || (pAd->MeshTab.OpMode & MESH_POTAL))
			{
			pMeshProxyEntry = MeshProxyEntryTableLookUp(pAd, pSrcBufVA + MAC_ADDR_LEN);

			if (!pMeshProxyEntry)
			{
				pMeshProxyEntry = MeshProxyEntryTableInsert(pAd, pAd->MeshTab.CurrentAddress, pSrcBufVA + MAC_ADDR_LEN);
			}
		}
			else
			{
				return FALSE;
			}
		}

		if (RouteId == BMCAST_ROUTE_ID)
		{
			MeshClonePacket(pAd, pPacket, MESH_PROXY, 0);
		}
		else if (RouteId >= 0)
		{
			INT LinkId;

			LinkId = PathMeshLinkIDSearch(pAd, RouteId);
			if ((LinkId >= 0) && VALID_MESH_LINK_ID(LinkId))
			{
				*pWcid = pAd->MeshTab.MeshLink[LinkId].Entry.MacTabMatchWCID;
				RTMP_SET_MESH_ROUTE_ID(pPacket, (UINT8)RouteId);

				/* MESH_PROXY indicate the packet come from os layer to mesh0 virtual interface. */
				RTMP_SET_MESH_SOURCE(pPacket, MESH_PROXY);
				allowed = TRUE;
			}
		}
		else
		{
			/* entity is not exist. */
			/* start path discovery. */
			if (MAC_ADDR_EQUAL(pSrcBufVA + MAC_ADDR_LEN, pAd->MeshTab.CurrentAddress))
				MeshCreatePreqAction(pAd, NULL, pSrcBufVA);
			else
				MeshCreatePreqAction(pAd, pSrcBufVA + MAC_ADDR_LEN, pSrcBufVA);
		}
	}
 
	return allowed;
}

VOID PerpareMeshHeader(
	IN RTMP_ADAPTER *pAd,
	IN TX_BLK *pTxBlk,
	OUT PMESH_FLAG pMeshFlag,
	OUT UINT16 *pMeshTTL,
	OUT UINT32 *pMeshSeq,
	OUT PUCHAR *ppMeshAddr5,
	OUT PUCHAR *ppMeshAddr6)
{
	UINT MeshHdrLen = 0;
	PNDIS_PACKET pPacket = pTxBlk->pPacket;
	PUCHAR pSrcBufVA = GET_OS_PKT_DATAPTR(pPacket);
	UINT8 TXWISize = pAd->chipCap.TXWISize;
	PHEADER_802_11 pHeader_802_11 = (PHEADER_802_11)&pTxBlk->HeaderBuf[TXINFO_SIZE + pAd->chipCap.TXWISize];

	if (RTMP_GET_MESH_SOURCE(pPacket) == MESH_PROXY)
	{
		pMeshFlag->word = 0;
		*pMeshTTL = pAd->MeshTab.TTL;
		*pMeshSeq = INC_MESH_SEQ(pAd->MeshTab.MeshSeq);
		if (( (*pSrcBufVA & 0x01) /* B/Mcast packet. */
				|| MAC_ADDR_EQUAL(pSrcBufVA, pHeader_802_11->Addr3)) /* or DA is a MP. */
			&& MAC_ADDR_EQUAL(pSrcBufVA + MAC_ADDR_LEN, pAd->MeshTab.CurrentAddress))
		{	
			pMeshFlag->field.AE = 0;
			*ppMeshAddr5 = NULL;
			*ppMeshAddr6 = NULL;
		}
		else
		{
			pMeshFlag->field.AE = 2;
			*ppMeshAddr5 = pSrcBufVA;
			*ppMeshAddr6 = pSrcBufVA + MAC_ADDR_LEN;
		}
	}
	else
	{
		pSrcBufVA += LENGTH_802_3;
		MeshHdrLen = GetMeshHederLen(pSrcBufVA);
		pMeshFlag->word = GetMeshFlag(pSrcBufVA);
		*pMeshTTL = GetMeshTTL(pSrcBufVA) - 1;
		*pMeshSeq = GetMeshSeq(pSrcBufVA);
		*ppMeshAddr5 = GetMeshAddr5(pSrcBufVA);
		*ppMeshAddr6 = GetMeshAddr6(pSrcBufVA);

		if (NdisEqualMemory(SNAP_802_1H, pTxBlk->pSrcBufData + MeshHdrLen, 6)  || NdisEqualMemory(SNAP_BRIDGE_TUNNEL, pTxBlk->pSrcBufData + MeshHdrLen, 6))             
		{
			/* skip Mesh header and LLC Header (8 Bytes). */
			pTxBlk->pSrcBufData = pTxBlk->pSrcBufData + MeshHdrLen + 8;
			pTxBlk->SrcBufLen  -= (MeshHdrLen + 8);
		}
		else
		{
			pTxBlk->pSrcBufData = pTxBlk->pSrcBufData + MeshHdrLen;
			pTxBlk->SrcBufLen  -= (MeshHdrLen);		
		}
	}

	return;
}

BOOLEAN MeshChCheck(
	IN RTMP_ADAPTER *pAd,
	IN PMESH_NEIGHBOR_ENTRY pNeighborEntry)
{
	BOOLEAN result = FALSE;
	
#ifdef DOT11_N_SUPPORT
	if ((pAd->CommonCfg.PhyMode >= PHY_11ABGN_MIXED)
		&& (pAd->CommonCfg.RegTransmitSetting.field.BW == BW_40)
		&& (pAd->CommonCfg.AddHTInfo.AddHtInfo.RecomWidth == BW_40)
		&& (pNeighborEntry->ChBW == BW_40)
		)
	{
		result = ((pNeighborEntry->Channel == pAd->CommonCfg.Channel)
					&& (pNeighborEntry->ChBW == pAd->CommonCfg.AddHTInfo.AddHtInfo.RecomWidth)
					&& (pNeighborEntry->ExtChOffset == pAd->CommonCfg.AddHTInfo.AddHtInfo.ExtChanOffset)) ? TRUE : FALSE;
	}
	else
#endif /* DOT11_N_SUPPORT */
	{	
		result = (pNeighborEntry->Channel == pAd->CommonCfg.Channel) ? TRUE : FALSE;
	}


	return result;
}

/*
	==========================================================================
	Description:
		Pre-build a BEACON frame in the shared memory
	==========================================================================
*/
VOID MeshMakeBeacon(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR			idx)
{
	UCHAR DsLen = 1, SsidLen;
	UCHAR RSNIe=IE_WPA;
	HEADER_802_11 BcnHdr;
	LARGE_INTEGER FakeTimestamp;
	ULONG FrameLen = 0;
	PTXWI_STRUC pTxWI = &pAd->BeaconTxWI;
	PUCHAR pBeaconFrame = (PUCHAR)pAd->MeshTab.BeaconBuf;
	UCHAR *ptr;
	UINT i;
	UINT32 longValue;
	UCHAR ASupRate[] = {0x8C, 0x12, 0x98, 0x24, 0xb0, 0x48, 0x60, 0x6C};
	UCHAR ASupRateLen = sizeof(ASupRate)/sizeof(UCHAR);
	ULONG TmpLen;
	HTTRANSMIT_SETTING BeaconTransmit;   /* MGMT frame PHY rate setting when operatin at Ht rate. */
	UINT8 TXWISize = pAd->chipCap.TXWISize;

	/* ignore SSID for MP. Refer to IEEE 802.11s-D1.06 */
	SsidLen = 0;

	if (pAd->MeshTab.bBcnSntReq == FALSE)
		return;


	DBGPRINT(RT_DEBUG_TRACE, ("MeshMakeBeacon - %02x:%02x:%02x:%02x:%02x:%02x\n", PRINT_MAC(pAd->MeshTab.CurrentAddress)));
	MgtMacHeaderInit(pAd, &BcnHdr, SUBTYPE_BEACON, 0, BROADCAST_ADDR, 
#ifdef P2P_SUPPORT
						pAd->MeshTab.CurrentAddress,
#endif /* P2P_SUPPORT */
						pAd->MeshTab.CurrentAddress);

	if (pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPANone)		
		RSNIe = IE_WPA;
	else if ((pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPA2) || 
			(pAd->MeshTab.AuthMode == Ndis802_11AuthModeWPA2PSK))
		RSNIe = IE_WPA2;
	
	/* for update framelen to TxWI later. */
	MakeOutgoingFrame(pBeaconFrame,                  &FrameLen,
					sizeof(HEADER_802_11),           &BcnHdr, 
					TIMESTAMP_LEN,                   &FakeTimestamp,
					2,                               &pAd->CommonCfg.BeaconPeriod,
					2,                               &pAd->MeshTab.CapabilityInfo,
					1,                               &SsidIe, 
					1,                               &SsidLen,
					END_OF_ARGS);

	if (pAd->CommonCfg.Channel <= 14)
	{
		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
					1,                               &SupRateIe, 
					1,                               &pAd->CommonCfg.SupRateLen,
					pAd->CommonCfg.SupRateLen,       pAd->CommonCfg.SupRate, 
						END_OF_ARGS);
		FrameLen += TmpLen;
	}
	else
	{
		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
						1,                               &SupRateIe, 
						1,                               &ASupRateLen,
						pAd->CommonCfg.SupRateLen,       ASupRate, 
						END_OF_ARGS);
		FrameLen += TmpLen;
	}

	MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
					1,                               &DsIe, 
					1,                               &DsLen, 
					1,                               &pAd->MeshTab.MeshChannel,
					END_OF_ARGS);
	FrameLen += TmpLen;

	if ((pAd->CommonCfg.Channel <= 14)
		&& (pAd->CommonCfg.ExtRateLen))
	{
		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
						1,                               &ExtRateIe, 
						1,                               &pAd->CommonCfg.ExtRateLen,
						pAd->CommonCfg.ExtRateLen,           pAd->CommonCfg.ExtRate, 
						END_OF_ARGS);
		FrameLen += TmpLen;
	}

	/* Append RSN_IE when  WPA OR WPAPSK, */
	if (pAd->MeshTab.AuthMode >= Ndis802_11AuthModeWPA)
	{
		MakeOutgoingFrame(pBeaconFrame+FrameLen,        &TmpLen,
						  1,                            &RSNIe,
						  1,                            &pAd->MeshTab.RSNIE_Len,
						  pAd->MeshTab.RSNIE_Len,      	pAd->MeshTab.RSN_IE,
						  END_OF_ARGS);
		FrameLen += TmpLen;
	}
        
#ifdef DOT11_N_SUPPORT
	/* AP Channel Report */
	if (pAd->CommonCfg.PhyMode == PHY_11BGN_MIXED
		&& ((pAd->CommonCfg.HT_DisallowTKIP == FALSE)
			|| (pAd->CommonCfg.HT_DisallowTKIP
				&& !IS_INVALID_HT_SECURITY(pAd->MeshTab.WepStatus))) 
		) /*wayne_note */
	{
		UCHAR APChannelReportIe = IE_AP_CHANNEL_REPORT;
		ULONG	TmpLen;

		/* 802.11n D2.0 Annex J */
		/* USA */
		/* regulatory class 32, channel set 1~7 */
		/* regulatory class 33, channel set 5-11 */

		UCHAR rclass32[]={32, 1, 2, 3, 4, 5, 6, 7};
        UCHAR rclass33[]={33, 5, 6, 7, 8, 9, 10, 11};
		UCHAR rclasslen = 8; /*sizeof(rclass32); */

		
			MakeOutgoingFrame(pBeaconFrame+FrameLen,&TmpLen,
							  1,                    &APChannelReportIe,
							  1,                    &rclasslen,
							  rclasslen,            rclass32,
   							  1,                    &APChannelReportIe,
							  1,                    &rclasslen,
							  rclasslen,            rclass33,
							  END_OF_ARGS);
			FrameLen += TmpLen;		
		}
#endif /* DOT11_N_SUPPORT */
    
	BeaconTransmit.word = 0;
	RTMPWriteTxWI(pAd, pTxWI, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, 0, BSS0Mcast_WCID, 
		FrameLen, PID_MGMT, 0, 0,IFS_HTTXOP, FALSE, &BeaconTransmit);
	/* */
	/* step 6. move BEACON TXD and frame content to on-chip memory */
	/* */
	ptr = (PUCHAR)&pAd->BeaconTxWI;
#ifdef RT_BIG_ENDIAN
    RTMPWIEndianChange(pAd, ptr, TYPE_TXWI);
#endif


	for (i=0; i<TXWISize; i+=4)
	{
		longValue =  *ptr + (*(ptr+1)<<8) + (*(ptr+2)<<16) + (*(ptr+3)<<24);
		RTMP_CHIP_UPDATE_BEACON(pAd, pAd->BeaconOffset[idx] + i, longValue, 4);
		ptr +=4;
	}


	/* update BEACON frame content. start right after the 24-byte TXINFO field */
	ptr = (PUCHAR)pAd->MeshTab.BeaconBuf;
#ifdef RT_BIG_ENDIAN
    RTMPFrameEndianChange(pAd, ptr, DIR_WRITE, FALSE);
#endif


	for (i= 0; i< FrameLen; i+=4)
	{
		longValue =  *ptr + (*(ptr+1)<<8) + (*(ptr+2)<<16) + (*(ptr+3)<<24);
		RTMP_CHIP_UPDATE_BEACON(pAd, pAd->BeaconOffset[idx] + TXWISize + i, longValue, 4);
		ptr += 4;
	}


	pAd->MeshTab.TimIELocationInBeacon = (UCHAR)FrameLen; 
	pAd->MeshTab.CapabilityInfoLocationInBeacon = sizeof(HEADER_802_11) + TIMESTAMP_LEN + 2;


#ifdef CONFIG_STA_SUPPORT
	RTMP_IO_READ32(pAd, MAC_BSSID_DW1, &longValue);
	longValue &= 0x0000FFFF;
	RTMP_IO_WRITE32(pAd, MAC_BSSID_DW1, longValue);
#endif /* CONFIG_STA_SUPPORT */

}

/*
	==========================================================================
	Description:
		Update the BEACON frame in the shared memory. Because TIM IE is variable
		length. other IEs after TIM has to shift and total frame length may change
		for each BEACON period.
	Output:
		pAd->ApCfg.MBSSID[apidx].CapabilityInfo
		pAd->ApCfg.ErpIeContent
	==========================================================================
*/
VOID MeshUpdateBeaconFrame(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR			idx) 
{
	/*PTXWI_STRUC pTxWI = &pAd->BeaconTxWI; */
	PUCHAR pBeaconFrame = (PUCHAR)pAd->MeshTab.BeaconBuf;
	UCHAR *ptr;
	ULONG FrameLen = pAd->MeshTab.TimIELocationInBeacon;
	ULONG UpdatePos = pAd->MeshTab.TimIELocationInBeacon;
	/*UCHAR RSNIe=IE_WPA, RSNIe2=IE_WPA2; */
	/*UCHAR ID_1B, TimFirst, TimLast, *pTim; */
	HTTRANSMIT_SETTING BeaconTransmit;   /* MGMT frame PHY rate setting when operatin at Ht rate. */

	if (pAd->MeshTab.bBcnSntReq == FALSE)
		return;

	/* The beacon of mesh isn't be initialized */
	if (FrameLen == 0)
		return;

	/* */
	/* step 1 - update BEACON's Capability */
	/* */
	ptr = pBeaconFrame + pAd->MeshTab.CapabilityInfoLocationInBeacon;
	*ptr = (UCHAR)(pAd->MeshTab.CapabilityInfo & 0x00ff);
	*(ptr+1) = (UCHAR)((pAd->MeshTab.CapabilityInfo & 0xff00) >> 8);

#ifdef DOT11_N_SUPPORT
	/* */
	/* step 5. Update HT. Since some fields might change in the same BSS. */
	/* */
	if ((pAd->CommonCfg.PhyMode >= PHY_11ABGN_MIXED) 
		&& ((pAd->CommonCfg.HT_DisallowTKIP == FALSE)
		|| (pAd->CommonCfg.HT_DisallowTKIP
			&& !IS_INVALID_HT_SECURITY(pAd->MeshTab.WepStatus))) 
	) /*wayne_note */
	{
		ULONG TmpLen;
		UCHAR HtLen, HtLen1;
		/*UCHAR i; */

#ifdef RT_BIG_ENDIAN
		HT_CAPABILITY_IE HtCapabilityTmp;
		ADD_HT_INFO_IE	addHTInfoTmp;
		USHORT	b2lTmp, b2lTmp2;
#endif

		/* add HT Capability IE */
		HtLen = sizeof(pAd->CommonCfg.HtCapability);
		HtLen1 = sizeof(pAd->CommonCfg.AddHTInfo);
#ifndef RT_BIG_ENDIAN
		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
								  1,                                &HtCapIe,
								  1,                                &HtLen,
								 HtLen,          &pAd->CommonCfg.HtCapability, 
								  1,                                &AddHtInfoIe,
								  1,                                &HtLen1,
								 HtLen1,          &pAd->CommonCfg.AddHTInfo, 
						  END_OF_ARGS);
#else
		NdisMoveMemory(&HtCapabilityTmp, &pAd->CommonCfg.HtCapability, HtLen);
		*(USHORT *)(&HtCapabilityTmp.HtCapInfo) = SWAP16(*(USHORT *)(&HtCapabilityTmp.HtCapInfo));
		*(USHORT *)(&HtCapabilityTmp.ExtHtCapInfo) = SWAP16(*(USHORT *)(&HtCapabilityTmp.ExtHtCapInfo));

		NdisMoveMemory(&addHTInfoTmp, &pAd->CommonCfg.AddHTInfo, HtLen1);
		*(USHORT *)(&addHTInfoTmp.AddHtInfo2) = SWAP16(*(USHORT *)(&addHTInfoTmp.AddHtInfo2));
		*(USHORT *)(&addHTInfoTmp.AddHtInfo3) = SWAP16(*(USHORT *)(&addHTInfoTmp.AddHtInfo3));

		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
								  1,                                &HtCapIe,
								  1,                                &HtLen,
								 HtLen,                   &HtCapabilityTmp, 
								  1,                                &AddHtInfoIe,
								  1,                                &HtLen1,
								 HtLen1,                   &addHTInfoTmp, 
						  END_OF_ARGS);
#endif
		FrameLen += TmpLen;

	}
#endif /* DOT11_N_SUPPORT */


#ifdef DOT11_N_SUPPORT
	if ((pAd->CommonCfg.PhyMode >= PHY_11ABGN_MIXED)
		&& ((pAd->CommonCfg.HT_DisallowTKIP == FALSE)
 		|| (pAd->CommonCfg.HT_DisallowTKIP 
			&& !IS_INVALID_HT_SECURITY(pAd->MeshTab.WepStatus))) 
		)/*wayne_note */
	{
		ULONG TmpLen;
		UCHAR HtLen, HtLen1;
		/*UCHAR i; */
#ifdef RT_BIG_ENDIAN
		HT_CAPABILITY_IE HtCapabilityTmp;
		ADD_HT_INFO_IE	addHTInfoTmp;
		USHORT	b2lTmp, b2lTmp2;
#endif
		/* add HT Capability IE */
		HtLen = sizeof(pAd->CommonCfg.HtCapability);
		HtLen1 = sizeof(pAd->CommonCfg.AddHTInfo);

		if (pAd->bBroadComHT == TRUE)
		{
			UCHAR epigram_ie_len;
			UCHAR BROADCOM_HTC[4] = {0x0, 0x90, 0x4c, 0x33};
			UCHAR BROADCOM_AHTINFO[4] = {0x0, 0x90, 0x4c, 0x34};


			epigram_ie_len = HtLen + 4;
#ifndef RT_BIG_ENDIAN
			MakeOutgoingFrame(pBeaconFrame + FrameLen,      &TmpLen,
						  1,                                &WpaIe,
						  1,                                &epigram_ie_len,
						  4,                                &BROADCOM_HTC[0],
						  HtLen,          					&pAd->CommonCfg.HtCapability, 
						  END_OF_ARGS);
#else
			NdisMoveMemory(&HtCapabilityTmp, &pAd->CommonCfg.HtCapability, HtLen);
			*(USHORT *)(&HtCapabilityTmp.HtCapInfo) = SWAP16(*(USHORT *)(&HtCapabilityTmp.HtCapInfo));
			*(USHORT *)(&HtCapabilityTmp.ExtHtCapInfo) = SWAP16(*(USHORT *)(&HtCapabilityTmp.ExtHtCapInfo));

			MakeOutgoingFrame(pBeaconFrame + FrameLen,       &TmpLen,
						1,                               &WpaIe,
						1,                               &epigram_ie_len,
						4,                               &BROADCOM_HTC[0], 
						HtLen,                           &HtCapabilityTmp,
						END_OF_ARGS);
#endif

			FrameLen += TmpLen;

			epigram_ie_len = HtLen1 + 4;
#ifndef RT_BIG_ENDIAN
			MakeOutgoingFrame(pBeaconFrame + FrameLen,        &TmpLen,
						  1,                                &WpaIe,
						  1,                                &epigram_ie_len,
						  4,                                &BROADCOM_AHTINFO[0],
						  HtLen1, 							&pAd->CommonCfg.AddHTInfo, 
						  END_OF_ARGS);
#else
			NdisMoveMemory(&addHTInfoTmp, &pAd->CommonCfg.AddHTInfo, HtLen1);
			*(USHORT *)(&addHTInfoTmp.AddHtInfo2) = SWAP16(*(USHORT *)(&addHTInfoTmp.AddHtInfo2));
			*(USHORT *)(&addHTInfoTmp.AddHtInfo3) = SWAP16(*(USHORT *)(&addHTInfoTmp.AddHtInfo3));

			MakeOutgoingFrame(pBeaconFrame + FrameLen,         &TmpLen,
							1,                             &WpaIe,
							1,                             &epigram_ie_len,
							4,                             &BROADCOM_AHTINFO[0],
							HtLen1,                        &addHTInfoTmp,
							END_OF_ARGS);
#endif
			FrameLen += TmpLen;
		}

	}

	/* P802.11n_D1.10 */
	/* 7.3.2.27 Extended Capabilities IE */
	/* HT Information Exchange Support */
	if ((pAd->CommonCfg.PhyMode >= PHY_11ABGN_MIXED)
		&& ((pAd->CommonCfg.HT_DisallowTKIP == FALSE) 
		|| (pAd->CommonCfg.HT_DisallowTKIP 
			&& !IS_INVALID_HT_SECURITY(pAd->MeshTab.WepStatus))) 
		) /*wayne_note */
	{
		ULONG TmpLen;
		UCHAR ExtCapIe[3] = {IE_EXT_CAPABILITY, 1, 0x01};
		MakeOutgoingFrame(pBeaconFrame+FrameLen, &TmpLen,
							3,                   ExtCapIe,
							END_OF_ARGS);
		FrameLen += TmpLen;

	}
#endif /* DOT11_N_SUPPORT */

   	/* add Ralink-specific IE here - Byte0.b0=1 for aggregation, Byte0.b1=1 for piggy-back */
   	if ((pAd->CommonCfg.HT_DisallowTKIP == FALSE) || (pAd->CommonCfg.HT_DisallowTKIP && !IS_INVALID_HT_SECURITY(pAd->MeshTab.WepStatus)))	
	{/*wayne_note */
		ULONG TmpLen;
		UCHAR RalinkSpecificIe[9] = {IE_VENDOR_SPECIFIC, 7, 0x00, 0x0c, 0x43, 0x00, 0x00, 0x00, 0x00};

		if (pAd->CommonCfg.bAggregationCapable)
			RalinkSpecificIe[5] |= 0x1;
		if (pAd->CommonCfg.bPiggyBackCapable)
			RalinkSpecificIe[5] |= 0x2;
#ifdef DOT11_N_SUPPORT
		if (pAd->CommonCfg.bRdg)
			RalinkSpecificIe[5] |= 0x4;
#endif /* DOT11_N_SUPPORT */
		MakeOutgoingFrame(pBeaconFrame+FrameLen, &TmpLen,
							9,                   RalinkSpecificIe,
							END_OF_ARGS);
		FrameLen += TmpLen;
	}
	
	/* Insert MeshIDIE and MeshConfigurationIE in Beacon frame */
	/*if (MeshValid(&pAd->MeshTab)) */
	{
		pAd->MeshTab.MeshCapability.field.AcceptPeerLinks = MeshAcceptPeerLink(pAd);
		InsertMeshIdIE(pAd, pBeaconFrame+FrameLen, &FrameLen);
		InsertMeshConfigurationIE(pAd, pBeaconFrame+FrameLen, &FrameLen, FALSE);
		InsertMeshHostNameIE(pAd, pBeaconFrame+FrameLen, &FrameLen);
	}
	
	/* Insert MSCIE */
	InsertMSCIE(pAd, pBeaconFrame+FrameLen, &FrameLen);
	
	/* */
	/* step 6. Since FrameLen may change, update TXWI. */
	/* */
	/* Update in real buffer */
	/* Update sw copy. */
	if (pAd->CommonCfg.Channel <= 14)
		BeaconTransmit.word = 0;
	else
		BeaconTransmit.word = 0x4000;
	
	RTMPWriteTxWI(pAd, &pAd->BeaconTxWI, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, 0, 0xff, 
		FrameLen, PID_MGMT, QID_MGMT, 0, IFS_HTTXOP, FALSE, &BeaconTransmit);
	/* */
	/* step 7. move BEACON TXWI and frame content to on-chip memory */
	/* */
	RT28xx_UpdateBeaconToAsic(pAd, idx + MIN_NET_DEVICE_FOR_MESH, FrameLen, UpdatePos);
}

VOID MeshCleanBeaconFrame(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR			idx) 
{
	INT i;
	UINT8 TXWISize = pAd->chipCap.TXWISize;


	/* when the ra interface is down, do not send its beacon frame */
	/* clear all zero */
	for(i=0; i < TXWISize; i+=4)
		RTMP_CHIP_UPDATE_BEACON(pAd, pAd->BeaconOffset[idx] + i, 0, 4);



}

/*
	==========================================================================
	Description:
	Note: 
		BEACON frame in shared memory should be built ok before this routine
		can be called. Otherwise, a garbage frame maybe transmitted out every
		Beacon period.
 
	==========================================================================
 */
VOID AsicEnableMESHSync(
	IN PRTMP_ADAPTER pAd)
{
	BCN_TIME_CFG_STRUC csr;

	RTMP_IO_READ32(pAd, BCN_TIME_CFG, &csr.word);

	
	/* start sending BEACON */
	csr.field.BeaconInterval = pAd->CommonCfg.BeaconPeriod << 4; /* ASIC register in units of 1/16 TU */
	csr.field.bTsfTicking = 1;
	csr.field.TsfSyncMode = 3; /* sync TSF in IBSS mode */
	csr.field.bTBTTEnable = 1;
	csr.field.bBeaconGen = 1;
	RTMP_IO_WRITE32(pAd, BCN_TIME_CFG, csr.word);
}

#ifdef CONFIG_STA_SUPPORT
BOOLEAN MeshWirelessForward(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket,
	IN	ULONG			FromWhichBSSID)
{
    BOOLEAN			bAnnounce, bDirectForward;
	UCHAR			*pHeader802_3;
	PNDIS_PACKET	pForwardPacket = NULL;
	PNDIS_PACKET	pMeshForwardPacket = NULL;

	if (FromWhichBSSID < MIN_NET_DEVICE_FOR_MESH)
		return TRUE;

	pHeader802_3 = GET_OS_PKT_DATAPTR(pPacket);

		MeshDataPktProcess(pAd, pPacket, (FromWhichBSSID - MIN_NET_DEVICE_FOR_MESH),
							&pMeshForwardPacket, &bDirectForward, &bAnnounce);

	if (bDirectForward)
	{
		LONG RouteId;

		/* build an NDIS packet */
		if ((bDirectForward == TRUE) && (bAnnounce == TRUE))
			pForwardPacket = pMeshForwardPacket;
		else
			pForwardPacket = DuplicatePacket(get_netdev_from_bssid(pAd, FromWhichBSSID),
											pPacket, FromWhichBSSID);

		if (pForwardPacket == NULL)
			return bAnnounce;

		RouteId = PathRouteIDSearch(pAd, pHeader802_3);
			if (RouteId == BMCAST_ROUTE_ID)
			{
				MeshClonePacket(pAd, pForwardPacket, MESH_FORWARD, (FromWhichBSSID - MIN_NET_DEVICE_FOR_MESH));
				/* release packet */
				RELEASE_NDIS_PACKET(pAd, pForwardPacket, NDIS_STATUS_SUCCESS);
			}
			else if (RouteId >= 0)
			{
				INT LinkId;

				LinkId = PathMeshLinkIDSearch(pAd, RouteId);
				if ((LinkId >= 0) && VALID_MESH_LINK_ID(LinkId))
				{
					RTMP_SET_PACKET_NET_DEVICE_MESH(pForwardPacket, 0);
					RTMP_SET_PACKET_SOURCE(pForwardPacket, PKTSRC_NDIS);
					RTMP_SET_PACKET_MOREDATA(pForwardPacket, FALSE);
					RTMP_SET_PACKET_WCID(pForwardPacket,
											pAd->MeshTab.MeshLink[LinkId].Entry.MacTabMatchWCID);
					RTMP_SET_MESH_ROUTE_ID(pForwardPacket, RouteId);
					RTMP_SET_MESH_SOURCE(pForwardPacket, MESH_FORWARD);
					STASendPacket(pAd, pForwardPacket);
				}
				else
				{
					/* release packet */
					RELEASE_NDIS_PACKET(pAd, pForwardPacket, NDIS_STATUS_FAILURE);
				}
			}
			else
			{
				/* entity is not exist. */
				/* start path discovery. */
				MeshCreatePreqAction(pAd, NULL, pHeader802_3);

				/* release packet */
				RELEASE_NDIS_PACKET(pAd, pForwardPacket, NDIS_STATUS_FAILURE);
			}

		/* Dequeue outgoing frames from TxSwQueue[] and process it */
		RTMPDeQueuePacket(pAd, FALSE, NUM_OF_TX_RING, MAX_TX_PROCESS);
	}
	
	return bAnnounce;
}
#endif /* CONFIG_STA_SUPPORT */

UINT32 MeshAirLinkTime(
	IN PRTMP_ADAPTER pAd,
	IN PMAC_TABLE_ENTRY pMacEntry,
	IN HTTRANSMIT_SETTING HTTxMode)
{

typedef struct __TX_RATE
{
	UINT8 PhyMode;
	UINT8 MCS;
	UINT8 RateIdx;
	ULONG DataRate;
} _TX_RATE;

_TX_RATE TxRate[] =
{
	{MODE_CCK,    0,   0, 10}, /* 1 Mbps */
	{MODE_CCK,    1,   1, 20}, /* 2 Mbps */
	{MODE_CCK,    2,   2, 55}, /* 5.5 Mbps */
	{MODE_CCK,    3,   3, 110}, /* 11 Mbps */

	{MODE_OFDM,   0,   4, 60}, /* 6 Mbps */
	{MODE_OFDM,   1,   5, 90}, /* 9 Mbps */
	{MODE_OFDM,   2,   6, 120}, /* 12 Mbps */
	{MODE_OFDM,   3,   7, 180}, /* 18 Mbps */
	{MODE_OFDM,   4,   8, 240}, /* 24 Mbps */
	{MODE_OFDM,   5,   9, 360}, /* 36 Mbps */
	{MODE_OFDM,   6,  10, 480}, /* 48 Mbps */
	{MODE_OFDM,   7,  11, 540}, /* 54 Mbps */

#ifdef DOT11_N_SUPPORT
	{MODE_HTMIX,  0,  12, 65}, /* 6.5 Mbps */
	{MODE_HTMIX,  1,  13, 130}, /* 13 Mbps */
	{MODE_HTMIX,  2,  14, 195}, /* 19.5 Mbps */
	{MODE_HTMIX,  3,  15, 260}, /* 26 Mbps */
	{MODE_HTMIX,  4,  16, 390}, /* 39 Mbps */
	{MODE_HTMIX,  5,  17, 520}, /* 52 Mbps */
	{MODE_HTMIX,  6,  18, 585}, /* 58.5 Mbps */
	{MODE_HTMIX,  7,  19, 650}, /* 65 Mbps */
	{MODE_HTMIX,  8,  20, 130}, /* 13 Mbps */
	{MODE_HTMIX,  9,  21, 260}, /* 26 Mbps */
	{MODE_HTMIX, 10,  22, 390}, /* 39 Mbps */
	{MODE_HTMIX, 11,  23, 520}, /* 52 Mbps */
	{MODE_HTMIX, 12,  24, 780}, /* 78 Mbps */
	{MODE_HTMIX, 13,  25, 1040}, /* 104 Mbps */
	{MODE_HTMIX, 14,  26, 1170}, /* 117 Mbps */
	{MODE_HTMIX, 15,  27, 1300}, /* 130 Mbps */
#endif /* DOT11_N_SUPPORT */
};
#define _TX_RATE_TAB_SIZE (sizeof(TxRate) /  sizeof(_TX_RATE))

	INT loopIdx;
	ULONG Rate = 10;
	ULONG ErrRate = 0;
	UINT PhyMode;
	ULONG Metric;
	ULONG PhyOverHead;

	PhyMode = HTTxMode.field.MODE;
#ifdef DOT11_N_SUPPORT
	PhyMode = (HTTxMode.field.MODE > MODE_HTMIX) ?
					MODE_HTMIX : HTTxMode.field.MODE;
#endif /* DOT11_N_SUPPORT */

	for (loopIdx = 0; loopIdx < _TX_RATE_TAB_SIZE; loopIdx++)
	{
		if ((TxRate[loopIdx].PhyMode == HTTxMode.field.MODE)
			&& (TxRate[loopIdx].MCS == HTTxMode.field.MCS))
		{
			Rate = TxRate[loopIdx].DataRate;
			if (pMacEntry != NULL)
				ErrRate = pMacEntry->PER[TxRate[loopIdx].RateIdx] >= 100
							? 99 : pMacEntry->PER[TxRate[loopIdx].RateIdx];
			else
				ErrRate = 0;
			break;
		}
	}

#ifdef DOT11_N_SUPPORT
	if ((PhyMode > MODE_OFDM)
			&& (HTTxMode.field.BW == 1))
	{
		Rate *= 2;
	}
#endif /* DOT11_N_SUPPORT */

	if (PhyMode == MODE_CCK)
		PhyOverHead = 335 + 346;
	else
		PhyOverHead = 75 + 110;

	Metric = (PhyOverHead + (8192 * 10 / Rate)) * (100 /(100 - ErrRate));

	return Metric;
}

UINT32 MESH_LinkMetricUpdate(
	IN PRTMP_ADAPTER pAd,
	IN PCHAR pDestAddr)
{
	PMAC_TABLE_ENTRY pEntry;
	HTTRANSMIT_SETTING HTTxMode;
	ULONG Idx = GetMeshLinkId(pAd, pDestAddr);

	pEntry = MacTableLookup(pAd, (PUCHAR)pDestAddr);
	if (pEntry == NULL)
		HTTxMode.word = pAd->CommonCfg.MlmeTransmit.word;
	else 
		HTTxMode.word = pEntry->HTPhyMode.word;

	if (Idx < MAX_MESH_LINKS)
		pAd->MeshTab.MeshLink[Idx].Entry.Metrics =
			MeshAirLinkTime(pAd, pEntry, HTTxMode);

	return pAd->MeshTab.MeshLink[Idx].Entry.Metrics;
}

VOID EnqueuePeerLinkMetricReport(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR pDestAddr,
	IN UINT32 Metric)
{
	HEADER_802_11 MeshHdr;
	PUCHAR pOutBuffer = NULL;
	NDIS_STATUS NStatus;
	ULONG FrameLen;
	MESH_FLAG MeshFlag;
	UINT32 MeshSeq = INC_MESH_SEQ(pAd->MeshTab.MeshSeq);

	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  /*Get an unused nonpaged memory */
	if(NStatus != NDIS_STATUS_SUCCESS)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("%s() allocate memory failed \n", __FUNCTION__));
		return;
	}

	MeshHeaderInit(pAd, &MeshHdr,
		pDestAddr,		/* addr1 */
		pAd->MeshTab.CurrentAddress,							/* addr2 */
		ZERO_MAC_ADDR);		/* addr3 */
	NdisMoveMemory(pOutBuffer, (PCHAR)&MeshHdr, sizeof(HEADER_802_11));
	FrameLen = sizeof(HEADER_802_11);

	/* Mesh Header */
	MeshFlag.word = 0;
	MeshFlag.field.AE = 0;	/* Peer-Link manager frame never carry 6 addresses. */
	InsertMeshHeader(pAd, (pOutBuffer + FrameLen), &FrameLen, MeshFlag.word,
		pAd->MeshTab.TTL, MeshSeq, NULL, NULL, NULL);

	/* Action field */
	InsertMeshActField(pAd, (pOutBuffer + FrameLen), &FrameLen, CATEGORY_MESH_LINK_METRIC, ACT_CODE_LINK_METRIC_REP);

	/* Insert Link Metric Report IE */
	InsertLinkMetricReportIE(pAd, (pOutBuffer+FrameLen), &FrameLen, Metric);

	MiniportMMRequest(pAd, QID_AC_BE, pOutBuffer, FrameLen);
	MlmeFreeMemory(pAd, pOutBuffer);

	DBGPRINT(RT_DEBUG_TRACE, ("%s: Dest address(%02x:%02x:%02x:%02x:%02x:%02x)\n",
		__FUNCTION__, pDestAddr[0], pDestAddr[1], pDestAddr[2], 
		pDestAddr[4], pDestAddr[4], pDestAddr[5]));

	return;
}

VOID MeshPeerLinkMetricReportProcess(
	IN PRTMP_ADAPTER pAd,
	IN RX_BLK *pRxBlk)
{
	PHEADER_802_11 pHeader = (PHEADER_802_11)pRxBlk->pHeader;
	PUCHAR pFrame;
	ULONG FrameLen;
	UINT MeshLinkId = 0;
	UINT32 LinkMetric;

	do 
	{
		ULONG Idx;
		UCHAR MeshHdrLen;

		Idx = GetMeshLinkId(pAd, (PCHAR)pHeader->Addr2);
		if (Idx == BSS_NOT_FOUND)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("%s() Link Metric Report Ignore, PeerLink Not found.\n", __FUNCTION__));
			return;
		}
		MeshLinkId = (UINT)Idx;

		MeshHdrLen = GetMeshHederLen(pRxBlk->pData);
		/* skip Mesh Header */
		pRxBlk->pData += MeshHdrLen;
		pRxBlk->DataSize -= MeshHdrLen;

		/* skip Category and ActionCode */
		pFrame = (PUCHAR)(pRxBlk->pData + 2);
		FrameLen = pRxBlk->DataSize - 2;

		MeshLinkMetricReportSanity(	pAd,
							pFrame,
							FrameLen,
							&LinkMetric);

		DBGPRINT(RT_DEBUG_TRACE, ("%s: LinkMetric=%d, PeerMac=%02x:%02x:%02x:%02x:%02x:%02x\n",
			__FUNCTION__, LinkMetric, pHeader->Addr2[0], pHeader->Addr2[1],
			pHeader->Addr2[2], pHeader->Addr2[3], pHeader->Addr2[4], pHeader->Addr2[5]));

		pAd->MeshTab.MeshLink[Idx].Entry.Metrics = LinkMetric;
	} while (FALSE);

	return;
}


VOID MeshCfgInit(
	IN PRTMP_ADAPTER pAd,
	IN PSTRING		 pHostName)
{
	INT	i;

	/* default configuration of Mesh. */
	pAd->MeshTab.OpMode = MESH_MP;

#ifdef CONFIG_AP_SUPPORT
	IF_DEV_CONFIG_OPMODE_ON_AP(pAd)
		pAd->MeshTab.OpMode |= MESH_AP;
#endif /* CONFIG_AP_SUPPORT */

	pAd->MeshTab.PathProtocolId = MESH_HWMP;
	pAd->MeshTab.PathMetricId = MESH_AIRTIME;
	pAd->MeshTab.ContgesionCtrlId = NULL_PROTOCOL;
	pAd->MeshTab.TTL = MESH_TTL;
	pAd->MeshTab.MeshMaxTxRate = 0;
	pAd->MeshTab.MeshMultiCastAgeOut = MULTIPATH_AGEOUT;
	pAd->MeshTab.UCGEnable = FALSE;
	pAd->MeshTab.MeshCapability.field.Forwarding = 1;
	if (pAd->MeshTab.MeshIdLen == 0)
	{
		pAd->MeshTab.MeshIdLen = strlen(DEFAULT_MESH_ID);
		NdisMoveMemory(pAd->MeshTab.MeshId, DEFAULT_MESH_ID, pAd->MeshTab.MeshIdLen);
	}

	/* initialize state */
	pAd->MeshTab.EasyMeshSecurity = TRUE;	/* Default is TRUE for CMPC */
	pAd->MeshTab.bInitialMsaDone = FALSE;
	pAd->MeshTab.bKeyholderDone  = FALSE;
	pAd->MeshTab.bConnectedToMKD = FALSE;
	pAd->MeshTab.MeshOnly = FALSE;

	pAd->MeshTab.bAutoTxRateSwitch = TRUE;
	pAd->MeshTab.DesiredTransmitSetting.field.MCS = MCS_AUTO;

	for (i = 0; i < MAX_MESH_LINKS; i++)
		NdisZeroMemory(&pAd->MeshTab.MeshLink[i].Entry, sizeof(MESH_LINK_ENTRY));

	if (strlen(pHostName) > 0)
	{
		if (strlen(pHostName) < MAX_HOST_NAME_LEN)
			strcpy((PSTRING) pAd->MeshTab.HostName, pHostName);
		else
			strncpy((PSTRING) pAd->MeshTab.HostName, pHostName, MAX_HOST_NAME_LEN-1);
	}
	else
		strcpy((PSTRING) pAd->MeshTab.HostName, DEFAULT_MESH_HOST_NAME);

}


VOID MeshInit(
	IN PRTMP_ADAPTER 				pAd,
	IN RTMP_OS_NETDEV_OP_HOOK		*pNetDevOps)
{
#define MESH_MAX_DEV_NUM	32
	PNET_DEV	new_dev_p;
/*	RTMP_OS_NETDEV_OP_HOOK	netDevOpHook; */
	
	/* sanity check to avoid redundant virtual interfaces are created */
	if (pAd->flg_mesh_init != FALSE)
		return;


	/* init */
	pAd->MeshTab.dev = NULL;
 
	/* create virtual network interface */
	do {
		UINT32 MC_RowID = 0, IoctlIF = 0;
#ifdef MULTIPLE_CARD_SUPPORT
		MC_RowID = pAd->MC_RowID;
#endif /* MULTIPLE_CARD_SUPPORT */
#ifdef HOSTAPD_SUPPORT
		IoctlIF = pAd->IoctlIF;
#endif /* HOSTAPD_SUPPORT */
		new_dev_p = RtmpOSNetDevCreate(MC_RowID, &IoctlIF, INT_MESH, 0, sizeof(PRTMP_ADAPTER), INF_MESH_DEV_NAME);
#ifdef HOSTAPD_SUPPORT
		pAd->IoctlIF = IoctlIF;
#endif /* HOSTAPD_SUPPORT */
		if (new_dev_p == NULL)
		{
			/* allocation fail, exit */
			DBGPRINT(RT_DEBUG_ERROR, ("Allocate network device fail (MESH)...\n"));
			break;
		}

		RTMP_OS_NETDEV_SET_PRIV(new_dev_p, pAd);

		/* init MAC address of virtual network interface */
		COPY_MAC_ADDR(pAd->MeshTab.CurrentAddress, pAd->CurrentAddress);
#ifdef CONFIG_AP_SUPPORT
		if (pAd->chipCap.MBSSIDMode == MBSSID_MODE1)
		{
		if (pAd->ApCfg.BssidNum > 0) 
		{
			/* 	
				Refer to HW definition - 
					Bit1 of MAC address Byte0 is local administration bit 
					and should be set to 1 in extended multiple BSSIDs'
					Bit3~ of MAC address Byte0 is extended multiple BSSID index.
			 */ 
			pAd->MeshTab.CurrentAddress[0] += 2; 	
			pAd->MeshTab.CurrentAddress[0] += ((pAd->ApCfg.BssidNum - 1) << 2);
		}
		}
		else
		{
		pAd->MeshTab.CurrentAddress[ETH_LENGTH_OF_ADDRESS - 1] =
			(pAd->MeshTab.CurrentAddress[ETH_LENGTH_OF_ADDRESS - 1] + pAd->ApCfg.BssidNum) & 0xFF;
		}
#endif /* CONFIG_AP_SUPPORT */


		pNetDevOps->priv_flags = INT_MESH; /* we are virtual interface */
		pNetDevOps->needProtcted = TRUE;
		NdisMoveMemory(&pNetDevOps->devAddr[0], &pAd->MeshTab.CurrentAddress[0], MAC_ADDR_LEN);
		
		/* register this device to OS */
		RtmpOSNetDevAttach(pAd->OpMode, new_dev_p, pNetDevOps);

		/* backup our virtual network interface */
       	 pAd->MeshTab.dev = new_dev_p;
	} while(FALSE);

	/* Initialize Mesh configuration */
	/*MeshCfgInit(pAd, pHostName); */

	/* initialize Mesh Tables and allocate spin locks */
	NdisAllocateSpinLock(pAd, &pAd->MeshTabLock);

	NeighborTableInit(pAd);
	BMPktSigTabInit(pAd);
	MultipathPoolInit(pAd);

	MeshRoutingTable_Init(pAd);
	MeshEntryTable_Init(pAd);
	MeshProxyEntryTable_Init(pAd);

#ifdef CONFIG_STA_SUPPORT
#endif /* CONFIG_STA_SUPPORT */

	pAd->flg_mesh_init = TRUE;
}


INT MESH_OpenPre(
	IN	PNET_DEV					pDev)
{
	PRTMP_ADAPTER pAd;


	pAd = RTMP_OS_NETDEV_GET_PRIV(pDev);
	if (ADHOC_ON(pAd))
		return -1;

	pAd->MeshTab.bBcnSntReq = TRUE;
	return 0;
}


INT MESH_OpenPost(
	IN	PNET_DEV					pDev)
{
	PRTMP_ADAPTER pAd;


	pAd = RTMP_OS_NETDEV_GET_PRIV(pDev);

	/* Statup Mesh Protocol Stack. */
	MeshUp(pAd);

#ifdef CONFIG_STA_SUPPORT
	{
		UINT32 Value;
		/* Pre-tbtt interrupt setting. */
		RTMP_IO_READ32(pAd, INT_TIMER_CFG, &Value);
		Value &= 0xffff0000;
		Value |= 6 << 4; /* Pre-TBTT is 6ms before TBTT interrupt. 1~10 ms is reasonable. */
		RTMP_IO_WRITE32(pAd, INT_TIMER_CFG, Value);

		/* Enable pre-tbtt interrupt */
		RTMP_IO_READ32(pAd, INT_TIMER_EN, &Value);
		Value |=0x1;
		RTMP_IO_WRITE32(pAd, INT_TIMER_EN, Value);
	}
	AsicEnableMESHSync(pAd);
#endif /* CONFIG_STA_SUPPORT */
	return 0;
}


INT MESH_Close(
	IN	PNET_DEV					pDev)
{
	PRTMP_ADAPTER pAd;


	pAd = RTMP_OS_NETDEV_GET_PRIV(pDev);
	MeshDown(pAd, TRUE);

	pAd->MeshTab.bBcnSntReq = FALSE;

#ifdef CONFIG_STA_SUPPORT
	{
		UINT32 Value;
		/* Disable pre-tbtt interrupt */
		RTMP_IO_READ32(pAd, INT_TIMER_EN, &Value);
		Value &=0xe;
		RTMP_IO_WRITE32(pAd, INT_TIMER_EN, Value);
	}

	/*update beacon Sync */
	/*if rausb0 is up => stop beacon */
	/*if rausb0 is down => we will call AsicDisableSync() in usb_rtusb_close_device() */
	if (INFRA_ON(pAd))
		AsicEnableBssSync(pAd);
	else if (ADHOC_ON(pAd))
		AsicEnableIbssSync(pAd);
	else
		AsicDisableSync(pAd);
#endif /* CONFIG_STA_SUPPORT */

	pAd->MeshTab.bBcnSntReq = FALSE;

#ifdef CONFIG_AP_SUPPORT
	APMakeAllBssBeacon(pAd);
	APUpdateAllBeaconFrame(pAd);
#endif /* CONFIG_AP_SUPPORT */
	return 0;
}


int MESH_PacketSend(
	IN	PNDIS_PACKET				pPktSrc, 
	IN	PNET_DEV					pDev,
	IN	RTMP_NET_PACKET_TRANSMIT	Func)
{
	PRTMP_ADAPTER pAd;
	PMESH_STRUCT pMesh;



	pAd = RTMP_OS_NETDEV_GET_PRIV(pDev);
	ASSERT(pAd);

#ifdef RALINK_ATE
	if (ATE_ON(pAd))
	{
		RELEASE_NDIS_PACKET(pAd, pPktSrc, NDIS_STATUS_FAILURE);
		return 0;
	}
#endif /* RALINK_ATE */
	if ((RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS)) ||
		(RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF))          ||
		(RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)))
	{
		/* wlan is scanning/disabled/reset */
		RELEASE_NDIS_PACKET(pAd, pPktSrc, NDIS_STATUS_FAILURE);
		return 0;
	}

	pMesh = (PMESH_STRUCT)&pAd->MeshTab;
	do
	{
		if (MeshValid(pMesh) != TRUE)
			break;
		/* find the device in our Mesh list */
		if (pMesh->dev == pDev)
		{
			/* ya! find it */
			pAd->RalinkCounters.PendingNdisPacketCount ++;
			RTMP_SET_PACKET_SOURCE(pPktSrc, PKTSRC_NDIS);
			RTMP_SET_PACKET_MOREDATA(pPktSrc, FALSE);
			RTMP_SET_PACKET_NET_DEVICE_MESH(pPktSrc, 0);
			SET_OS_PKT_NETDEV(pPktSrc, pAd->net_dev);


			/* transmit the packet */
			return Func(RTPKT_TO_OSPKT(pPktSrc));
		}
    } while(FALSE);


	/* can not find the BSS so discard the packet */

	RELEASE_NDIS_PACKET(pAd, pPktSrc, NDIS_STATUS_FAILURE);

	return 0;
}

#endif /* MESH_SUPPORT */

