#!/bin/sh
# file: iso15118/pev.sh

#
#   configure a QCA7000 PIB file as a SLAC-EVSE on Linux or Cygwin. 
#

if [ $# -ne 1 ]; then
	cat << EOF
usage: evse.sh PIBFILE

This script configures a QCA7000 PIB file as a SLAC-EVSE

EOF
	exit 1
fi 

# ====================================================================
# Manufacturer HFID; 
# --------------------------------------------------------------------

setpib ${1} 24 hfid "Delta Electronics $(date)"

# ====================================================================
# User HFID; 
# --------------------------------------------------------------------

setpib ${1} 74 hfid "Qualcomm Atheros Enabled EVSE"

# ====================================================================
# CCo Selection; 0=Auto, 1=Never, 2=Always, 3=UserAssigned
# --------------------------------------------------------------------

setpib ${1} F4 byte 2

# ====================================================================
# AVLN Membership; 0=No, 1=Yes
# --------------------------------------------------------------------

setpib ${1} FF byte 0

# ====================================================================
# Communications Media; 0=Powerline, 1=Coax Only
# --------------------------------------------------------------------

setpib ${1} 109 byte 1

# ====================================================================
# SLAC Enable; 0=disable, 1=PEV, 2=EVSE
# --------------------------------------------------------------------

setpib ${1} 1653 byte 2

# ====================================================================
# Low Speed Link, High Speed Link
# --------------------------------------------------------------------

setpib ${1} 1C98 long 10240 long 102400

# ====================================================================
# DBC Enable; 0=Disable, 1=Enable 
# --------------------------------------------------------------------

setpib ${1} 1F80 byte 0

# ====================================================================
# Simple QoS; 0=disable, 1=enable
# --------------------------------------------------------------------

setpib ${1} 2030 byte 0

# ====================================================================
# Background PIB HAR; 0=disable, 1=enable
# --------------------------------------------------------------------

setpib ${1} 16D2 byte 0

# ====================================================================
# Fast AVLN Associate; 0=disable, 1=enable
# --------------------------------------------------------------------

setpib ${1} 16D3 byte 1

