PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE "django_migrations" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "applied" datetime NOT NULL);
INSERT INTO "django_migrations" VALUES(1,'admin_log','0001_initial','2017-09-25 05:15:11.274464');
INSERT INTO "django_migrations" VALUES(2,'captcha','0001_initial','2017-09-25 05:15:11.282693');
INSERT INTO "django_migrations" VALUES(3,'contenttypes','0001_initial','2017-09-25 05:15:11.299005');
INSERT INTO "django_migrations" VALUES(4,'contenttypes','0002_remove_content_type_name','2017-09-25 05:15:11.333309');
INSERT INTO "django_migrations" VALUES(5,'database','0001_initial','2017-09-25 05:15:11.343225');
INSERT INTO "django_migrations" VALUES(6,'institutions','0001_initial','2017-09-25 05:15:11.375638');
INSERT INTO "django_migrations" VALUES(7,'institutions','0002_institutionquota','2017-09-25 05:15:11.390670');
INSERT INTO "django_migrations" VALUES(8,'invitations','0001_initial','2017-09-25 05:15:11.462708');
INSERT INTO "django_migrations" VALUES(9,'invitations','0002_invitation_invite_type','2017-09-25 05:15:11.475679');
INSERT INTO "django_migrations" VALUES(10,'invitations','0003_auto_20160510_1703','2017-09-25 05:15:11.493852');
INSERT INTO "django_migrations" VALUES(11,'invitations','0004_auto_20160629_1610','2017-09-25 05:15:11.524141');
INSERT INTO "django_migrations" VALUES(12,'invitations','0005_auto_20160629_1614','2017-09-25 05:15:11.535737');
INSERT INTO "django_migrations" VALUES(13,'post_office','0001_initial','2017-09-25 05:15:11.624490');
INSERT INTO "django_migrations" VALUES(14,'post_office','0002_add_i18n_and_backend_alias','2017-09-25 05:15:11.927851');
INSERT INTO "django_migrations" VALUES(15,'post_office','0003_auto_20170725_0206','2017-09-25 05:15:11.947859');
INSERT INTO "django_migrations" VALUES(16,'role_permissions','0001_initial','2017-09-25 05:15:11.959526');
INSERT INTO "django_migrations" VALUES(17,'sessions','0001_initial','2017-09-25 05:15:11.983224');
INSERT INTO "django_migrations" VALUES(18,'termsandconditions','0001_initial','2017-09-25 05:15:12.024418');
CREATE TABLE "registration_registrationprofile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "emailuser_id" integer NOT NULL, "activation_key" varchar(40) NOT NULL);
CREATE TABLE "api2_token" ("key" varchar(40) NOT NULL PRIMARY KEY, "user" varchar(255) NOT NULL UNIQUE, "created" datetime NOT NULL);
CREATE TABLE "api2_tokenv2" ("key" varchar(40) NOT NULL PRIMARY KEY, "user" varchar(255) NOT NULL, "platform" varchar(32) NOT NULL, "device_id" varchar(40) NOT NULL, "device_name" varchar(40) NOT NULL, "platform_version" varchar(16) NOT NULL, "client_version" varchar(16) NOT NULL, "last_accessed" datetime NOT NULL, "last_login_ip" char(39) NULL, "created_at" datetime NOT NULL, "wiped_at" datetime NULL, UNIQUE ("user", "platform", "device_id"));
CREATE TABLE "avatar_avatar" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "emailuser" varchar(255) NOT NULL, "primary" bool NOT NULL, "avatar" varchar(1024) NOT NULL, "date_uploaded" datetime NOT NULL);
CREATE TABLE "avatar_groupavatar" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" varchar(255) NOT NULL, "avatar" varchar(1024) NOT NULL, "date_uploaded" datetime NOT NULL);
CREATE TABLE "base_filediscuss" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_message_id" integer NOT NULL REFERENCES "group_groupmessage" ("id"), "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "path_hash" varchar(12) NOT NULL);
CREATE TABLE "base_filecomment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "parent_path" text NOT NULL, "repo_id_parent_path_md5" varchar(100) NOT NULL, "item_name" text NOT NULL, "author" varchar(255) NOT NULL, "comment" text NOT NULL, "created_at" datetime NOT NULL, "updated_at" datetime NOT NULL);
CREATE TABLE "base_userstarredfiles" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL, "org_id" integer NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "is_dir" bool NOT NULL);
CREATE TABLE "base_userenabledmodule" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "module_name" varchar(20) NOT NULL);
CREATE TABLE "base_groupenabledmodule" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" varchar(10) NOT NULL, "module_name" varchar(20) NOT NULL);
CREATE TABLE "base_userlastlogin" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "last_login" datetime NOT NULL);
CREATE TABLE "base_commandslastcheck" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "command_type" varchar(100) NOT NULL, "last_check" datetime NOT NULL);
CREATE TABLE "base_innerpubmsg" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "from_email" varchar(254) NOT NULL, "message" varchar(500) NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "base_innerpubmsgreply" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "reply_to_id" integer NOT NULL REFERENCES "base_innerpubmsg" ("id"), "from_email" varchar(254) NOT NULL, "message" varchar(150) NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "base_devicetoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(80) NOT NULL, "user" varchar(255) NOT NULL, "platform" varchar(32) NOT NULL, "version" varchar(16) NOT NULL, "pversion" varchar(16) NOT NULL, UNIQUE ("token", "user"));
CREATE TABLE "base_clientlogintoken" ("token" varchar(32) NOT NULL PRIMARY KEY, "username" varchar(255) NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "contacts_contact" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_email" varchar(255) NOT NULL, "contact_email" varchar(255) NOT NULL, "contact_name" varchar(255) NULL, "note" varchar(255) NULL);
CREATE TABLE "wiki_personalwiki" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL UNIQUE, "repo_id" varchar(36) NOT NULL);
CREATE TABLE "wiki_groupwiki" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL UNIQUE, "repo_id" varchar(36) NOT NULL);
CREATE TABLE "group_groupmessage" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL, "from_email" varchar(255) NOT NULL, "message" text NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "group_messagereply" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "reply_to_id" integer NOT NULL REFERENCES "group_groupmessage" ("id"), "from_email" varchar(255) NOT NULL, "message" text NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "group_messageattachment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_message_id" integer NOT NULL REFERENCES "group_groupmessage" ("id"), "repo_id" varchar(40) NOT NULL, "attach_type" varchar(5) NOT NULL, "path" text NOT NULL, "src" varchar(20) NOT NULL);
CREATE TABLE "group_publicgroup" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL);
CREATE TABLE "notifications_notification" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "message" varchar(512) NOT NULL, "primary" bool NOT NULL);
CREATE TABLE "notifications_usernotification" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "to_user" varchar(255) NOT NULL, "msg_type" varchar(30) NOT NULL, "detail" text NOT NULL, "timestamp" datetime NOT NULL, "seen" bool NOT NULL);
CREATE TABLE "options_useroptions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(255) NOT NULL, "option_key" varchar(50) NOT NULL, "option_val" varchar(50) NOT NULL);
CREATE TABLE "profile_profile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(254) NOT NULL UNIQUE, "nickname" varchar(64) NOT NULL, "intro" text NOT NULL, "lang_code" text NULL, "login_id" varchar(225) NULL UNIQUE, "contact_email" varchar(225) NULL, "institution" varchar(225) NULL, "list_in_address_book" bool NOT NULL);
CREATE TABLE "profile_detailedprofile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL, "department" varchar(512) NOT NULL, "telephone" varchar(100) NOT NULL);
CREATE TABLE "share_anonymousshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_owner" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "anonymous_email" varchar(255) NOT NULL, "token" varchar(25) NOT NULL UNIQUE);
CREATE TABLE "share_extragroupssharepermission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "group_id" integer NOT NULL, "permission" varchar(30) NOT NULL);
CREATE TABLE "share_extrasharepermission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "share_to" varchar(255) NOT NULL, "permission" varchar(30) NOT NULL);
CREATE TABLE "share_fileshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(100) NOT NULL UNIQUE, "ctime" datetime NOT NULL, "view_cnt" integer NOT NULL, "s_type" varchar(2) NOT NULL, "password" varchar(128) NULL, "expire_date" datetime NULL, "permission" varchar(50) NOT NULL);
CREATE TABLE "share_orgfileshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL, "file_share_id" integer NOT NULL UNIQUE REFERENCES "share_fileshare" ("id"));
CREATE TABLE "share_uploadlinkshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(100) NOT NULL UNIQUE, "ctime" datetime NOT NULL, "view_cnt" integer NOT NULL, "password" varchar(128) NULL, "expire_date" datetime NULL);
CREATE TABLE "share_privatefiledirshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "from_user" varchar(255) NOT NULL, "to_user" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(10) NOT NULL UNIQUE, "permission" varchar(5) NOT NULL, "s_type" varchar(5) NOT NULL);
CREATE TABLE "tags_fileuuidmap" ("uuid" char(32) NOT NULL PRIMARY KEY, "repo_id" varchar(36) NOT NULL, "repo_id_parent_path_md5" varchar(100) NOT NULL, "parent_path" text NOT NULL, "filename" varchar(1024) NOT NULL, "is_dir" bool NOT NULL);
CREATE TABLE "tags_tags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL UNIQUE);
CREATE TABLE "tags_filetag" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"), "tag_id" integer NOT NULL REFERENCES "tags_tags" ("id"), "username" varchar(255) NOT NULL);
CREATE TABLE "revision_tag_tags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL UNIQUE);
CREATE TABLE "revision_tag_revisiontags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "revision_id" varchar(255) NOT NULL, "tag_id" integer NOT NULL REFERENCES "revision_tag_tags" ("id"), "username" varchar(255) NOT NULL);
CREATE TABLE "two_factor_totpdevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL, "key" varchar(80) NOT NULL, "step" smallint unsigned NOT NULL, "t0" bigint NOT NULL, "digits" smallint unsigned NOT NULL, "tolerance" smallint unsigned NOT NULL, "drift" smallint NOT NULL, "last_t" bigint NOT NULL);
CREATE TABLE "two_factor_phonedevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL, "number" varchar(40) NOT NULL, "key" varchar(40) NOT NULL, "method" varchar(4) NOT NULL);
CREATE TABLE "two_factor_staticdevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL);
CREATE TABLE "two_factor_statictoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "device_id" integer NOT NULL REFERENCES "two_factor_staticdevice" ("id"), "token" varchar(16) NOT NULL);
CREATE TABLE "trusted_ip_trustedip" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "ip" varchar(255) NOT NULL);
CREATE TABLE "sysadmin_extra_userloginlog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "login_date" datetime NOT NULL, "login_ip" varchar(128) NOT NULL, "login_success" bool NOT NULL);
CREATE TABLE "organizations_orgmemberquota" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL, "quota" integer NOT NULL);
CREATE TABLE "admin_log_adminlog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL, "operation" varchar(255) NOT NULL, "detail" text NOT NULL, "datetime" datetime NOT NULL);
CREATE TABLE "captcha_captchastore" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "challenge" varchar(32) NOT NULL, "response" varchar(32) NOT NULL, "hashkey" varchar(40) NOT NULL UNIQUE, "expiration" datetime NOT NULL);
CREATE TABLE "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL, UNIQUE ("app_label", "model"));
INSERT INTO "django_content_type" VALUES(1,'contenttypes','contenttype');
INSERT INTO "django_content_type" VALUES(2,'sessions','session');
INSERT INTO "django_content_type" VALUES(3,'registration','registrationprofile');
INSERT INTO "django_content_type" VALUES(4,'captcha','captchastore');
INSERT INTO "django_content_type" VALUES(5,'database','constance');
INSERT INTO "django_content_type" VALUES(6,'post_office','attachment');
INSERT INTO "django_content_type" VALUES(7,'post_office','emailtemplate');
INSERT INTO "django_content_type" VALUES(8,'post_office','email');
INSERT INTO "django_content_type" VALUES(9,'post_office','log');
INSERT INTO "django_content_type" VALUES(10,'termsandconditions','termsandconditions');
INSERT INTO "django_content_type" VALUES(11,'termsandconditions','usertermsandconditions');
INSERT INTO "django_content_type" VALUES(12,'api2','token');
INSERT INTO "django_content_type" VALUES(13,'api2','tokenv2');
INSERT INTO "django_content_type" VALUES(14,'avatar','avatar');
INSERT INTO "django_content_type" VALUES(15,'avatar','groupavatar');
INSERT INTO "django_content_type" VALUES(16,'base','groupenabledmodule');
INSERT INTO "django_content_type" VALUES(17,'base','clientlogintoken');
INSERT INTO "django_content_type" VALUES(18,'base','userenabledmodule');
INSERT INTO "django_content_type" VALUES(19,'base','filecomment');
INSERT INTO "django_content_type" VALUES(20,'base','filediscuss');
INSERT INTO "django_content_type" VALUES(21,'base','devicetoken');
INSERT INTO "django_content_type" VALUES(22,'base','commandslastcheck');
INSERT INTO "django_content_type" VALUES(23,'base','innerpubmsg');
INSERT INTO "django_content_type" VALUES(24,'base','innerpubmsgreply');
INSERT INTO "django_content_type" VALUES(25,'base','userlastlogin');
INSERT INTO "django_content_type" VALUES(26,'base','userstarredfiles');
INSERT INTO "django_content_type" VALUES(27,'contacts','contact');
INSERT INTO "django_content_type" VALUES(28,'institutions','institutionadmin');
INSERT INTO "django_content_type" VALUES(29,'institutions','institution');
INSERT INTO "django_content_type" VALUES(30,'institutions','institutionquota');
INSERT INTO "django_content_type" VALUES(31,'invitations','invitation');
INSERT INTO "django_content_type" VALUES(32,'wiki','personalwiki');
INSERT INTO "django_content_type" VALUES(33,'wiki','groupwiki');
INSERT INTO "django_content_type" VALUES(34,'group','publicgroup');
INSERT INTO "django_content_type" VALUES(35,'group','groupmessage');
INSERT INTO "django_content_type" VALUES(36,'group','messageattachment');
INSERT INTO "django_content_type" VALUES(37,'group','messagereply');
INSERT INTO "django_content_type" VALUES(38,'notifications','notification');
INSERT INTO "django_content_type" VALUES(39,'notifications','usernotification');
INSERT INTO "django_content_type" VALUES(40,'options','useroptions');
INSERT INTO "django_content_type" VALUES(41,'profile','profile');
INSERT INTO "django_content_type" VALUES(42,'profile','detailedprofile');
INSERT INTO "django_content_type" VALUES(43,'share','privatefiledirshare');
INSERT INTO "django_content_type" VALUES(44,'share','fileshare');
INSERT INTO "django_content_type" VALUES(45,'share','orgfileshare');
INSERT INTO "django_content_type" VALUES(46,'share','uploadlinkshare');
INSERT INTO "django_content_type" VALUES(47,'share','extrasharepermission');
INSERT INTO "django_content_type" VALUES(48,'share','extragroupssharepermission');
INSERT INTO "django_content_type" VALUES(49,'share','anonymousshare');
INSERT INTO "django_content_type" VALUES(50,'admin_log','adminlog');
INSERT INTO "django_content_type" VALUES(51,'tags','fileuuidmap');
INSERT INTO "django_content_type" VALUES(52,'tags','filetag');
INSERT INTO "django_content_type" VALUES(53,'tags','tags');
INSERT INTO "django_content_type" VALUES(54,'revision_tag','revisiontags');
INSERT INTO "django_content_type" VALUES(55,'revision_tag','tags');
INSERT INTO "django_content_type" VALUES(56,'two_factor','phonedevice');
INSERT INTO "django_content_type" VALUES(57,'two_factor','statictoken');
INSERT INTO "django_content_type" VALUES(58,'two_factor','totpdevice');
INSERT INTO "django_content_type" VALUES(59,'two_factor','staticdevice');
INSERT INTO "django_content_type" VALUES(60,'role_permissions','adminrole');
INSERT INTO "django_content_type" VALUES(61,'trusted_ip','trustedip');
INSERT INTO "django_content_type" VALUES(62,'sysadmin_extra','userloginlog');
INSERT INTO "django_content_type" VALUES(63,'organizations','orgmemberquota');
CREATE TABLE "constance_config" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "key" varchar(255) NOT NULL UNIQUE, "value" text NOT NULL);
CREATE TABLE "institutions_institution" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(200) NOT NULL, "create_time" datetime NOT NULL);
CREATE TABLE "institutions_institutionadmin" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(254) NOT NULL, "institution_id" integer NOT NULL REFERENCES "institutions_institution" ("id"));
CREATE TABLE "institutions_institutionquota" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "quota" bigint NOT NULL, "institution_id" integer NOT NULL REFERENCES "institutions_institution" ("id"));
CREATE TABLE "invitations_invitation" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(40) NOT NULL, "inviter" varchar(255) NOT NULL, "accepter" varchar(255) NOT NULL, "invite_time" datetime NOT NULL, "accept_time" datetime NULL, "invite_type" varchar(20) NOT NULL, "expire_time" datetime NOT NULL);
CREATE TABLE "post_office_attachment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "file" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
CREATE TABLE "post_office_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "date" datetime NOT NULL, "status" smallint unsigned NOT NULL, "exception_type" varchar(255) NOT NULL, "message" text NOT NULL, "email_id" integer NOT NULL REFERENCES "post_office_email" ("id"));
CREATE TABLE "post_office_attachment_emails" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "attachment_id" integer NOT NULL REFERENCES "post_office_attachment" ("id"), "email_id" integer NOT NULL REFERENCES "post_office_email" ("id"), UNIQUE ("attachment_id", "email_id"));
CREATE TABLE "post_office_email" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "from_email" varchar(254) NOT NULL, "cc" text NOT NULL, "bcc" text NOT NULL, "subject" varchar(255) NOT NULL, "message" text NOT NULL, "html_message" text NOT NULL, "status" smallint unsigned NULL, "priority" smallint unsigned NULL, "created" datetime NOT NULL, "last_updated" datetime NOT NULL, "scheduled_time" datetime NULL, "headers" text NULL, "context" text NULL, "template_id" integer NULL REFERENCES "post_office_emailtemplate" ("id"), "backend_alias" varchar(64) NOT NULL, "to" text NOT NULL);
CREATE TABLE "post_office_emailtemplate" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL, "description" text NOT NULL, "subject" varchar(255) NOT NULL, "content" text NOT NULL, "html_content" text NOT NULL, "created" datetime NOT NULL, "last_updated" datetime NOT NULL, "default_template_id" integer NULL REFERENCES "post_office_emailtemplate" ("id"), "language" varchar(12) NOT NULL, UNIQUE ("language", "default_template_id"));
CREATE TABLE "role_permissions_adminrole" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL UNIQUE, "role" varchar(255) NOT NULL);
CREATE TABLE "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
CREATE TABLE "termsandconditions_termsandconditions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "slug" varchar(50) NOT NULL, "name" text NOT NULL, "version_number" decimal NOT NULL, "text" text NULL, "info" text NULL, "date_active" datetime NULL, "date_created" datetime NOT NULL);
CREATE TABLE "termsandconditions_usertermsandconditions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "ip_address" char(39) NULL, "date_accepted" datetime NOT NULL, "terms_id" integer NOT NULL REFERENCES "termsandconditions_termsandconditions" ("id"), UNIQUE ("username", "terms_id"));
DELETE FROM sqlite_sequence;
INSERT INTO "sqlite_sequence" VALUES('django_migrations',18);
INSERT INTO "sqlite_sequence" VALUES('django_content_type',63);
INSERT INTO "sqlite_sequence" VALUES('invitations_invitation',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_email',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_emailtemplate',0);
INSERT INTO "sqlite_sequence" VALUES('termsandconditions_usertermsandconditions',0);
CREATE INDEX "base_filediscuss_06a351d8" ON "base_filediscuss" ("group_message_id");
CREATE INDEX "base_filediscuss_b57d9b6b" ON "base_filediscuss" ("path_hash");
CREATE INDEX "base_filecomment_9a8c79bf" ON "base_filecomment" ("repo_id");
CREATE INDEX "base_filecomment_c5bf47d4" ON "base_filecomment" ("repo_id_parent_path_md5");
CREATE INDEX "base_filecomment_02bd92fa" ON "base_filecomment" ("author");
CREATE INDEX "base_userstarredfiles_0c83f57c" ON "base_userstarredfiles" ("email");
CREATE INDEX "base_userstarredfiles_9a8c79bf" ON "base_userstarredfiles" ("repo_id");
CREATE INDEX "base_userenabledmodule_14c4b06b" ON "base_userenabledmodule" ("username");
CREATE INDEX "base_groupenabledmodule_0e939a4f" ON "base_groupenabledmodule" ("group_id");
CREATE INDEX "base_userlastlogin_14c4b06b" ON "base_userlastlogin" ("username");
CREATE INDEX "base_innerpubmsgreply_6ec85d95" ON "base_innerpubmsgreply" ("reply_to_id");
CREATE INDEX "base_clientlogintoken_14c4b06b" ON "base_clientlogintoken" ("username");
CREATE INDEX "contacts_contact_40c27bdc" ON "contacts_contact" ("user_email");
CREATE INDEX "group_groupmessage_0e939a4f" ON "group_groupmessage" ("group_id");
CREATE INDEX "group_messagereply_6ec85d95" ON "group_messagereply" ("reply_to_id");
CREATE INDEX "group_messageattachment_06a351d8" ON "group_messageattachment" ("group_message_id");
CREATE INDEX "group_publicgroup_0e939a4f" ON "group_publicgroup" ("group_id");
CREATE INDEX "notifications_usernotification_86899d6f" ON "notifications_usernotification" ("to_user");
CREATE INDEX "notifications_usernotification_486af403" ON "notifications_usernotification" ("msg_type");
CREATE INDEX "options_useroptions_0c83f57c" ON "options_useroptions" ("email");
CREATE INDEX "profile_profile_b9973d8c" ON "profile_profile" ("contact_email");
CREATE INDEX "profile_profile_955bfff7" ON "profile_profile" ("institution");
CREATE INDEX "profile_profile_3d5d3631" ON "profile_profile" ("list_in_address_book");
CREATE INDEX "profile_detailedprofile_ee11cbb1" ON "profile_detailedprofile" ("user");
CREATE INDEX "share_extragroupssharepermission_9a8c79bf" ON "share_extragroupssharepermission" ("repo_id");
CREATE INDEX "share_extragroupssharepermission_0e939a4f" ON "share_extragroupssharepermission" ("group_id");
CREATE INDEX "share_extrasharepermission_9a8c79bf" ON "share_extrasharepermission" ("repo_id");
CREATE INDEX "share_extrasharepermission_e4fb1dad" ON "share_extrasharepermission" ("share_to");
CREATE INDEX "share_fileshare_14c4b06b" ON "share_fileshare" ("username");
CREATE INDEX "share_fileshare_9a8c79bf" ON "share_fileshare" ("repo_id");
CREATE INDEX "share_fileshare_1abd88b5" ON "share_fileshare" ("s_type");
CREATE INDEX "share_fileshare_4b65ca0f" ON "share_fileshare" ("permission");
CREATE INDEX "share_orgfileshare_9cf869aa" ON "share_orgfileshare" ("org_id");
CREATE INDEX "share_uploadlinkshare_14c4b06b" ON "share_uploadlinkshare" ("username");
CREATE INDEX "share_uploadlinkshare_9a8c79bf" ON "share_uploadlinkshare" ("repo_id");
CREATE INDEX "share_privatefiledirshare_f4f87abd" ON "share_privatefiledirshare" ("from_user");
CREATE INDEX "share_privatefiledirshare_86899d6f" ON "share_privatefiledirshare" ("to_user");
CREATE INDEX "share_privatefiledirshare_9a8c79bf" ON "share_privatefiledirshare" ("repo_id");
CREATE INDEX "tags_fileuuidmap_9a8c79bf" ON "tags_fileuuidmap" ("repo_id");
CREATE INDEX "tags_fileuuidmap_c5bf47d4" ON "tags_fileuuidmap" ("repo_id_parent_path_md5");
CREATE INDEX "tags_filetag_10634818" ON "tags_filetag" ("uuid_id");
CREATE INDEX "tags_filetag_76f094bc" ON "tags_filetag" ("tag_id");
CREATE INDEX "revision_tag_revisiontags_9a8c79bf" ON "revision_tag_revisiontags" ("repo_id");
CREATE INDEX "revision_tag_revisiontags_5de09a8d" ON "revision_tag_revisiontags" ("revision_id");
CREATE INDEX "revision_tag_revisiontags_76f094bc" ON "revision_tag_revisiontags" ("tag_id");
CREATE INDEX "revision_tag_revisiontags_14c4b06b" ON "revision_tag_revisiontags" ("username");
CREATE INDEX "two_factor_statictoken_9379346c" ON "two_factor_statictoken" ("device_id");
CREATE INDEX "two_factor_statictoken_94a08da1" ON "two_factor_statictoken" ("token");
CREATE INDEX "trusted_ip_trustedip_957b527b" ON "trusted_ip_trustedip" ("ip");
CREATE INDEX "sysadmin_extra_userloginlog_14c4b06b" ON "sysadmin_extra_userloginlog" ("username");
CREATE INDEX "sysadmin_extra_userloginlog_28ed1ef0" ON "sysadmin_extra_userloginlog" ("login_date");
CREATE INDEX "organizations_orgmemberquota_9cf869aa" ON "organizations_orgmemberquota" ("org_id");
CREATE INDEX "admin_log_adminlog_0c83f57c" ON "admin_log_adminlog" ("email");
CREATE INDEX "admin_log_adminlog_f7235a61" ON "admin_log_adminlog" ("operation");
CREATE INDEX "institutions_institutionadmin_a964baeb" ON "institutions_institutionadmin" ("institution_id");
CREATE INDEX "institutions_institutionquota_a964baeb" ON "institutions_institutionquota" ("institution_id");
CREATE INDEX "invitations_invitation_94a08da1" ON "invitations_invitation" ("token");
CREATE INDEX "invitations_invitation_d5dd16f8" ON "invitations_invitation" ("inviter");
CREATE INDEX "post_office_log_fdfd0ebf" ON "post_office_log" ("email_id");
CREATE INDEX "post_office_attachment_emails_07ba63f5" ON "post_office_attachment_emails" ("attachment_id");
CREATE INDEX "post_office_attachment_emails_fdfd0ebf" ON "post_office_attachment_emails" ("email_id");
CREATE INDEX "post_office_email_9acb4454" ON "post_office_email" ("status");
CREATE INDEX "post_office_email_e2fa5388" ON "post_office_email" ("created");
CREATE INDEX "post_office_email_3acc0b7a" ON "post_office_email" ("last_updated");
CREATE INDEX "post_office_email_ed24d584" ON "post_office_email" ("scheduled_time");
CREATE INDEX "post_office_email_74f53564" ON "post_office_email" ("template_id");
CREATE INDEX "post_office_emailtemplate_dea6f63e" ON "post_office_emailtemplate" ("default_template_id");
CREATE INDEX "django_session_de54fa62" ON "django_session" ("expire_date");
CREATE INDEX "termsandconditions_termsandconditions_2dbcba41" ON "termsandconditions_termsandconditions" ("slug");
CREATE INDEX "termsandconditions_usertermsandconditions_2ab34720" ON "termsandconditions_usertermsandconditions" ("terms_id");
COMMIT;
