/******************************************************************************
 *
 * response.c - part of smap
 * 
 * Contains all SIP response parsers to do the fingerprinting work
 *
 * $Id: response.c,v 1.5 2007-10-07 10:15:11 hscholz Exp $
 *****************************************************************************/
#ifndef _RESPONSE_C
#define _RESPONSE_C

#include "config.h"

/******************************************************************************
 *
 * response_reason()
 *
 * get response code from message
 * We do ignore the reason phrase although it might be a bad idea for 100%
 * accurate SIP fingerprinting.
 *
 *****************************************************************************/
int response_reason(int *res, char *buf) {

	char *p;
	int i;
	unsigned int reason = 0;

	FUNCTION(__FILE__, __FUNCTION__);

	if ((res == NULL) || (buf == NULL))
		goto error;

	/* packet should be > 64 Bytes long to make any sense at all */
	if (strlen(buf) < 64)
		goto error;

	/* response has to start with 'SIP/2.0 ' */
	if (strncmp(buf, "SIP/2.0 ", 8)) {
		/* did not, so bail out ... */
		goto error;
	}

	p = (buf + 7);
	while ((*p == ' ') || (*p == '\t'))
		p++; /* skip spaces */

	/* this should be a three digit number */
	for (i = 0; i < 3; i++) {
		if ((*p >= '0') && (*p <= '9')) {
			reason *= 10;	/* FIXME: overflow possible */
			reason += *p - '0';
			p++;
		}
	}
	/* next char has to be a white space */
	if ((*p != ' ') && ((*p != '\t')))
		goto error;
	*res = reason;
	return 1;

error:
	*res = 0;
	return 0;
}

/******************************************************************************
 *
 * response_getcallid()
 *
 * pull the Call-ID userpart from a single message and return it or return
 * 0 in case of error
 *
 * limitation: Call-ID must be numberic to be fully parsed
 *****************************************************************************/

unsigned int response_getcallid(char *buf) {

	char *p;
	unsigned int val;

	FUNCTION(__FILE__, __FUNCTION__);

	if (buf == NULL) return 0;

	/* packet should be > 64 Bytes long to make any sense at all */
	if (strlen(buf) < 64) return 0;

	/* response has to start with 'SIP/2.0 ' */
	if (strncmp(buf, "SIP/2.0 ", 8)) {
		/* did not, so bail out ... */
		return 0;
	}

	/* search for a new line that starts with Call-ID */

	/* \r\nCall-ID : 12345@whatever */
	/* ^^^^^^^^^^^					*/
	p = strcasestr(buf, "\r\nCall-ID");
	if (!p) return 0;
	p += strlen("\r\nCall-ID");
	/* \r\nCall-ID : 12345@whatever */
	/*            ^					*/
	while ((*p == ' ') || (*p == '\t'))
		p++; /* skip spaces */
	/* \r\nCall-ID : 12345@whatever */
	/*             ^				*/
	if (*p != ':') return 0;
	p++;
	/* \r\nCall-ID : 12345@whatever */
	/*              ^				*/
	while ((*p == ' ') || (*p == '\t'))
		p++; /* skip spaces */
	/* \r\nCall-ID : 12345@whatever */
	/*               ^^^^^			*/
	val = 0;
	while ((p != NULL) && (*p >= '0') && (*p <= '9')) {
		val *= 10;		/* FIXME: overflow possible */
		val += *p - '0';
		p++;
	}
	/* \r\nCall-ID : 12345@whatever */
	/*                    ^			*/
	if (*p != '@') return 0;

	return (val) ? val : 0;
}

#endif /* _RESPONSE_C */
