The files here are for building an RPM package installable on CentOS 6.x/RHEL 6.x.

I (Dexter Ang, aka @thepoch) am not affiliated with the SoftEther VPN Project. Any bugs, suggestions, improvements on building an RPM should probably be reported to me.

## Install and run

After the package is built and installed, you can start the service as root:

    service vpnserver start

You can also have it start automatically:

    chkconfig vpnserver on

## Files

This project containts the following files to build an RPM of SoftEther VPN:

* SPEC/softethervpn.spec - The main spec file
* SOURCES/fix-makefiles.sh - Script that modifies the original makefiles so it properly makes with BUILDROOT.
* linux_??bit.mak - Makefiles modified using fix-makefiles.sh. You can replace these with the original from source, and rerun the script above.
* init.d/vpnserver - initscript
* scripts/* - scripts that are originally generated by the original makefiles.

## To Build on CentOS 6.x

As root, install the following packages:

    yum -y groupinstall "Development Tools"
    yum -y install ncurses-devel openssl-devel readline-devel
    yum -y install rpmdevtools

As a regular user, create your rpmbuild directory structure:

    rpmdev-setuptree

Copy over the files from their respective directories in this repository into your rpmbuild directory. Then

    rpmbuild -ba SPECS/softethervpn.spec

The resulting RPM will be in the RPM directory. Install this as root:

    rpm -Uvh RPMS/`arch`/softethervpn-4*rpm

## Known Issues

1. Currently, vpnserver hangs when stopped on CentOS 6.5. Have not had time to debug. Ticket #18 on SoftEtherVPN [https://github.com/SoftEtherVPN/SoftEtherVPN/issues/18](https://github.com/SoftEtherVPN/SoftEtherVPN/issues/18).
2. Directory structure retained as-is under /usr/vpn*.
3. Not built into separate packages (ie vpnserver, vpnclient, etc. are all in one).
4. When uninstalling, if you ran any of the SoftEtherVPN binaries, configuration and other files are generated in /usr/vpn*. So these directories will remain when you uninstall the RPM. You can delete these if you don't plan on using the configurations again.

## Personal Notes

1. This is my first time creating a spec file, creating an RPM, etc. Apologies in advance for any mistakes.
2. This was tested using sources for version: **4.04.9412**. I'll try and update this as new versions come out.

