#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0x8C,0x58,0x18,0xF1,0x04,0xF9,0x2D,0x35,0x67,0x66,0x41,0x7B,
		0x0F,0xEC,0x48,0x94,0xAE,0x05,0xE2,0x3E,0x38,0xD9,0xB6,0x25,
		0xB3,0x76,0xDD,0x67,0xB4,0x86,0x27,0x2B,0xCF,0x16,0x1C,0xD0,
		0xFE,0x18,0xD0,0x14,0x64,0x09,0x42,0xE0,0xEB,0x17,0xBB,0x2E,
		0xD3,0xA1,0x4B,0x91,0x32,0x96,0x2E,0xF9,0x26,0xC4,0x2D,0x4A,
		0xDA,0xAC,0xDC,0xFC,0x60,0x5C,0xDC,0x14,0xEC,0xB8,0x54,0xBB,
		0x31,0x95,0x29,0x46,0x5A,0x8F,0x30,0x68,0x04,0x4C,0x04,0xA2,
		0x74,0xC7,0x6F,0xAD,0x28,0x46,0x9F,0xA7,0x8F,0xD8,0x93,0x9E,
		0xA8,0xEE,0x98,0x08,0x11,0xFE,0x05,0xBE,0x9A,0x39,0xC7,0x4A,
		0xE3,0x1F,0x6F,0xB2,0x6D,0xBC,0xC6,0x46,0xB8,0x13,0x85,0xCF,
		0xC2,0x26,0x17,0x15,0x55,0xDD,0x13,0x1B,0xF4,0xFE,0x80,0x5F,
		0x45,0xF3,0x4E,0x93,0x42,0x4E,0x7C,0xB2,0xCF,0xF8,0xAA,0xF6,
		0xF7,0xD3,0x31,0x76,0x85,0xFA,0x8C,0x3D,0xA2,0xCD,0x85,0x27,
		0xEA,0xAD,0xFB,0x4B,0x9F,0x4E,0xF4,0x3A,0x89,0x55,0xEB,0xFB,
		0xD6,0xB6,0x90,0x2C,0x74,0x6D,0x03,0x58,0xA6,0xB2,0xB1,0x00,
		0xDF,0x65,0x56,0xCE,0x61,0xA9,0xCD,0xCD,0xE2,0x5D,0x71,0xDE,
		0xAC,0xB5,0x05,0x84,0x90,0xE3,0xC6,0x52,0x83,0x02,0x9F,0x6F,
		0xCB,0x7D,0xB7,0xE8,0x88,0x79,0xA8,0xA3,0x98,0x90,0x92,0x1E,
		0xE9,0xD0,0x9F,0xE9,0x1D,0xBC,0xDB,0xD2,0xCF,0xA7,0x78,0x41,
		0x4C,0x9D,0x7D,0x9A,0x0D,0x73,0x8A,0xB7,0x61,0xCD,0x45,0x0C,
		0x39,0xC9,0x66,0xAC,0xF4,0x78,0x5B,0x1E,0xEF,0x92,0xD4,0xC8,
		0x09,0x10,0xDD,0xDB,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
#endif /* OPENSSL_NO_DH */
