/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.Theory;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class Theories
extends BlockJUnit4ClassRunner {
    public Theories(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> list) {
        super.collectInitializationErrors(list);
        this.validateDataPointFields(list);
        this.validateDataPointMethods(list);
    }

    private void validateDataPointFields(List<Throwable> list) {
        Field[] fieldArray;
        for (Field field : fieldArray = this.getTestClass().getJavaClass().getDeclaredFields()) {
            if (field.getAnnotation(DataPoint.class) == null && field.getAnnotation(DataPoints.class) == null) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                list.add(new Error("DataPoint field " + field.getName() + " must be static"));
            }
            if (Modifier.isPublic(field.getModifiers())) continue;
            list.add(new Error("DataPoint field " + field.getName() + " must be public"));
        }
    }

    private void validateDataPointMethods(List<Throwable> list) {
        Method[] methodArray;
        for (Method method : methodArray = this.getTestClass().getJavaClass().getDeclaredMethods()) {
            if (method.getAnnotation(DataPoint.class) == null && method.getAnnotation(DataPoints.class) == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                list.add(new Error("DataPoint method " + method.getName() + " must be static"));
            }
            if (Modifier.isPublic(method.getModifiers())) continue;
            list.add(new Error("DataPoint method " + method.getName() + " must be public"));
        }
    }

    @Override
    protected void validateConstructor(List<Throwable> list) {
        this.validateOnlyOneConstructor(list);
    }

    @Override
    protected void validateTestMethods(List<Throwable> list) {
        for (FrameworkMethod frameworkMethod : this.computeTestMethods()) {
            if (frameworkMethod.getAnnotation(Theory.class) != null) {
                frameworkMethod.validatePublicVoid(false, list);
                frameworkMethod.validateNoTypeParametersOnArgs(list);
            } else {
                frameworkMethod.validatePublicVoidNoArg(false, list);
            }
            for (ParameterSignature parameterSignature : ParameterSignature.signatures(frameworkMethod.getMethod())) {
                ParametersSuppliedBy parametersSuppliedBy = parameterSignature.findDeepAnnotation(ParametersSuppliedBy.class);
                if (parametersSuppliedBy == null) continue;
                this.validateParameterSupplier(parametersSuppliedBy.value(), list);
            }
        }
    }

    private void validateParameterSupplier(Class<? extends ParameterSupplier> clazz, List<Throwable> list) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length != 1) {
            list.add(new Error("ParameterSupplier " + clazz.getName() + " must have only one constructor (either empty or taking only a TestClass)"));
        } else {
            Class<?>[] classArray = constructorArray[0].getParameterTypes();
            if (classArray.length != 0 && !classArray[0].equals(TestClass.class)) {
                list.add(new Error("ParameterSupplier " + clazz.getName() + " constructor must take either nothing or a single TestClass instance"));
            }
        }
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> arrayList = new ArrayList<FrameworkMethod>(super.computeTestMethods());
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(Theory.class);
        arrayList.removeAll(list);
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public Statement methodBlock(FrameworkMethod frameworkMethod) {
        return new TheoryAnchor(frameworkMethod, this.getTestClass());
    }

    public static class TheoryAnchor
    extends Statement {
        private int successes = 0;
        private final FrameworkMethod testMethod;
        private final TestClass testClass;
        private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();

        public TheoryAnchor(FrameworkMethod frameworkMethod, TestClass testClass) {
            this.testMethod = frameworkMethod;
            this.testClass = testClass;
        }

        private TestClass getTestClass() {
            return this.testClass;
        }

        @Override
        public void evaluate() throws Throwable {
            boolean bl;
            this.runWithAssignment(Assignments.allUnassigned(this.testMethod.getMethod(), this.getTestClass()));
            boolean bl2 = bl = this.testMethod.getAnnotation(Theory.class) != null;
            if (this.successes == 0 && bl) {
                Assert.fail("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters);
            }
        }

        protected void runWithAssignment(Assignments assignments) throws Throwable {
            if (!assignments.isComplete()) {
                this.runWithIncompleteAssignment(assignments);
            } else {
                this.runWithCompleteAssignment(assignments);
            }
        }

        protected void runWithIncompleteAssignment(Assignments assignments) throws Throwable {
            for (PotentialAssignment potentialAssignment : assignments.potentialsForNextUnassigned()) {
                this.runWithAssignment(assignments.assignNext(potentialAssignment));
            }
        }

        protected void runWithCompleteAssignment(final Assignments assignments) throws Throwable {
            new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

                @Override
                protected void collectInitializationErrors(List<Throwable> list) {
                }

                @Override
                public Statement methodBlock(FrameworkMethod frameworkMethod) {
                    final Statement statement = super.methodBlock(frameworkMethod);
                    return new Statement(){

                        @Override
                        public void evaluate() throws Throwable {
                            try {
                                statement.evaluate();
                                TheoryAnchor.this.handleDataPointSuccess();
                            }
                            catch (AssumptionViolatedException assumptionViolatedException) {
                                TheoryAnchor.this.handleAssumptionViolation(assumptionViolatedException);
                            }
                            catch (Throwable throwable) {
                                TheoryAnchor.this.reportParameterizedError(throwable, assignments.getArgumentStrings(TheoryAnchor.this.nullsOk()));
                            }
                        }
                    };
                }

                @Override
                protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object object) {
                    return TheoryAnchor.this.methodCompletesWithParameters(frameworkMethod, assignments, object);
                }

                @Override
                public Object createTest() throws Exception {
                    Object[] objectArray = assignments.getConstructorArguments();
                    if (!TheoryAnchor.this.nullsOk()) {
                        Assume.assumeNotNull(objectArray);
                    }
                    return this.getTestClass().getOnlyConstructor().newInstance(objectArray);
                }
            }.methodBlock(this.testMethod).evaluate();
        }

        private Statement methodCompletesWithParameters(final FrameworkMethod frameworkMethod, final Assignments assignments, final Object object) {
            return new Statement(){

                @Override
                public void evaluate() throws Throwable {
                    Object[] objectArray = assignments.getMethodArguments();
                    if (!TheoryAnchor.this.nullsOk()) {
                        Assume.assumeNotNull(objectArray);
                    }
                    frameworkMethod.invokeExplosively(object, objectArray);
                }
            };
        }

        protected void handleAssumptionViolation(AssumptionViolatedException assumptionViolatedException) {
            this.fInvalidParameters.add(assumptionViolatedException);
        }

        protected void reportParameterizedError(Throwable throwable, Object ... objectArray) throws Throwable {
            if (objectArray.length == 0) {
                throw throwable;
            }
            throw new ParameterizedAssertionError(throwable, this.testMethod.getName(), objectArray);
        }

        private boolean nullsOk() {
            Theory theory = this.testMethod.getMethod().getAnnotation(Theory.class);
            if (theory == null) {
                return false;
            }
            return theory.nullsAccepted();
        }

        protected void handleDataPointSuccess() {
            ++this.successes;
        }
    }
}

