/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.builders;

import java.lang.reflect.Modifier;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class AnnotatedBuilder
extends RunnerBuilder {
    private static final String CONSTRUCTOR_ERROR_FORMAT = "Custom runner class %s should have a public constructor with signature %s(Class testClass)";
    private final RunnerBuilder suiteBuilder;

    public AnnotatedBuilder(RunnerBuilder runnerBuilder) {
        this.suiteBuilder = runnerBuilder;
    }

    @Override
    public Runner runnerForClass(Class<?> clazz) throws Exception {
        Class<?> clazz2 = clazz;
        while (clazz2 != null) {
            RunWith runWith = clazz2.getAnnotation(RunWith.class);
            if (runWith != null) {
                return this.buildRunner(runWith.value(), clazz);
            }
            clazz2 = this.getEnclosingClassForNonStaticMemberClass(clazz2);
        }
        return null;
    }

    private Class<?> getEnclosingClassForNonStaticMemberClass(Class<?> clazz) {
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            return clazz.getEnclosingClass();
        }
        return null;
    }

    public Runner buildRunner(Class<? extends Runner> clazz, Class<?> clazz2) throws Exception {
        try {
            return clazz.getConstructor(Class.class).newInstance(clazz2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getConstructor(Class.class, RunnerBuilder.class).newInstance(clazz2, this.suiteBuilder);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                String string = clazz.getSimpleName();
                throw new InitializationError(String.format(CONSTRUCTOR_ERROR_FORMAT, string, string));
            }
        }
    }
}

