/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.Statement;

public class ExpectException
extends Statement {
    private final Statement next;
    private final Class<? extends Throwable> expected;

    public ExpectException(Statement statement, Class<? extends Throwable> clazz) {
        this.next = statement;
        this.expected = clazz;
    }

    @Override
    public void evaluate() throws Exception {
        boolean bl;
        block4: {
            bl = false;
            try {
                this.next.evaluate();
                bl = true;
            }
            catch (AssumptionViolatedException assumptionViolatedException) {
                throw assumptionViolatedException;
            }
            catch (Throwable throwable) {
                if (this.expected.isAssignableFrom(throwable.getClass())) break block4;
                String string = "Unexpected exception, expected<" + this.expected.getName() + "> but was<" + throwable.getClass().getName() + ">";
                throw new Exception(string, throwable);
            }
        }
        if (bl) {
            throw new AssertionError((Object)("Expected exception: " + this.expected.getName()));
        }
    }
}

