/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public abstract class TestWatcher
implements TestRule {
    @Override
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
                TestWatcher.this.startingQuietly(description, arrayList);
                try {
                    statement.evaluate();
                    TestWatcher.this.succeededQuietly(description, arrayList);
                }
                catch (org.junit.internal.AssumptionViolatedException assumptionViolatedException) {
                    arrayList.add(assumptionViolatedException);
                    TestWatcher.this.skippedQuietly(assumptionViolatedException, description, arrayList);
                }
                catch (Throwable throwable) {
                    arrayList.add(throwable);
                    TestWatcher.this.failedQuietly(throwable, description, arrayList);
                }
                finally {
                    TestWatcher.this.finishedQuietly(description, arrayList);
                }
                MultipleFailureException.assertEmpty(arrayList);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> list) {
        try {
            this.succeeded(description);
        }
        catch (Throwable throwable) {
            list.add(throwable);
        }
    }

    private void failedQuietly(Throwable throwable, Description description, List<Throwable> list) {
        try {
            this.failed(throwable, description);
        }
        catch (Throwable throwable2) {
            list.add(throwable2);
        }
    }

    private void skippedQuietly(org.junit.internal.AssumptionViolatedException assumptionViolatedException, Description description, List<Throwable> list) {
        try {
            if (assumptionViolatedException instanceof AssumptionViolatedException) {
                this.skipped((AssumptionViolatedException)assumptionViolatedException, description);
            } else {
                this.skipped(assumptionViolatedException, description);
            }
        }
        catch (Throwable throwable) {
            list.add(throwable);
        }
    }

    private void startingQuietly(Description description, List<Throwable> list) {
        try {
            this.starting(description);
        }
        catch (Throwable throwable) {
            list.add(throwable);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> list) {
        try {
            this.finished(description);
        }
        catch (Throwable throwable) {
            list.add(throwable);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable throwable, Description description) {
    }

    protected void skipped(AssumptionViolatedException assumptionViolatedException, Description description) {
        AssumptionViolatedException assumptionViolatedException2 = assumptionViolatedException;
        this.skipped((org.junit.internal.AssumptionViolatedException)assumptionViolatedException2, description);
    }

    @Deprecated
    protected void skipped(org.junit.internal.AssumptionViolatedException assumptionViolatedException, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

