/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import org.junit.internal.Classes;
import org.junit.runner.Description;
import org.junit.runner.FilterFactory;
import org.junit.runner.FilterFactoryParams;
import org.junit.runner.Request;
import org.junit.runner.manipulation.Filter;

class FilterFactories {
    FilterFactories() {
    }

    public static Filter createFilterFromFilterSpec(Request request, String string) throws FilterFactory.FilterNotCreatedException {
        Description description = request.getRunner().getDescription();
        String[] stringArray = string.contains("=") ? string.split("=", 2) : new String[]{string, ""};
        return FilterFactories.createFilter(stringArray[0], new FilterFactoryParams(description, stringArray[1]));
    }

    public static Filter createFilter(String string, FilterFactoryParams filterFactoryParams) throws FilterFactory.FilterNotCreatedException {
        FilterFactory filterFactory = FilterFactories.createFilterFactory(string);
        return filterFactory.createFilter(filterFactoryParams);
    }

    public static Filter createFilter(Class<? extends FilterFactory> clazz, FilterFactoryParams filterFactoryParams) throws FilterFactory.FilterNotCreatedException {
        FilterFactory filterFactory = FilterFactories.createFilterFactory(clazz);
        return filterFactory.createFilter(filterFactoryParams);
    }

    static FilterFactory createFilterFactory(String string) throws FilterFactory.FilterNotCreatedException {
        Class<FilterFactory> clazz;
        try {
            clazz = Classes.getClass(string).asSubclass(FilterFactory.class);
        }
        catch (Exception exception) {
            throw new FilterFactory.FilterNotCreatedException(exception);
        }
        return FilterFactories.createFilterFactory(clazz);
    }

    static FilterFactory createFilterFactory(Class<? extends FilterFactory> clazz) throws FilterFactory.FilterNotCreatedException {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new FilterFactory.FilterNotCreatedException(exception);
        }
    }
}

