/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.manipulation;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;

public abstract class Filter {
    public static final Filter ALL = new Filter(){

        @Override
        public boolean shouldRun(Description description) {
            return true;
        }

        @Override
        public String describe() {
            return "all tests";
        }

        @Override
        public void apply(Object object) throws NoTestsRemainException {
        }

        @Override
        public Filter intersect(Filter filter) {
            return filter;
        }
    };

    public static Filter matchMethodDescription(final Description description) {
        return new Filter(){

            @Override
            public boolean shouldRun(Description description3) {
                if (description3.isTest()) {
                    return description.equals(description3);
                }
                for (Description description2 : description3.getChildren()) {
                    if (!this.shouldRun(description2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String describe() {
                return String.format("Method %s", description.getDisplayName());
            }
        };
    }

    public abstract boolean shouldRun(Description var1);

    public abstract String describe();

    public void apply(Object object) throws NoTestsRemainException {
        if (!(object instanceof Filterable)) {
            return;
        }
        Filterable filterable = (Filterable)object;
        filterable.filter(this);
    }

    public Filter intersect(final Filter filter) {
        if (filter == this || filter == ALL) {
            return this;
        }
        final Filter filter2 = this;
        return new Filter(){

            @Override
            public boolean shouldRun(Description description) {
                return filter2.shouldRun(description) && filter.shouldRun(description);
            }

            @Override
            public String describe() {
                return filter2.describe() + " and " + filter.describe();
            }
        };
    }
}

