/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParametersFactory;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;

public class Parameterized
extends Suite {
    private static final ParametersRunnerFactory DEFAULT_FACTORY = new BlockJUnit4ClassRunnerWithParametersFactory();
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final List<Runner> runners;

    public Parameterized(Class<?> clazz) throws Throwable {
        super(clazz, NO_RUNNERS);
        ParametersRunnerFactory parametersRunnerFactory = this.getParametersRunnerFactory(clazz);
        Parameters parameters = this.getParametersMethod().getAnnotation(Parameters.class);
        this.runners = Collections.unmodifiableList(this.createRunnersForParameters(this.allParameters(), parameters.name(), parametersRunnerFactory));
    }

    private ParametersRunnerFactory getParametersRunnerFactory(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        UseParametersRunnerFactory useParametersRunnerFactory = clazz.getAnnotation(UseParametersRunnerFactory.class);
        if (useParametersRunnerFactory == null) {
            return DEFAULT_FACTORY;
        }
        Class<? extends ParametersRunnerFactory> clazz2 = useParametersRunnerFactory.value();
        return clazz2.newInstance();
    }

    @Override
    protected List<Runner> getChildren() {
        return this.runners;
    }

    private TestWithParameters createTestWithNotNormalizedParameters(String string, int n, Object object) {
        Object[] objectArray;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        Object[] objectArray3 = objectArray;
        return Parameterized.createTestWithParameters(this.getTestClass(), string, n, objectArray3);
    }

    private Iterable<Object> allParameters() throws Throwable {
        Object object = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(Parameters.class);
        for (FrameworkMethod frameworkMethod : list) {
            if (!frameworkMethod.isStatic() || !frameworkMethod.isPublic()) continue;
            return frameworkMethod;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private List<Runner> createRunnersForParameters(Iterable<Object> iterable, String string, ParametersRunnerFactory parametersRunnerFactory) throws InitializationError, Exception {
        try {
            List<TestWithParameters> list = this.createTestsForParameters(iterable, string);
            ArrayList<Runner> arrayList = new ArrayList<Runner>();
            for (TestWithParameters testWithParameters : list) {
                arrayList.add(parametersRunnerFactory.createRunnerForTestWithParameters(testWithParameters));
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private List<TestWithParameters> createTestsForParameters(Iterable<Object> iterable, String string) throws Exception {
        int n = 0;
        ArrayList<TestWithParameters> arrayList = new ArrayList<TestWithParameters>();
        for (Object object : iterable) {
            arrayList.add(this.createTestWithNotNormalizedParameters(string, n++, object));
        }
        return arrayList;
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String string = this.getTestClass().getName();
        String string2 = this.getParametersMethod().getName();
        String string3 = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", string, string2);
        return new Exception(string3);
    }

    private static TestWithParameters createTestWithParameters(TestClass testClass, String string, int n, Object[] objectArray) {
        String string2 = string.replaceAll("\\{index\\}", Integer.toString(n));
        String string3 = MessageFormat.format(string2, objectArray);
        return new TestWithParameters("[" + string3 + "]", testClass, Arrays.asList(objectArray));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Target(value={ElementType.TYPE})
    public static @interface UseParametersRunnerFactory {
        public Class<? extends ParametersRunnerFactory> value() default BlockJUnit4ClassRunnerWithParametersFactory.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "{index}";
    }
}

