/*
 * Decompiled with CFR 0.152.
 */
package org.junit.validator;

import java.util.concurrent.ConcurrentHashMap;
import org.junit.validator.AnnotationValidator;
import org.junit.validator.ValidateWith;

public class AnnotationValidatorFactory {
    private static final ConcurrentHashMap<ValidateWith, AnnotationValidator> VALIDATORS_FOR_ANNOTATION_TYPES = new ConcurrentHashMap();

    public AnnotationValidator createAnnotationValidator(ValidateWith validateWith) {
        AnnotationValidator annotationValidator = VALIDATORS_FOR_ANNOTATION_TYPES.get(validateWith);
        if (annotationValidator != null) {
            return annotationValidator;
        }
        Class<? extends AnnotationValidator> clazz = validateWith.value();
        if (clazz == null) {
            throw new IllegalArgumentException("Can't create validator, value is null in annotation " + validateWith.getClass().getName());
        }
        try {
            AnnotationValidator annotationValidator2 = clazz.newInstance();
            VALIDATORS_FOR_ANNOTATION_TYPES.putIfAbsent(validateWith, annotationValidator2);
            return VALIDATORS_FOR_ANNOTATION_TYPES.get(validateWith);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception received when creating AnnotationValidator class " + clazz.getName(), exception);
        }
    }
}

