/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.results;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.experimental.results.PrintableResult;

public class ResultMatchers {
    public static Matcher<PrintableResult> isSuccessful() {
        return ResultMatchers.failureCountIs(0);
    }

    public static Matcher<PrintableResult> failureCountIs(final int n) {
        return new TypeSafeMatcher<PrintableResult>(){

            public void describeTo(Description description) {
                description.appendText("has " + n + " failures");
            }

            public boolean matchesSafely(PrintableResult printableResult) {
                return printableResult.failureCount() == n;
            }
        };
    }

    public static Matcher<Object> hasSingleFailureContaining(final String string) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object object) {
                return object.toString().contains(string) && ResultMatchers.failureCountIs(1).matches(object);
            }

            public void describeTo(Description description) {
                description.appendText("has single failure containing " + string);
            }
        };
    }

    public static Matcher<PrintableResult> hasFailureContaining(final String string) {
        return new BaseMatcher<PrintableResult>(){

            public boolean matches(Object object) {
                return object.toString().contains(string);
            }

            public void describeTo(Description description) {
                description.appendText("has failure containing " + string);
            }
        };
    }
}

