/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assume;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class AllMembersSupplier
extends ParameterSupplier {
    private final TestClass clazz;

    public AllMembersSupplier(TestClass testClass) {
        this.clazz = testClass;
    }

    @Override
    public List<PotentialAssignment> getValueSources(ParameterSignature parameterSignature) throws Throwable {
        ArrayList<PotentialAssignment> arrayList = new ArrayList<PotentialAssignment>();
        this.addSinglePointFields(parameterSignature, arrayList);
        this.addMultiPointFields(parameterSignature, arrayList);
        this.addSinglePointMethods(parameterSignature, arrayList);
        this.addMultiPointMethods(parameterSignature, arrayList);
        return arrayList;
    }

    private void addMultiPointMethods(ParameterSignature parameterSignature, List<PotentialAssignment> list) throws Throwable {
        for (FrameworkMethod frameworkMethod : this.getDataPointsMethods(parameterSignature)) {
            Class<?> clazz = frameworkMethod.getReturnType();
            if ((!clazz.isArray() || !parameterSignature.canPotentiallyAcceptType(clazz.getComponentType())) && !Iterable.class.isAssignableFrom(clazz)) continue;
            try {
                this.addDataPointsValues(clazz, parameterSignature, frameworkMethod.getName(), list, frameworkMethod.invokeExplosively(null, new Object[0]));
            }
            catch (Throwable throwable) {
                DataPoints dataPoints = frameworkMethod.getAnnotation(DataPoints.class);
                if (dataPoints != null && AllMembersSupplier.isAssignableToAnyOf(dataPoints.ignoredExceptions(), throwable)) {
                    return;
                }
                throw throwable;
            }
        }
    }

    private void addSinglePointMethods(ParameterSignature parameterSignature, List<PotentialAssignment> list) {
        for (FrameworkMethod frameworkMethod : this.getSingleDataPointMethods(parameterSignature)) {
            if (!parameterSignature.canAcceptType(frameworkMethod.getType())) continue;
            list.add(new MethodParameterValue(frameworkMethod));
        }
    }

    private void addMultiPointFields(ParameterSignature parameterSignature, List<PotentialAssignment> list) {
        for (Field field : this.getDataPointsFields(parameterSignature)) {
            Class<?> clazz = field.getType();
            this.addDataPointsValues(clazz, parameterSignature, field.getName(), list, this.getStaticFieldValue(field));
        }
    }

    private void addSinglePointFields(ParameterSignature parameterSignature, List<PotentialAssignment> list) {
        for (Field field : this.getSingleDataPointFields(parameterSignature)) {
            Object object = this.getStaticFieldValue(field);
            if (!parameterSignature.canAcceptValue(object)) continue;
            list.add(PotentialAssignment.forValue(field.getName(), object));
        }
    }

    private void addDataPointsValues(Class<?> clazz, ParameterSignature parameterSignature, String string, List<PotentialAssignment> list, Object object) {
        if (clazz.isArray()) {
            this.addArrayValues(parameterSignature, string, list, object);
        } else if (Iterable.class.isAssignableFrom(clazz)) {
            this.addIterableValues(parameterSignature, string, list, (Iterable)object);
        }
    }

    private void addArrayValues(ParameterSignature parameterSignature, String string, List<PotentialAssignment> list, Object object) {
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2 = Array.get(object, i);
            if (!parameterSignature.canAcceptValue(object2)) continue;
            list.add(PotentialAssignment.forValue(string + "[" + i + "]", object2));
        }
    }

    private void addIterableValues(ParameterSignature parameterSignature, String string, List<PotentialAssignment> list, Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (parameterSignature.canAcceptValue(obj)) {
                list.add(PotentialAssignment.forValue(string + "[" + n + "]", obj));
            }
            ++n;
        }
    }

    private Object getStaticFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("unexpected: field from getClass doesn't exist on object");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected: getFields returned an inaccessible field");
        }
    }

    private static boolean isAssignableToAnyOf(Class<?>[] classArray, Object object) {
        for (Class<?> clazz : classArray) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    protected Collection<FrameworkMethod> getDataPointsMethods(ParameterSignature parameterSignature) {
        return this.clazz.getAnnotatedMethods(DataPoints.class);
    }

    protected Collection<Field> getSingleDataPointFields(ParameterSignature parameterSignature) {
        List<FrameworkField> list = this.clazz.getAnnotatedFields(DataPoint.class);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (FrameworkField frameworkField : list) {
            arrayList.add(frameworkField.getField());
        }
        return arrayList;
    }

    protected Collection<Field> getDataPointsFields(ParameterSignature parameterSignature) {
        List<FrameworkField> list = this.clazz.getAnnotatedFields(DataPoints.class);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (FrameworkField frameworkField : list) {
            arrayList.add(frameworkField.getField());
        }
        return arrayList;
    }

    protected Collection<FrameworkMethod> getSingleDataPointMethods(ParameterSignature parameterSignature) {
        return this.clazz.getAnnotatedMethods(DataPoint.class);
    }

    static class MethodParameterValue
    extends PotentialAssignment {
        private final FrameworkMethod method;

        private MethodParameterValue(FrameworkMethod frameworkMethod) {
            this.method = frameworkMethod;
        }

        @Override
        public Object getValue() throws PotentialAssignment.CouldNotGenerateValueException {
            try {
                return this.method.invokeExplosively(null, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("unexpected: argument length is checked");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected: getMethods returned an inaccessible method");
            }
            catch (Throwable throwable) {
                DataPoint dataPoint = this.method.getAnnotation(DataPoint.class);
                Assume.assumeTrue(dataPoint == null || !AllMembersSupplier.isAssignableToAnyOf(dataPoint.ignoredExceptions(), throwable));
                throw new PotentialAssignment.CouldNotGenerateValueException(throwable);
            }
        }

        @Override
        public String getDescription() throws PotentialAssignment.CouldNotGenerateValueException {
            return this.method.getName();
        }
    }
}

