/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private volatile Test test;

    public JUnit38ClassRunner(Class<?> clazz) {
        this(new TestSuite((Class<?>)clazz.asSubclass(TestCase.class)));
    }

    public JUnit38ClassRunner(Test test) {
        this.setTest(test);
    }

    @Override
    public void run(RunNotifier runNotifier) {
        TestResult testResult = new TestResult();
        testResult.addListener(this.createAdaptingListener(runNotifier));
        this.getTest().run(testResult);
    }

    public TestListener createAdaptingListener(RunNotifier runNotifier) {
        return new OldTestClassAdaptingListener(runNotifier);
    }

    @Override
    public Description getDescription() {
        return JUnit38ClassRunner.makeDescription(this.getTest());
    }

    private static Description makeDescription(Test test) {
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            return Description.createTestDescription(testCase.getClass(), testCase.getName(), JUnit38ClassRunner.getAnnotations(testCase));
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            String string = testSuite.getName() == null ? JUnit38ClassRunner.createSuiteDescription(testSuite) : testSuite.getName();
            Description description = Description.createSuiteDescription(string, new Annotation[0]);
            int n = testSuite.testCount();
            for (int i = 0; i < n; ++i) {
                Description description2 = JUnit38ClassRunner.makeDescription(testSuite.testAt(i));
                description.addChild(description2);
            }
            return description;
        }
        if (test instanceof Describable) {
            Describable describable = (Describable)((Object)test);
            return describable.getDescription();
        }
        if (test instanceof TestDecorator) {
            TestDecorator testDecorator = (TestDecorator)test;
            return JUnit38ClassRunner.makeDescription(testDecorator.getTest());
        }
        return Description.createSuiteDescription(test.getClass());
    }

    private static Annotation[] getAnnotations(TestCase testCase) {
        try {
            Method method = testCase.getClass().getMethod(testCase.getName(), new Class[0]);
            return method.getDeclaredAnnotations();
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Annotation[0];
    }

    private static String createSuiteDescription(TestSuite testSuite) {
        int n = testSuite.countTestCases();
        String string = n == 0 ? "" : String.format(" [example: %s]", testSuite.testAt(0));
        return String.format("TestSuite with %s tests%s", n, string);
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.getTest() instanceof Filterable) {
            Filterable filterable = (Filterable)((Object)this.getTest());
            filterable.filter(filter);
        } else if (this.getTest() instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)this.getTest();
            TestSuite testSuite2 = new TestSuite(testSuite.getName());
            int n = testSuite.testCount();
            for (int i = 0; i < n; ++i) {
                Test test = testSuite.testAt(i);
                if (!filter.shouldRun(JUnit38ClassRunner.makeDescription(test))) continue;
                testSuite2.addTest(test);
            }
            this.setTest(testSuite2);
            if (testSuite2.testCount() == 0) {
                throw new NoTestsRemainException();
            }
        }
    }

    @Override
    public void sort(Sorter sorter) {
        if (this.getTest() instanceof Sortable) {
            Sortable sortable = (Sortable)((Object)this.getTest());
            sortable.sort(sorter);
        }
    }

    private void setTest(Test test) {
        this.test = test;
    }

    private Test getTest() {
        return this.test;
    }

    private static final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier notifier;

        private OldTestClassAdaptingListener(RunNotifier runNotifier) {
            this.notifier = runNotifier;
        }

        @Override
        public void endTest(Test test) {
            this.notifier.fireTestFinished(this.asDescription(test));
        }

        @Override
        public void startTest(Test test) {
            this.notifier.fireTestStarted(this.asDescription(test));
        }

        @Override
        public void addError(Test test, Throwable throwable) {
            Failure failure = new Failure(this.asDescription(test), throwable);
            this.notifier.fireTestFailure(failure);
        }

        private Description asDescription(Test test) {
            if (test instanceof Describable) {
                Describable describable = (Describable)((Object)test);
                return describable.getDescription();
            }
            return Description.createTestDescription(this.getEffectiveClass(test), this.getName(test));
        }

        private Class<? extends Test> getEffectiveClass(Test test) {
            return test.getClass();
        }

        private String getName(Test test) {
            if (test instanceof TestCase) {
                return ((TestCase)test).getName();
            }
            return test.toString();
        }

        @Override
        public void addFailure(Test test, AssertionFailedError assertionFailedError) {
            this.addError(test, (Throwable)((Object)assertionFailedError));
        }
    }
}

