/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.model;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.MultipleFailureException;

public class EachTestNotifier {
    private final RunNotifier notifier;
    private final Description description;

    public EachTestNotifier(RunNotifier runNotifier, Description description) {
        this.notifier = runNotifier;
        this.description = description;
    }

    public void addFailure(Throwable throwable) {
        if (throwable instanceof MultipleFailureException) {
            this.addMultipleFailureException((MultipleFailureException)throwable);
        } else {
            this.notifier.fireTestFailure(new Failure(this.description, throwable));
        }
    }

    private void addMultipleFailureException(MultipleFailureException multipleFailureException) {
        for (Throwable throwable : multipleFailureException.getFailures()) {
            this.addFailure(throwable);
        }
    }

    public void addFailedAssumption(AssumptionViolatedException assumptionViolatedException) {
        this.notifier.fireTestAssumptionFailed(new Failure(this.description, assumptionViolatedException));
    }

    public void fireTestFinished() {
        this.notifier.fireTestFinished(this.description);
    }

    public void fireTestStarted() {
        this.notifier.fireTestStarted(this.description);
    }

    public void fireTestIgnored() {
        this.notifier.fireTestIgnored(this.description);
    }
}

