/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import junit.framework.Test;
import junit.runner.Version;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.internal.TextListener;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCommandLineParseResult;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnitCore {
    private final RunNotifier notifier = new RunNotifier();

    public static void main(String ... stringArray) {
        Result result = new JUnitCore().runMain(new RealSystem(), stringArray);
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static Result runClasses(Class<?> ... classArray) {
        return JUnitCore.runClasses(JUnitCore.defaultComputer(), classArray);
    }

    public static Result runClasses(Computer computer, Class<?> ... classArray) {
        return new JUnitCore().run(computer, classArray);
    }

    Result runMain(JUnitSystem jUnitSystem, String ... stringArray) {
        jUnitSystem.out().println("JUnit version " + Version.id());
        JUnitCommandLineParseResult jUnitCommandLineParseResult = JUnitCommandLineParseResult.parse(stringArray);
        TextListener textListener = new TextListener(jUnitSystem);
        this.addListener(textListener);
        return this.run(jUnitCommandLineParseResult.createRequest(JUnitCore.defaultComputer()));
    }

    public String getVersion() {
        return Version.id();
    }

    public Result run(Class<?> ... classArray) {
        return this.run(JUnitCore.defaultComputer(), classArray);
    }

    public Result run(Computer computer, Class<?> ... classArray) {
        return this.run(Request.classes(computer, classArray));
    }

    public Result run(Request request) {
        return this.run(request.getRunner());
    }

    public Result run(Test test) {
        return this.run(new JUnit38ClassRunner(test));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run(Runner runner) {
        Result result = new Result();
        RunListener runListener = result.createListener();
        this.notifier.addFirstListener(runListener);
        try {
            this.notifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.notifier);
            this.notifier.fireTestRunFinished(result);
        }
        finally {
            this.removeListener(runListener);
        }
        return result;
    }

    public void addListener(RunListener runListener) {
        this.notifier.addListener(runListener);
    }

    public void removeListener(RunListener runListener) {
        this.notifier.removeListener(runListener);
    }

    static Computer defaultComputer() {
        return new Computer();
    }
}

