/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.lookup(SerializedForm.class).getFields();
    private final AtomicInteger count;
    private final AtomicInteger ignoreCount;
    private final CopyOnWriteArrayList<Failure> failures;
    private final AtomicLong runTime;
    private final AtomicLong startTime;
    private SerializedForm serializedForm;

    public Result() {
        this.count = new AtomicInteger();
        this.ignoreCount = new AtomicInteger();
        this.failures = new CopyOnWriteArrayList();
        this.runTime = new AtomicLong();
        this.startTime = new AtomicLong();
    }

    private Result(SerializedForm serializedForm) {
        this.count = serializedForm.fCount;
        this.ignoreCount = serializedForm.fIgnoreCount;
        this.failures = new CopyOnWriteArrayList(serializedForm.fFailures);
        this.runTime = new AtomicLong(serializedForm.fRunTime);
        this.startTime = new AtomicLong(serializedForm.fStartTime);
    }

    public int getRunCount() {
        return this.count.get();
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public long getRunTime() {
        return this.runTime.get();
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public int getIgnoreCount() {
        return this.ignoreCount.get();
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SerializedForm serializedForm = new SerializedForm(this);
        serializedForm.serialize(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.serializedForm = SerializedForm.deserialize(objectInputStream);
    }

    private Object readResolve() {
        return new Result(this.serializedForm);
    }

    public RunListener createListener() {
        return new Listener();
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final AtomicInteger fCount;
        private final AtomicInteger fIgnoreCount;
        private final List<Failure> fFailures;
        private final long fRunTime;
        private final long fStartTime;

        public SerializedForm(Result result) {
            this.fCount = result.count;
            this.fIgnoreCount = result.ignoreCount;
            this.fFailures = Collections.synchronizedList(new ArrayList(result.failures));
            this.fRunTime = result.runTime.longValue();
            this.fStartTime = result.startTime.longValue();
        }

        private SerializedForm(ObjectInputStream.GetField getField) throws IOException {
            this.fCount = (AtomicInteger)getField.get("fCount", null);
            this.fIgnoreCount = (AtomicInteger)getField.get("fIgnoreCount", null);
            this.fFailures = (List)getField.get("fFailures", null);
            this.fRunTime = getField.get("fRunTime", 0L);
            this.fStartTime = getField.get("fStartTime", 0L);
        }

        public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("fCount", this.fCount);
            putField.put("fIgnoreCount", this.fIgnoreCount);
            putField.put("fFailures", this.fFailures);
            putField.put("fRunTime", this.fRunTime);
            putField.put("fStartTime", this.fStartTime);
            objectOutputStream.writeFields();
        }

        public static SerializedForm deserialize(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            return new SerializedForm(getField);
        }
    }

    @RunListener.ThreadSafe
    private class Listener
    extends RunListener {
        private Listener() {
        }

        @Override
        public void testRunStarted(Description description) throws Exception {
            Result.this.startTime.set(System.currentTimeMillis());
        }

        @Override
        public void testRunFinished(Result result) throws Exception {
            long l = System.currentTimeMillis();
            Result.this.runTime.addAndGet(l - Result.this.startTime.get());
        }

        @Override
        public void testFinished(Description description) throws Exception {
            Result.this.count.getAndIncrement();
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            Result.this.failures.add(failure);
        }

        @Override
        public void testIgnored(Description description) throws Exception {
            Result.this.ignoreCount.getAndIncrement();
        }

        @Override
        public void testAssumptionFailure(Failure failure) {
        }
    }
}

