/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.junit.validator.AnnotationsValidator;
import org.junit.validator.PublicClassValidator;
import org.junit.validator.TestClassValidator;

public abstract class ParentRunner<T>
extends Runner
implements Filterable,
Sortable {
    private static final List<TestClassValidator> VALIDATORS = Arrays.asList(new AnnotationsValidator(), new PublicClassValidator());
    private final Object childrenLock = new Object();
    private final TestClass testClass;
    private volatile Collection<T> filteredChildren = null;
    private volatile RunnerScheduler scheduler = new RunnerScheduler(){

        @Override
        public void schedule(Runnable runnable) {
            runnable.run();
        }

        @Override
        public void finished() {
        }
    };

    protected ParentRunner(Class<?> clazz) throws InitializationError {
        this.testClass = this.createTestClass(clazz);
        this.validate();
    }

    protected TestClass createTestClass(Class<?> clazz) {
        return new TestClass(clazz);
    }

    protected abstract List<T> getChildren();

    protected abstract Description describeChild(T var1);

    protected abstract void runChild(T var1, RunNotifier var2);

    protected void collectInitializationErrors(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, list);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, list);
        this.validateClassRules(list);
        this.applyValidators(list);
    }

    private void applyValidators(List<Throwable> list) {
        if (this.getTestClass().getJavaClass() != null) {
            for (TestClassValidator testClassValidator : VALIDATORS) {
                list.addAll(testClassValidator.validateTestClass(this.getTestClass()));
            }
        }
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> clazz, boolean bl, List<Throwable> list) {
        List<FrameworkMethod> list2 = this.getTestClass().getAnnotatedMethods(clazz);
        for (FrameworkMethod frameworkMethod : list2) {
            frameworkMethod.validatePublicVoidNoArg(bl, list);
        }
    }

    private void validateClassRules(List<Throwable> list) {
        RuleMemberValidator.CLASS_RULE_VALIDATOR.validate(this.getTestClass(), list);
        RuleMemberValidator.CLASS_RULE_METHOD_VALIDATOR.validate(this.getTestClass(), list);
    }

    protected Statement classBlock(RunNotifier runNotifier) {
        Statement statement = this.childrenInvoker(runNotifier);
        if (!this.areAllChildrenIgnored()) {
            statement = this.withBeforeClasses(statement);
            statement = this.withAfterClasses(statement);
            statement = this.withClassRules(statement);
        }
        return statement;
    }

    private boolean areAllChildrenIgnored() {
        for (T t : this.getFilteredChildren()) {
            if (this.isIgnored(t)) continue;
            return false;
        }
        return true;
    }

    protected Statement withBeforeClasses(Statement statement) {
        List<FrameworkMethod> list = this.testClass.getAnnotatedMethods(BeforeClass.class);
        return list.isEmpty() ? statement : new RunBefores(statement, list, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List<FrameworkMethod> list = this.testClass.getAnnotatedMethods(AfterClass.class);
        return list.isEmpty() ? statement : new RunAfters(statement, list, null);
    }

    private Statement withClassRules(Statement statement) {
        List<TestRule> list = this.classRules();
        return list.isEmpty() ? statement : new RunRules(statement, list, this.getDescription());
    }

    protected List<TestRule> classRules() {
        List<TestRule> list = this.testClass.getAnnotatedMethodValues(null, ClassRule.class, TestRule.class);
        list.addAll(this.testClass.getAnnotatedFieldValues(null, ClassRule.class, TestRule.class));
        return list;
    }

    protected Statement childrenInvoker(final RunNotifier runNotifier) {
        return new Statement(){

            @Override
            public void evaluate() {
                ParentRunner.this.runChildren(runNotifier);
            }
        };
    }

    protected boolean isIgnored(T t) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runChildren(final RunNotifier runNotifier) {
        RunnerScheduler runnerScheduler = this.scheduler;
        try {
            for (final T t : this.getFilteredChildren()) {
                runnerScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ParentRunner.this.runChild(t, runNotifier);
                    }
                });
            }
        }
        finally {
            runnerScheduler.finished();
        }
    }

    protected String getName() {
        return this.testClass.getName();
    }

    public final TestClass getTestClass() {
        return this.testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runLeaf(Statement statement, Description description, RunNotifier runNotifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, description);
        eachTestNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            eachTestNotifier.addFailedAssumption(assumptionViolatedException);
        }
        catch (Throwable throwable) {
            eachTestNotifier.addFailure(throwable);
        }
        finally {
            eachTestNotifier.fireTestFinished();
        }
    }

    protected Annotation[] getRunnerAnnotations() {
        return this.testClass.getAnnotations();
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.getName(), this.getRunnerAnnotations());
        for (T t : this.getFilteredChildren()) {
            description.addChild(this.describeChild(t));
        }
        return description;
    }

    @Override
    public void run(RunNotifier runNotifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, this.getDescription());
        try {
            Statement statement = this.classBlock(runNotifier);
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            eachTestNotifier.addFailedAssumption(assumptionViolatedException);
        }
        catch (StoppedByUserException stoppedByUserException) {
            throw stoppedByUserException;
        }
        catch (Throwable throwable) {
            eachTestNotifier.addFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        Object object = this.childrenLock;
        synchronized (object) {
            ArrayList<T> arrayList = new ArrayList<T>(this.getFilteredChildren());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.shouldRun(filter, e)) {
                    try {
                        filter.apply(e);
                    }
                    catch (NoTestsRemainException noTestsRemainException) {
                        iterator.remove();
                    }
                    continue;
                }
                iterator.remove();
            }
            this.filteredChildren = Collections.unmodifiableCollection(arrayList);
            if (this.filteredChildren.isEmpty()) {
                throw new NoTestsRemainException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Sorter sorter) {
        Object object = this.childrenLock;
        synchronized (object) {
            for (T t : this.getFilteredChildren()) {
                sorter.apply(t);
            }
            ArrayList<T> arrayList = new ArrayList<T>(this.getFilteredChildren());
            Collections.sort(arrayList, this.comparator(sorter));
            this.filteredChildren = Collections.unmodifiableCollection(arrayList);
        }
    }

    private void validate() throws InitializationError {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        this.collectInitializationErrors(arrayList);
        if (!arrayList.isEmpty()) {
            throw new InitializationError(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<T> getFilteredChildren() {
        if (this.filteredChildren == null) {
            Object object = this.childrenLock;
            synchronized (object) {
                if (this.filteredChildren == null) {
                    this.filteredChildren = Collections.unmodifiableCollection(this.getChildren());
                }
            }
        }
        return this.filteredChildren;
    }

    private boolean shouldRun(Filter filter, T t) {
        return filter.shouldRun(this.describeChild(t));
    }

    private Comparator<? super T> comparator(final Sorter sorter) {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return sorter.compare(ParentRunner.this.describeChild(t), ParentRunner.this.describeChild(t2));
            }
        };
    }

    public void setScheduler(RunnerScheduler runnerScheduler) {
        this.scheduler = runnerScheduler;
    }
}

