/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.NoGenericTypeParametersValidator;

public class FrameworkMethod
extends FrameworkMember<FrameworkMethod> {
    private final Method method;

    public FrameworkMethod(Method method) {
        if (method == null) {
            throw new NullPointerException("FrameworkMethod cannot be created without an underlying method.");
        }
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object invokeExplosively(final Object object, final Object ... objectArray) throws Throwable {
        return new ReflectiveCallable(){

            @Override
            protected Object runReflectiveCall() throws Throwable {
                return FrameworkMethod.this.method.invoke(object, objectArray);
            }
        }.run();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public void validatePublicVoidNoArg(boolean bl, List<Throwable> list) {
        this.validatePublicVoid(bl, list);
        if (this.method.getParameterTypes().length != 0) {
            list.add(new Exception("Method " + this.method.getName() + " should have no parameters"));
        }
    }

    public void validatePublicVoid(boolean bl, List<Throwable> list) {
        if (this.isStatic() != bl) {
            String string = bl ? "should" : "should not";
            list.add(new Exception("Method " + this.method.getName() + "() " + string + " be static"));
        }
        if (!this.isPublic()) {
            list.add(new Exception("Method " + this.method.getName() + "() should be public"));
        }
        if (this.method.getReturnType() != Void.TYPE) {
            list.add(new Exception("Method " + this.method.getName() + "() should be void"));
        }
    }

    @Override
    protected int getModifiers() {
        return this.method.getModifiers();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Class<?> getType() {
        return this.getReturnType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public void validateNoTypeParametersOnArgs(List<Throwable> list) {
        new NoGenericTypeParametersValidator(this.method).validate(list);
    }

    @Override
    public boolean isShadowedBy(FrameworkMethod frameworkMethod) {
        if (!frameworkMethod.getName().equals(this.getName())) {
            return false;
        }
        if (frameworkMethod.getParameterTypes().length != this.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < frameworkMethod.getParameterTypes().length; ++i) {
            if (frameworkMethod.getParameterTypes()[i].equals(this.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!FrameworkMethod.class.isInstance(object)) {
            return false;
        }
        return ((FrameworkMethod)object).method.equals(this.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    @Deprecated
    public boolean producesType(Type type) {
        return this.getParameterTypes().length == 0 && type instanceof Class && ((Class)type).isAssignableFrom(this.method.getReturnType());
    }

    private Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.method.getAnnotation(clazz);
    }

    public String toString() {
        return this.method.toString();
    }
}

