/*
 * Decompiled with CFR 0.152.
 */
package org.junit.validator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runners.model.Annotatable;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.junit.validator.AnnotationValidator;
import org.junit.validator.AnnotationValidatorFactory;
import org.junit.validator.TestClassValidator;
import org.junit.validator.ValidateWith;

public final class AnnotationsValidator
implements TestClassValidator {
    private static final List<AnnotatableValidator<?>> VALIDATORS = Arrays.asList(new ClassValidator(), new MethodValidator(), new FieldValidator());

    @Override
    public List<Exception> validateTestClass(TestClass testClass) {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (AnnotatableValidator<?> annotatableValidator : VALIDATORS) {
            List<Exception> list = annotatableValidator.validateTestClass(testClass);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static class FieldValidator
    extends AnnotatableValidator<FrameworkField> {
        private FieldValidator() {
        }

        @Override
        Iterable<FrameworkField> getAnnotatablesForTestClass(TestClass testClass) {
            return testClass.getAnnotatedFields();
        }

        @Override
        List<Exception> validateAnnotatable(AnnotationValidator annotationValidator, FrameworkField frameworkField) {
            return annotationValidator.validateAnnotatedField(frameworkField);
        }
    }

    private static class MethodValidator
    extends AnnotatableValidator<FrameworkMethod> {
        private MethodValidator() {
        }

        @Override
        Iterable<FrameworkMethod> getAnnotatablesForTestClass(TestClass testClass) {
            return testClass.getAnnotatedMethods();
        }

        @Override
        List<Exception> validateAnnotatable(AnnotationValidator annotationValidator, FrameworkMethod frameworkMethod) {
            return annotationValidator.validateAnnotatedMethod(frameworkMethod);
        }
    }

    private static class ClassValidator
    extends AnnotatableValidator<TestClass> {
        private ClassValidator() {
        }

        @Override
        Iterable<TestClass> getAnnotatablesForTestClass(TestClass testClass) {
            return Collections.singletonList(testClass);
        }

        @Override
        List<Exception> validateAnnotatable(AnnotationValidator annotationValidator, TestClass testClass) {
            return annotationValidator.validateAnnotatedClass(testClass);
        }
    }

    private static abstract class AnnotatableValidator<T extends Annotatable> {
        private static final AnnotationValidatorFactory ANNOTATION_VALIDATOR_FACTORY = new AnnotationValidatorFactory();

        private AnnotatableValidator() {
        }

        abstract Iterable<T> getAnnotatablesForTestClass(TestClass var1);

        abstract List<Exception> validateAnnotatable(AnnotationValidator var1, T var2);

        public List<Exception> validateTestClass(TestClass testClass) {
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (Annotatable annotatable : this.getAnnotatablesForTestClass(testClass)) {
                List<Exception> list = this.validateAnnotatable(annotatable);
                arrayList.addAll(list);
            }
            return arrayList;
        }

        private List<Exception> validateAnnotatable(T t) {
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (Annotation annotation : t.getAnnotations()) {
                Class<? extends Annotation> clazz = annotation.annotationType();
                ValidateWith validateWith = clazz.getAnnotation(ValidateWith.class);
                if (validateWith == null) continue;
                AnnotationValidator annotationValidator = ANNOTATION_VALIDATOR_FACTORY.createAnnotationValidator(validateWith);
                List<Exception> list = this.validateAnnotatable(annotationValidator, t);
                arrayList.addAll(list);
            }
            return arrayList;
        }
    }
}

