/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[54] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	ValaCodeContext* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	ValaCodeContext* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	ValaCodeContext* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	ValaCodeContext* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	ValaCodeContext* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	ValaCodeContext* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	ValaCodeContext* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	ValaCodeContext* _tmp46_ = NULL;
	ValaReport* _tmp47_ = NULL;
	ValaReport* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	ValaCodeContext* _tmp50_ = NULL;
	ValaReport* _tmp51_ = NULL;
	ValaReport* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	ValaCodeContext* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	ValaCodeContext* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	ValaCodeContext* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	ValaCodeContext* _tmp63_ = NULL;
	gboolean _tmp64_ = FALSE;
	ValaCodeContext* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_ = NULL;
	ValaCodeContext* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	ValaCodeContext* _tmp72_ = NULL;
	const gchar* _tmp73_ = NULL;
	ValaCodeContext* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	ValaCodeContext* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	ValaCodeContext* _tmp78_ = NULL;
	const gchar* _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp81_ = NULL;
	const gchar* _tmp83_ = NULL;
	const gchar* _tmp91_ = NULL;
	ValaCodeContext* _tmp100_ = NULL;
	gchar** _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	gchar** _tmp102_ = NULL;
	gint _tmp102__length1 = 0;
	ValaCodeContext* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	ValaCodeContext* _tmp105_ = NULL;
	gchar** _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	gchar** _tmp107_ = NULL;
	gint _tmp107__length1 = 0;
	ValaCodeContext* _tmp108_ = NULL;
	gchar** _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	gchar** _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	ValaCodeContext* _tmp111_ = NULL;
	gboolean _tmp112_ = FALSE;
	ValaCodeContext* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
	ValaCodeContext* _tmp115_ = NULL;
	gboolean _tmp116_ = FALSE;
	ValaCodeContext* _tmp117_ = NULL;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp122_ = FALSE;
	gboolean _tmp123_ = FALSE;
	const gchar* _tmp124_ = NULL;
	gboolean _tmp132_ = FALSE;
	const gchar* _tmp133_ = NULL;
	ValaCodeContext* _tmp134_ = NULL;
	gboolean _tmp135_ = FALSE;
	ValaCodeContext* _tmp136_ = NULL;
	const gchar* _tmp137_ = NULL;
	ValaCodeContext* _tmp138_ = NULL;
	gboolean _tmp139_ = FALSE;
	gchar** _tmp140_ = NULL;
	gint _tmp140__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp152_ = FALSE;
	const gchar* _tmp153_ = NULL;
	ValaCodeContext* _tmp156_ = NULL;
	gint _tmp157_ = 0;
	ValaCodeContext* _tmp158_ = NULL;
	gint _tmp159_ = 0;
	ValaCodeContext* _tmp160_ = NULL;
	gint _tmp161_ = 0;
	gint _tmp162_ = 0;
	gboolean _tmp171_ = FALSE;
	gchar** _tmp174_ = NULL;
	gint _tmp174__length1 = 0;
	gchar** _tmp179_ = NULL;
	gint _tmp179__length1 = 0;
	ValaCodeContext* _tmp190_ = NULL;
	gchar** _tmp191_ = NULL;
	gint _tmp191__length1 = 0;
	gchar** _tmp192_ = NULL;
	gint _tmp192__length1 = 0;
	gboolean _tmp193_ = FALSE;
	ValaCodeContext* _tmp194_ = NULL;
	ValaReport* _tmp195_ = NULL;
	ValaReport* _tmp196_ = NULL;
	gint _tmp197_ = 0;
	ValaCodeContext* _tmp205_ = NULL;
	ValaGDBusServerModule* _tmp206_ = NULL;
	ValaGDBusServerModule* _tmp207_ = NULL;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp208_ = NULL;
	gint _tmp208__length1 = 0;
	gboolean _tmp218_ = FALSE;
	gboolean _tmp219_ = FALSE;
	gboolean _tmp223_ = FALSE;
	ValaCodeContext* _tmp224_ = NULL;
	ValaReport* _tmp225_ = NULL;
	ValaReport* _tmp226_ = NULL;
	gint _tmp227_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp235_ = NULL;
	ValaParser* _tmp236_ = NULL;
	ValaCodeContext* _tmp237_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp238_ = NULL;
	ValaGenieParser* _tmp239_ = NULL;
	ValaCodeContext* _tmp240_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp241_ = NULL;
	ValaGirParser* _tmp242_ = NULL;
	ValaCodeContext* _tmp243_ = NULL;
	gboolean _tmp244_ = FALSE;
	ValaCodeContext* _tmp245_ = NULL;
	ValaReport* _tmp246_ = NULL;
	ValaReport* _tmp247_ = NULL;
	gint _tmp248_ = 0;
	const gchar* _tmp256_ = NULL;
	ValaCodeContext* _tmp262_ = NULL;
	gboolean _tmp263_ = FALSE;
	ValaCodeContext* _tmp264_ = NULL;
	ValaReport* _tmp265_ = NULL;
	ValaReport* _tmp266_ = NULL;
	gint _tmp267_ = 0;
	gboolean _tmp275_ = FALSE;
	gboolean _tmp276_ = FALSE;
	gboolean _tmp277_ = FALSE;
	const gchar* _tmp285_ = NULL;
	gboolean _tmp290_ = FALSE;
	ValaCodeContext* _tmp291_ = NULL;
	ValaReport* _tmp292_ = NULL;
	ValaReport* _tmp293_ = NULL;
	gint _tmp294_ = 0;
	ValaCodeContext* _tmp302_ = NULL;
	ValaCodeGenerator* _tmp303_ = NULL;
	ValaCodeGenerator* _tmp304_ = NULL;
	ValaCodeContext* _tmp305_ = NULL;
	gboolean _tmp306_ = FALSE;
	ValaCodeContext* _tmp307_ = NULL;
	ValaReport* _tmp308_ = NULL;
	ValaReport* _tmp309_ = NULL;
	gint _tmp310_ = 0;
	gboolean _tmp318_ = FALSE;
	const gchar* _tmp319_ = NULL;
	const gchar* _tmp323_ = NULL;
	const gchar* _tmp375_ = NULL;
	const gchar* _tmp389_ = NULL;
	const gchar* _tmp412_ = NULL;
	ValaCodeContext* _tmp415_ = NULL;
	ValaUsedAttr* _tmp416_ = NULL;
	ValaUsedAttr* _tmp417_ = NULL;
	ValaCodeContext* _tmp418_ = NULL;
	gboolean _tmp419_ = FALSE;
	ValaCodeContext* _tmp420_ = NULL;
	ValaReport* _tmp421_ = NULL;
	ValaReport* _tmp422_ = NULL;
	gint _tmp423_ = 0;
	gboolean _tmp431_ = FALSE;
	gint _tmp455_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		gchar** env_args = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint env_args_length1 = 0;
		gint _env_args_size_ = 0;
		const gchar* env_colors = NULL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp4_ = _tmp3_ = g_get_environ ();
		env_args = _tmp4_;
		env_args_length1 = _vala_array_length (_tmp3_);
		_env_args_size_ = env_args_length1;
		_tmp5_ = env_args;
		_tmp5__length1 = env_args_length1;
		_tmp6_ = g_environ_getenv (_tmp5_, "VALA_COLORS");
		env_colors = _tmp6_;
		_tmp7_ = env_colors;
		if (_tmp7_ != NULL) {
			ValaCodeContext* _tmp8_ = NULL;
			ValaReport* _tmp9_ = NULL;
			ValaReport* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_report (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = env_colors;
			vala_report_set_colors (_tmp10_, _tmp11_);
		} else {
			ValaCodeContext* _tmp12_ = NULL;
			ValaReport* _tmp13_ = NULL;
			ValaReport* _tmp14_ = NULL;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			vala_report_set_colors (_tmp14_, VALA_COMPILER_DEFAULT_COLORS);
		}
		env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp17_ = vala_compiler_ccode_only;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		_tmp18_ = vala_compiler_compile_only;
		_tmp16_ = !_tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = vala_compiler_output;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp20_ = vala_compiler_sources;
		_tmp20__length1 = _vala_array_length (vala_compiler_sources);
		_tmp21_ = _tmp20_[0];
		_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
		if (_tmp22_ != (-1)) {
			gint dot = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = string_last_index_of_char (_tmp24_, (gunichar) '.', 0);
			dot = _tmp25_;
			_tmp26_ = vala_compiler_sources;
			_tmp26__length1 = _vala_array_length (vala_compiler_sources);
			_tmp27_ = _tmp26_[0];
			_tmp28_ = dot;
			_tmp29_ = string_substring (_tmp27_, (glong) 0, (glong) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_path_get_basename (_tmp30_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp31_;
			_g_free0 (_tmp30_);
		}
	}
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp32_, !_tmp33_);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->context;
	_tmp43_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_code_context_get_report (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp48_, !_tmp49_);
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_code_context_get_report (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp52_, !_tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp56_, !_tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp58_, _tmp59_);
	_tmp61_ = vala_compiler_ccode_only;
	if (_tmp61_) {
		gchar** _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		_tmp62_ = vala_compiler_cc_options;
		_tmp62__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp60_ = _tmp62_ != NULL;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp65_, _tmp66_);
	_tmp68_ = vala_compiler_header_filename;
	if (_tmp68_ == NULL) {
		gboolean _tmp69_ = FALSE;
		_tmp69_ = vala_compiler_use_header;
		_tmp67_ = _tmp69_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp70_ = self->priv->context;
	_tmp71_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->context;
	_tmp77_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_compiler_output;
	vala_code_context_set_output (_tmp78_, _tmp79_);
	_tmp81_ = vala_compiler_output;
	if (_tmp81_ != NULL) {
		gboolean _tmp82_ = FALSE;
		_tmp82_ = vala_compiler_ccode_only;
		_tmp80_ = _tmp82_;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp83_ = vala_compiler_basedir;
	if (_tmp83_ == NULL) {
		ValaCodeContext* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		_tmp84_ = self->priv->context;
		_tmp85_ = vala_code_context_realpath (".");
		_tmp86_ = _tmp85_;
		vala_code_context_set_basedir (_tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
	} else {
		ValaCodeContext* _tmp87_ = NULL;
		const gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		_tmp87_ = self->priv->context;
		_tmp88_ = vala_compiler_basedir;
		_tmp89_ = vala_code_context_realpath (_tmp88_);
		_tmp90_ = _tmp89_;
		vala_code_context_set_basedir (_tmp87_, _tmp90_);
		_g_free0 (_tmp90_);
	}
	_tmp91_ = vala_compiler_directory;
	if (_tmp91_ != NULL) {
		ValaCodeContext* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		_tmp92_ = self->priv->context;
		_tmp93_ = vala_compiler_directory;
		_tmp94_ = vala_code_context_realpath (_tmp93_);
		_tmp95_ = _tmp94_;
		vala_code_context_set_directory (_tmp92_, _tmp95_);
		_g_free0 (_tmp95_);
	} else {
		ValaCodeContext* _tmp96_ = NULL;
		ValaCodeContext* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		const gchar* _tmp99_ = NULL;
		_tmp96_ = self->priv->context;
		_tmp97_ = self->priv->context;
		_tmp98_ = vala_code_context_get_basedir (_tmp97_);
		_tmp99_ = _tmp98_;
		vala_code_context_set_directory (_tmp96_, _tmp99_);
	}
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_compiler_vapi_directories;
	_tmp101__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp102_ = (_tmp101_ != NULL) ? _vala_array_dup1 (_tmp101_, _tmp101__length1) : ((gpointer) _tmp101_);
	_tmp102__length1 = _tmp101__length1;
	_tmp100_->vapi_directories = (_vala_array_free (_tmp100_->vapi_directories, _tmp100_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp100_->vapi_directories = _tmp102_;
	_tmp100_->vapi_directories_length1 = _tmp102__length1;
	_tmp103_ = self->priv->context;
	_tmp104_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp103_, _tmp104_);
	_tmp105_ = self->priv->context;
	_tmp106_ = vala_compiler_gir_directories;
	_tmp106__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp107_ = (_tmp106_ != NULL) ? _vala_array_dup2 (_tmp106_, _tmp106__length1) : ((gpointer) _tmp106_);
	_tmp107__length1 = _tmp106__length1;
	_tmp105_->gir_directories = (_vala_array_free (_tmp105_->gir_directories, _tmp105_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp105_->gir_directories = _tmp107_;
	_tmp105_->gir_directories_length1 = _tmp107__length1;
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_metadata_directories;
	_tmp109__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp110_ = (_tmp109_ != NULL) ? _vala_array_dup3 (_tmp109_, _tmp109__length1) : ((gpointer) _tmp109_);
	_tmp110__length1 = _tmp109__length1;
	_tmp108_->metadata_directories = (_vala_array_free (_tmp108_->metadata_directories, _tmp108_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp108_->metadata_directories = _tmp110_;
	_tmp108_->metadata_directories_length1 = _tmp110__length1;
	_tmp111_ = self->priv->context;
	_tmp112_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp111_, _tmp112_);
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp113_, _tmp114_);
	_tmp115_ = self->priv->context;
	_tmp116_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp115_, _tmp116_);
	_tmp117_ = self->priv->context;
	_tmp118_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp117_, _tmp118_);
	_tmp120_ = vala_compiler_ccode_only;
	if (_tmp120_) {
		gboolean _tmp121_ = FALSE;
		_tmp121_ = vala_compiler_save_temps;
		_tmp119_ = _tmp121_;
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp124_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp124_, "gobject-2.0") == 0) {
		_tmp123_ = TRUE;
	} else {
		const gchar* _tmp125_ = NULL;
		_tmp125_ = vala_compiler_profile;
		_tmp123_ = g_strcmp0 (_tmp125_, "gobject") == 0;
	}
	if (_tmp123_) {
		_tmp122_ = TRUE;
	} else {
		const gchar* _tmp126_ = NULL;
		_tmp126_ = vala_compiler_profile;
		_tmp122_ = _tmp126_ == NULL;
	}
	if (_tmp122_) {
		ValaCodeContext* _tmp127_ = NULL;
		ValaCodeContext* _tmp128_ = NULL;
		_tmp127_ = self->priv->context;
		vala_code_context_set_profile (_tmp127_, VALA_PROFILE_GOBJECT);
		_tmp128_ = self->priv->context;
		vala_code_context_add_define (_tmp128_, "GOBJECT");
	} else {
		const gchar* _tmp129_ = NULL;
		gchar* _tmp130_ = NULL;
		gchar* _tmp131_ = NULL;
		_tmp129_ = vala_compiler_profile;
		_tmp130_ = g_strdup_printf ("Unknown profile %s", _tmp129_);
		_tmp131_ = _tmp130_;
		vala_report_error (NULL, _tmp131_);
		_g_free0 (_tmp131_);
	}
	_tmp132_ = vala_compiler_nostdpkg;
	_tmp133_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp132_ | (_tmp133_ != NULL);
	_tmp134_ = self->priv->context;
	_tmp135_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp134_, _tmp135_);
	_tmp136_ = self->priv->context;
	_tmp137_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp136_, _tmp137_);
	_tmp138_ = self->priv->context;
	_tmp139_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp138_, _tmp139_);
	_tmp140_ = vala_compiler_defines;
	_tmp140__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp140_ != NULL) {
		gchar** _tmp141_ = NULL;
		gint _tmp141__length1 = 0;
		_tmp141_ = vala_compiler_defines;
		_tmp141__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp141_;
			define_collection_length1 = _tmp141__length1;
			for (define_it = 0; define_it < _tmp141__length1; define_it = define_it + 1) {
				gchar* _tmp142_ = NULL;
				gchar* define = NULL;
				_tmp142_ = g_strdup (define_collection[define_it]);
				define = _tmp142_;
				{
					ValaCodeContext* _tmp143_ = NULL;
					const gchar* _tmp144_ = NULL;
					_tmp143_ = self->priv->context;
					_tmp144_ = define;
					vala_code_context_add_define (_tmp143_, _tmp144_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp145_ = FALSE;
			_tmp145_ = TRUE;
			while (TRUE) {
				gint _tmp147_ = 0;
				ValaCodeContext* _tmp148_ = NULL;
				gint _tmp149_ = 0;
				gchar* _tmp150_ = NULL;
				gchar* _tmp151_ = NULL;
				if (!_tmp145_) {
					gint _tmp146_ = 0;
					_tmp146_ = i;
					i = _tmp146_ + 2;
				}
				_tmp145_ = FALSE;
				_tmp147_ = i;
				if (!(_tmp147_ <= 28)) {
					break;
				}
				_tmp148_ = self->priv->context;
				_tmp149_ = i;
				_tmp150_ = g_strdup_printf ("VALA_0_%d", _tmp149_);
				_tmp151_ = _tmp150_;
				vala_code_context_add_define (_tmp148_, _tmp151_);
				_g_free0 (_tmp151_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 24;
	_tmp153_ = vala_compiler_target_glib;
	if (_tmp153_ != NULL) {
		const gchar* _tmp154_ = NULL;
		gint _tmp155_ = 0;
		_tmp154_ = vala_compiler_target_glib;
		_tmp155_ = sscanf (_tmp154_, "%d.%d", &glib_major, &glib_minor);
		_tmp152_ = _tmp155_ != 2;
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp156_ = self->priv->context;
	_tmp157_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp156_, _tmp157_);
	_tmp158_ = self->priv->context;
	_tmp159_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp158_, _tmp159_);
	_tmp160_ = self->priv->context;
	_tmp161_ = vala_code_context_get_target_glib_major (_tmp160_);
	_tmp162_ = _tmp161_;
	if (_tmp162_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp163_ = FALSE;
			_tmp163_ = TRUE;
			while (TRUE) {
				gint _tmp165_ = 0;
				gint _tmp166_ = 0;
				ValaCodeContext* _tmp167_ = NULL;
				gint _tmp168_ = 0;
				gchar* _tmp169_ = NULL;
				gchar* _tmp170_ = NULL;
				if (!_tmp163_) {
					gint _tmp164_ = 0;
					_tmp164_ = i;
					i = _tmp164_ + 2;
				}
				_tmp163_ = FALSE;
				_tmp165_ = i;
				_tmp166_ = glib_minor;
				if (!(_tmp165_ <= _tmp166_)) {
					break;
				}
				_tmp167_ = self->priv->context;
				_tmp168_ = i;
				_tmp169_ = g_strdup_printf ("GLIB_2_%d", _tmp168_);
				_tmp170_ = _tmp169_;
				vala_code_context_add_define (_tmp167_, _tmp170_);
				_g_free0 (_tmp170_);
			}
		}
	}
	_tmp171_ = vala_compiler_nostdpkg;
	if (!_tmp171_) {
		ValaCodeContext* _tmp172_ = NULL;
		ValaCodeContext* _tmp173_ = NULL;
		_tmp172_ = self->priv->context;
		vala_code_context_add_external_package (_tmp172_, "glib-2.0");
		_tmp173_ = self->priv->context;
		vala_code_context_add_external_package (_tmp173_, "gobject-2.0");
	}
	_tmp174_ = vala_compiler_packages;
	_tmp174__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp174_ != NULL) {
		gchar** _tmp175_ = NULL;
		gint _tmp175__length1 = 0;
		_tmp175_ = vala_compiler_packages;
		_tmp175__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp175_;
			package_collection_length1 = _tmp175__length1;
			for (package_it = 0; package_it < _tmp175__length1; package_it = package_it + 1) {
				gchar* _tmp176_ = NULL;
				gchar* package = NULL;
				_tmp176_ = g_strdup (package_collection[package_it]);
				package = _tmp176_;
				{
					ValaCodeContext* _tmp177_ = NULL;
					const gchar* _tmp178_ = NULL;
					_tmp177_ = self->priv->context;
					_tmp178_ = package;
					vala_code_context_add_external_package (_tmp177_, _tmp178_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp179_ = vala_compiler_fast_vapis;
	_tmp179__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp179_ != NULL) {
		gchar** _tmp180_ = NULL;
		gint _tmp180__length1 = 0;
		ValaCodeContext* _tmp189_ = NULL;
		_tmp180_ = vala_compiler_fast_vapis;
		_tmp180__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp180_;
			vapi_collection_length1 = _tmp180__length1;
			for (vapi_it = 0; vapi_it < _tmp180__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp181_ = NULL;
				gchar* vapi = NULL;
				_tmp181_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp181_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp182_ = NULL;
					gchar* _tmp183_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp184_ = NULL;
					const gchar* _tmp185_ = NULL;
					ValaSourceFile* _tmp186_ = NULL;
					ValaCodeContext* _tmp187_ = NULL;
					ValaSourceFile* _tmp188_ = NULL;
					_tmp182_ = vapi;
					_tmp183_ = vala_code_context_realpath (_tmp182_);
					rpath = _tmp183_;
					_tmp184_ = self->priv->context;
					_tmp185_ = rpath;
					_tmp186_ = vala_source_file_new (_tmp184_, VALA_SOURCE_FILE_TYPE_FAST, _tmp185_, NULL, FALSE);
					source_file = _tmp186_;
					_tmp187_ = self->priv->context;
					_tmp188_ = source_file;
					vala_code_context_add_source_file (_tmp187_, _tmp188_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp189_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp189_, TRUE);
	}
	_tmp190_ = self->priv->context;
	_tmp191_ = vala_compiler_gresources;
	_tmp191__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp192_ = (_tmp191_ != NULL) ? _vala_array_dup4 (_tmp191_, _tmp191__length1) : ((gpointer) _tmp191_);
	_tmp192__length1 = _tmp191__length1;
	_tmp190_->gresources = (_vala_array_free (_tmp190_->gresources, _tmp190_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp190_->gresources = _tmp192_;
	_tmp190_->gresources_length1 = _tmp192__length1;
	_tmp194_ = self->priv->context;
	_tmp195_ = vala_code_context_get_report (_tmp194_);
	_tmp196_ = _tmp195_;
	_tmp197_ = vala_report_get_errors (_tmp196_);
	if (_tmp197_ > 0) {
		_tmp193_ = TRUE;
	} else {
		gboolean _tmp198_ = FALSE;
		gboolean _tmp199_ = FALSE;
		_tmp199_ = vala_compiler_fatal_warnings;
		if (_tmp199_) {
			ValaCodeContext* _tmp200_ = NULL;
			ValaReport* _tmp201_ = NULL;
			ValaReport* _tmp202_ = NULL;
			gint _tmp203_ = 0;
			_tmp200_ = self->priv->context;
			_tmp201_ = vala_code_context_get_report (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_report_get_warnings (_tmp202_);
			_tmp198_ = _tmp203_ > 0;
		} else {
			_tmp198_ = FALSE;
		}
		_tmp193_ = _tmp198_;
	}
	if (_tmp193_) {
		gint _tmp204_ = 0;
		_tmp204_ = vala_compiler_quit (self);
		result = _tmp204_;
		return result;
	}
	_tmp205_ = self->priv->context;
	_tmp206_ = vala_gd_bus_server_module_new ();
	_tmp207_ = _tmp206_;
	vala_code_context_set_codegen (_tmp205_, (ValaCodeGenerator*) _tmp207_);
	_vala_code_visitor_unref0 (_tmp207_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp208_ = vala_compiler_sources;
	_tmp208__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp208_;
		source_collection_length1 = _tmp208__length1;
		for (source_it = 0; source_it < _tmp208__length1; source_it = source_it + 1) {
			gchar* _tmp209_ = NULL;
			gchar* source = NULL;
			_tmp209_ = g_strdup (source_collection[source_it]);
			source = _tmp209_;
			{
				ValaCodeContext* _tmp210_ = NULL;
				const gchar* _tmp211_ = NULL;
				gboolean _tmp212_ = FALSE;
				gboolean _tmp213_ = FALSE;
				_tmp210_ = self->priv->context;
				_tmp211_ = source;
				_tmp212_ = vala_compiler_run_output;
				_tmp213_ = vala_code_context_add_source_filename (_tmp210_, _tmp211_, _tmp212_, TRUE);
				if (_tmp213_) {
					const gchar* _tmp214_ = NULL;
					gboolean _tmp215_ = FALSE;
					_tmp214_ = source;
					_tmp215_ = g_str_has_suffix (_tmp214_, ".c");
					if (_tmp215_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp216_ = NULL;
						gboolean _tmp217_ = FALSE;
						_tmp216_ = source;
						_tmp217_ = g_str_has_suffix (_tmp216_, ".h");
						if (_tmp217_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp219_ = vala_compiler_ccode_only;
	if (_tmp219_) {
		gboolean _tmp220_ = FALSE;
		gboolean _tmp221_ = FALSE;
		_tmp221_ = has_c_files;
		if (_tmp221_) {
			_tmp220_ = TRUE;
		} else {
			gboolean _tmp222_ = FALSE;
			_tmp222_ = has_h_files;
			_tmp220_ = _tmp222_;
		}
		_tmp218_ = _tmp220_;
	} else {
		_tmp218_ = FALSE;
	}
	if (_tmp218_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp224_ = self->priv->context;
	_tmp225_ = vala_code_context_get_report (_tmp224_);
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_report_get_errors (_tmp226_);
	if (_tmp227_ > 0) {
		_tmp223_ = TRUE;
	} else {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_ = FALSE;
		_tmp229_ = vala_compiler_fatal_warnings;
		if (_tmp229_) {
			ValaCodeContext* _tmp230_ = NULL;
			ValaReport* _tmp231_ = NULL;
			ValaReport* _tmp232_ = NULL;
			gint _tmp233_ = 0;
			_tmp230_ = self->priv->context;
			_tmp231_ = vala_code_context_get_report (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_report_get_warnings (_tmp232_);
			_tmp228_ = _tmp233_ > 0;
		} else {
			_tmp228_ = FALSE;
		}
		_tmp223_ = _tmp228_;
	}
	if (_tmp223_) {
		gint _tmp234_ = 0;
		_tmp234_ = vala_compiler_quit (self);
		result = _tmp234_;
		return result;
	}
	_tmp235_ = vala_parser_new ();
	parser = _tmp235_;
	_tmp236_ = parser;
	_tmp237_ = self->priv->context;
	vala_parser_parse (_tmp236_, _tmp237_);
	_tmp238_ = vala_genie_parser_new ();
	genie_parser = _tmp238_;
	_tmp239_ = genie_parser;
	_tmp240_ = self->priv->context;
	vala_genie_parser_parse (_tmp239_, _tmp240_);
	_tmp241_ = vala_gir_parser_new ();
	gir_parser = _tmp241_;
	_tmp242_ = gir_parser;
	_tmp243_ = self->priv->context;
	vala_gir_parser_parse (_tmp242_, _tmp243_);
	_tmp245_ = self->priv->context;
	_tmp246_ = vala_code_context_get_report (_tmp245_);
	_tmp247_ = _tmp246_;
	_tmp248_ = vala_report_get_errors (_tmp247_);
	if (_tmp248_ > 0) {
		_tmp244_ = TRUE;
	} else {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_ = FALSE;
		_tmp250_ = vala_compiler_fatal_warnings;
		if (_tmp250_) {
			ValaCodeContext* _tmp251_ = NULL;
			ValaReport* _tmp252_ = NULL;
			ValaReport* _tmp253_ = NULL;
			gint _tmp254_ = 0;
			_tmp251_ = self->priv->context;
			_tmp252_ = vala_code_context_get_report (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_report_get_warnings (_tmp253_);
			_tmp249_ = _tmp254_ > 0;
		} else {
			_tmp249_ = FALSE;
		}
		_tmp244_ = _tmp249_;
	}
	if (_tmp244_) {
		gint _tmp255_ = 0;
		_tmp255_ = vala_compiler_quit (self);
		result = _tmp255_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp256_ = vala_compiler_fast_vapi_filename;
	if (_tmp256_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp257_ = NULL;
		ValaCodeWriter* _tmp258_ = NULL;
		ValaCodeContext* _tmp259_ = NULL;
		const gchar* _tmp260_ = NULL;
		gint _tmp261_ = 0;
		_tmp257_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp257_;
		_tmp258_ = interface_writer;
		_tmp259_ = self->priv->context;
		_tmp260_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp258_, _tmp259_, _tmp260_);
		_tmp261_ = vala_compiler_quit (self);
		result = _tmp261_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp262_ = self->priv->context;
	vala_code_context_check (_tmp262_);
	_tmp264_ = self->priv->context;
	_tmp265_ = vala_code_context_get_report (_tmp264_);
	_tmp266_ = _tmp265_;
	_tmp267_ = vala_report_get_errors (_tmp266_);
	if (_tmp267_ > 0) {
		_tmp263_ = TRUE;
	} else {
		gboolean _tmp268_ = FALSE;
		gboolean _tmp269_ = FALSE;
		_tmp269_ = vala_compiler_fatal_warnings;
		if (_tmp269_) {
			ValaCodeContext* _tmp270_ = NULL;
			ValaReport* _tmp271_ = NULL;
			ValaReport* _tmp272_ = NULL;
			gint _tmp273_ = 0;
			_tmp270_ = self->priv->context;
			_tmp271_ = vala_code_context_get_report (_tmp270_);
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_report_get_warnings (_tmp272_);
			_tmp268_ = _tmp273_ > 0;
		} else {
			_tmp268_ = FALSE;
		}
		_tmp263_ = _tmp268_;
	}
	if (_tmp263_) {
		gint _tmp274_ = 0;
		_tmp274_ = vala_compiler_quit (self);
		result = _tmp274_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp277_ = vala_compiler_ccode_only;
	if (!_tmp277_) {
		gboolean _tmp278_ = FALSE;
		_tmp278_ = vala_compiler_compile_only;
		_tmp276_ = !_tmp278_;
	} else {
		_tmp276_ = FALSE;
	}
	if (_tmp276_) {
		const gchar* _tmp279_ = NULL;
		_tmp279_ = vala_compiler_library;
		_tmp275_ = _tmp279_ == NULL;
	} else {
		_tmp275_ = FALSE;
	}
	if (_tmp275_) {
		gboolean _tmp280_ = FALSE;
		gboolean _tmp281_ = FALSE;
		_tmp281_ = has_c_files;
		if (!_tmp281_) {
			ValaCodeContext* _tmp282_ = NULL;
			ValaMethod* _tmp283_ = NULL;
			ValaMethod* _tmp284_ = NULL;
			_tmp282_ = self->priv->context;
			_tmp283_ = vala_code_context_get_entry_point (_tmp282_);
			_tmp284_ = _tmp283_;
			_tmp280_ = _tmp284_ == NULL;
		} else {
			_tmp280_ = FALSE;
		}
		if (_tmp280_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp285_ = vala_compiler_dump_tree;
	if (_tmp285_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp286_ = NULL;
		ValaCodeWriter* _tmp287_ = NULL;
		ValaCodeContext* _tmp288_ = NULL;
		const gchar* _tmp289_ = NULL;
		_tmp286_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp286_;
		_tmp287_ = code_writer;
		_tmp288_ = self->priv->context;
		_tmp289_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp287_, _tmp288_, _tmp289_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp291_ = self->priv->context;
	_tmp292_ = vala_code_context_get_report (_tmp291_);
	_tmp293_ = _tmp292_;
	_tmp294_ = vala_report_get_errors (_tmp293_);
	if (_tmp294_ > 0) {
		_tmp290_ = TRUE;
	} else {
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_ = FALSE;
		_tmp296_ = vala_compiler_fatal_warnings;
		if (_tmp296_) {
			ValaCodeContext* _tmp297_ = NULL;
			ValaReport* _tmp298_ = NULL;
			ValaReport* _tmp299_ = NULL;
			gint _tmp300_ = 0;
			_tmp297_ = self->priv->context;
			_tmp298_ = vala_code_context_get_report (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_report_get_warnings (_tmp299_);
			_tmp295_ = _tmp300_ > 0;
		} else {
			_tmp295_ = FALSE;
		}
		_tmp290_ = _tmp295_;
	}
	if (_tmp290_) {
		gint _tmp301_ = 0;
		_tmp301_ = vala_compiler_quit (self);
		result = _tmp301_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp302_ = self->priv->context;
	_tmp303_ = vala_code_context_get_codegen (_tmp302_);
	_tmp304_ = _tmp303_;
	_tmp305_ = self->priv->context;
	vala_code_generator_emit (_tmp304_, _tmp305_);
	_tmp307_ = self->priv->context;
	_tmp308_ = vala_code_context_get_report (_tmp307_);
	_tmp309_ = _tmp308_;
	_tmp310_ = vala_report_get_errors (_tmp309_);
	if (_tmp310_ > 0) {
		_tmp306_ = TRUE;
	} else {
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_ = FALSE;
		_tmp312_ = vala_compiler_fatal_warnings;
		if (_tmp312_) {
			ValaCodeContext* _tmp313_ = NULL;
			ValaReport* _tmp314_ = NULL;
			ValaReport* _tmp315_ = NULL;
			gint _tmp316_ = 0;
			_tmp313_ = self->priv->context;
			_tmp314_ = vala_code_context_get_report (_tmp313_);
			_tmp315_ = _tmp314_;
			_tmp316_ = vala_report_get_warnings (_tmp315_);
			_tmp311_ = _tmp316_ > 0;
		} else {
			_tmp311_ = FALSE;
		}
		_tmp306_ = _tmp311_;
	}
	if (_tmp306_) {
		gint _tmp317_ = 0;
		_tmp317_ = vala_compiler_quit (self);
		result = _tmp317_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp319_ = vala_compiler_vapi_filename;
	if (_tmp319_ == NULL) {
		const gchar* _tmp320_ = NULL;
		_tmp320_ = vala_compiler_library;
		_tmp318_ = _tmp320_ != NULL;
	} else {
		_tmp318_ = FALSE;
	}
	if (_tmp318_) {
		const gchar* _tmp321_ = NULL;
		gchar* _tmp322_ = NULL;
		_tmp321_ = vala_compiler_library;
		_tmp322_ = g_strdup_printf ("%s.vapi", _tmp321_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp322_;
	}
	_tmp323_ = vala_compiler_library;
	if (_tmp323_ != NULL) {
		const gchar* _tmp324_ = NULL;
		_tmp324_ = vala_compiler_gir;
		if (_tmp324_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp325_ = NULL;
			gchar* _tmp326_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp327_ = NULL;
			gint _tmp328_ = 0;
			gint _tmp329_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp330_ = NULL;
			gint _tmp331_ = 0;
			gboolean _tmp332_ = FALSE;
			gint _tmp333_ = 0;
			_tmp325_ = vala_compiler_gir;
			_tmp326_ = g_path_get_basename (_tmp325_);
			gir_base = _tmp326_;
			_tmp327_ = gir_base;
			_tmp328_ = strlen (_tmp327_);
			_tmp329_ = _tmp328_;
			gir_len = (glong) _tmp329_;
			_tmp330_ = gir_base;
			_tmp331_ = string_last_index_of_char (_tmp330_, (gunichar) '-', 0);
			last_hyphen = _tmp331_;
			_tmp333_ = last_hyphen;
			if (_tmp333_ == (-1)) {
				_tmp332_ = TRUE;
			} else {
				const gchar* _tmp334_ = NULL;
				gboolean _tmp335_ = FALSE;
				_tmp334_ = gir_base;
				_tmp335_ = g_str_has_suffix (_tmp334_, ".gir");
				_tmp332_ = !_tmp335_;
			}
			if (_tmp332_) {
				const gchar* _tmp336_ = NULL;
				gchar* _tmp337_ = NULL;
				gchar* _tmp338_ = NULL;
				_tmp336_ = vala_compiler_gir;
				_tmp337_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp336_);
				_tmp338_ = _tmp337_;
				vala_report_error (NULL, _tmp338_);
				_g_free0 (_tmp338_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp339_ = NULL;
				gint _tmp340_ = 0;
				gchar* _tmp341_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp342_ = NULL;
				gint _tmp343_ = 0;
				glong _tmp344_ = 0L;
				gint _tmp345_ = 0;
				gchar* _tmp346_ = NULL;
				const gchar* _tmp347_ = NULL;
				gboolean _tmp348_ = FALSE;
				gboolean _tmp349_ = FALSE;
				gboolean _tmp350_ = FALSE;
				const gchar* _tmp351_ = NULL;
				_tmp339_ = gir_base;
				_tmp340_ = last_hyphen;
				_tmp341_ = string_substring (_tmp339_, (glong) 0, (glong) _tmp340_);
				gir_namespace = _tmp341_;
				_tmp342_ = gir_base;
				_tmp343_ = last_hyphen;
				_tmp344_ = gir_len;
				_tmp345_ = last_hyphen;
				_tmp346_ = string_substring (_tmp342_, (glong) (_tmp343_ + 1), (_tmp344_ - _tmp345_) - 5);
				gir_version = _tmp346_;
				_tmp347_ = gir_version;
				g_strcanon (_tmp347_, "0123456789.", '?');
				_tmp351_ = gir_namespace;
				if (g_strcmp0 (_tmp351_, "") == 0) {
					_tmp350_ = TRUE;
				} else {
					const gchar* _tmp352_ = NULL;
					_tmp352_ = gir_version;
					_tmp350_ = g_strcmp0 (_tmp352_, "") == 0;
				}
				if (_tmp350_) {
					_tmp349_ = TRUE;
				} else {
					const gchar* _tmp353_ = NULL;
					gchar _tmp354_ = '\0';
					gboolean _tmp355_ = FALSE;
					_tmp353_ = gir_version;
					_tmp354_ = string_get (_tmp353_, (glong) 0);
					_tmp355_ = g_ascii_isdigit (_tmp354_);
					_tmp349_ = !_tmp355_;
				}
				if (_tmp349_) {
					_tmp348_ = TRUE;
				} else {
					const gchar* _tmp356_ = NULL;
					gboolean _tmp357_ = FALSE;
					_tmp356_ = gir_version;
					_tmp357_ = string_contains (_tmp356_, "?");
					_tmp348_ = _tmp357_;
				}
				if (_tmp348_) {
					const gchar* _tmp358_ = NULL;
					gchar* _tmp359_ = NULL;
					gchar* _tmp360_ = NULL;
					_tmp358_ = vala_compiler_gir;
					_tmp359_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp358_);
					_tmp360_ = _tmp359_;
					vala_report_error (NULL, _tmp360_);
					_g_free0 (_tmp360_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp361_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp362_ = NULL;
					const gchar* _tmp363_ = NULL;
					ValaGIRWriter* _tmp368_ = NULL;
					ValaCodeContext* _tmp369_ = NULL;
					const gchar* _tmp370_ = NULL;
					const gchar* _tmp371_ = NULL;
					const gchar* _tmp372_ = NULL;
					const gchar* _tmp373_ = NULL;
					const gchar* _tmp374_ = NULL;
					_tmp361_ = vala_gir_writer_new ();
					gir_writer = _tmp361_;
					_tmp362_ = g_strdup (".");
					gir_directory = _tmp362_;
					_tmp363_ = vala_compiler_directory;
					if (_tmp363_ != NULL) {
						ValaCodeContext* _tmp364_ = NULL;
						const gchar* _tmp365_ = NULL;
						const gchar* _tmp366_ = NULL;
						gchar* _tmp367_ = NULL;
						_tmp364_ = self->priv->context;
						_tmp365_ = vala_code_context_get_directory (_tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = g_strdup (_tmp366_);
						_g_free0 (gir_directory);
						gir_directory = _tmp367_;
					}
					_tmp368_ = gir_writer;
					_tmp369_ = self->priv->context;
					_tmp370_ = gir_directory;
					_tmp371_ = vala_compiler_gir;
					_tmp372_ = gir_namespace;
					_tmp373_ = gir_version;
					_tmp374_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp368_, _tmp369_, _tmp370_, _tmp371_, _tmp372_, _tmp373_, _tmp374_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp375_ = vala_compiler_vapi_filename;
	if (_tmp375_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp376_ = NULL;
		gboolean _tmp377_ = FALSE;
		const gchar* _tmp378_ = NULL;
		ValaCodeWriter* _tmp386_ = NULL;
		ValaCodeContext* _tmp387_ = NULL;
		const gchar* _tmp388_ = NULL;
		_tmp376_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp376_;
		_tmp378_ = vala_compiler_directory;
		if (_tmp378_ != NULL) {
			const gchar* _tmp379_ = NULL;
			gboolean _tmp380_ = FALSE;
			_tmp379_ = vala_compiler_vapi_filename;
			_tmp380_ = g_path_is_absolute (_tmp379_);
			_tmp377_ = !_tmp380_;
		} else {
			_tmp377_ = FALSE;
		}
		if (_tmp377_) {
			ValaCodeContext* _tmp381_ = NULL;
			const gchar* _tmp382_ = NULL;
			const gchar* _tmp383_ = NULL;
			const gchar* _tmp384_ = NULL;
			gchar* _tmp385_ = NULL;
			_tmp381_ = self->priv->context;
			_tmp382_ = vala_code_context_get_directory (_tmp381_);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_compiler_vapi_filename;
			_tmp385_ = g_strdup_printf ("%s%c%s", _tmp383_, (gint) G_DIR_SEPARATOR, _tmp384_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp385_;
		}
		_tmp386_ = interface_writer;
		_tmp387_ = self->priv->context;
		_tmp388_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp386_, _tmp387_, _tmp388_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp389_ = vala_compiler_internal_vapi_filename;
	if (_tmp389_ != NULL) {
		gboolean _tmp390_ = FALSE;
		const gchar* _tmp391_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp394_ = NULL;
		ValaCodeWriter* _tmp395_ = NULL;
		const gchar* _tmp396_ = NULL;
		const gchar* _tmp397_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp398_ = NULL;
		gchar* _tmp399_ = NULL;
		gboolean _tmp400_ = FALSE;
		const gchar* _tmp401_ = NULL;
		ValaCodeWriter* _tmp409_ = NULL;
		ValaCodeContext* _tmp410_ = NULL;
		const gchar* _tmp411_ = NULL;
		_tmp391_ = vala_compiler_internal_header_filename;
		if (_tmp391_ == NULL) {
			_tmp390_ = TRUE;
		} else {
			const gchar* _tmp392_ = NULL;
			_tmp392_ = vala_compiler_header_filename;
			_tmp390_ = _tmp392_ == NULL;
		}
		if (_tmp390_) {
			gint _tmp393_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp393_ = vala_compiler_quit (self);
			result = _tmp393_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp394_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp394_;
		_tmp395_ = interface_writer;
		_tmp396_ = vala_compiler_header_filename;
		_tmp397_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp395_, _tmp396_, _tmp397_);
		_tmp398_ = vala_compiler_internal_vapi_filename;
		_tmp399_ = g_strdup (_tmp398_);
		vapi_filename = _tmp399_;
		_tmp401_ = vala_compiler_directory;
		if (_tmp401_ != NULL) {
			const gchar* _tmp402_ = NULL;
			gboolean _tmp403_ = FALSE;
			_tmp402_ = vapi_filename;
			_tmp403_ = g_path_is_absolute (_tmp402_);
			_tmp400_ = !_tmp403_;
		} else {
			_tmp400_ = FALSE;
		}
		if (_tmp400_) {
			ValaCodeContext* _tmp404_ = NULL;
			const gchar* _tmp405_ = NULL;
			const gchar* _tmp406_ = NULL;
			const gchar* _tmp407_ = NULL;
			gchar* _tmp408_ = NULL;
			_tmp404_ = self->priv->context;
			_tmp405_ = vala_code_context_get_directory (_tmp404_);
			_tmp406_ = _tmp405_;
			_tmp407_ = vapi_filename;
			_tmp408_ = g_strdup_printf ("%s%c%s", _tmp406_, (gint) G_DIR_SEPARATOR, _tmp407_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp408_;
		}
		_tmp409_ = interface_writer;
		_tmp410_ = self->priv->context;
		_tmp411_ = vapi_filename;
		vala_code_writer_write_file (_tmp409_, _tmp410_, _tmp411_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp412_ = vala_compiler_dependencies;
	if (_tmp412_ != NULL) {
		ValaCodeContext* _tmp413_ = NULL;
		const gchar* _tmp414_ = NULL;
		_tmp413_ = self->priv->context;
		_tmp414_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp413_, _tmp414_);
	}
	_tmp415_ = self->priv->context;
	_tmp416_ = vala_code_context_get_used_attr (_tmp415_);
	_tmp417_ = _tmp416_;
	_tmp418_ = self->priv->context;
	vala_used_attr_check_unused (_tmp417_, _tmp418_);
	_tmp420_ = self->priv->context;
	_tmp421_ = vala_code_context_get_report (_tmp420_);
	_tmp422_ = _tmp421_;
	_tmp423_ = vala_report_get_errors (_tmp422_);
	if (_tmp423_ > 0) {
		_tmp419_ = TRUE;
	} else {
		gboolean _tmp424_ = FALSE;
		gboolean _tmp425_ = FALSE;
		_tmp425_ = vala_compiler_fatal_warnings;
		if (_tmp425_) {
			ValaCodeContext* _tmp426_ = NULL;
			ValaReport* _tmp427_ = NULL;
			ValaReport* _tmp428_ = NULL;
			gint _tmp429_ = 0;
			_tmp426_ = self->priv->context;
			_tmp427_ = vala_code_context_get_report (_tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_report_get_warnings (_tmp428_);
			_tmp424_ = _tmp429_ > 0;
		} else {
			_tmp424_ = FALSE;
		}
		_tmp419_ = _tmp424_;
	}
	if (_tmp419_) {
		gint _tmp430_ = 0;
		_tmp430_ = vala_compiler_quit (self);
		result = _tmp430_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp431_ = vala_compiler_ccode_only;
	if (!_tmp431_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp432_ = NULL;
		gboolean _tmp433_ = FALSE;
		const gchar* _tmp434_ = NULL;
		gboolean _tmp438_ = FALSE;
		const gchar* _tmp439_ = NULL;
		gchar** _tmp443_ = NULL;
		gint _tmp443__length1 = 0;
		_tmp432_ = vala_ccode_compiler_new ();
		ccompiler = _tmp432_;
		_tmp434_ = vala_compiler_cc_command;
		if (_tmp434_ == NULL) {
			const gchar* _tmp435_ = NULL;
			_tmp435_ = g_getenv ("CC");
			_tmp433_ = _tmp435_ != NULL;
		} else {
			_tmp433_ = FALSE;
		}
		if (_tmp433_) {
			const gchar* _tmp436_ = NULL;
			gchar* _tmp437_ = NULL;
			_tmp436_ = g_getenv ("CC");
			_tmp437_ = g_strdup (_tmp436_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp437_;
		}
		_tmp439_ = vala_compiler_pkg_config_command;
		if (_tmp439_ == NULL) {
			const gchar* _tmp440_ = NULL;
			_tmp440_ = g_getenv ("PKG_CONFIG");
			_tmp438_ = _tmp440_ != NULL;
		} else {
			_tmp438_ = FALSE;
		}
		if (_tmp438_) {
			const gchar* _tmp441_ = NULL;
			gchar* _tmp442_ = NULL;
			_tmp441_ = g_getenv ("PKG_CONFIG");
			_tmp442_ = g_strdup (_tmp441_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp442_;
		}
		_tmp443_ = vala_compiler_cc_options;
		_tmp443__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp443_ == NULL) {
			ValaCCodeCompiler* _tmp444_ = NULL;
			ValaCodeContext* _tmp445_ = NULL;
			const gchar* _tmp446_ = NULL;
			gchar** _tmp447_ = NULL;
			gchar** _tmp448_ = NULL;
			gint _tmp448__length1 = 0;
			const gchar* _tmp449_ = NULL;
			_tmp444_ = ccompiler;
			_tmp445_ = self->priv->context;
			_tmp446_ = vala_compiler_cc_command;
			_tmp447_ = g_new0 (gchar*, 0 + 1);
			_tmp448_ = _tmp447_;
			_tmp448__length1 = 0;
			_tmp449_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp444_, _tmp445_, _tmp446_, _tmp448_, 0, _tmp449_);
			_tmp448_ = (_vala_array_free (_tmp448_, _tmp448__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp450_ = NULL;
			ValaCodeContext* _tmp451_ = NULL;
			const gchar* _tmp452_ = NULL;
			gchar** _tmp453_ = NULL;
			gint _tmp453__length1 = 0;
			const gchar* _tmp454_ = NULL;
			_tmp450_ = ccompiler;
			_tmp451_ = self->priv->context;
			_tmp452_ = vala_compiler_cc_command;
			_tmp453_ = vala_compiler_cc_options;
			_tmp453__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp454_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp450_, _tmp451_, _tmp452_, _tmp453_, _tmp453__length1, _tmp454_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp455_ = vala_compiler_quit (self);
	result = _tmp455_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	const gchar* _tmp37_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gint _tmp40_ = 0;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp54_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp28_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp14_ = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp18_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp14_ = g_option_context_new ("- Vala");
			opt_context = _tmp14_;
			_tmp15_ = opt_context;
			g_option_context_set_help_enabled (_tmp15_, TRUE);
			_tmp16_ = opt_context;
			g_option_context_add_main_entries (_tmp16_, VALA_COMPILER_options, NULL);
			_tmp17_ = compile_args;
			_tmp17__length1 = compile_args_length1;
			temp_args = _tmp17_;
			temp_args_length1 = _tmp17__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp18_ = opt_context;
			g_option_context_parse (_tmp18_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = stdout;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			fprintf (_tmp19_, "%s\n", _tmp21_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			FILE* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = stdout;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			fprintf (_tmp22_, "%s\n", _tmp24_);
			_tmp25_ = stdout;
			_tmp26_ = args;
			_tmp26__length1 = args_length1;
			_tmp27_ = _tmp26_[0];
			fprintf (_tmp25_, "Run '%s --help' to see a full list of available command line options.\n", _tmp27_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp28_ = i;
		i = _tmp28_ + 1;
	}
	_tmp29_ = vala_compiler_version;
	if (_tmp29_) {
		FILE* _tmp30_ = NULL;
		_tmp30_ = stdout;
		fprintf (_tmp30_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp31_ = FALSE;
		_tmp31_ = vala_compiler_api_version;
		if (_tmp31_) {
			FILE* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp32_ = stdout;
			_tmp33_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp34_ = _tmp33_;
			fprintf (_tmp32_, "%s\n", _tmp34_);
			_g_free0 (_tmp34_);
			result = 0;
			return result;
		}
	}
	_tmp35_ = args;
	_tmp35__length1 = args_length1;
	_tmp36_ = i;
	_tmp37_ = _tmp35_[_tmp36_];
	if (_tmp37_ == NULL) {
		FILE* _tmp38_ = NULL;
		_tmp38_ = stderr;
		fprintf (_tmp38_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp39_ = args;
	_tmp39__length1 = args_length1;
	_tmp40_ = i;
	_tmp41_ = _tmp39_[_tmp40_];
	_tmp42_ = g_strdup (_tmp41_);
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp43_;
	_tmp44_ = g_get_tmp_dir ();
	_tmp45_ = args;
	_tmp45__length1 = args_length1;
	_tmp46_ = i;
	_tmp47_ = _tmp45_[_tmp46_];
	_tmp48_ = g_path_get_basename (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp44_, _tmp49_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp51_ = vala_compiler_output;
	_tmp52_ = g_mkstemp (_tmp51_);
	outputfd = _tmp52_;
	_tmp53_ = outputfd;
	if (_tmp53_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp54_ = vala_compiler_new ();
	compiler = _tmp54_;
	_tmp55_ = compiler;
	_tmp56_ = vala_compiler_run (_tmp55_);
	ret = _tmp56_;
	_tmp57_ = ret;
	if (_tmp57_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp58_ = outputfd;
	close (_tmp58_);
	_tmp59_ = vala_compiler_output;
	_tmp60_ = g_chmod (_tmp59_, 0700);
	if (_tmp60_ != 0) {
		const gchar* _tmp61_ = NULL;
		_tmp61_ = vala_compiler_output;
		g_unlink (_tmp61_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_strdup (_tmp62_);
	_tmp64_ = g_new0 (gchar*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	target_args = _tmp64_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp65_ = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gchar** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gint _tmp69_ = 0;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		_tmp65_ = i;
		_tmp66_ = args;
		_tmp66__length1 = args_length1;
		if (!(_tmp65_ < _tmp66__length1)) {
			break;
		}
		_tmp67_ = target_args;
		_tmp67__length1 = target_args_length1;
		_tmp68_ = args;
		_tmp68__length1 = args_length1;
		_tmp69_ = i;
		_tmp70_ = _tmp68_[_tmp69_];
		_tmp71_ = g_strdup (_tmp70_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp71_);
		_tmp72_ = i;
		i = _tmp72_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp73_ = NULL;
		gchar** _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		GPid _tmp75_ = 0;
		const gchar* _tmp76_ = NULL;
		GPid _tmp77_ = 0;
		GMainLoop* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp73_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp73_;
		_data1_->child_status = 0;
		_tmp74_ = target_args;
		_tmp74__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp74_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp75_, &_inner_error_);
		pid = _tmp75_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp76_ = vala_compiler_output;
		g_unlink (_tmp76_);
		_tmp77_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp77_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp78_ = _data1_->loop;
		g_main_loop_run (_tmp78_);
		_tmp79_ = _data1_->child_status;
		result = _tmp79_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp80_ = NULL;
		GError* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp80_ = stdout;
		_tmp81_ = e;
		_tmp82_ = _tmp81_->message;
		fprintf (_tmp80_, "%s\n", _tmp82_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_ = NULL;
	ValaCompiler* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		FILE* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = _tmp20_[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp21_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = vala_compiler_version;
	if (_tmp22_) {
		FILE* _tmp23_ = NULL;
		_tmp23_ = stdout;
		fprintf (_tmp23_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp24_ = FALSE;
		_tmp24_ = vala_compiler_api_version;
		if (_tmp24_) {
			FILE* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp25_ = stdout;
			_tmp26_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp27_ = _tmp26_;
			fprintf (_tmp25_, "%s\n", _tmp27_);
			_g_free0 (_tmp27_);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_ = NULL;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



