local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, m, Protocol, selectroute, subnets, routes
m = Map("hninpop", translate("hninpop"))

m:section(SimpleSection).template  = "hninpop/status"

s = m:section(TypedSection, "default")
s.anonymous = true
s.addremove = false
s:tab("general", translate("General Settings"))
--general

-- 页面加载前，执行 luci.sys.exec("/usr/sbin/hninpop check_user")
luci.sys.exec("/usr/sbin/hninpop check_user")

-- 定义enable字段，用于显示开关按钮
enable = s:taboption("general", Flag, "enable", translate("Bring up on boot"))
enable.default = enable.disabled


username = s:taboption("general", Value, "username", translate("Username"))
username.placeholder = "username" 

password = s:taboption("general", Value, "password", translate("Password"))
password.password=true;

local description = luci.sys.exec("uci -q get hninpop.@default[0].description")
-- 如果description不为空，则显示description字段,显示为文本。不是输入框
if description ~= "" then
    -- description = s:taboption("general", Value, "description", translate("Description"))
    description = s:taboption("general", DummyValue, "description", translate("提示信息"))
end

local login_status = luci.sys.exec("uci -q get hninpop.@default[0].login_status")
if login_status == "" then
    login_status = "0"
end
-- 如果login_status大于等于1，则显示登录状态
if tonumber(login_status) >= 1 then
    login_status = s:taboption("general", DummyValue, "login_status", translate("登录状态"))
    login_status.rawhtml = true
    login_status.value = "<span style='color: red;'>" .. translate("系统检测到该账号已在客户端登录，请先退出客户端登录，再继续使用路由器服务。") .. "</span>"
end


tunnelall = s:taboption("general", Flag, "tunnelall", translate("全局模式"), translate("勾选后为全局模式，未勾选为自动分流模式。"))
tunnelall.default = enable.disabled

mode = s:taboption("general", Flag, "ipmode", translate("防IP泄露模式"), translate("勾选后为防IP泄露模式，海外流量只经过VPN。<br>出现网络异常，如丢包或断网时:<br>分流模式，会导致无法访问海外网络。<br>全局模式，会导致无法访问任何网络。"))
mode.default = enable.disabled

test = s:taboption("general", Flag, "testmode", translate("测试模式"))
test.default = enable.disabled

return m