local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, m
m = Map("hninpop", translate("hninpop"))

s = m:section(TypedSection, "default")
s.anonymous = true
s.addremove = false
s:tab("sysupgrade", translate("固件更新"))


-- 获取当前版本号
local version = luci.sys.exec("cat /etc/openwrt_version"):gsub("\n", "")
if version == "" then
    version = "1.0.0"
end

-- 显示当前版本号
local current_version = s:taboption("sysupgrade", DummyValue, "_version", translate("当前版本"))
current_version.default = version
current_version.rawhtml = true

-- 获取新版本号
local new_version = luci.sys.exec("uci -q get system.@system[0].new_version"):gsub("\n", "")
if new_version ~= version and new_version ~= "" then
    local new_version_display = s:taboption("sysupgrade", DummyValue, "_new_version", translate("最新版本"))
    new_version_display.default = new_version
    new_version_display.rawhtml = true

    local update_log = luci.sys.exec('opkg list luci-app-hninpop | awk \'{ for (i=5; i<=NF; i++) printf $i " "; print "" }\''):gsub("\n", "")
    local update_log_display = s:taboption("sysupgrade", DummyValue, "_update_log", translate("更新日志"))
    update_log_display.default = update_log
    update_log_display.rawhtml = true

    local sysupgrade_check = s:taboption("sysupgrade", Button, "_sysupgrade_check", translate("更新"), translate("点击立即更新固件,更新过程中请勿断电。大约需要5分钟，请耐心等待。"))
    sysupgrade_check.inputtitle = translate("立即更新")
    sysupgrade_check.inputstyle = "apply"

    -- 定义按钮点击后的操作
    function sysupgrade_check.write(self, section)
        local commands = [[
            local_md5=$(md5sum /tmp/openwrt.bin | awk '{print $1}')
            remote_md5=$(cat /tmp/sys_md5|awk '{print $1}')
            if [ "$local_md5" == "$remote_md5" ]; then
                echo "MD5校验通过"
                sysupgrade /tmp/openwrt.bin
            else
                echo "MD5校验失败"
            fi
        ]]
        luci.sys.exec(commands)
        luci.http.redirect(luci.dispatcher.build_url("admin", "hninpop", "sysupgrade"))
    end
end

return m
