/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
/*
 ***************************************************************************
 ***************************************************************************

	Module Name:
	eeprom.h

	Abstract:
	Miniport header file for eeprom related information

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/
#ifndef __EEPROM_H__
#define __EEPROM_H__

#include "eeprom/mt_dmac_e2p_def.h"

/* For ioctl check usage */
#define EEPROM_IS_PROGRAMMED		0x80

#define E2P_NONE					0x00
#define E2P_EFUSE_MODE				0x01
#define E2P_FLASH_MODE				0x02
#define E2P_EEPROM_MODE			0x03
#define E2P_BIN_MODE				0x04
#define NUM_OF_E2P_MODE			0x05

#define E2P_SRC_FROM_EFUSE		BIT(0)
#define E2P_SRC_FROM_FLASH		BIT(1)
#define E2P_SRC_FROM_EEPROM		BIT(2)
#define E2P_SRC_FROM_BIN		BIT(3)
#define E2P_SRC_FROM_FLASH_AND_EFUSE    (BIT(0) | BIT(1)) /* merge mode */
#define E2P_SRC_FROM_BIN_AND_EFUSE      (BIT(0) | BIT(3)) /* merge mode */

#if defined(MT7663) || defined(MT7626) || defined(AXE) || defined(MT7915) || \
	defined(MT7986) || defined(MT7916) || defined(MT7981)
#define CONNAC_EFUSE_FORMAT_SUPPORT
#endif

#ifdef RTMP_MAC_PCI
#define MAX_EEPROM_BIN_FILE_SIZE	512
#else
#define MAX_EEPROM_BIN_FILE_SIZE	1024
#endif /* !RTMP_MAC_PCI */

#if defined(RTMP_MAC_USB) || defined(RT3883)
#define EEPROM_SIZE					0x400
#else
/* #define EEPROM_SIZE					0x200 */
#if defined(MT7986) || defined(MT7916) || defined(MT7981)
#define EEPROM_SIZE					0x1000
#elif defined(MT7663)
#define EEPROM_SIZE					0x600
#else
#define EEPROM_SIZE					0x400
#endif
#endif /* defined(RTMP_MAC_USB) || defined(RT3883) */

#define EEPROM_DEFULT_BIN_FILE	"RT30xxEEPROM.bin"
#ifdef BB_SOC
#define BIN_FILE_PATH				"/etc/RT30xxEEPROM.bin"
#if defined(PRE_CAL_TRX_SET1_SUPPORT) || defined(PRE_CAL_TRX_SET2_SUPPORT) || defined(RLM_CAL_CACHE_SUPPORT)
#define CAL_FILE_PATH				"/etc/CALDATA_default.bin"
#endif /* PRE_CAL_TRX_SET1_SUPPORT */
#if defined(CAL_BIN_FILE_SUPPORT) && defined(MT7615)
#define CAL_BIN_FILE_PATH           "/etc/CALIBRATION_DATA.bin"
#endif /* CAL_BIN_FILE_SUPPORT */
#else
/* #define BIN_FILE_PATH				"/tmp/RT30xxEEPROM.bin" */
#ifdef WCX_SUPPORT
#define BIN_FILE_PATH				"/data/nvram/APCFG/APRDEB/WIFI"
#else
#define BIN_FILE_PATH				"/etc/RT30xxEEPROM.bin"
#if defined(PRE_CAL_TRX_SET1_SUPPORT) || defined(PRE_CAL_TRX_SET2_SUPPORT) || defined(RLM_CAL_CACHE_SUPPORT)
#define CAL_FILE_PATH				"/etc/CALDATA_default.bin"
#endif /* PRE_CAL_TRX_SET1_SUPPORT */
#if defined(CAL_BIN_FILE_SUPPORT) && defined(MT7615)
#define CAL_BIN_FILE_PATH           "/etc/CALIBRATION_DATA.bin"
#endif /* CAL_BIN_FILE_SUPPORT */
#endif /* WCX_SUPPORT */
#endif /* BB_SOC */

#define EEPROM_DFT_FILE_DIR		"/etc_ro/wlan/"
#define EEPROM_1ST_FILE_DIR		"/etc_ro/Wireless/RT2860/"
#define EEPROM_2ND_FILE_DIR		"/etc_ro/Wireless/iNIC/"

#ifndef EEPROM_DEFAULT_FILE_PATH
/* RFIC 2820 */
#define EEPROM_DEFAULT_FILE_PATH                     "/etc_ro/wlan/RT2880_RT2820_AP_2T3R_V1_6.bin"




#endif /* EEPROM_DEFAULT_FILE_PATH */


typedef struct eeprom_flash_info_t {
	UINT32	offset;
	UINT32	size;
	RTMP_STRING	bin_name[L1PROFILE_ATTRNAME_LEN];
} eeprom_flash_info;


#define NVRAM_OFFSET				0x30000

#if defined(CONFIG_RT2880_FLASH_32M)
#define DEFAULT_RF_OFFSET					0x1FE0000
#else
#define DEFAULT_RF_OFFSET					0x40000
#endif

#define SECOND_RF_OFFSET					0x48000

#ifdef RT_BIG_ENDIAN
typedef	union _EEPROM_WORD_STRUC {
	struct {
		UCHAR	Byte1;				/* High Byte */
		UCHAR	Byte0;				/* Low Byte */
	} field;
	USHORT	word;
} EEPROM_WORD_STRUC;
#else
typedef	union _EEPROM_WORD_STRUC {
	struct {
		UCHAR	Byte0;
		UCHAR	Byte1;
	} field;
	USHORT	word;
} EEPROM_WORD_STRUC;
#endif


/* ------------------------------------------------------------------- */
/*  E2PROM data layout */
/* ------------------------------------------------------------------- */

/* Board type */

#define BOARD_TYPE_MINI_CARD		0	/* Mini card */
#define BOARD_TYPE_USB_PEN		1	/* USB pen */

/*CONNAC based parameter define --- START*/
#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT
#define SINGLE_GROUP               1
#define G_BAND_CH_GROUP_NUM        1
#define A_BAND_CH_GROUP_NUM        8
#define IPA_SWITCH_TYPE_NUM        3
#define G_BAND_LNA_CATOGORY_NUM    1
#define A_BAND_LNA_CATOGORY_NUM    3
#define THERMO_TYPE_NUM            3
#define G_BAND_DPD_GROUP_NUM       6
#define A_BAND_DPD_GROUP_NUM      48
#define G_BAND_BW20_CH_NUM             14
#define G_BAND_BW40_CH_NUM             9
#define G_BAND_LATENCY_CATOGORY_NUM    3
#define A_BAND_LATENCY_CATOGORY_NUM    3

#define EFUSE_INFO_TX_POWER_SIMPLE_TYPE		0
#define EFUSE_INFO_TX_POWER_EXTENDED_TYPE	1
#define EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1	2

#define BAND_G                                        0
#define BAND_A                                        1
#define BAND_NUM                                      2

/** chanel group not care*/
#define CH_GROUP_NOT_CARE          0

/** Efuse Common module element number */
#define EFUSE_INFO_2G4_COMMON_TEMP_TSSI_NUM                 (1 * EFUSE_COMMON_TEMP_TSSI_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_COMMON_DYNAMIC_IPA_SWITCH_NUM        EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_ITEM_NUM
#define EFUSE_INFO_2G4_COMMON_ELNA_NUM                      (1 * EFUSE_2G4_COMMON_ELNA_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_COMMON_THERMO_COMP_NUM               EFUSE_COMMON_THERMO_COMP_CATEGORY_ITEM_NUM
#define EFUSE_INFO_2G4_COMMON_EPA_DPD_NUM                   EFUSE_COMMON_EPA_DPD_CATEGORY_ITEM_NUM

#define EFUSE_INFO_5G_COMMON_TEMP_TSSI_NUM                  (8 * EFUSE_COMMON_TEMP_TSSI_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_COMMON_DYNAMIC_IPA_SWITCH_NUM         EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_ITEM_NUM
#define EFUSE_INFO_5G_COMMON_ELNA_NUM                       (3 * EFUSE_5G_COMMON_ELNA_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_COMMON_THERMO_COMP_NUM                EFUSE_COMMON_THERMO_COMP_CATEGORY_ITEM_NUM
#define EFUSE_INFO_5G_COMMON_EPA_DPD_NUM                    EFUSE_COMMON_EPA_DPD_CATEGORY_ITEM_NUM

#define EFUSE_INFO_2G4_WF_PATH_FE_LOSS_NUM                  (1 * EFUSE_2G4_WF_PATH_FE_LOSS_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_WF_PATH_TSSI_NUM                     (1 * EFUSE_WF_PATH_TSSI_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_WF_PATH_PHY_POWER_NUM                EFUSE_WF_PATH_PHY_POWER_CATEGORY_ITEM_NUM
#define EFUSE_INFO_2G4_WF_PATH_TX_POWER_OFFSET_NUM          (1 * EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_WF_PATH_DPD_G0_NUM                   (1 * EFUSE_WF_PATH_DPD_G0_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_2G4_WF_PATH_LNA_GAIN_NUM                 (1 * EFUSE_WF_PATH_LNA_GAIN_CATEGORY_ITEM_NUM)

#define EFUSE_INFO_5G_WF_PATH_FE_LOSS_NUM                   (3 * EFUSE_5G_WF_PATH_FE_LOSS_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_WF_PATH_TSSI_NUM                      (8 * EFUSE_WF_PATH_TSSI_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_WF_PATH_PHY_POWER_NUM                 EFUSE_WF_PATH_PHY_POWER_CATEGORY_ITEM_NUM
#define EFUSE_INFO_5G_WF_PATH_TX_POWER_OFFSET_NUM           (8 * EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_WF_PATH_DPD_G0_NUM                    (4 * EFUSE_WF_PATH_DPD_G0_CATEGORY_ITEM_NUM)
#define EFUSE_INFO_5G_WF_PATH_LNA_GAIN_NUM                  (8 * EFUSE_WF_PATH_LNA_GAIN_CATEGORY_ITEM_NUM)

/** Efuse Common module element offset */
#define EFUSE_INFO_2G4_COMMON_TEMP_TSSI_OFFSET              0
#define EFUSE_INFO_2G4_COMMON_DYNAMIC_IPA_SWITCH_OFFSET     (EFUSE_INFO_2G4_COMMON_TEMP_TSSI_OFFSET + EFUSE_INFO_2G4_COMMON_TEMP_TSSI_NUM)
#define EFUSE_INFO_2G4_COMMON_ELNA_OFFSET                   (EFUSE_INFO_2G4_COMMON_DYNAMIC_IPA_SWITCH_OFFSET + EFUSE_INFO_2G4_COMMON_DYNAMIC_IPA_SWITCH_NUM)
#define EFUSE_INFO_2G4_COMMON_THERMO_COMP_OFFSET            (EFUSE_INFO_2G4_COMMON_ELNA_OFFSET + EFUSE_INFO_2G4_COMMON_ELNA_NUM)
#define EFUSE_INFO_2G4_COMMON_EPA_DPD_OFFSET                (EFUSE_INFO_2G4_COMMON_THERMO_COMP_OFFSET + EFUSE_INFO_2G4_COMMON_EPA_DPD_NUM)

#define EFUSE_INFO_5G_COMMON_TEMP_TSSI_OFFSET               0
#define EFUSE_INFO_5G_COMMON_DYNAMIC_IPA_SWITCH_OFFSET      (EFUSE_INFO_5G_COMMON_TEMP_TSSI_OFFSET + EFUSE_INFO_5G_COMMON_TEMP_TSSI_NUM)
#define EFUSE_INFO_5G_COMMON_ELNA_OFFSET                    (EFUSE_INFO_5G_COMMON_DYNAMIC_IPA_SWITCH_OFFSET + EFUSE_INFO_5G_COMMON_DYNAMIC_IPA_SWITCH_NUM)
#define EFUSE_INFO_5G_COMMON_THERMO_COMP_OFFSET             (EFUSE_INFO_5G_COMMON_ELNA_OFFSET + EFUSE_INFO_5G_COMMON_ELNA_NUM)
#define EFUSE_INFO_5G_COMMON_EPA_DPD_OFFSET                 (EFUSE_INFO_5G_COMMON_THERMO_COMP_OFFSET + EFUSE_INFO_5G_COMMON_EPA_DPD_NUM)

#define EFUSE_INFO_2G4_WF_PATH_FE_LOSS_OFFSET               0
#define EFUSE_INFO_2G4_WF_PATH_TSSI_OFFSET                  (EFUSE_INFO_2G4_WF_PATH_FE_LOSS_OFFSET + EFUSE_INFO_2G4_WF_PATH_FE_LOSS_NUM)
#define EFUSE_INFO_2G4_WF_PATH_PHY_POWER_OFFSET             (EFUSE_INFO_2G4_WF_PATH_TSSI_OFFSET + EFUSE_INFO_2G4_WF_PATH_TSSI_NUM)
#define EFUSE_INFO_2G4_WF_PATH_TX_POWER_OFFSET_OFFSET       (EFUSE_INFO_2G4_WF_PATH_PHY_POWER_OFFSET + EFUSE_INFO_2G4_WF_PATH_PHY_POWER_NUM)
#define EFUSE_INFO_2G4_WF_PATH_DPD_G0_OFFSET                (EFUSE_INFO_2G4_WF_PATH_TX_POWER_OFFSET_OFFSET + EFUSE_INFO_2G4_WF_PATH_TX_POWER_OFFSET_NUM)
#define EFUSE_INFO_2G4_WF_PATH_LNA_GAIN_OFFSET              (EFUSE_INFO_2G4_WF_PATH_DPD_G0_OFFSET + EFUSE_INFO_2G4_WF_PATH_DPD_G0_NUM)

#define EFUSE_INFO_5G_WF_PATH_FE_LOSS_OFFSET                0
#define EFUSE_INFO_5G_WF_PATH_TSSI_OFFSET                   (EFUSE_INFO_5G_WF_PATH_FE_LOSS_OFFSET + EFUSE_INFO_5G_WF_PATH_FE_LOSS_NUM)
#define EFUSE_INFO_5G_WF_PATH_PHY_POWER_OFFSET              (EFUSE_INFO_5G_WF_PATH_TSSI_OFFSET + EFUSE_INFO_5G_WF_PATH_TSSI_NUM)
#define EFUSE_INFO_5G_WF_PATH_TX_POWER_OFFSET_OFFSET        (EFUSE_INFO_5G_WF_PATH_PHY_POWER_OFFSET + EFUSE_INFO_5G_WF_PATH_PHY_POWER_NUM)
#define EFUSE_INFO_5G_WF_PATH_DPD_G0_OFFSET                 (EFUSE_INFO_5G_WF_PATH_TX_POWER_OFFSET_OFFSET + EFUSE_INFO_5G_WF_PATH_TX_POWER_OFFSET_NUM)
#define EFUSE_INFO_5G_WF_PATH_LNA_GAIN_OFFSET               (EFUSE_INFO_5G_WF_PATH_DPD_G0_OFFSET + EFUSE_INFO_5G_WF_PATH_DPD_G0_NUM)

#if defined(MT7663) || defined(AXE) || defined(MT7915) || defined(MT7986) || \
	defined(MT7916) || defined(MT7981)
#define CONNAC_WIFI_TX_POWER_EFUSE_TYPE EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1
#endif

#define TX_PATH_NUM 4
#define RX_PATH_NUM 4
#define MAX_ANTENNA_NUM	4

#define IBF_LNA_TYPE_NUM           5
#define IBF_CAL_GROUP              8
#define IBF_PARAM_NUM              (TX_PATH_NUM + (RX_PATH_NUM * IBF_LNA_TYPE_NUM))
#endif /*#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT*/
/*CONNAC based parameter define --- END*/

/*
	EEPROM antenna select format
*/

#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_NIC_CINFIG2_STRUC {
	struct {
		USHORT DACTestBit:1;	/* control if driver should patch the DAC issue */
		USHORT CoexBit:1;
		USHORT bInternalTxALC:1;	/* Internal Tx ALC */
		USHORT AntOpt:1;	/* Fix Antenna Option: 0:Main; 1: Aux */
		USHORT AntDiversity:1;	/* Antenna diversity */
		USHORT Rsv1:1;	/* must be 0 */
		USHORT BW40MAvailForA:1;	/* 0:enable, 1:disable */
		USHORT BW40MAvailForG:1;	/* 0:enable, 1:disable */
		USHORT EnableWPSPBC:1;	/* WPS PBC Control bit */
		USHORT BW40MSidebandForA:1;
		USHORT BW40MSidebandForG:1;
		USHORT CardbusAcceleration:1;	/* !!! NOTE: 0 - enable, 1 - disable */
		USHORT ExternalLNAForA:1;	/* external LNA enable for 5G */
		USHORT ExternalLNAForG:1;	/* external LNA enable for 2.4G */
		USHORT DynamicTxAgcControl:1;	/* */
		USHORT HardwareRadioControl:1;	/* Whether RF is controlled by driver or HW. 1:enable hw control, 0:disable */
	} field;
	USHORT word;
} EEPROM_NIC_CONFIG2_STRUC, *PEEPROM_NIC_CONFIG2_STRUC;
#else
typedef union _EEPROM_NIC_CINFIG2_STRUC {
	struct {
		USHORT HardwareRadioControl:1;	/* 1:enable, 0:disable */
		USHORT DynamicTxAgcControl:1;	/* */
		USHORT ExternalLNAForG:1;	/* external LNA enable for 2.4G */
		USHORT ExternalLNAForA:1;	/* external LNA enable for 5G */
		USHORT CardbusAcceleration:1;	/* !!! NOTE: 0 - enable, 1 - disable */
		USHORT BW40MSidebandForG:1;
		USHORT BW40MSidebandForA:1;
		USHORT EnableWPSPBC:1;	/* WPS PBC Control bit */
		USHORT BW40MAvailForG:1;	/* 0:enable, 1:disable */
		USHORT BW40MAvailForA:1;	/* 0:enable, 1:disable */
		USHORT Rsv1:1;	/* must be 0 */
		USHORT AntDiversity:1;	/* Antenna diversity */
		USHORT AntOpt:1;	/* Fix Antenna Option: 0:Main; 1: Aux */
		USHORT bInternalTxALC:1;	/* Internal Tx ALC */
		USHORT CoexBit:1;
		USHORT DACTestBit:1;	/* control if driver should patch the DAC issue */
	} field;
	USHORT word;
} EEPROM_NIC_CONFIG2_STRUC, *PEEPROM_NIC_CONFIG2_STRUC;
#endif

/*
	TX_PWR Value valid range 0xFA(-6) ~ 0x24(36)
*/
#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_TX_PWR_STRUC {
	struct {
		signed char Byte1;	/* High Byte */
		signed char Byte0;	/* Low Byte */
	} field;
	USHORT word;
} EEPROM_TX_PWR_STRUC, *PEEPROM_TX_PWR_STRUC;
#else
typedef union _EEPROM_TX_PWR_STRUC {
	struct {
		signed char Byte0;	/* Low Byte */
		signed char Byte1;	/* High Byte */
	} field;
	USHORT word;
} EEPROM_TX_PWR_STRUC, *PEEPROM_TX_PWR_STRUC;
#endif

#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_VERSION_STRUC {
	struct {
		UCHAR Version;	/* High Byte */
		UCHAR FaeReleaseNumber;	/* Low Byte */
	} field;
	USHORT word;
} EEPROM_VERSION_STRUC, *PEEPROM_VERSION_STRUC;
#else
typedef union _EEPROM_VERSION_STRUC {
	struct {
		UCHAR FaeReleaseNumber;	/* Low Byte */
		UCHAR Version;	/* High Byte */
	} field;
	USHORT word;
} EEPROM_VERSION_STRUC, *PEEPROM_VERSION_STRUC;
#endif

#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_LED_STRUC {
	struct {
		USHORT Rsvd:3;	/* Reserved */
		USHORT LedMode:5;	/* Led mode. */
		USHORT PolarityGPIO_4:1;	/* Polarity GPIO#4 setting. */
		USHORT PolarityGPIO_3:1;	/* Polarity GPIO#3 setting. */
		USHORT PolarityGPIO_2:1;	/* Polarity GPIO#2 setting. */
		USHORT PolarityGPIO_1:1;	/* Polarity GPIO#1 setting. */
		USHORT PolarityGPIO_0:1;	/* Polarity GPIO#0 setting. */
		USHORT PolarityACT:1;	/* Polarity ACT setting. */
		USHORT PolarityRDY_A:1;	/* Polarity RDY_A setting. */
		USHORT PolarityRDY_G:1;	/* Polarity RDY_G setting. */
	} field;
	USHORT word;
} EEPROM_LED_STRUC, *PEEPROM_LED_STRUC;
#else
typedef union _EEPROM_LED_STRUC {
	struct {
		USHORT PolarityRDY_G:1;	/* Polarity RDY_G setting. */
		USHORT PolarityRDY_A:1;	/* Polarity RDY_A setting. */
		USHORT PolarityACT:1;	/* Polarity ACT setting. */
		USHORT PolarityGPIO_0:1;	/* Polarity GPIO#0 setting. */
		USHORT PolarityGPIO_1:1;	/* Polarity GPIO#1 setting. */
		USHORT PolarityGPIO_2:1;	/* Polarity GPIO#2 setting. */
		USHORT PolarityGPIO_3:1;	/* Polarity GPIO#3 setting. */
		USHORT PolarityGPIO_4:1;	/* Polarity GPIO#4 setting. */
		USHORT LedMode:5;	/* Led mode. */
		USHORT Rsvd:3;	/* Reserved */
	} field;
	USHORT word;
} EEPROM_LED_STRUC, *PEEPROM_LED_STRUC;
#endif

#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_TXPOWER_DELTA_STRUC {
	struct {
		UCHAR TxPowerEnable:1;	/* Enable */
		UCHAR Type:1;	/* 1: plus the delta value, 0: minus the delta value */
		UCHAR DeltaValue:6;	/* Tx Power dalta value (MAX=4) */
	} field;
	UCHAR value;
} EEPROM_TXPOWER_DELTA_STRUC, *PEEPROM_TXPOWER_DELTA_STRUC;
#else
typedef union _EEPROM_TXPOWER_DELTA_STRUC {
	struct {
		UCHAR DeltaValue:6;	/* Tx Power dalta value (MAX=4) */
		UCHAR Type:1;	/* 1: plus the delta value, 0: minus the delta value */
		UCHAR TxPowerEnable:1;	/* Enable */
	} field;
	UCHAR value;
} EEPROM_TXPOWER_DELTA_STRUC, *PEEPROM_TXPOWER_DELTA_STRUC;
#endif


#ifdef RT_BIG_ENDIAN
typedef union _EEPROM_TX_PWR_OFFSET_STRUC {
	struct {
		UCHAR	Byte1;	/* High Byte */
		UCHAR	Byte0;	/* Low Byte */
	} field;

	USHORT		word;
} EEPROM_TX_PWR_OFFSET_STRUC, *PEEPROM_TX_PWR_OFFSET_STRUC;
#else
typedef union _EEPROM_TX_PWR_OFFSET_STRUC {
	struct {
		UCHAR	Byte0;	/* Low Byte */
		UCHAR	Byte1;	/* High Byte */
	} field;

	USHORT		word;
} EEPROM_TX_PWR_OFFSET_STRUC, *PEEPROM_TX_PWR_OFFSET_STRUC;
#endif /* RT_BIG_ENDIAN */

typedef struct _EEPROM_CONTROL {
	UCHAR e2pCurMode;
	UCHAR e2pSource;
	RTMP_STRING BinSource[100];
} EEPROM_CONTROL, *PEEPROM_CONTROL;

typedef struct _EPPROM_PROPERTY_TYPE {
	USHORT  Offset;
	BOOLEAN RFlcok;
	BOOLEAN CalFree;
} EPPROM_PROPERTY_TYPE, *P_EPPROM_PROPERTY_TYPE;

/*CONNAC based parameter define --- START*/
#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT
typedef enum _TYPE_CONTENT_FORMAT {
	CONTENT_FORMAT_BIN_CONTENT = 0,
	CONTENT_FORMAT_WHOLE_CONTENT = 1,
	CONTENT_FORMAT_MULTIPLE_SECTIONS = 2
} TYPE_CONTENT_FORMAT, *P_TYPE_CONTENT_FORMAT;

typedef enum _ENUM_EFUSE_INFO_GETSET {
	ENUM_EFUSE_INFO_GET = 0,
	ENUM_EFUSE_INFO_SET,
	ENUM_EFUSE_INFO_MODE_NUM
} ENUM_EFUSE_INFO_GETSET, *P_ENUM_EFUSE_INFO_GETSET;

/** FrontEnd Loss Type */
typedef enum _ENUM_FRONTEND_LOSS_TYPE {
	ENUM_FRONTEND_LOSS_TYPE_TX = 0,
	ENUM_FRONTEND_LOSS_TYPE_RX,
	ENUM_FRONTEND_LOSS_TYPE_NUM
} ENUM_FRONTEND_LOSS_TYPE, *P_ENUM_FRONTEND_LOSS_TYPE;

/** Channel group category */
typedef enum _CH_GROUP {
	CH_GROUP_0 = 0,
	CH_GROUP_1,
	CH_GROUP_2,
	CH_GROUP_3,
	CH_GROUP_4,
	CH_GROUP_5,
	CH_GROUP_6,
	CH_GROUP_7,
	CH_GROUP_NUM
} CH_GROUP, *P_CH_GROUP;

/** Efuse Info Category Enumeration */
typedef enum _EFUSE_INFO_MODULE_CATEGORY {
	EFUSE_INFO_MODULE_SYSTEM = 0,
	EFUSE_INFO_MODULE_COMMON,
	EFUSE_INFO_MODULE_TX_POWER,
	EFUSE_INFO_MODULE_DELAY_COMP,
	EFUSE_INFO_MODULE_WIFI_PATH,
	EFUSE_INFO_MODULE_IBF_CAL,
	EFUSE_INFO_MODULE_NUM
} EFUSE_INFO_MODULE_CATEGORY, *P_EFUSE_INFO_MODULE_CATEGORY;

/** Tx Power Category Enumeration */
typedef enum _EFUSE_INFO_TX_POWER_CATEGORY {
	CATEGORY_NTX_POWER_OFFSET = 0,
	CATEGORY_TX_POWER_RATE,
	TX_POWER_CATEGORY_NUM
} EFUSE_INFO_TX_POWER_CATEGORY, *P_EFUSE_INFO_TX_POWER_CATEGORY;

/** Delay Compensation Category Enumeration */
typedef enum _EFUSE_INFO_DELAY_COMP_CATEGORY {
	CATEGORY_DEALY_COMP_CTRL = 0,
	CATEGORY_RX_LATENCY,
	DELAY_COMP_CATEGORY_NUM
} EFUSE_INFO_DELAY_COMP_CATEGORY, *P_EFUSE_INFO_DELAY_COMP_CATEGORY;

/** NTx Power offset Item List */
typedef enum _EFUSE_NTX_POWER_OFFSET_ITEM {
	EFUSE2G4_3TX_2G4_2TX_POWER_OFFSET = 0,
	EFUSE5G_2TX_2G4_4TX_POWER_OFFSET,
	EFUSE5G_4TX_5G_3TX_POWER_OFFSET,
	EFUSE_NTX_POWER_OFFSET_ITEM_NUM
} EFUSE_NTX_POWER_OFFSET_ITEM, *P_EFUSE_NTX_POWER_OFFSET_ITEM;

#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE)
/** 2G Rate Power Item List */
typedef enum _EFUSE_2G4_RATE_POWER_ITEM {
	EFUSE_2G4_TXPOWER_CCK_1M2M = 0,
	EFUSE_2G4_TXPOWER_CCK_5M11M,
	EFUSE_2G4_TXPOWER_OFDM_6M9M,
	EFUSE_2G4_TXPOWER_OFDM_12M18M,
	EFUSE_2G4_TXPOWER_OFDM_24M36M,
	EFUSE_2G4_TXPOWER_OFDM_48M,
	EFUSE_2G4_TXPOWER_OFDM_54M,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M0,
	EFUSE_2G4_TXPOWER_HT40_M32,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M1M2,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M3M4,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M5,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M6,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M7,
	EFUSE_2G4_TXPOWER_VHT20_M8,
	EFUSE_2G4_TXPOWER_VHT20_M9,
	EFUSE_2G4_TXPOWER_HT40_M0,
	EFUSE_2G4_TXPOWER_HT40_M1M2,
	EFUSE_2G4_TXPOWER_HT40_M3M4,
	EFUSE_2G4_TXPOWER_HT40_M5,
	EFUSE_2G4_TXPOWER_HT40_M6,
	EFUSE_2G4_TXPOWER_HT40_M7,
	EFUSE_2G4_TXPOWER_VHT40_BW_OFFSET,
	EFUSE_2G4_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_2G4_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_2G4_RATE_POWER_ITEM, *P_EFUSE_2G4_RATE_POWER_ITEM;

/** 5G Rate Power Item List */
typedef enum _EFUSE_5G_RATE_POWER_ITEM {
	EFUSE_5G_TXPOWER_OFDM_6M9M = 0,
	EFUSE_5G_TXPOWER_OFDM_12M18M,
	EFUSE_5G_TXPOWER_OFDM_24M36M,
	EFUSE_5G_TXPOWER_OFDM_48M,
	EFUSE_5G_TXPOWER_OFDM_54M,
	EFUSE_5G_TXPOWER_HT20_VHT20_M0,
	EFUSE_5G_TXPOWER_HT40_M32,
	EFUSE_5G_TXPOWER_HT20_VHT20_M1M2,
	EFUSE_5G_TXPOWER_HT20_VHT20_M3M4,
	EFUSE_5G_TXPOWER_HT20_VHT20_M5,
	EFUSE_5G_TXPOWER_HT20_VHT20_M6,
	EFUSE_5G_TXPOWER_HT20_VHT20_M7,
	EFUSE_5G_TXPOWER_VHT20_M8,
	EFUSE_5G_TXPOWER_VHT20_M9,
	EFUSE_5G_TXPOWER_HT40_M0,
	EFUSE_5G_TXPOWER_HT40_M1M2,
	EFUSE_5G_TXPOWER_HT40_M3M4,
	EFUSE_5G_TXPOWER_HT40_M5,
	EFUSE_5G_TXPOWER_HT40_M6,
	EFUSE_5G_TXPOWER_HT40_M7,
	EFUSE_5G_TXPOWER_VHT40_BW_OFFSET,
	EFUSE_5G_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_5G_TXPOWER_VHT80_BW_OFFSET,
	EFUSE_5G_TXPOWER_VHT160C_BW_OFFSET,
	EFUSE_5G_TXPOWER_VHT160NC_BW_OFFSET,
	EFUSE_5G_TXPOWER_LGVHT80_BW_OFFSET,
	EFUSE_5G_TXPOWER_LGVHT160_BW_OFFSET,
	EFUSE_5G_TXPOWER_BW5M_OFFSET,
	EFUSE_5G_TXPOWER_BW10M_OFFSET,
	EFUSE_5G_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_5G_RATE_POWER_ITEM, *P_EFUSE_5G_RATE_POWER_ITEM;

#else /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE) */
#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE)
/** 2G Rate Power Item List */
typedef enum _EFUSE_2G4_RATE_POWER_ITEM {
	EFUSE_2G4_TXPOWER_CCK_1M = 0,
	EFUSE_2G4_TXPOWER_CCK_2M,
	EFUSE_2G4_TXPOWER_CCK_5M,
	EFUSE_2G4_TXPOWER_CCK_11M,
	EFUSE_2G4_TXPOWER_OFDM_6M,
	EFUSE_2G4_TXPOWER_OFDM_9M,
	EFUSE_2G4_TXPOWER_OFDM_12M,
	EFUSE_2G4_TXPOWER_OFDM_18M,
	EFUSE_2G4_TXPOWER_OFDM_24M,
	EFUSE_2G4_TXPOWER_OFDM_36M,
	EFUSE_2G4_TXPOWER_OFDM_48M,
	EFUSE_2G4_TXPOWER_OFDM_54M,
	EFUSE_2G4_TXPOWER_HT20_M0,
	EFUSE_2G4_TXPOWER_HT20_M1,
	EFUSE_2G4_TXPOWER_HT20_M2,
	EFUSE_2G4_TXPOWER_HT20_M3,
	EFUSE_2G4_TXPOWER_HT20_M4,
	EFUSE_2G4_TXPOWER_HT20_M5,
	EFUSE_2G4_TXPOWER_HT20_M6,
	EFUSE_2G4_TXPOWER_HT20_M7,
	EFUSE_2G4_TXPOWER_HT40_M0,
	EFUSE_2G4_TXPOWER_HT40_M1,
	EFUSE_2G4_TXPOWER_HT40_M2,
	EFUSE_2G4_TXPOWER_HT40_M3,
	EFUSE_2G4_TXPOWER_HT40_M4,
	EFUSE_2G4_TXPOWER_HT40_M5,
	EFUSE_2G4_TXPOWER_HT40_M6,
	EFUSE_2G4_TXPOWER_HT40_M7,
	EFUSE_2G4_TXPOWER_VHT20_M0,
	EFUSE_2G4_TXPOWER_VHT20_M1,
	EFUSE_2G4_TXPOWER_VHT20_M2,
	EFUSE_2G4_TXPOWER_VHT20_M3,
	EFUSE_2G4_TXPOWER_VHT20_M4,
	EFUSE_2G4_TXPOWER_VHT20_M5,
	EFUSE_2G4_TXPOWER_VHT20_M6,
	EFUSE_2G4_TXPOWER_VHT20_M7,
	EFUSE_2G4_TXPOWER_VHT20_M8,
	EFUSE_2G4_TXPOWER_VHT20_M9,
	EFUSE_2G4_TXPOWER_VHT40_M0,
	EFUSE_2G4_TXPOWER_VHT40_M1,
	EFUSE_2G4_TXPOWER_VHT40_M2,
	EFUSE_2G4_TXPOWER_VHT40_M3,
	EFUSE_2G4_TXPOWER_VHT40_M4,
	EFUSE_2G4_TXPOWER_VHT40_M5,
	EFUSE_2G4_TXPOWER_VHT40_M6,
	EFUSE_2G4_TXPOWER_VHT40_M7,
	EFUSE_2G4_TXPOWER_VHT40_M8,
	EFUSE_2G4_TXPOWER_VHT40_M9,
	EFUSE_2G4_TXPOWER_HT40_M32,
	EFUSE_2G4_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_2G4_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_2G4_RATE_POWER_ITEM, *P_EFUSE_2G4_RATE_POWER_ITEM;

/** 5G Rate Power Item List */
typedef enum _EFUSE_5G_RATE_POWER_ITEM {
	EFUSE_5G_TXPOWER_OFDM_6M = 0,
	EFUSE_5G_TXPOWER_OFDM_9M,
	EFUSE_5G_TXPOWER_OFDM_12M,
	EFUSE_5G_TXPOWER_OFDM_18M,
	EFUSE_5G_TXPOWER_OFDM_24M,
	EFUSE_5G_TXPOWER_OFDM_36M,
	EFUSE_5G_TXPOWER_OFDM_48M,
	EFUSE_5G_TXPOWER_OFDM_54M,
	EFUSE_5G_TXPOWER_HT20_M0,
	EFUSE_5G_TXPOWER_HT20_M1,
	EFUSE_5G_TXPOWER_HT20_M2,
	EFUSE_5G_TXPOWER_HT20_M3,
	EFUSE_5G_TXPOWER_HT20_M4,
	EFUSE_5G_TXPOWER_HT20_M5,
	EFUSE_5G_TXPOWER_HT20_M6,
	EFUSE_5G_TXPOWER_HT20_M7,
	EFUSE_5G_TXPOWER_HT40_M0,
	EFUSE_5G_TXPOWER_HT40_M1,
	EFUSE_5G_TXPOWER_HT40_M2,
	EFUSE_5G_TXPOWER_HT40_M3,
	EFUSE_5G_TXPOWER_HT40_M4,
	EFUSE_5G_TXPOWER_HT40_M5,
	EFUSE_5G_TXPOWER_HT40_M6,
	EFUSE_5G_TXPOWER_HT40_M7,
	EFUSE_5G_TXPOWER_VHT20_M0,
	EFUSE_5G_TXPOWER_VHT20_M1,
	EFUSE_5G_TXPOWER_VHT20_M2,
	EFUSE_5G_TXPOWER_VHT20_M3,
	EFUSE_5G_TXPOWER_VHT20_M4,
	EFUSE_5G_TXPOWER_VHT20_M5,
	EFUSE_5G_TXPOWER_VHT20_M6,
	EFUSE_5G_TXPOWER_VHT20_M7,
	EFUSE_5G_TXPOWER_VHT20_M8,
	EFUSE_5G_TXPOWER_VHT20_M9,
	EFUSE_5G_TXPOWER_VHT40_M0,
	EFUSE_5G_TXPOWER_VHT40_M1,
	EFUSE_5G_TXPOWER_VHT40_M2,
	EFUSE_5G_TXPOWER_VHT40_M3,
	EFUSE_5G_TXPOWER_VHT40_M4,
	EFUSE_5G_TXPOWER_VHT40_M5,
	EFUSE_5G_TXPOWER_VHT40_M6,
	EFUSE_5G_TXPOWER_VHT40_M7,
	EFUSE_5G_TXPOWER_VHT40_M8,
	EFUSE_5G_TXPOWER_VHT40_M9,
	EFUSE_5G_TXPOWER_VHT80_M0,
	EFUSE_5G_TXPOWER_VHT80_M1,
	EFUSE_5G_TXPOWER_VHT80_M2,
	EFUSE_5G_TXPOWER_VHT80_M3,
	EFUSE_5G_TXPOWER_VHT80_M4,
	EFUSE_5G_TXPOWER_VHT80_M5,
	EFUSE_5G_TXPOWER_VHT80_M6,
	EFUSE_5G_TXPOWER_VHT80_M7,
	EFUSE_5G_TXPOWER_VHT80_M8,
	EFUSE_5G_TXPOWER_VHT80_M9,
	EFUSE_5G_TXPOWER_VHT160_M0,
	EFUSE_5G_TXPOWER_VHT160_M1,
	EFUSE_5G_TXPOWER_VHT160_M2,
	EFUSE_5G_TXPOWER_VHT160_M3,
	EFUSE_5G_TXPOWER_VHT160_M4,
	EFUSE_5G_TXPOWER_VHT160_M5,
	EFUSE_5G_TXPOWER_VHT160_M6,
	EFUSE_5G_TXPOWER_VHT160_M7,
	EFUSE_5G_TXPOWER_VHT160_M8,
	EFUSE_5G_TXPOWER_VHT160_M9,
	EFUSE_5G_TXPOWER_HT40_M32,
	EFUSE_5G_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_5G_TXPOWER_LGVHT80_BW_OFFSET,
	EFUSE_5G_TXPOWER_LGVHT160_BW_OFFSET,
	EFUSE_5G_TXPOWER_BW5M_OFFSET,
	EFUSE_5G_TXPOWER_BW10M_OFFSET,
	EFUSE_5G_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_5G_RATE_POWER_ITEM, *P_EFUSE_5G_RATE_POWER_ITEM;

#else /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE) */
#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1)
/** 2G Rate Power Item List */
typedef enum _EFUSE_2G4_RATE_POWER_ITEM {
	EFUSE_2G4_TXPOWER_CCK_1M2M = 0,
	EFUSE_2G4_TXPOWER_CCK_5M11M,
	EFUSE_2G4_TXPOWER_OFDM_6M9M,
	EFUSE_2G4_TXPOWER_OFDM_12M18M,
	EFUSE_2G4_TXPOWER_OFDM_24M36M,
	EFUSE_2G4_TXPOWER_OFDM_48M,
	EFUSE_2G4_TXPOWER_OFDM_54M,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M0,
	EFUSE_2G4_TXPOWER_HT40_M32,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M1M2,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M3M4,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M5,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M6,
	EFUSE_2G4_TXPOWER_HT20_VHT20_M7,
	EFUSE_2G4_TXPOWER_VHT20_M8,
	EFUSE_2G4_TXPOWER_VHT20_M9,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M0,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M1M2,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M3M4,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M5,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M6,
	EFUSE_2G4_TXPOWER_HT40_VHT40_M7,
	EFUSE_2G4_TXPOWER_VHT40_M8,
	EFUSE_2G4_TXPOWER_VHT40_M9,
	EFUSE_2G4_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_2G4_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_2G4_RATE_POWER_ITEM, *P_EFUSE_2G4_RATE_POWER_ITEM;

/** 5G Rate Power Item List */
typedef enum _EFUSE_5G_RATE_POWER_ITEM {
	EFUSE_5G_TXPOWER_OFDM_6M9M = 0,
	EFUSE_5G_TXPOWER_OFDM_12M18M,
	EFUSE_5G_TXPOWER_OFDM_24M36M,
	EFUSE_5G_TXPOWER_OFDM_48M,
	EFUSE_5G_TXPOWER_OFDM_54M,
	EFUSE_5G_TXPOWER_HT20_VHT20_M0,
	EFUSE_5G_TXPOWER_HT40_M32,
	EFUSE_5G_TXPOWER_HT20_VHT20_M1M2,
	EFUSE_5G_TXPOWER_HT20_VHT20_M3M4,
	EFUSE_5G_TXPOWER_HT20_VHT20_M5,
	EFUSE_5G_TXPOWER_HT20_VHT20_M6,
	EFUSE_5G_TXPOWER_HT20_VHT20_M7,
	EFUSE_5G_TXPOWER_VHT20_M8,
	EFUSE_5G_TXPOWER_VHT20_M9,
	EFUSE_5G_TXPOWER_HT40_VHT40_M0,
	EFUSE_5G_TXPOWER_HT40_VHT40_M1M2,
	EFUSE_5G_TXPOWER_HT40_VHT40_M3M4,
	EFUSE_5G_TXPOWER_HT40_VHT40_M5,
	EFUSE_5G_TXPOWER_HT40_VHT40_M6,
	EFUSE_5G_TXPOWER_HT40_VHT40_M7,
	EFUSE_5G_TXPOWER_VHT40_M8,
	EFUSE_5G_TXPOWER_VHT40_M9,
	EFUSE_5G_TXPOWER_LGVHT40_BW_OFFSET,
	EFUSE_5G_TXPOWER_VHT80_M0,
	EFUSE_5G_TXPOWER_VHT80_M1M2,
	EFUSE_5G_TXPOWER_VHT80_M3M4,
	EFUSE_5G_TXPOWER_VHT80_M5,
	EFUSE_5G_TXPOWER_VHT80_M6,
	EFUSE_5G_TXPOWER_VHT80_M7,
	EFUSE_5G_TXPOWER_VHT80_M8,
	EFUSE_5G_TXPOWER_VHT80_M9,
	EFUSE_5G_TXPOWER_LGVHT80_BW_OFFSET,
	EFUSE_5G_TXPOWER_BW5M_OFFSET,
	EFUSE_5G_TXPOWER_BW10M_OFFSET,
	EFUSE_5G_TXPOWER_RATE_POWER_ITEM_NUM
} EFUSE_5G_RATE_POWER_ITEM, *P_EFUSE_5G_RATE_POWER_ITEM;
#endif /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1) */
#endif /* !(CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE) */
#endif /* !(CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE) */

/** Common Module Item Category */
typedef enum _ENUM_EFUSE_COMMON_CATOGORY {
	EFUSE_COMMON_CATEGORY_TEMP_TSSI = 0,
	EFUSE_COMMON_CATEGORY_DYNAMIC_IPA_SWITCH,
	EFUSE_COMMON_CATEGORY_ELNA,
	EFUSE_COMMON_CATEGORY_THERMO_COMP,
	EFUSE_COMMON_CATEGORY_EPA_DPD,
	EFUSE_COMMON_CATOGORY_NUM
} ENUM_EFUSE_COMMON_CATOGORY, *P_ENUM_EFUSE_COMMON_CATOGORY;

/** Common TempTssi Item List */
typedef enum _EFUSE_COMMON_TEMP_TSSI_ITEM {
	EFUSE_COMMON_TEMP_TSSI_CATEGORY_TSSI_PA_CELL_OFFSET_HPA = 0,
	EFUSE_COMMON_TEMP_TSSI_CATEGORY_TSSI_PA_CELL_OFFSET_MPA,
	EFUSE_COMMON_TEMP_TSSI_CATEGORY_ITEM_NUM
} EFUSE_COMMON_TEMP_TSSI_ITEM, *P_EFUSE_COMMON_TEMP_TSSI_ITEM;

/** Common Dynamic iPA switch Item List */
typedef enum _EFUSE_COMMON_DYNAMIC_IPA_SWITCH_ITEM {
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_FPA_CCK_THRESHOLD = 0,  /* group FPA */
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_FPA_LOW_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_FPA_MID_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_FPA_HIGH_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_HPA_CCK_THRESHOLD,  /* group HPA */
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_HPA_LOW_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_HPA_MID_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_HPA_HIGH_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_MPA_CCK_THRESHOLD,  /* group MPA */
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_MPA_LOW_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_MPA_MID_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_MPA_HIGH_RATE_TRHESHOLD,
	EFUSE_COMMON_DYNAMIC_IPA_SWITCH_CATEGORY_ITEM_NUM
} EFUSE_COMMON_DYNAMIC_IPA_SWITCHI_ITEM, *P_EFUSE_COMMON_DYNAMIC_IPA_SWITCH_ITEM;

/** 2G Common eLNA Item List */
typedef enum _EFUSE_2G4_COMMON_ELNA_ITEM {
	EFUSE_2G4_COMMON_ELNA_CATEGORY_RECEIVED_MODE_GAIN = 0,
	EFUSE_2G4_COMMON_ELNA_CATEGORY_RECEIVED_MODE_P1DB,
	EFUSE_2G4_COMMON_ELNA_CATEGORY_BYPASS_MODE_GAIN,
	EFUSE_2G4_COMMON_ELNA_CATEGORY_BYPASS_MODE_P1DB,
	EFUSE_2G4_COMMON_ELNA_CATEGORY_ITEM_NUM
} EFUSE_2G4_COMMON_ELNA_ITEM, *P_EFUSE_2G4_COMMON_ELNA_ITEM;

/** 5G Common eLNA Item List */
typedef enum _EFUSE_5G_COMMON_ELNA_ITEM {
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_GAIN_GROUP_0 = 0,  /* group 0 */
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_NF_GROUP_0,
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_P1DB_GROUP_0,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_GAIN_GROUP_0,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_NF_GROUP_0,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_P1DB_GROUP_0,
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_GAIN_GROUP_1,  /* group 1 */
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_NF_GROUP_1,
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_P1DB_GROUP_1,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_GAIN_GROUP_1,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_NF_GROUP_1,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_P1DB_GROUP_1,
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_GAIN_GROUP_2,  /* group 2 */
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_NF_GROUP_2,
	EFUSE_5G_COMMON_ELNA_CATEGORY_RECEIVED_MODE_P1DB_GROUP_2,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_GAIN_GROUP_2,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_NF_GROUP_2,
	EFUSE_5G_COMMON_ELNA_CATEGORY_BYPASS_MODE_P1DB_GROUP_2,
	EFUSE_5G_COMMON_ELNA_CATEGORY_ITEM_NUM
} EFUSE_5G_COMMON_TEMP_TSSI_ITEM, *P_EFUSE_5G_COMMON_TEMP_TSSI_ITEM;

/** Common Dynamic Thermo Compensation Item List */
typedef enum _EFUSE_COMMON_THERMO_COMP_ITEM {
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N7 = 0,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N6,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N5,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N4,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N3,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N2,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N1,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_N0,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_REF_STEP,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_REF_TEMP,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P1,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P2,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P3,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P4,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P5,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P6,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_STEP_P7,
	EFUSE_COMMON_THERMO_COMP_CATEGORY_ITEM_NUM
} EFUSE_COMMON_THERMO_COMP_ITEM, *P_EFUSE_COMMON_THERMO_COMP_ITEM;

/** Common Dynamic ePA DPD Item List */
typedef enum _EFUSE_COMMON_EPA_DPD_ITEM {
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_LOWER_BOUND_GROUP_NT = 0,  /* group NT */
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_UPPER_BOUND_GROUP_NT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_0_GROUP_NT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_1_GROUP_NT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_LOWER_BOUND_GROUP_LT,  /* group LT */
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_UPPER_BOUND_GROUP_LT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_0_GROUP_LT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_1_GROUP_LT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_LOWER_BOUND_GROUP_HT,  /* group HT */
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_ON_UPPER_BOUND_GROUP_HT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_0_GROUP_HT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_DPD_PROTECTION_1_GROUP_HT,
	EFUSE_COMMON_EPA_DPD_CATEGORY_ITEM_NUM
} EFUSE_COMMON_EPA_DPD_ITEM, *P_EFUSE_COMMON_EPA_DPD_ITEM;

/** 2G Common Item List (all) */
typedef enum _EFUSE_2G4_COMMON_ITEM {
	EFUSE_2G4_COMMON_TSSI_PA_CELL_OFFSET_HPA = 0,
	EFUSE_2G4_COMMON_TSSI_PA_CELL_OFFSET_MPA,
	EFUSE_2G4_COMMON_FPA_CCK_THRESHOLD,
	EFUSE_2G4_COMMON_FPA_LOW_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_FPA_MID_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_FPA_HIGH_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_HPA_CCK_THRESHOLD,
	EFUSE_2G4_COMMON_HPA_LOW_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_HPA_MID_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_HPA_HIGH_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_MPA_CCK_THRESHOLD,
	EFUSE_2G4_COMMON_MPA_LOW_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_MPA_MID_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_MPA_HIGH_RATE_TRHESHOLD,
	EFUSE_2G4_COMMON_ELNA_RECEIVED_MODE_GAIN,
	EFUSE_2G4_COMMON_ELNA_RECEIVED_MODE_P1DB,
	EFUSE_2G4_COMMON_ELNA_BYPASS_MODE_GAIN,
	EFUSE_2G4_COMMON_ELNA_BYPASS_MODE_P1DB,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N7,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N6,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N5,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N4,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N3,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N2,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N1,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_N0,
	EFUSE_2G4_COMMON_THERMO_COMP_REF_STEP,
	EFUSE_2G4_COMMON_THERMO_COMP_REF_TEMP,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P1,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P2,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P3,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P4,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P5,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P6,
	EFUSE_2G4_COMMON_THERMO_COMP_STEP_P7,
	EFUSE_2G4_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_NT,
	EFUSE_2G4_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_NT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_0_GROUP_NT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_1_GROUP_NT,
	EFUSE_2G4_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_LT,
	EFUSE_2G4_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_LT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_0_GROUP_LT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_1_GROUP_LT,
	EFUSE_2G4_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_HT,
	EFUSE_2G4_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_HT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_0_GROUP_HT,
	EFUSE_2G4_COMMON_EPA_DPD_PROTECTION_1_GROUP_HT,
	EFUSE_2G4_COMMON_ITEM_NUM
} EFUSE_2G4_COMMON_ITEM, *P_EFUSE_2G4_COMMON_ITEM;

/** 5G Common Item List (all) */
typedef enum _EFUSE_5G_COMMON_ITEM {
	EFUSE_5G_COMMON_TSSI_PA_CELL_OFFSET_HPA = 0,
	EFUSE_5G_COMMON_TSSI_PA_CELL_OFFSET_MPA,
	EFUSE_5G_COMMON_FPA_CCK_THRESHOLD,
	EFUSE_5G_COMMON_FPA_LOW_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_FPA_MID_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_FPA_HIGH_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_HPA_CCK_THRESHOLD,
	EFUSE_5G_COMMON_HPA_LOW_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_HPA_MID_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_HPA_HIGH_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_MA_CCK_THRESHOLD,
	EFUSE_5G_COMMON_MPA_LOW_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_MPA_MID_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_MPA_HIGH_RATE_TRHESHOLD,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_GAIN_GROUP_0,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_NF_GROUP_0,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_P1DB_GROUP_0,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_GAIN_GROUP_0,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_NF_GROUP_0,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_P1DB_GROUP_0,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_GAIN_GROUP_1,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_NF_GROUP_1,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_P1DB_GROUP_1,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_GAIN_GROUP_1,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_NF_GROUP_1,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_P1DB_GROUP_1,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_GAIN_GROUP_2,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_NF_GROUP_2,
	EFUSE_5G_COMMON_ELNA_RECEIVED_MODE_P1DB_GROUP_2,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_GAIN_GROUP_2,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_NF_GROUP_2,
	EFUSE_5G_COMMON_ELNA_BYPASS_MODE_P1DB_GROUP_2,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N7,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N6,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N5,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N4,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N3,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N2,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N1,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_N0,
	EFUSE_5G_COMMON_THERMO_COMP_REF_STEP,
	EFUSE_5G_COMMON_THERMO_COMP_REF_TEMP,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P1,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P2,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P3,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P4,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P5,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P6,
	EFUSE_5G_COMMON_THERMO_COMP_STEP_P7,
	EFUSE_5G_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_NT,
	EFUSE_5G_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_NT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_0_GROUP_NT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_1_GROUP_NT,
	EFUSE_5G_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_LT,
	EFUSE_5G_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_LT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_0_GROUP_LT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_1_GROUP_LT,
	EFUSE_5G_COMMON_EPA_DPD_ON_LOWER_BOUND_GROUP_HT,
	EFUSE_5G_COMMON_EPA_DPD_ON_UPPER_BOUND_GROUP_HT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_0_GROUP_HT,
	EFUSE_5G_COMMON_EPA_DPD_PROTECTION_1_GROUP_HT,
	EFUSE_5G_COMMON_ITEM_NUM
} EFUSE_5G_COMMON_ITEM, *P_EFUSE_5G_COMMON_ITEM;

/** WF Path Item Catogory */
typedef enum _ENUM_EFUSE_WF_PATH_CATOGORY {
	EFUSE_WF_PATH_CATEGORY_FE_LOSS = 0,
	EFUSE_WF_PATH_CATEGORY_TSSI,
	EFUSE_WF_PATH_CATEGORY_TX_PHY_POWER,
	EFUSE_WF_PATH_CATEGORY_TX_POWER_OFFSET,
	EFUSE_WF_PATH_CATEGORY_TX_DPD_G0_OFFSET,
	EFUSE_WF_PATH_CATEGORY_LNA_GAIN_CAL,
	EFUSE_WF_PATH_CATOGORY_NUM
} ENUM_EFUSE_WF_PATH_CATOGORY, *P_ENUM_EFUSE_WF_PATH_CATOGORY;

/** 2G WF Path FeLoss Item List */
typedef enum _EFUSE_2G4_WF_PATH_FE_LOSS_ITEM {
	EFUSE_2G4_WF_PATH_FE_LOSS_CATEGORY_FE_LOSS = 0,
	EFUSE_2G4_WF_PATH_FE_LOSS_CATEGORY_ITEM_NUM
} EFUSE_2G4_WF_PATH_FE_LOSS_ITEM, *P_EFUSE_2G4_WF_PATH_FE_LOSS_ITEM;

/** 5G WF Path FeLoss Item List */
typedef enum _EFUSE_5G_WF_PATH_FE_LOSS_ITEM {
	EFUSE_5G_WF_PATH_FE_LOSS_CATEGORY_FE_LOSS_GROUP_0 = 0,
	EFUSE_5G_WF_PATH_FE_LOSS_CATEGORY_FE_LOSS_GROUP_1,
	EFUSE_5G_WF_PATH_FE_LOSS_CATEGORY_FE_LOSS_GROUP_2,
	EFUSE_5G_WF_PATH_FE_LOSS_CATEGORY_ITEM_NUM
} EFUSE_5G_WF_PATH_FE_LOSS_ITEM, *P_EFUSE_5G_WF_PATH_FE_LOSS_ITEM;

/** 2G/5G WF Path Tssi Item List */
typedef enum _EFUSE_WF_PATH_TSSI_ITEM {
	EFUSE_WF_PATH_TSSI_CATEGORY_PA_TSSI_SLOPE = 0,
	EFUSE_WF_PATH_TSSI_CATEGORY_PA_TSSI_OFFSET,
	EFUSE_WF_PATH_TSSI_CATEGORY_TX_TARGET_POWER,
	EFUSE_WF_PATH_TSSI_CATEGORY_ITEM_NUM
} EFUSE_WF_PATH_TSSI_ITEM, *P_EFUSE_WF_PATH_TSSI_ITEM;

/** 2G/5G WF Path Phy Power Item List */
typedef enum _EFUSE_WF_PATH_PHY_POWER_ITEM {
	EFUSE_WF_PATH_PHY_POWER_CATEGORY_PHY_POWER = 0,
	EFUSE_WF_PATH_PHY_POWER_CATEGORY_ITEM_NUM
} EFUSE_WF_PATH_PHY_POWER_ITEM, *P_EFUSE_WF_PATH_PHY_POWER_ITEM;

/** 2G WF Path Channel Power Offset Item List */
typedef enum _EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_ITEM {
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CATEGORY_CHANNEL_LOW = 0,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CATEGORY_CHANNEL_MID,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CATEGORY_CHANNEL_HIGH,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CATEGORY_ITEM_NUM
} EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_ITEM, *P_EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_ITEM;

/** 5G WF Path Channel Power Offset Item List */
typedef enum _EFUSE_5G_WF_PATH_TX_POWER_OFFSET_ITEM {
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CATEGORY_CHANNEL_LOW = 0,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CATEGORY_CHANNEL_HIGH,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CATEGORY_ITEM_NUM
} EFUSE_5G_WF_PATH_TX_POWER_OFFSET_ITEM, *P_EFUSE_5G_WF_PATH_TX_POWER_OFFSET_ITEM;

/** 2G/5G WF Path DPD G0 Item List */
typedef enum _EFUSE_WF_PATH_DPD_G0_ITEM {
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_0 = 0,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_1,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_2,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_3,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_4,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_DPD_G0_OFFSET_5,
	EFUSE_WF_PATH_DPD_G0_CATEGORY_ITEM_NUM
} EFUSE_WF_PATH_DPD_G0_ITEM, *P_EFUSE_WF_PATH_DPD_G0_ITEM;

/** 2G/5G WF Path LNA Gain Item List */
typedef enum _EFUSE_WF_PATH_LNA_GAIN_ITEM {
	EFUSE_WF_PATH_LNA_GAIN_CATEGORY_LNA_GAIN_CAL_0 = 0,
	EFUSE_WF_PATH_LNA_GAIN_CATEGORY_LNA_GAIN_CAL_1,
	EFUSE_WF_PATH_LNA_GAIN_CATEGORY_ITEM_NUM
} EFUSE_WF_PATH_LNA_GAIN_ITEM, *P_EFUSE_WF_PATH_LNA_GAIN_ITEM;

/** 2G WF Path Item List (all) */
typedef enum _EFUSE_2G4_WF_PATH_ITEM {
	EFUSE_2G4_WF_PATH_FE_LOSS = 0,
	EFUSE_2G4_WF_PATH_PA_TSSI_SLOPE,
	EFUSE_2G4_WF_PATH_PA_TSSI_OFFSET,
	EFUSE_2G4_WF_PATH_TX_TARGET_POWER,
	EFUSE_2G4_WF_PATH_TX_PHY_POWER,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CHANNEL_MID,
	EFUSE_2G4_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_0,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_1,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_2,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_3,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_4,
	EFUSE_2G4_WF_PATH_DPD_G0_OFFSET_5,
	EFUSE_2G4_WF_PATH_LNA_GAIN_CAL_0,
	EFUSE_2G4_WF_PATH_LNA_GAIN_CAL_1,
	EFUSE_2G4_WF_PATH_ITEM_NUM
} EFUSE_2G4_WF_PATH_ITEM, *P_EFUSE_2G4_WF_PATH_ITEM;

/** 5G WF Path Item List (all) */
typedef enum _EFUSE_5G_WF_PATH_ITEM {
	EFUSE_5G_WF_PATH_FE_LOSS_GROUP_0 = 0,
	EFUSE_5G_WF_PATH_FE_LOSS_GROUP_1,
	EFUSE_5G_WF_PATH_FE_LOSS_GROUP_2,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_0,   /* TSSI GROUP_0 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_0,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_0,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_1,   /* TSSI GROUP_1 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_1,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_1,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_2,   /* TSSI GROUP_2 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_2,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_2,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_3,   /* TSSI GROUP_3 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_3,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_3,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_4,   /* TSSI GROUP_4 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_4,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_4,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_5,   /* TSSI GROUP_5 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_5,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_5,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_6,   /* TSSI GROUP_6 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_6,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_6,
	EFUSE_5G_WF_PATH_PA_TSSI_SLOPE_GROUP_7,   /* TSSI GROUP_7 */
	EFUSE_5G_WF_PATH_PA_TSSI_OFFSET_GROUP_7,
	EFUSE_5G_WF_PATH_TX_TARGET_POWER_GROUP_7,
	EFUSE_5G_WF_PATH_TX_PHY_POWER,            /* Physical Power */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_0,   /* TX GROUP_0 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_0,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_1,   /* TX GROUP_1 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_1,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_2,   /* TX GROUP_2 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_2,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_3,   /* TX GROUP_3 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_3,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_4,   /* TX GROUP_4 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_4,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_5,   /* TX GROUP_5 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_5,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_6,   /* TX GROUP_6 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_6,
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_LOW_GROUP_7,   /* TX GROUP_7 */
	EFUSE_5G_WF_PATH_TX_POWER_OFFSET_CHANNEL_HIGH_GROUP_7,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_0,   /* DPD G0 GROUP_0 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_0,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_0,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_0,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_0,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_0,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_1,   /* DPD G0 GROUP_1 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_1,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_1,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_1,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_1,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_1,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_2,   /* DPD G0 GROUP_2 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_2,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_2,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_2,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_2,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_2,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_3,   /* DPD G0 GROUP_3 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_3,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_3,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_3,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_3,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_3,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_4,   /* DPD G0 GROUP_4 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_4,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_4,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_4,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_4,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_4,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_5,   /* DPD G0 GROUP_5 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_5,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_5,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_5,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_5,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_5,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_6,   /* DPD G0 GROUP_6 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_6,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_6,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_6,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_6,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_6,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_0_GROUP_7,   /* DPD G0 GROUP_7 */
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_1_GROUP_7,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_2_GROUP_7,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_3_GROUP_7,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_4_GROUP_7,
	EFUSE_5G_WF_PATH_DPD_G0_OFFSET_5_GROUP_7,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_0,   /* LNA GAIN CAL GROUP_0 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_0,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_1,   /* LNA GAIN CAL GROUP_1 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_1,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_2,   /* LNA GAIN CAL GROUP_2 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_2,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_3,   /* LNA GAIN CAL GROUP_3 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_3,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_4,   /* LNA GAIN CAL GROUP_4 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_4,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_5,   /* LNA GAIN CAL GROUP_5 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_5,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_6,   /* LNA GAIN CAL GROUP_6 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_6,
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_0_GROUP_7,   /* LNA GAIN CAL GROUP_7 */
	EFUSE_5G_WF_PATH_LNA_GAIN_CAL_1_GROUP_7,
	EFUSE_5G_WF_PATH_ITEM_NUM
} EFUSE_5G_WF_PATH_ITEM, *P_EFUSE_5G_WF_PATH_ITEM;

#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE)

/** element structure (TX_POWER_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
#else
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
#endif
	UINT8 u1Reserved[6];
} EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T, *P_EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_TX_POWER_T {
	UINT8 u1TxPowerCCK1M2M;
	UINT8 u1TxPowerCCK5M11M;

	UINT8 u1TxPowerOFDM6M9M;
	UINT8 u1TxPowerOFDM12M18M;
	UINT8 u1TxPowerOFDM24M36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20VHT20M0;
	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerHT20VHT20M1M2;
	UINT8 u1TxPowerHT20VHT20M3M4;
	UINT8 u1TxPowerHT20VHT20M5;
	UINT8 u1TxPowerHT20VHT20M6;
	UINT8 u1TxPowerHT20VHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;
	UINT8 u1TxPowerHT40M0;
	UINT8 u1TxPowerHT40M1M2;
	UINT8 u1TxPowerHT40M3M4;
	UINT8 u1TxPowerHT40M5;
	UINT8 u1TxPowerHT40M6;
	UINT8 u1TxPowerHT40M7;

	UINT8 u1TxPowerBwOffsetVHT40;
	UINT8 u1TxPowerBwOffsetLGVHT40;
} EFUSE_INFO_ELEMENT_2G4_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_2G4_TX_POWER_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_TX_POWER_T {
	UINT8 u1TxPowerOFDM6M9M;
	UINT8 u1TxPowerOFDM12M18M;
	UINT8 u1TxPowerOFDM24M36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20VHT20M0;
	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerHT20VHT20M1M2;
	UINT8 u1TxPowerHT20VHT20M3M4;
	UINT8 u1TxPowerHT20VHT20M5;
	UINT8 u1TxPowerHT20VHT20M6;
	UINT8 u1TxPowerHT20VHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;
	UINT8 u1TxPowerHT40M0;
	UINT8 u1TxPowerHT40M1M2;
	UINT8 u1TxPowerHT40M3M4;
	UINT8 u1TxPowerHT40M5;
	UINT8 u1TxPowerHT40M6;
	UINT8 u1TxPowerHT40M7;

	UINT8 u1TxPowerBwOffsetVHT40;
	UINT8 u1TxPowerBwOffsetLGVHT40;
	UINT8 u1TxPowerBwOffsetVHT80;
	UINT8 u1TxPowerBwOffsetVHT160C;
	UINT8 u1TxPowerBwOffsetVHT160NC;
	UINT8 u1TxPowerBwOffsetLGVHT80;
	UINT8 u1TxPowerBwOffsetLGVHT160;

	UINT8 u1TxPowerBwOffset5M;
	UINT8 u1TxPowerBwOffset10M;
} EFUSE_INFO_ELEMENT_5G_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_5G_TX_POWER_T;

typedef struct _EFUSE_INFO_MODULE_TX_POWER_T {
	EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T rNTxPowerOffset;
	EFUSE_INFO_ELEMENT_2G4_TX_POWER_T r2G4TxPower;
	EFUSE_INFO_ELEMENT_5G_TX_POWER_T r5GTxPower;
} EFUSE_INFO_MODULE_TX_POWER_T, *P_EFUSE_INFO_MODULE_TX_POWER_T;

#else /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE) */
#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE)
/** element structure (TX_POWER_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
#else
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
#endif
	UINT8 u1Reserved[5];
} EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T, *P_EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_TX_POWER_T {
	UINT8 u1TxPowerCCK1M;
	UINT8 u1TxPowerCCK2M;
	UINT8 u1TxPowerCCK5M;
	UINT8 u1TxPowerCCK11M;

	UINT8 u1TxPowerOFDM6M;
	UINT8 u1TxPowerOFDM9M;
	UINT8 u1TxPowerOFDM12M;
	UINT8 u1TxPowerOFDM18M;
	UINT8 u1TxPowerOFDM24M;
	UINT8 u1TxPowerOFDM36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20M0;
	UINT8 u1TxPowerHT20M1;
	UINT8 u1TxPowerHT20M2;
	UINT8 u1TxPowerHT20M3;
	UINT8 u1TxPowerHT20M4;
	UINT8 u1TxPowerHT20M5;
	UINT8 u1TxPowerHT20M6;
	UINT8 u1TxPowerHT20M7;

	UINT8 u1TxPowerHT40M0;
	UINT8 u1TxPowerHT40M1;
	UINT8 u1TxPowerHT40M2;
	UINT8 u1TxPowerHT40M3;
	UINT8 u1TxPowerHT40M4;
	UINT8 u1TxPowerHT40M5;
	UINT8 u1TxPowerHT40M6;
	UINT8 u1TxPowerHT40M7;

	UINT8 u1TxPowerVHT20M0;
	UINT8 u1TxPowerVHT20M1;
	UINT8 u1TxPowerVHT20M2;
	UINT8 u1TxPowerVHT20M3;
	UINT8 u1TxPowerVHT20M4;
	UINT8 u1TxPowerVHT20M5;
	UINT8 u1TxPowerVHT20M6;
	UINT8 u1TxPowerVHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;

	UINT8 u1TxPowerVHT40M0;
	UINT8 u1TxPowerVHT40M1;
	UINT8 u1TxPowerVHT40M2;
	UINT8 u1TxPowerVHT40M3;
	UINT8 u1TxPowerVHT40M4;
	UINT8 u1TxPowerVHT40M5;
	UINT8 u1TxPowerVHT40M6;
	UINT8 u1TxPowerVHT40M7;
	UINT8 u1TxPowerVHT40M8;
	UINT8 u1TxPowerVHT40M9;

	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerBwOffsetLGVHT40;
} EFUSE_INFO_ELEMENT_2G4_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_2G4_TX_POWER_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_TX_POWER_T {
	UINT8 u1TxPowerOFDM6M;
	UINT8 u1TxPowerOFDM9M;
	UINT8 u1TxPowerOFDM12M;
	UINT8 u1TxPowerOFDM18M;
	UINT8 u1TxPowerOFDM24M;
	UINT8 u1TxPowerOFDM36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20M0;
	UINT8 u1TxPowerHT20M1;
	UINT8 u1TxPowerHT20M2;
	UINT8 u1TxPowerHT20M3;
	UINT8 u1TxPowerHT20M4;
	UINT8 u1TxPowerHT20M5;
	UINT8 u1TxPowerHT20M6;
	UINT8 u1TxPowerHT20M7;

	UINT8 u1TxPowerHT40M0;
	UINT8 u1TxPowerHT40M1;
	UINT8 u1TxPowerHT40M2;
	UINT8 u1TxPowerHT40M3;
	UINT8 u1TxPowerHT40M4;
	UINT8 u1TxPowerHT40M5;
	UINT8 u1TxPowerHT40M6;
	UINT8 u1TxPowerHT40M7;

	UINT8 u1TxPowerVHT20M0;
	UINT8 u1TxPowerVHT20M1;
	UINT8 u1TxPowerVHT20M2;
	UINT8 u1TxPowerVHT20M3;
	UINT8 u1TxPowerVHT20M4;
	UINT8 u1TxPowerVHT20M5;
	UINT8 u1TxPowerVHT20M6;
	UINT8 u1TxPowerVHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;

	UINT8 u1TxPowerVHT40M0;
	UINT8 u1TxPowerVHT40M1;
	UINT8 u1TxPowerVHT40M2;
	UINT8 u1TxPowerVHT40M3;
	UINT8 u1TxPowerVHT40M4;
	UINT8 u1TxPowerVHT40M5;
	UINT8 u1TxPowerVHT40M6;
	UINT8 u1TxPowerVHT40M7;
	UINT8 u1TxPowerVHT40M8;
	UINT8 u1TxPowerVHT40M9;

	UINT8 u1TxPowerVHT80M0;
	UINT8 u1TxPowerVHT80M1;
	UINT8 u1TxPowerVHT80M2;
	UINT8 u1TxPowerVHT80M3;
	UINT8 u1TxPowerVHT80M4;
	UINT8 u1TxPowerVHT80M5;
	UINT8 u1TxPowerVHT80M6;
	UINT8 u1TxPowerVHT80M7;
	UINT8 u1TxPowerVHT80M8;
	UINT8 u1TxPowerVHT80M9;

	UINT8 u1TxPowerVHT160M0;
	UINT8 u1TxPowerVHT160M1;
	UINT8 u1TxPowerVHT160M2;
	UINT8 u1TxPowerVHT160M3;
	UINT8 u1TxPowerVHT160M4;
	UINT8 u1TxPowerVHT160M5;
	UINT8 u1TxPowerVHT160M6;
	UINT8 u1TxPowerVHT160M7;
	UINT8 u1TxPowerVHT160M8;
	UINT8 u1TxPowerVHT160M9;

	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerBwOffsetLGVHT40;
	UINT8 u1TxPowerBwOffsetLGVHT80;
	UINT8 u1TxPowerBwOffsetLGVHT160;

	UINT8 u1TxPowerBwOffset5M;
	UINT8 u1TxPowerBwOffset10M;
} EFUSE_INFO_ELEMENT_5G_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_5G_TX_POWER_T;

typedef struct _EFUSE_INFO_MODULE_TX_POWER_T {
	EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T rNTxPowerOffset;
	EFUSE_INFO_ELEMENT_2G4_TX_POWER_T r2G4TxPower;
	EFUSE_INFO_ELEMENT_5G_TX_POWER_T r5GTxPower;
} EFUSE_INFO_MODULE_TX_POWER_T, *P_EFUSE_INFO_MODULE_TX_POWER_T;

#else /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE) */
#if (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1)
/** element structure (TX_POWER_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
#else
	UINT8 u12G4TxPowerOffset2T : 4;
	UINT8 u12G4TxPowerOffset3T : 4;
	UINT8 u12G4TxPowerOffset4T : 4;
	UINT8 u15GTxPowerOffset2T  : 4;
	UINT8 u15GTxPowerOffset3T  : 4;
	UINT8 u15GTxPowerOffset4T  : 4;
#endif
	UINT8 u1Reserved[6];
} EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T, *P_EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_TX_POWER_T {
	UINT8 u1TxPowerCCK1M2M;
	UINT8 u1TxPowerCCK5M11M;

	UINT8 u1TxPowerOFDM6M9M;
	UINT8 u1TxPowerOFDM12M18M;
	UINT8 u1TxPowerOFDM24M36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20VHT20M0;
	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerHT20VHT20M1M2;
	UINT8 u1TxPowerHT20VHT20M3M4;
	UINT8 u1TxPowerHT20VHT20M5;
	UINT8 u1TxPowerHT20VHT20M6;
	UINT8 u1TxPowerHT20VHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;
	UINT8 u1TxPowerHT40VHT40M0;
	UINT8 u1TxPowerHT40VHT40M1M2;
	UINT8 u1TxPowerHTc40VHT40M3M4;
	UINT8 u1TxPowerHT40VHT40M5;
	UINT8 u1TxPowerHT40VHT40M6;
	UINT8 u1TxPowerHT40VHT40M7;
	UINT8 u1TxPowerVHT40M8;
	UINT8 u1TxPowerVHT40M9;

	UINT8 u1TxPowerBwOffsetLGVHT40;
} EFUSE_INFO_ELEMENT_2G4_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_2G4_TX_POWER_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_TX_POWER_T {
	UINT8 u1TxPowerOFDM6M9M;
	UINT8 u1TxPowerOFDM12M18M;
	UINT8 u1TxPowerOFDM24M36M;
	UINT8 u1TxPowerOFDM48M;
	UINT8 u1TxPowerOFDM54M;

	UINT8 u1TxPowerHT20VHT20M0;
	UINT8 u1TxPowerHT40M32;
	UINT8 u1TxPowerHT20VHT20M1M2;
	UINT8 u1TxPowerHT20VHT20M3M4;
	UINT8 u1TxPowerHT20VHT20M5;
	UINT8 u1TxPowerHT20VHT20M6;
	UINT8 u1TxPowerHT20VHT20M7;
	UINT8 u1TxPowerVHT20M8;
	UINT8 u1TxPowerVHT20M9;
	UINT8 u1TxPowerHT40VHT40M0;
	UINT8 u1TxPowerHT40VHT40M1M2;
	UINT8 u1TxPowerHT40VHT40M3M4;
	UINT8 u1TxPowerHT40VHT40M5;
	UINT8 u1TxPowerHT40VHT40M6;
	UINT8 u1TxPowerHT40VHT40M7;
	UINT8 u1TxPowerVHT40M8;
	UINT8 u1TxPowerVHT40M9;
	UINT8 u1TxPowerBwOffsetLGVHT40;

	UINT8 u1TxPowerVHT80M0;
	UINT8 u1TxPowerVHT80M1M2;
	UINT8 u1TxPowerVHT80M3M4;
	UINT8 u1TxPowerVHT80M5;
	UINT8 u1TxPowerVHT80M6;
	UINT8 u1TxPowerVHT80M7;
	UINT8 u1TxPowerVHT80M8;
	UINT8 u1TxPowerVHT80M9;
	UINT8 u1TxPowerBwOffsetLGVHT80;

	UINT8 u1TxPowerBwOffset5M;
	UINT8 u1TxPowerBwOffset10M;
} EFUSE_INFO_ELEMENT_5G_TX_POWER_T, *P_EFUSE_INFO_ELEMENT_5G_TX_POWER_T;

typedef struct _EFUSE_INFO_MODULE_TX_POWER_T {
	EFUSE_INFO_ELEMENT_2G4_TX_POWER_T r2G4TxPower;
	EFUSE_INFO_ELEMENT_5G_TX_POWER_T r5GTxPower;
} EFUSE_INFO_MODULE_TX_POWER_T, *P_EFUSE_INFO_MODULE_TX_POWER_T;
#endif /* (CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_CUSTOMIZED_TYPE_1) */
#endif /* !(CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_EXTENDED_TYPE) */
#endif /* !(CONNAC_WIFI_TX_POWER_EFUSE_TYPE == EFUSE_INFO_TX_POWER_SIMPLE_TYPE) */

/** element structure (COMMON_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_TSSI_PA_CELL_OFFSET_T {
	UINT8  u1TssiPACellOffsetHPA;
	UINT8  u1TssiPACellOffsetMPA;
} EFUSE_INFO_ELEMENT_TSSI_PA_CELL_OFFSET_T, *P_EFUSE_INFO_ELEMENT_TSSI_PA_CELL_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_DYNAMIC_IPA_SWITCH_T {
	UINT8  u1PACckThreshold;;
	UINT8  u1PALowRateThreshold;
	UINT8  u1PAMidRateThreshold;
	UINT8  u1PAHighRateThreshold;
} EFUSE_INFO_ELEMENT_DYNAMIC_IPA_SWITCH_T, *P_EFUSE_INFO_ELEMENT_DYNAMIC_IPA_SWITCH_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_ELNA_PARAM_T {
	UINT8  u1ELNAReceivedModeGain;
	UINT8  u1ELNAReceivedModeP1dB;
	UINT8  u1ELNABypassModeGain;
	UINT8  u1ELNABypassdModeP1dB;
} EFUSE_INFO_ELEMENT_2G4_ELNA_PARAM_T, *P_EFUSE_INFO_ELEMENT_2G4_ELNA_PARAM_T;

typedef struct _EFUSE_INFO_ELEMENT_THERMO_COMP_T {
	UINT8  u1ThermoComp_N7;
	UINT8  u1ThermoComp_N6;
	UINT8  u1ThermoComp_N5;
	UINT8  u1ThermoComp_N4;
	UINT8  u1ThermoComp_N3;
	UINT8  u1ThermoComp_N2;
	UINT8  u1ThermoComp_N1;
	UINT8  u1ThermoComp_N0;
	UINT8  u1ThermoCompRefStep;
	UINT8  u1ThermoCompRefTemp;
	UINT8  u1ThermoComp_P1;
	UINT8  u1ThermoComp_P2;
	UINT8  u1ThermoComp_P3;
	UINT8  u1ThermoComp_P4;
	UINT8  u1ThermoComp_P5;
	UINT8  u1ThermoComp_P6;
	UINT8  u1ThermoComp_P7;
} EFUSE_INFO_ELEMENT_THERMO_COMP_T, *P_EFUSE_INFO_ELEMENT_THERMO_COMP_T;

typedef struct _EFUSE_INFO_ELEMENT_EPA_DPD_BOUND_T {
	UINT8  u1EPADpdOnLowerBound;
	UINT8  u1EPADpdOnUpperBound;
	UINT8  u1EPADpdProtection[2];
} EFUSE_INFO_ELEMENT_EPA_DPD_BOUND_T, *P_EFUSE_INFO_ELEMENT_EPA_DPD_BOUND_T;

/** element structure (WF_PATH_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_FE_LOSS_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u1RxFeLoss : 4;
	UINT8 u1TxFeLoss : 4;
#else
	UINT8 u1TxFeLoss : 4;
	UINT8 u1RxFeLoss : 4;
#endif


} EFUSE_INFO_ELEMENT_FE_LOSS_T, *P_EFUSE_INFO_ELEMENT_FE_LOSS_T;

typedef struct _EFUSE_INFO_ELEMENT_TSSI_T {
	UINT8 u1PATssiSlope;
	UINT8 u1PATssiOffset;
	UINT8 u1TxTargetPower;
} EFUSE_INFO_ELEMENT_TSSI_T, *P_EFUSE_INFO_ELEMENT_TSSI_T;

typedef struct _EFUSE_INFO_ELEMENT_TX_PHY_POWER_T {
	UINT8 u1TxPhyPower;
} EFUSE_INFO_ELEMENT_TX_PHY_POWER_T, *P_EFUSE_INFO_ELEMENT_TX_PHY_POWER_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_TX_POWER_OFFSET_T {
	UINT8 u1TxPowerOffsetLow;
	UINT8 u1TxPowerOffsetMid;
	UINT8 u1TxPowerOffsetHigh;
} EFUSE_INFO_ELEMENT_2G4_TX_POWER_OFFSET_T, *P_EFUSE_INFO_ELEMENT_2G4_TX_POWER_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_TX_DPD_G0_OFFSET_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u1TxDpdG0OffsetLowRate  : 4;
	UINT8 u1TxDpdG0OffsetHighRate : 4;
#else
	UINT8 u1TxDpdG0OffsetHighRate : 4;
	UINT8 u1TxDpdG0OffsetLowRate  : 4;
#endif
} EFUSE_INFO_ELEMENT_TX_DPD_G0_OFFSET_T, *P_EFUSE_INFO_ELEMENT_TX_DPD_G0_OFFSET_T;

typedef struct _EFUSE_INFO_ELEMENT_LNA_GAIN_CAL_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u1LNAGainCal_Diff_H_M  : 4;
	UINT8 u1LNAGainCal_Diff_UH_H : 4;
	UINT8 u1LNAGainCal_Diff_L_UL : 4;
	UINT8 u1LNAGainCal_Diff_M_L  : 4;
#else
	UINT8 u1LNAGainCal_Diff_UH_H : 4;
	UINT8 u1LNAGainCal_Diff_H_M  : 4;
	UINT8 u1LNAGainCal_Diff_M_L  : 4;
	UINT8 u1LNAGainCal_Diff_L_UL : 4;
#endif
} EFUSE_INFO_ELEMENT_LNA_GAIN_CAL_T, *P_EFUSE_INFO_ELEMENT_LNA_GAIN_CAL_T;

/** module structure */
typedef struct _EFUSE_INFO_MODULE_SYSTEM_T {
#ifdef RT_BIG_ENDIAN
	/* Byte 0 */
	UINT8	 u1BandSelectBand0	: 2; /* [7:6]: Band Select (if DBDC on, for Band0) */
	UINT8	 u1RxPath			: 3; /* [5:3]: Rx Path	*/
	UINT8	 u1TxPath			: 3; /* [2:0]: Tx Path	*/

	/* Byte 1 */
	UINT8	 u1BandSelectBand1	: 2; /* [7:6]: Band Select (if DBDC on, for Band1) */
	UINT8	 u1OfdmTxStream		: 3; /* [5:3]: OFDM TxStream */
	UINT8	 u1CckTxStream		: 3; /* [2:0]: CCK TxStream  */

	/* Byte 2 */
	UINT8	 u1TxSW_P_A			: 1; /* [7]: P Ploarity(A_BAND)  */
	UINT8	 u1TxSW_N_A			: 1; /* [6]: N Ploarity(A_BAND) */
	UINT8	 u1TxSW_P_G			: 1; /* [5]: P Ploarity(G_BAND)  */
	UINT8	 u1TxSW_N_G			: 1; /* [4]: N Ploarity(G_BAND) */
	UINT8	 u1DbdcForceMode	: 1; /* [3]: Dbdc Force-Mode*/
	UINT8	 u1RxStream			: 3; /* [2:0]: Rx Stream	*/

	/* Byte 3 */
	UINT8	 u1Dbdc1RxPath		: 2; /* [7:6]: DBDC1 Rx Path*/
	UINT8	 u1Dbdc1TxPath		: 2; /* [5:4]: DBDC1 Tx Path*/
	UINT8	 u1Dbdc0RxPath		: 2; /* [3:2]: DBDC0 Rx Path*/
	UINT8	 u1Dbdc0TxPath		: 2; /* [1:0]: DBDC0 Tx Path*/

	/* Byte 4 */
	UINT8	 u1DPDTable_A		: 1; /* [7]: DPD Table (A_BAND)*/
	UINT8	 u1DPDTable_G		: 1; /* [6]: DPD Table (G_BAND)*/
	UINT8	 u1EpaDPD_A			: 1; /* [5]: ePA DPD (A_BAND) */
	UINT8	 u1IpaDPD_A			: 1; /* [4]: iPA DPD (A_BAND)*/
	UINT8	 u1EpaDPD_G			: 1; /* [3]: ePA DPD (G_BAND)*/
	UINT8	 u1IpaDPD_G			: 1; /* [2]: iPA DPD (G_BAND)*/
	UINT8	 u1TxFiler_A		: 1; /* [1]: Tx Filter (A_BAND)*/
	UINT8	 u1TxFiler_G		: 1; /* [0]: Tx Filter (G_BAND) */

	/* Byte 5 */
	UINT8	 u1FixPaCell_A		: 2; /* [7:6]: Fix PA cell (A_BAND) */
	UINT8	 u1FixPaCell_G		: 2; /* [5:4]: Fix PA cell (G_BAND) */
	UINT8	 u1FixPa_A			: 1; /* [3]: Fix PA (A_BAND)	 */
	UINT8	 u1FixPa_G			: 1; /* [2]: Fix PA (G_BAND)	*/
	UINT8	 u1PaEn_A			: 1; /* [1]: PA Enable (A_BAND) */
	UINT8	 u1PaEn_G			: 1; /* [0]: PA Enable (G_BAND) */

	/* Byte 6 */
	UINT8	 u1RxDCOC_A			: 1; /* [7]: RxDCOC (A_BAND) */
	UINT8	 u1RxDCOC_G			: 1; /* [6]: RxDCOC (G_BAND)*/
	UINT8	 u1LnaPaSelect_A	: 2; /* [5:4]: LNA/PA select (A_BAND) */
	UINT8	 u1LnaPaSelect_G	: 2; /* [3:2]: LNA/PA select (G_BAND)*/
	UINT8	 u1LnaEn_A			: 1; /* [1]: LNA Enable (A_BAND) */
	UINT8	 u1LnaEn_G			: 1; /* [0]: LNA Enable (G_BAND) */

	/* Byte 7 */
	UINT8	 u1Reserved			: 1; /* [7]: Reserved */
	UINT8	 u1CoRx				: 1; /* [6]: CORX */
	UINT8	 u1TempCompSel_BAND1	: 1; /* [5]: Temperature compensation Select (DBDC Band1) */
	UINT8	 u1TssiSet_BAND1	: 1; /* [4]: Tssi Set (if DBDC on, for Band1)			 */
	UINT8	 u1TempCompSel_A	: 1; /* [3]: Temperature compensation Select (DBDC Band0) */
	UINT8	 u1TssiSet_A		: 1; /* [2]: Tssi Set (if DBDC on, for Band0)			 */
	UINT8	 u1TempCompSel_G	: 1; /* [1]: Temperature compensation Select (DBDC Band0) */
	UINT8	 u1TssiSet_G		: 1; /* [0]: Tssi Set (if DBDC on, for Band0)			 */

	/* Byte 8 */
	UINT8	 u1THADCAnalogPart	: 8; /* [7:0]: THADC Analog part */

	/* Byte 9 */
	UINT8	 u1THADCSlopPart	: 8; /* [7:0]: THADC Slop part	*/

	/* Byte 10 */
	UINT8	 u1THADCCalPart		: 8; /* [7:0]: THADC Calibration part */

	/* Byte 11 */
	UINT8	 u1ThermalCompOffset	: 8; /* [7:0]: Thermal Compensation offset*/

	/* Byte 12 */
	UINT8	 u1WF0RcalResult	: 8; /* [7:0]: WF0 Rcal Result*/

	/* Byte 13 */
	UINT8	 u1WF2RcalResult	: 8; /* [7:0]: WF2 Rcal Result*/

	/* Byte 14 */
	UINT8	 u1RFTxLcLoop		: 8; /* [7:0]: RF Tx LC Loop*/

	/* Byte 15 */
	UINT8	 u1RxAntDiversity_A : 2; /* [7:6]: Rx Antenna Diversity (A_BAND) */
	UINT8	 u1RxAntDiversity_G : 2; /* [5:4]: Rx Antenna Diversity (G_BAND)*/
	UINT8	 u1CoexIsolation	: 4; /* [3:0]: cOEX isolation*/

#else
	/* Byte 0 */
	UINT8	 u1TxPath			: 3; /* [2:0]: Tx Path	*/
	UINT8	 u1RxPath			: 3; /* [5:3]: Rx Path	*/
	UINT8	 u1BandSelectBand0	: 2; /* [7:6]: Band Select (if DBDC on, for Band0)*/

	/* Byte 1 */
	UINT8	 u1CckTxStream		: 3; /* [2:0]: CCK TxStream */
	UINT8	 u1OfdmTxStream 	: 3; /* [5:3]: OFDM TxStream */
	UINT8	 u1BandSelectBand1	: 2; /* [7:6]: Band Select (if DBDC on, for Band1)*/

	/* Byte 2 */
	UINT8	 u1RxStream			: 3; /* [2:0]: Rx Stream	*/
	UINT8	 u1DbdcForceMode	: 1; /* [3]: Dbdc Force-Mode*/
	UINT8	 u1TxSW_N_G			: 1; /* [4]: N Ploarity(G_BAND)  */
	UINT8	 u1TxSW_P_G			: 1; /* [5]: P Ploarity(G_BAND) */
	UINT8	 u1TxSW_N_A			: 1; /* [6]: N Ploarity(A_BAND) */
	UINT8	 u1TxSW_P_A			: 1; /* [7]: P Ploarity(A_BAND) */

	/* Byte 3 */
	UINT8	 u1Dbdc0TxPath		: 2; /* [1:0]: DBDC0 Tx Path*/
	UINT8	 u1Dbdc0RxPath		: 2; /* [3:2]: DBDC0 Rx Path */
	UINT8	 u1Dbdc1TxPath		: 2; /* [5:4]: DBDC1 Tx Path */
	UINT8	 u1Dbdc1RxPath		: 2; /* [7:6]: DBDC1 Rx Path */

	/* Byte 4 */
	UINT8	 u1TxFiler_G		: 1; /* [0]: Tx Filter (G_BAND)*/
	UINT8	 u1TxFiler_A		: 1; /* [1]: Tx Filter (A_BAND)*/
	UINT8	 u1IpaDPD_G			: 1; /* [2]: iPA DPD (G_BAND) */
	UINT8	 u1EpaDPD_G			: 1; /* [3]: ePA DPD (G_BAND) */
	UINT8	 u1IpaDPD_A			: 1; /* [4]: iPA DPD (A_BAND) */
	UINT8	 u1EpaDPD_A			: 1; /* [5]: ePA DPD (A_BAND) */
	UINT8	 u1DPDTable_G		: 1; /* [6]: DPD Table (G_BAND)*/
	UINT8	 u1DPDTable_A		: 1; /* [7]: DPD Table (A_BAND)*/

	/* Byte 5 */
	UINT8	 u1PaEn_G			: 1; /* [0]: PA Enable (G_BAND) */
	UINT8	 u1PaEn_A			: 1; /* [1]: PA Enable (A_BAND) */
	UINT8	 u1FixPa_G			: 1; /* [2]: Fix PA (G_BAND) */
	UINT8	 u1FixPa_A			: 1; /* [3]: Fix PA (A_BAND) */
	UINT8	 u1FixPaCell_G		: 2; /* [5:4]: Fix PA cell (G_BAND) */
	UINT8	 u1FixPaCell_A		: 2; /* [7:6]: Fix PA cell (A_BAND) */

	/* Byte 6 */
	UINT8	 u1LnaEn_G			: 1; /* [0]: LNA Enable (G_BAND) */
	UINT8	 u1LnaEn_A			: 1; /* [1]: LNA Enable (A_BAND)*/
	UINT8	 u1LnaPaSelect_G	: 2; /* [3:2]: LNA/PA select (G_BAND)*/
	UINT8	 u1LnaPaSelect_A	: 2; /* [5:4]: LNA/PA select (A_BAND) */
	UINT8	 u1RxDCOC_G			: 1; /* [6]: RxDCOC (G_BAND)*/
	UINT8	 u1RxDCOC_A			: 1; /* [7]: RxDCOC (A_BAND)*/

	/* Byte 7 */
	UINT8	 u1TssiSet_G		: 1; /* [0]: Tssi Set (if DBDC on, for Band0)*/
	UINT8	 u1TempCompSel_G	: 1; /* [1]: TC Select (DBDC Band0) */
	UINT8	 u1TssiSet_A		: 1; /* [2]: Tssi Set (if DBDC on, for Band0)*/
	UINT8	 u1TempCompSel_A	: 1; /* [3]: TC Select (DBDC Band0) */
	UINT8	 u1TssiSet_BAND1	: 1; /* [4]: Tssi Set (if DBDC on, for Band1)*/
	UINT8	 u1TempCompSel_BAND1	: 1; /* [5]: Tc Select (DBDC Band1) */
	UINT8	 u1CoRx				: 1; /* [6]: CORX */
	UINT8	 u1Reserved			: 1; /* [7]: Reserved */

	/* Byte 8 */
	UINT8	 u1THADCAnalogPart	: 8; /* [7:0]: THADC Analog part*/

	/* Byte 9 */
	UINT8	 u1THADCSlopPart	: 8; /* [7:0]: THADC Slop part */

	/* Byte 10 */
	UINT8	 u1THADCCalPart	: 8; /* [7:0]: THADC Calibration part */

	/* Byte 11 */
	UINT8	 u1ThermalCompOffset	: 8; /* [7:0]: Thermal Compensation offset	*/

	/* Byte 12 */
	UINT8	 u1WF0RcalResult	: 8; /* [7:0]: WF0 Rcal Result */

	/* Byte 13 */
	UINT8	 u1WF2RcalResult	: 8; /* [7:0]: WF2 Rcal Result */

	/* Byte 14 */
	UINT8	 u1RFTxLcLoop		: 8; /* [7:0]: RF Tx LC Loop*/

	/* Byte 15 */
	UINT8	 u1CoexIsolation	: 4; /* [3:0]: cOEX isolation*/
	UINT8	 u1RxAntDiversity_G	: 2; /* [5:4]: Rx Antenna Diversity (G_BAND)*/
	UINT8	 u1RxAntDiversity_A	: 2; /* [7:6]: Rx Antenna Diversity (A_BAND) */
#endif
} EFUSE_INFO_MODULE_SYSTEM_T, *P_EFUSE_INFO_MODULE_SYSTEM_T;

/** element structure (DELAY_COMP_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_T {
	UINT8 u1RxLatencyBw20[G_BAND_BW20_CH_NUM];
	UINT8 u1RxLatencyBw40[G_BAND_BW40_CH_NUM];
} EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_T, *P_EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_RX_LATENCY_T {
	UINT8 u1RxLatencyLowCh;
	UINT8 u1RxLatencyMidCh;
	UINT8 u1RxLatencyHighCh;
} EFUSE_INFO_ELEMENT_5G_RX_LATENCY_T, *P_EFUSE_INFO_ELEMENT_5G_RX_LATENCY_T;

typedef struct _EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_TMP_T {
#ifdef RT_BIG_ENDIAN
	UINT8 u111v2G4RxLatencyLtmpGroup1 : 4; /* [7:4] */
	UINT8 u111v2G4RxLatencyLtmpGroup0 : 4; /* [3:0] */
#else
	UINT8 u111v2G4RxLatencyLtmpGroup0 : 4; /* [3:0] */
	UINT8 u111v2G4RxLatencyLtmpGroup1 : 4; /* [7:4] */
#endif
} EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_TMP_T, *P_EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_TMP_T;

typedef struct _EFUSE_INFO_ELEMENT_DELAY_COMP_CTRL_T {
	EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_TMP_T u111v2G4RxLatencyLtmpBw20[G_BAND_LATENCY_CATOGORY_NUM];
	EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_TMP_T u111v2G4RxLatencyLtmpBw40[G_BAND_LATENCY_CATOGORY_NUM];
#ifdef RT_BIG_ENDIAN
	UINT8 u1Reserved			: 1; /* [  7] */
	UINT8 u111v5GValid			: 1; /* [  6] */
	UINT8 u111v2G4Bw40Valid		: 1; /* [  5] */
	UINT8 u111v2G4Bw20Valid		: 1; /* [  4] */
	UINT8 u111v5Gcal			: 2; /* [3:2] */
	UINT8 u111v2G4cal			: 2; /* [1:0] */

	UINT8 u111vTRxPath			: 4; /* [7:4] */
	UINT8 u111v2G4Bw40HighChValid	: 1; /* [  3] */
	UINT8 u111v2G4Bw40LowChValid	: 1; /* [  2] */
	UINT8 u111v2G4Bw20HighChValid	: 1; /* [  1] */
	UINT8 u111v2G4Bw20LowChValid	: 1; /* [  0] */
#else
	UINT8 u111v2G4cal			: 2; /* [1:0] */
	UINT8 u111v5Gcal			: 2; /* [3:2] */
	UINT8 u111v2G4Bw20Valid		: 1; /* [  4] */
	UINT8 u111v2G4Bw40Valid		: 1; /* [  5] */
	UINT8 u111v5GValid			: 1; /* [  6] */
	UINT8 u1Reserved			: 1; /* [  7] */

	UINT8 u111v2G4Bw20LowChValid	: 1; /* [  0] */
	UINT8 u111v2G4Bw20HighChValid	: 1; /* [  1] */
	UINT8 u111v2G4Bw40LowChValid	: 1; /* [  2] */
	UINT8 u111v2G4Bw40HighChValid	: 1; /* [  3] */
	UINT8 u111vTRxPath				: 4; /* [7:4] */

#endif
} EFUSE_INFO_ELEMENT_DELAY_COMP_CTRL_T, *P_EFUSE_INFO_ELEMENT_DELAY_COMP_CTRL_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_ELNA_PARAM_T {
	UINT8  u1ELNAReceivedModeGain;
	UINT8  u1ELNAReceivedModeNF;
	UINT8  u1ELNAReceivedModeP1dB;
	UINT8  u1ELNABypassModeGain;
	UINT8  u1ELNABypassModeNF;
	UINT8  u1ELNABypassdModeP1dB;
} EFUSE_INFO_ELEMENT_5G_ELNA_PARAM_T, *P_EFUSE_INFO_ELEMENT_5G_ELNA_PARAM_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_TX_POWER_OFFSET_T {
	UINT8 u1TxPowerOffsetLow;
	UINT8 u1TxPowerOffsetHigh;
} EFUSE_INFO_ELEMENT_5G_TX_POWER_OFFSET_T, *P_EFUSE_INFO_ELEMENT_5G_TX_POWER_OFFSET_T;

/** element structure (IBF_MODULE) */
typedef struct _EFUSE_INFO_ELEMENT_2G4_IBF_PARAM_T {
	UINT8 u1IBfParam[IBF_PARAM_NUM * G_BAND_CH_GROUP_NUM];
} EFUSE_INFO_ELEMENT_2G4_IBF_PARAM_T, *P_EFUSE_INFO_ELEMENT_2G4_IBF_PARAM_T;

typedef struct _EFUSE_INFO_ELEMENT_5G_IBF_PARAM_T {
	UINT8 u1IBfParam[IBF_PARAM_NUM * A_BAND_CH_GROUP_NUM];
} EFUSE_INFO_ELEMENT_5G_IBF_PARAM_T, *P_EFUSE_INFO_ELEMENT_5G_IBF_PARAM_T;

/*typedef struct _EFUSE_INFO_MODULE_TX_POWER_T {
	EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T rNTxPowerOffset;
	EFUSE_INFO_ELEMENT_2G4_TX_POWER_T r2G4TxPower;
	EFUSE_INFO_ELEMENT_5G_TX_POWER_T r5GTxPower;
} EFUSE_INFO_MODULE_TX_POWER_T, *P_EFUSE_INFO_MODULE_TX_POWER_T;*/

typedef struct _EFUSE_INFO_MODULE_2G4_COMMON_T {
	EFUSE_INFO_ELEMENT_TSSI_PA_CELL_OFFSET_T rTssiPACellOffset[G_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_DYNAMIC_IPA_SWITCH_T rDynamIPASwitch[IPA_SWITCH_TYPE_NUM];
	EFUSE_INFO_ELEMENT_2G4_ELNA_PARAM_T r2G4ELNAParam[G_BAND_LNA_CATOGORY_NUM];
	EFUSE_INFO_ELEMENT_THERMO_COMP_T rThermoComp;
	EFUSE_INFO_ELEMENT_EPA_DPD_BOUND_T rEPADpdBound[THERMO_TYPE_NUM];
	UCHAR u1Reserved;
} EFUSE_INFO_MODULE_2G4_COMMON_T, *P_EFUSE_INFO_MODULE_2G4_COMMON_T;

typedef struct _EFUSE_INFO_MODULE_2G4_WIFI_PATH_T {
	EFUSE_INFO_ELEMENT_FE_LOSS_T rFeLoss[G_BAND_LNA_CATOGORY_NUM];
	EFUSE_INFO_ELEMENT_TSSI_T rTssi[G_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_TX_PHY_POWER_T rTxPhyPower;
	EFUSE_INFO_ELEMENT_2G4_TX_POWER_OFFSET_T rTxPowerOffset[G_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_TX_DPD_G0_OFFSET_T rTxDpdG0Offset[G_BAND_DPD_GROUP_NUM];
	EFUSE_INFO_ELEMENT_LNA_GAIN_CAL_T rLNAGainCal[G_BAND_CH_GROUP_NUM];
} EFUSE_INFO_MODULE_2G4_WIFI_PATH_T, *P_EFUSE_INFO_MODULE_2G4_WIFI_PATH_T;

typedef struct _EFUSE_INFO_MODULE_DELAY_COMP_T {
	EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_T r2G4RxLatency;
	EFUSE_INFO_ELEMENT_5G_RX_LATENCY_T r5GRxLatency;
	EFUSE_INFO_ELEMENT_DELAY_COMP_CTRL_T rDelayCompCtrl;
} EFUSE_INFO_MODULE_DELAY_COMP_T, *P_EFUSE_INFO_MODULE_DELAY_COMP_T;

typedef struct _EFUSE_INFO_MODULE_5G_COMMON_T {
	EFUSE_INFO_ELEMENT_TSSI_PA_CELL_OFFSET_T rTssiPACellOffset[A_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_DYNAMIC_IPA_SWITCH_T rDynamIPASwitch[IPA_SWITCH_TYPE_NUM];
	EFUSE_INFO_ELEMENT_5G_ELNA_PARAM_T r5GELNAParam[A_BAND_LNA_CATOGORY_NUM];
	EFUSE_INFO_ELEMENT_THERMO_COMP_T rThermoComp;
	EFUSE_INFO_ELEMENT_EPA_DPD_BOUND_T rEPADpdBound[THERMO_TYPE_NUM];
	UINT8 u1Reserved[5];
} EFUSE_INFO_MODULE_5G_COMMON_T, *P_EFUSE_INFO_MODULE_5G_COMMON_T;

typedef struct _EFUSE_INFO_MODULE_5G_WIFI_PATH_T {
	EFUSE_INFO_ELEMENT_FE_LOSS_T rFeLoss[A_BAND_LNA_CATOGORY_NUM];
	EFUSE_INFO_ELEMENT_TSSI_T rTssi[A_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_TX_PHY_POWER_T rTxPhyPower;
	EFUSE_INFO_ELEMENT_5G_TX_POWER_OFFSET_T rTxPowerOffset[A_BAND_CH_GROUP_NUM];
	EFUSE_INFO_ELEMENT_TX_DPD_G0_OFFSET_T rTxDpdG0Offset[A_BAND_DPD_GROUP_NUM];
	EFUSE_INFO_ELEMENT_LNA_GAIN_CAL_T rLNAGainCal[A_BAND_CH_GROUP_NUM];
	UINT8 u1Reserved[4];
} EFUSE_INFO_MODULE_5G_WIFI_PATH_T, *P_EFUSE_INFO_MODULE_5G_WIFI_PATH_T;

typedef struct _EFUSE_INFO_MODULE_IBF_CAL_T {
	EFUSE_INFO_ELEMENT_2G4_IBF_PARAM_T r2G4IBfParam;
	EFUSE_INFO_ELEMENT_5G_IBF_PARAM_T r5GIBfParam;
} EFUSE_INFO_MODULE_IBF_CAL_T, *P_EFUSE_INFO_MODULE_IBF_CAL_T;

/** Efuse structure */
typedef struct _EFUSE_INFO_ALL_T {
	P_EFUSE_INFO_MODULE_SYSTEM_T prSys;
	P_EFUSE_INFO_ELEMENT_DELAY_COMP_CTRL_T prDelayCompCtrl;
	P_EFUSE_INFO_ELEMENT_NTX_POWER_OFFSET_T prNTxPowerOffset;

	/* 2G related */
	P_EFUSE_INFO_MODULE_2G4_COMMON_T pr2G4Cmm;
	P_EFUSE_INFO_ELEMENT_2G4_TX_POWER_T pr2G4TxPower;
	P_EFUSE_INFO_ELEMENT_2G4_RX_LATENCY_T pr2G4RxLatency;
	P_EFUSE_INFO_MODULE_2G4_WIFI_PATH_T pr2G4WFPath[MAX_ANTENNA_NUM];
	P_EFUSE_INFO_ELEMENT_2G4_IBF_PARAM_T pr2G4IBfParam;

	/* 5G related */
	P_EFUSE_INFO_MODULE_5G_COMMON_T pr5GCmm;
	P_EFUSE_INFO_ELEMENT_5G_TX_POWER_T pr5GTxPower;
	P_EFUSE_INFO_ELEMENT_5G_RX_LATENCY_T pr5GRxLatency;
	P_EFUSE_INFO_MODULE_5G_WIFI_PATH_T pr5GWFPath[MAX_ANTENNA_NUM];
	P_EFUSE_INFO_ELEMENT_5G_IBF_PARAM_T pr5GIBfParam;
} EFUSE_INFO_ALL_T, *P_EFUSE_INFO_ALL_T;
#endif/*#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT*/
/*CONNAC based parameter define --- END*/

#define NIC_CONFIGURE_0 0x34
#define EXTERNAL_PA_MASK (0x3 << 8)
#define GET_PA_TYPE(p) (((p) & EXTERNAL_PA_MASK) >> 8)

#define NIC_CONFIGURE_1 0x36
#define INTERNAL_TX_ALC_EN (1 << 13)

#define XTAL_TRIM1 0x3A
#define XTAL_TRIM1_DIP_SELECTION (1 << 7)
#define XTAL_TRIM1_MASK (0x7F)

#define G_BAND_20_40_BW_PWR_DELTA 0x50
#define G_BAND_20_40_BW_PWR_DELTA_MASK (0x3f)
#define G_BAND_20_40_BW_PWR_DELTA_SIGN (1 << 6)
#define G_BAND_20_40_BW_PWR_DELTA_EN (1 << 7)
#define A_BAND_20_40_BW_PWR_DELTA_MASK (0x3f << 8)
#define A_BAND_20_40_BW_PWR_DELTA_SIGN (1 << 14)
#define A_BAND_20_40_BW_PWR_DELTA_EN (1 << 15)



#define A_BAND_20_80_BW_PWR_DELTA 0x52
#define A_BAND_20_80_BW_PWR_DELTA_MASK (0x3f)
#define A_BAND_20_80_BW_PWR_DELTA_SIGN (1 << 6)
#define A_BAND_20_80_BW_PWR_DELTA_EN (1 << 7)
#define G_BAND_EXT_PA_SETTING_MASK (0x7f << 8)
#define G_BAND_EXT_PA_SETTING_EN (1 << 15)

#define A_BAND_EXT_PA_SETTING 0x54
#define A_BAND_EXT_PA_SETTING_MASK (0x7f)
#define A_BAND_EXT_PA_SETTING_EN (1 << 7)
#define TEMP_SENSOR_CAL_MASK (0x7f << 8)
#define TEMP_SENSOR_CAL_EN (1 << 15)

#define TX0_G_BAND_TSSI_SLOPE 0x56
#define TX0_G_BAND_TSSI_SLOPE_MASK (0xff)
#define TX0_G_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define TX0_G_BAND_TARGET_PWR 0x58
#define TX0_G_BAND_TARGET_PWR_MASK (0xff)
#define TX0_G_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define TX0_G_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define TX0_G_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define TX0_G_BAND_CHL_PWR_DELTA_MID 0x5A
#define TX0_G_BAND_CHL_PWR_DELTA_MID_MASK (0x3f)
#define TX0_G_BAND_CHL_PWR_DELTA_MID_SIGN (1 << 6)
#define TX0_G_BAND_CHL_PWR_DELTA_MID_EN (1 << 7)
#define TX0_G_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define TX0_G_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define TX0_G_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define TX1_G_BAND_TSSI_SLOPE 0x5C
#define TX1_G_BAND_TSSI_SLOPE_MASK (0xff)
#define TX1_G_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define TX1_G_BAND_TARGET_PWR 0x5E
#define TX1_G_BAND_TARGET_PWR_MASK (0xff)
#define TX1_G_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define TX1_G_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define TX1_G_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define TX1_G_BAND_CHL_PWR_DELTA_MID 0x60
#define TX1_G_BAND_CHL_PWR_DELTA_MID_MASK (0x3f)
#define TX1_G_BAND_CHL_PWR_DELTA_MID_SIGN (1 << 6)
#define TX1_G_BAND_CHL_PWR_DELTA_MID_EN (1 << 7)
#define TX1_G_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define TX1_G_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define TX1_G_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP0_TX0_A_BAND_TSSI_SLOPE 0x62
#define GRP0_TX0_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP0_TX0_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP0_TX0_A_BAND_TARGET_PWR 0x64
#define GRP0_TX0_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_HI 0x66
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP0_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP1_TX0_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP1_TX0_A_BAND_TSSI_OFFSET 0x68
#define GRP1_TX0_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP1_TX0_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_LOW 0x6A
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP1_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP2_TX0_A_BAND_TSSI_SLOPE 0x6C
#define GRP2_TX0_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP2_TX0_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP2_TX0_A_BAND_TARGET_PWR 0x6E
#define GRP2_TX0_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_HI 0x70
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP2_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP3_TX0_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP3_TX0_A_BAND_TSSI_OFFSET 0x72
#define GRP3_TX0_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP3_TX0_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_LOW 0x74
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP3_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP4_TX0_A_BAND_TSSI_SLOPE 0x76
#define GRP4_TX0_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP4_TX0_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP4_TX0_A_BAND_TARGET_PWR 0x78
#define GRP4_TX0_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_HI 0x7A
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP4_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP5_TX0_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP5_TX0_A_BAND_TSSI_OFFSET 0x7C
#define GRP5_TX0_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP5_TX0_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_LOW 0X7E
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP5_TX0_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP0_TX1_A_BAND_TSSI_SLOPE 0x80
#define GRP0_TX1_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP0_TX1_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP0_TX1_A_BAND_TARGET_PWR 0x82
#define GRP0_TX1_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_HI 0x84
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP0_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP1_TX1_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP1_TX1_A_BAND_TSSI_OFFSET 0x86
#define GRP1_TX1_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP1_TX1_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_LOW 0x88
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP1_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP2_TX1_A_BAND_TSSI_SLOPE 0x8A
#define GRP2_TX1_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP2_TX1_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP2_TX1_A_BAND_TARGET_PWR 0x8C
#define GRP2_TX1_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_HI 0x8E
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP2_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP3_TX1_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP3_TX1_A_BAND_TSSI_OFFSET 0x90
#define GRP3_TX1_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP3_TX1_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_LOW 0x92
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP3_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define GRP4_TX1_A_BAND_TSSI_SLOPE 0x94
#define GRP4_TX1_A_BAND_TSSI_SLOPE_MASK (0xff)
#define GRP4_TX1_A_BAND_TSSI_OFFSET_MASK (0xff << 8)

#define GRP4_TX1_A_BAND_TARGET_PWR 0x96
#define GRP4_TX1_A_BAND_TARGET_PWR_MASK (0xff)
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f << 8)
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 14)
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 15)

#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_HI 0x98
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f)
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 6)
#define GRP4_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 7)
#define GRP5_TX1_A_BAND_TSSI_SLOPE_MASK (0xff << 8)

#define GRP5_TX1_A_BAND_TSSI_OFFSET 0x9A
#define GRP5_TX1_A_BAND_TSSI_OFFSET_MASK (0xff)
#define GRP5_TX1_A_BAND_TARGET_PWR_MASK (0xff << 8)

#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_LOW 0x9C
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_LOW_MASK (0x3f)
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_LOW_SIGN (1 << 6)
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_LOW_EN (1 << 7)
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_HI_MASK (0x3f << 8)
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_HI_SIGN (1 << 14)
#define GRP5_TX1_A_BAND_CHL_PWR_DELTA_HI_EN (1 << 15)

#define G_BAND_BANDEDGE_PWR_BACK_OFF 0x9E
#define G_BAND_BANDEDGE_PWR_BACK_OFF_MASK (0x7f)
#define G_BAND_BANDEDGE_PWR_BACK_OFF_EN (1 << 7)
#define XTAL_TRIM2_MASK (0x7f << 8)
#define XTAL_TRIM2_DIP_SELECTION (1 << 15)

#define TX_PWR_CCK_1_2M 0xA0
#define TX_PWR_CCK_1_2M_MASK (0x3f)
#define TX_PWR_CCK_1_2M_SIGN (1 << 6)
#define TX_PWR_CCK_1_2M_EN (1 << 7)
#define TX_PWR_CCK_5_11M_MASK (0x3f << 8)
#define TX_PWR_CCK_5_11M_SIGN (1 << 14)
#define TX_PWR_CCK_5_11M_EN (1 << 15)

#define TX_PWR_G_BAND_OFDM_6_9M 0xA2
#define TX_PWR_G_BAND_OFDM_6_9M_MASK (0x3f)
#define TX_PWR_G_BAND_OFDM_6_9M_SIGN (1 << 6)
#define TX_PWR_G_BAND_OFDM_6_9M_EN (1 << 7)
#define TX_PWR_G_BAND_OFDM_12_18M_MASK (0x3f << 8)
#define TX_PWR_G_BAND_OFDM_12_18M_SIGN (1 << 14)
#define TX_PWR_G_BAND_OFDM_12_18M_EN (1 << 15)

#define TX_PWR_G_BAND_OFDM_24_36M 0xA4
#define TX_PWR_G_BAND_OFDM_24_36M_MASK (0x3f)
#define TX_PWR_G_BAND_OFDM_24_36M_SIGN (1 << 6)
#define TX_PWR_G_BAND_OFDM_24_36M_EN (1 << 7)
#define TX_PWR_G_BAND_OFDM_48_54M_MASK (0x3f << 8)
#define TX_PWR_G_BAND_OFDM_48_54M_SIGN (1 << 14)
#define TX_PWR_G_BAND_OFDM_48_54M_EN (1 << 15)

#define TX_PWR_HT_MCS_0_1 0xA6
#define TX_PWR_HT_MCS_0_1_MASK (0x3f)
#define TX_PWR_HT_MCS_0_1_SIGN (1 << 6)
#define TX_PWR_HT_MCS_0_1_EN (1 << 7)
#define TX_PWR_HT_MCS_2_3_MASK (0x3f << 8)
#define TX_PWR_HT_MCS_2_3_SIGN (1 << 14)
#define TX_PWR_HT_MCS_2_3_EN (1 << 15)

#define TX_PWR_HT_MCS_4_5 0xA8
#define TX_PWR_HT_MCS_4_5_MASK (0x3f)
#define TX_PWR_HT_MCS_4_5_SIGN (1 << 6)
#define TX_PWR_HT_MCS_4_5_EN (1 << 7)
#define TX_PWR_HT_MCS_6_7_MASK (0x3f << 8)
#define TX_PWR_HT_MCS_6_7_SIGN (1 << 14)
#define TX_PWR_HT_MCS_6_7_EN (1 << 15)

#define TX_PWR_HT_MCS_8_9 0xAA
#define TX_PWR_HT_MCS_8_9_MASK (0x3f)
#define TX_PWR_HT_MCS_8_9_SIGN (1 << 6)
#define TX_PWR_HT_MCS_8_9_EN (1 << 7)
#define TX_PWR_HT_MCS_10_11_MASK (0x3f << 8)
#define TX_PWR_HT_MCS_10_11_SIGN (1 << 14)
#define TX_PWR_HT_MCS_10_11_EN (1 << 15)

#define TX_PWR_HT_MCS_12_13 0xAC
#define TX_PWR_HT_MCS_12_13_MASK (0x3f)
#define TX_PWR_HT_MCS_12_13_SIGN (1 << 6)
#define TX_PWR_HT_MCS_12_13_EN (1 << 7)
#define TX_PWR_HT_MCS_14_15_MASK (0x3f << 8)
#define TX_PWR_HT_MCS_14_15_SIGN (1 << 14)
#define TX_PWR_HT_MCS_14_15_EN (1 << 15)

#define CONFIG_G_BAND_CHL 0xB0
#define CONFIG_G_BAND_CHL_GRP1_MASK (0xff)
#define CONFIG_G_BAND_CHL_GRP2_MASK (0xff << 8)

#define TX_PWR_A_BAND_OFDM_6_9M 0xB2
#define TX_PWR_A_BAND_OFDM_6_9M_MASK (0x3f)
#define TX_PWR_A_BAND_OFDM_6_9M_SIGN (1 << 6)
#define TX_PWR_A_BAND_OFDM_6_9M_EN (1 << 7)
#define TX_PWR_A_BAND_OFDM_12_18M_MASK (0x3f << 8)
#define TX_PWR_A_BAND_OFDM_12_18M_SIGN (1 << 14)
#define TX_PWR_A_BAND_OFDM_12_18M_EN (1 << 15)

#define TX_PWR_A_BAND_OFDM_24_36M 0xB4
#define TX_PWR_A_BAND_OFDM_24_36M_MASK (0x3f)
#define TX_PWR_A_BAND_OFDM_24_36M_SIGN (1 << 6)
#define TX_PWR_A_BAND_OFDM_24_36M_EN (1 << 7)
#define TX_PWR_A_BAND_OFDM_48_54M_MASK (0x3f << 8)
#define TX_PWR_A_BAND_OFDM_48_54M_SIGN (1 << 14)
#define TX_PWR_A_BAND_OFDM_48_54M_EN (1 << 15)

#define CONFIG1_A_BAND_CHL 0xB6
#define CONFIG1_A_BAND_CHL_GRP1_MASK 0xff
#define CONFIG1_A_BAND_CHL_GRP2_MASK (0xff << 8)

#define CONFIG2_A_BAND_CHL 0xB8
#define CONFIG2_A_BAND_CHL_GRP1_MASK (0xff)
#define CONFIG2_A_BAND_CHL_GRP2_MASK (0xff << 8)

#define TX_PWR_VHT_MCS_0_1 0xBA
#define TX_PWR_VHT_MCS_0_1_MASK (0x3f)
#define TX_PWR_VHT_MCS_0_1_SIGN (1 << 6)
#define TX_PWR_VHT_MCS_0_1_EN (1 << 7)
#define TX_PWR_VHT_MCS_2_3_MASK (0x3f << 8)
#define TX_PWR_VHT_MCS_2_3_SIGN (1 << 14)
#define TX_PWR_VHT_MCS_2_3_EN (1 << 15)

#define TX_PWR_VHT_MCS_4_5 0xBC
#define TX_PWR_VHT_MCS_4_5_MASK (0x3f)
#define TX_PWR_VHT_MCS_4_5_SIGN (1 << 6)
#define TX_PWR_VHT_MCS_4_5_EN (1 << 7)
#define TX_PWR_VHT_MCS_6_7_MASK (0x3f << 8)
#define TX_PWR_VHT_MCS_6_7_SIGN (1 << 14)
#define TX_PWR_VHT_MCS_6_7_EN (1 << 15)

#define TX_PWR_5G_VHT_MCS_8_9 0xBE
#define TX_PWR_5G_VHT_MCS_8_9_MASK (0x3f)
#define TX_PWR_5G_VHT_MCS_8_9_SIGN (1 << 6)
#define TX_PWR_5G_VHT_MCS_8_9_EN (1 << 7)
#define TX_PWR_2G_VHT_MCS_8_9_MASK (0x3f << 8)
#define TX_PWR_2G_VHT_MCS_8_9_SIGN (1 << 14)
#define TX_PWR_2G_VHT_MCS_8_9_EN (1 << 15)

#ifndef MT_MAC
#define CP_FT_VERSION 0xF6
#endif /* ! MT_MAC */
#define CP_FT_VERSION_MASK 0xFF

#define RF_2G_RX_HIGH_GAIN 0xF8
#define RF0_2G_RX_HIGH_GAIN_MASK (0x07 << 8)
#define RF0_2G_RX_HIGH_GAIN_SIGN (1 << 11)
#define RF1_2G_RX_HIGH_GAIN_MASK (0x07 << 12)
#define RF1_2G_RX_HIGH_GAIN_SIGN (1 << 15)

#define RF_5G_GRP0_1_RX_HIGH_GAIN 0xFA
#define RF0_5G_GRP0_RX_HIGH_GAIN_MASK (0x07)
#define RF0_5G_GRP0_RX_HIGH_GAIN_SIGN (1 << 3)
#define RF1_5G_GRP0_RX_HIGH_GAIN_MASK (0x07 << 4)
#define RF1_5G_GRP0_RX_HIGH_GAIN_SIGN (1 << 7)
#define RF0_5G_GRP1_RX_HIGH_GAIN_MASK (0x07 << 8)
#define RF0_5G_GRP1_RX_HIGH_GAIN_SIGN (1 << 11)
#define RF1_5G_GRP1_RX_HIGH_GAIN_MASK (0x07 << 12)
#define RF1_5G_GRP1_RX_HIGH_GAIN_SIGN (1 << 15)

#define RF_5G_GRP2_3_RX_HIGH_GAIN 0xFC
#define RF0_5G_GRP2_RX_HIGH_GAIN_MASK (0x07)
#define RF0_5G_GRP2_RX_HIGH_GAIN_SIGN (1 << 3)
#define RF1_5G_GRP2_RX_HIGH_GAIN_MASK (0x07 << 4)
#define RF1_5G_GRP2_RX_HIGH_GAIN_SIGN (1 << 7)
#define RF0_5G_GRP3_RX_HIGH_GAIN_MASK (0x07 << 8)
#define RF0_5G_GRP3_RX_HIGH_GAIN_SIGN (1 << 11)
#define RF1_5G_GRP3_RX_HIGH_GAIN_MASK (0x07 << 12)
#define RF1_5G_GRP3_RX_HIGH_GAIN_SIGN (1 << 15)

#define RF_5G_GRP4_5_RX_HIGH_GAIN 0xFE
#define RF0_5G_GRP4_RX_HIGH_GAIN_MASK (0x07)
#define RF0_5G_GRP4_RX_HIGH_GAIN_SIGN (1 << 3)
#define RF1_5G_GRP4_RX_HIGH_GAIN_MASK (0x07 << 4)
#define RF1_5G_GRP4_RX_HIGH_GAIN_SIGN (1 << 7)
#define RF0_5G_GRP5_RX_HIGH_GAIN_MASK (0x07 << 8)
#define RF0_5G_GRP5_RX_HIGH_GAIN_SIGN (1 << 11)
#define RF1_5G_GRP5_RX_HIGH_GAIN_MASK (0x07 << 12)
#define RF1_5G_GRP5_RX_HIGH_GAIN_SIGN (1 << 15)

#define BT_RCAL_RESULT 0x138
#define BT_VCDL_CALIBRATION 0x13C
#define BT_PMUCFG 0x13E

struct _RTMP_ADAPTER;

#ifdef RTMP_PCI_SUPPORT
/*************************************************************************
  *	Public function declarations for prom-based chipset
  ************************************************************************/
BOOLEAN rtmp_ee_prom_read16(struct _RTMP_ADAPTER *pAd, UINT32 Offset, UINT16 *pVal);
int rtmp_ee_prom_write16(struct _RTMP_ADAPTER *pAd, UINT32 Offset, USHORT val);
#endif /* RTMP_PCI_SUPPORT */




#if defined(RTMP_RBUS_SUPPORT) || defined(RTMP_FLASH_SUPPORT)
/*************************************************************************
  *	Public function declarations for flash-based chipset
  ************************************************************************/
NDIS_STATUS rtmp_nv_init(struct _RTMP_ADAPTER *pAd);
RTMP_STRING *get_dev_eeprom_binary(VOID *pvAd);
UINT get_dev_eeprom_offset(VOID *pvAd);
BOOLEAN rtmp_ee_flash_read(struct _RTMP_ADAPTER *pAd, UINT32 Offset, USHORT *pVal);
int rtmp_ee_flash_write(struct _RTMP_ADAPTER *pAd, UINT32 Offset, USHORT data);
BOOLEAN rtmp_ee_flash_read_with_range(struct _RTMP_ADAPTER *pAd, UINT32 start, UINT32 Length, UCHAR *pbuf);
int rtmp_ee_flash_write_with_range(struct _RTMP_ADAPTER *pAd, UINT32 start, UINT32 Length, UCHAR *pbuf);
VOID rtmp_ee_flash_read_all(struct _RTMP_ADAPTER *pAd, USHORT *Data);
VOID rtmp_ee_flash_write_all(struct _RTMP_ADAPTER *pAd);
#endif /* defined(RTMP_RBUS_SUPPORT) || defined(RTMP_FLASH_SUPPORT) */
UINT get_dev_eeprom_size(VOID *pvAd);


#ifdef RTMP_EFUSE_SUPPORT
/*************************************************************************
  *	Public function declarations for efuse-based chipset
  ************************************************************************/
BOOLEAN rtmp_ee_efuse_read16(struct _RTMP_ADAPTER *pAd, UINT32 Offset, USHORT *pVal);
int rtmp_ee_efuse_write16(struct _RTMP_ADAPTER *pAd, UINT32 Offset, USHORT data);
INT rtmp_ee_write_to_efuse(struct _RTMP_ADAPTER *pAd);

NTSTATUS eFuseRead(struct _RTMP_ADAPTER *pAd, USHORT Offset, USHORT *pData, USHORT len);
NTSTATUS eFuseWrite(struct _RTMP_ADAPTER *pAd, USHORT Offset, USHORT *pData, USHORT len);

VOID eFuseGetFreeBlockCount(struct _RTMP_ADAPTER *pAd, UINT *EfuseFreeBlock);

INT eFuse_init(struct _RTMP_ADAPTER *pAd);
INT efuse_probe(struct _RTMP_ADAPTER *pAd);
#endif /* RTMP_EFUSE_SUPPORT */

/*************************************************************************
  *	Public function declarations for using BIN buffer mode to access eeprom contents
  ************************************************************************/
BOOLEAN rtmp_ee_bin_read16(struct _RTMP_ADAPTER *pAd, UINT32 Offset, UINT16 *pValue);

INT rtmp_ee_bin_write16(
	IN struct _RTMP_ADAPTER *pAd,
	IN UINT32			Offset,
	IN USHORT			data);

INT rtmp_ee_load_from_bin(
	IN struct _RTMP_ADAPTER *pAd);

INT rtmp_ee_write_to_bin(
	IN struct _RTMP_ADAPTER *pAd);

BOOLEAN rtmp_ee_bin_read_with_range(struct _RTMP_ADAPTER *pAd, UINT32 start, UINT32 Length, UCHAR *pbuf);
int rtmp_ee_bin_write_with_range(struct _RTMP_ADAPTER *pAd, UINT32 start, UINT32 Length, UCHAR *pbuf);

INT rtmp_ee_write_to_prom(struct _RTMP_ADAPTER *pAd);

INT Set_LoadEepromBufferFromBin_Proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);

INT Set_EepromBufferWriteBack_Proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);

INT Set_bufferMode_Proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);

INT show_e2pinfo_proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);

#if defined(PRE_CAL_TRX_SET1_SUPPORT) || defined(PRE_CAL_TRX_SET2_SUPPORT) || defined(RLM_CAL_CACHE_SUPPORT)
NDIS_STATUS rtmp_cal_load_from_bin(
	IN struct _RTMP_ADAPTER *pAd,
	IN UCHAR *buf,
	IN ULONG offset,
	IN ULONG len);

NDIS_STATUS rtmp_cal_write_to_bin(
	IN struct _RTMP_ADAPTER *pAd,
	IN UCHAR *buf,
	IN ULONG offset,
	IN ULONG len);
#endif /* PRE_CAL_TRX_SET1_SUPPORT */

#if defined(CAL_BIN_FILE_SUPPORT) && defined(MT7615)
INT Cal_Data_Write_To_Bin(
	IN struct _RTMP_ADAPTER *pAd,
	IN UINT8 *Buf,
	IN UINT32 Offset,
	IN UINT32 Len);

INT Cal_Data_Load_From_Bin(
	IN struct _RTMP_ADAPTER *pAd,
	IN UINT8 *Buf,
	IN UINT32 Offset,
	IN UINT32 Len);
#endif /* CAL_BIN_FILE_SUPPORT */

#ifdef CAL_FREE_IC_SUPPORT
INT Set_LoadCalFreeData_Proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);
INT Set_CheckCalFree_Proc(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);
#endif


/*************************************************************************
  *	Public function declarations for prom operation callback functions setting
  ************************************************************************/
INT RtmpChipOpsEepromHook(struct _RTMP_ADAPTER *pAd, INT infType, INT forceMode);

INT NICReadEEPROMParameters(struct _RTMP_ADAPTER *pAd, RTMP_STRING *mac_addr);

#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT
void rtmp_eeprom_info_extract(struct _RTMP_ADAPTER *pAd);

NDIS_STATUS rtmp_eeprom_Sys_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR GetOrSet,
	UCHAR ColumnIdx,
	UCHAR *value
);
NDIS_STATUS rtmp_eeprom_WfCmm_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR eBand,
	ENUM_EFUSE_COMMON_CATOGORY eCmmType,
	UCHAR GetOrSet,
	UCHAR ChGroup,
	UCHAR ColumnIdx,
	UCHAR *value
);
NDIS_STATUS rtmp_eeprom_WfPath_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR eBand,
	ENUM_EFUSE_WF_PATH_CATOGORY eWFPathType,
	UCHAR AntIdx,
	UCHAR GetOrSet,
	UCHAR ChGroup,
	UCHAR ColumnIdx,
	UCHAR *value
);

NDIS_STATUS rtmp_eeprom_TxPwr_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR eBand,
	EFUSE_INFO_TX_POWER_CATEGORY eTxPwrParamCat,
	UCHAR GetOrSet,
	UCHAR ColumnIdx,
	UCHAR *value
);

NDIS_STATUS rtmp_eeprom_IBF_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR eBand,
	UCHAR GetOrSet,
	UCHAR ColumnIdx,
	UCHAR *value
);

NDIS_STATUS rtmp_eeprom_DelayComp_update(
	struct _RTMP_ADAPTER *pAd,
	UCHAR eBand,
	UCHAR GetOrSet,
	EFUSE_INFO_DELAY_COMP_CATEGORY eDelayCompParamCat,
	UCHAR ColumnIdx,
	UCHAR *value
);

INT32 show_UpdateEfuse_Example(struct _RTMP_ADAPTER *pAd, RTMP_STRING *arg);
#endif /*#ifdef	CONNAC_EFUSE_FORMAT_SUPPORT*/

#endif /* __EEPROM_H__ */
