//[File]            : wf_pp_top.h
//[Revision time]   : Mon Jan  4 19:36:32 2021
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2021 Mediatek Incorportion. All rights reserved.

#ifndef __WF_PP_TOP_REGS_H__
#define __WF_PP_TOP_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     WF_PP_TOP CR Definitions
//
//****************************************************************************

#define WF_PP_TOP_BASE                                         0x820CC000

#define WF_PP_TOP_TXDWCNT_ADDR                                 (WF_PP_TOP_BASE + 0x0000) // C000
#define WF_PP_TOP_RST_ADDR                                     (WF_PP_TOP_BASE + 0x0030) // C030
#define WF_PP_TOP_INT_ADDR                                     (WF_PP_TOP_BASE + 0x0034) // C034
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_ADDR                       (WF_PP_TOP_BASE + 0x0038) // C038
#define WF_PP_TOP_CSO_ADDR                                     (WF_PP_TOP_BASE + 0x0040) // C040
#define WF_PP_TOP_EXHDCSO_ADDR                                 (WF_PP_TOP_BASE + 0x0044) // C044
#define WF_PP_TOP_CG_SWCTL_ADDR                                (WF_PP_TOP_BASE + 0x0048) // C048
#define WF_PP_TOP_SDIO_RLEN_ADDR                               (WF_PP_TOP_BASE + 0x004C) // C04C
#define WF_PP_TOP_PAGECTL0_ADDR                                (WF_PP_TOP_BASE + 0x0050) // C050
#define WF_PP_TOP_PAGECTL1_ADDR                                (WF_PP_TOP_BASE + 0x0054) // C054
#define WF_PP_TOP_PAGECTL2_ADDR                                (WF_PP_TOP_BASE + 0x0058) // C058
#define WF_PP_TOP_PAGECTL3_ADDR                                (WF_PP_TOP_BASE + 0x005C) // C05C
#define WF_PP_TOP_PAGECTL4_ADDR                                (WF_PP_TOP_BASE + 0x0060) // C060
#define WF_PP_TOP_PAGECTL5_ADDR                                (WF_PP_TOP_BASE + 0x0064) // C064
#define WF_PP_TOP_PAGECTL6_ADDR                                (WF_PP_TOP_BASE + 0x0068) // C068
#define WF_PP_TOP_PAGECTL7_ADDR                                (WF_PP_TOP_BASE + 0x006C) // C06C
#define WF_PP_TOP_PAGECTL8_ADDR                                (WF_PP_TOP_BASE + 0x0070) // C070
#define WF_PP_TOP_PAGECTL9_ADDR                                (WF_PP_TOP_BASE + 0x0074) // C074
#define WF_PP_TOP_PAGECTL10_ADDR                               (WF_PP_TOP_BASE + 0x0078) // C078
#define WF_PP_TOP_RSV3_ADDR                                    (WF_PP_TOP_BASE + 0x007C) // C07C
#define WF_PP_TOP_RXQ_PRIO_ADDR                                (WF_PP_TOP_BASE + 0x00C0) // C0C0
#define WF_PP_TOP_RXQ_PRIO_2_ADDR                              (WF_PP_TOP_BASE + 0x00C4) // C0C4
#define WF_PP_TOP_RXQ_PRIO_3_ADDR                              (WF_PP_TOP_BASE + 0x00C8) // C0C8
#define WF_PP_TOP_RXQ_WFDMA_CFG_ADDR                           (WF_PP_TOP_BASE + 0x00D0) // C0D0
#define WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR                          (WF_PP_TOP_BASE + 0x00E8) // C0E8
#define WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR                          (WF_PP_TOP_BASE + 0x00EC) // C0EC
#define WF_PP_TOP_DBG_CTRL_ADDR                                (WF_PP_TOP_BASE + 0x00FC) // C0FC
#define WF_PP_TOP_DBG_FID_CTRL_ADDR                            (WF_PP_TOP_BASE + 0x0100) // C100
#define WF_PP_TOP_DBG_CS_0_ADDR                                (WF_PP_TOP_BASE + 0x0104) // C104
#define WF_PP_TOP_DBG_CS_1_ADDR                                (WF_PP_TOP_BASE + 0x0108) // C108
#define WF_PP_TOP_DBG_CS_2_ADDR                                (WF_PP_TOP_BASE + 0x010C) // C10C
#define WF_PP_TOP_DBG_ADDR                                     (WF_PP_TOP_BASE + 0x0110) // C110
#define WF_PP_TOP_PP_MDP_CTRL_ADDR                             (WF_PP_TOP_BASE + 0x0120) // C120
#define WF_PP_TOP_TCFR_ADDR                                    (WF_PP_TOP_BASE + 0x0124) // C124
#define WF_PP_TOP_TCFR_1_ADDR                                  (WF_PP_TOP_BASE + 0x0128) // C128
#define WF_PP_TOP_PP_RD_CTL0_ADDR                              (WF_PP_TOP_BASE + 0x0130) // C130
#define WF_PP_TOP_PP_RD_CTL1_ADDR                              (WF_PP_TOP_BASE + 0x0134) // C134




/* =====================================================================================

  ---TXDWCNT (0x820CC000 + 0x0000)---

    TX0_ADD_DW_CNT[7..0]         - (RW) Tx packet length software adjustment register (For PLD, in DDW unit)
    TX1_ADD_DW_CNT[15..8]        - (RW) Tx packet length software adjustment register (For TXD+PLD, in DDW unit)
    LIFETIME_UNIT[17..16]        - (RW) Tx packet life time unit select
                                     2'b00 : 8TU
                                     2'b01 : 16TU
                                     2'b10 : 32TU
                                     2'b11 : 64TU
    TAT_UNIT[19..18]             - (RW) Tx packet arrival time unit select
                                     2'b00 : 1TU
                                     2'b01 : 0.5TU
                                     2'b10 : 0.25TU
                                     2'b11 : 0.125TU
    RESERVED20[31..20]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_TXDWCNT_TAT_UNIT_ADDR                        WF_PP_TOP_TXDWCNT_ADDR
#define WF_PP_TOP_TXDWCNT_TAT_UNIT_MASK                        0x000C0000                // TAT_UNIT[19..18]
#define WF_PP_TOP_TXDWCNT_TAT_UNIT_SHFT                        18
#define WF_PP_TOP_TXDWCNT_LIFETIME_UNIT_ADDR                   WF_PP_TOP_TXDWCNT_ADDR
#define WF_PP_TOP_TXDWCNT_LIFETIME_UNIT_MASK                   0x00030000                // LIFETIME_UNIT[17..16]
#define WF_PP_TOP_TXDWCNT_LIFETIME_UNIT_SHFT                   16
#define WF_PP_TOP_TXDWCNT_TX1_ADD_DW_CNT_ADDR                  WF_PP_TOP_TXDWCNT_ADDR
#define WF_PP_TOP_TXDWCNT_TX1_ADD_DW_CNT_MASK                  0x0000FF00                // TX1_ADD_DW_CNT[15..8]
#define WF_PP_TOP_TXDWCNT_TX1_ADD_DW_CNT_SHFT                  8
#define WF_PP_TOP_TXDWCNT_TX0_ADD_DW_CNT_ADDR                  WF_PP_TOP_TXDWCNT_ADDR
#define WF_PP_TOP_TXDWCNT_TX0_ADD_DW_CNT_MASK                  0x000000FF                // TX0_ADD_DW_CNT[7..0]
#define WF_PP_TOP_TXDWCNT_TX0_ADD_DW_CNT_SHFT                  0

/* =====================================================================================

  ---RST (0x820CC000 + 0x0030)---

    LOGIC_RSTB[0]                - (RW) Resets PP logic
                                     0: Assert reset
                                     1: De-assert reset
    RESERVED1[30..1]             - (RO) Reserved bits
    FID_FFF_EN[31]               - (RW) Enables PSE Tx client write buffer allocation retry
                                     0 : Disable
                                     1 : Enable

 =====================================================================================*/
#define WF_PP_TOP_RST_FID_FFF_EN_ADDR                          WF_PP_TOP_RST_ADDR
#define WF_PP_TOP_RST_FID_FFF_EN_MASK                          0x80000000                // FID_FFF_EN[31]
#define WF_PP_TOP_RST_FID_FFF_EN_SHFT                          31
#define WF_PP_TOP_RST_LOGIC_RSTB_ADDR                          WF_PP_TOP_RST_ADDR
#define WF_PP_TOP_RST_LOGIC_RSTB_MASK                          0x00000001                // LOGIC_RSTB[0]
#define WF_PP_TOP_RST_LOGIC_RSTB_SHFT                          0

/* =====================================================================================

  ---INT (0x820CC000 + 0x0034)---

    PSE_TX_PAGE_OVER[0]          - (W1C) Indicates PSE Tx client write buffer page number requirement is more than PSE remaining page count or not
                                     0 : less than or equal to
                                     1 : more than
    PSE_TX_FID_FFF[1]            - (W1C) Indicates PSE return illegal FID in PSE Tx client WBA
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    PLE_TX_PAGE_OVER[2]          - (W1C) Indicates PLE Tx client write buffer page number requirement is more than PLE remaining page count or not
                                     0 : less than or equal to
                                     1 : more than
    PLE_TX_FID_FFF[3]            - (W1C) Indicates PLE return illegal FID in PLE Tx client WBA
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    PSE_TX_MSDU_LEN[4]           - (W1C) Indicates MSDU length accumulation is longer than AMSDU length
                                     0 : shorter than or equal to
                                     1 : longer than
    PSE_TX_LEN_TOO_SHORT[5]      - (W1C) Indicates Tx packet length is too short or not, i.e. 1DW or 2DW, which will make FSM malfunction
                                     0 : Legal Tx packet length
                                     1 : Illegal Tx packet length
    PSE_TX_LEN_ALIGH_FAIL[6]     - (W1C) Indicates Tx packet length is aligned with EOF indicator or not
                                     0 : Aligned
                                     1 : Not aligned
    PSE_RX0_PKT_TOO_SHORT[7]     - (W1C) Indicates Rx packet length is too short or not, i.e. less than or equal to 4 bytes, which will make FSM malfunction
                                     0 : Legal Rx packet length
                                     1 : Illegal Rx packet length
    PSE_RX0_FID_FFF[8]           - (W1C) Indicates illegal FID return in RESET queue operation
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    PSE_RX1_PKT_TOO_SHORT[9]     - (W1C) Indicates Rx packet length is too short or not, i.e. less than or equal to 4 bytes, which will make FSM malfunction
                                     0 : Legal Rx packet length
                                     1 : Illegal Rx packet length
    PSE_RX1_FID_FFF[10]          - (W1C) Indicates illegal FID return in RESET queue operation
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    RD_RX0_FID_FFF[11]           - (W1C) Indicates illegal FID return in RESET and GETNEXT queue operation
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    RESERVED12[15..12]           - (RO) Reserved bits
    PLE_TX_INT_EN[16]            - (RW) Enables PLE Tx client interrupt
                                     0 : Disable
                                     1 : Enable
    PSE_TX_INT_EN[17]            - (RW) Enables PSE Tx client interrupt
                                     0 : Disable
                                     1 : Enable
    PSE_RX_INT_EN[18]            - (RW) Enables PSE Rx client interrupt
                                     0 : Disable
                                     1 : Enable
    RD_RX_INT_EN[19]             - (RW) Enables PSE Rx client read length interrupt
                                     0 : Disable
                                     1 : Enable
    RESERVED20[23..20]           - (RO) Reserved bits
    B1_PSE_TX_PAGE_OVER[24]      - (W1C) Indicates PSE Tx client write buffer page number requirement is more than PSE remaining page count or not for DBDC band 1
                                     0 : less than or equal to
                                     1 : more than
    B1_PSE_TX_FID_FFF[25]        - (W1C) Indicates PSE return illegal FID in PSE Tx client WBA for DBDC band 1
                                     0 : FID not equal to 12'hFFF
                                     1 : FID equal to 12'hFFF
    B1_PSE_TX_MSDU_LEN[26]       - (W1C) Indicates MSDU length accumulation is longer than AMSDU length for DBDC band 1
                                     0 : shorter than or equal to
                                     1 : longer than
    B1_PSE_TX_LEN_TOO_SHORT[27]  - (W1C) Indicates Tx packet length is too short or not, i.e. 1DW or 2DW, which will make FSM malfunction for DBDC band 1
                                     0 : Legal Tx packet length
                                     1 : Illegal Tx packet length
    B1_PSE_TX_LEN_ALIGH_FAIL[28] - (W1C) Indicates Tx packet length is aligned with EOF indicator or not for DBDC band 1
                                     0 : Aligned
                                     1 : Not aligned
    RESERVED29[30..29]           - (RO) Reserved bits
    B1_PSE_TX_INT_EN[31]         - (RW) Enables PSE Tx client interrupt for DBDC band 1
                                     0 : Disable
                                     1 : Enable

 =====================================================================================*/
#define WF_PP_TOP_INT_B1_PSE_TX_INT_EN_ADDR                    WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_INT_EN_MASK                    0x80000000                // B1_PSE_TX_INT_EN[31]
#define WF_PP_TOP_INT_B1_PSE_TX_INT_EN_SHFT                    31
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_ALIGH_FAIL_ADDR            WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_ALIGH_FAIL_MASK            0x10000000                // B1_PSE_TX_LEN_ALIGH_FAIL[28]
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_ALIGH_FAIL_SHFT            28
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_TOO_SHORT_ADDR             WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_TOO_SHORT_MASK             0x08000000                // B1_PSE_TX_LEN_TOO_SHORT[27]
#define WF_PP_TOP_INT_B1_PSE_TX_LEN_TOO_SHORT_SHFT             27
#define WF_PP_TOP_INT_B1_PSE_TX_MSDU_LEN_ADDR                  WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_MSDU_LEN_MASK                  0x04000000                // B1_PSE_TX_MSDU_LEN[26]
#define WF_PP_TOP_INT_B1_PSE_TX_MSDU_LEN_SHFT                  26
#define WF_PP_TOP_INT_B1_PSE_TX_FID_FFF_ADDR                   WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_FID_FFF_MASK                   0x02000000                // B1_PSE_TX_FID_FFF[25]
#define WF_PP_TOP_INT_B1_PSE_TX_FID_FFF_SHFT                   25
#define WF_PP_TOP_INT_B1_PSE_TX_PAGE_OVER_ADDR                 WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_B1_PSE_TX_PAGE_OVER_MASK                 0x01000000                // B1_PSE_TX_PAGE_OVER[24]
#define WF_PP_TOP_INT_B1_PSE_TX_PAGE_OVER_SHFT                 24
#define WF_PP_TOP_INT_RD_RX_INT_EN_ADDR                        WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_RD_RX_INT_EN_MASK                        0x00080000                // RD_RX_INT_EN[19]
#define WF_PP_TOP_INT_RD_RX_INT_EN_SHFT                        19
#define WF_PP_TOP_INT_PSE_RX_INT_EN_ADDR                       WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_RX_INT_EN_MASK                       0x00040000                // PSE_RX_INT_EN[18]
#define WF_PP_TOP_INT_PSE_RX_INT_EN_SHFT                       18
#define WF_PP_TOP_INT_PSE_TX_INT_EN_ADDR                       WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_INT_EN_MASK                       0x00020000                // PSE_TX_INT_EN[17]
#define WF_PP_TOP_INT_PSE_TX_INT_EN_SHFT                       17
#define WF_PP_TOP_INT_PLE_TX_INT_EN_ADDR                       WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PLE_TX_INT_EN_MASK                       0x00010000                // PLE_TX_INT_EN[16]
#define WF_PP_TOP_INT_PLE_TX_INT_EN_SHFT                       16
#define WF_PP_TOP_INT_RD_RX0_FID_FFF_ADDR                      WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_RD_RX0_FID_FFF_MASK                      0x00000800                // RD_RX0_FID_FFF[11]
#define WF_PP_TOP_INT_RD_RX0_FID_FFF_SHFT                      11
#define WF_PP_TOP_INT_PSE_RX1_FID_FFF_ADDR                     WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_RX1_FID_FFF_MASK                     0x00000400                // PSE_RX1_FID_FFF[10]
#define WF_PP_TOP_INT_PSE_RX1_FID_FFF_SHFT                     10
#define WF_PP_TOP_INT_PSE_RX1_PKT_TOO_SHORT_ADDR               WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_RX1_PKT_TOO_SHORT_MASK               0x00000200                // PSE_RX1_PKT_TOO_SHORT[9]
#define WF_PP_TOP_INT_PSE_RX1_PKT_TOO_SHORT_SHFT               9
#define WF_PP_TOP_INT_PSE_RX0_FID_FFF_ADDR                     WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_RX0_FID_FFF_MASK                     0x00000100                // PSE_RX0_FID_FFF[8]
#define WF_PP_TOP_INT_PSE_RX0_FID_FFF_SHFT                     8
#define WF_PP_TOP_INT_PSE_RX0_PKT_TOO_SHORT_ADDR               WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_RX0_PKT_TOO_SHORT_MASK               0x00000080                // PSE_RX0_PKT_TOO_SHORT[7]
#define WF_PP_TOP_INT_PSE_RX0_PKT_TOO_SHORT_SHFT               7
#define WF_PP_TOP_INT_PSE_TX_LEN_ALIGH_FAIL_ADDR               WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_LEN_ALIGH_FAIL_MASK               0x00000040                // PSE_TX_LEN_ALIGH_FAIL[6]
#define WF_PP_TOP_INT_PSE_TX_LEN_ALIGH_FAIL_SHFT               6
#define WF_PP_TOP_INT_PSE_TX_LEN_TOO_SHORT_ADDR                WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_LEN_TOO_SHORT_MASK                0x00000020                // PSE_TX_LEN_TOO_SHORT[5]
#define WF_PP_TOP_INT_PSE_TX_LEN_TOO_SHORT_SHFT                5
#define WF_PP_TOP_INT_PSE_TX_MSDU_LEN_ADDR                     WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_MSDU_LEN_MASK                     0x00000010                // PSE_TX_MSDU_LEN[4]
#define WF_PP_TOP_INT_PSE_TX_MSDU_LEN_SHFT                     4
#define WF_PP_TOP_INT_PLE_TX_FID_FFF_ADDR                      WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PLE_TX_FID_FFF_MASK                      0x00000008                // PLE_TX_FID_FFF[3]
#define WF_PP_TOP_INT_PLE_TX_FID_FFF_SHFT                      3
#define WF_PP_TOP_INT_PLE_TX_PAGE_OVER_ADDR                    WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PLE_TX_PAGE_OVER_MASK                    0x00000004                // PLE_TX_PAGE_OVER[2]
#define WF_PP_TOP_INT_PLE_TX_PAGE_OVER_SHFT                    2
#define WF_PP_TOP_INT_PSE_TX_FID_FFF_ADDR                      WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_FID_FFF_MASK                      0x00000002                // PSE_TX_FID_FFF[1]
#define WF_PP_TOP_INT_PSE_TX_FID_FFF_SHFT                      1
#define WF_PP_TOP_INT_PSE_TX_PAGE_OVER_ADDR                    WF_PP_TOP_INT_ADDR
#define WF_PP_TOP_INT_PSE_TX_PAGE_OVER_MASK                    0x00000001                // PSE_TX_PAGE_OVER[0]
#define WF_PP_TOP_INT_PSE_TX_PAGE_OVER_SHFT                    0

/* =====================================================================================

  ---CT_CMD_FIFO_ENTRY (0x820CC000 + 0x0038)---

    CT_CMD_FIFO_ENTRY_NUM[1..0]  - (RW) Cut-through command FIFO entry number control (For DBDC performance concern)
                                     2'h0 : Entry Number = 4
                                     2'h1 : Entry Number = 4
                                     2'h2 : Entry Number = 2
                                     2'h3 : Entry Number = 1
    RESERVED2[7..2]              - (RO) Reserved bits
    HIF_TXP_ACTIVE_CTL0[8]       - (RW) PP_HIF_TXP_ACTIVE control
                                     0 : Ignore ple_disp_cut_txd_req
                                     1 : Include ple_disp_cut_txd_req
    HIF_TXP_ACTIVE_CTL1[9]       - (RW) PP_HIF_TXP_ACTIVE control
                                     0 : Block ple_disp_mactx_txp_active when cut_afull asserts
                                     1 : No block
    RESERVED10[31..10]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL1_ADDR   WF_PP_TOP_CT_CMD_FIFO_ENTRY_ADDR
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL1_MASK   0x00000200                // HIF_TXP_ACTIVE_CTL1[9]
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL1_SHFT   9
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL0_ADDR   WF_PP_TOP_CT_CMD_FIFO_ENTRY_ADDR
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL0_MASK   0x00000100                // HIF_TXP_ACTIVE_CTL0[8]
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_HIF_TXP_ACTIVE_CTL0_SHFT   8
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_CT_CMD_FIFO_ENTRY_NUM_ADDR WF_PP_TOP_CT_CMD_FIFO_ENTRY_ADDR
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_CT_CMD_FIFO_ENTRY_NUM_MASK 0x00000003                // CT_CMD_FIFO_ENTRY_NUM[1..0]
#define WF_PP_TOP_CT_CMD_FIFO_ENTRY_CT_CMD_FIFO_ENTRY_NUM_SHFT 0

/* =====================================================================================

  ---CSO (0x820CC000 + 0x0040)---

    TX_CSO_EN[0]                 - (RW) Enables Tx checksum offload
                                     0 : Disable
                                     1 : Enable
    TX_CSO_WB_DIS[1]             - (RW) Disable write back Tx checksum
                                     0: enable write back checksum
                                     1: disable write back checksum
    TX_CSO_DOP_MODE[2]           - (RW) Write back Tx checksum data operation mode
                                     0: use 1st page FID
                                     1: use latched FID
    RESERVED3[15..3]             - (RO) Reserved bits
    RX_CSO_IPV4_EN[16]           - (RW) Enables Rx IPV4 checksum offload
                                     0 : Disable
                                     1 : Enable
    RX_CSO_IPV6_EN[17]           - (RW) Enables Rx IPV6 checksum offload
                                     0 : Disable
                                     1 : Enable
    RX_CSO_TCP_EN[18]            - (RW) Enables Rx TCP checksum offload
                                     0 : Disable
                                     1 : Enable when RX_CSO_IPV4_EN is 1 or RX_CSO_IPV6_EN is 1
    RX_CSO_UDP_EN[19]            - (RW) Enables Rx UDP checksum offload
                                     0 : Disable
                                     1 : Enable when RX_CSO_IPV4_EN is 1 or RX_CSO_IPV6_EN is 1
    RESERVED20[31..20]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_CSO_RX_CSO_UDP_EN_ADDR                       WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_RX_CSO_UDP_EN_MASK                       0x00080000                // RX_CSO_UDP_EN[19]
#define WF_PP_TOP_CSO_RX_CSO_UDP_EN_SHFT                       19
#define WF_PP_TOP_CSO_RX_CSO_TCP_EN_ADDR                       WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_RX_CSO_TCP_EN_MASK                       0x00040000                // RX_CSO_TCP_EN[18]
#define WF_PP_TOP_CSO_RX_CSO_TCP_EN_SHFT                       18
#define WF_PP_TOP_CSO_RX_CSO_IPV6_EN_ADDR                      WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_RX_CSO_IPV6_EN_MASK                      0x00020000                // RX_CSO_IPV6_EN[17]
#define WF_PP_TOP_CSO_RX_CSO_IPV6_EN_SHFT                      17
#define WF_PP_TOP_CSO_RX_CSO_IPV4_EN_ADDR                      WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_RX_CSO_IPV4_EN_MASK                      0x00010000                // RX_CSO_IPV4_EN[16]
#define WF_PP_TOP_CSO_RX_CSO_IPV4_EN_SHFT                      16
#define WF_PP_TOP_CSO_TX_CSO_DOP_MODE_ADDR                     WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_TX_CSO_DOP_MODE_MASK                     0x00000004                // TX_CSO_DOP_MODE[2]
#define WF_PP_TOP_CSO_TX_CSO_DOP_MODE_SHFT                     2
#define WF_PP_TOP_CSO_TX_CSO_WB_DIS_ADDR                       WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_TX_CSO_WB_DIS_MASK                       0x00000002                // TX_CSO_WB_DIS[1]
#define WF_PP_TOP_CSO_TX_CSO_WB_DIS_SHFT                       1
#define WF_PP_TOP_CSO_TX_CSO_EN_ADDR                           WF_PP_TOP_CSO_ADDR
#define WF_PP_TOP_CSO_TX_CSO_EN_MASK                           0x00000001                // TX_CSO_EN[0]
#define WF_PP_TOP_CSO_TX_CSO_EN_SHFT                           0

/* =====================================================================================

  ---EXHDCSO (0x820CC000 + 0x0044)---

    NEXT_H_EN[0]                 - (RW) Enables newly-supported extension header
                                     0 : Disable
                                     1 : Enable
    RESERVED1[3..1]              - (RO) Reserved bits
    NEXT_H_JUMP_W[5..4]          - (RW) Indicates the newly-supported extension header length weight
                                     2'h0 : Extension Header Length Field x 1
                                     2'h1 : Extension Header Length Field x 2
                                     2'h2 : Extension Header Length Field x 3
                                     2'h3 : Extension Header Length Field x 4
                                     Extension Header Length Field : Unit=DW
    NEXT_H_JUMP_OFF[7..6]        - (RW) Indicates the newly-supported header length offset. Unit=DW

                                     Total newly-supported extension header length = Extension Header Length Field x (NEXT_H_JUMP_W + 1) + NEXT_H_JUMP_OFF
    NEXT_H[15..8]                - (RW) Indicates the type of the newly-supported header
                                     When this new header is identified, HW will skip the entire header length
    ESP_EN[16]                   - (RW) Supports Encapsulation extension header
                                     0 : Not support
                                     1 : Support
    AH_EN[17]                    - (RW) Supports Authentication extension header
                                     0 : Not support
                                     1 : Support
    RH_EN[18]                    - (RW) Supports Routing extension header
                                     0 : Not support
                                     1 : Support
    DEST_EN[19]                  - (RW) Supports Destination extension header
                                     0 : Not support
                                     1 : Support
    HOP_EN[20]                   - (RW) Supports Hop-By-Hop extension header
                                     0 : Not support
                                     1 : Support
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_EXHDCSO_HOP_EN_ADDR                          WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_HOP_EN_MASK                          0x00100000                // HOP_EN[20]
#define WF_PP_TOP_EXHDCSO_HOP_EN_SHFT                          20
#define WF_PP_TOP_EXHDCSO_DEST_EN_ADDR                         WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_DEST_EN_MASK                         0x00080000                // DEST_EN[19]
#define WF_PP_TOP_EXHDCSO_DEST_EN_SHFT                         19
#define WF_PP_TOP_EXHDCSO_RH_EN_ADDR                           WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_RH_EN_MASK                           0x00040000                // RH_EN[18]
#define WF_PP_TOP_EXHDCSO_RH_EN_SHFT                           18
#define WF_PP_TOP_EXHDCSO_AH_EN_ADDR                           WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_AH_EN_MASK                           0x00020000                // AH_EN[17]
#define WF_PP_TOP_EXHDCSO_AH_EN_SHFT                           17
#define WF_PP_TOP_EXHDCSO_ESP_EN_ADDR                          WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_ESP_EN_MASK                          0x00010000                // ESP_EN[16]
#define WF_PP_TOP_EXHDCSO_ESP_EN_SHFT                          16
#define WF_PP_TOP_EXHDCSO_NEXT_H_ADDR                          WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_NEXT_H_MASK                          0x0000FF00                // NEXT_H[15..8]
#define WF_PP_TOP_EXHDCSO_NEXT_H_SHFT                          8
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_OFF_ADDR                 WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_OFF_MASK                 0x000000C0                // NEXT_H_JUMP_OFF[7..6]
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_OFF_SHFT                 6
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_W_ADDR                   WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_W_MASK                   0x00000030                // NEXT_H_JUMP_W[5..4]
#define WF_PP_TOP_EXHDCSO_NEXT_H_JUMP_W_SHFT                   4
#define WF_PP_TOP_EXHDCSO_NEXT_H_EN_ADDR                       WF_PP_TOP_EXHDCSO_ADDR
#define WF_PP_TOP_EXHDCSO_NEXT_H_EN_MASK                       0x00000001                // NEXT_H_EN[0]
#define WF_PP_TOP_EXHDCSO_NEXT_H_EN_SHFT                       0

/* =====================================================================================

  ---CG_SWCTL (0x820CC000 + 0x0048)---

    CG_SW_CTL[0]                 - (RW) Clock enable software control
                                     0 : Software clock gate
                                     1 : Software clock ungate
    VTA_DIS[1]                   - (RW) VTA disable control
                                     0 : enable VTA
                                     1: disable VTA
    RX_PAUSE_DISP_HIF_DIS[2]     - (RW) Disable pause Rx packet to host when host Rx ring full, even if PP is processing this packet.
                                     0 : enable pause Rx packet
                                     1: disable pause Rx packet
    RX_PAUSE_DISP_MCU_DIS[3]     - (RW) Disable pause Rx packet to mcu when mcu Rx ring full, even if PP is processing this packet.
                                     0 : enable pause Rx packet
                                     1: disable pause Rx packet
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_MCU_DIS_ADDR          WF_PP_TOP_CG_SWCTL_ADDR
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_MCU_DIS_MASK          0x00000008                // RX_PAUSE_DISP_MCU_DIS[3]
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_MCU_DIS_SHFT          3
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_HIF_DIS_ADDR          WF_PP_TOP_CG_SWCTL_ADDR
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_HIF_DIS_MASK          0x00000004                // RX_PAUSE_DISP_HIF_DIS[2]
#define WF_PP_TOP_CG_SWCTL_RX_PAUSE_DISP_HIF_DIS_SHFT          2
#define WF_PP_TOP_CG_SWCTL_VTA_DIS_ADDR                        WF_PP_TOP_CG_SWCTL_ADDR
#define WF_PP_TOP_CG_SWCTL_VTA_DIS_MASK                        0x00000002                // VTA_DIS[1]
#define WF_PP_TOP_CG_SWCTL_VTA_DIS_SHFT                        1
#define WF_PP_TOP_CG_SWCTL_CG_SW_CTL_ADDR                      WF_PP_TOP_CG_SWCTL_ADDR
#define WF_PP_TOP_CG_SWCTL_CG_SW_CTL_MASK                      0x00000001                // CG_SW_CTL[0]
#define WF_PP_TOP_CG_SWCTL_CG_SW_CTL_SHFT                      0

/* =====================================================================================

  ---SDIO_RLEN (0x820CC000 + 0x004C)---

    SDIO_RLEN[0]                 - (RW) Enables SDIO read length function
                                     0 : Disable
                                     1 : Enable

                                     If HIF is SDIO, disable read length function after FW download because SDIO RX path will resume store-and-forward path in normal mode
    SDIO_IMPV_EN[1]              - (RW) Enables SDIO read length when length count not full
                                     0 : Disable
                                     1 : Enable
    SDIO_RX1_EN[2]               - (RW) Enables RX1 to MCU for SDIO
                                     0 : Disable
                                     1 : Enable
    SDIO_DATA_IMPV_DIS[3]        - (RW) Disable SDIO start rx ack when rx packet
                                     0 : Enable
                                     1 : Disable
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_SDIO_RLEN_SDIO_DATA_IMPV_DIS_ADDR            WF_PP_TOP_SDIO_RLEN_ADDR
#define WF_PP_TOP_SDIO_RLEN_SDIO_DATA_IMPV_DIS_MASK            0x00000008                // SDIO_DATA_IMPV_DIS[3]
#define WF_PP_TOP_SDIO_RLEN_SDIO_DATA_IMPV_DIS_SHFT            3
#define WF_PP_TOP_SDIO_RLEN_SDIO_RX1_EN_ADDR                   WF_PP_TOP_SDIO_RLEN_ADDR
#define WF_PP_TOP_SDIO_RLEN_SDIO_RX1_EN_MASK                   0x00000004                // SDIO_RX1_EN[2]
#define WF_PP_TOP_SDIO_RLEN_SDIO_RX1_EN_SHFT                   2
#define WF_PP_TOP_SDIO_RLEN_SDIO_IMPV_EN_ADDR                  WF_PP_TOP_SDIO_RLEN_ADDR
#define WF_PP_TOP_SDIO_RLEN_SDIO_IMPV_EN_MASK                  0x00000002                // SDIO_IMPV_EN[1]
#define WF_PP_TOP_SDIO_RLEN_SDIO_IMPV_EN_SHFT                  1
#define WF_PP_TOP_SDIO_RLEN_SDIO_RLEN_ADDR                     WF_PP_TOP_SDIO_RLEN_ADDR
#define WF_PP_TOP_SDIO_RLEN_SDIO_RLEN_MASK                     0x00000001                // SDIO_RLEN[0]
#define WF_PP_TOP_SDIO_RLEN_SDIO_RLEN_SHFT                     0

/* =====================================================================================

  ---PAGECTL0 (0x820CC000 + 0x0050)---

    PSE_PAGE_CNT_TH[11..0]       - (RW) PSE page count threshold (CMD)

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL0_PSE_PAGE_CNT_TH_ADDR                WF_PP_TOP_PAGECTL0_ADDR
#define WF_PP_TOP_PAGECTL0_PSE_PAGE_CNT_TH_MASK                0x00000FFF                // PSE_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL0_PSE_PAGE_CNT_TH_SHFT                0

/* =====================================================================================

  ---PAGECTL1 (0x820CC000 + 0x0054)---

    PLE_PAGE_CNT_TH[11..0]       - (RW) PLE page count threshold

                                     If PLE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL1_PLE_PAGE_CNT_TH_ADDR                WF_PP_TOP_PAGECTL1_ADDR
#define WF_PP_TOP_PAGECTL1_PLE_PAGE_CNT_TH_MASK                0x00000FFF                // PLE_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL1_PLE_PAGE_CNT_TH_SHFT                0

/* =====================================================================================

  ---PAGECTL2 (0x820CC000 + 0x0058)---

    CUT_PAGE_CNT_TH[11..0]       - (RW) PSE page count threshold (Cut-through payload)

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL2_CUT_PAGE_CNT_TH_ADDR                WF_PP_TOP_PAGECTL2_ADDR
#define WF_PP_TOP_PAGECTL2_CUT_PAGE_CNT_TH_MASK                0x00000FFF                // CUT_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL2_CUT_PAGE_CNT_TH_SHFT                0

/* =====================================================================================

  ---PAGECTL3 (0x820CC000 + 0x005C)---

    SF_PAGE_CNT_TH1[11..0]       - (RW) PSE page count threshold (Store-Forward payload)

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL3_SF_PAGE_CNT_TH1_ADDR                WF_PP_TOP_PAGECTL3_ADDR
#define WF_PP_TOP_PAGECTL3_SF_PAGE_CNT_TH1_MASK                0x00000FFF                // SF_PAGE_CNT_TH1[11..0]
#define WF_PP_TOP_PAGECTL3_SF_PAGE_CNT_TH1_SHFT                0

/* =====================================================================================

  ---PAGECTL4 (0x820CC000 + 0x0060)---

    SF_PAGE_CNT_TH2[11..0]       - (RW) PSE page count threshold (Store-Forward payload)

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL4_SF_PAGE_CNT_TH2_ADDR                WF_PP_TOP_PAGECTL4_ADDR
#define WF_PP_TOP_PAGECTL4_SF_PAGE_CNT_TH2_MASK                0x00000FFF                // SF_PAGE_CNT_TH2[11..0]
#define WF_PP_TOP_PAGECTL4_SF_PAGE_CNT_TH2_SHFT                0

/* =====================================================================================

  ---PAGECTL5 (0x820CC000 + 0x0064)---

    TXCMD_PAGE_CNT_TH[11..0]     - (RW) PLE page count threshold (TXCMD)

                                     If PLE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL5_TXCMD_PAGE_CNT_TH_ADDR              WF_PP_TOP_PAGECTL5_ADDR
#define WF_PP_TOP_PAGECTL5_TXCMD_PAGE_CNT_TH_MASK              0x00000FFF                // TXCMD_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL5_TXCMD_PAGE_CNT_TH_SHFT              0

/* =====================================================================================

  ---PAGECTL6 (0x820CC000 + 0x0068)---

    PLE_PAGE_CNT_H_TH[11..0]     - (RW) PLE page count high threshold

                                     If PLE remaining page count is more than this threshold, flow control will be inactivated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL6_PLE_PAGE_CNT_H_TH_ADDR              WF_PP_TOP_PAGECTL6_ADDR
#define WF_PP_TOP_PAGECTL6_PLE_PAGE_CNT_H_TH_MASK              0x00000FFF                // PLE_PAGE_CNT_H_TH[11..0]
#define WF_PP_TOP_PAGECTL6_PLE_PAGE_CNT_H_TH_SHFT              0

/* =====================================================================================

  ---PAGECTL7 (0x820CC000 + 0x006C)---

    PLE_WM_PAGE_CNT_L_TH[11..0]  - (RW) PLE WMCPU page count low threshold

                                     If PLE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL7_PLE_WM_PAGE_CNT_L_TH_ADDR           WF_PP_TOP_PAGECTL7_ADDR
#define WF_PP_TOP_PAGECTL7_PLE_WM_PAGE_CNT_L_TH_MASK           0x00000FFF                // PLE_WM_PAGE_CNT_L_TH[11..0]
#define WF_PP_TOP_PAGECTL7_PLE_WM_PAGE_CNT_L_TH_SHFT           0

/* =====================================================================================

  ---PAGECTL8 (0x820CC000 + 0x0070)---

    PLE_WM_PAGE_CNT_H_TH[11..0]  - (RW) PLE WMCPU page count high threshold

                                     If PLE remaining page count is more than this threshold, flow control will be inactivated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL8_PLE_WM_PAGE_CNT_H_TH_ADDR           WF_PP_TOP_PAGECTL8_ADDR
#define WF_PP_TOP_PAGECTL8_PLE_WM_PAGE_CNT_H_TH_MASK           0x00000FFF                // PLE_WM_PAGE_CNT_H_TH[11..0]
#define WF_PP_TOP_PAGECTL8_PLE_WM_PAGE_CNT_H_TH_SHFT           0

/* =====================================================================================

  ---PAGECTL9 (0x820CC000 + 0x0074)---

    MCU_PAGE_CNT_TH[11..0]       - (RW) PSE MCU page count threshold

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL9_MCU_PAGE_CNT_TH_ADDR                WF_PP_TOP_PAGECTL9_ADDR
#define WF_PP_TOP_PAGECTL9_MCU_PAGE_CNT_TH_MASK                0x00000FFF                // MCU_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL9_MCU_PAGE_CNT_TH_SHFT                0

/* =====================================================================================

  ---PAGECTL10 (0x820CC000 + 0x0078)---

    HOST_SF_PAGE_CNT_TH[11..0]   - (RW) PSE page count threshold (Store-Forward payload)

                                     If PSE remaining page count is less than this threshold, flow control will be activated
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PAGECTL10_HOST_SF_PAGE_CNT_TH_ADDR           WF_PP_TOP_PAGECTL10_ADDR
#define WF_PP_TOP_PAGECTL10_HOST_SF_PAGE_CNT_TH_MASK           0x00000FFF                // HOST_SF_PAGE_CNT_TH[11..0]
#define WF_PP_TOP_PAGECTL10_HOST_SF_PAGE_CNT_TH_SHFT           0

/* =====================================================================================

  ---RSV3 (0x820CC000 + 0x007C)---

    RSV3[31..0]                  - (RW) Reserved CR

 =====================================================================================*/
#define WF_PP_TOP_RSV3_RSV3_ADDR                               WF_PP_TOP_RSV3_ADDR
#define WF_PP_TOP_RSV3_RSV3_MASK                               0xFFFFFFFF                // RSV3[31..0]
#define WF_PP_TOP_RSV3_RSV3_SHFT                               0

/* =====================================================================================

  ---RXQ_PRIO (0x820CC000 + 0x00C0)---

    RXQ_1ST[3..0]                - (RW) 1st RX queue priority selection
    RESERVED4[7..4]              - (RO) Reserved bits
    RXQ_2ND[11..8]               - (RW) 2nd RX queue priority selection
    RESERVED12[15..12]           - (RO) Reserved bits
    RXQ_3RD[19..16]              - (RW) 3rd RX queue priority selection
    RESERVED20[23..20]           - (RO) Reserved bits
    RXQ_4TH[27..24]              - (RW) 4th RX queue priority selection
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_RXQ_PRIO_RXQ_4TH_ADDR                        WF_PP_TOP_RXQ_PRIO_ADDR
#define WF_PP_TOP_RXQ_PRIO_RXQ_4TH_MASK                        0x0F000000                // RXQ_4TH[27..24]
#define WF_PP_TOP_RXQ_PRIO_RXQ_4TH_SHFT                        24
#define WF_PP_TOP_RXQ_PRIO_RXQ_3RD_ADDR                        WF_PP_TOP_RXQ_PRIO_ADDR
#define WF_PP_TOP_RXQ_PRIO_RXQ_3RD_MASK                        0x000F0000                // RXQ_3RD[19..16]
#define WF_PP_TOP_RXQ_PRIO_RXQ_3RD_SHFT                        16
#define WF_PP_TOP_RXQ_PRIO_RXQ_2ND_ADDR                        WF_PP_TOP_RXQ_PRIO_ADDR
#define WF_PP_TOP_RXQ_PRIO_RXQ_2ND_MASK                        0x00000F00                // RXQ_2ND[11..8]
#define WF_PP_TOP_RXQ_PRIO_RXQ_2ND_SHFT                        8
#define WF_PP_TOP_RXQ_PRIO_RXQ_1ST_ADDR                        WF_PP_TOP_RXQ_PRIO_ADDR
#define WF_PP_TOP_RXQ_PRIO_RXQ_1ST_MASK                        0x0000000F                // RXQ_1ST[3..0]
#define WF_PP_TOP_RXQ_PRIO_RXQ_1ST_SHFT                        0

/* =====================================================================================

  ---RXQ_PRIO_2 (0x820CC000 + 0x00C4)---

    RXQ_5TH[3..0]                - (RW) 5th RX queue priority selection
    RESERVED4[7..4]              - (RO) Reserved bits
    RXQ_6TH[11..8]               - (RW) 6th RX queue priority selection
    RESERVED12[15..12]           - (RO) Reserved bits
    RXQ_7TH[19..16]              - (RW) 7th RX queue priority selection
    RESERVED20[23..20]           - (RO) Reserved bits
    RXQ_8TH[27..24]              - (RW) 8th RX queue priority selection
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_8TH_ADDR                      WF_PP_TOP_RXQ_PRIO_2_ADDR
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_8TH_MASK                      0x0F000000                // RXQ_8TH[27..24]
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_8TH_SHFT                      24
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_7TH_ADDR                      WF_PP_TOP_RXQ_PRIO_2_ADDR
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_7TH_MASK                      0x000F0000                // RXQ_7TH[19..16]
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_7TH_SHFT                      16
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_6TH_ADDR                      WF_PP_TOP_RXQ_PRIO_2_ADDR
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_6TH_MASK                      0x00000F00                // RXQ_6TH[11..8]
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_6TH_SHFT                      8
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_5TH_ADDR                      WF_PP_TOP_RXQ_PRIO_2_ADDR
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_5TH_MASK                      0x0000000F                // RXQ_5TH[3..0]
#define WF_PP_TOP_RXQ_PRIO_2_RXQ_5TH_SHFT                      0

/* =====================================================================================

  ---RXQ_PRIO_3 (0x820CC000 + 0x00C8)---

    RXQ_9TH[3..0]                - (RW) 9th RX queue priority selection
    RESERVED4[7..4]              - (RO) Reserved bits
    RXQ_10TH[11..8]              - (RW) 10th RX queue priority selection
    RESERVED12[15..12]           - (RO) Reserved bits
    RXQ_11TH[19..16]             - (RW) 11th RX queue priority selection
    RESERVED20[23..20]           - (RO) Reserved bits
    RXQ_12TH[27..24]             - (RW) 12th RX queue priority selection
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_12TH_ADDR                     WF_PP_TOP_RXQ_PRIO_3_ADDR
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_12TH_MASK                     0x0F000000                // RXQ_12TH[27..24]
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_12TH_SHFT                     24
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_11TH_ADDR                     WF_PP_TOP_RXQ_PRIO_3_ADDR
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_11TH_MASK                     0x000F0000                // RXQ_11TH[19..16]
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_11TH_SHFT                     16
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_10TH_ADDR                     WF_PP_TOP_RXQ_PRIO_3_ADDR
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_10TH_MASK                     0x00000F00                // RXQ_10TH[11..8]
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_10TH_SHFT                     8
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_9TH_ADDR                      WF_PP_TOP_RXQ_PRIO_3_ADDR
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_9TH_MASK                      0x0000000F                // RXQ_9TH[3..0]
#define WF_PP_TOP_RXQ_PRIO_3_RXQ_9TH_SHFT                      0

/* =====================================================================================

  ---RXQ_WFDMA_CFG (0x820CC000 + 0x00D0)---

    RXQ_QID0_WFDMA_QSEL[2..0]    - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID0_WFDMA_PORT_SEL[3]   - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID0_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID1_WFDMA_QSEL[6..4]    - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID1_WFDMA_PORT_SEL[7]   - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID1_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID2_WFDMA_QSEL[10..8]   - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID2_WFDMA_PORT_SEL[11]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID2_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID3_WFDMA_QSEL[14..12]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID3_WFDMA_PORT_SEL[15]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID3_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID4_WFDMA_QSEL[18..16]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID4_WFDMA_PORT_SEL[19]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID4_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID5_WFDMA_QSEL[22..20]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID5_WFDMA_PORT_SEL[23]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID5_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID6_WFDMA_QSEL[26..24]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID6_WFDMA_PORT_SEL[27]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID6_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID7_WFDMA_QSEL[30..28]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID7_WFDMA_PORT_SEL[31]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID7_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0

 =====================================================================================*/
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_PORT_SEL_MASK   0x80000000                // RXQ_QID7_WFDMA_PORT_SEL[31]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_PORT_SEL_SHFT   31
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_QSEL_MASK       0x70000000                // RXQ_QID7_WFDMA_QSEL[30..28]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID7_WFDMA_QSEL_SHFT       28
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_PORT_SEL_MASK   0x08000000                // RXQ_QID6_WFDMA_PORT_SEL[27]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_PORT_SEL_SHFT   27
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_QSEL_MASK       0x07000000                // RXQ_QID6_WFDMA_QSEL[26..24]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID6_WFDMA_QSEL_SHFT       24
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_PORT_SEL_MASK   0x00800000                // RXQ_QID5_WFDMA_PORT_SEL[23]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_PORT_SEL_SHFT   23
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_QSEL_MASK       0x00700000                // RXQ_QID5_WFDMA_QSEL[22..20]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID5_WFDMA_QSEL_SHFT       20
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_PORT_SEL_MASK   0x00080000                // RXQ_QID4_WFDMA_PORT_SEL[19]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_PORT_SEL_SHFT   19
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_QSEL_MASK       0x00070000                // RXQ_QID4_WFDMA_QSEL[18..16]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID4_WFDMA_QSEL_SHFT       16
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_PORT_SEL_MASK   0x00008000                // RXQ_QID3_WFDMA_PORT_SEL[15]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_PORT_SEL_SHFT   15
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_QSEL_MASK       0x00007000                // RXQ_QID3_WFDMA_QSEL[14..12]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID3_WFDMA_QSEL_SHFT       12
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_PORT_SEL_MASK   0x00000800                // RXQ_QID2_WFDMA_PORT_SEL[11]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_PORT_SEL_SHFT   11
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_QSEL_MASK       0x00000700                // RXQ_QID2_WFDMA_QSEL[10..8]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID2_WFDMA_QSEL_SHFT       8
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_PORT_SEL_MASK   0x00000080                // RXQ_QID1_WFDMA_PORT_SEL[7]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_PORT_SEL_SHFT   7
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_QSEL_MASK       0x00000070                // RXQ_QID1_WFDMA_QSEL[6..4]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID1_WFDMA_QSEL_SHFT       4
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_PORT_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_PORT_SEL_MASK   0x00000008                // RXQ_QID0_WFDMA_PORT_SEL[3]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_PORT_SEL_SHFT   3
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_QSEL_ADDR       WF_PP_TOP_RXQ_WFDMA_CFG_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_QSEL_MASK       0x00000007                // RXQ_QID0_WFDMA_QSEL[2..0]
#define WF_PP_TOP_RXQ_WFDMA_CFG_RXQ_QID0_WFDMA_QSEL_SHFT       0

/* =====================================================================================

  ---RXQ_WFDMA_CF_5 (0x820CC000 + 0x00E8)---

    RXQ_QID0_WFDMA_HIF_SEL[0]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID1_WFDMA_HIF_SEL[1]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID2_WFDMA_HIF_SEL[2]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID3_WFDMA_HIF_SEL[3]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID4_WFDMA_HIF_SEL[4]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID5_WFDMA_HIF_SEL[5]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID6_WFDMA_HIF_SEL[6]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID7_WFDMA_HIF_SEL[7]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID8_WFDMA_HIF_SEL[8]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID9_WFDMA_HIF_SEL[9]    - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID10_WFDMA_HIF_SEL[10]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RXQ_QID11_WFDMA_HIF_SEL[11]  - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0
                                     1: HIF, HOST_DMA0 PCIe_1
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID11_WFDMA_HIF_SEL_ADDR  WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID11_WFDMA_HIF_SEL_MASK  0x00000800                // RXQ_QID11_WFDMA_HIF_SEL[11]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID11_WFDMA_HIF_SEL_SHFT  11
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID10_WFDMA_HIF_SEL_ADDR  WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID10_WFDMA_HIF_SEL_MASK  0x00000400                // RXQ_QID10_WFDMA_HIF_SEL[10]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID10_WFDMA_HIF_SEL_SHFT  10
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID9_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID9_WFDMA_HIF_SEL_MASK   0x00000200                // RXQ_QID9_WFDMA_HIF_SEL[9]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID9_WFDMA_HIF_SEL_SHFT   9
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID8_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID8_WFDMA_HIF_SEL_MASK   0x00000100                // RXQ_QID8_WFDMA_HIF_SEL[8]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID8_WFDMA_HIF_SEL_SHFT   8
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID7_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID7_WFDMA_HIF_SEL_MASK   0x00000080                // RXQ_QID7_WFDMA_HIF_SEL[7]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID7_WFDMA_HIF_SEL_SHFT   7
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID6_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
//#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID6_WFDMA_HIF_SEL_MASK   0x00000040                 RXQ_QID6_WFDMA_HIF_SEL[6]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID6_WFDMA_HIF_SEL_SHFT   6
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID5_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID5_WFDMA_HIF_SEL_MASK   0x00000020                // RXQ_QID5_WFDMA_HIF_SEL[5]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID5_WFDMA_HIF_SEL_SHFT   5
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID4_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID4_WFDMA_HIF_SEL_MASK   0x00000010                // RXQ_QID4_WFDMA_HIF_SEL[4]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID4_WFDMA_HIF_SEL_SHFT   4
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID3_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID3_WFDMA_HIF_SEL_MASK   0x00000008                // RXQ_QID3_WFDMA_HIF_SEL[3]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID3_WFDMA_HIF_SEL_SHFT   3
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID2_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID2_WFDMA_HIF_SEL_MASK   0x00000004                // RXQ_QID2_WFDMA_HIF_SEL[2]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID2_WFDMA_HIF_SEL_SHFT   2
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID1_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID1_WFDMA_HIF_SEL_MASK   0x00000002                // RXQ_QID1_WFDMA_HIF_SEL[1]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID1_WFDMA_HIF_SEL_SHFT   1
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID0_WFDMA_HIF_SEL_ADDR   WF_PP_TOP_RXQ_WFDMA_CF_5_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID0_WFDMA_HIF_SEL_MASK   0x00000001                // RXQ_QID0_WFDMA_HIF_SEL[0]
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID0_WFDMA_HIF_SEL_SHFT   0

/* =====================================================================================

  ---RXQ_WFDMA_CF_6 (0x820CC000 + 0x00EC)---

    RXQ_QID8_WFDMA_QSEL[2..0]    - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID8_WFDMA_PORT_SEL[3]   - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID0_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID9_WFDMA_QSEL[6..4]    - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID9_WFDMA_PORT_SEL[7]   - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID1_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID10_WFDMA_QSEL[10..8]  - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID10_WFDMA_PORT_SEL[11] - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID2_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RXQ_QID11_WFDMA_QSEL[14..12] - (RW) WFDMA RX Ring To HIF selection
                                     3'h0: RxRing0
                                     3'h1: RxRing1
                                     3'h2: RxRing2
                                     3'h3: RxRing3
                                     3'h4: RxRing4
    RXQ_QID11_WFDMA_PORT_SEL[15] - (RW) RX queue WFDMA Port selection.
                                     0: HIF, HOST_DMA0 PCIe_0/HOST_DMA0 PCIe_1 by RXQ_QID3_WFDMA_HIF_SEL
                                     1: MCU, MCU_DMA0
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_PORT_SEL_ADDR WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_PORT_SEL_MASK 0x00008000                // RXQ_QID11_WFDMA_PORT_SEL[15]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_PORT_SEL_SHFT 15
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_QSEL_ADDR     WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_QSEL_MASK     0x00007000                // RXQ_QID11_WFDMA_QSEL[14..12]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID11_WFDMA_QSEL_SHFT     12
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_PORT_SEL_ADDR WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_PORT_SEL_MASK 0x00000800                // RXQ_QID10_WFDMA_PORT_SEL[11]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_PORT_SEL_SHFT 11
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_QSEL_ADDR     WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_QSEL_MASK     0x00000700                // RXQ_QID10_WFDMA_QSEL[10..8]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID10_WFDMA_QSEL_SHFT     8
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_PORT_SEL_ADDR  WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_PORT_SEL_MASK  0x00000080                // RXQ_QID9_WFDMA_PORT_SEL[7]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_PORT_SEL_SHFT  7
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_QSEL_ADDR      WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_QSEL_MASK      0x00000070                // RXQ_QID9_WFDMA_QSEL[6..4]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID9_WFDMA_QSEL_SHFT      4
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_PORT_SEL_ADDR  WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_PORT_SEL_MASK  0x00000008                // RXQ_QID8_WFDMA_PORT_SEL[3]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_PORT_SEL_SHFT  3
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_QSEL_ADDR      WF_PP_TOP_RXQ_WFDMA_CF_6_ADDR
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_QSEL_MASK      0x00000007                // RXQ_QID8_WFDMA_QSEL[2..0]
#define WF_PP_TOP_RXQ_WFDMA_CF_6_RXQ_QID8_WFDMA_QSEL_SHFT      0

/* =====================================================================================

  ---DBG_CTRL (0x820CC000 + 0x00FC)---

    PLE_CTRL_ERR_IND[3..0]       - (RO) PLE Control Error Indicate Flag
    DBG_RX_SEL[4]                - (RW) Debug Rx 0/1 select
    DBG_RX_PSE_D_MODE[5]         - (RW) Debug Rx PSE d_oper mode
                                     0: burst mode
                                     1: packet mode
    DBG_TX_DIS_BLK[6]            - (RW) Disable Block Mode
    DBG_TX_ENQ_MODE[7]           - (RW) Tx Enqueue Mode
                                     0: always enable block mode, ignore DBG_TX_DIS_BLK, enqueue when 1st MSDU ready
                                     1: enqueu after whole frame ready
    DISP_TX_ERR_FLAG[15..8]      - (RO) Dispatch TX Error Flag for Band 0
    DISP_TX_ERR_FLAG_1[23..16]   - (RO) Dispatch TX Error Flag for Band 1
    DBG_BAND_SEL[24]             - (RW) Debug Band 0/1 select
    DBG_BYTE_SEL[27..25]         - (RW) Debug byte select
    DBG_EN[28]                   - (RW) Debug Flag enable
    DBG_CNT_EN[29]               - (RW) Debug Counter Enable
    DBG_CNT_CLR[30]              - (W1C) Clear debug counter
    ERR_IND_CLR[31]              - (RW) Clear Error Indicate Flag

 =====================================================================================*/
#define WF_PP_TOP_DBG_CTRL_ERR_IND_CLR_ADDR                    WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_ERR_IND_CLR_MASK                    0x80000000                // ERR_IND_CLR[31]
#define WF_PP_TOP_DBG_CTRL_ERR_IND_CLR_SHFT                    31
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_CLR_ADDR                    WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_CLR_MASK                    0x40000000                // DBG_CNT_CLR[30]
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_CLR_SHFT                    30
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_EN_ADDR                     WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_EN_MASK                     0x20000000                // DBG_CNT_EN[29]
#define WF_PP_TOP_DBG_CTRL_DBG_CNT_EN_SHFT                     29
#define WF_PP_TOP_DBG_CTRL_DBG_EN_ADDR                         WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_EN_MASK                         0x10000000                // DBG_EN[28]
#define WF_PP_TOP_DBG_CTRL_DBG_EN_SHFT                         28
#define WF_PP_TOP_DBG_CTRL_DBG_BYTE_SEL_ADDR                   WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_BYTE_SEL_MASK                   0x0E000000                // DBG_BYTE_SEL[27..25]
#define WF_PP_TOP_DBG_CTRL_DBG_BYTE_SEL_SHFT                   25
#define WF_PP_TOP_DBG_CTRL_DBG_BAND_SEL_ADDR                   WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_BAND_SEL_MASK                   0x01000000                // DBG_BAND_SEL[24]
#define WF_PP_TOP_DBG_CTRL_DBG_BAND_SEL_SHFT                   24
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_1_ADDR             WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_1_MASK             0x00FF0000                // DISP_TX_ERR_FLAG_1[23..16]
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_1_SHFT             16
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_ADDR               WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_MASK               0x0000FF00                // DISP_TX_ERR_FLAG[15..8]
#define WF_PP_TOP_DBG_CTRL_DISP_TX_ERR_FLAG_SHFT               8
#define WF_PP_TOP_DBG_CTRL_DBG_TX_ENQ_MODE_ADDR                WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_TX_ENQ_MODE_MASK                0x00000080                // DBG_TX_ENQ_MODE[7]
#define WF_PP_TOP_DBG_CTRL_DBG_TX_ENQ_MODE_SHFT                7
#define WF_PP_TOP_DBG_CTRL_DBG_TX_DIS_BLK_ADDR                 WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_TX_DIS_BLK_MASK                 0x00000040                // DBG_TX_DIS_BLK[6]
#define WF_PP_TOP_DBG_CTRL_DBG_TX_DIS_BLK_SHFT                 6
#define WF_PP_TOP_DBG_CTRL_DBG_RX_PSE_D_MODE_ADDR              WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_RX_PSE_D_MODE_MASK              0x00000020                // DBG_RX_PSE_D_MODE[5]
#define WF_PP_TOP_DBG_CTRL_DBG_RX_PSE_D_MODE_SHFT              5
#define WF_PP_TOP_DBG_CTRL_DBG_RX_SEL_ADDR                     WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_DBG_RX_SEL_MASK                     0x00000010                // DBG_RX_SEL[4]
#define WF_PP_TOP_DBG_CTRL_DBG_RX_SEL_SHFT                     4
#define WF_PP_TOP_DBG_CTRL_PLE_CTRL_ERR_IND_ADDR               WF_PP_TOP_DBG_CTRL_ADDR
#define WF_PP_TOP_DBG_CTRL_PLE_CTRL_ERR_IND_MASK               0x0000000F                // PLE_CTRL_ERR_IND[3..0]
#define WF_PP_TOP_DBG_CTRL_PLE_CTRL_ERR_IND_SHFT               0

/* =====================================================================================

  ---DBG_FID_CTRL (0x820CC000 + 0x0100)---

    DBG_FID_INFO[11..0]          - (RO) Debug FID dump value
    RESERVED12[23..12]           - (RO) Reserved bits
    DBG_FID_SEL[28..24]          - (RW) Debug FID selection, dump FID information
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_SEL_ADDR                WF_PP_TOP_DBG_FID_CTRL_ADDR
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_SEL_MASK                0x1F000000                // DBG_FID_SEL[28..24]
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_SEL_SHFT                24
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_INFO_ADDR               WF_PP_TOP_DBG_FID_CTRL_ADDR
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_INFO_MASK               0x00000FFF                // DBG_FID_INFO[11..0]
#define WF_PP_TOP_DBG_FID_CTRL_DBG_FID_INFO_SHFT               0

/* =====================================================================================

  ---DBG_CS_0 (0x820CC000 + 0x0104)---

    DBG_CS_0[31..0]              - (RO) Debug information 0

 =====================================================================================*/
#define WF_PP_TOP_DBG_CS_0_DBG_CS_0_ADDR                       WF_PP_TOP_DBG_CS_0_ADDR
#define WF_PP_TOP_DBG_CS_0_DBG_CS_0_MASK                       0xFFFFFFFF                // DBG_CS_0[31..0]
#define WF_PP_TOP_DBG_CS_0_DBG_CS_0_SHFT                       0

/* =====================================================================================

  ---DBG_CS_1 (0x820CC000 + 0x0108)---

    DBG_CS_1[31..0]              - (RO) Debug information 1

 =====================================================================================*/
#define WF_PP_TOP_DBG_CS_1_DBG_CS_1_ADDR                       WF_PP_TOP_DBG_CS_1_ADDR
#define WF_PP_TOP_DBG_CS_1_DBG_CS_1_MASK                       0xFFFFFFFF                // DBG_CS_1[31..0]
#define WF_PP_TOP_DBG_CS_1_DBG_CS_1_SHFT                       0

/* =====================================================================================

  ---DBG_CS_2 (0x820CC000 + 0x010C)---

    DBG_CS_2[31..0]              - (RO) Debug information 2

 =====================================================================================*/
#define WF_PP_TOP_DBG_CS_2_DBG_CS_2_ADDR                       WF_PP_TOP_DBG_CS_2_ADDR
#define WF_PP_TOP_DBG_CS_2_DBG_CS_2_MASK                       0xFFFFFFFF                // DBG_CS_2[31..0]
#define WF_PP_TOP_DBG_CS_2_DBG_CS_2_SHFT                       0

/* =====================================================================================

  ---DBG (0x820CC000 + 0x0110)---

    DBG_PROB[31..0]              - (RO) Debug probe

 =====================================================================================*/
#define WF_PP_TOP_DBG_DBG_PROB_ADDR                            WF_PP_TOP_DBG_ADDR
#define WF_PP_TOP_DBG_DBG_PROB_MASK                            0xFFFFFFFF                // DBG_PROB[31..0]
#define WF_PP_TOP_DBG_DBG_PROB_SHFT                            0

/* =====================================================================================

  ---PP_MDP_CTRL (0x820CC000 + 0x0120)---

    MDP_PLD_OFST[7..0]           - (RW) MDP payload offset
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PP_MDP_CTRL_MDP_PLD_OFST_ADDR                WF_PP_TOP_PP_MDP_CTRL_ADDR
#define WF_PP_TOP_PP_MDP_CTRL_MDP_PLD_OFST_MASK                0x000000FF                // MDP_PLD_OFST[7..0]
#define WF_PP_TOP_PP_MDP_CTRL_MDP_PLD_OFST_SHFT                0

/* =====================================================================================

  ---TCFR (0x820CC000 + 0x0124)---

    TXP_QID[6..0]                - (RW) Select the destination QID
    RESERVED7[7]                 - (RO) Reserved bits
    TXP_PID[9..8]                - (RW) Select the PortID
                                     0: HIF Port
                                     1: MCU Port
                                     2: MAC
    RESERVED10[15..10]           - (RO) Reserved bits
    TXP1_QID[22..16]             - (RW) Select the destination QID for Band 1
    RESERVED23[23]               - (RO) Reserved bits
    TXP1_PID[25..24]             - (RW) Select the PortID for Band 1
                                     0: HIF Port
                                     1: MCU Port
                                     2: MAC
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_TCFR_TXP1_PID_ADDR                           WF_PP_TOP_TCFR_ADDR
#define WF_PP_TOP_TCFR_TXP1_PID_MASK                           0x03000000                // TXP1_PID[25..24]
#define WF_PP_TOP_TCFR_TXP1_PID_SHFT                           24
#define WF_PP_TOP_TCFR_TXP1_QID_ADDR                           WF_PP_TOP_TCFR_ADDR
#define WF_PP_TOP_TCFR_TXP1_QID_MASK                           0x007F0000                // TXP1_QID[22..16]
#define WF_PP_TOP_TCFR_TXP1_QID_SHFT                           16
#define WF_PP_TOP_TCFR_TXP_PID_ADDR                            WF_PP_TOP_TCFR_ADDR
#define WF_PP_TOP_TCFR_TXP_PID_MASK                            0x00000300                // TXP_PID[9..8]
#define WF_PP_TOP_TCFR_TXP_PID_SHFT                            8
#define WF_PP_TOP_TCFR_TXP_QID_ADDR                            WF_PP_TOP_TCFR_ADDR
#define WF_PP_TOP_TCFR_TXP_QID_MASK                            0x0000007F                // TXP_QID[6..0]
#define WF_PP_TOP_TCFR_TXP_QID_SHFT                            0

/* =====================================================================================

  ---TCFR_1 (0x820CC000 + 0x0128)---

    TXP_SAF_QID[6..0]            - (RW) Select the destination QID
    RESERVED7[7]                 - (RO) Reserved bits
    TXP_SAF_PID[9..8]            - (RW) Select the PortID
                                     0: HIF Port
                                     1: MCU Port
                                     2: MAC
    RESERVED10[31..10]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_TCFR_1_TXP_SAF_PID_ADDR                      WF_PP_TOP_TCFR_1_ADDR
#define WF_PP_TOP_TCFR_1_TXP_SAF_PID_MASK                      0x00000300                // TXP_SAF_PID[9..8]
#define WF_PP_TOP_TCFR_1_TXP_SAF_PID_SHFT                      8
#define WF_PP_TOP_TCFR_1_TXP_SAF_QID_ADDR                      WF_PP_TOP_TCFR_1_ADDR
#define WF_PP_TOP_TCFR_1_TXP_SAF_QID_MASK                      0x0000007F                // TXP_SAF_QID[6..0]
#define WF_PP_TOP_TCFR_1_TXP_SAF_QID_SHFT                      0

/* =====================================================================================

  ---PP_RD_CTL0 (0x820CC000 + 0x0130)---

    PP_REDIR_WBID0[4..0]         - (RW) Configure write buffer id, if PP redirect is enable and QID = 0.
    RESERVED5[7..5]              - (RO) Reserved bits
    PP_REDIR_WBID1[12..8]        - (RW) Configure write buffer id, if PP redirect is enable and QID = 1.
    RESERVED13[15..13]           - (RO) Reserved bits
    PP_REDIR_WBID2[20..16]       - (RW) Configure write buffer id, if PP redirect is enable and QID = 2.
    RESERVED21[23..21]           - (RO) Reserved bits
    PP_REDIR_WBID3[28..24]       - (RW) Configure write buffer id, if PP redirect is enable and QID = 3.
    RESERVED29[30..29]           - (RO) Reserved bits
    PP_REDIR_EN[31]              - (RW) Enable PP redirect function
                                     When PKT_FT frame = 0x3, redirect packet to HIF port.
                                     1 : Enable
                                     0: Disable

 =====================================================================================*/
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_EN_ADDR                  WF_PP_TOP_PP_RD_CTL0_ADDR
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_EN_MASK                  0x80000000                // PP_REDIR_EN[31]
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_EN_SHFT                  31
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID3_ADDR               WF_PP_TOP_PP_RD_CTL0_ADDR
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID3_MASK               0x1F000000                // PP_REDIR_WBID3[28..24]
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID3_SHFT               24
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID2_ADDR               WF_PP_TOP_PP_RD_CTL0_ADDR
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID2_MASK               0x001F0000                // PP_REDIR_WBID2[20..16]
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID2_SHFT               16
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID1_ADDR               WF_PP_TOP_PP_RD_CTL0_ADDR
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID1_MASK               0x00001F00                // PP_REDIR_WBID1[12..8]
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID1_SHFT               8
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID0_ADDR               WF_PP_TOP_PP_RD_CTL0_ADDR
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID0_MASK               0x0000001F                // PP_REDIR_WBID0[4..0]
#define WF_PP_TOP_PP_RD_CTL0_PP_REDIR_WBID0_SHFT               0

/* =====================================================================================

  ---PP_RD_CTL1 (0x820CC000 + 0x0134)---

    PP_REDIR_QID0[6..0]          - (RW) Configure queue id, if PP redirect is enable and QID = 0 .
    RESERVED7[7]                 - (RO) Reserved bits
    PP_REDIR_QID1[14..8]         - (RW) Configure queue id, if PP redirect is enable and QID = 1.
    RESERVED15[15]               - (RO) Reserved bits
    PP_REDIR_QID2[22..16]        - (RW) Configure queue id, if PP redirect is enable and QID = 2 .
    RESERVED23[23]               - (RO) Reserved bits
    PP_REDIR_QID3[30..24]        - (RW) Configure queue id, if PP redirect is enable and QID = 3.
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID3_ADDR                WF_PP_TOP_PP_RD_CTL1_ADDR
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID3_MASK                0x7F000000                // PP_REDIR_QID3[30..24]
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID3_SHFT                24
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID2_ADDR                WF_PP_TOP_PP_RD_CTL1_ADDR
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID2_MASK                0x007F0000                // PP_REDIR_QID2[22..16]
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID2_SHFT                16
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID1_ADDR                WF_PP_TOP_PP_RD_CTL1_ADDR
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID1_MASK                0x00007F00                // PP_REDIR_QID1[14..8]
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID1_SHFT                8
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID0_ADDR                WF_PP_TOP_PP_RD_CTL1_ADDR
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID0_MASK                0x0000007F                // PP_REDIR_QID0[6..0]
#define WF_PP_TOP_PP_RD_CTL1_PP_REDIR_QID0_SHFT                0

#ifdef __cplusplus
}
#endif

#endif // __WF_PP_TOP_REGS_H__
