#
# Copyright (c) 2014 Wi-Fi Alliance
# 
# Permission to use, copy, modify, and/or distribute this software for any 
# purpose with or without fee is hereby granted, provided that the above 
# copyright notice and this permission notice appear in all copies.
# 
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
# SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
# USE OR PERFORMANCE OF THIS SOFTWARE.
#
include $(TOPDIR)/rules.mk
CROSS_COMPILE = mipsel-linux-
CC = $(CROSS_COMPILE)gcc
LIB=lib
DUT=dut
CA=ca
UCC=ucc
MAKE=make

# This is for WMM-PS
#for Ext TG
#CFLAGS = -g -O2 -D_REENTRANT -DWFA_WMM_PS_EXT -Wall -I../inc

## for WMM-AC, WMM-PS, Voice, PMF, TDLS Test-Bed 
#CFLAGS = -g -O2 -D_REENTRANT  -DWFA_WMM_PS_EXT -DWFA_WMM_AC -DWFA_VOICE_EXT -DWFA_STA_TB -Wall -I../inc

## for WMM-AC, WMM-PS Test-Bed
#CFLAGS = -g -O2 -D_REENTRANT  -DWFA_WMM_PS_EXT -DWFA_WMM_AC -DWFA_STA_TB -Wall -I../inc

## for non-Test-Bed WMM-AC, WMM-PS and Voice
#CFLAGS = -g -O2 -D_REENTRANT  -DWFA_WMM_PS_EXT -DWFA_WMM_AC -DWFA_VOICE_EXT -Wall -I../inc

## for PC-ENDPOINT
#CFLAGS = -g -O2 -D_REENTRANT  -DWFA_WMM_PS_EXT -DWFA_WMM_AC -DWFA_VOICE_EXT -DWFA_PC_CONSOLE -Wall -I../inc

## for PC-ENDPOINT No Voice
#CFLAGS = -g -O2 -D_REENTRANT  -DWFA_WMM_PS_EXT -DWFA_WMM_AC -DWFA_PC_CONSOLE -DWFA_STA_TB -Wall -I../inc

# This is for WPA2 as default
CFLAGS = -g -O2 -D_REENTRANT -Wall -I../inc -DWFA_STA_TB -DMTK_PRIVATE_IOCTL -DDRIVER_SCAN_TRIGGER #-DTGAC_DAEMON -DWFA_WMM_PS_EXT

ifeq ($(CONFIG_DBDC_MODE), y)
CFLAGS += -DDBDC_MODE_CERT
endif

ifeq ($(CONFIG_MULTI_PROFILE_SUPPORT), y)
CFLAGS += -DWIFI_MULTI_PROFILE
endif

ifeq ($(CONFIG_first_card_name), "MT7615")
ifeq ($(CONFIG_second_card_name), "MT7615")
CFLAGS += -DFIRST_CARD_MT7615_SECOND_CARD_MT7615
endif
endif

ifeq ($(CONFIG_first_card_name), "MT7986")
ifeq ($(CONFIG_MTK_WIFI_SKU_TYPE), "AX4200")
CFLAGS += -DFIRST_CARD_MT7986_AX4200
endif
endif

ifeq ($(CONFIG_first_card_name), "MT7986")
ifeq ($(CONFIG_MTK_WIFI_SKU_TYPE), "AX6000")
CFLAGS += -DFIRST_CARD_MT7986_AX6000
endif
endif

ifeq ($(CONFIG_first_card_name), "MT7986")
ifeq ($(CONFIG_MTK_WIFI_SKU_TYPE), "AX8400")
CFLAGS += -DFIRST_CARD_MT7986_AX8400
endif
endif

ifeq ($(CONFIG_first_card_name), "MT7916")
CFLAGS += -DFIRST_CARD_MT7916
endif

ifeq ($(CONFIG_first_card_name), "MT7981")
CFLAGS += -DFIRST_CARD_MT7981
endif

# this is for sensitive mac log
CFLAGS += -DMASK_PARTIAL_MACADDR

DUTLIBS = ../lib/libwfa_dut.a -lpthread
CALIBS = ../lib/libwfa_ca.a -lpthread
RANLIB = ranlib

LIBWFA_NAME_DUT = libwfa_dut.a
LIBWFA_NAME_CA = libwfa_ca.a
LIBWFA_NAME = libwfa.a

LIB_OBJS = wfa_sock.o wfa_tg.o wfa_cs.o wfa_ca_resp.o wfa_tlv.o wfa_typestr.o wfa_cmdtbl.o wfa_cmdproc.o wfa_miscs.o wfa_thr.o wfa_wmmps.o wfa_mtk.o

LIB_OBJS_DUT = wfa_sock.o wfa_tlv.o wfa_cs.o wfa_cmdtbl.o wfa_tg.o wfa_miscs.o wfa_thr.o wfa_wmmps.o wfa_mtk.o

LIB_OBJS_CA = wfa_sock.o wfa_tlv.o wfa_ca_resp.o wfa_cmdproc.o wfa_miscs.o wfa_typestr.o

CLEANFILES = core core.* *.core.* *.o *.a
