/*
 * AM33XX-CM3 firmware
 *
 * Cortex-M3 (CM3) firmware for power management on Texas Instruments' AM33XX series of SoCs
 *
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  This software is licensed under the  standard terms and conditions in the Texas Instruments  Incorporated
 *  Technology and Software Publicly Available Software License Agreement , a copy of which is included in the
 *  software download.
*/

#ifndef __CM43XX_H
#define __CM43XX_H

/* CM base address */
#define AM43XX_CM_BASE			0x44DF0000

#define AM43XX_CM_REGADDR(inst, reg)				\
	(AM43XX_CM_BASE + (inst) + (reg))

/* CM instances */
#define AM43XX_CM_WKUP_INST	0x2800
#define AM43XX_CM_DEVICE_INST	0x4100
#define AM43XX_CM_DPLL_INST	0x4200
#define AM43XX_CM_MPU_INST	0x8300
#define AM43XX_CM_GFX_INST	0x8400
#define AM43XX_CM_RTC_INST	0x8500
#define AM43XX_CM_TAMPER_INST	0x8600
#define AM43XX_CM_CEFUSE_INST	0x8700
#define AM43XX_CM_PER_INST	0x8800

/* PRCM clockdomain register offsets (from instance start) */
#define AM43XX_CM_WKUP_L3_AON_CDOFFS		0x0000
#define AM43XX_CM_WKUP_L3S_TSC_CDOFFS		0x0100
#define AM43XX_CM_WKUP_L4_WKUP_AON_CDOFFS	0x0200
#define AM43XX_CM_WKUP_WKUP_CDOFFS		0x0300
#define AM43XX_CM_MPU_MPU_CDOFFS		0x0000
#define AM43XX_CM_GFX_GFX_L3_CDOFFS		0x0000
#define AM43XX_CM_RTC_RTC_CDOFFS		0x0000
#define AM43XX_CM_TAMPER_TAMPER_CDOFFS		0x0000
#define AM43XX_CM_CEFUSE_CEFUSE_CDOFFS		0x0000
#define AM43XX_CM_PER_L3_CDOFFS	    		0x0000
#define AM43XX_CM_PER_L3S_CDOFFS		0x0200
#define AM43XX_CM_PER_ICSS_CDOFFS		0x0300
#define AM43XX_CM_PER_L4LS_CDOFFS		0x0400
#define AM43XX_CM_PER_EMIF_CDOFFS		0x0700
#define AM43XX_CM_PER_LCDC_CDOFFS		0x0800
#define AM43XX_CM_PER_DSS_CDOFFS		0x0a00
#define AM43XX_CM_PER_CPSW_CDOFFS		0x0b00
#define AM43XX_CM_PER_OCPWP_L3_CDOFFS		0x0c00

/* CM */

/* CM.CM_WKUP register offsets */
#define AM43XX_CM_L3_AON_CLKSTCTRL_OFFSET		0x0000
#define AM43XX_CM_L3_AON_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0000)
#define AM43XX_CM_WKUP_DEBUGSS_CLKCTRL_OFFSET		0x0020
#define AM43XX_CM_WKUP_DEBUGSS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0020)
#define AM43XX_CM_L3S_TSC_CLKSTCTRL_OFFSET		0x0100
#define AM43XX_CM_L3S_TSC_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0100)
#define AM43XX_CM_L4_WKUP_AON_CLKSTCTRL_OFFSET		0x0200
#define AM43XX_CM_L4_WKUP_AON_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0200)
#define AM43XX_CM_WKUP_L4WKUP_CLKCTRL_OFFSET		0x0220
#define AM43XX_CM_WKUP_L4WKUP_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0220)
#define AM43XX_CM_WKUP_WKUP_M3_CLKCTRL_OFFSET		0x0228
#define AM43XX_CM_WKUP_WKUP_M3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0228)
#define AM43XX_CM_WKUP_SYNCTIMER_CLKCTRL_OFFSET		0x0230
#define AM43XX_CM_WKUP_SYNCTIMER_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0230)
#define AM43XX_CM_WKUP_CLKDIV32K_CLKCTRL_OFFSET		0x0238
#define AM43XX_CM_WKUP_CLKDIV32K_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0238)
#define AM43XX_CM_WKUP_USBPHY0_CLKCTRL_OFFSET		0x0240
#define AM43XX_CM_WKUP_USBPHY0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0240)
#define AM43XX_CM_WKUP_USBPHY1_CLKCTRL_OFFSET		0x0248
#define AM43XX_CM_WKUP_USBPHY1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0248)
#define AM43XX_CM_WKUP_CLKSTCTRL_OFFSET			0x0300
#define AM43XX_CM_WKUP_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0300)
#define AM43XX_CM_WKUP_TIMER0_CLKCTRL_OFFSET		0x0320
#define AM43XX_CM_WKUP_TIMER0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0320)
#define AM43XX_CM_WKUP_TIMER1_CLKCTRL_OFFSET		0x0328
#define AM43XX_CM_WKUP_TIMER1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0328)
#define AM43XX_CM_WKUP_WDT0_CLKCTRL_OFFSET		0x0330
#define AM43XX_CM_WKUP_WDT0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0330)
#define AM43XX_CM_WKUP_WDT1_CLKCTRL_OFFSET		0x0338
#define AM43XX_CM_WKUP_WDT1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0338)
#define AM43XX_CM_WKUP_I2C0_CLKCTRL_OFFSET		0x0340
#define AM43XX_CM_WKUP_I2C0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0340)
#define AM43XX_CM_WKUP_UART0_CLKCTRL_OFFSET		0x0348
#define AM43XX_CM_WKUP_UART0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0348)
#define AM43XX_CM_WKUP_SMARTREFLEX0_CLKCTRL_OFFSET	0x0350
#define AM43XX_CM_WKUP_SMARTREFLEX0_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0350)
#define AM43XX_CM_WKUP_SMARTREFLEX1_CLKCTRL_OFFSET	0x0358
#define AM43XX_CM_WKUP_SMARTREFLEX1_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0358)
#define AM43XX_CM_WKUP_CONTROL_CLKCTRL_OFFSET		0x0360
#define AM43XX_CM_WKUP_CONTROL_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0360)
#define AM43XX_CM_WKUP_GPIO0_CLKCTRL_OFFSET		0x0368
#define AM43XX_CM_WKUP_GPIO0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0368)
#define AM43XX_CM_CLKMODE_DPLL_CORE_OFFSET		0x0520
#define AM43XX_CM_CLKMODE_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0520)
#define AM43XX_CM_IDLEST_DPLL_CORE_OFFSET		0x0524
#define AM43XX_CM_IDLEST_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0524)
#define AM43XX_CM_CLKSEL_DPLL_CORE_OFFSET		0x052c
#define AM43XX_CM_CLKSEL_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x052c)
#define AM43XX_CM_DIV_M4_DPLL_CORE_OFFSET		0x0538
#define AM43XX_CM_DIV_M4_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0538)
#define AM43XX_CM_DIV_M5_DPLL_CORE_OFFSET		0x053c
#define AM43XX_CM_DIV_M5_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x053c)
#define AM43XX_CM_DIV_M6_DPLL_CORE_OFFSET		0x0540
#define AM43XX_CM_DIV_M6_DPLL_CORE			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0540)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_CORE_OFFSET	0x0548
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_CORE		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0548)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_CORE_OFFSET	0x054c
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_CORE		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x054c)
#define AM43XX_CM_CLKMODE_DPLL_MPU_OFFSET		0x0560
#define AM43XX_CM_CLKMODE_DPLL_MPU			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0560)
#define AM43XX_CM_IDLEST_DPLL_MPU_OFFSET		0x0564
#define AM43XX_CM_IDLEST_DPLL_MPU			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0564)
#define AM43XX_CM_CLKSEL_DPLL_MPU_OFFSET		0x056c
#define AM43XX_CM_CLKSEL_DPLL_MPU			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x056c)
#define AM43XX_CM_DIV_M2_DPLL_MPU_OFFSET		0x0570
#define AM43XX_CM_DIV_M2_DPLL_MPU			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0570)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_MPU_OFFSET	0x0588
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_MPU		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0588)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_MPU_OFFSET	0x058c
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_MPU		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x058c)
#define AM43XX_CM_CLKMODE_DPLL_DDR_OFFSET		0x05a0
#define AM43XX_CM_CLKMODE_DPLL_DDR			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05a0)
#define AM43XX_CM_IDLEST_DPLL_DDR_OFFSET		0x05a4
#define AM43XX_CM_IDLEST_DPLL_DDR			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05a4)
#define AM43XX_CM_CLKSEL_DPLL_DDR_OFFSET		0x05ac
#define AM43XX_CM_CLKSEL_DPLL_DDR			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05ac)
#define AM43XX_CM_DIV_M2_DPLL_DDR_OFFSET		0x05b0
#define AM43XX_CM_DIV_M2_DPLL_DDR			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05b0)
#define AM43XX_CM_DIV_M4_DPLL_DDR_OFFSET		0x05b8
#define AM43XX_CM_DIV_M4_DPLL_DDR			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05b8)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_DDR_OFFSET	0x05c8
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_DDR		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05c8)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_DDR_OFFSET	0x05cc
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_DDR		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05cc)
#define AM43XX_CM_CLKMODE_DPLL_PER_OFFSET		0x05e0
#define AM43XX_CM_CLKMODE_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05e0)
#define AM43XX_CM_IDLEST_DPLL_PER_OFFSET		0x05e4
#define AM43XX_CM_IDLEST_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05e4)
#define AM43XX_CM_CLKSEL_DPLL_PER_OFFSET		0x05ec
#define AM43XX_CM_CLKSEL_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05ec)
#define AM43XX_CM_DIV_M2_DPLL_PER_OFFSET		0x05f0
#define AM43XX_CM_DIV_M2_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x05f0)
#define AM43XX_CM_CLKSEL2_DPLL_PER_OFFSET		0x0604
#define AM43XX_CM_CLKSEL2_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0604)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_PER_OFFSET	0x0608
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_PER		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0608)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_PER_OFFSET	0x060c
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_PER		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x060c)
#define AM43XX_CM_CLKDCOLDO_DPLL_PER_OFFSET		0x0614
#define AM43XX_CM_CLKDCOLDO_DPLL_PER			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0614)
#define AM43XX_CM_CLKMODE_DPLL_DISP_OFFSET		0x0620
#define AM43XX_CM_CLKMODE_DPLL_DISP			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0620)
#define AM43XX_CM_IDLEST_DPLL_DISP_OFFSET		0x0624
#define AM43XX_CM_IDLEST_DPLL_DISP			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0624)
#define AM43XX_CM_CLKSEL_DPLL_DISP_OFFSET		0x062c
#define AM43XX_CM_CLKSEL_DPLL_DISP			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x062c)
#define AM43XX_CM_DIV_M2_DPLL_DISP_OFFSET		0x0630
#define AM43XX_CM_DIV_M2_DPLL_DISP			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0630)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_DISP_OFFSET	0x0648
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_DISP		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0648)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_DISP_OFFSET	0x064c
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_DISP		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x064c)
#define AM43XX_CM_CLKMODE_DPLL_EXTDEV_OFFSET		0x0660
#define AM43XX_CM_CLKMODE_DPLL_EXTDEV			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0660)
#define AM43XX_CM_IDLEST_DPLL_EXTDEV_OFFSET		0x0664
#define AM43XX_CM_IDLEST_DPLL_EXTDEV			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0664)
#define AM43XX_CM_CLKSEL_DPLL_EXTDEV_OFFSET		0x066c
#define AM43XX_CM_CLKSEL_DPLL_EXTDEV			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x066c)
#define AM43XX_CM_DIV_M2_DPLL_EXTDEV_OFFSET		0x0670
#define AM43XX_CM_DIV_M2_DPLL_EXTDEV			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0670)
#define AM43XX_CM_CLKSEL2_DPLL_EXTDEV_OFFSET		0x0684
#define AM43XX_CM_CLKSEL2_DPLL_EXTDEV			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0684)
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_EXTDEV_OFFSET	0x0688
#define AM43XX_CM_SSC_DELTAMSTEP_DPLL_EXTDEV		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x0688)
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_EXTDEV_OFFSET	0x068c
#define AM43XX_CM_SSC_MODFREQDIV_DPLL_EXTDEV		AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x068c)
#define AM43XX_CM_SHADOW_FREQ_CONFIG1_OFFSET		0x07a0
#define AM43XX_CM_SHADOW_FREQ_CONFIG1			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x07a0)
#define AM43XX_CM_SHADOW_FREQ_CONFIG2_OFFSET		0x07a4
#define AM43XX_CM_SHADOW_FREQ_CONFIG2			AM43XX_CM_REGADDR(AM43XX_CM_WKUP_INST, 0x07a4)

/* CM.CM_DEVICE register offsets */
#define AM43XX_CM_CLKOUT1_CTRL_OFFSET			0x0000
#define AM43XX_CM_CLKOUT1_CTRL				AM43XX_CM_REGADDR(AM43XX_CM_DEVICE_INST, 0x0000)
#define AM43XX_CM_DLL_CTRL_OFFSET			0x0004
#define AM43XX_CM_DLL_CTRL				AM43XX_CM_REGADDR(AM43XX_CM_DEVICE_INST, 0x0004)
#define AM43XX_CM_CLKOUT2_CTRL_OFFSET			0x0008
#define AM43XX_CM_CLKOUT2_CTRL				AM43XX_CM_REGADDR(AM43XX_CM_DEVICE_INST, 0x0008)

/* CM.CM_DPLL register offsets */
#define AM43XX_CLKSEL_TIMER1MS_CLK_OFFSET		0x0000
#define AM43XX_CLKSEL_TIMER1MS_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0000)
#define AM43XX_CLKSEL_TIMER2_CLK_OFFSET			0x0004
#define AM43XX_CLKSEL_TIMER2_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0004)
#define AM43XX_CLKSEL_TIMER3_CLK_OFFSET			0x0008
#define AM43XX_CLKSEL_TIMER3_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0008)
#define AM43XX_CLKSEL_TIMER4_CLK_OFFSET			0x000c
#define AM43XX_CLKSEL_TIMER4_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x000c)
#define AM43XX_CLKSEL_TIMER5_CLK_OFFSET			0x0010
#define AM43XX_CLKSEL_TIMER5_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0010)
#define AM43XX_CLKSEL_TIMER6_CLK_OFFSET			0x0014
#define AM43XX_CLKSEL_TIMER6_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0014)
#define AM43XX_CLKSEL_TIMER7_CLK_OFFSET			0x0018
#define AM43XX_CLKSEL_TIMER7_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0018)
#define AM43XX_CLKSEL_TIMER8_CLK_OFFSET			0x001c
#define AM43XX_CLKSEL_TIMER8_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x001c)
#define AM43XX_CLKSEL_TIMER9_CLK_OFFSET			0x0020
#define AM43XX_CLKSEL_TIMER9_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0020)
#define AM43XX_CLKSEL_TIMER10_CLK_OFFSET		0x0024
#define AM43XX_CLKSEL_TIMER10_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0024)
#define AM43XX_CLKSEL_TIMER11_CLK_OFFSET		0x0028
#define AM43XX_CLKSEL_TIMER11_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0028)
#define AM43XX_CLKSEL_WDT1_CLK_OFFSET			0x002c
#define AM43XX_CLKSEL_WDT1_CLK				AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x002c)
#define AM43XX_CLKSEL_SYNCTIMER_CLK_OFFSET		0x0030
#define AM43XX_CLKSEL_SYNCTIMER_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0030)
#define AM43XX_CLKSEL_MAC_CLK_OFFSET			0x0034
#define AM43XX_CLKSEL_MAC_CLK				AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0034)
#define AM43XX_CLKSEL_CPTS_RFT_CLK_OFFSET		0x0038
#define AM43XX_CLKSEL_CPTS_RFT_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0038)
#define AM43XX_CLKSEL_GFX_FCLK_OFFSET			0x003c
#define AM43XX_CLKSEL_GFX_FCLK				AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x003c)
#define AM43XX_CLKSEL_GPIO0_DBCLK_OFFSET		0x0040
#define AM43XX_CLKSEL_GPIO0_DBCLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0040)
#define AM43XX_CLKSEL_LCDC_PIXEL_CLK_OFFSET		0x0044
#define AM43XX_CLKSEL_LCDC_PIXEL_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0044)
#define AM43XX_CLKSEL_ICSS_OCP_CLK_OFFSET		0x0048
#define AM43XX_CLKSEL_ICSS_OCP_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0048)
#define AM43XX_CLKSEL_MAG_CARD_CLK_OFFSET		0x004c
#define AM43XX_CLKSEL_MAG_CARD_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x004c)
#define AM43XX_CLKSEL_DLL_AGING_CLK_OFFSET		0x0050
#define AM43XX_CLKSEL_DLL_AGING_CLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0050)
#define AM43XX_CLKSEL_USIM0_FCLK_OFFSET			0x0054
#define AM43XX_CLKSEL_USIM0_FCLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0054)
#define AM43XX_CLKSEL_USIM1_FCLK_OFFSET			0x0058
#define AM43XX_CLKSEL_USIM1_FCLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0058)
#define AM43XX_CLKSEL_USIM_DBCLK_OFFSET			0x005c
#define AM43XX_CLKSEL_USIM_DBCLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x005c)
#define AM43XX_CLKSEL_USBPHY32KHZ_GCLK_OFFSET		0x0060
#define AM43XX_CLKSEL_USBPHY32KHZ_GCLK			AM43XX_CM_REGADDR(AM43XX_CM_DPLL_INST, 0x0060)

/* CM.CM_MPU register offsets */
#define AM43XX_CM_MPU_CLKSTCTRL_OFFSET			0x0000
#define AM43XX_CM_MPU_CLKSTCTRL				AM43XX_CM_REGADDR(AM43XX_CM_MPU_INST, 0x0000)
#define AM43XX_CM_MPU_MPU_CLKCTRL_OFFSET		0x0020
#define AM43XX_CM_MPU_MPU_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_MPU_INST, 0x0020)

/* CM.CM_GFX register offsets */
#define AM43XX_CM_GFX_L3_CLKSTCTRL_OFFSET		0x0000
#define AM43XX_CM_GFX_L3_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_GFX_INST, 0x0000)
#define AM43XX_CM_GFX_GFX_CLKCTRL_OFFSET		0x0020
#define AM43XX_CM_GFX_GFX_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_GFX_INST, 0x0020)

/* CM.CM_RTC register offsets */

/* CM.CM_TAMPER register offsets */
#define AM43XX_CM_TAMPER_CLKSTCTRL_OFFSET		0x0000
#define AM43XX_CM_TAMPER_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_TAMPER_INST, 0x0000)
#define AM43XX_CM_TAMPER_TPMSS_CLKCTRL_OFFSET		0x0020
#define AM43XX_CM_TAMPER_TPMSS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_TAMPER_INST, 0x0020)

/* CM.CM_CEFUSE register offsets */
#define AM43XX_CM_CEFUSE_CLKSTCTRL_OFFSET		0x0000
#define AM43XX_CM_CEFUSE_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_CEFUSE_INST, 0x0000)
#define AM43XX_CM_CEFUSE_CEFUSE_CLKCTRL_OFFSET		0x0020
#define AM43XX_CM_CEFUSE_CEFUSE_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_CEFUSE_INST, 0x0020)

/* CM.CM_PER register offsets */
#define AM43XX_CM_PER_L3_CLKSTCTRL_OFFSET		0x0000
#define AM43XX_CM_PER_L3_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0000)
#define AM43XX_CM_PER_L3_CLKCTRL_OFFSET			0x0020
#define AM43XX_CM_PER_L3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0020)
#define AM43XX_CM_PER_AES0_CLKCTRL_OFFSET		0x0028
#define AM43XX_CM_PER_AES0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0028)
#define AM43XX_CM_PER_DES_CLKCTRL_OFFSET		0x0030
#define AM43XX_CM_PER_DES_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0030)
#define AM43XX_CM_PER_CRYPTODMA_CLKCTRL_OFFSET		0x0038
#define AM43XX_CM_PER_CRYPTODMA_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0038)
#define AM43XX_CM_PER_L3_INSTR_CLKCTRL_OFFSET		0x0040
#define AM43XX_CM_PER_L3_INSTR_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0040)
#define AM43XX_CM_PER_MSTR_EXPS_CLKCTRL_OFFSET		0x0048
#define AM43XX_CM_PER_MSTR_EXPS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0048)
#define AM43XX_CM_PER_OCMCRAM_CLKCTRL_OFFSET		0x0050
#define AM43XX_CM_PER_OCMCRAM_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0050)
#define AM43XX_CM_PER_SHA0_CLKCTRL_OFFSET		0x0058
#define AM43XX_CM_PER_SHA0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0058)
#define AM43XX_CM_PER_SLV_EXPS_CLKCTRL_OFFSET		0x0060
#define AM43XX_CM_PER_SLV_EXPS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0060)
#define AM43XX_CM_PER_VPFE0_CLKCTRL_OFFSET		0x0068
#define AM43XX_CM_PER_VPFE0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0068)
#define AM43XX_CM_PER_VPFE1_CLKCTRL_OFFSET		0x0070
#define AM43XX_CM_PER_VPFE1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0070)
#define AM43XX_CM_PER_TPCC_CLKCTRL_OFFSET		0x0078
#define AM43XX_CM_PER_TPCC_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0078)
#define AM43XX_CM_PER_TPTC0_CLKCTRL_OFFSET		0x0080
#define AM43XX_CM_PER_TPTC0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0080)
#define AM43XX_CM_PER_TPTC1_CLKCTRL_OFFSET		0x0088
#define AM43XX_CM_PER_TPTC1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0088)
#define AM43XX_CM_PER_TPTC2_CLKCTRL_OFFSET		0x0090
#define AM43XX_CM_PER_TPTC2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0090)
#define AM43XX_CM_PER_DLL_AGING_CLKCTRL_OFFSET		0x0098
#define AM43XX_CM_PER_DLL_AGING_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0098)
#define AM43XX_CM_PER_L4HS_CLKCTRL_OFFSET		0x00a0
#define AM43XX_CM_PER_L4HS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x00a0)
#define AM43XX_CM_PER_L4FW_CLKCTRL_OFFSET		0x00a8
#define AM43XX_CM_PER_L4FW_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x00a8)
#define AM43XX_CM_PER_L3S_CLKSTCTRL_OFFSET		0x0200
#define AM43XX_CM_PER_L3S_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0200)
#define AM43XX_CM_PER_GPMC_CLKCTRL_OFFSET		0x0220
#define AM43XX_CM_PER_GPMC_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0220)
#define AM43XX_CM_PER_IEEE5000_CLKCTRL_OFFSET		0x0228
#define AM43XX_CM_PER_IEEE5000_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0228)
#define AM43XX_CM_PER_MAG_CARD_CLKCTRL_OFFSET		0x0230
#define AM43XX_CM_PER_MAG_CARD_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0230)
#define AM43XX_CM_PER_MCASP0_CLKCTRL_OFFSET		0x0238
#define AM43XX_CM_PER_MCASP0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0238)
#define AM43XX_CM_PER_MCASP1_CLKCTRL_OFFSET		0x0240
#define AM43XX_CM_PER_MCASP1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0240)
#define AM43XX_CM_PER_MMC2_CLKCTRL_OFFSET		0x0248
#define AM43XX_CM_PER_MMC2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0248)
#define AM43XX_CM_PER_QSPI_CLKCTRL_OFFSET		0x0258
#define AM43XX_CM_PER_QSPI_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0258)
#define AM43XX_CM_PER_USB_OTG_SS0_CLKCTRL_OFFSET	0x0260
#define AM43XX_CM_PER_USB_OTG_SS0_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0260)
#define AM43XX_CM_PER_USB_OTG_SS1_CLKCTRL_OFFSET	0x0268
#define AM43XX_CM_PER_USB_OTG_SS1_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0268)
#define AM43XX_CM_PER_ICSS_CLKSTCTRL_OFFSET		0x0300
#define AM43XX_CM_PER_ICSS_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0300)
#define AM43XX_CM_PER_ICSS_CLKCTRL_OFFSET		0x0320
#define AM43XX_CM_PER_ICSS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0320)
#define AM43XX_CM_PER_L4LS_CLKSTCTRL_OFFSET		0x0400
#define AM43XX_CM_PER_L4LS_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0400)
#define AM43XX_CM_PER_L4LS_CLKCTRL_OFFSET		0x0420
#define AM43XX_CM_PER_L4LS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0420)
#define AM43XX_CM_PER_DCAN0_CLKCTRL_OFFSET		0x0428
#define AM43XX_CM_PER_DCAN0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0428)
#define AM43XX_CM_PER_DCAN1_CLKCTRL_OFFSET		0x0430
#define AM43XX_CM_PER_DCAN1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0430)
#define AM43XX_CM_PER_EPWMSS0_CLKCTRL_OFFSET		0x0438
#define AM43XX_CM_PER_EPWMSS0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0438)
#define AM43XX_CM_PER_EPWMSS1_CLKCTRL_OFFSET		0x0440
#define AM43XX_CM_PER_EPWMSS1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0440)
#define AM43XX_CM_PER_EPWMSS2_CLKCTRL_OFFSET		0x0448
#define AM43XX_CM_PER_EPWMSS2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0448)
#define AM43XX_CM_PER_EPWMSS3_CLKCTRL_OFFSET		0x0450
#define AM43XX_CM_PER_EPWMSS3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0450)
#define AM43XX_CM_PER_EPWMSS4_CLKCTRL_OFFSET		0x0458
#define AM43XX_CM_PER_EPWMSS4_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0458)
#define AM43XX_CM_PER_EPWMSS5_CLKCTRL_OFFSET		0x0460
#define AM43XX_CM_PER_EPWMSS5_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0460)
#define AM43XX_CM_PER_ELM_CLKCTRL_OFFSET		0x0468
#define AM43XX_CM_PER_ELM_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0468)
#define AM43XX_CM_PER_ERMC_CLKCTRL_OFFSET		0x0470
#define AM43XX_CM_PER_ERMC_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0470)
#define AM43XX_CM_PER_GPIO1_CLKCTRL_OFFSET		0x0478
#define AM43XX_CM_PER_GPIO1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0478)
#define AM43XX_CM_PER_GPIO2_CLKCTRL_OFFSET		0x0480
#define AM43XX_CM_PER_GPIO2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0480)
#define AM43XX_CM_PER_GPIO3_CLKCTRL_OFFSET		0x0488
#define AM43XX_CM_PER_GPIO3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0488)
#define AM43XX_CM_PER_GPIO4_CLKCTRL_OFFSET		0x0490
#define AM43XX_CM_PER_GPIO4_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0490)
#define AM43XX_CM_PER_GPIO5_CLKCTRL_OFFSET		0x0498
#define AM43XX_CM_PER_GPIO5_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0498)
#define AM43XX_CM_PER_HDQ1W_CLKCTRL_OFFSET		0x04a0
#define AM43XX_CM_PER_HDQ1W_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04a0)
#define AM43XX_CM_PER_I2C1_CLKCTRL_OFFSET		0x04a8
#define AM43XX_CM_PER_I2C1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04a8)
#define AM43XX_CM_PER_I2C2_CLKCTRL_OFFSET		0x04b0
#define AM43XX_CM_PER_I2C2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04b0)
#define AM43XX_CM_PER_MAILBOX0_CLKCTRL_OFFSET		0x04b8
#define AM43XX_CM_PER_MAILBOX0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04b8)
#define AM43XX_CM_PER_MMC0_CLKCTRL_OFFSET		0x04c0
#define AM43XX_CM_PER_MMC0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04c0)
#define AM43XX_CM_PER_MMC1_CLKCTRL_OFFSET		0x04c8
#define AM43XX_CM_PER_MMC1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04c8)
#define AM43XX_CM_PER_PKA_CLKCTRL_OFFSET		0x04d0
#define AM43XX_CM_PER_PKA_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04d0)
#define AM43XX_CM_PER_RNG_CLKCTRL_OFFSET		0x04e0
#define AM43XX_CM_PER_RNG_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04e0)
#define AM43XX_CM_PER_SPARE0_CLKCTRL_OFFSET		0x04e8
#define AM43XX_CM_PER_SPARE0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04e8)
#define AM43XX_CM_PER_SPARE1_CLKCTRL_OFFSET		0x04f0
#define AM43XX_CM_PER_SPARE1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x04f0)
#define AM43XX_CM_PER_SPI0_CLKCTRL_OFFSET		0x0500
#define AM43XX_CM_PER_SPI0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0500)
#define AM43XX_CM_PER_SPI1_CLKCTRL_OFFSET		0x0508
#define AM43XX_CM_PER_SPI1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0508)
#define AM43XX_CM_PER_SPI2_CLKCTRL_OFFSET		0x0510
#define AM43XX_CM_PER_SPI2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0510)
#define AM43XX_CM_PER_SPI3_CLKCTRL_OFFSET		0x0518
#define AM43XX_CM_PER_SPI3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0518)
#define AM43XX_CM_PER_SPI4_CLKCTRL_OFFSET		0x0520
#define AM43XX_CM_PER_SPI4_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0520)
#define AM43XX_CM_PER_SPINLOCK_CLKCTRL_OFFSET		0x0528
#define AM43XX_CM_PER_SPINLOCK_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0528)
#define AM43XX_CM_PER_TIMER2_CLKCTRL_OFFSET		0x0530
#define AM43XX_CM_PER_TIMER2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0530)
#define AM43XX_CM_PER_TIMER3_CLKCTRL_OFFSET		0x0538
#define AM43XX_CM_PER_TIMER3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0538)
#define AM43XX_CM_PER_TIMER4_CLKCTRL_OFFSET		0x0540
#define AM43XX_CM_PER_TIMER4_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0540)
#define AM43XX_CM_PER_TIMER5_CLKCTRL_OFFSET		0x0548
#define AM43XX_CM_PER_TIMER5_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0548)
#define AM43XX_CM_PER_TIMER6_CLKCTRL_OFFSET		0x0550
#define AM43XX_CM_PER_TIMER6_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0550)
#define AM43XX_CM_PER_TIMER7_CLKCTRL_OFFSET		0x0558
#define AM43XX_CM_PER_TIMER7_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0558)
#define AM43XX_CM_PER_TIMER8_CLKCTRL_OFFSET		0x0560
#define AM43XX_CM_PER_TIMER8_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0560)
#define AM43XX_CM_PER_TIMER9_CLKCTRL_OFFSET		0x0568
#define AM43XX_CM_PER_TIMER9_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0568)
#define AM43XX_CM_PER_TIMER10_CLKCTRL_OFFSET		0x0570
#define AM43XX_CM_PER_TIMER10_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0570)
#define AM43XX_CM_PER_TIMER11_CLKCTRL_OFFSET		0x0578
#define AM43XX_CM_PER_TIMER11_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0578)
#define AM43XX_CM_PER_UART1_CLKCTRL_OFFSET		0x0580
#define AM43XX_CM_PER_UART1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0580)
#define AM43XX_CM_PER_UART2_CLKCTRL_OFFSET		0x0588
#define AM43XX_CM_PER_UART2_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0588)
#define AM43XX_CM_PER_UART3_CLKCTRL_OFFSET		0x0590
#define AM43XX_CM_PER_UART3_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0590)
#define AM43XX_CM_PER_UART4_CLKCTRL_OFFSET		0x0598
#define AM43XX_CM_PER_UART4_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0598)
#define AM43XX_CM_PER_UART5_CLKCTRL_OFFSET		0x05a0
#define AM43XX_CM_PER_UART5_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x05a0)
#define AM43XX_CM_PER_USIM0_CLKCTRL_OFFSET		0x05a8
#define AM43XX_CM_PER_USIM0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x05a8)
#define AM43XX_CM_PER_USIM1_CLKCTRL_OFFSET		0x05b0
#define AM43XX_CM_PER_USIM1_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x05b0)
#define AM43XX_CM_PER_USBPHYOCP2SCP0_CLKCTRL_OFFSET	0x05b8
#define AM43XX_CM_PER_USBPHYOCP2SCP0_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x05b8)
#define AM43XX_CM_PER_USBPHYOCP2SCP1_CLKCTRL_OFFSET	0x05c0
#define AM43XX_CM_PER_USBPHYOCP2SCP1_CLKCTRL		AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x05c0)
#define AM43XX_CM_PER_EMIF_CLKSTCTRL_OFFSET		0x0700
#define AM43XX_CM_PER_EMIF_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0700)
#define AM43XX_CM_PER_EMIF_CLKCTRL_OFFSET		0x0720
#define AM43XX_CM_PER_EMIF_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0720)
#define AM43XX_CM_PER_DLL_CLKCTRL_OFFSET		0x0728
#define AM43XX_CM_PER_DLL_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0728)
#define AM43XX_CM_PER_EMIF_FW_CLKCTRL_OFFSET		0x0730
#define AM43XX_CM_PER_EMIF_FW_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0730)
#define AM43XX_CM_PER_OTFA_EMIF_CLKCTRL_OFFSET		0x0738
#define AM43XX_CM_PER_OTFA_EMIF_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0738)
#define AM43XX_CM_PER_LCDC_CLKSTCTRL_OFFSET		0x0800
#define AM43XX_CM_PER_LCDC_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0800)
#define AM43XX_CM_PER_LCDC_CLKCTRL_OFFSET		0x0820
#define AM43XX_CM_PER_LCDC_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0820)
#define AM43XX_CM_PER_DSS_CLKSTCTRL_OFFSET		0x0a00
#define AM43XX_CM_PER_DSS_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0a00)
#define AM43XX_CM_PER_DSS_CLKCTRL_OFFSET		0x0a20
#define AM43XX_CM_PER_DSS_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0a20)
#define AM43XX_CM_PER_CPSW_CLKSTCTRL_OFFSET		0x0b00
#define AM43XX_CM_PER_CPSW_CLKSTCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0b00)
#define AM43XX_CM_PER_CPGMAC0_CLKCTRL_OFFSET		0x0b20
#define AM43XX_CM_PER_CPGMAC0_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0b20)
#define AM43XX_CM_PER_OCPWP_L3_CLKSTCTRL_OFFSET		0x0c00
#define AM43XX_CM_PER_OCPWP_L3_CLKSTCTRL		AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0c00)
#define AM43XX_CM_PER_OCPWP_CLKCTRL_OFFSET		0x0c20
#define AM43XX_CM_PER_OCPWP_CLKCTRL			AM43XX_CM_REGADDR(AM43XX_CM_PER_INST, 0x0c20)

/* PRCM RMW helper macros */

/* AM43XX MPU PWR DOMAIN */

#define AM43XX_MPU_RAM_RETSTATE_MASK				(0x1 << 8)
#define AM43XX_MPU_RAM_RETSTATE_SHIFT				(8)

#define AM43XX_MPU_L2_RETSTATE_MASK				(0x1 << 10)
#define AM43XX_MPU_L2_RETSTATE_SHIFT				(10)

#define AM43XX_MPU_L1_RETSTATE_MASK				(0x1 << 9)
#define AM43XX_MPU_L1_RETSTATE_SHIFT				(9)

#define AM43XX_MPU_LOWPOWERSTATECHANGE_MASK			(0x1 << 4)
#define AM43XX_MPU_LOWPOWERSTATECHANGE_SHIFT			(4)

#define AM43XX_MPU_LOGICRETSTATE_MASK				(0x1 << 2)
#define AM43XX_MPU_LOGICRETSTATE_SHIFT				(2)

#define AM43XX_MPU_POWERSTATE_MASK				(0x3 << 0)
#define AM43XX_MPU_POWERSTATE_SHIFT				(0)

/* AM43XX PER PWR DOMAIN */

#define AM43XX_PER_ICSS_MEM_RETSTATE_MASK			(0x1 << 8)
#define AM43XX_PER_ICSS_MEM_RETSTATE_SHIFT			(8)

#define AM43XX_PER_MEM_RETSTATE_MASK				(0x1 << 9)
#define AM43XX_PER_MEM_RETSTATE_SHIFT				(9)

#define AM43XX_PER_RAM1_MEM_RETSTATE_MASK			(0x1 << 10)
#define AM43XX_PER_RAM1_MEM_RETSTATE_SHIFT			(10)

#define AM43XX_PER_RAM2_MEM_RETSTATE_MASK			(0x1 << 11)
#define AM43XX_PER_RAM2_MEM_RETSTATE_SHIFT			(11)

#define AM43XX_PER_LOWPOWERSTATECHANGE_MASK			(0x1 << 4)
#define AM43XX_PER_LOWPOWERSTATECHANGE_SHIFT			(4)

#define AM43XX_PER_LOGICRETSTATE_MASK				(0x1 << 2)
#define AM43XX_PER_LOGICRETSTATE_SHIFT				(2)

#define AM43XX_PER_POWERSTATE_MASK				(0x3 << 0)
#define AM43XX_PER_POWERSTATE_SHIFT				(0)

#endif
