/* 
 * command.c : command list
 * version 0.0.3 - Copyright (C) 2002-2003 Alessandro Fausto
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *	Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.
 *
 *	Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *
 *	Neither the name of the author nor the names of the contributors may
 *	be used to endorse or promote products derived from this software 
 *	without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To contact me write at:
 *             fareale@libero.it
 *   for bugs: fareale.bug@libero.it
 */

/*
 * v 0.03 :
 * 	- changed led menagement procedure structure and logic
 * v 0.0B1 : 28/04/2002
 */

#include <linux/input.h>
#include <linux/ioctl.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <time.h>

#include "debug.h"
#include "command.h"

#define DEBUGNAME         "CMD: "
//#define INLINECMD         1

#define MAX_CMD_LEN 128
#define ON_PRESS       1
#define ON_RELEASE     2
#define ON_REPEAT      4


struct CMD * cmd = NULL ;

void exec( char * command)
{
	if( fork() == 0) {
		char ** tmp ;
		int i ;
		
		// CHILD Process
		d2printf( "command to execute is\n%s\n", command) ;
		strtok( command, " ") ;
		d2printf( "program is %s\n", command) ;
		i = 0 ;
		tmp = (char **) malloc( sizeof( char *)) ;
		tmp[ 0] = command ;
		do {
			printf( "argv%d is %s\n", i, tmp[i]) ;
			i++ ;
		        tmp = (char **) realloc( tmp, (i+1) * sizeof( char *)) ;
		} while( (tmp[ i] = strtok( NULL, " ")) != NULL) ; 
		execv( command, tmp) ;
		perror( "ERROR: execv") ;
		exit( 1) ;
	} // end if( fork())
}

int getNumberofEntry()
{
	struct CMD * tmp ;
	int count ;

	if( cmd) {
		for( tmp = cmd, count = 0 ; 
		     tmp->command[ 0] != '\0' && tmp->code != 0 && tmp->mode != 0 ;
		     tmp++, count++) 
			;
		return count ;
	}
	return -1 ;
}

const struct CMD * getCommand( int pos)
{
	struct CMD * tmp ;

	if( (tmp = cmd) != NULL) {
		for( tmp = cmd ; 
		     tmp->command[ 0] != '\0' && tmp->code != 0 && tmp->mode != 0 ;
		     tmp++) {
			if( pos-- == 0) break ; 
		}
	}
	return tmp ;
}

const struct CMD * findCommand( unsigned short code, int value)
{
	struct CMD * tmp ;

	if( (tmp = cmd) != NULL) {
		for( tmp = cmd ; 
		     tmp->command[ 0] != '\0' && tmp->code != 0 && tmp->mode != 0 ;
		     tmp++) {
			if( (code == tmp->code) &&
			    ( ((tmp->mode & ON_PRESS) && (value == 1)) ||
			      ((tmp->mode & ON_RELEASE) && (value == 0)) ||
			      ((tmp->mode & ON_REPEAT) && (value == 2)) )
			    )
				return tmp ;
		}
	}
	return NULL ;
}

int executeCommand( unsigned short code, int value)
{
	char * eventValue[ 4] = { "RELEASE", "PRESS", "REPEAT", NULL} ;
	const struct CMD * tmp ;

	tmp = findCommand( code, value) ;
	
	if( tmp) {
		exec( tmp->command) ;
		return 1 ;
	} else { 
		fprintf( stderr, "no command found for key %d, event %s\n", 
			 code, eventValue[ value]) ;
		return 0 ; 
	} // end if( tmp)
}

int addCommand( char * command, unsigned short code, unsigned short mode)
{
	struct CMD * tmp ;
	int count ;
	
        count = getNumberofEntry( cmd) ;
	if( count >= 0) { 
		cmd = (struct CMD *) realloc( cmd, 
				              (count+2)*sizeof( struct CMD)) ;
		if( cmd) {
			strncpy( cmd[ count].command, command, MAX_CMD_LEN) ;
			cmd[ count].code = code ;
			cmd[ count].mode = mode ;
			bzero( &cmd[ count + 1], sizeof( struct CMD)) ;
		}
		return 1 ;
	}
	return 0 ;
}


int InitCommand()
{
	int i ;
	
	cmd = (struct CMD *) malloc( sizeof( struct CMD)) ;
	if( cmd) {
		bzero( cmd, sizeof( struct CMD)) ;
		
#ifdef INLINECMD
 	  	addCommand( "toggleshutdown.sh", 1, ON_RELEASE) ;
 		addCommand( "/etc/init.d/iptables start", 88, ON_PRESS) ;
 		addCommand( "/etc/init.d/iptables stop", 87, ON_PRESS) ;
		addCommand( "/etc/init.d/nfs start", 68, ON_PRESS) ;
		addCommand( "/etc/init.d/nfs stop", 67, ON_PRESS) ;
		
		addCommand( "/sbin/modprobe ppa", 13, ON_PRESS) ;
		addCommand( "/sbin/modprobe -r ppa", 12, ON_RELEASE) ;

		addCommand( "/usr/local/bin/rele CAM on", 11, ON_PRESS) ;
		addCommand( "/usr/local/bin/rele CAM off", 10, ON_RELEASE) ;
#endif
	}

	return 1 ;
}

#define LEDNUM 3
int ledcode[ LEDNUM] = { LED_NUML, LED_CAPSL, LED_SCROLLL} ;
int leds = 0 ;

void ledSet( int fd, int mask) 
{
	int i, bit = 1 ;
	struct input_event event ;
		
	event.type = EV_LED ;
	event.value = 1 ;
	for( i = 0 ; i < LEDNUM ; i++, bit = bit << 1)
		if( mask & bit) {
			event.code = ledcode[ i] ;
			write( fd, &event, sizeof( event)) ;
		}
	leds = leds | mask ; // LED = LED OR MASK
}

void ledClear( int fd, int mask) 
{
	int i, bit = 1 ;
	struct input_event event ;
		
	event.type = EV_LED ;
	event.value = 0 ;
	for( i = 0 ; i < LEDNUM ; i++, bit = bit << 1)
		if( mask & bit) {
			event.code = ledcode[ i] ;
			write( fd, &event, sizeof( event)) ;
		}
	leds = leds & (~mask) ; // LED = LED AND NOT MASK
}
	
void ledBlink( int fd, int mask)
{
	int i, bit = 1 ;
	struct input_event event ;
		
	event.type = EV_LED ;
	for( i = 0 ; i < LEDNUM ; i++, bit = bit << 1)
		if( mask & bit) {
			event.code = ledcode[ i] ;
			event.value = (leds & bit) == 0 ;
			write( fd, &event, sizeof( event)) ;
			leds ^= bit ;
		}
}

