#ifndef _DRV_API_H
#define _DRV_API_H
/****************************************************************************
                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_api.h
      This file contains the defines, the structures declarations,
      the tables declarations and the global functions declarations.
      It is the main configuration file for the project and can be adapted
      to own needs.

   \remarks
      Compiler switch for OS is needed. Use LINUX for linux and VXWORKS for
      VxWorks. WIN32 is just for test purposes for function tests.
      Make sure PPC is defined if using a PPC system. Currently this driver
      is working without RTAI but the time resolution is only 10 ms, affecting
      a instable voice downstreaming.
*/

/**
 \mainpage VMMC Driver Description
 \section DRV_INTEGRATION Integrating the Driver
 \subsection COMP_SWITCHES Compiler Switches
 - LINUX        - must be specified for LINUX
 - VXWORKS      - must be specified for VxWorks
 - TAPI         - TAPI interface supported
 - DEBUG        - enables debug features as asserts for example
 - ENABLE_TRACE - enables print out to terminal
*/

/* ============================= */
/* Global Defines                */
/* ============================= */

/* define prototypes for VxWorks 5 */
#ifndef __PROTOTYPE_5_0
   #define __PROTOTYPE_5_0
#endif

#ifdef HAVE_CONFIG_H
#include "drv_config.h"
/*lint -save -e(19)  we need this ; to stop a runaway arguments from breaking
  out of drv_config.h */
;
/*lint -restore */
#else
#error no drv_config.h
#endif

#if defined(VXWORKS) || defined(LINUX)
   /* define to enable the shared interrupt handling */
   #define VMMC_SHARED_INTERRUPT
#endif /* defined(VXWORKS) || defined(LINUX) */

/* ============================= */
/* includes                      */
/* ============================= */

/* this included file is supposed to support following OS:
   - LINUX
   - VXWORKS
   - NO_OS
   - WINDOWS
*/
#include "drv_vmmc_osmap.h"

/* device specific headers to implement the device specific  "hook"
   functionality, such as PCM GPIO multiplex control */
#if defined(SYSTEM_AR9) || defined(SYSTEM_VR9)
#include "drv_vmmc_amazon_s.h"
#elif defined SYSTEM_DANUBE
#include "drv_vmmc_danube.h"
#endif

/*
   list of possible features to check against VMMC_CFG_FEATURES
*/

/* support for line testing */
#define VMMC_FEAT_LT                        0x00000100
/* support for GR909 tests */
#define VMMC_FEAT_GR909                     0x00000200
/* support for voice connections */
#define VMMC_FEAT_VOICE                     0x00000400
/* support for FAX connections */
#define VMMC_FEAT_FAX_T38                   0x00000800
/* support for packet handling (AAL/RTP) */
#define VMMC_FEAT_PACKET                    0x00001000
/* support for Audio Channel */
#define VMMC_FEAT_AUDIO                     0x00002000
/* support for FAX T.38 in voice DSP */
#define VMMC_FEAT_FAX_T38_FW                0x00004000
/* support for HDLC data */
#define VMMC_FEAT_HDLC                      0x00008000
/* support for Kernel Packet Interface */
#define VMMC_FEAT_KPI                       0x00010000
/* support for analog line calibration */
#define VMMC_FEAT_CALIBRATION               0x00020000
/* support for analog line continuous measurement */
#define VMMC_FEAT_CONT_MEASUREMENT          0x00040000
/* support for announcements inside firmware */
#define VMMC_FEAT_ANNOUNCEMENTS             0x00080000
/* support for FXS Phone Detection */
#define VMMC_FEAT_PHONE_DETECTION           0x00100000


/* ---------------------- */

#ifndef VMMC_CFG_FEATURES
/* if not already set, define features depending on TAPI and other defines */
#ifdef TAPI_VOICE
#define VMMC_CFG_ADD_FEAT_VOICE   (VMMC_FEAT_VOICE | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_VOICE   0
#endif

#ifdef TAPI_AUDIO
#define VMMC_CFG_ADD_FEAT_AUDIO (VMMC_FEAT_AUDIO | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_AUDIO 0
#endif

#ifdef TAPI_FAX_T38
#define VMMC_CFG_ADD_FEAT_FAX_T38 (VMMC_FEAT_FAX_T38 | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_FAX_T38 0
#endif

#ifdef TAPI_FAX_T38_FW
#define VMMC_CFG_ADD_FEAT_FAX_T38_FW (VMMC_FEAT_FAX_T38_FW | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_FAX_T38_FW 0
#endif

#ifdef HDLC_SUPPORT
#define VMMC_CFG_ADD_FEAT_HDLC (VMMC_FEAT_HDLC | VMMC_FEAT_KPI | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_HDLC 0
#endif

#ifdef KPI_SUPPORT
#define VMMC_CFG_ADD_FEAT_KPI (VMMC_FEAT_KPI | VMMC_FEAT_PACKET)
#else
#define VMMC_CFG_ADD_FEAT_KPI 0
#endif

#ifdef TAPI_LT
#define VMMC_CFG_ADD_FEAT_LT      VMMC_FEAT_LT
#else
#define VMMC_CFG_ADD_FEAT_LT      0
#endif

#ifdef TAPI_GR909
#define VMMC_CFG_ADD_FEAT_GR909      VMMC_FEAT_GR909
#else
#define VMMC_CFG_ADD_FEAT_GR909      0
#endif

#ifdef CALIBRATION_SUPPORT
#define VMMC_CFG_ADD_FEAT_CALIBRATION     VMMC_FEAT_CALIBRATION
#else
#define VMMC_CFG_ADD_FEAT_CALIBRATION     0
#endif

#ifdef TAPI_CONT_MEASUREMENT
#define VMMC_CFG_ADD_FEAT_CONT_MEASUREMENT VMMC_FEAT_CONT_MEASUREMENT
#else
#define VMMC_CFG_ADD_FEAT_CONT_MEASUREMENT 0
#endif

#ifdef TAPI_ANNOUNCEMENTS
#define VMMC_CFG_ADD_FEAT_ANNOUNCEMENTS (VMMC_FEAT_ANNOUNCEMENTS)
#else
#define VMMC_CFG_ADD_FEAT_ANNOUNCEMENTS 0
#endif

/* TAPI FXS Phone Detection feature is not available for Danube platform */
#if defined(TAPI_PHONE_DETECTION) && (defined(SYSTEM_AR9) || defined(SYSTEM_VR9))
#define VMMC_CFG_ADD_FEAT_PHONE_DETECTION VMMC_FEAT_PHONE_DETECTION
#else
#define VMMC_CFG_ADD_FEAT_PHONE_DETECTION 0
#endif /* TAPI_PHONE_DETECTION && (SYSTEM_AR9 || SYSTEM_VR9) */

#define VMMC_CFG_FEATURES      ( VMMC_CFG_ADD_FEAT_VOICE             \
                              |  VMMC_CFG_ADD_FEAT_FAX_T38           \
                              |  VMMC_CFG_ADD_FEAT_FAX_T38_FW        \
                              |  VMMC_CFG_ADD_FEAT_LT                \
                              |  VMMC_CFG_ADD_FEAT_GR909             \
                              |  VMMC_CFG_ADD_FEAT_AUDIO             \
                              |  VMMC_CFG_ADD_FEAT_HDLC              \
                              |  VMMC_CFG_ADD_FEAT_KPI               \
                              |  VMMC_CFG_ADD_FEAT_CALIBRATION       \
                              |  VMMC_CFG_ADD_FEAT_CONT_MEASUREMENT  \
                              |  VMMC_CFG_ADD_FEAT_ANNOUNCEMENTS     \
                              |  VMMC_CFG_ADD_FEAT_PHONE_DETECTION)

#endif /* VMMC_CFG_FEATURES */

#define TAPI_PACKET 1

#endif /* _DRV_API_H */
