<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_host - Serveur Apache HTTP Version 2.2</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_host</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_authz_host.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_authz_host.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisations de groupe bases sur l'hte (nom ou adresse
IP)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_host_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_host.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis les versions 2.1 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Les directives fournies par le module
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> s'utilisent dans des sections
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>,
    <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, et
    <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, ou des
    fichiers
    <code><a href="core.html#accessfilename">.htaccess</a> </code> pour
    contrler l'accs  certaines zones du serveur. Le contrle d'accs
    peut tre effectu en fonction du nom d'hte, de l'adresse IP, ou
    d'autres caractristiques de la requte client, telles qu'elles sont
    enregistres dans des <a href="../env.html">variables
    d'environnement</a>. Les directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> permettent de spcifier
    quels clients sont ou ne sont pas autoriss  accder au serveur,
    alors que la directive <code class="directive"><a href="#order">Order</a></code> dfinit le statut d'accs
    par dfaut, et dtermine la manire dont les directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> vont interagir.</p>

    <p>Les restrictions d'accs bases sur l'hte et l'authentification
     base de mots de passe peuvent tre utilises conjointement. Dans
    ce cas, la directive <code class="directive"><a href="../mod/core.html#satisfy">Satisfy</a></code>
    permet de dterminer la manire dont ces deux mthodes de
    restriction interagissent.</p>

    <p>En gnral, les directives de restriction d'accs s'appliquent 
    toutes les mthodes d'accs (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de ne restreindre
    l'accs que pour certaines mthodes, tout en laissant les autres
    mthodes sans protection, en plaant les directives dans une section
    <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#allow">Allow</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deny">Deny</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#order">Order</a></li>
</ul>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/core.html#satisfy">Satisfy</a></code></li>
<li><code class="directive"><a href="../mod/core.html#require">Require</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allow" id="allow">Directive</a> <a name="Allow" id="Allow">Allow</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrles quels htes peuvent accder  une certaine zone
du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Allow from all|<var>hte</var>|env=[!]<var>var-env</var>
[<var>hte</var>|env=[!]<var>var-env</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_host</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le support de la ngation de env=<var>env-variable</var>
est assur depuis la version 2.2.10 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">Allow</code> permet de contrler
    quels htes peuvent
    accder  une zone du serveur. On peut contrler
    l'accs en fonction du nom d'hte, de l'adresse IP, d'un intervalle
    d'adresses IP, ou d'autres caractristiques de la requte client
    enregistres dans des variables d'environnement.</p>

    <p>Le premier argument de cette directive est toujours
    <code>from</code>. Les arguments suivants peuvent se prsenter sous
    trois formes. Si <code>Allow from all</code> est spcifi, tous les
    htes ont l'autorisation d'accs, sauf si la configuration des
    directives <code class="directive"><a href="#deny">Deny</a></code> et
    <code class="directive"><a href="#order">Order</a></code> apporte une
    restriction quelconque, comme dcrit plus loin. Afin de n'accorder
    l'accs au serveur qu' certains htes ou groupes d'htes,
    on peut utiliser l'argument <var>hte</var> sous les formes
    suivantes :</p>

    <dl>
      <dt>Un nom de domaine, ventuellement partiel</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from apache.org<br />
        Allow from .net exemple.edu
      </code></p></div>
      <p>Les htes dont les nom correspond  la chane spcifie, ou
      se terminant par elle, sont autoriss  accder. Seuls les
      lments complets du nom de domaine sont compars, si bien que
      l'exemple ci-dessus correspondra  <code>foo.apache.org</code>,
      mais pas  <code>fooapache.org</code>. Avec cette configuration,
      Apache va effectuer une double recherche DNS sur l'adresse IP du
      client, sans tenir compte de la dfinition de la directive
      <code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code>. Il effectue
      tout d'abord une recherche DNS inverse sur l'adresse IP afin de
      dterminer le nom d'hte associ, puis une recherche directe sur
      le nom d'hte pour vrifier s'il correspond bien  l'adresse IP
      originale. L'accs ne sera accord que si le nom d'hte correspond
       la chane spcifie et si les recherches DNS inverse et
      directe produisent un rsultat cohrent.</p></dd>

      <dt>Une adresse IP complte</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.2.3<br />
        Allow from 192.168.1.104 192.168.1.205
      </code></p></div>
      <p>L'adresse IP d'un hte qui a l'autorisation d'accs</p></dd>

      <dt>Une adresse IP partielle</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1<br />
        Allow from 10 172.20 192.168.2
      </code></p></div>
      <p>Les 1  3 premiers octets d'une adresse IP, pour rfrencer un
      sous-rseau.</p></dd>

      <dt>Une paire rseau/masque de sous-rseau</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.0.0/255.255.0.0
      </code></p></div>
      <p>Un rseau a.b.c.d, et un masque de sous-rseau w.x.y.z. pour la
      restriction plus fine d'un sous-rseau.</p></dd>

      <dt>Une spcification CIDR rseau/nnn</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.0.0/16
      </code></p></div>
      <p>Identique au cas prcdent, mais le masque de sous-rseau se
      compose des nnn bits de poids forts.</p></dd>
    </dl>

    <p>Notez que les trois derniers exemples rfrencent exactement le
    mme ensemble d'htes.</p>

    <p>On peut spcifier des adresses et sous-rseaux IPv6 de la manire
    suivante :</p>

    <div class="example"><p><code>
       Allow from 2001:db8::a00:20ff:fea7:ccea<br />
       Allow from 2001:db8::a00:20ff:fea7:ccea/10
    </code></p></div>



    <p>Le troisime format d'arguments de la directive
    <code class="directive">Allow</code> permet de contrler l'accs au
    serveur en fonction de l'existence d'une <a href="../env.html">variable d'environnement</a>. Lorsque
    <code>Allow from
    env=<var>var-env</var></code> est spcifi, la
    requte est autorise si la variable d'environnement
    <var>var-env</var> existe. Lorsque <code>Allow from
    env=!<var>var-env</var></code> est spcifi, la requte est
    autorise  accder si la variable d'environnement
    <var>var-env</var> n'existe pas. Le serveur fournit la possibilit
    de dfinir des variables d'environnement avec une grande souplesse
    en fonction des caractristiques de la requte client  l'aide des
    directives fournies par le module <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>. On
    peut ainsi utiliser cette directive pour contrler l'accs en
    fonction de certains en-ttes comme <code>User-Agent</code> (type de
    navigateur), <code>Referer</code>, etc...</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      SetEnvIf User-Agent ^KnockKnock/2\.0 laisse_moi_entrer<br />
      &lt;Directory /docroot&gt;<br />
      <span class="indent">
        Order Deny,Allow<br />
        Deny from all<br />
        Allow from env=laisse_moi_entrer<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>Dans cet exemple, les navigateurs dont la chane de description
    de l'en-tte user-agent commence par <code>KnockKnock/2.0</code> se
    verront accorder l'accs, alors que tous les autres se le verront
    refuser.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="deny" id="deny">Directive</a> <a name="Deny" id="Deny">Deny</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine quels htes ont l'accs au serveur
refus</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Deny from all|<var>hte</var>|env=[!]<var>var-env</var>
[<var>hte</var>|env=[!]<var>var-env</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_host</td></tr>
</table>
    <p>Cette directive permet de restreindre l'accs au serveur en
    fonction du nom d'hte, de l'adresse IP, ou de variables
    d'environnement. Les arguments de la directive
    <code class="directive">Deny</code> sont identiques  ceux de la directive
    <code class="directive"><a href="#allow">Allow</a></code>..</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="order" id="order">Directive</a> <a name="Order" id="Order">Order</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le statut d'accs par dfaut et l'ordre dans
lequel les directives <code class="directive">Allow</code> et
<code class="directive">Deny</code> sont values.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Order <var>ordre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Order Deny,Allow</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_host</td></tr>
</table>

    <p>La directive <code class="directive">Order</code>, utilise avec les
    directives <code class="directive"><a href="#allow">Allow</a></code> et
    <code class="directive"><a href="#deny">Deny</a></code>, fournit un
    systme de contrle d'accs en trois passes. La premire passe
    traite soit toutes les directives <code class="directive"><a href="#allow">Allow</a></code>, soit toutes les
    directives <code class="directive"><a href="#deny">Deny</a></code>,
    comme spcifi par la directive <code class="directive">Order</code>. La
    seconde passe traite le reste des directives (<code class="directive"><a href="#deny">Deny</a></code> ou <code class="directive"><a href="#allow">Allow</a></code>). La troisime passe
    s'applique  toutes les requtes auxquelles aucune des deux
    premires passes ne s'appliquent.</p>

    <p>Notez que toutes les directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> sont traites,  la
    diffrence d'un pare-feu classique, o seule la premire rgle qui
    convient est traite. La dernire directive qui convient l'emporte
    sur les autres ( la diffrence l aussi d'un pare-feu classique).
    De plus, l'ordre dans lequel les lignes apparaissent dans les
    fichiers de configuration n'a aucune importance -- toutes les
    directives <code class="directive"><a href="#allow">Allow</a></code> sont traites comme un
    groupe, toutes les directives <code class="directive"><a href="#deny">Deny</a></code> comme un autre, et le
    statut d'accs par dfaut est indpendant.</p>

    <p><em>Ordre</em> peut tre soit :</p>

    <dl>
      <dt><code>Allow,Deny</code></dt>

      <dd>Toutes les directives <code class="directive"><a href="#allow">Allow</a></code> sont values en premier
      ; l'une d'elles au moins doit convenir, faute de quoi la requte
      sera rejete. Vient ensuite le tour des directives <code class="directive"><a href="#deny">Deny</a></code>. Si l'une au moins
      convient, le requte est rejete. Enfin, toute requte  laquelle
      ne convient aucune directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> sera rejete par dfaut.</dd>

      <dt><code>Deny,Allow</code></dt>

      <dd>Toutes les directives <code class="directive"><a href="#deny">Deny</a></code> sont values en premier
      ; si l'une au moins
      convient, le requte est rejete, <strong>sauf</strong> si une
      directive <code class="directive"><a href="#allow">Allow</a></code>
       convient aussi. Enfin,
      toute requte  laquelle
      ne convient aucune directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> aura l'autorisation
      d'accs par dfaut.</dd>

      <dt><code>Mutual-failure</code></dt>

      <dd>Cet ordre est identique  l'ordre <code>Order
      Allow,Deny</code> qui le remplace.</dd>
    </dl>

    <p>Les mots-cls ne doivent tre spars que par des virgules ;
    aucun espace ne doit s'intercaler entre eux.</p>

    <table class="bordered">
      <tr>
        <th>Directives qui conviennent</th>
        <th>Rsultat de Allow,Deny</th>
        <th>Rsultat de Deny,Allow</th>
      </tr><tr>
        <th>Allow seulement convient</th>
        <td>Requte autorise</td>
        <td>Requte autorise</td>
      </tr><tr>
        <th>Deny seulement convient</th>
        <td>Requte rejete</td>
        <td>Requte rejete</td>
      </tr><tr>
        <th>Aucune directive ne convient</th>
        <td>La seconde directive par dfaut: Rejet</td>
        <td>La seconde directive par dfaut: Autorisation</td>
      </tr><tr>
        <th>Allow &amp; Deny conviennent</th>
        <td>La dernire directive qui convient prend le contrle: Rejet</td>
        <td>La dernire directive qui convient prend le contrle: Autorisation</td>
      </tr>
    </table>

    <p>Dans l'exemple suivant, tous les htes du domaine apache.org ont
    l'autorisation d'accs ; tous les autres htes voient leur accs
    refus.</p>

    <div class="example"><p><code>
      Order Deny,Allow<br />
      Deny from all<br />
      Allow from apache.org
    </code></p></div>

    <p>Dans l'exemple suivant, tous les htes du domaine apache.org ont
    l'autorisation d'accs, sauf les htes du sous-domaine
    foo.apache.org qui voient leur accs refus. Tous les htes qui ne
    font pas partie du domaine apache.org voient leur accs refus car
    le statut d'accs par dfaut est dfini  <code class="directive"><a href="#deny">Deny</a></code>.</p>

    <div class="example"><p><code>
    Order Allow,Deny<br />
      Allow from apache.org<br />
      Deny from foo.apache.org
    </code></p></div>


    <p>En revanche, si la directive <code class="directive">Order</code> du
    dernier exemple a pour valeur <code>Deny,Allow</code>, tous les
    htes auront l'autorisation d'accs. Ceci est d au fait que l'on ne
    tient pas compte de l'ordre dans lequel apparaissent les directives
    dans le fichier de configuration, et que la directive <code>Allow
    from apache.org</code> est value en dernier et l'emporte donc sur
    la directive <code>Deny from foo.apache.org</code>. Tous les htes
    qui ne font pas partie du domaine <code>apache.org</code> auront
    aussi l'autorisation d'accs, car le statut d'accs par dfaut est
    dfini 
    <code class="directive"><a href="#allow">Allow</a></code>.</p>

    <p>Mme en l'absence de directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> associes, la prsence
    d'une directive <code class="directive">Order</code> peut affecter l'accs 
    une partie du serveur,  cause de son effet sur le statut d'accs
    par dfaut. Par exemple,</p>

    <div class="example"><p><code>
      &lt;Directory /www&gt;<br />
      <span class="indent">
        Order Allow,Deny<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>interdira tout accs au rpertoire <code>/www</code> car le
    statut d'accs par dfaut est dfini  <code class="directive"><a href="#deny">Deny</a></code>.</p>

    <p>La directive <code class="directive">Order</code> ne contrle l'ordre de
    traitement des directives d'accs qu' l'intrieur de chaque phase
    du traitement de la configuration du serveur. Ceci implique, par
    exemple, qu'une directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> apparaissant dans une
    section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>
    sera toujours value aprs une directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> apparaissant dans une
    section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou un fichier
    <code>.htaccess</code>, sans tenir compte de la dfinition de la
    directive <code class="directive">Order</code>. Pour plus de dtails sur la
    fusion des sections de configuration, voir la documentation <a href="../sections.html">Comment fonctionnent les sections Directory,
    Location et Files</a>.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_authz_host.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_authz_host.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.2/mod/mod_authz_host.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>