/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSEMI_H
#define _REGSEMI_H  1

#include "regs.h"

#ifndef REGS_EMI_BASE
#define REGS_EMI_BASE (REGS_BASE + 0x00020000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_CTRL - EMI Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CE_SELECT            :  4;
        unsigned RESET_OUT            :  1;
        unsigned WRITE_PROTECT        :  1;
        unsigned MEM_WIDTH            :  1;
        unsigned RSVD0                :  1;
        unsigned HIGH_PRIORITY_WRITE  :  3;
        unsigned RSVD1                :  1;
        unsigned PRIORITY_WRITE_ITER  :  3;
        unsigned RSVD2                :  1;
        unsigned PORT_PRIORITY_ORDER  :  5;
        unsigned RSVD3                :  1;
        unsigned ARB_MODE             :  2;
        unsigned DLL_RESET            :  1;
        unsigned DLL_SHIFT_RESET      :  1;
        unsigned AXI_DEPTH            :  2;
        unsigned TRAP_INIT            :  1;
        unsigned TRAP_SR              :  1;
        unsigned CLKGATE              :  1;
        unsigned SFTRST               :  1;
    } B;
} hw_emi_ctrl_t;
#endif


//
// constants & macros for entire HW_EMI_CTRL register
//

#define HW_EMI_CTRL_ADDR      (REGS_EMI_BASE + 0x00000000)
#define HW_EMI_CTRL_SET_ADDR  (REGS_EMI_BASE + 0x00000004)
#define HW_EMI_CTRL_CLR_ADDR  (REGS_EMI_BASE + 0x00000008)
#define HW_EMI_CTRL_TOG_ADDR  (REGS_EMI_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_CTRL           (*(volatile hw_emi_ctrl_t *) HW_EMI_CTRL_ADDR)
#define HW_EMI_CTRL_RD()      (HW_EMI_CTRL.U)
#define HW_EMI_CTRL_WR(v)     (HW_EMI_CTRL.U = (v))
#define HW_EMI_CTRL_SET(v)    ((*(volatile reg32_t *) HW_EMI_CTRL_SET_ADDR) = (v))
#define HW_EMI_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_EMI_CTRL_CLR_ADDR) = (v))
#define HW_EMI_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_EMI_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_EMI_CTRL bitfields
//

//--- Register HW_EMI_CTRL, field SFTRST

#define BP_EMI_CTRL_SFTRST      31
#define BM_EMI_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_EMI_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_EMI_CTRL_SFTRST)
#else
#define BF_EMI_CTRL_SFTRST(v)   (((v) << 31) & BM_EMI_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_SFTRST(v)   BF_CS1(EMI_CTRL, SFTRST, v)
#endif

//--- Register HW_EMI_CTRL, field CLKGATE

#define BP_EMI_CTRL_CLKGATE      30
#define BM_EMI_CTRL_CLKGATE      0x40000000

#define BF_EMI_CTRL_CLKGATE(v)   (((v) << 30) & BM_EMI_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_CLKGATE(v)   BF_CS1(EMI_CTRL, CLKGATE, v)
#endif

//--- Register HW_EMI_CTRL, field TRAP_SR

#define BP_EMI_CTRL_TRAP_SR      29
#define BM_EMI_CTRL_TRAP_SR      0x20000000

#define BF_EMI_CTRL_TRAP_SR(v)   (((v) << 29) & BM_EMI_CTRL_TRAP_SR)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_TRAP_SR(v)   BF_CS1(EMI_CTRL, TRAP_SR, v)
#endif

//--- Register HW_EMI_CTRL, field TRAP_INIT

#define BP_EMI_CTRL_TRAP_INIT      28
#define BM_EMI_CTRL_TRAP_INIT      0x10000000

#define BF_EMI_CTRL_TRAP_INIT(v)   (((v) << 28) & BM_EMI_CTRL_TRAP_INIT)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_TRAP_INIT(v)   BF_CS1(EMI_CTRL, TRAP_INIT, v)
#endif

//--- Register HW_EMI_CTRL, field AXI_DEPTH

#define BP_EMI_CTRL_AXI_DEPTH      26
#define BM_EMI_CTRL_AXI_DEPTH      0x0C000000

#define BF_EMI_CTRL_AXI_DEPTH(v)   (((v) << 26) & BM_EMI_CTRL_AXI_DEPTH)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_AXI_DEPTH(v)   BF_CS1(EMI_CTRL, AXI_DEPTH, v)
#endif

#define BV_EMI_CTRL_AXI_DEPTH__ONE    0x0
#define BV_EMI_CTRL_AXI_DEPTH__TWO    0x1
#define BV_EMI_CTRL_AXI_DEPTH__THREE  0x2
#define BV_EMI_CTRL_AXI_DEPTH__FOUR   0x3

//--- Register HW_EMI_CTRL, field DLL_SHIFT_RESET

#define BP_EMI_CTRL_DLL_SHIFT_RESET      25
#define BM_EMI_CTRL_DLL_SHIFT_RESET      0x02000000

#define BF_EMI_CTRL_DLL_SHIFT_RESET(v)   (((v) << 25) & BM_EMI_CTRL_DLL_SHIFT_RESET)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_DLL_SHIFT_RESET(v)   BF_CS1(EMI_CTRL, DLL_SHIFT_RESET, v)
#endif

//--- Register HW_EMI_CTRL, field DLL_RESET

#define BP_EMI_CTRL_DLL_RESET      24
#define BM_EMI_CTRL_DLL_RESET      0x01000000

#define BF_EMI_CTRL_DLL_RESET(v)   (((v) << 24) & BM_EMI_CTRL_DLL_RESET)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_DLL_RESET(v)   BF_CS1(EMI_CTRL, DLL_RESET, v)
#endif

//--- Register HW_EMI_CTRL, field ARB_MODE

#define BP_EMI_CTRL_ARB_MODE      22
#define BM_EMI_CTRL_ARB_MODE      0x00C00000

#define BF_EMI_CTRL_ARB_MODE(v)   (((v) << 22) & BM_EMI_CTRL_ARB_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_ARB_MODE(v)   BF_CS1(EMI_CTRL, ARB_MODE, v)
#endif

#define BV_EMI_CTRL_ARB_MODE__TIMESTAMP      0x0
#define BV_EMI_CTRL_ARB_MODE__WRITE_HYBRID   0x1
#define BV_EMI_CTRL_ARB_MODE__PORT_PRIORITY  0x2

//--- Register HW_EMI_CTRL, field PORT_PRIORITY_ORDER

#define BP_EMI_CTRL_PORT_PRIORITY_ORDER      16
#define BM_EMI_CTRL_PORT_PRIORITY_ORDER      0x001F0000

#define BF_EMI_CTRL_PORT_PRIORITY_ORDER(v)   (((v) << 16) & BM_EMI_CTRL_PORT_PRIORITY_ORDER)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_PORT_PRIORITY_ORDER(v)   BF_CS1(EMI_CTRL, PORT_PRIORITY_ORDER, v)
#endif

#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0123  0x00
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0312  0x01
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0231  0x02
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0321  0x03
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0213  0x04
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0132  0x05
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1023  0x06
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1302  0x07
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1230  0x08
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1320  0x09
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1203  0x0A
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1032  0x0B
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2013  0x0C
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2301  0x0D
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2130  0x0E
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2310  0x0F
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2103  0x10
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2031  0x11
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3012  0x12
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3201  0x13
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3120  0x14
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3210  0x15
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3102  0x16
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3021  0x17

//--- Register HW_EMI_CTRL, field PRIORITY_WRITE_ITER

#define BP_EMI_CTRL_PRIORITY_WRITE_ITER      12
#define BM_EMI_CTRL_PRIORITY_WRITE_ITER      0x00007000

#define BF_EMI_CTRL_PRIORITY_WRITE_ITER(v)   (((v) << 12) & BM_EMI_CTRL_PRIORITY_WRITE_ITER)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_PRIORITY_WRITE_ITER(v)   BF_CS1(EMI_CTRL, PRIORITY_WRITE_ITER, v)
#endif

//--- Register HW_EMI_CTRL, field HIGH_PRIORITY_WRITE

#define BP_EMI_CTRL_HIGH_PRIORITY_WRITE      8
#define BM_EMI_CTRL_HIGH_PRIORITY_WRITE      0x00000700

#define BF_EMI_CTRL_HIGH_PRIORITY_WRITE(v)   (((v) << 8) & BM_EMI_CTRL_HIGH_PRIORITY_WRITE)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_HIGH_PRIORITY_WRITE(v)   BF_CS1(EMI_CTRL, HIGH_PRIORITY_WRITE, v)
#endif

//--- Register HW_EMI_CTRL, field MEM_WIDTH

#define BP_EMI_CTRL_MEM_WIDTH      6
#define BM_EMI_CTRL_MEM_WIDTH      0x00000040

#define BF_EMI_CTRL_MEM_WIDTH(v)   (((v) << 6) & BM_EMI_CTRL_MEM_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_MEM_WIDTH(v)   BF_CS1(EMI_CTRL, MEM_WIDTH, v)
#endif

//--- Register HW_EMI_CTRL, field WRITE_PROTECT

#define BP_EMI_CTRL_WRITE_PROTECT      5
#define BM_EMI_CTRL_WRITE_PROTECT      0x00000020

#define BF_EMI_CTRL_WRITE_PROTECT(v)   (((v) << 5) & BM_EMI_CTRL_WRITE_PROTECT)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_WRITE_PROTECT(v)   BF_CS1(EMI_CTRL, WRITE_PROTECT, v)
#endif

//--- Register HW_EMI_CTRL, field RESET_OUT

#define BP_EMI_CTRL_RESET_OUT      4
#define BM_EMI_CTRL_RESET_OUT      0x00000010

#define BF_EMI_CTRL_RESET_OUT(v)   (((v) << 4) & BM_EMI_CTRL_RESET_OUT)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_RESET_OUT(v)   BF_CS1(EMI_CTRL, RESET_OUT, v)
#endif

//--- Register HW_EMI_CTRL, field CE_SELECT

#define BP_EMI_CTRL_CE_SELECT      0
#define BM_EMI_CTRL_CE_SELECT      0x0000000F

#define BF_EMI_CTRL_CE_SELECT(v)   (((v) << 0) & BM_EMI_CTRL_CE_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_CTRL_CE_SELECT(v)   BF_CS1(EMI_CTRL, CE_SELECT, v)
#endif

#define BV_EMI_CTRL_CE_SELECT__NONE  0x0
#define BV_EMI_CTRL_CE_SELECT__CE0   0x1
#define BV_EMI_CTRL_CE_SELECT__CE1   0x2
#define BV_EMI_CTRL_CE_SELECT__CE2   0x4
#define BV_EMI_CTRL_CE_SELECT__CE3   0x8


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_STAT - NOR Flash Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NOR_BUSY            :  1;
        unsigned DRAM_HALTED         :  1;
        unsigned RSVD0               : 27;
        unsigned LARGE_DRAM_ENABLED  :  1;
        unsigned NOR_PRESENT         :  1;
        unsigned DRAM_PRESENT        :  1;
    } B;
} hw_emi_stat_t;
#endif


//
// constants & macros for entire HW_EMI_STAT register
//

#define HW_EMI_STAT_ADDR      (REGS_EMI_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_STAT           (*(volatile hw_emi_stat_t *) HW_EMI_STAT_ADDR)
#define HW_EMI_STAT_RD()      (HW_EMI_STAT.U)
#endif


//
// constants & macros for individual HW_EMI_STAT bitfields
//

//--- Register HW_EMI_STAT, field DRAM_PRESENT

#define BP_EMI_STAT_DRAM_PRESENT      31
#define BM_EMI_STAT_DRAM_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_EMI_STAT_DRAM_PRESENT(v)   ((((reg32_t) v) << 31) & BM_EMI_STAT_DRAM_PRESENT)
#else
#define BF_EMI_STAT_DRAM_PRESENT(v)   (((v) << 31) & BM_EMI_STAT_DRAM_PRESENT)
#endif

//--- Register HW_EMI_STAT, field NOR_PRESENT

#define BP_EMI_STAT_NOR_PRESENT      30
#define BM_EMI_STAT_NOR_PRESENT      0x40000000

#define BF_EMI_STAT_NOR_PRESENT(v)   (((v) << 30) & BM_EMI_STAT_NOR_PRESENT)

//--- Register HW_EMI_STAT, field LARGE_DRAM_ENABLED

#define BP_EMI_STAT_LARGE_DRAM_ENABLED      29
#define BM_EMI_STAT_LARGE_DRAM_ENABLED      0x20000000

#define BF_EMI_STAT_LARGE_DRAM_ENABLED(v)   (((v) << 29) & BM_EMI_STAT_LARGE_DRAM_ENABLED)

//--- Register HW_EMI_STAT, field DRAM_HALTED

#define BP_EMI_STAT_DRAM_HALTED      1
#define BM_EMI_STAT_DRAM_HALTED      0x00000002

#define BF_EMI_STAT_DRAM_HALTED(v)   (((v) << 1) & BM_EMI_STAT_DRAM_HALTED)

#define BV_EMI_STAT_DRAM_HALTED__NOT_HALTED  0x0
#define BV_EMI_STAT_DRAM_HALTED__HALTED      0x1

//--- Register HW_EMI_STAT, field NOR_BUSY

#define BP_EMI_STAT_NOR_BUSY      0
#define BM_EMI_STAT_NOR_BUSY      0x00000001

#define BF_EMI_STAT_NOR_BUSY(v)   (((v) << 0) & BM_EMI_STAT_NOR_BUSY)

#define BV_EMI_STAT_NOR_BUSY__NOT_BUSY  0x0
#define BV_EMI_STAT_NOR_BUSY__BUSY      0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_TIME - NOR Flash Memory Timing Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TAS    :  4;
        unsigned RSVD0  :  4;
        unsigned TDS    :  5;
        unsigned RSVD1  :  3;
        unsigned TDH    :  4;
        unsigned RSVD2  :  4;
        unsigned THZ    :  4;
        unsigned RSVD4  :  4;
    } B;
} hw_emi_time_t;
#endif


//
// constants & macros for entire HW_EMI_TIME register
//

#define HW_EMI_TIME_ADDR      (REGS_EMI_BASE + 0x00000020)
#define HW_EMI_TIME_SET_ADDR  (REGS_EMI_BASE + 0x00000024)
#define HW_EMI_TIME_CLR_ADDR  (REGS_EMI_BASE + 0x00000028)
#define HW_EMI_TIME_TOG_ADDR  (REGS_EMI_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_TIME           (*(volatile hw_emi_time_t *) HW_EMI_TIME_ADDR)
#define HW_EMI_TIME_RD()      (HW_EMI_TIME.U)
#define HW_EMI_TIME_WR(v)     (HW_EMI_TIME.U = (v))
#define HW_EMI_TIME_SET(v)    ((*(volatile reg32_t *) HW_EMI_TIME_SET_ADDR) = (v))
#define HW_EMI_TIME_CLR(v)    ((*(volatile reg32_t *) HW_EMI_TIME_CLR_ADDR) = (v))
#define HW_EMI_TIME_TOG(v)    ((*(volatile reg32_t *) HW_EMI_TIME_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_EMI_TIME bitfields
//

//--- Register HW_EMI_TIME, field THZ

#define BP_EMI_TIME_THZ      24
#define BM_EMI_TIME_THZ      0x0F000000

#define BF_EMI_TIME_THZ(v)   (((v) << 24) & BM_EMI_TIME_THZ)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_TIME_THZ(v)   BF_CS1(EMI_TIME, THZ, v)
#endif

//--- Register HW_EMI_TIME, field TDH

#define BP_EMI_TIME_TDH      16
#define BM_EMI_TIME_TDH      0x000F0000

#define BF_EMI_TIME_TDH(v)   (((v) << 16) & BM_EMI_TIME_TDH)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_TIME_TDH(v)   BF_CS1(EMI_TIME, TDH, v)
#endif

//--- Register HW_EMI_TIME, field TDS

#define BP_EMI_TIME_TDS      8
#define BM_EMI_TIME_TDS      0x00001F00

#define BF_EMI_TIME_TDS(v)   (((v) << 8) & BM_EMI_TIME_TDS)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_TIME_TDS(v)   BF_CS1(EMI_TIME, TDS, v)
#endif

//--- Register HW_EMI_TIME, field TAS

#define BP_EMI_TIME_TAS      0
#define BM_EMI_TIME_TAS      0x0000000F

#define BF_EMI_TIME_TAS(v)   (((v) << 0) & BM_EMI_TIME_TAS)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_TIME_TAS(v)   BF_CS1(EMI_TIME, TAS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DDR_TEST_MODE_CSR - DDR Test Mode Control and Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned START  :  1;
        unsigned DONE   :  1;
        unsigned RSVD1  : 30;
    } B;
} hw_emi_ddr_test_mode_csr_t;
#endif


//
// constants & macros for entire HW_EMI_DDR_TEST_MODE_CSR register
//

#define HW_EMI_DDR_TEST_MODE_CSR_ADDR      (REGS_EMI_BASE + 0x00000030)
#define HW_EMI_DDR_TEST_MODE_CSR_SET_ADDR  (REGS_EMI_BASE + 0x00000034)
#define HW_EMI_DDR_TEST_MODE_CSR_CLR_ADDR  (REGS_EMI_BASE + 0x00000038)
#define HW_EMI_DDR_TEST_MODE_CSR_TOG_ADDR  (REGS_EMI_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DDR_TEST_MODE_CSR           (*(volatile hw_emi_ddr_test_mode_csr_t *) HW_EMI_DDR_TEST_MODE_CSR_ADDR)
#define HW_EMI_DDR_TEST_MODE_CSR_RD()      (HW_EMI_DDR_TEST_MODE_CSR.U)
#define HW_EMI_DDR_TEST_MODE_CSR_WR(v)     (HW_EMI_DDR_TEST_MODE_CSR.U = (v))
#define HW_EMI_DDR_TEST_MODE_CSR_SET(v)    ((*(volatile reg32_t *) HW_EMI_DDR_TEST_MODE_CSR_SET_ADDR) = (v))
#define HW_EMI_DDR_TEST_MODE_CSR_CLR(v)    ((*(volatile reg32_t *) HW_EMI_DDR_TEST_MODE_CSR_CLR_ADDR) = (v))
#define HW_EMI_DDR_TEST_MODE_CSR_TOG(v)    ((*(volatile reg32_t *) HW_EMI_DDR_TEST_MODE_CSR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_EMI_DDR_TEST_MODE_CSR bitfields
//

//--- Register HW_EMI_DDR_TEST_MODE_CSR, field DONE

#define BP_EMI_DDR_TEST_MODE_CSR_DONE      1
#define BM_EMI_DDR_TEST_MODE_CSR_DONE      0x00000002

#define BF_EMI_DDR_TEST_MODE_CSR_DONE(v)   (((v) << 1) & BM_EMI_DDR_TEST_MODE_CSR_DONE)

//--- Register HW_EMI_DDR_TEST_MODE_CSR, field START

#define BP_EMI_DDR_TEST_MODE_CSR_START      0
#define BM_EMI_DDR_TEST_MODE_CSR_START      0x00000001

#define BF_EMI_DDR_TEST_MODE_CSR_START(v)   (((v) << 0) & BM_EMI_DDR_TEST_MODE_CSR_START)

#ifndef __LANGUAGE_ASM__
#define BW_EMI_DDR_TEST_MODE_CSR_START(v)   BF_CS1(EMI_DDR_TEST_MODE_CSR, START, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DEBUG - NOR Flash Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned NOR_STATE  :  4;
        unsigned RSVD1      : 28;
    } B;
} hw_emi_debug_t;
#endif


//
// constants & macros for entire HW_EMI_DEBUG register
//

#define HW_EMI_DEBUG_ADDR      (REGS_EMI_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DEBUG           (*(volatile hw_emi_debug_t *) HW_EMI_DEBUG_ADDR)
#define HW_EMI_DEBUG_RD()      (HW_EMI_DEBUG.U)
#endif


//
// constants & macros for individual HW_EMI_DEBUG bitfields
//

//--- Register HW_EMI_DEBUG, field NOR_STATE

#define BP_EMI_DEBUG_NOR_STATE      0
#define BM_EMI_DEBUG_NOR_STATE      0x0000000F

#define BF_EMI_DEBUG_NOR_STATE(v)   (((v) << 0) & BM_EMI_DEBUG_NOR_STATE)


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DDR_TEST_MODE_STATUS0 - DDR Test Mode Status Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR0  : 13;
        unsigned RSVD1  : 19;
    } B;
} hw_emi_ddr_test_mode_status0_t;
#endif


//
// constants & macros for entire HW_EMI_DDR_TEST_MODE_STATUS0 register
//

#define HW_EMI_DDR_TEST_MODE_STATUS0_ADDR      (REGS_EMI_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DDR_TEST_MODE_STATUS0           (*(volatile hw_emi_ddr_test_mode_status0_t *) HW_EMI_DDR_TEST_MODE_STATUS0_ADDR)
#define HW_EMI_DDR_TEST_MODE_STATUS0_RD()      (HW_EMI_DDR_TEST_MODE_STATUS0.U)
#endif


//
// constants & macros for individual HW_EMI_DDR_TEST_MODE_STATUS0 bitfields
//

//--- Register HW_EMI_DDR_TEST_MODE_STATUS0, field ADDR0

#define BP_EMI_DDR_TEST_MODE_STATUS0_ADDR0      0
#define BM_EMI_DDR_TEST_MODE_STATUS0_ADDR0      0x00001FFF

#define BF_EMI_DDR_TEST_MODE_STATUS0_ADDR0(v)   (((v) << 0) & BM_EMI_DDR_TEST_MODE_STATUS0_ADDR0)


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DDR_TEST_MODE_STATUS1 - DDR Test Mode Status Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR1  : 13;
        unsigned RSVD1  : 19;
    } B;
} hw_emi_ddr_test_mode_status1_t;
#endif


//
// constants & macros for entire HW_EMI_DDR_TEST_MODE_STATUS1 register
//

#define HW_EMI_DDR_TEST_MODE_STATUS1_ADDR      (REGS_EMI_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DDR_TEST_MODE_STATUS1           (*(volatile hw_emi_ddr_test_mode_status1_t *) HW_EMI_DDR_TEST_MODE_STATUS1_ADDR)
#define HW_EMI_DDR_TEST_MODE_STATUS1_RD()      (HW_EMI_DDR_TEST_MODE_STATUS1.U)
#endif


//
// constants & macros for individual HW_EMI_DDR_TEST_MODE_STATUS1 bitfields
//

//--- Register HW_EMI_DDR_TEST_MODE_STATUS1, field ADDR1

#define BP_EMI_DDR_TEST_MODE_STATUS1_ADDR1      0
#define BM_EMI_DDR_TEST_MODE_STATUS1_ADDR1      0x00001FFF

#define BF_EMI_DDR_TEST_MODE_STATUS1_ADDR1(v)   (((v) << 0) & BM_EMI_DDR_TEST_MODE_STATUS1_ADDR1)


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DDR_TEST_MODE_STATUS2 - DDR Test Mode Status Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA0;
    } B;
} hw_emi_ddr_test_mode_status2_t;
#endif


//
// constants & macros for entire HW_EMI_DDR_TEST_MODE_STATUS2 register
//

#define HW_EMI_DDR_TEST_MODE_STATUS2_ADDR      (REGS_EMI_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DDR_TEST_MODE_STATUS2           (*(volatile hw_emi_ddr_test_mode_status2_t *) HW_EMI_DDR_TEST_MODE_STATUS2_ADDR)
#define HW_EMI_DDR_TEST_MODE_STATUS2_RD()      (HW_EMI_DDR_TEST_MODE_STATUS2.U)
#endif


//
// constants & macros for individual HW_EMI_DDR_TEST_MODE_STATUS2 bitfields
//

//--- Register HW_EMI_DDR_TEST_MODE_STATUS2, field DATA0

#define BP_EMI_DDR_TEST_MODE_STATUS2_DATA0      0
#define BM_EMI_DDR_TEST_MODE_STATUS2_DATA0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_EMI_DDR_TEST_MODE_STATUS2_DATA0(v)   ((reg32_t) v)
#else
#define BF_EMI_DDR_TEST_MODE_STATUS2_DATA0(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_DDR_TEST_MODE_STATUS3 - DDR Test Mode Status Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA1;
    } B;
} hw_emi_ddr_test_mode_status3_t;
#endif


//
// constants & macros for entire HW_EMI_DDR_TEST_MODE_STATUS3 register
//

#define HW_EMI_DDR_TEST_MODE_STATUS3_ADDR      (REGS_EMI_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_DDR_TEST_MODE_STATUS3           (*(volatile hw_emi_ddr_test_mode_status3_t *) HW_EMI_DDR_TEST_MODE_STATUS3_ADDR)
#define HW_EMI_DDR_TEST_MODE_STATUS3_RD()      (HW_EMI_DDR_TEST_MODE_STATUS3.U)
#endif


//
// constants & macros for individual HW_EMI_DDR_TEST_MODE_STATUS3 bitfields
//

//--- Register HW_EMI_DDR_TEST_MODE_STATUS3, field DATA1

#define BP_EMI_DDR_TEST_MODE_STATUS3_DATA1      0
#define BM_EMI_DDR_TEST_MODE_STATUS3_DATA1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_EMI_DDR_TEST_MODE_STATUS3_DATA1(v)   ((reg32_t) v)
#else
#define BF_EMI_DDR_TEST_MODE_STATUS3_DATA1(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_EMI_VERSION - EMI Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_emi_version_t;
#endif


//
// constants & macros for entire HW_EMI_VERSION register
//

#define HW_EMI_VERSION_ADDR      (REGS_EMI_BASE + 0x000000F0)

#ifndef __LANGUAGE_ASM__
#define HW_EMI_VERSION           (*(volatile hw_emi_version_t *) HW_EMI_VERSION_ADDR)
#define HW_EMI_VERSION_RD()      (HW_EMI_VERSION.U)
#endif


//
// constants & macros for individual HW_EMI_VERSION bitfields
//

//--- Register HW_EMI_VERSION, field MAJOR

#define BP_EMI_VERSION_MAJOR      24
#define BM_EMI_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_EMI_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_EMI_VERSION_MAJOR)
#else
#define BF_EMI_VERSION_MAJOR(v)   (((v) << 24) & BM_EMI_VERSION_MAJOR)
#endif

//--- Register HW_EMI_VERSION, field MINOR

#define BP_EMI_VERSION_MINOR      16
#define BM_EMI_VERSION_MINOR      0x00FF0000

#define BF_EMI_VERSION_MINOR(v)   (((v) << 16) & BM_EMI_VERSION_MINOR)

//--- Register HW_EMI_VERSION, field STEP

#define BP_EMI_VERSION_STEP      0
#define BM_EMI_VERSION_STEP      0x0000FFFF

#define BF_EMI_VERSION_STEP(v)   (((v) << 0) & BM_EMI_VERSION_STEP)


#endif // _REGSEMI_H

////////////////////////////////////////////////////////////////////////////////
