/*   FILE: state-connecting.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 14 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

class StateConnecting : State {
	string source_name;
	State  next_state;

	public StateConnecting (MainLoop loop, LCDPlayer player, string source_name, State next_state) {
		this.source_name = source_name;
		this.next_state = next_state;
		print_selected ();
	}

        public override void print_selected () {
		output ("Connecting to " + source_name + "...");
        }

	public override void seekback () {
	}

	public override void seekforward () {
	}

	public override void next () {
	}

	public override void previous () {
	}

	public override State transition () {
		return next_state;
	}
}
