/*
 * notif.c
 *
 * Author: Radek Krejci <rkrejci@cesnet.cz>
 *
 * This code generates example notification using libnetconf. Since the
 * notification is written into the default NETCONF event stream, all clients
 * subscribed to this (default) stream will receive notification about this
 * event.
 *
 * Copyright (c) 2014 CESNET, z.s.p.o.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is, and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */

#include <stdio.h>

#include <libnetconf.h>

int main(int argc, char* argv[])
{
	if (argc != 1) {
		printf("Generate <example-event/> NETCONF event record.\n");
		printf("Usage %s [-h]\n", argv[0]);
		return 0;
	}

	/* init libnetconf (at least) with Notification subsystem */
	nc_init(NC_INIT_NOTIF);

	/* generate event */
	ncntf_event_new(-1, NCNTF_GENERIC, "<example-event xmlns=\"some:namespace\"><msg>Hey!!! Something happened!</msg></example-event>");

	/* bye-bye */
	return 0;
}
