/*
* Miax
*
*  Copyright (C) 2004 by Ubaldo Porcheddu <ubaldo@eja.it>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>

#define RATE 8000
#define BLOCKLEN (RATE/100)
#define BLOCKSIZE 320
#define COS(x) costabf[(((x)>>6)&0x3ffu)] 
#define SIN(x) COS((x)+0xc000)

static int timeout=0, costab=0, freq[8] = { 1209, 1336, 1477, 1633, 697, 770, 852, 941 };
static float costabf[1024];
static char *dtmfstr = "123A456B789C*0#D";


void gencostab() {

	int i;

	if (costab == 0) { 
		for(i=0;i<(sizeof(costabf)/4);i++) { costabf[i]=cos(M_PI*2.0*i/(sizeof(costabf)/4)); } 
		costab=1;
		}
	}


int max_idx(const float *f) {

	float en = 0;
	int idx = -1, i;

	for (i = 0; i < 4; i++) {
		if (f[i] > en) { 
			en = f[i]; 
			idx = i; 
			}
		}
	if (idx < 0) { return -1; }
	en *= 0.1;
	for (i = 0; i < 4; i++) {
		if (idx != i && f[i] > en) { return -1; }
		}
	
	return idx;
	}


int process_block(float energy, float *tenergy) {

	float f[16];
	int i, j;

	for (i = 0; i < 16; i++) { f[i] = tenergy[i]; }
	for (i = 0; i < 8; i++) { f[i] = (f[i]*f[i]) + (f[i+8]*f[i+8]); }
	if ((i = max_idx(f)) < 0) { return -1; }
	if ((j = max_idx(f+4)) < 0) { return -1; }
	if (((energy*=(BLOCKLEN*0.5)) * 0.4) > (f[i] + f[j+4])) { return -1; }

	return (i & 3) | ((j << 2) & 0xc);
	}


int dtmf(short *buf) {

	int i=0, x=0, y=0, z=0, c=-1, n=0, r=0;
	float energy=0, tenergy[16], fbuf[BLOCKSIZE];
	unsigned int ph[8];

	memset(tenergy, 0, sizeof(tenergy));
	memset(ph, 0, sizeof(ph));

	gencostab();

	for (i=0;i<BLOCKSIZE;i++) { fbuf[i] = *(buf++); }
	for (x=0;x<BLOCKSIZE;x++) {
		energy += (fbuf[x]*fbuf[x]);
		for (i = 0; i < 8; i++) {
			tenergy[i] += COS(ph[i]) * fbuf[x];
			tenergy[i+8] += SIN(ph[i]) * fbuf[x];
			ph[i] += (freq[i]*65536)/RATE;
			}
		if (y-- <= 0) {
			y = BLOCKLEN;
			i = process_block(energy, tenergy);
			if (i != z && i >= 0) { n=timeout; c=i; timeout=0; }
			z = i;
 		}
		timeout++;
		}
	if (c >= 0 && (n-timeout) > (BLOCKSIZE*4)) { 
		r=dtmfstr[c]; 
		if (strchr("ABCD*",r)) { r=0; } 
		}

	return r;
	}
