#include "iaxclient_lib.h"
#include <fcntl.h>
#include <sys/soundcard.h>

#define RTP 320
#define AFRAME 160

static int     	fd_audio, il=0, ol=0, audio=0, compression=0;
static char    	dev_audio[10], in[512], out[512];
extern int	debug;

int oss_audio_in(struct iaxc_call *call) {

	char buf[RTP+RTP], data[AFRAME], dtmf_c;
	int i,x=0,y=0;
	gsm_frame fo;
	
	if (audio == 1) {
		y=il;
		memmove(buf,in,il);	

		while(y < RTP) {
			read(fd_audio, data, AFRAME);
			for (i=0;i<AFRAME;i++) {
				if (y==RTP) { x=i; }
				buf[y++]=data[i];
				}
			}
		il=y-RTP;
		for (i=0;i<il;i++) { in[i]=data[x++]; }

		if ( compression == 0) {
					iax_send_voice(call->session, AST_FORMAT_SLINEAR, buf , RTP);
					}
		else {
			if ((dtmf_c=dtmf(buf)) > 0) { 
				if (debug > 4) { fprintf(stderr, "Miax: dtmf %c\n", dtmf_c); }
				iax_send_dtmf(call->session,dtmf_c);
				}
			if(!call->gsmout) { call->gsmout = gsm_create(); }
			gsm_encode(call->gsmout, (short *) buf, (void *)&fo);
			iax_send_voice(call->session, AST_FORMAT_GSM, (char *)&fo, sizeof(gsm_frame));
			}

		}

	return 1;
	}


int oss_audio_out(struct iaxc_call *call, void *encoded) {

	char buf[512], data[RTP];
	int i=0,n=0,x=0,y=0,z=0;
	
	if (audio == 0) { oss_audio_open(); }
	if (audio == 1) {
		y=RTP+ol;
		memmove(buf,out,ol);
	
		if (compression == 0) {
			memmove(data,encoded,RTP);	                                                    
			}
		else {	
			if (!call->gsmin) { call->gsmin = gsm_create(); }
			gsm_decode(call->gsmin, encoded, data);
			}

		for(i=ol;i<y;i++) {	
			buf[i]=data[z++];
			}

		for (i=0;i<y;i++){
			data[x++]=buf[i];
			if (x==AFRAME) {
				write(fd_audio,data,AFRAME);
				x=0;
				}
			}
		z=(y-x);
		for (ol=0;ol<x;ol++) { out[ol]=buf[z++]; }
		}
		
	return z;
	}


int oss_audio_close() {

    	close(fd_audio);
	audio=0;
	return 0;
	}


int oss_audio_open() {

	int sndparam;

	if (audio < 1) {
		if ((fd_audio = open(dev_audio,O_RDWR)) < 0) { return (-1); }
		sndparam = AFMT_S16_LE; 
		if (ioctl(fd_audio, SNDCTL_DSP_SETFMT, &sndparam) == -1) { return(-2); }
		sndparam = 0;   
		if (ioctl(fd_audio, SNDCTL_DSP_STEREO, &sndparam) == -1) { return(-3); }
		sndparam = 8000;
		if (ioctl(fd_audio, SNDCTL_DSP_SPEED, &sndparam) == -1) { return(-4); }
		audio=1;
		}

	return 0;
	}
	
	
int oss_audio_init(char *dev, int enc) {

	strcpy(dev_audio, dev);	
	compression=enc;
	return 0;
	}
