package wang.switchy.hin2n.storage.db.base;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import wang.switchy.hin2n.storage.db.base.model.N2NSettingModel;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "N2NSettingList".
*/
public class N2NSettingModelDao extends AbstractDao<N2NSettingModel, Long> {

    public static final String TABLENAME = "N2NSettingList";

    /**
     * Properties of entity N2NSettingModel.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Name = new Property(1, String.class, "name", false, "NAME");
        public final static Property Ip = new Property(2, String.class, "ip", false, "IP");
        public final static Property Netmask = new Property(3, String.class, "netmask", false, "NETMASK");
        public final static Property Community = new Property(4, String.class, "community", false, "COMMUNITY");
        public final static Property Password = new Property(5, String.class, "password", false, "PASSWORD");
        public final static Property SuperNode = new Property(6, String.class, "superNode", false, "SUPER_NODE");
        public final static Property MoreSettings = new Property(7, boolean.class, "moreSettings", false, "MORE_SETTINGS");
        public final static Property SuperNodeBackup = new Property(8, String.class, "superNodeBackup", false, "SUPER_NODE_BACKUP");
        public final static Property MacAddr = new Property(9, String.class, "macAddr", false, "MAC_ADDR");
        public final static Property Mtu = new Property(10, int.class, "mtu", false, "MTU");
        public final static Property ResoveSupernodeIP = new Property(11, boolean.class, "resoveSupernodeIP", false, "RESOVE_SUPERNODE_IP");
        public final static Property LocalPort = new Property(12, int.class, "localPort", false, "LOCAL_PORT");
        public final static Property AllowRouting = new Property(13, boolean.class, "allowRouting", false, "ALLOW_ROUTING");
        public final static Property DropMuticast = new Property(14, boolean.class, "dropMuticast", false, "DROP_MUTICAST");
        public final static Property TraceLevel = new Property(15, int.class, "traceLevel", false, "TRACE_LEVEL");
        public final static Property IsSelcected = new Property(16, boolean.class, "isSelcected", false, "IS_SELCECTED");
    }


    public N2NSettingModelDao(DaoConfig config) {
        super(config);
    }
    
    public N2NSettingModelDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"N2NSettingList\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"NAME\" TEXT," + // 1: name
                "\"IP\" TEXT," + // 2: ip
                "\"NETMASK\" TEXT," + // 3: netmask
                "\"COMMUNITY\" TEXT," + // 4: community
                "\"PASSWORD\" TEXT," + // 5: password
                "\"SUPER_NODE\" TEXT," + // 6: superNode
                "\"MORE_SETTINGS\" INTEGER NOT NULL ," + // 7: moreSettings
                "\"SUPER_NODE_BACKUP\" TEXT," + // 8: superNodeBackup
                "\"MAC_ADDR\" TEXT," + // 9: macAddr
                "\"MTU\" INTEGER NOT NULL ," + // 10: mtu
                "\"RESOVE_SUPERNODE_IP\" INTEGER NOT NULL ," + // 11: resoveSupernodeIP
                "\"LOCAL_PORT\" INTEGER NOT NULL ," + // 12: localPort
                "\"ALLOW_ROUTING\" INTEGER NOT NULL ," + // 13: allowRouting
                "\"DROP_MUTICAST\" INTEGER NOT NULL ," + // 14: dropMuticast
                "\"TRACE_LEVEL\" INTEGER NOT NULL ," + // 15: traceLevel
                "\"IS_SELCECTED\" INTEGER NOT NULL );"); // 16: isSelcected
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"N2NSettingList\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, N2NSettingModel entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(2, name);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(3, ip);
        }
 
        String netmask = entity.getNetmask();
        if (netmask != null) {
            stmt.bindString(4, netmask);
        }
 
        String community = entity.getCommunity();
        if (community != null) {
            stmt.bindString(5, community);
        }
 
        String password = entity.getPassword();
        if (password != null) {
            stmt.bindString(6, password);
        }
 
        String superNode = entity.getSuperNode();
        if (superNode != null) {
            stmt.bindString(7, superNode);
        }
        stmt.bindLong(8, entity.getMoreSettings() ? 1L: 0L);
 
        String superNodeBackup = entity.getSuperNodeBackup();
        if (superNodeBackup != null) {
            stmt.bindString(9, superNodeBackup);
        }
 
        String macAddr = entity.getMacAddr();
        if (macAddr != null) {
            stmt.bindString(10, macAddr);
        }
        stmt.bindLong(11, entity.getMtu());
        stmt.bindLong(12, entity.getResoveSupernodeIP() ? 1L: 0L);
        stmt.bindLong(13, entity.getLocalPort());
        stmt.bindLong(14, entity.getAllowRouting() ? 1L: 0L);
        stmt.bindLong(15, entity.getDropMuticast() ? 1L: 0L);
        stmt.bindLong(16, entity.getTraceLevel());
        stmt.bindLong(17, entity.getIsSelcected() ? 1L: 0L);
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, N2NSettingModel entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(2, name);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(3, ip);
        }
 
        String netmask = entity.getNetmask();
        if (netmask != null) {
            stmt.bindString(4, netmask);
        }
 
        String community = entity.getCommunity();
        if (community != null) {
            stmt.bindString(5, community);
        }
 
        String password = entity.getPassword();
        if (password != null) {
            stmt.bindString(6, password);
        }
 
        String superNode = entity.getSuperNode();
        if (superNode != null) {
            stmt.bindString(7, superNode);
        }
        stmt.bindLong(8, entity.getMoreSettings() ? 1L: 0L);
 
        String superNodeBackup = entity.getSuperNodeBackup();
        if (superNodeBackup != null) {
            stmt.bindString(9, superNodeBackup);
        }
 
        String macAddr = entity.getMacAddr();
        if (macAddr != null) {
            stmt.bindString(10, macAddr);
        }
        stmt.bindLong(11, entity.getMtu());
        stmt.bindLong(12, entity.getResoveSupernodeIP() ? 1L: 0L);
        stmt.bindLong(13, entity.getLocalPort());
        stmt.bindLong(14, entity.getAllowRouting() ? 1L: 0L);
        stmt.bindLong(15, entity.getDropMuticast() ? 1L: 0L);
        stmt.bindLong(16, entity.getTraceLevel());
        stmt.bindLong(17, entity.getIsSelcected() ? 1L: 0L);
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public N2NSettingModel readEntity(Cursor cursor, int offset) {
        N2NSettingModel entity = new N2NSettingModel( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // name
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // ip
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // netmask
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // community
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // password
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // superNode
            cursor.getShort(offset + 7) != 0, // moreSettings
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // superNodeBackup
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // macAddr
            cursor.getInt(offset + 10), // mtu
            cursor.getShort(offset + 11) != 0, // resoveSupernodeIP
            cursor.getInt(offset + 12), // localPort
            cursor.getShort(offset + 13) != 0, // allowRouting
            cursor.getShort(offset + 14) != 0, // dropMuticast
            cursor.getInt(offset + 15), // traceLevel
            cursor.getShort(offset + 16) != 0 // isSelcected
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, N2NSettingModel entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setName(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setIp(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setNetmask(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setCommunity(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setPassword(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setSuperNode(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setMoreSettings(cursor.getShort(offset + 7) != 0);
        entity.setSuperNodeBackup(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setMacAddr(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setMtu(cursor.getInt(offset + 10));
        entity.setResoveSupernodeIP(cursor.getShort(offset + 11) != 0);
        entity.setLocalPort(cursor.getInt(offset + 12));
        entity.setAllowRouting(cursor.getShort(offset + 13) != 0);
        entity.setDropMuticast(cursor.getShort(offset + 14) != 0);
        entity.setTraceLevel(cursor.getInt(offset + 15));
        entity.setIsSelcected(cursor.getShort(offset + 16) != 0);
     }
    
    @Override
    protected final Long updateKeyAfterInsert(N2NSettingModel entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(N2NSettingModel entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(N2NSettingModel entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
